/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DnsNameState {
    PENDING_VERIFICATION("pendingVerification"),
    VERIFIED("verified"),
    FAILED("failed"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DnsNameState> VALUE_MAP;
    private final String value;

    private DnsNameState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DnsNameState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DnsNameState> knownValues() {
        EnumSet<DnsNameState> knownValues = EnumSet.allOf(DnsNameState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DnsNameState.class, DnsNameState::toString);
    }
}

