/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ingest;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opensearch.script.Script;
import org.opensearch.script.ScriptService;
import org.opensearch.script.ScriptType;
import org.opensearch.script.TemplateScript;

public interface ValueSource {
    public Object copyAndResolve(Map<String, Object> var1);

    public static ValueSource wrap(Object value, ScriptService scriptService) {
        Object object = value;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Map.class, List.class, byte[].class, String.class, Number.class, Boolean.class}, (Object)object, n)) {
            case 0 -> {
                Map mapValue;
                Map castedMap = mapValue = (Map)object;
                HashMap<ValueSource, ValueSource> valueTypeMap = new HashMap<ValueSource, ValueSource>(castedMap.size());
                for (Map.Entry entry : castedMap.entrySet()) {
                    valueTypeMap.put(ValueSource.wrap(entry.getKey(), scriptService), ValueSource.wrap(entry.getValue(), scriptService));
                }
                yield new MapValue(valueTypeMap);
            }
            case 1 -> {
                List listValue;
                List castedList = listValue = (List)object;
                ArrayList<ValueSource> valueSourceList = new ArrayList<ValueSource>(castedList.size());
                for (Object item : castedList) {
                    valueSourceList.add(ValueSource.wrap(item, scriptService));
                }
                yield new ListValue(valueSourceList);
            }
            case 2 -> {
                byte[] byteArray = (byte[])object;
                yield new ByteValue(byteArray);
            }
            case 3 -> {
                String stringValue = (String)object;
                if (scriptService.isLangSupported("mustache") && stringValue.contains("{{")) {
                    Script script = new Script(ScriptType.INLINE, "mustache", stringValue, Collections.emptyMap());
                    yield new TemplatedValue(scriptService.compile(script, TemplateScript.CONTEXT));
                }
                yield new ObjectValue(stringValue);
            }
            case -1 -> new ObjectValue(null);
            case 4 -> {
                Number number = (Number)object;
                yield new ObjectValue(number);
            }
            case 5 -> {
                Boolean bool = (Boolean)object;
                yield new ObjectValue(bool);
            }
            default -> throw new IllegalArgumentException("unexpected value type [" + String.valueOf(value.getClass()) + "]");
        };
    }

    public static final class MapValue
    implements ValueSource {
        private final Map<ValueSource, ValueSource> map;

        MapValue(Map<ValueSource, ValueSource> map) {
            this.map = map;
        }

        @Override
        public Object copyAndResolve(Map<String, Object> model) {
            HashMap<Object, Object> copy = new HashMap<Object, Object>();
            for (Map.Entry<ValueSource, ValueSource> entry : this.map.entrySet()) {
                copy.put(entry.getKey().copyAndResolve(model), entry.getValue().copyAndResolve(model));
            }
            return copy;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MapValue mapValue = (MapValue)o;
            return this.map.equals(mapValue.map);
        }

        public int hashCode() {
            return this.map.hashCode();
        }
    }

    public static final class ListValue
    implements ValueSource {
        private final List<ValueSource> values;

        ListValue(List<ValueSource> values) {
            this.values = values;
        }

        @Override
        public Object copyAndResolve(Map<String, Object> model) {
            ArrayList<Object> copy = new ArrayList<Object>(this.values.size());
            for (ValueSource value : this.values) {
                copy.add(value.copyAndResolve(model));
            }
            return copy;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ListValue listValue = (ListValue)o;
            return this.values.equals(listValue.values);
        }

        public int hashCode() {
            return this.values.hashCode();
        }
    }

    public static final class ByteValue
    implements ValueSource {
        private final byte[] value;

        ByteValue(byte[] value) {
            this.value = value;
        }

        @Override
        public Object copyAndResolve(Map<String, Object> model) {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ByteValue objectValue = (ByteValue)o;
            return Arrays.equals(this.value, objectValue.value);
        }

        public int hashCode() {
            return Arrays.hashCode(this.value);
        }
    }

    public static final class TemplatedValue
    implements ValueSource {
        private final TemplateScript.Factory template;

        TemplatedValue(TemplateScript.Factory template) {
            this.template = template;
        }

        @Override
        public Object copyAndResolve(Map<String, Object> model) {
            return this.template.newInstance(model).execute();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TemplatedValue templatedValue = (TemplatedValue)o;
            return Objects.equals(this.template, templatedValue.template);
        }

        public int hashCode() {
            return Objects.hashCode(this.template);
        }
    }

    public static final class ObjectValue
    implements ValueSource {
        private final Object value;

        ObjectValue(Object value) {
            this.value = value;
        }

        @Override
        public Object copyAndResolve(Map<String, Object> model) {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ObjectValue objectValue = (ObjectValue)o;
            return Objects.equals(this.value, objectValue.value);
        }

        public int hashCode() {
            return Objects.hashCode(this.value);
        }
    }
}

