/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Given an intensity image and a label map, compute min, max, variance
and mean of the pixels associated with each label or segment.


LabelStatisticsImageFilter computes the minimum, maximum, sum, mean, median, variance and sigma
of regions of an intensity image, where the regions are defined via a
label map (a second input). The label image should be integral type.
The filter needs all of its input image. It behaves as a filter with
an input and output. Thus it can be inserted in a pipeline with other
filters and the statistics will only be recomputed if a downstream
filter changes.

Optionally, the filter also computes intensity histograms on each
object. If histograms are enabled, a median intensity value can also
be computed, although its accuracy is limited to the bin width of the
histogram. If histograms are not enabled, the median returns zero.

This filter is automatically multi-threaded and can stream its input
when NumberOfStreamDivisions is set to more than
Statistics are independently computed for each streamed and threaded region then
merged.

See:
 itk::LabelStatisticsImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkLabelStatisticsImageFilter.h
*/
public class LabelStatisticsImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected LabelStatisticsImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.LabelStatisticsImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(LabelStatisticsImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(LabelStatisticsImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::LabelStatisticsImageFilter::~LabelStatisticsImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_LabelStatisticsImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::LabelStatisticsImageFilter::LabelStatisticsImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  LabelStatisticsImageFilter() {
    this(SimpleITKJNI.new_LabelStatisticsImageFilter(), true);
  }

  /**
Self&amp; itk::simple::LabelStatisticsImageFilter::SetUseHistograms(bool UseHistograms)
*/
public  void setUseHistograms(boolean UseHistograms) {
    SimpleITKJNI.LabelStatisticsImageFilter_setUseHistograms(swigCPtr, this, UseHistograms);
  }

  /**
Self&amp; itk::simple::LabelStatisticsImageFilter::UseHistogramsOn()

Set the value of UseHistograms to true or false respectfully.

*/
public  void useHistogramsOn() {
    SimpleITKJNI.LabelStatisticsImageFilter_useHistogramsOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::LabelStatisticsImageFilter::UseHistogramsOff()
*/
public  void useHistogramsOff() {
    SimpleITKJNI.LabelStatisticsImageFilter_useHistogramsOff(swigCPtr, this);
  }

  /**
bool itk::simple::LabelStatisticsImageFilter::GetUseHistograms() const
*/
public  boolean getUseHistograms() {
    return SimpleITKJNI.LabelStatisticsImageFilter_getUseHistograms(swigCPtr, this);
  }

  /**
double itk::simple::LabelStatisticsImageFilter::GetMinimum(int64_t label) const

Return the computed Minimum for a label.

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  double getMinimum(long label) {
    return SimpleITKJNI.LabelStatisticsImageFilter_getMinimum(swigCPtr, this, label);
  }

  /**
double itk::simple::LabelStatisticsImageFilter::GetMaximum(int64_t label) const

Return the computed Maximum for a label.

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  double getMaximum(long label) {
    return SimpleITKJNI.LabelStatisticsImageFilter_getMaximum(swigCPtr, this, label);
  }

  /**
double itk::simple::LabelStatisticsImageFilter::GetMean(int64_t label) const

Return the computed Mean for a label.

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  double getMean(long label) {
    return SimpleITKJNI.LabelStatisticsImageFilter_getMean(swigCPtr, this, label);
  }

  /**
double itk::simple::LabelStatisticsImageFilter::GetMedian(int64_t label) const

Return the computed Median for a label. Requires histograms to be
enabled!

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  double getMedian(long label) {
    return SimpleITKJNI.LabelStatisticsImageFilter_getMedian(swigCPtr, this, label);
  }

  /**
double itk::simple::LabelStatisticsImageFilter::GetSigma(int64_t label) const

Return the computed Standard Deviation for a label.

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  double getSigma(long label) {
    return SimpleITKJNI.LabelStatisticsImageFilter_getSigma(swigCPtr, this, label);
  }

  /**
double itk::simple::LabelStatisticsImageFilter::GetVariance(int64_t label) const

Return the computed Variance for a label.

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  double getVariance(long label) {
    return SimpleITKJNI.LabelStatisticsImageFilter_getVariance(swigCPtr, this, label);
  }

  /**
double itk::simple::LabelStatisticsImageFilter::GetSum(int64_t label) const

Return the compute Sum for a label.

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  double getSum(long label) {
    return SimpleITKJNI.LabelStatisticsImageFilter_getSum(swigCPtr, this, label);
  }

  /**
uint64_t itk::simple::LabelStatisticsImageFilter::GetCount(int64_t label) const

Return the number of pixels for a label.

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  java.math.BigInteger getCount(long label) {
    return SimpleITKJNI.LabelStatisticsImageFilter_getCount(swigCPtr, this, label);
  }

  /**
std::vector&lt;int&gt; itk::simple::LabelStatisticsImageFilter::GetBoundingBox(int64_t label) const

Return the computed bounding box for a label. A vector of minIndex,
maxIndex pairs for each axis. The intervals include the endpoints.

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  VectorInt32 getBoundingBox(long label) {
    return new VectorInt32(SimpleITKJNI.LabelStatisticsImageFilter_getBoundingBox(swigCPtr, this, label), true);
  }

  /**
std::vector&lt;unsigned int&gt; itk::simple::LabelStatisticsImageFilter::GetRegion(int64_t label) const

Return the computed region.

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  VectorUInt32 getRegion(long label) {
    return new VectorUInt32(SimpleITKJNI.LabelStatisticsImageFilter_getRegion(swigCPtr, this, label), true);
  }

  /**
std::vector&lt;int64_t&gt; itk::simple::LabelStatisticsImageFilter::GetLabels() const

This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public  VectorInt64 getLabels() {
    return new VectorInt64(SimpleITKJNI.LabelStatisticsImageFilter_getLabels(swigCPtr, this), true);
  }

  /**
std::string itk::simple::LabelStatisticsImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.LabelStatisticsImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::LabelStatisticsImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.LabelStatisticsImageFilter_toString(swigCPtr, this);
  }

  /**
void itk::simple::LabelStatisticsImageFilter::Execute(const Image &amp;image, const Image &amp;labelImage)

Execute the filter on the input image

*/
public  void execute(Image image, Image labelImage) {
    SimpleITKJNI.LabelStatisticsImageFilter_execute(swigCPtr, this, Image.getCPtr(image), image, Image.getCPtr(labelImage), labelImage);
  }

  /**
bool itk::simple::LabelStatisticsImageFilter::HasLabel(int64_t label)

Does the specified label exist? Can only be called after a call a call
to Update().

*/
public  boolean hasLabel(long label) {
    return SimpleITKJNI.LabelStatisticsImageFilter_hasLabel(swigCPtr, this, label);
  }

  /**
uint64_t itk::simple::LabelStatisticsImageFilter::GetNumberOfLabels()

Return the number of labels after execution .

*/
public  java.math.BigInteger getNumberOfLabels() {
    return SimpleITKJNI.LabelStatisticsImageFilter_getNumberOfLabels(swigCPtr, this);
  }

}
