/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.rm;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.rm.RMEvent;
import org.jkiss.dbeaver.model.rm.RMEventListener;

public class RMEventManager {
    private static final Log log = Log.getLog(RMEventManager.class);
    private static final List<RMEventListener> listeners = new CopyOnWriteArrayList<RMEventListener>();

    public static synchronized void addEventListener(RMEventListener listener) {
        listeners.add(listener);
    }

    public static synchronized void removeEventListener(RMEventListener listener) {
        listeners.remove(listener);
    }

    public static void fireEvent(RMEvent event) {
        for (RMEventListener listener : listeners) {
            try {
                listener.handleRMEvent(event);
            }
            catch (Exception e) {
                log.error(e.getMessage(), e);
            }
        }
    }
}

