# This file has been autogenerated by the pywayland scanner

# Copyright © 2020 - 2023 Andri Yngvason
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from __future__ import annotations

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)

from .ext_transient_seat_v1 import ExtTransientSeatV1


class ExtTransientSeatManagerV1(Interface):
    """Transient seat manager

    The transient seat manager creates short-lived seats.
    """

    name = "ext_transient_seat_manager_v1"
    version = 1


class ExtTransientSeatManagerV1Proxy(Proxy[ExtTransientSeatManagerV1]):
    interface = ExtTransientSeatManagerV1

    @ExtTransientSeatManagerV1.request(
        Argument(ArgumentType.NewId, interface=ExtTransientSeatV1),
    )
    def create(self) -> Proxy[ExtTransientSeatV1]:
        """Create a transient seat

        Create a new seat that is removed when the client side transient seat
        object is destroyed.

        The actual seat may be removed sooner, in which case the transient seat
        object shall become inert.

        :returns:
            :class:`~pywayland.protocol.ext_transient_seat_v1.ExtTransientSeatV1`
        """
        seat = self._marshal_constructor(0, ExtTransientSeatV1)
        return seat

    @ExtTransientSeatManagerV1.request()
    def destroy(self) -> None:
        """Destroy the manager

        Destroy the manager.

        All objects created by the manager will remain valid until they are
        destroyed themselves.
        """
        self._marshal(1)
        self._destroy()


class ExtTransientSeatManagerV1Resource(Resource):
    interface = ExtTransientSeatManagerV1


class ExtTransientSeatManagerV1Global(Global):
    interface = ExtTransientSeatManagerV1


ExtTransientSeatManagerV1._gen_c()
ExtTransientSeatManagerV1.proxy_class = ExtTransientSeatManagerV1Proxy
ExtTransientSeatManagerV1.resource_class = ExtTransientSeatManagerV1Resource
ExtTransientSeatManagerV1.global_class = ExtTransientSeatManagerV1Global
