/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.cat;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opensearch.common.Booleans;
import org.opensearch.common.Table;
import org.opensearch.common.io.Streams;
import org.opensearch.common.io.UTF8StreamWriter;
import org.opensearch.common.regex.Regex;
import org.opensearch.common.unit.SizeValue;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.BytesStream;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;

public class RestTable {
    public static RestResponse buildResponse(Table table, RestChannel channel) throws Exception {
        RestRequest request = channel.request();
        MediaType mediaType = RestTable.getXContentType(request);
        if (mediaType != null) {
            return RestTable.buildXContentBuilder(table, channel);
        }
        return RestTable.buildTextPlainResponse(table, channel);
    }

    private static MediaType getXContentType(RestRequest request) {
        if (request.hasParam("format")) {
            return MediaType.fromFormat((String)request.param("format"));
        }
        return MediaType.fromMediaType((String)request.header("Accept"));
    }

    public static RestResponse buildXContentBuilder(Table table, RestChannel channel) throws Exception {
        RestRequest request = channel.request();
        XContentBuilder builder = channel.newBuilder();
        List<DisplayHeader> displayHeaders = RestTable.buildDisplayHeaders(table, request);
        if (Objects.nonNull(table.getPageToken())) {
            RestTable.buildPaginatedXContentBuilder(table, request, builder, displayHeaders);
        } else {
            builder.startArray();
            RestTable.addRowsToXContentBuilder(table, request, builder, displayHeaders);
            builder.endArray();
        }
        return new BytesRestResponse(RestStatus.OK, builder);
    }

    private static void buildPaginatedXContentBuilder(Table table, RestRequest request, XContentBuilder builder, List<DisplayHeader> displayHeaders) throws Exception {
        assert (Objects.nonNull(table.getPageToken().getPaginatedEntity())) : "Paginated element is required in-case of paginated responses";
        builder.startObject();
        builder.field("next_token", table.getPageToken().getNextToken());
        builder.startArray(table.getPageToken().getPaginatedEntity());
        RestTable.addRowsToXContentBuilder(table, request, builder, displayHeaders);
        builder.endArray();
        builder.endObject();
    }

    private static void addRowsToXContentBuilder(Table table, RestRequest request, XContentBuilder builder, List<DisplayHeader> displayHeaders) throws Exception {
        List<Integer> rowOrder = RestTable.getRowOrder(table, request);
        for (Integer row : rowOrder) {
            builder.startObject();
            for (DisplayHeader header : displayHeaders) {
                builder.field(header.display, RestTable.renderValue(request, table.getAsMap().get((Object)header.name).get((int)row.intValue()).value));
            }
            builder.endObject();
        }
    }

    public static RestResponse buildTextPlainResponse(Table table, RestChannel channel) throws IOException {
        RestRequest request = channel.request();
        boolean verbose = request.paramAsBoolean("v", false);
        List<DisplayHeader> headers = RestTable.buildDisplayHeaders(table, request);
        int[] width = RestTable.buildWidths(table, request, verbose, headers);
        BytesStream bytesOut = Streams.flushOnCloseStream(channel.bytesOutput());
        UTF8StreamWriter out = new UTF8StreamWriter().setOutput((OutputStream)bytesOut);
        int lastHeader = headers.size() - 1;
        if (verbose) {
            for (int col = 0; col < headers.size(); ++col) {
                DisplayHeader header = headers.get(col);
                boolean isLastColumn = col == lastHeader;
                RestTable.pad(new Table.Cell((Object)header.display, table.findHeaderByName(header.name)), width[col], request, out, isLastColumn);
                if (isLastColumn) continue;
                out.append(" ");
            }
            out.append("\n");
        }
        List<Integer> rowOrder = RestTable.getRowOrder(table, request);
        for (Integer row : rowOrder) {
            for (int col = 0; col < headers.size(); ++col) {
                DisplayHeader header = headers.get(col);
                boolean isLastColumn = col == lastHeader;
                RestTable.pad(table.getAsMap().get(header.name).get(row), width[col], request, out, isLastColumn);
                if (isLastColumn) continue;
                out.append(" ");
            }
            out.append("\n");
        }
        if (Objects.nonNull(table.getPageToken())) {
            out.append("next_token " + table.getPageToken().getNextToken());
            out.append("\n");
        }
        out.close();
        return new BytesRestResponse(RestStatus.OK, "text/plain; charset=UTF-8", bytesOut.bytes());
    }

    static List<Integer> getRowOrder(Table table, RestRequest request) {
        String[] columnOrdering = request.paramAsStringArray("s", null);
        ArrayList<Integer> rowOrder = new ArrayList<Integer>();
        for (int i = 0; i < table.getRows().size(); ++i) {
            rowOrder.add(i);
        }
        if (columnOrdering != null) {
            Map<String, String> headerAliasMap = table.getAliasMap();
            ArrayList<ColumnOrderElement> ordering = new ArrayList<ColumnOrderElement>();
            for (int i = 0; i < columnOrdering.length; ++i) {
                String columnHeader = columnOrdering[i];
                boolean reverse = false;
                if (columnHeader.endsWith(":desc")) {
                    columnHeader = columnHeader.substring(0, columnHeader.length() - ":desc".length());
                    reverse = true;
                } else if (columnHeader.endsWith(":asc")) {
                    columnHeader = columnHeader.substring(0, columnHeader.length() - ":asc".length());
                }
                if (!headerAliasMap.containsKey(columnHeader)) {
                    throw new UnsupportedOperationException(String.format(Locale.ROOT, "Unable to sort by unknown sort key `%s`", columnHeader));
                }
                ordering.add(new ColumnOrderElement(headerAliasMap.get(columnHeader), reverse));
            }
            Collections.sort(rowOrder, new TableIndexComparator(table, ordering));
        }
        return rowOrder;
    }

    static List<DisplayHeader> buildDisplayHeaders(Table table, RestRequest request) {
        ArrayList<DisplayHeader> display = new ArrayList<DisplayHeader>();
        if (request.hasParam("h")) {
            Set<String> headers = RestTable.expandHeadersFromRequest(table, request);
            for (String possibility : headers) {
                DisplayHeader dispHeader = null;
                if (table.getAsMap().containsKey(possibility)) {
                    dispHeader = new DisplayHeader(possibility, possibility);
                } else {
                    block1: for (Table.Cell headerCell : table.getHeaders()) {
                        String aliases = headerCell.attr.get("alias");
                        if (aliases == null) continue;
                        for (String alias : Strings.splitStringByCommaToArray((String)aliases)) {
                            if (!possibility.equals(alias)) continue;
                            dispHeader = new DisplayHeader(headerCell.value.toString(), alias);
                            continue block1;
                        }
                    }
                }
                if (dispHeader == null || !RestTable.checkOutputTimestamp(dispHeader, request)) continue;
                display.add(dispHeader);
                Table.Cell hcell = table.getHeaderMap().get(dispHeader.name);
                String siblingFlag = hcell.attr.get("sibling");
                if (siblingFlag == null) continue;
                String sibling = siblingFlag + "." + dispHeader.name;
                Table.Cell c = table.getHeaderMap().get(sibling);
                if (c == null || !request.paramAsBoolean(siblingFlag, false)) continue;
                display.add(new DisplayHeader(c.value.toString(), siblingFlag + "." + dispHeader.display));
            }
        } else {
            for (Table.Cell cell : table.getHeaders()) {
                String d = cell.attr.get("default");
                if (!Booleans.parseBoolean((String)d, (boolean)true) || !RestTable.checkOutputTimestamp(cell.value.toString(), request)) continue;
                display.add(new DisplayHeader(cell.value.toString(), cell.value.toString()));
            }
        }
        return display;
    }

    static boolean checkOutputTimestamp(DisplayHeader dispHeader, RestRequest request) {
        return RestTable.checkOutputTimestamp(dispHeader.name, request);
    }

    static boolean checkOutputTimestamp(String disp, RestRequest request) {
        if ("timestamp".equals(disp) || "epoch".equals(disp)) {
            return request.paramAsBoolean("ts", true);
        }
        return true;
    }

    private static Set<String> expandHeadersFromRequest(Table table, RestRequest request) {
        LinkedHashSet<String> headers = new LinkedHashSet<String>(table.getHeaders().size());
        for (String header : Strings.splitStringByCommaToArray((String)request.param("h"))) {
            if (Regex.isSimpleMatchPattern(header)) {
                block1: for (Table.Cell tableHeaderCell : table.getHeaders()) {
                    String[] aliases;
                    String configuredHeader = tableHeaderCell.value.toString();
                    if (Regex.simpleMatch(header, configuredHeader)) {
                        headers.add(configuredHeader);
                        continue;
                    }
                    if (!tableHeaderCell.attr.containsKey("alias")) continue;
                    for (String alias : aliases = Strings.splitStringByCommaToArray((String)tableHeaderCell.attr.get("alias"))) {
                        if (!Regex.simpleMatch(header, alias)) continue;
                        headers.add(configuredHeader);
                        continue block1;
                    }
                }
                continue;
            }
            headers.add(header);
        }
        return headers;
    }

    public static int[] buildHelpWidths(Table table, RestRequest request) {
        int[] width = new int[3];
        for (Table.Cell cell : table.getHeaders()) {
            int vWidth;
            String v = RestTable.renderValue(request, cell.value);
            int n = vWidth = v == null ? 0 : v.length();
            if (width[0] < vWidth) {
                width[0] = vWidth;
            }
            v = RestTable.renderValue(request, cell.attr.containsKey("alias") ? cell.attr.get("alias") : "");
            int n2 = vWidth = v == null ? 0 : v.length();
            if (width[1] < vWidth) {
                width[1] = vWidth;
            }
            if (width[2] >= (vWidth = (v = RestTable.renderValue(request, cell.attr.containsKey("desc") ? cell.attr.get("desc") : "not available")) == null ? 0 : v.length())) continue;
            width[2] = vWidth;
        }
        return width;
    }

    private static int[] buildWidths(Table table, RestRequest request, boolean verbose, List<DisplayHeader> headers) {
        int i;
        int[] width = new int[headers.size()];
        if (verbose) {
            i = 0;
            for (DisplayHeader hdr : headers) {
                int vWidth = hdr.display.length();
                if (width[i] < vWidth) {
                    width[i] = vWidth;
                }
                ++i;
            }
        }
        i = 0;
        for (DisplayHeader hdr : headers) {
            for (Table.Cell cell : table.getAsMap().get(hdr.name)) {
                String v = RestTable.renderValue(request, cell.value);
                int vWidth = v == null ? 0 : v.length();
                if (width[i] >= vWidth) continue;
                width[i] = vWidth;
            }
            ++i;
        }
        return width;
    }

    public static void pad(Table.Cell cell, int width, RestRequest request, UTF8StreamWriter out) throws IOException {
        RestTable.pad(cell, width, request, out, false);
    }

    public static void pad(Table.Cell cell, int width, RestRequest request, UTF8StreamWriter out, boolean isLast) throws IOException {
        String sValue = RestTable.renderValue(request, cell.value);
        int length = sValue == null ? 0 : sValue.length();
        byte leftOver = (byte)(width - length);
        String textAlign = cell.attr.get("text-align");
        if (textAlign == null) {
            textAlign = "left";
        }
        if (leftOver > 0 && textAlign.equals("right")) {
            for (byte i = 0; i < leftOver; i = (byte)(i + 1)) {
                out.append(" ");
            }
            if (sValue != null) {
                out.append(sValue);
            }
        } else {
            if (sValue != null) {
                out.append(sValue);
            }
            if (!isLast) {
                for (byte i = 0; i < leftOver; i = (byte)(i + 1)) {
                    out.append(" ");
                }
            }
        }
    }

    private static String renderValue(RestRequest request, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof ByteSizeValue) {
            ByteSizeValue v = (ByteSizeValue)value;
            String resolution = request.param("bytes");
            if ("b".equals(resolution)) {
                return Long.toString(v.getBytes());
            }
            if ("k".equals(resolution) || "kb".equals(resolution)) {
                return Long.toString(v.getKb());
            }
            if ("m".equals(resolution) || "mb".equals(resolution)) {
                return Long.toString(v.getMb());
            }
            if ("g".equals(resolution) || "gb".equals(resolution)) {
                return Long.toString(v.getGb());
            }
            if ("t".equals(resolution) || "tb".equals(resolution)) {
                return Long.toString(v.getTb());
            }
            if ("p".equals(resolution) || "pb".equals(resolution)) {
                return Long.toString(v.getPb());
            }
            return v.toString();
        }
        if (value instanceof SizeValue) {
            SizeValue v = (SizeValue)value;
            String resolution = request.param("size");
            if ("".equals(resolution)) {
                return Long.toString(v.singles());
            }
            if ("k".equals(resolution)) {
                return Long.toString(v.kilo());
            }
            if ("m".equals(resolution)) {
                return Long.toString(v.mega());
            }
            if ("g".equals(resolution)) {
                return Long.toString(v.giga());
            }
            if ("t".equals(resolution)) {
                return Long.toString(v.tera());
            }
            if ("p".equals(resolution)) {
                return Long.toString(v.peta());
            }
            return v.toString();
        }
        if (value instanceof TimeValue) {
            TimeValue v = (TimeValue)value;
            String resolution = request.param("time");
            if ("nanos".equals(resolution)) {
                return Long.toString(v.nanos());
            }
            if ("micros".equals(resolution)) {
                return Long.toString(v.micros());
            }
            if ("ms".equals(resolution)) {
                return Long.toString(v.millis());
            }
            if ("s".equals(resolution)) {
                return Long.toString(v.seconds());
            }
            if ("m".equals(resolution)) {
                return Long.toString(v.minutes());
            }
            if ("h".equals(resolution)) {
                return Long.toString(v.hours());
            }
            if ("d".equals(resolution)) {
                return Long.toString(v.days());
            }
            return v.toString();
        }
        return value.toString();
    }

    static class DisplayHeader {
        public final String name;
        public final String display;

        DisplayHeader(String name, String display) {
            this.name = name;
            this.display = display;
        }
    }

    static class ColumnOrderElement {
        private final String column;
        private final boolean reverse;

        ColumnOrderElement(String column, boolean reverse) {
            this.column = column;
            this.reverse = reverse;
        }

        public String getColumn() {
            return this.column;
        }

        public boolean isReversed() {
            return this.reverse;
        }
    }

    static class TableIndexComparator
    implements Comparator<Integer> {
        private final Table table;
        private final int maxIndex;
        private final List<ColumnOrderElement> ordering;

        TableIndexComparator(Table table, List<ColumnOrderElement> ordering) {
            this.table = table;
            this.maxIndex = table.getRows().size();
            this.ordering = ordering;
        }

        private int compareCell(Object o1, Object o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            if (o1 instanceof Comparable && o1.getClass().equals(o2.getClass())) {
                return ((Comparable)o1).compareTo(o2);
            }
            return o1.toString().compareTo(o2.toString());
        }

        @Override
        public int compare(Integer rowIndex1, Integer rowIndex2) {
            if (rowIndex1 < this.maxIndex && rowIndex1 >= 0 && rowIndex2 < this.maxIndex && rowIndex2 >= 0) {
                Map<String, List<Table.Cell>> tableMap = this.table.getAsMap();
                for (ColumnOrderElement orderingElement : this.ordering) {
                    int comparison;
                    String column = orderingElement.getColumn();
                    if (!tableMap.containsKey(column) || (comparison = this.compareCell(tableMap.get((Object)column).get((int)rowIndex1.intValue()).value, tableMap.get((Object)column).get((int)rowIndex2.intValue()).value)) == 0) continue;
                    return orderingElement.isReversed() ? -1 * comparison : comparison;
                }
                return 0;
            }
            throw new AssertionError((Object)String.format(Locale.ENGLISH, "Invalid comparison of indices (%s, %s): Table has %s rows.", rowIndex1, rowIndex2, this.table.getRows().size()));
        }
    }
}

