/*
 * Decompiled with CFR 0.152.
 */
package org.cugos.wkg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.cugos.wkg.CircularString;
import org.cugos.wkg.Coordinate;
import org.cugos.wkg.Curve;
import org.cugos.wkg.Dimension;
import org.cugos.wkg.Surface;

public class CurvePolygon
extends Surface {
    private final Curve outerCurve;
    private final List<Curve> innerCurves;

    public CurvePolygon(Curve outerCurve, List<Curve> innerCurves, Dimension dimension, String srid) {
        super(dimension, srid);
        this.outerCurve = outerCurve;
        this.innerCurves = Collections.unmodifiableList(innerCurves);
    }

    public CurvePolygon(Curve outerCurve, List<Curve> innerCurves, Dimension dimension) {
        this(outerCurve, innerCurves, dimension, null);
    }

    public Curve getOuterCurve() {
        return this.outerCurve;
    }

    public List<Curve> getInnerCurves() {
        return this.innerCurves;
    }

    @Override
    public boolean isEmpty() {
        return this.outerCurve == null | this.outerCurve.isEmpty();
    }

    @Override
    public int getNumberOfCoordinates() {
        int numberOfCoordinates = this.outerCurve.getNumberOfCoordinates();
        for (Curve curve : this.innerCurves) {
            numberOfCoordinates += curve.getNumberOfCoordinates();
        }
        return numberOfCoordinates;
    }

    @Override
    public List<Coordinate> getCoordinates() {
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        coordinates.addAll(this.outerCurve.getCoordinates());
        for (Curve curve : this.innerCurves) {
            coordinates.addAll(curve.getCoordinates());
        }
        return Collections.unmodifiableList(coordinates);
    }

    public static CurvePolygon createEmpty() {
        return new CurvePolygon(new CircularString(new ArrayList<Coordinate>(), Dimension.Two, null), new ArrayList<Curve>(), Dimension.Two, null);
    }
}

