"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Span = void 0;
var _node = require("../node");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

class Span extends _node.PPLNode {
  constructor(name, children, spanExpression, customLabel) {
    super(name, children);
    this.spanExpression = spanExpression;
    this.customLabel = customLabel;
  }
  getTokens() {
    return {
      span_expression: this.spanExpression.getTokens(),
      customLabel: this.customLabel
    };
  }
  toString() {
    return `${this.spanExpression.toString()}${this.customLabel ? ` as ${this.customLabel}` : ''}`;
  }
}
exports.Span = Span;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfbm9kZSIsInJlcXVpcmUiLCJTcGFuIiwiUFBMTm9kZSIsImNvbnN0cnVjdG9yIiwibmFtZSIsImNoaWxkcmVuIiwic3BhbkV4cHJlc3Npb24iLCJjdXN0b21MYWJlbCIsImdldFRva2VucyIsInNwYW5fZXhwcmVzc2lvbiIsInRvU3RyaW5nIiwiZXhwb3J0cyJdLCJzb3VyY2VzIjpbInNwYW4udHMiXSwic291cmNlc0NvbnRlbnQiOlsiLypcbiAqIENvcHlyaWdodCBPcGVuU2VhcmNoIENvbnRyaWJ1dG9yc1xuICogU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiAqL1xuXG5pbXBvcnQgeyBQUExOb2RlIH0gZnJvbSAnLi4vbm9kZSc7XG5cbmV4cG9ydCBjbGFzcyBTcGFuIGV4dGVuZHMgUFBMTm9kZSB7XG4gIGNvbnN0cnVjdG9yKFxuICAgIG5hbWU6IHN0cmluZyxcbiAgICBjaGlsZHJlbjogUFBMTm9kZVtdLFxuICAgIHByaXZhdGUgc3BhbkV4cHJlc3Npb246IFBQTE5vZGUsXG4gICAgcHJpdmF0ZSBjdXN0b21MYWJlbDogc3RyaW5nXG4gICkge1xuICAgIHN1cGVyKG5hbWUsIGNoaWxkcmVuKTtcbiAgfVxuXG4gIGdldFRva2VucygpIHtcbiAgICByZXR1cm4ge1xuICAgICAgc3Bhbl9leHByZXNzaW9uOiB0aGlzLnNwYW5FeHByZXNzaW9uLmdldFRva2VucygpLFxuICAgICAgY3VzdG9tTGFiZWw6IHRoaXMuY3VzdG9tTGFiZWwsXG4gICAgfTtcbiAgfVxuXG4gIHRvU3RyaW5nKCk6IHN0cmluZyB7XG4gICAgcmV0dXJuIGAke3RoaXMuc3BhbkV4cHJlc3Npb24udG9TdHJpbmcoKX0ke3RoaXMuY3VzdG9tTGFiZWwgPyBgIGFzICR7dGhpcy5jdXN0b21MYWJlbH1gIDogJyd9YDtcbiAgfVxufVxuIl0sIm1hcHBpbmdzIjoiOzs7Ozs7QUFLQSxJQUFBQSxLQUFBLEdBQUFDLE9BQUE7QUFMQTtBQUNBO0FBQ0E7QUFDQTs7QUFJTyxNQUFNQyxJQUFJLFNBQVNDLGFBQU8sQ0FBQztFQUNoQ0MsV0FBV0EsQ0FDVEMsSUFBWSxFQUNaQyxRQUFtQixFQUNYQyxjQUF1QixFQUN2QkMsV0FBbUIsRUFDM0I7SUFDQSxLQUFLLENBQUNILElBQUksRUFBRUMsUUFBUSxDQUFDO0lBQUMsS0FIZEMsY0FBdUIsR0FBdkJBLGNBQXVCO0lBQUEsS0FDdkJDLFdBQW1CLEdBQW5CQSxXQUFtQjtFQUc3QjtFQUVBQyxTQUFTQSxDQUFBLEVBQUc7SUFDVixPQUFPO01BQ0xDLGVBQWUsRUFBRSxJQUFJLENBQUNILGNBQWMsQ0FBQ0UsU0FBUyxDQUFDLENBQUM7TUFDaERELFdBQVcsRUFBRSxJQUFJLENBQUNBO0lBQ3BCLENBQUM7RUFDSDtFQUVBRyxRQUFRQSxDQUFBLEVBQVc7SUFDakIsT0FBUSxHQUFFLElBQUksQ0FBQ0osY0FBYyxDQUFDSSxRQUFRLENBQUMsQ0FBRSxHQUFFLElBQUksQ0FBQ0gsV0FBVyxHQUFJLE9BQU0sSUFBSSxDQUFDQSxXQUFZLEVBQUMsR0FBRyxFQUFHLEVBQUM7RUFDaEc7QUFDRjtBQUFDSSxPQUFBLENBQUFWLElBQUEsR0FBQUEsSUFBQSJ9