/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.backup;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.backup.JDBCDatabaseBackupDescriptor;

public class JDBCDatabaseBackupRegistry {
    public static final String SQL_BACKUP_EXTENSION_ID = "org.jkiss.dbeaver.sqlBackup";
    private static JDBCDatabaseBackupRegistry instance = null;
    private final List<JDBCDatabaseBackupDescriptor> descriptors = new ArrayList<JDBCDatabaseBackupDescriptor>();

    public static synchronized JDBCDatabaseBackupRegistry getInstance() {
        if (instance == null) {
            instance = new JDBCDatabaseBackupRegistry();
            instance.loadExtensions(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private JDBCDatabaseBackupRegistry() {
    }

    private synchronized void loadExtensions(@NotNull IExtensionRegistry registry) {
        IConfigurationElement[] extConfigs;
        IConfigurationElement[] iConfigurationElementArray = extConfigs = registry.getConfigurationElementsFor(SQL_BACKUP_EXTENSION_ID);
        int n = extConfigs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ext = iConfigurationElementArray[n2];
            if (JDBCDatabaseBackupDescriptor.TAG_BACKUP.equals(ext.getName())) {
                this.parseAttribute(ext);
            }
            ++n2;
        }
    }

    private void parseAttribute(@NotNull IConfigurationElement ext) {
        JDBCDatabaseBackupDescriptor providerDescriptor = new JDBCDatabaseBackupDescriptor(ext);
        this.descriptors.add(providerDescriptor);
    }

    public List<JDBCDatabaseBackupDescriptor> getDescriptors() {
        return new ArrayList<JDBCDatabaseBackupDescriptor>(this.descriptors);
    }

    public JDBCDatabaseBackupDescriptor getCurrentDescriptor(@NotNull SQLDialect sqlDialect) {
        for (JDBCDatabaseBackupDescriptor descriptor : this.getDescriptors()) {
            if (!sqlDialect.getDialectId().equals(descriptor.getDialect())) continue;
            return descriptor;
        }
        return null;
    }
}

