/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSPointerEvent.h"

#include "ActiveDOMObject.h"
#include "Document.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSEventTarget.h"
#include "JSPointerEvent.h"
#include "JSWindowProxy.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<PointerEvent::Init>> convertDictionary<PointerEvent::Init>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    PointerEvent::Init result;
    JSValue bubblesValue;
    if (isNullOrUndefined)
        bubblesValue = jsUndefined();
    else {
        bubblesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bubbles"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto bubblesConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, bubblesValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (UNLIKELY(bubblesConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.bubbles = bubblesConversionResult.releaseReturnValue();
    JSValue cancelableValue;
    if (isNullOrUndefined)
        cancelableValue = jsUndefined();
    else {
        cancelableValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "cancelable"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto cancelableConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, cancelableValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (UNLIKELY(cancelableConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.cancelable = cancelableConversionResult.releaseReturnValue();
    JSValue composedValue;
    if (isNullOrUndefined)
        composedValue = jsUndefined();
    else {
        composedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "composed"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto composedConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, composedValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (UNLIKELY(composedConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.composed = composedConversionResult.releaseReturnValue();
    JSValue detailValue;
    if (isNullOrUndefined)
        detailValue = jsUndefined();
    else {
        detailValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "detail"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto detailConversionResult = convertOptionalWithDefault<IDLLong>(lexicalGlobalObject, detailValue, [&]() -> ConversionResult<IDLLong> { return Converter<IDLLong>::ReturnType { 0 }; });
    if (UNLIKELY(detailConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.detail = detailConversionResult.releaseReturnValue();
    JSValue viewValue;
    if (isNullOrUndefined)
        viewValue = jsUndefined();
    else {
        viewValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "view"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto viewConversionResult = convertOptionalWithDefault<IDLNullable<IDLInterface<WindowProxy>>>(lexicalGlobalObject, viewValue, [&]() -> ConversionResult<IDLNullable<IDLInterface<WindowProxy>>> { return typename Converter<IDLNullable<IDLInterface<WindowProxy>>>::ReturnType { nullptr }; });
    if (UNLIKELY(viewConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.view = viewConversionResult.releaseReturnValue();
    JSValue altKeyValue;
    if (isNullOrUndefined)
        altKeyValue = jsUndefined();
    else {
        altKeyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "altKey"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto altKeyConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, altKeyValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (UNLIKELY(altKeyConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.altKey = altKeyConversionResult.releaseReturnValue();
    JSValue ctrlKeyValue;
    if (isNullOrUndefined)
        ctrlKeyValue = jsUndefined();
    else {
        ctrlKeyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "ctrlKey"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto ctrlKeyConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, ctrlKeyValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (UNLIKELY(ctrlKeyConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.ctrlKey = ctrlKeyConversionResult.releaseReturnValue();
    JSValue metaKeyValue;
    if (isNullOrUndefined)
        metaKeyValue = jsUndefined();
    else {
        metaKeyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "metaKey"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto metaKeyConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, metaKeyValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (UNLIKELY(metaKeyConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.metaKey = metaKeyConversionResult.releaseReturnValue();
    JSValue modifierAltGraphValue;
    if (isNullOrUndefined)
        modifierAltGraphValue = jsUndefined();
    else {
        modifierAltGraphValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "modifierAltGraph"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto modifierAltGraphConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, modifierAltGraphValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (UNLIKELY(modifierAltGraphConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.modifierAltGraph = modifierAltGraphConversionResult.releaseReturnValue();
    JSValue modifierCapsLockValue;
    if (isNullOrUndefined)
        modifierCapsLockValue = jsUndefined();
    else {
        modifierCapsLockValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "modifierCapsLock"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto modifierCapsLockConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, modifierCapsLockValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (UNLIKELY(modifierCapsLockConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.modifierCapsLock = modifierCapsLockConversionResult.releaseReturnValue();
    JSValue shiftKeyValue;
    if (isNullOrUndefined)
        shiftKeyValue = jsUndefined();
    else {
        shiftKeyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "shiftKey"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto shiftKeyConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, shiftKeyValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (UNLIKELY(shiftKeyConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.shiftKey = shiftKeyConversionResult.releaseReturnValue();
    JSValue buttonValue;
    if (isNullOrUndefined)
        buttonValue = jsUndefined();
    else {
        buttonValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "button"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto buttonConversionResult = convertOptionalWithDefault<IDLShort>(lexicalGlobalObject, buttonValue, [&]() -> ConversionResult<IDLShort> { return Converter<IDLShort>::ReturnType { 0 }; });
    if (UNLIKELY(buttonConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.button = buttonConversionResult.releaseReturnValue();
    JSValue buttonsValue;
    if (isNullOrUndefined)
        buttonsValue = jsUndefined();
    else {
        buttonsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "buttons"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto buttonsConversionResult = convertOptionalWithDefault<IDLUnsignedShort>(lexicalGlobalObject, buttonsValue, [&]() -> ConversionResult<IDLUnsignedShort> { return Converter<IDLUnsignedShort>::ReturnType { 0 }; });
    if (UNLIKELY(buttonsConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.buttons = buttonsConversionResult.releaseReturnValue();
    JSValue clientXValue;
    if (isNullOrUndefined)
        clientXValue = jsUndefined();
    else {
        clientXValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "clientX"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto clientXConversionResult = convertOptionalWithDefault<IDLLong>(lexicalGlobalObject, clientXValue, [&]() -> ConversionResult<IDLLong> { return Converter<IDLLong>::ReturnType { 0 }; });
    if (UNLIKELY(clientXConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.clientX = clientXConversionResult.releaseReturnValue();
    JSValue clientYValue;
    if (isNullOrUndefined)
        clientYValue = jsUndefined();
    else {
        clientYValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "clientY"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto clientYConversionResult = convertOptionalWithDefault<IDLLong>(lexicalGlobalObject, clientYValue, [&]() -> ConversionResult<IDLLong> { return Converter<IDLLong>::ReturnType { 0 }; });
    if (UNLIKELY(clientYConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.clientY = clientYConversionResult.releaseReturnValue();
    JSValue movementXValue;
    if (isNullOrUndefined)
        movementXValue = jsUndefined();
    else {
        movementXValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "movementX"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto movementXConversionResult = convertOptionalWithDefault<IDLDouble>(lexicalGlobalObject, movementXValue, [&]() -> ConversionResult<IDLDouble> { return Converter<IDLDouble>::ReturnType { 0 }; });
    if (UNLIKELY(movementXConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.movementX = movementXConversionResult.releaseReturnValue();
    JSValue movementYValue;
    if (isNullOrUndefined)
        movementYValue = jsUndefined();
    else {
        movementYValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "movementY"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto movementYConversionResult = convertOptionalWithDefault<IDLDouble>(lexicalGlobalObject, movementYValue, [&]() -> ConversionResult<IDLDouble> { return Converter<IDLDouble>::ReturnType { 0 }; });
    if (UNLIKELY(movementYConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.movementY = movementYConversionResult.releaseReturnValue();
    JSValue relatedTargetValue;
    if (isNullOrUndefined)
        relatedTargetValue = jsUndefined();
    else {
        relatedTargetValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "relatedTarget"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto relatedTargetConversionResult = convertOptionalWithDefault<IDLNullable<IDLInterface<EventTarget>>>(lexicalGlobalObject, relatedTargetValue, [&]() -> ConversionResult<IDLNullable<IDLInterface<EventTarget>>> { return typename Converter<IDLNullable<IDLInterface<EventTarget>>>::ReturnType { nullptr }; });
    if (UNLIKELY(relatedTargetConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.relatedTarget = relatedTargetConversionResult.releaseReturnValue();
    JSValue screenXValue;
    if (isNullOrUndefined)
        screenXValue = jsUndefined();
    else {
        screenXValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "screenX"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto screenXConversionResult = convertOptionalWithDefault<IDLLong>(lexicalGlobalObject, screenXValue, [&]() -> ConversionResult<IDLLong> { return Converter<IDLLong>::ReturnType { 0 }; });
    if (UNLIKELY(screenXConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.screenX = screenXConversionResult.releaseReturnValue();
    JSValue screenYValue;
    if (isNullOrUndefined)
        screenYValue = jsUndefined();
    else {
        screenYValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "screenY"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto screenYConversionResult = convertOptionalWithDefault<IDLLong>(lexicalGlobalObject, screenYValue, [&]() -> ConversionResult<IDLLong> { return Converter<IDLLong>::ReturnType { 0 }; });
    if (UNLIKELY(screenYConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.screenY = screenYConversionResult.releaseReturnValue();
    if (jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)->scriptExecutionContext()->settingsValues().altitudeAngleEnabled) {
        JSValue altitudeAngleValue;
        if (isNullOrUndefined)
            altitudeAngleValue = jsUndefined();
        else {
            altitudeAngleValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "altitudeAngle"_s));
            RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
        }
        if (!altitudeAngleValue.isUndefined()) {
            auto altitudeAngleConversionResult = convert<IDLDouble>(lexicalGlobalObject, altitudeAngleValue);
            if (UNLIKELY(altitudeAngleConversionResult.hasException(throwScope)))
                return ConversionResultException { };
            result.altitudeAngle = altitudeAngleConversionResult.releaseReturnValue();
        }
    }
    if (jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)->scriptExecutionContext()->settingsValues().azimuthAngleEnabled) {
        JSValue azimuthAngleValue;
        if (isNullOrUndefined)
            azimuthAngleValue = jsUndefined();
        else {
            azimuthAngleValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "azimuthAngle"_s));
            RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
        }
        if (!azimuthAngleValue.isUndefined()) {
            auto azimuthAngleConversionResult = convert<IDLDouble>(lexicalGlobalObject, azimuthAngleValue);
            if (UNLIKELY(azimuthAngleConversionResult.hasException(throwScope)))
                return ConversionResultException { };
            result.azimuthAngle = azimuthAngleConversionResult.releaseReturnValue();
        }
    }
    if (jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)->scriptExecutionContext()->settingsValues().getCoalescedEventsEnabled) {
        JSValue coalescedEventsValue;
        if (isNullOrUndefined)
            coalescedEventsValue = jsUndefined();
        else {
            coalescedEventsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "coalescedEvents"_s));
            RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
        }
        auto coalescedEventsConversionResult = convertOptionalWithDefault<IDLSequence<IDLInterface<PointerEvent>>>(lexicalGlobalObject, coalescedEventsValue, [&]() -> ConversionResult<IDLSequence<IDLInterface<PointerEvent>>> { return Converter<IDLSequence<IDLInterface<PointerEvent>>>::ReturnType { }; });
        if (UNLIKELY(coalescedEventsConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.coalescedEvents = coalescedEventsConversionResult.releaseReturnValue();
    }
    JSValue heightValue;
    if (isNullOrUndefined)
        heightValue = jsUndefined();
    else {
        heightValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "height"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto heightConversionResult = convertOptionalWithDefault<IDLDouble>(lexicalGlobalObject, heightValue, [&]() -> ConversionResult<IDLDouble> { return Converter<IDLDouble>::ReturnType { 1 }; });
    if (UNLIKELY(heightConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.height = heightConversionResult.releaseReturnValue();
    JSValue isPrimaryValue;
    if (isNullOrUndefined)
        isPrimaryValue = jsUndefined();
    else {
        isPrimaryValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "isPrimary"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto isPrimaryConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, isPrimaryValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (UNLIKELY(isPrimaryConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.isPrimary = isPrimaryConversionResult.releaseReturnValue();
    JSValue pointerIdValue;
    if (isNullOrUndefined)
        pointerIdValue = jsUndefined();
    else {
        pointerIdValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "pointerId"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto pointerIdConversionResult = convertOptionalWithDefault<IDLLong>(lexicalGlobalObject, pointerIdValue, [&]() -> ConversionResult<IDLLong> { return Converter<IDLLong>::ReturnType { 0 }; });
    if (UNLIKELY(pointerIdConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.pointerId = pointerIdConversionResult.releaseReturnValue();
    JSValue pointerTypeValue;
    if (isNullOrUndefined)
        pointerTypeValue = jsUndefined();
    else {
        pointerTypeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "pointerType"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto pointerTypeConversionResult = convertOptionalWithDefault<IDLDOMString>(lexicalGlobalObject, pointerTypeValue, [&]() -> ConversionResult<IDLDOMString> { return Converter<IDLDOMString>::ReturnType { emptyString() }; });
    if (UNLIKELY(pointerTypeConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.pointerType = pointerTypeConversionResult.releaseReturnValue();
    if (jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)->scriptExecutionContext()->settingsValues().getPredictedEventsEnabled) {
        JSValue predictedEventsValue;
        if (isNullOrUndefined)
            predictedEventsValue = jsUndefined();
        else {
            predictedEventsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "predictedEvents"_s));
            RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
        }
        auto predictedEventsConversionResult = convertOptionalWithDefault<IDLSequence<IDLInterface<PointerEvent>>>(lexicalGlobalObject, predictedEventsValue, [&]() -> ConversionResult<IDLSequence<IDLInterface<PointerEvent>>> { return Converter<IDLSequence<IDLInterface<PointerEvent>>>::ReturnType { }; });
        if (UNLIKELY(predictedEventsConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.predictedEvents = predictedEventsConversionResult.releaseReturnValue();
    }
    JSValue pressureValue;
    if (isNullOrUndefined)
        pressureValue = jsUndefined();
    else {
        pressureValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "pressure"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto pressureConversionResult = convertOptionalWithDefault<IDLFloat>(lexicalGlobalObject, pressureValue, [&]() -> ConversionResult<IDLFloat> { return Converter<IDLFloat>::ReturnType { 0 }; });
    if (UNLIKELY(pressureConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.pressure = pressureConversionResult.releaseReturnValue();
    JSValue tangentialPressureValue;
    if (isNullOrUndefined)
        tangentialPressureValue = jsUndefined();
    else {
        tangentialPressureValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "tangentialPressure"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto tangentialPressureConversionResult = convertOptionalWithDefault<IDLFloat>(lexicalGlobalObject, tangentialPressureValue, [&]() -> ConversionResult<IDLFloat> { return Converter<IDLFloat>::ReturnType { 0 }; });
    if (UNLIKELY(tangentialPressureConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.tangentialPressure = tangentialPressureConversionResult.releaseReturnValue();
    JSValue tiltXValue;
    if (isNullOrUndefined)
        tiltXValue = jsUndefined();
    else {
        tiltXValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "tiltX"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto tiltXConversionResult = convertOptionalWithDefault<IDLLong>(lexicalGlobalObject, tiltXValue, [&]() -> ConversionResult<IDLLong> { return Converter<IDLLong>::ReturnType { 0 }; });
    if (UNLIKELY(tiltXConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.tiltX = tiltXConversionResult.releaseReturnValue();
    JSValue tiltYValue;
    if (isNullOrUndefined)
        tiltYValue = jsUndefined();
    else {
        tiltYValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "tiltY"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto tiltYConversionResult = convertOptionalWithDefault<IDLLong>(lexicalGlobalObject, tiltYValue, [&]() -> ConversionResult<IDLLong> { return Converter<IDLLong>::ReturnType { 0 }; });
    if (UNLIKELY(tiltYConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.tiltY = tiltYConversionResult.releaseReturnValue();
    JSValue twistValue;
    if (isNullOrUndefined)
        twistValue = jsUndefined();
    else {
        twistValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "twist"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto twistConversionResult = convertOptionalWithDefault<IDLLong>(lexicalGlobalObject, twistValue, [&]() -> ConversionResult<IDLLong> { return Converter<IDLLong>::ReturnType { 0 }; });
    if (UNLIKELY(twistConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.twist = twistConversionResult.releaseReturnValue();
    JSValue widthValue;
    if (isNullOrUndefined)
        widthValue = jsUndefined();
    else {
        widthValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "width"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto widthConversionResult = convertOptionalWithDefault<IDLDouble>(lexicalGlobalObject, widthValue, [&]() -> ConversionResult<IDLDouble> { return Converter<IDLDouble>::ReturnType { 1 }; });
    if (UNLIKELY(widthConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.width = widthConversionResult.releaseReturnValue();
    return result;
}

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsPointerEventPrototypeFunction_getCoalescedEvents);
static JSC_DECLARE_HOST_FUNCTION(jsPointerEventPrototypeFunction_getPredictedEvents);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsPointerEventConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPointerEvent_pointerId);
static JSC_DECLARE_CUSTOM_GETTER(jsPointerEvent_width);
static JSC_DECLARE_CUSTOM_GETTER(jsPointerEvent_height);
static JSC_DECLARE_CUSTOM_GETTER(jsPointerEvent_pressure);
static JSC_DECLARE_CUSTOM_GETTER(jsPointerEvent_tangentialPressure);
static JSC_DECLARE_CUSTOM_GETTER(jsPointerEvent_tiltX);
static JSC_DECLARE_CUSTOM_GETTER(jsPointerEvent_tiltY);
static JSC_DECLARE_CUSTOM_GETTER(jsPointerEvent_twist);
static JSC_DECLARE_CUSTOM_GETTER(jsPointerEvent_altitudeAngle);
static JSC_DECLARE_CUSTOM_GETTER(jsPointerEvent_azimuthAngle);
static JSC_DECLARE_CUSTOM_GETTER(jsPointerEvent_pointerType);
static JSC_DECLARE_CUSTOM_GETTER(jsPointerEvent_isPrimary);

class JSPointerEventPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSPointerEventPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSPointerEventPrototype* ptr = new (NotNull, JSC::allocateCell<JSPointerEventPrototype>(vm)) JSPointerEventPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSPointerEventPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSPointerEventPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSPointerEventPrototype, JSPointerEventPrototype::Base);

using JSPointerEventDOMConstructor = JSDOMConstructor<JSPointerEvent>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSPointerEventDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSPointerEventDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto typeConversionResult = convert<IDLAtomStringAdaptor<IDLDOMString>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(typeConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto eventInitDictConversionResult = convert<IDLDictionary<PointerEvent::Init>>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(eventInitDictConversionResult.hasException(throwScope)))
       return encodedJSValue();
    auto object = PointerEvent::create(typeConversionResult.releaseReturnValue(), eventInitDictConversionResult.releaseReturnValue());
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<PointerEvent>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<PointerEvent>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSPointerEventDOMConstructorConstruct, JSPointerEventDOMConstructor::construct);

template<> const ClassInfo JSPointerEventDOMConstructor::s_info = { "PointerEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPointerEventDOMConstructor) };

template<> JSValue JSPointerEventDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSMouseEvent::getConstructor(vm, &globalObject);
}

template<> void JSPointerEventDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "PointerEvent"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSPointerEvent::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSPointerEventPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPointerEventConstructor, 0 } },
    { "pointerId"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsPointerEvent_pointerId, 0 } },
    { "width"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsPointerEvent_width, 0 } },
    { "height"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsPointerEvent_height, 0 } },
    { "pressure"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsPointerEvent_pressure, 0 } },
    { "tangentialPressure"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsPointerEvent_tangentialPressure, 0 } },
    { "tiltX"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsPointerEvent_tiltX, 0 } },
    { "tiltY"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsPointerEvent_tiltY, 0 } },
    { "twist"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsPointerEvent_twist, 0 } },
    { "altitudeAngle"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsPointerEvent_altitudeAngle, 0 } },
    { "azimuthAngle"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsPointerEvent_azimuthAngle, 0 } },
    { "pointerType"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsPointerEvent_pointerType, 0 } },
    { "isPrimary"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsPointerEvent_isPrimary, 0 } },
    { "getCoalescedEvents"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsPointerEventPrototypeFunction_getCoalescedEvents, 0 } },
    { "getPredictedEvents"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsPointerEventPrototypeFunction_getPredictedEvents, 0 } },
};

const ClassInfo JSPointerEventPrototype::s_info = { "PointerEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPointerEventPrototype) };

void JSPointerEventPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSPointerEvent::info(), JSPointerEventPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().getCoalescedEventsEnabled)) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "getCoalescedEvents"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().getPredictedEventsEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "getPredictedEvents"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().altitudeAngleEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "altitudeAngle"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().azimuthAngleEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "azimuthAngle"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSPointerEvent::s_info = { "PointerEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPointerEvent) };

JSPointerEvent::JSPointerEvent(Structure* structure, JSDOMGlobalObject& globalObject, Ref<PointerEvent>&& impl)
    : JSMouseEvent(structure, globalObject, WTFMove(impl))
{
}

Ref<PointerEvent> JSPointerEvent::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, PointerEvent>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSPointerEvent::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSPointerEventPrototype::createStructure(vm, &globalObject, JSMouseEvent::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSPointerEventPrototype::create(vm, &globalObject, structure);
}

JSObject* JSPointerEvent::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSPointerEvent>(vm, globalObject);
}

JSValue JSPointerEvent::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSPointerEventDOMConstructor, DOMConstructorID::PointerEvent>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsPointerEventConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSPointerEventPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSPointerEvent::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsPointerEvent_pointerIdGetter(JSGlobalObject& lexicalGlobalObject, JSPointerEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.pointerId())));
}

JSC_DEFINE_CUSTOM_GETTER(jsPointerEvent_pointerId, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPointerEvent>::get<jsPointerEvent_pointerIdGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPointerEvent_widthGetter(JSGlobalObject& lexicalGlobalObject, JSPointerEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.width())));
}

JSC_DEFINE_CUSTOM_GETTER(jsPointerEvent_width, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPointerEvent>::get<jsPointerEvent_widthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPointerEvent_heightGetter(JSGlobalObject& lexicalGlobalObject, JSPointerEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.height())));
}

JSC_DEFINE_CUSTOM_GETTER(jsPointerEvent_height, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPointerEvent>::get<jsPointerEvent_heightGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPointerEvent_pressureGetter(JSGlobalObject& lexicalGlobalObject, JSPointerEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLFloat>(lexicalGlobalObject, throwScope, impl.pressure())));
}

JSC_DEFINE_CUSTOM_GETTER(jsPointerEvent_pressure, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPointerEvent>::get<jsPointerEvent_pressureGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPointerEvent_tangentialPressureGetter(JSGlobalObject& lexicalGlobalObject, JSPointerEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLFloat>(lexicalGlobalObject, throwScope, impl.tangentialPressure())));
}

JSC_DEFINE_CUSTOM_GETTER(jsPointerEvent_tangentialPressure, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPointerEvent>::get<jsPointerEvent_tangentialPressureGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPointerEvent_tiltXGetter(JSGlobalObject& lexicalGlobalObject, JSPointerEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.tiltX())));
}

JSC_DEFINE_CUSTOM_GETTER(jsPointerEvent_tiltX, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPointerEvent>::get<jsPointerEvent_tiltXGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPointerEvent_tiltYGetter(JSGlobalObject& lexicalGlobalObject, JSPointerEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.tiltY())));
}

JSC_DEFINE_CUSTOM_GETTER(jsPointerEvent_tiltY, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPointerEvent>::get<jsPointerEvent_tiltYGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPointerEvent_twistGetter(JSGlobalObject& lexicalGlobalObject, JSPointerEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.twist())));
}

JSC_DEFINE_CUSTOM_GETTER(jsPointerEvent_twist, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPointerEvent>::get<jsPointerEvent_twistGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPointerEvent_altitudeAngleGetter(JSGlobalObject& lexicalGlobalObject, JSPointerEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.altitudeAngle())));
}

JSC_DEFINE_CUSTOM_GETTER(jsPointerEvent_altitudeAngle, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPointerEvent>::get<jsPointerEvent_altitudeAngleGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPointerEvent_azimuthAngleGetter(JSGlobalObject& lexicalGlobalObject, JSPointerEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.azimuthAngle())));
}

JSC_DEFINE_CUSTOM_GETTER(jsPointerEvent_azimuthAngle, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPointerEvent>::get<jsPointerEvent_azimuthAngleGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPointerEvent_pointerTypeGetter(JSGlobalObject& lexicalGlobalObject, JSPointerEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.pointerType())));
}

JSC_DEFINE_CUSTOM_GETTER(jsPointerEvent_pointerType, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPointerEvent>::get<jsPointerEvent_pointerTypeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPointerEvent_isPrimaryGetter(JSGlobalObject& lexicalGlobalObject, JSPointerEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.isPrimary())));
}

JSC_DEFINE_CUSTOM_GETTER(jsPointerEvent_isPrimary, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPointerEvent>::get<jsPointerEvent_isPrimaryGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsPointerEventPrototypeFunction_getCoalescedEventsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPointerEvent>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLSequence<IDLInterface<PointerEvent>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getCoalescedEvents())));
}

JSC_DEFINE_HOST_FUNCTION(jsPointerEventPrototypeFunction_getCoalescedEvents, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSPointerEvent>::call<jsPointerEventPrototypeFunction_getCoalescedEventsBody>(*lexicalGlobalObject, *callFrame, "getCoalescedEvents");
}

static inline JSC::EncodedJSValue jsPointerEventPrototypeFunction_getPredictedEventsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPointerEvent>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLSequence<IDLInterface<PointerEvent>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getPredictedEvents())));
}

JSC_DEFINE_HOST_FUNCTION(jsPointerEventPrototypeFunction_getPredictedEvents, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSPointerEvent>::call<jsPointerEventPrototypeFunction_getPredictedEventsBody>(*lexicalGlobalObject, *callFrame, "getPredictedEvents");
}

JSC::GCClient::IsoSubspace* JSPointerEvent::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSPointerEvent, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForPointerEvent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForPointerEvent = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForPointerEvent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForPointerEvent = std::forward<decltype(space)>(space); }
    );
}

void JSPointerEvent::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSPointerEvent*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7PointerEvent@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore12PointerEventE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, PointerEvent>, void>> static inline void verifyVTable(PointerEvent* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7PointerEvent@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore12PointerEventE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // PointerEvent has subclasses. If PointerEvent has subclasses that get passed
        // to toJS() we currently require PointerEvent you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<PointerEvent>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<PointerEvent>(impl.ptr());
#endif
    return createWrapper<PointerEvent>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, PointerEvent& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

PointerEvent* JSPointerEvent::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSPointerEvent*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
