/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPURenderBundleEncoderDescriptor.h"

#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSGPUTextureFormat.h"
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<GPURenderBundleEncoderDescriptor>> convertDictionary<GPURenderBundleEncoderDescriptor>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    GPURenderBundleEncoderDescriptor result;
    JSValue labelValue;
    if (isNullOrUndefined)
        labelValue = jsUndefined();
    else {
        labelValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "label"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!labelValue.isUndefined()) {
        auto labelConversionResult = convert<IDLUSVString>(lexicalGlobalObject, labelValue);
        if (UNLIKELY(labelConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.label = labelConversionResult.releaseReturnValue();
    }
    JSValue colorFormatsValue;
    if (isNullOrUndefined)
        colorFormatsValue = jsUndefined();
    else {
        colorFormatsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "colorFormats"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (colorFormatsValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "colorFormats"_s, "GPURenderBundleEncoderDescriptor"_s, "sequence"_s);
        return ConversionResultException { };
    }
    auto colorFormatsConversionResult = convert<IDLSequence<IDLNullable<IDLEnumeration<GPUTextureFormat>>>>(lexicalGlobalObject, colorFormatsValue);
    if (UNLIKELY(colorFormatsConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.colorFormats = colorFormatsConversionResult.releaseReturnValue();
    JSValue depthStencilFormatValue;
    if (isNullOrUndefined)
        depthStencilFormatValue = jsUndefined();
    else {
        depthStencilFormatValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "depthStencilFormat"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!depthStencilFormatValue.isUndefined()) {
        auto depthStencilFormatConversionResult = convert<IDLEnumeration<GPUTextureFormat>>(lexicalGlobalObject, depthStencilFormatValue);
        if (UNLIKELY(depthStencilFormatConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.depthStencilFormat = depthStencilFormatConversionResult.releaseReturnValue();
    }
    JSValue sampleCountValue;
    if (isNullOrUndefined)
        sampleCountValue = jsUndefined();
    else {
        sampleCountValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "sampleCount"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto sampleCountConversionResult = convertOptionalWithDefault<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, sampleCountValue, [&]() -> ConversionResult<IDLEnforceRangeAdaptor<IDLUnsignedLong>> { return Converter<IDLEnforceRangeAdaptor<IDLUnsignedLong>>::ReturnType { 1 }; });
    if (UNLIKELY(sampleCountConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.sampleCount = sampleCountConversionResult.releaseReturnValue();
    JSValue depthReadOnlyValue;
    if (isNullOrUndefined)
        depthReadOnlyValue = jsUndefined();
    else {
        depthReadOnlyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "depthReadOnly"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto depthReadOnlyConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, depthReadOnlyValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (UNLIKELY(depthReadOnlyConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.depthReadOnly = depthReadOnlyConversionResult.releaseReturnValue();
    JSValue stencilReadOnlyValue;
    if (isNullOrUndefined)
        stencilReadOnlyValue = jsUndefined();
    else {
        stencilReadOnlyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "stencilReadOnly"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto stencilReadOnlyConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, stencilReadOnlyValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (UNLIKELY(stencilReadOnlyConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.stencilReadOnly = stencilReadOnlyConversionResult.releaseReturnValue();
    return result;
}

} // namespace WebCore
