/*
 * Copyright (C) 2021-2023 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1.  Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 * 2.  Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#pragma once

#include "ArgumentCoders.h"
#include "Connection.h"
#if PLATFORM(GTK) || PLATFORM(WPE)
#include "DMABufRendererBufferFormat.h"
#endif
#include "MessageNames.h"
#include <WebCore/ShareableBitmapHandle.h>
#include <wtf/Forward.h>
#include <wtf/ThreadSafeRefCounted.h>
#include <wtf/Vector.h>

namespace WebCore {
class IntSize;
class Region;
}

namespace Messages {
namespace AcceleratedBackingStoreDMABuf {

static inline IPC::ReceiverName messageReceiverName()
{
    return IPC::ReceiverName::AcceleratedBackingStoreDMABuf;
}

class DidCreateBuffer {
public:
    using Arguments = std::tuple<uint64_t, WebCore::IntSize, uint32_t, Vector<UnixFileDescriptor>, Vector<uint32_t>, Vector<uint32_t>, uint64_t, WebKit::DMABufRendererBufferFormat::Usage>;

    static IPC::MessageName name() { return IPC::MessageName::AcceleratedBackingStoreDMABuf_DidCreateBuffer; }
    static constexpr bool isSync = false;
    static constexpr bool canDispatchOutOfOrder = false;
    static constexpr bool replyCanDispatchOutOfOrder = false;

    DidCreateBuffer(uint64_t id, const WebCore::IntSize& size, uint32_t format, const Vector<UnixFileDescriptor>& fds, const Vector<uint32_t>& offsets, const Vector<uint32_t>& strides, uint64_t modifier, const WebKit::DMABufRendererBufferFormat::Usage& usage)
        : m_arguments(id, size, format, fds, offsets, strides, modifier, usage)
    {
    }

    auto&& arguments()
    {
        return WTFMove(m_arguments);
    }

private:
    std::tuple<uint64_t, const WebCore::IntSize&, uint32_t, const Vector<UnixFileDescriptor>&, const Vector<uint32_t>&, const Vector<uint32_t>&, uint64_t, const WebKit::DMABufRendererBufferFormat::Usage&> m_arguments;
};

class DidCreateBufferSHM {
public:
    using Arguments = std::tuple<uint64_t, WebCore::ShareableBitmapHandle>;

    static IPC::MessageName name() { return IPC::MessageName::AcceleratedBackingStoreDMABuf_DidCreateBufferSHM; }
    static constexpr bool isSync = false;
    static constexpr bool canDispatchOutOfOrder = false;
    static constexpr bool replyCanDispatchOutOfOrder = false;

    DidCreateBufferSHM(uint64_t id, WebCore::ShareableBitmapHandle&& handle)
        : m_arguments(id, WTFMove(handle))
    {
    }

    auto&& arguments()
    {
        return WTFMove(m_arguments);
    }

private:
    std::tuple<uint64_t, WebCore::ShareableBitmapHandle&&> m_arguments;
};

class DidDestroyBuffer {
public:
    using Arguments = std::tuple<uint64_t>;

    static IPC::MessageName name() { return IPC::MessageName::AcceleratedBackingStoreDMABuf_DidDestroyBuffer; }
    static constexpr bool isSync = false;
    static constexpr bool canDispatchOutOfOrder = false;
    static constexpr bool replyCanDispatchOutOfOrder = false;

    explicit DidDestroyBuffer(uint64_t id)
        : m_arguments(id)
    {
    }

    auto&& arguments()
    {
        return WTFMove(m_arguments);
    }

private:
    std::tuple<uint64_t> m_arguments;
};

class Frame {
public:
    using Arguments = std::tuple<uint64_t, WebCore::Region, UnixFileDescriptor>;

    static IPC::MessageName name() { return IPC::MessageName::AcceleratedBackingStoreDMABuf_Frame; }
    static constexpr bool isSync = false;
    static constexpr bool canDispatchOutOfOrder = false;
    static constexpr bool replyCanDispatchOutOfOrder = false;

    Frame(uint64_t id, const WebCore::Region& damage, const UnixFileDescriptor& syncFD)
        : m_arguments(id, damage, syncFD)
    {
    }

    auto&& arguments()
    {
        return WTFMove(m_arguments);
    }

private:
    std::tuple<uint64_t, const WebCore::Region&, const UnixFileDescriptor&> m_arguments;
};

} // namespace AcceleratedBackingStoreDMABuf
} // namespace Messages
