
#include <string>

const std::string rp2350_json = R"""(
[
    {
        "crit": false,
        "description": "Bits 15:0 of SHA-256 hash of boot key 0 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_BOOTKEY0_0",
        "redundancy": 1,
        "row": 128,
        "seq_index": 0,
        "seq_length": 16,
        "seq_prefix": "OTP_DATA_BOOTKEY0"
    },
    {
        "crit": false,
        "description": "Bits 31:16 of SHA-256 hash of boot key 0 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_BOOTKEY0_1",
        "redundancy": 1,
        "row": 129,
        "seq_index": 1,
        "seq_length": 16,
        "seq_prefix": "OTP_DATA_BOOTKEY0"
    },
    {
        "crit": false,
        "description": "Bits 175:160 of SHA-256 hash of boot key 0 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_BOOTKEY0_10",
        "redundancy": 1,
        "row": 138,
        "seq_index": 10,
        "seq_length": 16,
        "seq_prefix": "OTP_DATA_BOOTKEY0"
    },
    {
        "crit": false,
        "description": "Bits 191:176 of SHA-256 hash of boot key 0 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_BOOTKEY0_11",
        "redundancy": 1,
        "row": 139,
        "seq_index": 11,
        "seq_length": 16,
        "seq_prefix": "OTP_DATA_BOOTKEY0"
    },
    {
        "crit": false,
        "description": "Bits 207:192 of SHA-256 hash of boot key 0 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_BOOTKEY0_12",
        "redundancy": 1,
        "row": 140,
        "seq_index": 12,
        "seq_length": 16,
        "seq_prefix": "OTP_DATA_BOOTKEY0"
    },
    {
        "crit": false,
        "description": "Bits 223:208 of SHA-256 hash of boot key 0 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_BOOTKEY0_13",
        "redundancy": 1,
        "row": 141,
        "seq_index": 13,
        "seq_length": 16,
        "seq_prefix": "OTP_DATA_BOOTKEY0"
    },
    {
        "crit": false,
        "description": "Bits 239:224 of SHA-256 hash of boot key 0 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_BOOTKEY0_14",
        "redundancy": 1,
        "row": 142,
        "seq_index": 14,
        "seq_length": 16,
        "seq_prefix": "OTP_DATA_BOOTKEY0"
    },
    {
        "crit": false,
        "description": "Bits 255:240 of SHA-256 hash of boot key 0 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_BOOTKEY0_15",
        "redundancy": 1,
        "row": 143,
        "seq_index": 15,
        "seq_length": 16,
        "seq_prefix": "OTP_DATA_BOOTKEY0"
    },
    {
        "crit": false,
        "description": "Bits 47:32 of SHA-256 hash of boot key 0 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_BOOTKEY0_2",
        "redundancy": 1,
        "row": 130,
        "seq_index": 2,
        "seq_length": 16,
        "seq_prefix": "OTP_DATA_BOOTKEY0"
    },
    {
        "crit": false,
        "description": "Bits 63:48 of SHA-256 hash of boot key 0 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_BOOTKEY0_3",
        "redundancy": 1,
        "row": 131,
        "seq_index": 3,
        "seq_length": 16,
        "seq_prefix": "OTP_DATA_BOOTKEY0"
    },
    {
        "crit": false,
        "description": "Bits 79:64 of SHA-256 hash of boot key 0 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_BOOTKEY0_4",
        "redundancy": 1,
        "row": 132,
        "seq_index": 4,
        "seq_length": 16,
        "seq_prefix": "OTP_DATA_BOOTKEY0"
    },
    {
        "crit": false,
        "description": "Bits 95:80 of SHA-256 hash of boot key 0 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_BOOTKEY0_5",
        "redundancy": 1,
        "row": 133,
        "seq_index": 5,
        "seq_length": 16,
        "seq_prefix": "OTP_DATA_BOOTKEY0"
    },
    {
        "crit": false,
        "description": "Bits 111:96 of SHA-256 hash of boot key 0 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_BOOTKEY0_6",
        "redundancy": 1,
        "row": 134,
        "seq_index": 6,
        "seq_length": 16,
        "seq_prefix": "OTP_DATA_BOOTKEY0"
    },
    {
        "crit": false,
        "description": "Bits 127:112 of SHA-256 hash of boot key 0 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_BOOTKEY0_7",
        "redundancy": 1,
        "row": 135,
        "seq_index": 7,
        "seq_length": 16,
        "seq_prefix": "OTP_DATA_BOOTKEY0"
    },
    {
        "crit": false,
        "description": "Bits 143:128 of SHA-256 hash of boot key 0 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_BOOTKEY0_8",
        "redundancy": 1,
        "row": 136,
        "seq_index": 8,
        "seq_length": 16,
        "seq_prefix": "OTP_DATA_BOOTKEY0"
    },
    {
        "crit": false,
        "description": "Bits 159:144 of SHA-256 hash of boot key 0 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_BOOTKEY0_9",
        "redundancy": 1,
        "row": 137,
        "seq_index": 9,
        "seq_length": 16,
        "seq_prefix": "OTP_DATA_BOOTKEY0"
    },
    {
        "crit": false,
        "description": "Bits 15:0 of SHA-256 hash of boot key 1 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_BOOTKEY1_0",
        "redundancy": 1,
        "row": 144,
        "seq_index": 0,
        "seq_length": 16,
        "seq_prefix": "OTP_DATA_BOOTKEY1"
    },
    {
        "crit": false,
        "description": "Bits 31:16 of SHA-256 hash of boot key 1 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_BOOTKEY1_1",
        "redundancy": 1,
        "row": 145,
        "seq_index": 1,
        "seq_length": 16,
        "seq_prefix": "OTP_DATA_BOOTKEY1"
    },
    {
        "crit": false,
        "description": "Bits 175:160 of SHA-256 hash of boot key 1 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_BOOTKEY1_10",
        "redundancy": 1,
        "row": 154,
        "seq_index": 10,
        "seq_length": 16,
        "seq_prefix": "OTP_DATA_BOOTKEY1"
    },
    {
        "crit": false,
        "description": "Bits 191:176 of SHA-256 hash of boot key 1 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_BOOTKEY1_11",
        "redundancy": 1,
        "row": 155,
        "seq_index": 11,
        "seq_length": 16,
        "seq_prefix": "OTP_DATA_BOOTKEY1"
    },
    {
        "crit": false,
        "description": "Bits 207:192 of SHA-256 hash of boot key 1 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_BOOTKEY1_12",
        "redundancy": 1,
        "row": 156,
        "seq_index": 12,
        "seq_length": 16,
        "seq_prefix": "OTP_DATA_BOOTKEY1"
    },
    {
        "crit": false,
        "description": "Bits 223:208 of SHA-256 hash of boot key 1 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_BOOTKEY1_13",
        "redundancy": 1,
        "row": 157,
        "seq_index": 13,
        "seq_length": 16,
        "seq_prefix": "OTP_DATA_BOOTKEY1"
    },
    {
        "crit": false,
        "description": "Bits 239:224 of SHA-256 hash of boot key 1 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_BOOTKEY1_14",
        "redundancy": 1,
        "row": 158,
        "seq_index": 14,
        "seq_length": 16,
        "seq_prefix": "OTP_DATA_BOOTKEY1"
    },
    {
        "crit": false,
        "description": "Bits 255:240 of SHA-256 hash of boot key 1 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_BOOTKEY1_15",
        "redundancy": 1,
        "row": 159,
        "seq_index": 15,
        "seq_length": 16,
        "seq_prefix": "OTP_DATA_BOOTKEY1"
    },
    {
        "crit": false,
        "description": "Bits 47:32 of SHA-256 hash of boot key 1 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_BOOTKEY1_2",
        "redundancy": 1,
        "row": 146,
        "seq_index": 2,
        "seq_length": 16,
        "seq_prefix": "OTP_DATA_BOOTKEY1"
    },
    {
        "crit": false,
        "description": "Bits 63:48 of SHA-256 hash of boot key 1 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_BOOTKEY1_3",
        "redundancy": 1,
        "row": 147,
        "seq_index": 3,
        "seq_length": 16,
        "seq_prefix": "OTP_DATA_BOOTKEY1"
    },
    {
        "crit": false,
        "description": "Bits 79:64 of SHA-256 hash of boot key 1 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_BOOTKEY1_4",
        "redundancy": 1,
        "row": 148,
        "seq_index": 4,
        "seq_length": 16,
        "seq_prefix": "OTP_DATA_BOOTKEY1"
    },
    {
        "crit": false,
        "description": "Bits 95:80 of SHA-256 hash of boot key 1 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_BOOTKEY1_5",
        "redundancy": 1,
        "row": 149,
        "seq_index": 5,
        "seq_length": 16,
        "seq_prefix": "OTP_DATA_BOOTKEY1"
    },
    {
        "crit": false,
        "description": "Bits 111:96 of SHA-256 hash of boot key 1 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_BOOTKEY1_6",
        "redundancy": 1,
        "row": 150,
        "seq_index": 6,
        "seq_length": 16,
        "seq_prefix": "OTP_DATA_BOOTKEY1"
    },
    {
        "crit": false,
        "description": "Bits 127:112 of SHA-256 hash of boot key 1 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_BOOTKEY1_7",
        "redundancy": 1,
        "row": 151,
        "seq_index": 7,
        "seq_length": 16,
        "seq_prefix": "OTP_DATA_BOOTKEY1"
    },
    {
        "crit": false,
        "description": "Bits 143:128 of SHA-256 hash of boot key 1 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_BOOTKEY1_8",
        "redundancy": 1,
        "row": 152,
        "seq_index": 8,
        "seq_length": 16,
        "seq_prefix": "OTP_DATA_BOOTKEY1"
    },
    {
        "crit": false,
        "description": "Bits 159:144 of SHA-256 hash of boot key 1 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_BOOTKEY1_9",
        "redundancy": 1,
        "row": 153,
        "seq_index": 9,
        "seq_length": 16,
        "seq_prefix": "OTP_DATA_BOOTKEY1"
    },
    {
        "crit": false,
        "description": "Bits 15:0 of SHA-256 hash of boot key 2 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_BOOTKEY2_0",
        "redundancy": 1,
        "row": 160,
        "seq_index": 0,
        "seq_length": 16,
        "seq_prefix": "OTP_DATA_BOOTKEY2"
    },
    {
        "crit": false,
        "description": "Bits 31:16 of SHA-256 hash of boot key 2 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_BOOTKEY2_1",
        "redundancy": 1,
        "row": 161,
        "seq_index": 1,
        "seq_length": 16,
        "seq_prefix": "OTP_DATA_BOOTKEY2"
    },
    {
        "crit": false,
        "description": "Bits 175:160 of SHA-256 hash of boot key 2 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_BOOTKEY2_10",
        "redundancy": 1,
        "row": 170,
        "seq_index": 10,
        "seq_length": 16,
        "seq_prefix": "OTP_DATA_BOOTKEY2"
    },
    {
        "crit": false,
        "description": "Bits 191:176 of SHA-256 hash of boot key 2 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_BOOTKEY2_11",
        "redundancy": 1,
        "row": 171,
        "seq_index": 11,
        "seq_length": 16,
        "seq_prefix": "OTP_DATA_BOOTKEY2"
    },
    {
        "crit": false,
        "description": "Bits 207:192 of SHA-256 hash of boot key 2 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_BOOTKEY2_12",
        "redundancy": 1,
        "row": 172,
        "seq_index": 12,
        "seq_length": 16,
        "seq_prefix": "OTP_DATA_BOOTKEY2"
    },
    {
        "crit": false,
        "description": "Bits 223:208 of SHA-256 hash of boot key 2 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_BOOTKEY2_13",
        "redundancy": 1,
        "row": 173,
        "seq_index": 13,
        "seq_length": 16,
        "seq_prefix": "OTP_DATA_BOOTKEY2"
    },
    {
        "crit": false,
        "description": "Bits 239:224 of SHA-256 hash of boot key 2 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_BOOTKEY2_14",
        "redundancy": 1,
        "row": 174,
        "seq_index": 14,
        "seq_length": 16,
        "seq_prefix": "OTP_DATA_BOOTKEY2"
    },
    {
        "crit": false,
        "description": "Bits 255:240 of SHA-256 hash of boot key 2 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_BOOTKEY2_15",
        "redundancy": 1,
        "row": 175,
        "seq_index": 15,
        "seq_length": 16,
        "seq_prefix": "OTP_DATA_BOOTKEY2"
    },
    {
        "crit": false,
        "description": "Bits 47:32 of SHA-256 hash of boot key 2 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_BOOTKEY2_2",
        "redundancy": 1,
        "row": 162,
        "seq_index": 2,
        "seq_length": 16,
        "seq_prefix": "OTP_DATA_BOOTKEY2"
    },
    {
        "crit": false,
        "description": "Bits 63:48 of SHA-256 hash of boot key 2 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_BOOTKEY2_3",
        "redundancy": 1,
        "row": 163,
        "seq_index": 3,
        "seq_length": 16,
        "seq_prefix": "OTP_DATA_BOOTKEY2"
    },
    {
        "crit": false,
        "description": "Bits 79:64 of SHA-256 hash of boot key 2 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_BOOTKEY2_4",
        "redundancy": 1,
        "row": 164,
        "seq_index": 4,
        "seq_length": 16,
        "seq_prefix": "OTP_DATA_BOOTKEY2"
    },
    {
        "crit": false,
        "description": "Bits 95:80 of SHA-256 hash of boot key 2 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_BOOTKEY2_5",
        "redundancy": 1,
        "row": 165,
        "seq_index": 5,
        "seq_length": 16,
        "seq_prefix": "OTP_DATA_BOOTKEY2"
    },
    {
        "crit": false,
        "description": "Bits 111:96 of SHA-256 hash of boot key 2 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_BOOTKEY2_6",
        "redundancy": 1,
        "row": 166,
        "seq_index": 6,
        "seq_length": 16,
        "seq_prefix": "OTP_DATA_BOOTKEY2"
    },
    {
        "crit": false,
        "description": "Bits 127:112 of SHA-256 hash of boot key 2 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_BOOTKEY2_7",
        "redundancy": 1,
        "row": 167,
        "seq_index": 7,
        "seq_length": 16,
        "seq_prefix": "OTP_DATA_BOOTKEY2"
    },
    {
        "crit": false,
        "description": "Bits 143:128 of SHA-256 hash of boot key 2 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_BOOTKEY2_8",
        "redundancy": 1,
        "row": 168,
        "seq_index": 8,
        "seq_length": 16,
        "seq_prefix": "OTP_DATA_BOOTKEY2"
    },
    {
        "crit": false,
        "description": "Bits 159:144 of SHA-256 hash of boot key 2 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_BOOTKEY2_9",
        "redundancy": 1,
        "row": 169,
        "seq_index": 9,
        "seq_length": 16,
        "seq_prefix": "OTP_DATA_BOOTKEY2"
    },
    {
        "crit": false,
        "description": "Bits 15:0 of SHA-256 hash of boot key 3 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_BOOTKEY3_0",
        "redundancy": 1,
        "row": 176,
        "seq_index": 0,
        "seq_length": 16,
        "seq_prefix": "OTP_DATA_BOOTKEY3"
    },
    {
        "crit": false,
        "description": "Bits 31:16 of SHA-256 hash of boot key 3 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_BOOTKEY3_1",
        "redundancy": 1,
        "row": 177,
        "seq_index": 1,
        "seq_length": 16,
        "seq_prefix": "OTP_DATA_BOOTKEY3"
    },
    {
        "crit": false,
        "description": "Bits 175:160 of SHA-256 hash of boot key 3 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_BOOTKEY3_10",
        "redundancy": 1,
        "row": 186,
        "seq_index": 10,
        "seq_length": 16,
        "seq_prefix": "OTP_DATA_BOOTKEY3"
    },
    {
        "crit": false,
        "description": "Bits 191:176 of SHA-256 hash of boot key 3 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_BOOTKEY3_11",
        "redundancy": 1,
        "row": 187,
        "seq_index": 11,
        "seq_length": 16,
        "seq_prefix": "OTP_DATA_BOOTKEY3"
    },
    {
        "crit": false,
        "description": "Bits 207:192 of SHA-256 hash of boot key 3 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_BOOTKEY3_12",
        "redundancy": 1,
        "row": 188,
        "seq_index": 12,
        "seq_length": 16,
        "seq_prefix": "OTP_DATA_BOOTKEY3"
    },
    {
        "crit": false,
        "description": "Bits 223:208 of SHA-256 hash of boot key 3 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_BOOTKEY3_13",
        "redundancy": 1,
        "row": 189,
        "seq_index": 13,
        "seq_length": 16,
        "seq_prefix": "OTP_DATA_BOOTKEY3"
    },
    {
        "crit": false,
        "description": "Bits 239:224 of SHA-256 hash of boot key 3 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_BOOTKEY3_14",
        "redundancy": 1,
        "row": 190,
        "seq_index": 14,
        "seq_length": 16,
        "seq_prefix": "OTP_DATA_BOOTKEY3"
    },
    {
        "crit": false,
        "description": "Bits 255:240 of SHA-256 hash of boot key 3 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_BOOTKEY3_15",
        "redundancy": 1,
        "row": 191,
        "seq_index": 15,
        "seq_length": 16,
        "seq_prefix": "OTP_DATA_BOOTKEY3"
    },
    {
        "crit": false,
        "description": "Bits 47:32 of SHA-256 hash of boot key 3 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_BOOTKEY3_2",
        "redundancy": 1,
        "row": 178,
        "seq_index": 2,
        "seq_length": 16,
        "seq_prefix": "OTP_DATA_BOOTKEY3"
    },
    {
        "crit": false,
        "description": "Bits 63:48 of SHA-256 hash of boot key 3 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_BOOTKEY3_3",
        "redundancy": 1,
        "row": 179,
        "seq_index": 3,
        "seq_length": 16,
        "seq_prefix": "OTP_DATA_BOOTKEY3"
    },
    {
        "crit": false,
        "description": "Bits 79:64 of SHA-256 hash of boot key 3 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_BOOTKEY3_4",
        "redundancy": 1,
        "row": 180,
        "seq_index": 4,
        "seq_length": 16,
        "seq_prefix": "OTP_DATA_BOOTKEY3"
    },
    {
        "crit": false,
        "description": "Bits 95:80 of SHA-256 hash of boot key 3 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_BOOTKEY3_5",
        "redundancy": 1,
        "row": 181,
        "seq_index": 5,
        "seq_length": 16,
        "seq_prefix": "OTP_DATA_BOOTKEY3"
    },
    {
        "crit": false,
        "description": "Bits 111:96 of SHA-256 hash of boot key 3 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_BOOTKEY3_6",
        "redundancy": 1,
        "row": 182,
        "seq_index": 6,
        "seq_length": 16,
        "seq_prefix": "OTP_DATA_BOOTKEY3"
    },
    {
        "crit": false,
        "description": "Bits 127:112 of SHA-256 hash of boot key 3 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_BOOTKEY3_7",
        "redundancy": 1,
        "row": 183,
        "seq_index": 7,
        "seq_length": 16,
        "seq_prefix": "OTP_DATA_BOOTKEY3"
    },
    {
        "crit": false,
        "description": "Bits 143:128 of SHA-256 hash of boot key 3 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_BOOTKEY3_8",
        "redundancy": 1,
        "row": 184,
        "seq_index": 8,
        "seq_length": 16,
        "seq_prefix": "OTP_DATA_BOOTKEY3"
    },
    {
        "crit": false,
        "description": "Bits 159:144 of SHA-256 hash of boot key 3 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_BOOTKEY3_9",
        "redundancy": 1,
        "row": 185,
        "seq_index": 9,
        "seq_length": 16,
        "seq_prefix": "OTP_DATA_BOOTKEY3"
    },
    {
        "crit": false,
        "description": "Pin configuration for LED status, used by USB bootloader. (ECC) Must be valid if BOOT_FLAGS0_ENABLE_BOOTSEL_LED is set.",
        "ecc": true,
        "fields": [
            {
                "description": "LED is active-low. (Default: active-high.)",
                "mask": 256,
                "name": "ACTIVELOW"
            },
            {
                "description": "GPIO index to use for bootloader activity LED.",
                "mask": 63,
                "name": "PIN"
            }
        ],
        "mask": 319,
        "name": "OTP_DATA_BOOTSEL_LED_CFG",
        "redundancy": 1,
        "row": 86,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Optional PLL configuration for BOOTSEL mode. (ECC) This should be configured to produce an exact 48 MHz based on the crystal oscillator frequency. User mode software may also use this value to calculate the expected crystal frequency based on an assumed 48 MHz PLL output. If no configuration is given, the crystal is assumed to be 12 MHz. The PLL frequency can be calculated as: PLL out = (XOSC frequency / (REFDIV+1)) x FBDIV / (POSTDIV1 x POSTDIV2) Conversely the crystal frequency can be calculated as: XOSC frequency = 48 MHz x (REFDIV+1) x (POSTDIV1 x POSTDIV2) / FBDIV (Note the  +1 on REFDIV is because the value stored in this OTP location is the actual divisor value minus one.) Used if and only if ENABLE_BOOTSEL_NON_DEFAULT_PLL_XOSC_CFG is set in BOOT_FLAGS0. That bit should be set only after this row and BOOTSEL_XOSC_CFG are both correctly programmed.",
        "ecc": true,
        "fields": [
            {
                "description": "PLL reference divisor, minus one. Programming a value of 0 means a reference divisor of 1. Programming a value of 1 means a reference divisor of 2 (for exceptionally fast XIN inputs)",
                "mask": 32768,
                "name": "REFDIV"
            },
            {
                "description": "PLL post-divide 2 divisor, in the range 1..7 inclusive.",
                "mask": 28672,
                "name": "POSTDIV2"
            },
            {
                "description": "PLL post-divide 1 divisor, in the range 1..7 inclusive.",
                "mask": 3584,
                "name": "POSTDIV1"
            },
            {
                "description": "PLL feedback divisor, in the range 16..320 inclusive.",
                "mask": 511,
                "name": "FBDIV"
            }
        ],
        "mask": 65535,
        "name": "OTP_DATA_BOOTSEL_PLL_CFG",
        "redundancy": 1,
        "row": 87,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Non-default crystal oscillator configuration for the USB bootloader. (ECC) These values may also be used by user code configuring the crystal oscillator. Used if and only if ENABLE_BOOTSEL_NON_DEFAULT_PLL_XOSC_CFG is set in BOOT_FLAGS0. That bit should be set only after this row and BOOTSEL_PLL_CFG are both correctly programmed.",
        "ecc": true,
        "fields": [
            {
                "description": "Value of the XOSC_CTRL_FREQ_RANGE register. 0x0 -> 1_15MHZ 0x1 -> 10_30MHZ 0x2 -> 25_60MHZ 0x3 -> 40_100MHZ",
                "mask": 49152,
                "name": "RANGE"
            },
            {
                "description": "Value of the XOSC_STARTUP register",
                "mask": 16383,
                "name": "STARTUP"
            }
        ],
        "mask": 65535,
        "name": "OTP_DATA_BOOTSEL_XOSC_CFG",
        "redundancy": 1,
        "row": 88,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Disable/Enable boot paths/features in the RP2350 mask ROM. Disables always supersede enables. Enables are provided where there are other configurations in OTP that must be valid. (RBIT-3)",
        "ecc": false,
        "fields": [
            {
                "description": "",
                "mask": 2097152,
                "name": "DISABLE_SRAM_WINDOW_BOOT"
            },
            {
                "description": "Disable all access to XIP after entering an SRAM binary. Note that this will cause bootrom APIs that access XIP to fail, including APIs that interact with the partition table.",
                "mask": 1048576,
                "name": "DISABLE_XIP_ACCESS_ON_SRAM_ENTRY"
            },
            {
                "description": "",
                "mask": 524288,
                "name": "DISABLE_BOOTSEL_UART_BOOT"
            },
            {
                "description": "",
                "mask": 262144,
                "name": "DISABLE_BOOTSEL_USB_PICOBOOT_IFC"
            },
            {
                "description": "",
                "mask": 131072,
                "name": "DISABLE_BOOTSEL_USB_MSD_IFC"
            },
            {
                "description": "",
                "mask": 65536,
                "name": "DISABLE_WATCHDOG_SCRATCH"
            },
            {
                "description": "",
                "mask": 32768,
                "name": "DISABLE_POWER_SCRATCH"
            },
            {
                "description": "Enable OTP boot. A number of OTP rows specified by OTPBOOT_LEN will be loaded, starting from OTPBOOT_SRC, into the SRAM location specified by OTPBOOT_DST1 and OTPBOOT_DST0. The loaded program image is stored with ECC, 16 bits per row, and must contain a valid IMAGE_DEF. Do not set this bit without first programming an image into OTP and configuring OTPBOOT_LEN, OTPBOOT_SRC, OTPBOOT_DST0 and OTPBOOT_DST1. Note that OTPBOOT_LEN and OTPBOOT_SRC must be even numbers of OTP rows. Equivalently, the image must be a multiple of 32 bits in size, and must start at a 32-bit-aligned address in the ECC read data address window.",
                "mask": 16384,
                "name": "ENABLE_OTP_BOOT"
            },
            {
                "description": "Takes precedence over ENABLE_OTP_BOOT.",
                "mask": 8192,
                "name": "DISABLE_OTP_BOOT"
            },
            {
                "description": "",
                "mask": 4096,
                "name": "DISABLE_FLASH_BOOT"
            },
            {
                "description": "Require binaries to have a rollback version. Set automatically the first time a binary with a rollback version is booted.",
                "mask": 2048,
                "name": "ROLLBACK_REQUIRED"
            },
            {
                "description": "Require a partition table to be hashed (if not signed)",
                "mask": 1024,
                "name": "HASHED_PARTITION_TABLE"
            },
            {
                "description": "Require a partition table to be signed",
                "mask": 512,
                "name": "SECURE_PARTITION_TABLE"
            },
            {
                "description": "Disable auto-switch of CPU architecture on boot when the (only) binary to be booted is for the other Arm/RISC-V architecture and both architectures are enabled",
                "mask": 256,
                "name": "DISABLE_AUTO_SWITCH_ARCH"
            },
            {
                "description": "Restrict flash boot path to use of a single binary at the start of flash",
                "mask": 128,
                "name": "SINGLE_FLASH_BINARY"
            },
            {
                "description": "Override the limit for default flash metadata scanning. The value is specified in FLASH_PARTITION_SLOT_SIZE. Make sure FLASH_PARTITION_SLOT_SIZE is valid before setting this bit",
                "mask": 64,
                "name": "OVERRIDE_FLASH_PARTITION_SLOT_SIZE"
            },
            {
                "description": "Mark FLASH_DEVINFO as containing valid, ECC'd data which describes external flash devices.",
                "mask": 32,
                "name": "FLASH_DEVINFO_ENABLE"
            },
            {
                "description": "Enable quartering of ROSC divisor during signature check, to reduce secure boot time",
                "mask": 16,
                "name": "FAST_SIGCHECK_ROSC_DIV"
            },
            {
                "description": "If 1, configure the QSPI pads for 1.8 V operation when accessing flash for the first time from the bootrom, using the VOLTAGE_SELECT register for the QSPI pads bank. This slightly improves the input timing of the pads at low voltages, but does not affect their output characteristics. If 0, leave VOLTAGE_SELECT in its reset state (suitable for operation at and above 2.5 V)",
                "mask": 8,
                "name": "FLASH_IO_VOLTAGE_1V8"
            },
            {
                "description": "Enable loading of the non-default XOSC and PLL configuration before entering BOOTSEL mode. Ensure that BOOTSEL_XOSC_CFG and BOOTSEL_PLL_CFG are correctly programmed before setting this bit. If this bit is set, user software may use the contents of BOOTSEL_PLL_CFG to calculated the expected XOSC frequency based on the fixed USB boot frequency of 48 MHz.",
                "mask": 4,
                "name": "ENABLE_BOOTSEL_NON_DEFAULT_PLL_XOSC_CFG"
            },
            {
                "description": "Enable bootloader activity LED. If set, bootsel_led_cfg is assumed to be valid",
                "mask": 2,
                "name": "ENABLE_BOOTSEL_LED"
            },
            {
                "description": "",
                "mask": 1,
                "name": "DISABLE_BOOTSEL_EXEC2"
            }
        ],
        "mask": 4194303,
        "name": "OTP_DATA_BOOT_FLAGS0",
        "redundancy": 3,
        "row": 72,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Disable/Enable boot paths/features in the RP2350 mask ROM. Disables always supersede enables. Enables are provided where there are other configurations in OTP that must be valid. (RBIT-3)",
        "ecc": false,
        "fields": [
            {
                "description": "Enable entering BOOTSEL mode via double-tap of the RUN/RSTn pin. Adds a significant delay to boot time, as configured by DOUBLE_TAP_DELAY. This functions by waiting at startup (i.e. following a reset) to see if a second reset is applied soon afterward. The second reset is detected by the bootrom with help of the POWMAN_CHIP_RESET_DOUBLE_TAP flag, which is not reset by the external reset pin, and the bootrom enters BOOTSEL mode (NSBOOT) to await further instruction over USB or UART.",
                "mask": 524288,
                "name": "DOUBLE_TAP"
            },
            {
                "description": "Adjust how long to wait for a second reset when double tap BOOTSEL mode is enabled via DOUBLE_TAP. The minimum is 50 milliseconds, and each unit of this field adds an additional 50 milliseconds. For example, settings this field to its maximum value of 7 will cause the chip to wait for 400 milliseconds at boot to check for a second reset which requests entry to BOOTSEL mode. 200 milliseconds (DOUBLE_TAP_DELAY=3) is a good intermediate value.",
                "mask": 458752,
                "name": "DOUBLE_TAP_DELAY"
            },
            {
                "description": "Mark a boot key as invalid, or prevent it from ever becoming valid. The bootrom will ignore any boot key marked as invalid during secure boot signature checks. Each bit in this field corresponds to one of the four 256-bit boot key hashes that may be stored in page 2 of the OTP. When provisioning boot keys, it's recommended to mark any boot key slots you don't intend to use as KEY_INVALID, so that spurious keys can not be installed at a later time.",
                "mask": 3840,
                "name": "KEY_INVALID"
            },
            {
                "description": "Mark each of the possible boot keys as valid. The bootrom will check signatures against all valid boot keys, and ignore invalid boot keys. Each bit in this field corresponds to one of the four 256-bit boot key hashes that may be stored in page 2 of the OTP. A KEY_VALID bit is ignored if the corresponding KEY_INVALID bit is set. Boot keys are considered valid only when KEY_VALID is set and KEY_INVALID is clear. Do not mark a boot key as KEY_VALID if it does not contain a valid SHA-256 hash of your secp256k1 public key. Verify keys after programming, before setting the KEY_VALID bits -- a boot key with uncorrectable ECC faults will render your device unbootable if secure boot is enabled. Do not enable secure boot without first installing a valid key. This will render your device unbootable.",
                "mask": 15,
                "name": "KEY_VALID"
            }
        ],
        "mask": 986895,
        "name": "OTP_DATA_BOOT_FLAGS1",
        "redundancy": 3,
        "row": 75,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Bits 15:0 of public device ID. (ECC) The CHIPID0..3 rows contain a 64-bit random identifier for this chip, which can be read from the USB bootloader PICOBOOT interface or from the get_sys_info ROM API. The number of random bits makes the occurrence of twins exceedingly unlikely: for example, a fleet of a hundred million devices has a 99.97% probability of no twinned IDs. This is estimated to be lower than the occurrence of process errors in the assignment of sequential random IDs, and for practical purposes CHIPID may be treated as unique.",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_CHIPID0",
        "redundancy": 1,
        "row": 0,
        "seq_index": 0,
        "seq_length": 4,
        "seq_prefix": "OTP_DATA_CHIPID"
    },
    {
        "crit": false,
        "description": "Bits 31:16 of public device ID (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_CHIPID1",
        "redundancy": 1,
        "row": 1,
        "seq_index": 1,
        "seq_length": 4,
        "seq_prefix": "OTP_DATA_CHIPID"
    },
    {
        "crit": false,
        "description": "Bits 47:32 of public device ID (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_CHIPID2",
        "redundancy": 1,
        "row": 2,
        "seq_index": 2,
        "seq_length": 4,
        "seq_prefix": "OTP_DATA_CHIPID"
    },
    {
        "crit": false,
        "description": "Bits 63:48 of public device ID (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_CHIPID3",
        "redundancy": 1,
        "row": 3,
        "seq_index": 3,
        "seq_length": 4,
        "seq_prefix": "OTP_DATA_CHIPID"
    },
    {
        "crit": true,
        "description": "Page 0 critical boot flags (RBIT-8)",
        "ecc": false,
        "fields": [
            {
                "description": "Permanently disable RISC-V processors (Hazard3)",
                "mask": 2,
                "name": "RISCV_DISABLE"
            },
            {
                "description": "Permanently disable ARM processors (Cortex-M33)",
                "mask": 1,
                "name": "ARM_DISABLE"
            }
        ],
        "mask": 3,
        "name": "OTP_DATA_CRIT0",
        "redundancy": 8,
        "row": 56,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": true,
        "description": "Page 1 critical boot flags (RBIT-8)",
        "ecc": false,
        "fields": [
            {
                "description": "Increase the sensitivity of the glitch detectors from their default.",
                "mask": 96,
                "name": "GLITCH_DETECTOR_SENS"
            },
            {
                "description": "Arm the glitch detectors to reset the system if an abnormal clock/power event is observed.",
                "mask": 16,
                "name": "GLITCH_DETECTOR_ENABLE"
            },
            {
                "description": "Set the default boot architecture, 0=ARM 1=RISC-V. Ignored if ARM_DISABLE, RISCV_DISABLE or SECURE_BOOT_ENABLE is set.",
                "mask": 8,
                "name": "BOOT_ARCH"
            },
            {
                "description": "Disable all debug access",
                "mask": 4,
                "name": "DEBUG_DISABLE"
            },
            {
                "description": "Disable Secure debug access",
                "mask": 2,
                "name": "SECURE_DEBUG_DISABLE"
            },
            {
                "description": "Enable boot signature enforcement, and permanently disable the RISC-V cores.",
                "mask": 1,
                "name": "SECURE_BOOT_ENABLE"
            }
        ],
        "mask": 127,
        "name": "OTP_DATA_CRIT1",
        "redundancy": 8,
        "row": 64,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Default boot version thermometer counter, bits 23:0 (RBIT-3)",
        "ecc": false,
        "fields": [],
        "mask": 16777215,
        "name": "OTP_DATA_DEFAULT_BOOT_VERSION0",
        "redundancy": 3,
        "row": 78,
        "seq_index": 0,
        "seq_length": 2,
        "seq_prefix": "OTP_DATA_DEFAULT_BOOT_VERSION"
    },
    {
        "crit": false,
        "description": "Default boot version thermometer counter, bits 47:24 (RBIT-3)",
        "ecc": false,
        "fields": [],
        "mask": 16777215,
        "name": "OTP_DATA_DEFAULT_BOOT_VERSION1",
        "redundancy": 3,
        "row": 81,
        "seq_index": 1,
        "seq_length": 2,
        "seq_prefix": "OTP_DATA_DEFAULT_BOOT_VERSION"
    },
    {
        "crit": false,
        "description": "Stores information about external flash device(s). (ECC) Assumed to be valid if BOOT_FLAGS0_FLASH_DEVINFO_ENABLE is set.",
        "ecc": true,
        "fields": [
            {
                "description": "The size of the flash/PSRAM device on chip select 1 (addressable at 0x11000000 through 0x11ffffff). A value of zero is decoded as a size of zero (no device). Nonzero values are decoded as 4kiB << CS1_SIZE. For example, four megabytes is encoded with a CS1_SIZE value of 10, and 16 megabytes is encoded with a CS1_SIZE value of 12. When BOOT_FLAGS0_FLASH_DEVINFO_ENABLE is not set, a default of zero is used. 0x0 -> NONE 0x1 -> 8K 0x2 -> 16K 0x3 -> 32K 0x4 -> 64k 0x5 -> 128K 0x6 -> 256K 0x7 -> 512K 0x8 -> 1M 0x9 -> 2M 0xa -> 4M 0xb -> 8M 0xc -> 16M",
                "mask": 61440,
                "name": "CS1_SIZE"
            },
            {
                "description": "The size of the flash/PSRAM device on chip select 0 (addressable at 0x10000000 through 0x10ffffff). A value of zero is decoded as a size of zero (no device). Nonzero values are decoded as 4kiB << CS0_SIZE. For example, four megabytes is encoded with a CS0_SIZE value of 10, and 16 megabytes is encoded with a CS0_SIZE value of 12. When BOOT_FLAGS0_FLASH_DEVINFO_ENABLE is not set, a default of 12 (16 MiB) is used. 0x0 -> NONE 0x1 -> 8K 0x2 -> 16K 0x3 -> 32K 0x4 -> 64k 0x5 -> 128K 0x6 -> 256K 0x7 -> 512K 0x8 -> 1M 0x9 -> 2M 0xa -> 4M 0xb -> 8M 0xc -> 16M",
                "mask": 3840,
                "name": "CS0_SIZE"
            },
            {
                "description": "If true, all attached devices are assumed to support (or ignore, in the case of PSRAM) a block erase command with a command prefix of D8h, an erase size of 64 kiB, and a 24-bit address. Almost all 25-series flash devices support this command. If set, the bootrom will use the D8h erase command where it is able, to accelerate bulk erase operations. This makes flash programming faster. When BOOT_FLAGS0_FLASH_DEVINFO_ENABLE is not set, this field defaults to false.",
                "mask": 128,
                "name": "D8H_ERASE_SUPPORTED"
            },
            {
                "description": "Indicate a GPIO number to be used for the secondary flash chip select (CS1), which selects the external QSPI device mapped at system addresses 0x11000000 through 0x11ffffff. There is no such configuration for CS0, as the primary chip select has a dedicated pin. On RP2350 the permissible GPIO numbers are 0, 8, 19 and 47. Ignored if CS1_size is zero. If CS1_SIZE is nonzero, the bootrom will automatically configure this GPIO as a second chip select upon entering the flash boot path, or entering any other path that may use the QSPI flash interface, such as BOOTSEL mode (nsboot).",
                "mask": 63,
                "name": "CS1_GPIO"
            }
        ],
        "mask": 65471,
        "name": "OTP_DATA_FLASH_DEVINFO",
        "redundancy": 1,
        "row": 84,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Gap between partition table slot 0 and slot 1 at the start of flash (the default size is 4096 bytes) (ECC) Enabled by the OVERRIDE_FLASH_PARTITION_SLOT_SIZE bit in BOOT_FLAGS, the size is 4096 * (value + 1)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_FLASH_PARTITION_SLOT_SIZE",
        "redundancy": 1,
        "row": 85,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lower 16 bits of CRC32 of OTP addresses 0x00 through 0x6b (polynomial 0x4c11db7, input reflected, output reflected, seed all-ones, final XOR all-ones) (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_INFO_CRC0",
        "redundancy": 1,
        "row": 54,
        "seq_index": 0,
        "seq_length": 2,
        "seq_prefix": "OTP_DATA_INFO_CRC"
    },
    {
        "crit": false,
        "description": "Upper 16 bits of CRC32 of OTP addresses 0x00 through 0x6b (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_INFO_CRC1",
        "redundancy": 1,
        "row": 55,
        "seq_index": 1,
        "seq_length": 2,
        "seq_prefix": "OTP_DATA_INFO_CRC"
    },
    {
        "crit": false,
        "description": "Bits 15:0 of OTP access key 1 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_KEY1_0",
        "redundancy": 1,
        "row": 3912,
        "seq_index": 0,
        "seq_length": 8,
        "seq_prefix": "OTP_DATA_KEY1"
    },
    {
        "crit": false,
        "description": "Bits 31:16 of OTP access key 1 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_KEY1_1",
        "redundancy": 1,
        "row": 3913,
        "seq_index": 1,
        "seq_length": 8,
        "seq_prefix": "OTP_DATA_KEY1"
    },
    {
        "crit": false,
        "description": "Bits 47:32 of OTP access key 1 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_KEY1_2",
        "redundancy": 1,
        "row": 3914,
        "seq_index": 2,
        "seq_length": 8,
        "seq_prefix": "OTP_DATA_KEY1"
    },
    {
        "crit": false,
        "description": "Bits 63:48 of OTP access key 1 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_KEY1_3",
        "redundancy": 1,
        "row": 3915,
        "seq_index": 3,
        "seq_length": 8,
        "seq_prefix": "OTP_DATA_KEY1"
    },
    {
        "crit": false,
        "description": "Bits 79:64 of OTP access key 1 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_KEY1_4",
        "redundancy": 1,
        "row": 3916,
        "seq_index": 4,
        "seq_length": 8,
        "seq_prefix": "OTP_DATA_KEY1"
    },
    {
        "crit": false,
        "description": "Bits 95:80 of OTP access key 1 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_KEY1_5",
        "redundancy": 1,
        "row": 3917,
        "seq_index": 5,
        "seq_length": 8,
        "seq_prefix": "OTP_DATA_KEY1"
    },
    {
        "crit": false,
        "description": "Bits 111:96 of OTP access key 1 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_KEY1_6",
        "redundancy": 1,
        "row": 3918,
        "seq_index": 6,
        "seq_length": 8,
        "seq_prefix": "OTP_DATA_KEY1"
    },
    {
        "crit": false,
        "description": "Bits 127:112 of OTP access key 1 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_KEY1_7",
        "redundancy": 1,
        "row": 3919,
        "seq_index": 7,
        "seq_length": 8,
        "seq_prefix": "OTP_DATA_KEY1"
    },
    {
        "crit": false,
        "description": "Valid flag for key 1. Once the valid flag is set, the key can no longer be read or written, and becomes a valid fixed key for protecting OTP pages.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of VALID, with 3-way majority vote",
                "mask": 65536,
                "name": "VALID_R2"
            },
            {
                "description": "Redundant copy of VALID, with 3-way majority vote",
                "mask": 256,
                "name": "VALID_R1"
            },
            {
                "description": "",
                "mask": 1,
                "name": "VALID"
            }
        ],
        "mask": 65793,
        "name": "OTP_DATA_KEY1_VALID",
        "redundancy": 1,
        "row": 3961,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Bits 15:0 of OTP access key 2 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_KEY2_0",
        "redundancy": 1,
        "row": 3920,
        "seq_index": 0,
        "seq_length": 8,
        "seq_prefix": "OTP_DATA_KEY2"
    },
    {
        "crit": false,
        "description": "Bits 31:16 of OTP access key 2 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_KEY2_1",
        "redundancy": 1,
        "row": 3921,
        "seq_index": 1,
        "seq_length": 8,
        "seq_prefix": "OTP_DATA_KEY2"
    },
    {
        "crit": false,
        "description": "Bits 47:32 of OTP access key 2 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_KEY2_2",
        "redundancy": 1,
        "row": 3922,
        "seq_index": 2,
        "seq_length": 8,
        "seq_prefix": "OTP_DATA_KEY2"
    },
    {
        "crit": false,
        "description": "Bits 63:48 of OTP access key 2 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_KEY2_3",
        "redundancy": 1,
        "row": 3923,
        "seq_index": 3,
        "seq_length": 8,
        "seq_prefix": "OTP_DATA_KEY2"
    },
    {
        "crit": false,
        "description": "Bits 79:64 of OTP access key 2 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_KEY2_4",
        "redundancy": 1,
        "row": 3924,
        "seq_index": 4,
        "seq_length": 8,
        "seq_prefix": "OTP_DATA_KEY2"
    },
    {
        "crit": false,
        "description": "Bits 95:80 of OTP access key 2 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_KEY2_5",
        "redundancy": 1,
        "row": 3925,
        "seq_index": 5,
        "seq_length": 8,
        "seq_prefix": "OTP_DATA_KEY2"
    },
    {
        "crit": false,
        "description": "Bits 111:96 of OTP access key 2 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_KEY2_6",
        "redundancy": 1,
        "row": 3926,
        "seq_index": 6,
        "seq_length": 8,
        "seq_prefix": "OTP_DATA_KEY2"
    },
    {
        "crit": false,
        "description": "Bits 127:112 of OTP access key 2 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_KEY2_7",
        "redundancy": 1,
        "row": 3927,
        "seq_index": 7,
        "seq_length": 8,
        "seq_prefix": "OTP_DATA_KEY2"
    },
    {
        "crit": false,
        "description": "Valid flag for key 2. Once the valid flag is set, the key can no longer be read or written, and becomes a valid fixed key for protecting OTP pages.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of VALID, with 3-way majority vote",
                "mask": 65536,
                "name": "VALID_R2"
            },
            {
                "description": "Redundant copy of VALID, with 3-way majority vote",
                "mask": 256,
                "name": "VALID_R1"
            },
            {
                "description": "",
                "mask": 1,
                "name": "VALID"
            }
        ],
        "mask": 65793,
        "name": "OTP_DATA_KEY2_VALID",
        "redundancy": 1,
        "row": 3962,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Bits 15:0 of OTP access key 3 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_KEY3_0",
        "redundancy": 1,
        "row": 3928,
        "seq_index": 0,
        "seq_length": 8,
        "seq_prefix": "OTP_DATA_KEY3"
    },
    {
        "crit": false,
        "description": "Bits 31:16 of OTP access key 3 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_KEY3_1",
        "redundancy": 1,
        "row": 3929,
        "seq_index": 1,
        "seq_length": 8,
        "seq_prefix": "OTP_DATA_KEY3"
    },
    {
        "crit": false,
        "description": "Bits 47:32 of OTP access key 3 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_KEY3_2",
        "redundancy": 1,
        "row": 3930,
        "seq_index": 2,
        "seq_length": 8,
        "seq_prefix": "OTP_DATA_KEY3"
    },
    {
        "crit": false,
        "description": "Bits 63:48 of OTP access key 3 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_KEY3_3",
        "redundancy": 1,
        "row": 3931,
        "seq_index": 3,
        "seq_length": 8,
        "seq_prefix": "OTP_DATA_KEY3"
    },
    {
        "crit": false,
        "description": "Bits 79:64 of OTP access key 3 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_KEY3_4",
        "redundancy": 1,
        "row": 3932,
        "seq_index": 4,
        "seq_length": 8,
        "seq_prefix": "OTP_DATA_KEY3"
    },
    {
        "crit": false,
        "description": "Bits 95:80 of OTP access key 3 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_KEY3_5",
        "redundancy": 1,
        "row": 3933,
        "seq_index": 5,
        "seq_length": 8,
        "seq_prefix": "OTP_DATA_KEY3"
    },
    {
        "crit": false,
        "description": "Bits 111:96 of OTP access key 3 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_KEY3_6",
        "redundancy": 1,
        "row": 3934,
        "seq_index": 6,
        "seq_length": 8,
        "seq_prefix": "OTP_DATA_KEY3"
    },
    {
        "crit": false,
        "description": "Bits 127:112 of OTP access key 3 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_KEY3_7",
        "redundancy": 1,
        "row": 3935,
        "seq_index": 7,
        "seq_length": 8,
        "seq_prefix": "OTP_DATA_KEY3"
    },
    {
        "crit": false,
        "description": "Valid flag for key 3. Once the valid flag is set, the key can no longer be read or written, and becomes a valid fixed key for protecting OTP pages.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of VALID, with 3-way majority vote",
                "mask": 65536,
                "name": "VALID_R2"
            },
            {
                "description": "Redundant copy of VALID, with 3-way majority vote",
                "mask": 256,
                "name": "VALID_R1"
            },
            {
                "description": "",
                "mask": 1,
                "name": "VALID"
            }
        ],
        "mask": 65793,
        "name": "OTP_DATA_KEY3_VALID",
        "redundancy": 1,
        "row": 3963,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Bits 15:0 of OTP access key 4 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_KEY4_0",
        "redundancy": 1,
        "row": 3936,
        "seq_index": 0,
        "seq_length": 8,
        "seq_prefix": "OTP_DATA_KEY4"
    },
    {
        "crit": false,
        "description": "Bits 31:16 of OTP access key 4 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_KEY4_1",
        "redundancy": 1,
        "row": 3937,
        "seq_index": 1,
        "seq_length": 8,
        "seq_prefix": "OTP_DATA_KEY4"
    },
    {
        "crit": false,
        "description": "Bits 47:32 of OTP access key 4 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_KEY4_2",
        "redundancy": 1,
        "row": 3938,
        "seq_index": 2,
        "seq_length": 8,
        "seq_prefix": "OTP_DATA_KEY4"
    },
    {
        "crit": false,
        "description": "Bits 63:48 of OTP access key 4 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_KEY4_3",
        "redundancy": 1,
        "row": 3939,
        "seq_index": 3,
        "seq_length": 8,
        "seq_prefix": "OTP_DATA_KEY4"
    },
    {
        "crit": false,
        "description": "Bits 79:64 of OTP access key 4 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_KEY4_4",
        "redundancy": 1,
        "row": 3940,
        "seq_index": 4,
        "seq_length": 8,
        "seq_prefix": "OTP_DATA_KEY4"
    },
    {
        "crit": false,
        "description": "Bits 95:80 of OTP access key 4 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_KEY4_5",
        "redundancy": 1,
        "row": 3941,
        "seq_index": 5,
        "seq_length": 8,
        "seq_prefix": "OTP_DATA_KEY4"
    },
    {
        "crit": false,
        "description": "Bits 111:96 of OTP access key 4 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_KEY4_6",
        "redundancy": 1,
        "row": 3942,
        "seq_index": 6,
        "seq_length": 8,
        "seq_prefix": "OTP_DATA_KEY4"
    },
    {
        "crit": false,
        "description": "Bits 127:112 of OTP access key 4 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_KEY4_7",
        "redundancy": 1,
        "row": 3943,
        "seq_index": 7,
        "seq_length": 8,
        "seq_prefix": "OTP_DATA_KEY4"
    },
    {
        "crit": false,
        "description": "Valid flag for key 4. Once the valid flag is set, the key can no longer be read or written, and becomes a valid fixed key for protecting OTP pages.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of VALID, with 3-way majority vote",
                "mask": 65536,
                "name": "VALID_R2"
            },
            {
                "description": "Redundant copy of VALID, with 3-way majority vote",
                "mask": 256,
                "name": "VALID_R1"
            },
            {
                "description": "",
                "mask": 1,
                "name": "VALID"
            }
        ],
        "mask": 65793,
        "name": "OTP_DATA_KEY4_VALID",
        "redundancy": 1,
        "row": 3964,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Bits 15:0 of OTP access key 5 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_KEY5_0",
        "redundancy": 1,
        "row": 3944,
        "seq_index": 0,
        "seq_length": 8,
        "seq_prefix": "OTP_DATA_KEY5"
    },
    {
        "crit": false,
        "description": "Bits 31:16 of OTP access key 5 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_KEY5_1",
        "redundancy": 1,
        "row": 3945,
        "seq_index": 1,
        "seq_length": 8,
        "seq_prefix": "OTP_DATA_KEY5"
    },
    {
        "crit": false,
        "description": "Bits 47:32 of OTP access key 5 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_KEY5_2",
        "redundancy": 1,
        "row": 3946,
        "seq_index": 2,
        "seq_length": 8,
        "seq_prefix": "OTP_DATA_KEY5"
    },
    {
        "crit": false,
        "description": "Bits 63:48 of OTP access key 5 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_KEY5_3",
        "redundancy": 1,
        "row": 3947,
        "seq_index": 3,
        "seq_length": 8,
        "seq_prefix": "OTP_DATA_KEY5"
    },
    {
        "crit": false,
        "description": "Bits 79:64 of OTP access key 5 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_KEY5_4",
        "redundancy": 1,
        "row": 3948,
        "seq_index": 4,
        "seq_length": 8,
        "seq_prefix": "OTP_DATA_KEY5"
    },
    {
        "crit": false,
        "description": "Bits 95:80 of OTP access key 5 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_KEY5_5",
        "redundancy": 1,
        "row": 3949,
        "seq_index": 5,
        "seq_length": 8,
        "seq_prefix": "OTP_DATA_KEY5"
    },
    {
        "crit": false,
        "description": "Bits 111:96 of OTP access key 5 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_KEY5_6",
        "redundancy": 1,
        "row": 3950,
        "seq_index": 6,
        "seq_length": 8,
        "seq_prefix": "OTP_DATA_KEY5"
    },
    {
        "crit": false,
        "description": "Bits 127:112 of OTP access key 5 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_KEY5_7",
        "redundancy": 1,
        "row": 3951,
        "seq_index": 7,
        "seq_length": 8,
        "seq_prefix": "OTP_DATA_KEY5"
    },
    {
        "crit": false,
        "description": "Valid flag for key 5. Once the valid flag is set, the key can no longer be read or written, and becomes a valid fixed key for protecting OTP pages.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of VALID, with 3-way majority vote",
                "mask": 65536,
                "name": "VALID_R2"
            },
            {
                "description": "Redundant copy of VALID, with 3-way majority vote",
                "mask": 256,
                "name": "VALID_R1"
            },
            {
                "description": "",
                "mask": 1,
                "name": "VALID"
            }
        ],
        "mask": 65793,
        "name": "OTP_DATA_KEY5_VALID",
        "redundancy": 1,
        "row": 3965,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Bits 15:0 of OTP access key 6 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_KEY6_0",
        "redundancy": 1,
        "row": 3952,
        "seq_index": 0,
        "seq_length": 8,
        "seq_prefix": "OTP_DATA_KEY6"
    },
    {
        "crit": false,
        "description": "Bits 31:16 of OTP access key 6 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_KEY6_1",
        "redundancy": 1,
        "row": 3953,
        "seq_index": 1,
        "seq_length": 8,
        "seq_prefix": "OTP_DATA_KEY6"
    },
    {
        "crit": false,
        "description": "Bits 47:32 of OTP access key 6 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_KEY6_2",
        "redundancy": 1,
        "row": 3954,
        "seq_index": 2,
        "seq_length": 8,
        "seq_prefix": "OTP_DATA_KEY6"
    },
    {
        "crit": false,
        "description": "Bits 63:48 of OTP access key 6 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_KEY6_3",
        "redundancy": 1,
        "row": 3955,
        "seq_index": 3,
        "seq_length": 8,
        "seq_prefix": "OTP_DATA_KEY6"
    },
    {
        "crit": false,
        "description": "Bits 79:64 of OTP access key 6 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_KEY6_4",
        "redundancy": 1,
        "row": 3956,
        "seq_index": 4,
        "seq_length": 8,
        "seq_prefix": "OTP_DATA_KEY6"
    },
    {
        "crit": false,
        "description": "Bits 95:80 of OTP access key 6 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_KEY6_5",
        "redundancy": 1,
        "row": 3957,
        "seq_index": 5,
        "seq_length": 8,
        "seq_prefix": "OTP_DATA_KEY6"
    },
    {
        "crit": false,
        "description": "Bits 111:96 of OTP access key 6 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_KEY6_6",
        "redundancy": 1,
        "row": 3958,
        "seq_index": 6,
        "seq_length": 8,
        "seq_prefix": "OTP_DATA_KEY6"
    },
    {
        "crit": false,
        "description": "Bits 127:112 of OTP access key 6 (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_KEY6_7",
        "redundancy": 1,
        "row": 3959,
        "seq_index": 7,
        "seq_length": 8,
        "seq_prefix": "OTP_DATA_KEY6"
    },
    {
        "crit": false,
        "description": "Valid flag for key 6. Once the valid flag is set, the key can no longer be read or written, and becomes a valid fixed key for protecting OTP pages.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of VALID, with 3-way majority vote",
                "mask": 65536,
                "name": "VALID_R2"
            },
            {
                "description": "Redundant copy of VALID, with 3-way majority vote",
                "mask": 256,
                "name": "VALID_R1"
            },
            {
                "description": "",
                "mask": 1,
                "name": "VALID"
            }
        ],
        "mask": 65793,
        "name": "OTP_DATA_KEY6_VALID",
        "redundancy": 1,
        "row": 3966,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Low-power oscillator frequency in Hz, measured during manufacturing (ECC) This is measured at 1.1V, at room temperature, with the LPOSC trim register in its reset state.",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_LPOSC_CALIB",
        "redundancy": 1,
        "row": 17,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "The number of main user GPIOs (bank 0). Should read 48 in the QFN80 package, and 30 in the QFN60 package. (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 255,
        "name": "OTP_DATA_NUM_GPIOS",
        "redundancy": 1,
        "row": 24,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Bits 15:0 of the OTP boot image load destination (and entry point). (ECC) This must be a location in main SRAM (main SRAM is addresses 0x20000000 through 0x20082000) and must be word-aligned.",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_OTPBOOT_DST0",
        "redundancy": 1,
        "row": 96,
        "seq_index": 0,
        "seq_length": 2,
        "seq_prefix": "OTP_DATA_OTPBOOT_DST"
    },
    {
        "crit": false,
        "description": "Bits 31:16 of the OTP boot image load destination (and entry point). (ECC) This must be a location in main SRAM (main SRAM is addresses 0x20000000 through 0x20082000) and must be word-aligned.",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_OTPBOOT_DST1",
        "redundancy": 1,
        "row": 97,
        "seq_index": 1,
        "seq_length": 2,
        "seq_prefix": "OTP_DATA_OTPBOOT_DST"
    },
    {
        "crit": false,
        "description": "Length in rows of the OTP boot image. (ECC) OTPBOOT_LEN must be even. The total image size must be a multiple of 4 bytes (32 bits).",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_OTPBOOT_LEN",
        "redundancy": 1,
        "row": 95,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "OTP start row for the OTP boot image. (ECC) If OTP boot is enabled, the bootrom will load from this location into SRAM and then directly enter the loaded image. Note that the image must be signed if SECURE_BOOT_ENABLE is set. The image itself is assumed to be ECC-protected. This must be an even number. Equivalently, the OTP boot image must start at a word-aligned location in the ECC read data address window.",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_OTPBOOT_SRC",
        "redundancy": 1,
        "row": 94,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration LSBs for page 0 (rows 0x0 through 0x3f). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "State when at least one key is registered for this page and no matching key has been entered. 0x0 -> read_only 0x1 -> inaccessible",
                "mask": 64,
                "name": "NO_KEY_STATE"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant read access, or 0 if no such key is required.",
                "mask": 56,
                "name": "KEY_R"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant write access, or 0 if no such key is required.",
                "mask": 7,
                "name": "KEY_W"
            }
        ],
        "mask": 16777087,
        "name": "OTP_DATA_PAGE0_LOCK0",
        "redundancy": 1,
        "row": 3968,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration MSBs for page 0 (rows 0x0 through 0x3f). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "Dummy lock bits reserved for bootloaders (including the RP2350 USB bootloader) to store their own OTP access permissions. No hardware effect, and no corresponding SW_LOCKx registers. 0x0 -> Bootloader permits user reads and writes to this page 0x1 -> Bootloader permits user reads of this page 0x2 -> Do not use. Behaves the same as INACCESSIBLE 0x3 -> Bootloader does not permit user access to this page",
                "mask": 48,
                "name": "LOCK_BL"
            },
            {
                "description": "Lock state for Non-secure accesses to this page. Thermometer- coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. Note that READ_WRITE and READ_ONLY are equivalent in hardware, as the SBPI programming interface is not accessible to Non- secure software. However, Secure software may check these bits to apply write permissions to a Non-secure OTP programming API. 0x0 -> Page can be read by Non-secure software, and Secure software may permit Non-secure writes. 0x1 -> Page can be read by Non-secure software 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Non-secure software.",
                "mask": 12,
                "name": "LOCK_NS"
            },
            {
                "description": "Lock state for Secure accesses to this page. Thermometer-coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. 0x0 -> Page is fully accessible by Secure software. 0x1 -> Page can be read by Secure software, but can not be written. 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Secure software.",
                "mask": 3,
                "name": "LOCK_S"
            }
        ],
        "mask": 16777023,
        "name": "OTP_DATA_PAGE0_LOCK1",
        "redundancy": 1,
        "row": 3969,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration LSBs for page 10 (rows 0x280 through 0x2bf). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "State when at least one key is registered for this page and no matching key has been entered. 0x0 -> read_only 0x1 -> inaccessible",
                "mask": 64,
                "name": "NO_KEY_STATE"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant read access, or 0 if no such key is required.",
                "mask": 56,
                "name": "KEY_R"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant write access, or 0 if no such key is required.",
                "mask": 7,
                "name": "KEY_W"
            }
        ],
        "mask": 16777087,
        "name": "OTP_DATA_PAGE10_LOCK0",
        "redundancy": 1,
        "row": 3988,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration MSBs for page 10 (rows 0x280 through 0x2bf). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "Dummy lock bits reserved for bootloaders (including the RP2350 USB bootloader) to store their own OTP access permissions. No hardware effect, and no corresponding SW_LOCKx registers. 0x0 -> Bootloader permits user reads and writes to this page 0x1 -> Bootloader permits user reads of this page 0x2 -> Do not use. Behaves the same as INACCESSIBLE 0x3 -> Bootloader does not permit user access to this page",
                "mask": 48,
                "name": "LOCK_BL"
            },
            {
                "description": "Lock state for Non-secure accesses to this page. Thermometer- coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. Note that READ_WRITE and READ_ONLY are equivalent in hardware, as the SBPI programming interface is not accessible to Non- secure software. However, Secure software may check these bits to apply write permissions to a Non-secure OTP programming API. 0x0 -> Page can be read by Non-secure software, and Secure software may permit Non-secure writes. 0x1 -> Page can be read by Non-secure software 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Non-secure software.",
                "mask": 12,
                "name": "LOCK_NS"
            },
            {
                "description": "Lock state for Secure accesses to this page. Thermometer-coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. 0x0 -> Page is fully accessible by Secure software. 0x1 -> Page can be read by Secure software, but can not be written. 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Secure software.",
                "mask": 3,
                "name": "LOCK_S"
            }
        ],
        "mask": 16777023,
        "name": "OTP_DATA_PAGE10_LOCK1",
        "redundancy": 1,
        "row": 3989,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration LSBs for page 11 (rows 0x2c0 through 0x2ff). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "State when at least one key is registered for this page and no matching key has been entered. 0x0 -> read_only 0x1 -> inaccessible",
                "mask": 64,
                "name": "NO_KEY_STATE"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant read access, or 0 if no such key is required.",
                "mask": 56,
                "name": "KEY_R"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant write access, or 0 if no such key is required.",
                "mask": 7,
                "name": "KEY_W"
            }
        ],
        "mask": 16777087,
        "name": "OTP_DATA_PAGE11_LOCK0",
        "redundancy": 1,
        "row": 3990,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration MSBs for page 11 (rows 0x2c0 through 0x2ff). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "Dummy lock bits reserved for bootloaders (including the RP2350 USB bootloader) to store their own OTP access permissions. No hardware effect, and no corresponding SW_LOCKx registers. 0x0 -> Bootloader permits user reads and writes to this page 0x1 -> Bootloader permits user reads of this page 0x2 -> Do not use. Behaves the same as INACCESSIBLE 0x3 -> Bootloader does not permit user access to this page",
                "mask": 48,
                "name": "LOCK_BL"
            },
            {
                "description": "Lock state for Non-secure accesses to this page. Thermometer- coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. Note that READ_WRITE and READ_ONLY are equivalent in hardware, as the SBPI programming interface is not accessible to Non- secure software. However, Secure software may check these bits to apply write permissions to a Non-secure OTP programming API. 0x0 -> Page can be read by Non-secure software, and Secure software may permit Non-secure writes. 0x1 -> Page can be read by Non-secure software 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Non-secure software.",
                "mask": 12,
                "name": "LOCK_NS"
            },
            {
                "description": "Lock state for Secure accesses to this page. Thermometer-coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. 0x0 -> Page is fully accessible by Secure software. 0x1 -> Page can be read by Secure software, but can not be written. 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Secure software.",
                "mask": 3,
                "name": "LOCK_S"
            }
        ],
        "mask": 16777023,
        "name": "OTP_DATA_PAGE11_LOCK1",
        "redundancy": 1,
        "row": 3991,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration LSBs for page 12 (rows 0x300 through 0x33f). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "State when at least one key is registered for this page and no matching key has been entered. 0x0 -> read_only 0x1 -> inaccessible",
                "mask": 64,
                "name": "NO_KEY_STATE"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant read access, or 0 if no such key is required.",
                "mask": 56,
                "name": "KEY_R"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant write access, or 0 if no such key is required.",
                "mask": 7,
                "name": "KEY_W"
            }
        ],
        "mask": 16777087,
        "name": "OTP_DATA_PAGE12_LOCK0",
        "redundancy": 1,
        "row": 3992,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration MSBs for page 12 (rows 0x300 through 0x33f). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "Dummy lock bits reserved for bootloaders (including the RP2350 USB bootloader) to store their own OTP access permissions. No hardware effect, and no corresponding SW_LOCKx registers. 0x0 -> Bootloader permits user reads and writes to this page 0x1 -> Bootloader permits user reads of this page 0x2 -> Do not use. Behaves the same as INACCESSIBLE 0x3 -> Bootloader does not permit user access to this page",
                "mask": 48,
                "name": "LOCK_BL"
            },
            {
                "description": "Lock state for Non-secure accesses to this page. Thermometer- coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. Note that READ_WRITE and READ_ONLY are equivalent in hardware, as the SBPI programming interface is not accessible to Non- secure software. However, Secure software may check these bits to apply write permissions to a Non-secure OTP programming API. 0x0 -> Page can be read by Non-secure software, and Secure software may permit Non-secure writes. 0x1 -> Page can be read by Non-secure software 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Non-secure software.",
                "mask": 12,
                "name": "LOCK_NS"
            },
            {
                "description": "Lock state for Secure accesses to this page. Thermometer-coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. 0x0 -> Page is fully accessible by Secure software. 0x1 -> Page can be read by Secure software, but can not be written. 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Secure software.",
                "mask": 3,
                "name": "LOCK_S"
            }
        ],
        "mask": 16777023,
        "name": "OTP_DATA_PAGE12_LOCK1",
        "redundancy": 1,
        "row": 3993,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration LSBs for page 13 (rows 0x340 through 0x37f). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "State when at least one key is registered for this page and no matching key has been entered. 0x0 -> read_only 0x1 -> inaccessible",
                "mask": 64,
                "name": "NO_KEY_STATE"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant read access, or 0 if no such key is required.",
                "mask": 56,
                "name": "KEY_R"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant write access, or 0 if no such key is required.",
                "mask": 7,
                "name": "KEY_W"
            }
        ],
        "mask": 16777087,
        "name": "OTP_DATA_PAGE13_LOCK0",
        "redundancy": 1,
        "row": 3994,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration MSBs for page 13 (rows 0x340 through 0x37f). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "Dummy lock bits reserved for bootloaders (including the RP2350 USB bootloader) to store their own OTP access permissions. No hardware effect, and no corresponding SW_LOCKx registers. 0x0 -> Bootloader permits user reads and writes to this page 0x1 -> Bootloader permits user reads of this page 0x2 -> Do not use. Behaves the same as INACCESSIBLE 0x3 -> Bootloader does not permit user access to this page",
                "mask": 48,
                "name": "LOCK_BL"
            },
            {
                "description": "Lock state for Non-secure accesses to this page. Thermometer- coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. Note that READ_WRITE and READ_ONLY are equivalent in hardware, as the SBPI programming interface is not accessible to Non- secure software. However, Secure software may check these bits to apply write permissions to a Non-secure OTP programming API. 0x0 -> Page can be read by Non-secure software, and Secure software may permit Non-secure writes. 0x1 -> Page can be read by Non-secure software 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Non-secure software.",
                "mask": 12,
                "name": "LOCK_NS"
            },
            {
                "description": "Lock state for Secure accesses to this page. Thermometer-coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. 0x0 -> Page is fully accessible by Secure software. 0x1 -> Page can be read by Secure software, but can not be written. 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Secure software.",
                "mask": 3,
                "name": "LOCK_S"
            }
        ],
        "mask": 16777023,
        "name": "OTP_DATA_PAGE13_LOCK1",
        "redundancy": 1,
        "row": 3995,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration LSBs for page 14 (rows 0x380 through 0x3bf). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "State when at least one key is registered for this page and no matching key has been entered. 0x0 -> read_only 0x1 -> inaccessible",
                "mask": 64,
                "name": "NO_KEY_STATE"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant read access, or 0 if no such key is required.",
                "mask": 56,
                "name": "KEY_R"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant write access, or 0 if no such key is required.",
                "mask": 7,
                "name": "KEY_W"
            }
        ],
        "mask": 16777087,
        "name": "OTP_DATA_PAGE14_LOCK0",
        "redundancy": 1,
        "row": 3996,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration MSBs for page 14 (rows 0x380 through 0x3bf). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "Dummy lock bits reserved for bootloaders (including the RP2350 USB bootloader) to store their own OTP access permissions. No hardware effect, and no corresponding SW_LOCKx registers. 0x0 -> Bootloader permits user reads and writes to this page 0x1 -> Bootloader permits user reads of this page 0x2 -> Do not use. Behaves the same as INACCESSIBLE 0x3 -> Bootloader does not permit user access to this page",
                "mask": 48,
                "name": "LOCK_BL"
            },
            {
                "description": "Lock state for Non-secure accesses to this page. Thermometer- coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. Note that READ_WRITE and READ_ONLY are equivalent in hardware, as the SBPI programming interface is not accessible to Non- secure software. However, Secure software may check these bits to apply write permissions to a Non-secure OTP programming API. 0x0 -> Page can be read by Non-secure software, and Secure software may permit Non-secure writes. 0x1 -> Page can be read by Non-secure software 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Non-secure software.",
                "mask": 12,
                "name": "LOCK_NS"
            },
            {
                "description": "Lock state for Secure accesses to this page. Thermometer-coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. 0x0 -> Page is fully accessible by Secure software. 0x1 -> Page can be read by Secure software, but can not be written. 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Secure software.",
                "mask": 3,
                "name": "LOCK_S"
            }
        ],
        "mask": 16777023,
        "name": "OTP_DATA_PAGE14_LOCK1",
        "redundancy": 1,
        "row": 3997,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration LSBs for page 15 (rows 0x3c0 through 0x3ff). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "State when at least one key is registered for this page and no matching key has been entered. 0x0 -> read_only 0x1 -> inaccessible",
                "mask": 64,
                "name": "NO_KEY_STATE"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant read access, or 0 if no such key is required.",
                "mask": 56,
                "name": "KEY_R"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant write access, or 0 if no such key is required.",
                "mask": 7,
                "name": "KEY_W"
            }
        ],
        "mask": 16777087,
        "name": "OTP_DATA_PAGE15_LOCK0",
        "redundancy": 1,
        "row": 3998,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration MSBs for page 15 (rows 0x3c0 through 0x3ff). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "Dummy lock bits reserved for bootloaders (including the RP2350 USB bootloader) to store their own OTP access permissions. No hardware effect, and no corresponding SW_LOCKx registers. 0x0 -> Bootloader permits user reads and writes to this page 0x1 -> Bootloader permits user reads of this page 0x2 -> Do not use. Behaves the same as INACCESSIBLE 0x3 -> Bootloader does not permit user access to this page",
                "mask": 48,
                "name": "LOCK_BL"
            },
            {
                "description": "Lock state for Non-secure accesses to this page. Thermometer- coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. Note that READ_WRITE and READ_ONLY are equivalent in hardware, as the SBPI programming interface is not accessible to Non- secure software. However, Secure software may check these bits to apply write permissions to a Non-secure OTP programming API. 0x0 -> Page can be read by Non-secure software, and Secure software may permit Non-secure writes. 0x1 -> Page can be read by Non-secure software 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Non-secure software.",
                "mask": 12,
                "name": "LOCK_NS"
            },
            {
                "description": "Lock state for Secure accesses to this page. Thermometer-coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. 0x0 -> Page is fully accessible by Secure software. 0x1 -> Page can be read by Secure software, but can not be written. 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Secure software.",
                "mask": 3,
                "name": "LOCK_S"
            }
        ],
        "mask": 16777023,
        "name": "OTP_DATA_PAGE15_LOCK1",
        "redundancy": 1,
        "row": 3999,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration LSBs for page 16 (rows 0x400 through 0x43f). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "State when at least one key is registered for this page and no matching key has been entered. 0x0 -> read_only 0x1 -> inaccessible",
                "mask": 64,
                "name": "NO_KEY_STATE"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant read access, or 0 if no such key is required.",
                "mask": 56,
                "name": "KEY_R"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant write access, or 0 if no such key is required.",
                "mask": 7,
                "name": "KEY_W"
            }
        ],
        "mask": 16777087,
        "name": "OTP_DATA_PAGE16_LOCK0",
        "redundancy": 1,
        "row": 4000,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration MSBs for page 16 (rows 0x400 through 0x43f). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "Dummy lock bits reserved for bootloaders (including the RP2350 USB bootloader) to store their own OTP access permissions. No hardware effect, and no corresponding SW_LOCKx registers. 0x0 -> Bootloader permits user reads and writes to this page 0x1 -> Bootloader permits user reads of this page 0x2 -> Do not use. Behaves the same as INACCESSIBLE 0x3 -> Bootloader does not permit user access to this page",
                "mask": 48,
                "name": "LOCK_BL"
            },
            {
                "description": "Lock state for Non-secure accesses to this page. Thermometer- coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. Note that READ_WRITE and READ_ONLY are equivalent in hardware, as the SBPI programming interface is not accessible to Non- secure software. However, Secure software may check these bits to apply write permissions to a Non-secure OTP programming API. 0x0 -> Page can be read by Non-secure software, and Secure software may permit Non-secure writes. 0x1 -> Page can be read by Non-secure software 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Non-secure software.",
                "mask": 12,
                "name": "LOCK_NS"
            },
            {
                "description": "Lock state for Secure accesses to this page. Thermometer-coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. 0x0 -> Page is fully accessible by Secure software. 0x1 -> Page can be read by Secure software, but can not be written. 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Secure software.",
                "mask": 3,
                "name": "LOCK_S"
            }
        ],
        "mask": 16777023,
        "name": "OTP_DATA_PAGE16_LOCK1",
        "redundancy": 1,
        "row": 4001,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration LSBs for page 17 (rows 0x440 through 0x47f). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "State when at least one key is registered for this page and no matching key has been entered. 0x0 -> read_only 0x1 -> inaccessible",
                "mask": 64,
                "name": "NO_KEY_STATE"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant read access, or 0 if no such key is required.",
                "mask": 56,
                "name": "KEY_R"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant write access, or 0 if no such key is required.",
                "mask": 7,
                "name": "KEY_W"
            }
        ],
        "mask": 16777087,
        "name": "OTP_DATA_PAGE17_LOCK0",
        "redundancy": 1,
        "row": 4002,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration MSBs for page 17 (rows 0x440 through 0x47f). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "Dummy lock bits reserved for bootloaders (including the RP2350 USB bootloader) to store their own OTP access permissions. No hardware effect, and no corresponding SW_LOCKx registers. 0x0 -> Bootloader permits user reads and writes to this page 0x1 -> Bootloader permits user reads of this page 0x2 -> Do not use. Behaves the same as INACCESSIBLE 0x3 -> Bootloader does not permit user access to this page",
                "mask": 48,
                "name": "LOCK_BL"
            },
            {
                "description": "Lock state for Non-secure accesses to this page. Thermometer- coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. Note that READ_WRITE and READ_ONLY are equivalent in hardware, as the SBPI programming interface is not accessible to Non- secure software. However, Secure software may check these bits to apply write permissions to a Non-secure OTP programming API. 0x0 -> Page can be read by Non-secure software, and Secure software may permit Non-secure writes. 0x1 -> Page can be read by Non-secure software 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Non-secure software.",
                "mask": 12,
                "name": "LOCK_NS"
            },
            {
                "description": "Lock state for Secure accesses to this page. Thermometer-coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. 0x0 -> Page is fully accessible by Secure software. 0x1 -> Page can be read by Secure software, but can not be written. 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Secure software.",
                "mask": 3,
                "name": "LOCK_S"
            }
        ],
        "mask": 16777023,
        "name": "OTP_DATA_PAGE17_LOCK1",
        "redundancy": 1,
        "row": 4003,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration LSBs for page 18 (rows 0x480 through 0x4bf). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "State when at least one key is registered for this page and no matching key has been entered. 0x0 -> read_only 0x1 -> inaccessible",
                "mask": 64,
                "name": "NO_KEY_STATE"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant read access, or 0 if no such key is required.",
                "mask": 56,
                "name": "KEY_R"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant write access, or 0 if no such key is required.",
                "mask": 7,
                "name": "KEY_W"
            }
        ],
        "mask": 16777087,
        "name": "OTP_DATA_PAGE18_LOCK0",
        "redundancy": 1,
        "row": 4004,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration MSBs for page 18 (rows 0x480 through 0x4bf). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "Dummy lock bits reserved for bootloaders (including the RP2350 USB bootloader) to store their own OTP access permissions. No hardware effect, and no corresponding SW_LOCKx registers. 0x0 -> Bootloader permits user reads and writes to this page 0x1 -> Bootloader permits user reads of this page 0x2 -> Do not use. Behaves the same as INACCESSIBLE 0x3 -> Bootloader does not permit user access to this page",
                "mask": 48,
                "name": "LOCK_BL"
            },
            {
                "description": "Lock state for Non-secure accesses to this page. Thermometer- coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. Note that READ_WRITE and READ_ONLY are equivalent in hardware, as the SBPI programming interface is not accessible to Non- secure software. However, Secure software may check these bits to apply write permissions to a Non-secure OTP programming API. 0x0 -> Page can be read by Non-secure software, and Secure software may permit Non-secure writes. 0x1 -> Page can be read by Non-secure software 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Non-secure software.",
                "mask": 12,
                "name": "LOCK_NS"
            },
            {
                "description": "Lock state for Secure accesses to this page. Thermometer-coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. 0x0 -> Page is fully accessible by Secure software. 0x1 -> Page can be read by Secure software, but can not be written. 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Secure software.",
                "mask": 3,
                "name": "LOCK_S"
            }
        ],
        "mask": 16777023,
        "name": "OTP_DATA_PAGE18_LOCK1",
        "redundancy": 1,
        "row": 4005,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration LSBs for page 19 (rows 0x4c0 through 0x4ff). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "State when at least one key is registered for this page and no matching key has been entered. 0x0 -> read_only 0x1 -> inaccessible",
                "mask": 64,
                "name": "NO_KEY_STATE"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant read access, or 0 if no such key is required.",
                "mask": 56,
                "name": "KEY_R"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant write access, or 0 if no such key is required.",
                "mask": 7,
                "name": "KEY_W"
            }
        ],
        "mask": 16777087,
        "name": "OTP_DATA_PAGE19_LOCK0",
        "redundancy": 1,
        "row": 4006,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration MSBs for page 19 (rows 0x4c0 through 0x4ff). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "Dummy lock bits reserved for bootloaders (including the RP2350 USB bootloader) to store their own OTP access permissions. No hardware effect, and no corresponding SW_LOCKx registers. 0x0 -> Bootloader permits user reads and writes to this page 0x1 -> Bootloader permits user reads of this page 0x2 -> Do not use. Behaves the same as INACCESSIBLE 0x3 -> Bootloader does not permit user access to this page",
                "mask": 48,
                "name": "LOCK_BL"
            },
            {
                "description": "Lock state for Non-secure accesses to this page. Thermometer- coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. Note that READ_WRITE and READ_ONLY are equivalent in hardware, as the SBPI programming interface is not accessible to Non- secure software. However, Secure software may check these bits to apply write permissions to a Non-secure OTP programming API. 0x0 -> Page can be read by Non-secure software, and Secure software may permit Non-secure writes. 0x1 -> Page can be read by Non-secure software 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Non-secure software.",
                "mask": 12,
                "name": "LOCK_NS"
            },
            {
                "description": "Lock state for Secure accesses to this page. Thermometer-coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. 0x0 -> Page is fully accessible by Secure software. 0x1 -> Page can be read by Secure software, but can not be written. 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Secure software.",
                "mask": 3,
                "name": "LOCK_S"
            }
        ],
        "mask": 16777023,
        "name": "OTP_DATA_PAGE19_LOCK1",
        "redundancy": 1,
        "row": 4007,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration LSBs for page 1 (rows 0x40 through 0x7f). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "State when at least one key is registered for this page and no matching key has been entered. 0x0 -> read_only 0x1 -> inaccessible",
                "mask": 64,
                "name": "NO_KEY_STATE"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant read access, or 0 if no such key is required.",
                "mask": 56,
                "name": "KEY_R"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant write access, or 0 if no such key is required.",
                "mask": 7,
                "name": "KEY_W"
            }
        ],
        "mask": 16777087,
        "name": "OTP_DATA_PAGE1_LOCK0",
        "redundancy": 1,
        "row": 3970,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration MSBs for page 1 (rows 0x40 through 0x7f). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "Dummy lock bits reserved for bootloaders (including the RP2350 USB bootloader) to store their own OTP access permissions. No hardware effect, and no corresponding SW_LOCKx registers. 0x0 -> Bootloader permits user reads and writes to this page 0x1 -> Bootloader permits user reads of this page 0x2 -> Do not use. Behaves the same as INACCESSIBLE 0x3 -> Bootloader does not permit user access to this page",
                "mask": 48,
                "name": "LOCK_BL"
            },
            {
                "description": "Lock state for Non-secure accesses to this page. Thermometer- coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. Note that READ_WRITE and READ_ONLY are equivalent in hardware, as the SBPI programming interface is not accessible to Non- secure software. However, Secure software may check these bits to apply write permissions to a Non-secure OTP programming API. 0x0 -> Page can be read by Non-secure software, and Secure software may permit Non-secure writes. 0x1 -> Page can be read by Non-secure software 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Non-secure software.",
                "mask": 12,
                "name": "LOCK_NS"
            },
            {
                "description": "Lock state for Secure accesses to this page. Thermometer-coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. 0x0 -> Page is fully accessible by Secure software. 0x1 -> Page can be read by Secure software, but can not be written. 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Secure software.",
                "mask": 3,
                "name": "LOCK_S"
            }
        ],
        "mask": 16777023,
        "name": "OTP_DATA_PAGE1_LOCK1",
        "redundancy": 1,
        "row": 3971,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration LSBs for page 20 (rows 0x500 through 0x53f). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "State when at least one key is registered for this page and no matching key has been entered. 0x0 -> read_only 0x1 -> inaccessible",
                "mask": 64,
                "name": "NO_KEY_STATE"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant read access, or 0 if no such key is required.",
                "mask": 56,
                "name": "KEY_R"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant write access, or 0 if no such key is required.",
                "mask": 7,
                "name": "KEY_W"
            }
        ],
        "mask": 16777087,
        "name": "OTP_DATA_PAGE20_LOCK0",
        "redundancy": 1,
        "row": 4008,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration MSBs for page 20 (rows 0x500 through 0x53f). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "Dummy lock bits reserved for bootloaders (including the RP2350 USB bootloader) to store their own OTP access permissions. No hardware effect, and no corresponding SW_LOCKx registers. 0x0 -> Bootloader permits user reads and writes to this page 0x1 -> Bootloader permits user reads of this page 0x2 -> Do not use. Behaves the same as INACCESSIBLE 0x3 -> Bootloader does not permit user access to this page",
                "mask": 48,
                "name": "LOCK_BL"
            },
            {
                "description": "Lock state for Non-secure accesses to this page. Thermometer- coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. Note that READ_WRITE and READ_ONLY are equivalent in hardware, as the SBPI programming interface is not accessible to Non- secure software. However, Secure software may check these bits to apply write permissions to a Non-secure OTP programming API. 0x0 -> Page can be read by Non-secure software, and Secure software may permit Non-secure writes. 0x1 -> Page can be read by Non-secure software 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Non-secure software.",
                "mask": 12,
                "name": "LOCK_NS"
            },
            {
                "description": "Lock state for Secure accesses to this page. Thermometer-coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. 0x0 -> Page is fully accessible by Secure software. 0x1 -> Page can be read by Secure software, but can not be written. 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Secure software.",
                "mask": 3,
                "name": "LOCK_S"
            }
        ],
        "mask": 16777023,
        "name": "OTP_DATA_PAGE20_LOCK1",
        "redundancy": 1,
        "row": 4009,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration LSBs for page 21 (rows 0x540 through 0x57f). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "State when at least one key is registered for this page and no matching key has been entered. 0x0 -> read_only 0x1 -> inaccessible",
                "mask": 64,
                "name": "NO_KEY_STATE"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant read access, or 0 if no such key is required.",
                "mask": 56,
                "name": "KEY_R"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant write access, or 0 if no such key is required.",
                "mask": 7,
                "name": "KEY_W"
            }
        ],
        "mask": 16777087,
        "name": "OTP_DATA_PAGE21_LOCK0",
        "redundancy": 1,
        "row": 4010,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration MSBs for page 21 (rows 0x540 through 0x57f). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "Dummy lock bits reserved for bootloaders (including the RP2350 USB bootloader) to store their own OTP access permissions. No hardware effect, and no corresponding SW_LOCKx registers. 0x0 -> Bootloader permits user reads and writes to this page 0x1 -> Bootloader permits user reads of this page 0x2 -> Do not use. Behaves the same as INACCESSIBLE 0x3 -> Bootloader does not permit user access to this page",
                "mask": 48,
                "name": "LOCK_BL"
            },
            {
                "description": "Lock state for Non-secure accesses to this page. Thermometer- coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. Note that READ_WRITE and READ_ONLY are equivalent in hardware, as the SBPI programming interface is not accessible to Non- secure software. However, Secure software may check these bits to apply write permissions to a Non-secure OTP programming API. 0x0 -> Page can be read by Non-secure software, and Secure software may permit Non-secure writes. 0x1 -> Page can be read by Non-secure software 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Non-secure software.",
                "mask": 12,
                "name": "LOCK_NS"
            },
            {
                "description": "Lock state for Secure accesses to this page. Thermometer-coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. 0x0 -> Page is fully accessible by Secure software. 0x1 -> Page can be read by Secure software, but can not be written. 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Secure software.",
                "mask": 3,
                "name": "LOCK_S"
            }
        ],
        "mask": 16777023,
        "name": "OTP_DATA_PAGE21_LOCK1",
        "redundancy": 1,
        "row": 4011,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration LSBs for page 22 (rows 0x580 through 0x5bf). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "State when at least one key is registered for this page and no matching key has been entered. 0x0 -> read_only 0x1 -> inaccessible",
                "mask": 64,
                "name": "NO_KEY_STATE"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant read access, or 0 if no such key is required.",
                "mask": 56,
                "name": "KEY_R"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant write access, or 0 if no such key is required.",
                "mask": 7,
                "name": "KEY_W"
            }
        ],
        "mask": 16777087,
        "name": "OTP_DATA_PAGE22_LOCK0",
        "redundancy": 1,
        "row": 4012,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration MSBs for page 22 (rows 0x580 through 0x5bf). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "Dummy lock bits reserved for bootloaders (including the RP2350 USB bootloader) to store their own OTP access permissions. No hardware effect, and no corresponding SW_LOCKx registers. 0x0 -> Bootloader permits user reads and writes to this page 0x1 -> Bootloader permits user reads of this page 0x2 -> Do not use. Behaves the same as INACCESSIBLE 0x3 -> Bootloader does not permit user access to this page",
                "mask": 48,
                "name": "LOCK_BL"
            },
            {
                "description": "Lock state for Non-secure accesses to this page. Thermometer- coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. Note that READ_WRITE and READ_ONLY are equivalent in hardware, as the SBPI programming interface is not accessible to Non- secure software. However, Secure software may check these bits to apply write permissions to a Non-secure OTP programming API. 0x0 -> Page can be read by Non-secure software, and Secure software may permit Non-secure writes. 0x1 -> Page can be read by Non-secure software 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Non-secure software.",
                "mask": 12,
                "name": "LOCK_NS"
            },
            {
                "description": "Lock state for Secure accesses to this page. Thermometer-coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. 0x0 -> Page is fully accessible by Secure software. 0x1 -> Page can be read by Secure software, but can not be written. 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Secure software.",
                "mask": 3,
                "name": "LOCK_S"
            }
        ],
        "mask": 16777023,
        "name": "OTP_DATA_PAGE22_LOCK1",
        "redundancy": 1,
        "row": 4013,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration LSBs for page 23 (rows 0x5c0 through 0x5ff). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "State when at least one key is registered for this page and no matching key has been entered. 0x0 -> read_only 0x1 -> inaccessible",
                "mask": 64,
                "name": "NO_KEY_STATE"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant read access, or 0 if no such key is required.",
                "mask": 56,
                "name": "KEY_R"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant write access, or 0 if no such key is required.",
                "mask": 7,
                "name": "KEY_W"
            }
        ],
        "mask": 16777087,
        "name": "OTP_DATA_PAGE23_LOCK0",
        "redundancy": 1,
        "row": 4014,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration MSBs for page 23 (rows 0x5c0 through 0x5ff). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "Dummy lock bits reserved for bootloaders (including the RP2350 USB bootloader) to store their own OTP access permissions. No hardware effect, and no corresponding SW_LOCKx registers. 0x0 -> Bootloader permits user reads and writes to this page 0x1 -> Bootloader permits user reads of this page 0x2 -> Do not use. Behaves the same as INACCESSIBLE 0x3 -> Bootloader does not permit user access to this page",
                "mask": 48,
                "name": "LOCK_BL"
            },
            {
                "description": "Lock state for Non-secure accesses to this page. Thermometer- coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. Note that READ_WRITE and READ_ONLY are equivalent in hardware, as the SBPI programming interface is not accessible to Non- secure software. However, Secure software may check these bits to apply write permissions to a Non-secure OTP programming API. 0x0 -> Page can be read by Non-secure software, and Secure software may permit Non-secure writes. 0x1 -> Page can be read by Non-secure software 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Non-secure software.",
                "mask": 12,
                "name": "LOCK_NS"
            },
            {
                "description": "Lock state for Secure accesses to this page. Thermometer-coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. 0x0 -> Page is fully accessible by Secure software. 0x1 -> Page can be read by Secure software, but can not be written. 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Secure software.",
                "mask": 3,
                "name": "LOCK_S"
            }
        ],
        "mask": 16777023,
        "name": "OTP_DATA_PAGE23_LOCK1",
        "redundancy": 1,
        "row": 4015,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration LSBs for page 24 (rows 0x600 through 0x63f). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "State when at least one key is registered for this page and no matching key has been entered. 0x0 -> read_only 0x1 -> inaccessible",
                "mask": 64,
                "name": "NO_KEY_STATE"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant read access, or 0 if no such key is required.",
                "mask": 56,
                "name": "KEY_R"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant write access, or 0 if no such key is required.",
                "mask": 7,
                "name": "KEY_W"
            }
        ],
        "mask": 16777087,
        "name": "OTP_DATA_PAGE24_LOCK0",
        "redundancy": 1,
        "row": 4016,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration MSBs for page 24 (rows 0x600 through 0x63f). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "Dummy lock bits reserved for bootloaders (including the RP2350 USB bootloader) to store their own OTP access permissions. No hardware effect, and no corresponding SW_LOCKx registers. 0x0 -> Bootloader permits user reads and writes to this page 0x1 -> Bootloader permits user reads of this page 0x2 -> Do not use. Behaves the same as INACCESSIBLE 0x3 -> Bootloader does not permit user access to this page",
                "mask": 48,
                "name": "LOCK_BL"
            },
            {
                "description": "Lock state for Non-secure accesses to this page. Thermometer- coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. Note that READ_WRITE and READ_ONLY are equivalent in hardware, as the SBPI programming interface is not accessible to Non- secure software. However, Secure software may check these bits to apply write permissions to a Non-secure OTP programming API. 0x0 -> Page can be read by Non-secure software, and Secure software may permit Non-secure writes. 0x1 -> Page can be read by Non-secure software 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Non-secure software.",
                "mask": 12,
                "name": "LOCK_NS"
            },
            {
                "description": "Lock state for Secure accesses to this page. Thermometer-coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. 0x0 -> Page is fully accessible by Secure software. 0x1 -> Page can be read by Secure software, but can not be written. 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Secure software.",
                "mask": 3,
                "name": "LOCK_S"
            }
        ],
        "mask": 16777023,
        "name": "OTP_DATA_PAGE24_LOCK1",
        "redundancy": 1,
        "row": 4017,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration LSBs for page 25 (rows 0x640 through 0x67f). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "State when at least one key is registered for this page and no matching key has been entered. 0x0 -> read_only 0x1 -> inaccessible",
                "mask": 64,
                "name": "NO_KEY_STATE"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant read access, or 0 if no such key is required.",
                "mask": 56,
                "name": "KEY_R"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant write access, or 0 if no such key is required.",
                "mask": 7,
                "name": "KEY_W"
            }
        ],
        "mask": 16777087,
        "name": "OTP_DATA_PAGE25_LOCK0",
        "redundancy": 1,
        "row": 4018,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration MSBs for page 25 (rows 0x640 through 0x67f). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "Dummy lock bits reserved for bootloaders (including the RP2350 USB bootloader) to store their own OTP access permissions. No hardware effect, and no corresponding SW_LOCKx registers. 0x0 -> Bootloader permits user reads and writes to this page 0x1 -> Bootloader permits user reads of this page 0x2 -> Do not use. Behaves the same as INACCESSIBLE 0x3 -> Bootloader does not permit user access to this page",
                "mask": 48,
                "name": "LOCK_BL"
            },
            {
                "description": "Lock state for Non-secure accesses to this page. Thermometer- coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. Note that READ_WRITE and READ_ONLY are equivalent in hardware, as the SBPI programming interface is not accessible to Non- secure software. However, Secure software may check these bits to apply write permissions to a Non-secure OTP programming API. 0x0 -> Page can be read by Non-secure software, and Secure software may permit Non-secure writes. 0x1 -> Page can be read by Non-secure software 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Non-secure software.",
                "mask": 12,
                "name": "LOCK_NS"
            },
            {
                "description": "Lock state for Secure accesses to this page. Thermometer-coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. 0x0 -> Page is fully accessible by Secure software. 0x1 -> Page can be read by Secure software, but can not be written. 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Secure software.",
                "mask": 3,
                "name": "LOCK_S"
            }
        ],
        "mask": 16777023,
        "name": "OTP_DATA_PAGE25_LOCK1",
        "redundancy": 1,
        "row": 4019,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration LSBs for page 26 (rows 0x680 through 0x6bf). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "State when at least one key is registered for this page and no matching key has been entered. 0x0 -> read_only 0x1 -> inaccessible",
                "mask": 64,
                "name": "NO_KEY_STATE"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant read access, or 0 if no such key is required.",
                "mask": 56,
                "name": "KEY_R"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant write access, or 0 if no such key is required.",
                "mask": 7,
                "name": "KEY_W"
            }
        ],
        "mask": 16777087,
        "name": "OTP_DATA_PAGE26_LOCK0",
        "redundancy": 1,
        "row": 4020,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration MSBs for page 26 (rows 0x680 through 0x6bf). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "Dummy lock bits reserved for bootloaders (including the RP2350 USB bootloader) to store their own OTP access permissions. No hardware effect, and no corresponding SW_LOCKx registers. 0x0 -> Bootloader permits user reads and writes to this page 0x1 -> Bootloader permits user reads of this page 0x2 -> Do not use. Behaves the same as INACCESSIBLE 0x3 -> Bootloader does not permit user access to this page",
                "mask": 48,
                "name": "LOCK_BL"
            },
            {
                "description": "Lock state for Non-secure accesses to this page. Thermometer- coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. Note that READ_WRITE and READ_ONLY are equivalent in hardware, as the SBPI programming interface is not accessible to Non- secure software. However, Secure software may check these bits to apply write permissions to a Non-secure OTP programming API. 0x0 -> Page can be read by Non-secure software, and Secure software may permit Non-secure writes. 0x1 -> Page can be read by Non-secure software 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Non-secure software.",
                "mask": 12,
                "name": "LOCK_NS"
            },
            {
                "description": "Lock state for Secure accesses to this page. Thermometer-coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. 0x0 -> Page is fully accessible by Secure software. 0x1 -> Page can be read by Secure software, but can not be written. 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Secure software.",
                "mask": 3,
                "name": "LOCK_S"
            }
        ],
        "mask": 16777023,
        "name": "OTP_DATA_PAGE26_LOCK1",
        "redundancy": 1,
        "row": 4021,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration LSBs for page 27 (rows 0x6c0 through 0x6ff). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "State when at least one key is registered for this page and no matching key has been entered. 0x0 -> read_only 0x1 -> inaccessible",
                "mask": 64,
                "name": "NO_KEY_STATE"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant read access, or 0 if no such key is required.",
                "mask": 56,
                "name": "KEY_R"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant write access, or 0 if no such key is required.",
                "mask": 7,
                "name": "KEY_W"
            }
        ],
        "mask": 16777087,
        "name": "OTP_DATA_PAGE27_LOCK0",
        "redundancy": 1,
        "row": 4022,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration MSBs for page 27 (rows 0x6c0 through 0x6ff). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "Dummy lock bits reserved for bootloaders (including the RP2350 USB bootloader) to store their own OTP access permissions. No hardware effect, and no corresponding SW_LOCKx registers. 0x0 -> Bootloader permits user reads and writes to this page 0x1 -> Bootloader permits user reads of this page 0x2 -> Do not use. Behaves the same as INACCESSIBLE 0x3 -> Bootloader does not permit user access to this page",
                "mask": 48,
                "name": "LOCK_BL"
            },
            {
                "description": "Lock state for Non-secure accesses to this page. Thermometer- coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. Note that READ_WRITE and READ_ONLY are equivalent in hardware, as the SBPI programming interface is not accessible to Non- secure software. However, Secure software may check these bits to apply write permissions to a Non-secure OTP programming API. 0x0 -> Page can be read by Non-secure software, and Secure software may permit Non-secure writes. 0x1 -> Page can be read by Non-secure software 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Non-secure software.",
                "mask": 12,
                "name": "LOCK_NS"
            },
            {
                "description": "Lock state for Secure accesses to this page. Thermometer-coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. 0x0 -> Page is fully accessible by Secure software. 0x1 -> Page can be read by Secure software, but can not be written. 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Secure software.",
                "mask": 3,
                "name": "LOCK_S"
            }
        ],
        "mask": 16777023,
        "name": "OTP_DATA_PAGE27_LOCK1",
        "redundancy": 1,
        "row": 4023,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration LSBs for page 28 (rows 0x700 through 0x73f). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "State when at least one key is registered for this page and no matching key has been entered. 0x0 -> read_only 0x1 -> inaccessible",
                "mask": 64,
                "name": "NO_KEY_STATE"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant read access, or 0 if no such key is required.",
                "mask": 56,
                "name": "KEY_R"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant write access, or 0 if no such key is required.",
                "mask": 7,
                "name": "KEY_W"
            }
        ],
        "mask": 16777087,
        "name": "OTP_DATA_PAGE28_LOCK0",
        "redundancy": 1,
        "row": 4024,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration MSBs for page 28 (rows 0x700 through 0x73f). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "Dummy lock bits reserved for bootloaders (including the RP2350 USB bootloader) to store their own OTP access permissions. No hardware effect, and no corresponding SW_LOCKx registers. 0x0 -> Bootloader permits user reads and writes to this page 0x1 -> Bootloader permits user reads of this page 0x2 -> Do not use. Behaves the same as INACCESSIBLE 0x3 -> Bootloader does not permit user access to this page",
                "mask": 48,
                "name": "LOCK_BL"
            },
            {
                "description": "Lock state for Non-secure accesses to this page. Thermometer- coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. Note that READ_WRITE and READ_ONLY are equivalent in hardware, as the SBPI programming interface is not accessible to Non- secure software. However, Secure software may check these bits to apply write permissions to a Non-secure OTP programming API. 0x0 -> Page can be read by Non-secure software, and Secure software may permit Non-secure writes. 0x1 -> Page can be read by Non-secure software 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Non-secure software.",
                "mask": 12,
                "name": "LOCK_NS"
            },
            {
                "description": "Lock state for Secure accesses to this page. Thermometer-coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. 0x0 -> Page is fully accessible by Secure software. 0x1 -> Page can be read by Secure software, but can not be written. 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Secure software.",
                "mask": 3,
                "name": "LOCK_S"
            }
        ],
        "mask": 16777023,
        "name": "OTP_DATA_PAGE28_LOCK1",
        "redundancy": 1,
        "row": 4025,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration LSBs for page 29 (rows 0x740 through 0x77f). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "State when at least one key is registered for this page and no matching key has been entered. 0x0 -> read_only 0x1 -> inaccessible",
                "mask": 64,
                "name": "NO_KEY_STATE"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant read access, or 0 if no such key is required.",
                "mask": 56,
                "name": "KEY_R"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant write access, or 0 if no such key is required.",
                "mask": 7,
                "name": "KEY_W"
            }
        ],
        "mask": 16777087,
        "name": "OTP_DATA_PAGE29_LOCK0",
        "redundancy": 1,
        "row": 4026,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration MSBs for page 29 (rows 0x740 through 0x77f). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "Dummy lock bits reserved for bootloaders (including the RP2350 USB bootloader) to store their own OTP access permissions. No hardware effect, and no corresponding SW_LOCKx registers. 0x0 -> Bootloader permits user reads and writes to this page 0x1 -> Bootloader permits user reads of this page 0x2 -> Do not use. Behaves the same as INACCESSIBLE 0x3 -> Bootloader does not permit user access to this page",
                "mask": 48,
                "name": "LOCK_BL"
            },
            {
                "description": "Lock state for Non-secure accesses to this page. Thermometer- coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. Note that READ_WRITE and READ_ONLY are equivalent in hardware, as the SBPI programming interface is not accessible to Non- secure software. However, Secure software may check these bits to apply write permissions to a Non-secure OTP programming API. 0x0 -> Page can be read by Non-secure software, and Secure software may permit Non-secure writes. 0x1 -> Page can be read by Non-secure software 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Non-secure software.",
                "mask": 12,
                "name": "LOCK_NS"
            },
            {
                "description": "Lock state for Secure accesses to this page. Thermometer-coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. 0x0 -> Page is fully accessible by Secure software. 0x1 -> Page can be read by Secure software, but can not be written. 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Secure software.",
                "mask": 3,
                "name": "LOCK_S"
            }
        ],
        "mask": 16777023,
        "name": "OTP_DATA_PAGE29_LOCK1",
        "redundancy": 1,
        "row": 4027,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration LSBs for page 2 (rows 0x80 through 0xbf). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "State when at least one key is registered for this page and no matching key has been entered. 0x0 -> read_only 0x1 -> inaccessible",
                "mask": 64,
                "name": "NO_KEY_STATE"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant read access, or 0 if no such key is required.",
                "mask": 56,
                "name": "KEY_R"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant write access, or 0 if no such key is required.",
                "mask": 7,
                "name": "KEY_W"
            }
        ],
        "mask": 16777087,
        "name": "OTP_DATA_PAGE2_LOCK0",
        "redundancy": 1,
        "row": 3972,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration MSBs for page 2 (rows 0x80 through 0xbf). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "Dummy lock bits reserved for bootloaders (including the RP2350 USB bootloader) to store their own OTP access permissions. No hardware effect, and no corresponding SW_LOCKx registers. 0x0 -> Bootloader permits user reads and writes to this page 0x1 -> Bootloader permits user reads of this page 0x2 -> Do not use. Behaves the same as INACCESSIBLE 0x3 -> Bootloader does not permit user access to this page",
                "mask": 48,
                "name": "LOCK_BL"
            },
            {
                "description": "Lock state for Non-secure accesses to this page. Thermometer- coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. Note that READ_WRITE and READ_ONLY are equivalent in hardware, as the SBPI programming interface is not accessible to Non- secure software. However, Secure software may check these bits to apply write permissions to a Non-secure OTP programming API. 0x0 -> Page can be read by Non-secure software, and Secure software may permit Non-secure writes. 0x1 -> Page can be read by Non-secure software 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Non-secure software.",
                "mask": 12,
                "name": "LOCK_NS"
            },
            {
                "description": "Lock state for Secure accesses to this page. Thermometer-coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. 0x0 -> Page is fully accessible by Secure software. 0x1 -> Page can be read by Secure software, but can not be written. 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Secure software.",
                "mask": 3,
                "name": "LOCK_S"
            }
        ],
        "mask": 16777023,
        "name": "OTP_DATA_PAGE2_LOCK1",
        "redundancy": 1,
        "row": 3973,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration LSBs for page 30 (rows 0x780 through 0x7bf). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "State when at least one key is registered for this page and no matching key has been entered. 0x0 -> read_only 0x1 -> inaccessible",
                "mask": 64,
                "name": "NO_KEY_STATE"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant read access, or 0 if no such key is required.",
                "mask": 56,
                "name": "KEY_R"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant write access, or 0 if no such key is required.",
                "mask": 7,
                "name": "KEY_W"
            }
        ],
        "mask": 16777087,
        "name": "OTP_DATA_PAGE30_LOCK0",
        "redundancy": 1,
        "row": 4028,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration MSBs for page 30 (rows 0x780 through 0x7bf). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "Dummy lock bits reserved for bootloaders (including the RP2350 USB bootloader) to store their own OTP access permissions. No hardware effect, and no corresponding SW_LOCKx registers. 0x0 -> Bootloader permits user reads and writes to this page 0x1 -> Bootloader permits user reads of this page 0x2 -> Do not use. Behaves the same as INACCESSIBLE 0x3 -> Bootloader does not permit user access to this page",
                "mask": 48,
                "name": "LOCK_BL"
            },
            {
                "description": "Lock state for Non-secure accesses to this page. Thermometer- coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. Note that READ_WRITE and READ_ONLY are equivalent in hardware, as the SBPI programming interface is not accessible to Non- secure software. However, Secure software may check these bits to apply write permissions to a Non-secure OTP programming API. 0x0 -> Page can be read by Non-secure software, and Secure software may permit Non-secure writes. 0x1 -> Page can be read by Non-secure software 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Non-secure software.",
                "mask": 12,
                "name": "LOCK_NS"
            },
            {
                "description": "Lock state for Secure accesses to this page. Thermometer-coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. 0x0 -> Page is fully accessible by Secure software. 0x1 -> Page can be read by Secure software, but can not be written. 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Secure software.",
                "mask": 3,
                "name": "LOCK_S"
            }
        ],
        "mask": 16777023,
        "name": "OTP_DATA_PAGE30_LOCK1",
        "redundancy": 1,
        "row": 4029,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration LSBs for page 31 (rows 0x7c0 through 0x7ff). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "State when at least one key is registered for this page and no matching key has been entered. 0x0 -> read_only 0x1 -> inaccessible",
                "mask": 64,
                "name": "NO_KEY_STATE"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant read access, or 0 if no such key is required.",
                "mask": 56,
                "name": "KEY_R"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant write access, or 0 if no such key is required.",
                "mask": 7,
                "name": "KEY_W"
            }
        ],
        "mask": 16777087,
        "name": "OTP_DATA_PAGE31_LOCK0",
        "redundancy": 1,
        "row": 4030,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration MSBs for page 31 (rows 0x7c0 through 0x7ff). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "Dummy lock bits reserved for bootloaders (including the RP2350 USB bootloader) to store their own OTP access permissions. No hardware effect, and no corresponding SW_LOCKx registers. 0x0 -> Bootloader permits user reads and writes to this page 0x1 -> Bootloader permits user reads of this page 0x2 -> Do not use. Behaves the same as INACCESSIBLE 0x3 -> Bootloader does not permit user access to this page",
                "mask": 48,
                "name": "LOCK_BL"
            },
            {
                "description": "Lock state for Non-secure accesses to this page. Thermometer- coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. Note that READ_WRITE and READ_ONLY are equivalent in hardware, as the SBPI programming interface is not accessible to Non- secure software. However, Secure software may check these bits to apply write permissions to a Non-secure OTP programming API. 0x0 -> Page can be read by Non-secure software, and Secure software may permit Non-secure writes. 0x1 -> Page can be read by Non-secure software 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Non-secure software.",
                "mask": 12,
                "name": "LOCK_NS"
            },
            {
                "description": "Lock state for Secure accesses to this page. Thermometer-coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. 0x0 -> Page is fully accessible by Secure software. 0x1 -> Page can be read by Secure software, but can not be written. 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Secure software.",
                "mask": 3,
                "name": "LOCK_S"
            }
        ],
        "mask": 16777023,
        "name": "OTP_DATA_PAGE31_LOCK1",
        "redundancy": 1,
        "row": 4031,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration LSBs for page 32 (rows 0x800 through 0x83f). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "State when at least one key is registered for this page and no matching key has been entered. 0x0 -> read_only 0x1 -> inaccessible",
                "mask": 64,
                "name": "NO_KEY_STATE"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant read access, or 0 if no such key is required.",
                "mask": 56,
                "name": "KEY_R"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant write access, or 0 if no such key is required.",
                "mask": 7,
                "name": "KEY_W"
            }
        ],
        "mask": 16777087,
        "name": "OTP_DATA_PAGE32_LOCK0",
        "redundancy": 1,
        "row": 4032,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration MSBs for page 32 (rows 0x800 through 0x83f). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "Dummy lock bits reserved for bootloaders (including the RP2350 USB bootloader) to store their own OTP access permissions. No hardware effect, and no corresponding SW_LOCKx registers. 0x0 -> Bootloader permits user reads and writes to this page 0x1 -> Bootloader permits user reads of this page 0x2 -> Do not use. Behaves the same as INACCESSIBLE 0x3 -> Bootloader does not permit user access to this page",
                "mask": 48,
                "name": "LOCK_BL"
            },
            {
                "description": "Lock state for Non-secure accesses to this page. Thermometer- coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. Note that READ_WRITE and READ_ONLY are equivalent in hardware, as the SBPI programming interface is not accessible to Non- secure software. However, Secure software may check these bits to apply write permissions to a Non-secure OTP programming API. 0x0 -> Page can be read by Non-secure software, and Secure software may permit Non-secure writes. 0x1 -> Page can be read by Non-secure software 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Non-secure software.",
                "mask": 12,
                "name": "LOCK_NS"
            },
            {
                "description": "Lock state for Secure accesses to this page. Thermometer-coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. 0x0 -> Page is fully accessible by Secure software. 0x1 -> Page can be read by Secure software, but can not be written. 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Secure software.",
                "mask": 3,
                "name": "LOCK_S"
            }
        ],
        "mask": 16777023,
        "name": "OTP_DATA_PAGE32_LOCK1",
        "redundancy": 1,
        "row": 4033,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration LSBs for page 33 (rows 0x840 through 0x87f). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "State when at least one key is registered for this page and no matching key has been entered. 0x0 -> read_only 0x1 -> inaccessible",
                "mask": 64,
                "name": "NO_KEY_STATE"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant read access, or 0 if no such key is required.",
                "mask": 56,
                "name": "KEY_R"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant write access, or 0 if no such key is required.",
                "mask": 7,
                "name": "KEY_W"
            }
        ],
        "mask": 16777087,
        "name": "OTP_DATA_PAGE33_LOCK0",
        "redundancy": 1,
        "row": 4034,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration MSBs for page 33 (rows 0x840 through 0x87f). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "Dummy lock bits reserved for bootloaders (including the RP2350 USB bootloader) to store their own OTP access permissions. No hardware effect, and no corresponding SW_LOCKx registers. 0x0 -> Bootloader permits user reads and writes to this page 0x1 -> Bootloader permits user reads of this page 0x2 -> Do not use. Behaves the same as INACCESSIBLE 0x3 -> Bootloader does not permit user access to this page",
                "mask": 48,
                "name": "LOCK_BL"
            },
            {
                "description": "Lock state for Non-secure accesses to this page. Thermometer- coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. Note that READ_WRITE and READ_ONLY are equivalent in hardware, as the SBPI programming interface is not accessible to Non- secure software. However, Secure software may check these bits to apply write permissions to a Non-secure OTP programming API. 0x0 -> Page can be read by Non-secure software, and Secure software may permit Non-secure writes. 0x1 -> Page can be read by Non-secure software 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Non-secure software.",
                "mask": 12,
                "name": "LOCK_NS"
            },
            {
                "description": "Lock state for Secure accesses to this page. Thermometer-coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. 0x0 -> Page is fully accessible by Secure software. 0x1 -> Page can be read by Secure software, but can not be written. 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Secure software.",
                "mask": 3,
                "name": "LOCK_S"
            }
        ],
        "mask": 16777023,
        "name": "OTP_DATA_PAGE33_LOCK1",
        "redundancy": 1,
        "row": 4035,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration LSBs for page 34 (rows 0x880 through 0x8bf). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "State when at least one key is registered for this page and no matching key has been entered. 0x0 -> read_only 0x1 -> inaccessible",
                "mask": 64,
                "name": "NO_KEY_STATE"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant read access, or 0 if no such key is required.",
                "mask": 56,
                "name": "KEY_R"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant write access, or 0 if no such key is required.",
                "mask": 7,
                "name": "KEY_W"
            }
        ],
        "mask": 16777087,
        "name": "OTP_DATA_PAGE34_LOCK0",
        "redundancy": 1,
        "row": 4036,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration MSBs for page 34 (rows 0x880 through 0x8bf). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "Dummy lock bits reserved for bootloaders (including the RP2350 USB bootloader) to store their own OTP access permissions. No hardware effect, and no corresponding SW_LOCKx registers. 0x0 -> Bootloader permits user reads and writes to this page 0x1 -> Bootloader permits user reads of this page 0x2 -> Do not use. Behaves the same as INACCESSIBLE 0x3 -> Bootloader does not permit user access to this page",
                "mask": 48,
                "name": "LOCK_BL"
            },
            {
                "description": "Lock state for Non-secure accesses to this page. Thermometer- coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. Note that READ_WRITE and READ_ONLY are equivalent in hardware, as the SBPI programming interface is not accessible to Non- secure software. However, Secure software may check these bits to apply write permissions to a Non-secure OTP programming API. 0x0 -> Page can be read by Non-secure software, and Secure software may permit Non-secure writes. 0x1 -> Page can be read by Non-secure software 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Non-secure software.",
                "mask": 12,
                "name": "LOCK_NS"
            },
            {
                "description": "Lock state for Secure accesses to this page. Thermometer-coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. 0x0 -> Page is fully accessible by Secure software. 0x1 -> Page can be read by Secure software, but can not be written. 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Secure software.",
                "mask": 3,
                "name": "LOCK_S"
            }
        ],
        "mask": 16777023,
        "name": "OTP_DATA_PAGE34_LOCK1",
        "redundancy": 1,
        "row": 4037,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration LSBs for page 35 (rows 0x8c0 through 0x8ff). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "State when at least one key is registered for this page and no matching key has been entered. 0x0 -> read_only 0x1 -> inaccessible",
                "mask": 64,
                "name": "NO_KEY_STATE"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant read access, or 0 if no such key is required.",
                "mask": 56,
                "name": "KEY_R"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant write access, or 0 if no such key is required.",
                "mask": 7,
                "name": "KEY_W"
            }
        ],
        "mask": 16777087,
        "name": "OTP_DATA_PAGE35_LOCK0",
        "redundancy": 1,
        "row": 4038,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration MSBs for page 35 (rows 0x8c0 through 0x8ff). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "Dummy lock bits reserved for bootloaders (including the RP2350 USB bootloader) to store their own OTP access permissions. No hardware effect, and no corresponding SW_LOCKx registers. 0x0 -> Bootloader permits user reads and writes to this page 0x1 -> Bootloader permits user reads of this page 0x2 -> Do not use. Behaves the same as INACCESSIBLE 0x3 -> Bootloader does not permit user access to this page",
                "mask": 48,
                "name": "LOCK_BL"
            },
            {
                "description": "Lock state for Non-secure accesses to this page. Thermometer- coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. Note that READ_WRITE and READ_ONLY are equivalent in hardware, as the SBPI programming interface is not accessible to Non- secure software. However, Secure software may check these bits to apply write permissions to a Non-secure OTP programming API. 0x0 -> Page can be read by Non-secure software, and Secure software may permit Non-secure writes. 0x1 -> Page can be read by Non-secure software 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Non-secure software.",
                "mask": 12,
                "name": "LOCK_NS"
            },
            {
                "description": "Lock state for Secure accesses to this page. Thermometer-coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. 0x0 -> Page is fully accessible by Secure software. 0x1 -> Page can be read by Secure software, but can not be written. 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Secure software.",
                "mask": 3,
                "name": "LOCK_S"
            }
        ],
        "mask": 16777023,
        "name": "OTP_DATA_PAGE35_LOCK1",
        "redundancy": 1,
        "row": 4039,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration LSBs for page 36 (rows 0x900 through 0x93f). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "State when at least one key is registered for this page and no matching key has been entered. 0x0 -> read_only 0x1 -> inaccessible",
                "mask": 64,
                "name": "NO_KEY_STATE"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant read access, or 0 if no such key is required.",
                "mask": 56,
                "name": "KEY_R"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant write access, or 0 if no such key is required.",
                "mask": 7,
                "name": "KEY_W"
            }
        ],
        "mask": 16777087,
        "name": "OTP_DATA_PAGE36_LOCK0",
        "redundancy": 1,
        "row": 4040,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration MSBs for page 36 (rows 0x900 through 0x93f). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "Dummy lock bits reserved for bootloaders (including the RP2350 USB bootloader) to store their own OTP access permissions. No hardware effect, and no corresponding SW_LOCKx registers. 0x0 -> Bootloader permits user reads and writes to this page 0x1 -> Bootloader permits user reads of this page 0x2 -> Do not use. Behaves the same as INACCESSIBLE 0x3 -> Bootloader does not permit user access to this page",
                "mask": 48,
                "name": "LOCK_BL"
            },
            {
                "description": "Lock state for Non-secure accesses to this page. Thermometer- coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. Note that READ_WRITE and READ_ONLY are equivalent in hardware, as the SBPI programming interface is not accessible to Non- secure software. However, Secure software may check these bits to apply write permissions to a Non-secure OTP programming API. 0x0 -> Page can be read by Non-secure software, and Secure software may permit Non-secure writes. 0x1 -> Page can be read by Non-secure software 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Non-secure software.",
                "mask": 12,
                "name": "LOCK_NS"
            },
            {
                "description": "Lock state for Secure accesses to this page. Thermometer-coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. 0x0 -> Page is fully accessible by Secure software. 0x1 -> Page can be read by Secure software, but can not be written. 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Secure software.",
                "mask": 3,
                "name": "LOCK_S"
            }
        ],
        "mask": 16777023,
        "name": "OTP_DATA_PAGE36_LOCK1",
        "redundancy": 1,
        "row": 4041,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration LSBs for page 37 (rows 0x940 through 0x97f). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "State when at least one key is registered for this page and no matching key has been entered. 0x0 -> read_only 0x1 -> inaccessible",
                "mask": 64,
                "name": "NO_KEY_STATE"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant read access, or 0 if no such key is required.",
                "mask": 56,
                "name": "KEY_R"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant write access, or 0 if no such key is required.",
                "mask": 7,
                "name": "KEY_W"
            }
        ],
        "mask": 16777087,
        "name": "OTP_DATA_PAGE37_LOCK0",
        "redundancy": 1,
        "row": 4042,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration MSBs for page 37 (rows 0x940 through 0x97f). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "Dummy lock bits reserved for bootloaders (including the RP2350 USB bootloader) to store their own OTP access permissions. No hardware effect, and no corresponding SW_LOCKx registers. 0x0 -> Bootloader permits user reads and writes to this page 0x1 -> Bootloader permits user reads of this page 0x2 -> Do not use. Behaves the same as INACCESSIBLE 0x3 -> Bootloader does not permit user access to this page",
                "mask": 48,
                "name": "LOCK_BL"
            },
            {
                "description": "Lock state for Non-secure accesses to this page. Thermometer- coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. Note that READ_WRITE and READ_ONLY are equivalent in hardware, as the SBPI programming interface is not accessible to Non- secure software. However, Secure software may check these bits to apply write permissions to a Non-secure OTP programming API. 0x0 -> Page can be read by Non-secure software, and Secure software may permit Non-secure writes. 0x1 -> Page can be read by Non-secure software 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Non-secure software.",
                "mask": 12,
                "name": "LOCK_NS"
            },
            {
                "description": "Lock state for Secure accesses to this page. Thermometer-coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. 0x0 -> Page is fully accessible by Secure software. 0x1 -> Page can be read by Secure software, but can not be written. 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Secure software.",
                "mask": 3,
                "name": "LOCK_S"
            }
        ],
        "mask": 16777023,
        "name": "OTP_DATA_PAGE37_LOCK1",
        "redundancy": 1,
        "row": 4043,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration LSBs for page 38 (rows 0x980 through 0x9bf). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "State when at least one key is registered for this page and no matching key has been entered. 0x0 -> read_only 0x1 -> inaccessible",
                "mask": 64,
                "name": "NO_KEY_STATE"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant read access, or 0 if no such key is required.",
                "mask": 56,
                "name": "KEY_R"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant write access, or 0 if no such key is required.",
                "mask": 7,
                "name": "KEY_W"
            }
        ],
        "mask": 16777087,
        "name": "OTP_DATA_PAGE38_LOCK0",
        "redundancy": 1,
        "row": 4044,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration MSBs for page 38 (rows 0x980 through 0x9bf). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "Dummy lock bits reserved for bootloaders (including the RP2350 USB bootloader) to store their own OTP access permissions. No hardware effect, and no corresponding SW_LOCKx registers. 0x0 -> Bootloader permits user reads and writes to this page 0x1 -> Bootloader permits user reads of this page 0x2 -> Do not use. Behaves the same as INACCESSIBLE 0x3 -> Bootloader does not permit user access to this page",
                "mask": 48,
                "name": "LOCK_BL"
            },
            {
                "description": "Lock state for Non-secure accesses to this page. Thermometer- coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. Note that READ_WRITE and READ_ONLY are equivalent in hardware, as the SBPI programming interface is not accessible to Non- secure software. However, Secure software may check these bits to apply write permissions to a Non-secure OTP programming API. 0x0 -> Page can be read by Non-secure software, and Secure software may permit Non-secure writes. 0x1 -> Page can be read by Non-secure software 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Non-secure software.",
                "mask": 12,
                "name": "LOCK_NS"
            },
            {
                "description": "Lock state for Secure accesses to this page. Thermometer-coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. 0x0 -> Page is fully accessible by Secure software. 0x1 -> Page can be read by Secure software, but can not be written. 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Secure software.",
                "mask": 3,
                "name": "LOCK_S"
            }
        ],
        "mask": 16777023,
        "name": "OTP_DATA_PAGE38_LOCK1",
        "redundancy": 1,
        "row": 4045,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration LSBs for page 39 (rows 0x9c0 through 0x9ff). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "State when at least one key is registered for this page and no matching key has been entered. 0x0 -> read_only 0x1 -> inaccessible",
                "mask": 64,
                "name": "NO_KEY_STATE"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant read access, or 0 if no such key is required.",
                "mask": 56,
                "name": "KEY_R"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant write access, or 0 if no such key is required.",
                "mask": 7,
                "name": "KEY_W"
            }
        ],
        "mask": 16777087,
        "name": "OTP_DATA_PAGE39_LOCK0",
        "redundancy": 1,
        "row": 4046,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration MSBs for page 39 (rows 0x9c0 through 0x9ff). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "Dummy lock bits reserved for bootloaders (including the RP2350 USB bootloader) to store their own OTP access permissions. No hardware effect, and no corresponding SW_LOCKx registers. 0x0 -> Bootloader permits user reads and writes to this page 0x1 -> Bootloader permits user reads of this page 0x2 -> Do not use. Behaves the same as INACCESSIBLE 0x3 -> Bootloader does not permit user access to this page",
                "mask": 48,
                "name": "LOCK_BL"
            },
            {
                "description": "Lock state for Non-secure accesses to this page. Thermometer- coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. Note that READ_WRITE and READ_ONLY are equivalent in hardware, as the SBPI programming interface is not accessible to Non- secure software. However, Secure software may check these bits to apply write permissions to a Non-secure OTP programming API. 0x0 -> Page can be read by Non-secure software, and Secure software may permit Non-secure writes. 0x1 -> Page can be read by Non-secure software 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Non-secure software.",
                "mask": 12,
                "name": "LOCK_NS"
            },
            {
                "description": "Lock state for Secure accesses to this page. Thermometer-coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. 0x0 -> Page is fully accessible by Secure software. 0x1 -> Page can be read by Secure software, but can not be written. 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Secure software.",
                "mask": 3,
                "name": "LOCK_S"
            }
        ],
        "mask": 16777023,
        "name": "OTP_DATA_PAGE39_LOCK1",
        "redundancy": 1,
        "row": 4047,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration LSBs for page 3 (rows 0xc0 through 0xff). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "State when at least one key is registered for this page and no matching key has been entered. 0x0 -> read_only 0x1 -> inaccessible",
                "mask": 64,
                "name": "NO_KEY_STATE"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant read access, or 0 if no such key is required.",
                "mask": 56,
                "name": "KEY_R"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant write access, or 0 if no such key is required.",
                "mask": 7,
                "name": "KEY_W"
            }
        ],
        "mask": 16777087,
        "name": "OTP_DATA_PAGE3_LOCK0",
        "redundancy": 1,
        "row": 3974,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration MSBs for page 3 (rows 0xc0 through 0xff). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "Dummy lock bits reserved for bootloaders (including the RP2350 USB bootloader) to store their own OTP access permissions. No hardware effect, and no corresponding SW_LOCKx registers. 0x0 -> Bootloader permits user reads and writes to this page 0x1 -> Bootloader permits user reads of this page 0x2 -> Do not use. Behaves the same as INACCESSIBLE 0x3 -> Bootloader does not permit user access to this page",
                "mask": 48,
                "name": "LOCK_BL"
            },
            {
                "description": "Lock state for Non-secure accesses to this page. Thermometer- coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. Note that READ_WRITE and READ_ONLY are equivalent in hardware, as the SBPI programming interface is not accessible to Non- secure software. However, Secure software may check these bits to apply write permissions to a Non-secure OTP programming API. 0x0 -> Page can be read by Non-secure software, and Secure software may permit Non-secure writes. 0x1 -> Page can be read by Non-secure software 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Non-secure software.",
                "mask": 12,
                "name": "LOCK_NS"
            },
            {
                "description": "Lock state for Secure accesses to this page. Thermometer-coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. 0x0 -> Page is fully accessible by Secure software. 0x1 -> Page can be read by Secure software, but can not be written. 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Secure software.",
                "mask": 3,
                "name": "LOCK_S"
            }
        ],
        "mask": 16777023,
        "name": "OTP_DATA_PAGE3_LOCK1",
        "redundancy": 1,
        "row": 3975,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration LSBs for page 40 (rows 0xa00 through 0xa3f). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "State when at least one key is registered for this page and no matching key has been entered. 0x0 -> read_only 0x1 -> inaccessible",
                "mask": 64,
                "name": "NO_KEY_STATE"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant read access, or 0 if no such key is required.",
                "mask": 56,
                "name": "KEY_R"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant write access, or 0 if no such key is required.",
                "mask": 7,
                "name": "KEY_W"
            }
        ],
        "mask": 16777087,
        "name": "OTP_DATA_PAGE40_LOCK0",
        "redundancy": 1,
        "row": 4048,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration MSBs for page 40 (rows 0xa00 through 0xa3f). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "Dummy lock bits reserved for bootloaders (including the RP2350 USB bootloader) to store their own OTP access permissions. No hardware effect, and no corresponding SW_LOCKx registers. 0x0 -> Bootloader permits user reads and writes to this page 0x1 -> Bootloader permits user reads of this page 0x2 -> Do not use. Behaves the same as INACCESSIBLE 0x3 -> Bootloader does not permit user access to this page",
                "mask": 48,
                "name": "LOCK_BL"
            },
            {
                "description": "Lock state for Non-secure accesses to this page. Thermometer- coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. Note that READ_WRITE and READ_ONLY are equivalent in hardware, as the SBPI programming interface is not accessible to Non- secure software. However, Secure software may check these bits to apply write permissions to a Non-secure OTP programming API. 0x0 -> Page can be read by Non-secure software, and Secure software may permit Non-secure writes. 0x1 -> Page can be read by Non-secure software 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Non-secure software.",
                "mask": 12,
                "name": "LOCK_NS"
            },
            {
                "description": "Lock state for Secure accesses to this page. Thermometer-coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. 0x0 -> Page is fully accessible by Secure software. 0x1 -> Page can be read by Secure software, but can not be written. 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Secure software.",
                "mask": 3,
                "name": "LOCK_S"
            }
        ],
        "mask": 16777023,
        "name": "OTP_DATA_PAGE40_LOCK1",
        "redundancy": 1,
        "row": 4049,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration LSBs for page 41 (rows 0xa40 through 0xa7f). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "State when at least one key is registered for this page and no matching key has been entered. 0x0 -> read_only 0x1 -> inaccessible",
                "mask": 64,
                "name": "NO_KEY_STATE"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant read access, or 0 if no such key is required.",
                "mask": 56,
                "name": "KEY_R"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant write access, or 0 if no such key is required.",
                "mask": 7,
                "name": "KEY_W"
            }
        ],
        "mask": 16777087,
        "name": "OTP_DATA_PAGE41_LOCK0",
        "redundancy": 1,
        "row": 4050,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration MSBs for page 41 (rows 0xa40 through 0xa7f). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "Dummy lock bits reserved for bootloaders (including the RP2350 USB bootloader) to store their own OTP access permissions. No hardware effect, and no corresponding SW_LOCKx registers. 0x0 -> Bootloader permits user reads and writes to this page 0x1 -> Bootloader permits user reads of this page 0x2 -> Do not use. Behaves the same as INACCESSIBLE 0x3 -> Bootloader does not permit user access to this page",
                "mask": 48,
                "name": "LOCK_BL"
            },
            {
                "description": "Lock state for Non-secure accesses to this page. Thermometer- coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. Note that READ_WRITE and READ_ONLY are equivalent in hardware, as the SBPI programming interface is not accessible to Non- secure software. However, Secure software may check these bits to apply write permissions to a Non-secure OTP programming API. 0x0 -> Page can be read by Non-secure software, and Secure software may permit Non-secure writes. 0x1 -> Page can be read by Non-secure software 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Non-secure software.",
                "mask": 12,
                "name": "LOCK_NS"
            },
            {
                "description": "Lock state for Secure accesses to this page. Thermometer-coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. 0x0 -> Page is fully accessible by Secure software. 0x1 -> Page can be read by Secure software, but can not be written. 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Secure software.",
                "mask": 3,
                "name": "LOCK_S"
            }
        ],
        "mask": 16777023,
        "name": "OTP_DATA_PAGE41_LOCK1",
        "redundancy": 1,
        "row": 4051,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration LSBs for page 42 (rows 0xa80 through 0xabf). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "State when at least one key is registered for this page and no matching key has been entered. 0x0 -> read_only 0x1 -> inaccessible",
                "mask": 64,
                "name": "NO_KEY_STATE"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant read access, or 0 if no such key is required.",
                "mask": 56,
                "name": "KEY_R"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant write access, or 0 if no such key is required.",
                "mask": 7,
                "name": "KEY_W"
            }
        ],
        "mask": 16777087,
        "name": "OTP_DATA_PAGE42_LOCK0",
        "redundancy": 1,
        "row": 4052,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration MSBs for page 42 (rows 0xa80 through 0xabf). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "Dummy lock bits reserved for bootloaders (including the RP2350 USB bootloader) to store their own OTP access permissions. No hardware effect, and no corresponding SW_LOCKx registers. 0x0 -> Bootloader permits user reads and writes to this page 0x1 -> Bootloader permits user reads of this page 0x2 -> Do not use. Behaves the same as INACCESSIBLE 0x3 -> Bootloader does not permit user access to this page",
                "mask": 48,
                "name": "LOCK_BL"
            },
            {
                "description": "Lock state for Non-secure accesses to this page. Thermometer- coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. Note that READ_WRITE and READ_ONLY are equivalent in hardware, as the SBPI programming interface is not accessible to Non- secure software. However, Secure software may check these bits to apply write permissions to a Non-secure OTP programming API. 0x0 -> Page can be read by Non-secure software, and Secure software may permit Non-secure writes. 0x1 -> Page can be read by Non-secure software 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Non-secure software.",
                "mask": 12,
                "name": "LOCK_NS"
            },
            {
                "description": "Lock state for Secure accesses to this page. Thermometer-coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. 0x0 -> Page is fully accessible by Secure software. 0x1 -> Page can be read by Secure software, but can not be written. 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Secure software.",
                "mask": 3,
                "name": "LOCK_S"
            }
        ],
        "mask": 16777023,
        "name": "OTP_DATA_PAGE42_LOCK1",
        "redundancy": 1,
        "row": 4053,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration LSBs for page 43 (rows 0xac0 through 0xaff). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "State when at least one key is registered for this page and no matching key has been entered. 0x0 -> read_only 0x1 -> inaccessible",
                "mask": 64,
                "name": "NO_KEY_STATE"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant read access, or 0 if no such key is required.",
                "mask": 56,
                "name": "KEY_R"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant write access, or 0 if no such key is required.",
                "mask": 7,
                "name": "KEY_W"
            }
        ],
        "mask": 16777087,
        "name": "OTP_DATA_PAGE43_LOCK0",
        "redundancy": 1,
        "row": 4054,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration MSBs for page 43 (rows 0xac0 through 0xaff). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "Dummy lock bits reserved for bootloaders (including the RP2350 USB bootloader) to store their own OTP access permissions. No hardware effect, and no corresponding SW_LOCKx registers. 0x0 -> Bootloader permits user reads and writes to this page 0x1 -> Bootloader permits user reads of this page 0x2 -> Do not use. Behaves the same as INACCESSIBLE 0x3 -> Bootloader does not permit user access to this page",
                "mask": 48,
                "name": "LOCK_BL"
            },
            {
                "description": "Lock state for Non-secure accesses to this page. Thermometer- coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. Note that READ_WRITE and READ_ONLY are equivalent in hardware, as the SBPI programming interface is not accessible to Non- secure software. However, Secure software may check these bits to apply write permissions to a Non-secure OTP programming API. 0x0 -> Page can be read by Non-secure software, and Secure software may permit Non-secure writes. 0x1 -> Page can be read by Non-secure software 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Non-secure software.",
                "mask": 12,
                "name": "LOCK_NS"
            },
            {
                "description": "Lock state for Secure accesses to this page. Thermometer-coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. 0x0 -> Page is fully accessible by Secure software. 0x1 -> Page can be read by Secure software, but can not be written. 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Secure software.",
                "mask": 3,
                "name": "LOCK_S"
            }
        ],
        "mask": 16777023,
        "name": "OTP_DATA_PAGE43_LOCK1",
        "redundancy": 1,
        "row": 4055,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration LSBs for page 44 (rows 0xb00 through 0xb3f). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "State when at least one key is registered for this page and no matching key has been entered. 0x0 -> read_only 0x1 -> inaccessible",
                "mask": 64,
                "name": "NO_KEY_STATE"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant read access, or 0 if no such key is required.",
                "mask": 56,
                "name": "KEY_R"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant write access, or 0 if no such key is required.",
                "mask": 7,
                "name": "KEY_W"
            }
        ],
        "mask": 16777087,
        "name": "OTP_DATA_PAGE44_LOCK0",
        "redundancy": 1,
        "row": 4056,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration MSBs for page 44 (rows 0xb00 through 0xb3f). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "Dummy lock bits reserved for bootloaders (including the RP2350 USB bootloader) to store their own OTP access permissions. No hardware effect, and no corresponding SW_LOCKx registers. 0x0 -> Bootloader permits user reads and writes to this page 0x1 -> Bootloader permits user reads of this page 0x2 -> Do not use. Behaves the same as INACCESSIBLE 0x3 -> Bootloader does not permit user access to this page",
                "mask": 48,
                "name": "LOCK_BL"
            },
            {
                "description": "Lock state for Non-secure accesses to this page. Thermometer- coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. Note that READ_WRITE and READ_ONLY are equivalent in hardware, as the SBPI programming interface is not accessible to Non- secure software. However, Secure software may check these bits to apply write permissions to a Non-secure OTP programming API. 0x0 -> Page can be read by Non-secure software, and Secure software may permit Non-secure writes. 0x1 -> Page can be read by Non-secure software 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Non-secure software.",
                "mask": 12,
                "name": "LOCK_NS"
            },
            {
                "description": "Lock state for Secure accesses to this page. Thermometer-coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. 0x0 -> Page is fully accessible by Secure software. 0x1 -> Page can be read by Secure software, but can not be written. 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Secure software.",
                "mask": 3,
                "name": "LOCK_S"
            }
        ],
        "mask": 16777023,
        "name": "OTP_DATA_PAGE44_LOCK1",
        "redundancy": 1,
        "row": 4057,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration LSBs for page 45 (rows 0xb40 through 0xb7f). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "State when at least one key is registered for this page and no matching key has been entered. 0x0 -> read_only 0x1 -> inaccessible",
                "mask": 64,
                "name": "NO_KEY_STATE"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant read access, or 0 if no such key is required.",
                "mask": 56,
                "name": "KEY_R"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant write access, or 0 if no such key is required.",
                "mask": 7,
                "name": "KEY_W"
            }
        ],
        "mask": 16777087,
        "name": "OTP_DATA_PAGE45_LOCK0",
        "redundancy": 1,
        "row": 4058,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration MSBs for page 45 (rows 0xb40 through 0xb7f). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "Dummy lock bits reserved for bootloaders (including the RP2350 USB bootloader) to store their own OTP access permissions. No hardware effect, and no corresponding SW_LOCKx registers. 0x0 -> Bootloader permits user reads and writes to this page 0x1 -> Bootloader permits user reads of this page 0x2 -> Do not use. Behaves the same as INACCESSIBLE 0x3 -> Bootloader does not permit user access to this page",
                "mask": 48,
                "name": "LOCK_BL"
            },
            {
                "description": "Lock state for Non-secure accesses to this page. Thermometer- coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. Note that READ_WRITE and READ_ONLY are equivalent in hardware, as the SBPI programming interface is not accessible to Non- secure software. However, Secure software may check these bits to apply write permissions to a Non-secure OTP programming API. 0x0 -> Page can be read by Non-secure software, and Secure software may permit Non-secure writes. 0x1 -> Page can be read by Non-secure software 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Non-secure software.",
                "mask": 12,
                "name": "LOCK_NS"
            },
            {
                "description": "Lock state for Secure accesses to this page. Thermometer-coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. 0x0 -> Page is fully accessible by Secure software. 0x1 -> Page can be read by Secure software, but can not be written. 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Secure software.",
                "mask": 3,
                "name": "LOCK_S"
            }
        ],
        "mask": 16777023,
        "name": "OTP_DATA_PAGE45_LOCK1",
        "redundancy": 1,
        "row": 4059,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration LSBs for page 46 (rows 0xb80 through 0xbbf). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "State when at least one key is registered for this page and no matching key has been entered. 0x0 -> read_only 0x1 -> inaccessible",
                "mask": 64,
                "name": "NO_KEY_STATE"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant read access, or 0 if no such key is required.",
                "mask": 56,
                "name": "KEY_R"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant write access, or 0 if no such key is required.",
                "mask": 7,
                "name": "KEY_W"
            }
        ],
        "mask": 16777087,
        "name": "OTP_DATA_PAGE46_LOCK0",
        "redundancy": 1,
        "row": 4060,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration MSBs for page 46 (rows 0xb80 through 0xbbf). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "Dummy lock bits reserved for bootloaders (including the RP2350 USB bootloader) to store their own OTP access permissions. No hardware effect, and no corresponding SW_LOCKx registers. 0x0 -> Bootloader permits user reads and writes to this page 0x1 -> Bootloader permits user reads of this page 0x2 -> Do not use. Behaves the same as INACCESSIBLE 0x3 -> Bootloader does not permit user access to this page",
                "mask": 48,
                "name": "LOCK_BL"
            },
            {
                "description": "Lock state for Non-secure accesses to this page. Thermometer- coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. Note that READ_WRITE and READ_ONLY are equivalent in hardware, as the SBPI programming interface is not accessible to Non- secure software. However, Secure software may check these bits to apply write permissions to a Non-secure OTP programming API. 0x0 -> Page can be read by Non-secure software, and Secure software may permit Non-secure writes. 0x1 -> Page can be read by Non-secure software 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Non-secure software.",
                "mask": 12,
                "name": "LOCK_NS"
            },
            {
                "description": "Lock state for Secure accesses to this page. Thermometer-coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. 0x0 -> Page is fully accessible by Secure software. 0x1 -> Page can be read by Secure software, but can not be written. 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Secure software.",
                "mask": 3,
                "name": "LOCK_S"
            }
        ],
        "mask": 16777023,
        "name": "OTP_DATA_PAGE46_LOCK1",
        "redundancy": 1,
        "row": 4061,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration LSBs for page 47 (rows 0xbc0 through 0xbff). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "State when at least one key is registered for this page and no matching key has been entered. 0x0 -> read_only 0x1 -> inaccessible",
                "mask": 64,
                "name": "NO_KEY_STATE"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant read access, or 0 if no such key is required.",
                "mask": 56,
                "name": "KEY_R"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant write access, or 0 if no such key is required.",
                "mask": 7,
                "name": "KEY_W"
            }
        ],
        "mask": 16777087,
        "name": "OTP_DATA_PAGE47_LOCK0",
        "redundancy": 1,
        "row": 4062,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration MSBs for page 47 (rows 0xbc0 through 0xbff). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "Dummy lock bits reserved for bootloaders (including the RP2350 USB bootloader) to store their own OTP access permissions. No hardware effect, and no corresponding SW_LOCKx registers. 0x0 -> Bootloader permits user reads and writes to this page 0x1 -> Bootloader permits user reads of this page 0x2 -> Do not use. Behaves the same as INACCESSIBLE 0x3 -> Bootloader does not permit user access to this page",
                "mask": 48,
                "name": "LOCK_BL"
            },
            {
                "description": "Lock state for Non-secure accesses to this page. Thermometer- coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. Note that READ_WRITE and READ_ONLY are equivalent in hardware, as the SBPI programming interface is not accessible to Non- secure software. However, Secure software may check these bits to apply write permissions to a Non-secure OTP programming API. 0x0 -> Page can be read by Non-secure software, and Secure software may permit Non-secure writes. 0x1 -> Page can be read by Non-secure software 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Non-secure software.",
                "mask": 12,
                "name": "LOCK_NS"
            },
            {
                "description": "Lock state for Secure accesses to this page. Thermometer-coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. 0x0 -> Page is fully accessible by Secure software. 0x1 -> Page can be read by Secure software, but can not be written. 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Secure software.",
                "mask": 3,
                "name": "LOCK_S"
            }
        ],
        "mask": 16777023,
        "name": "OTP_DATA_PAGE47_LOCK1",
        "redundancy": 1,
        "row": 4063,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration LSBs for page 48 (rows 0xc00 through 0xc3f). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "State when at least one key is registered for this page and no matching key has been entered. 0x0 -> read_only 0x1 -> inaccessible",
                "mask": 64,
                "name": "NO_KEY_STATE"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant read access, or 0 if no such key is required.",
                "mask": 56,
                "name": "KEY_R"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant write access, or 0 if no such key is required.",
                "mask": 7,
                "name": "KEY_W"
            }
        ],
        "mask": 16777087,
        "name": "OTP_DATA_PAGE48_LOCK0",
        "redundancy": 1,
        "row": 4064,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration MSBs for page 48 (rows 0xc00 through 0xc3f). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "Dummy lock bits reserved for bootloaders (including the RP2350 USB bootloader) to store their own OTP access permissions. No hardware effect, and no corresponding SW_LOCKx registers. 0x0 -> Bootloader permits user reads and writes to this page 0x1 -> Bootloader permits user reads of this page 0x2 -> Do not use. Behaves the same as INACCESSIBLE 0x3 -> Bootloader does not permit user access to this page",
                "mask": 48,
                "name": "LOCK_BL"
            },
            {
                "description": "Lock state for Non-secure accesses to this page. Thermometer- coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. Note that READ_WRITE and READ_ONLY are equivalent in hardware, as the SBPI programming interface is not accessible to Non- secure software. However, Secure software may check these bits to apply write permissions to a Non-secure OTP programming API. 0x0 -> Page can be read by Non-secure software, and Secure software may permit Non-secure writes. 0x1 -> Page can be read by Non-secure software 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Non-secure software.",
                "mask": 12,
                "name": "LOCK_NS"
            },
            {
                "description": "Lock state for Secure accesses to this page. Thermometer-coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. 0x0 -> Page is fully accessible by Secure software. 0x1 -> Page can be read by Secure software, but can not be written. 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Secure software.",
                "mask": 3,
                "name": "LOCK_S"
            }
        ],
        "mask": 16777023,
        "name": "OTP_DATA_PAGE48_LOCK1",
        "redundancy": 1,
        "row": 4065,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration LSBs for page 49 (rows 0xc40 through 0xc7f). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "State when at least one key is registered for this page and no matching key has been entered. 0x0 -> read_only 0x1 -> inaccessible",
                "mask": 64,
                "name": "NO_KEY_STATE"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant read access, or 0 if no such key is required.",
                "mask": 56,
                "name": "KEY_R"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant write access, or 0 if no such key is required.",
                "mask": 7,
                "name": "KEY_W"
            }
        ],
        "mask": 16777087,
        "name": "OTP_DATA_PAGE49_LOCK0",
        "redundancy": 1,
        "row": 4066,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration MSBs for page 49 (rows 0xc40 through 0xc7f). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "Dummy lock bits reserved for bootloaders (including the RP2350 USB bootloader) to store their own OTP access permissions. No hardware effect, and no corresponding SW_LOCKx registers. 0x0 -> Bootloader permits user reads and writes to this page 0x1 -> Bootloader permits user reads of this page 0x2 -> Do not use. Behaves the same as INACCESSIBLE 0x3 -> Bootloader does not permit user access to this page",
                "mask": 48,
                "name": "LOCK_BL"
            },
            {
                "description": "Lock state for Non-secure accesses to this page. Thermometer- coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. Note that READ_WRITE and READ_ONLY are equivalent in hardware, as the SBPI programming interface is not accessible to Non- secure software. However, Secure software may check these bits to apply write permissions to a Non-secure OTP programming API. 0x0 -> Page can be read by Non-secure software, and Secure software may permit Non-secure writes. 0x1 -> Page can be read by Non-secure software 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Non-secure software.",
                "mask": 12,
                "name": "LOCK_NS"
            },
            {
                "description": "Lock state for Secure accesses to this page. Thermometer-coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. 0x0 -> Page is fully accessible by Secure software. 0x1 -> Page can be read by Secure software, but can not be written. 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Secure software.",
                "mask": 3,
                "name": "LOCK_S"
            }
        ],
        "mask": 16777023,
        "name": "OTP_DATA_PAGE49_LOCK1",
        "redundancy": 1,
        "row": 4067,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration LSBs for page 4 (rows 0x100 through 0x13f). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "State when at least one key is registered for this page and no matching key has been entered. 0x0 -> read_only 0x1 -> inaccessible",
                "mask": 64,
                "name": "NO_KEY_STATE"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant read access, or 0 if no such key is required.",
                "mask": 56,
                "name": "KEY_R"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant write access, or 0 if no such key is required.",
                "mask": 7,
                "name": "KEY_W"
            }
        ],
        "mask": 16777087,
        "name": "OTP_DATA_PAGE4_LOCK0",
        "redundancy": 1,
        "row": 3976,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration MSBs for page 4 (rows 0x100 through 0x13f). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "Dummy lock bits reserved for bootloaders (including the RP2350 USB bootloader) to store their own OTP access permissions. No hardware effect, and no corresponding SW_LOCKx registers. 0x0 -> Bootloader permits user reads and writes to this page 0x1 -> Bootloader permits user reads of this page 0x2 -> Do not use. Behaves the same as INACCESSIBLE 0x3 -> Bootloader does not permit user access to this page",
                "mask": 48,
                "name": "LOCK_BL"
            },
            {
                "description": "Lock state for Non-secure accesses to this page. Thermometer- coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. Note that READ_WRITE and READ_ONLY are equivalent in hardware, as the SBPI programming interface is not accessible to Non- secure software. However, Secure software may check these bits to apply write permissions to a Non-secure OTP programming API. 0x0 -> Page can be read by Non-secure software, and Secure software may permit Non-secure writes. 0x1 -> Page can be read by Non-secure software 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Non-secure software.",
                "mask": 12,
                "name": "LOCK_NS"
            },
            {
                "description": "Lock state for Secure accesses to this page. Thermometer-coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. 0x0 -> Page is fully accessible by Secure software. 0x1 -> Page can be read by Secure software, but can not be written. 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Secure software.",
                "mask": 3,
                "name": "LOCK_S"
            }
        ],
        "mask": 16777023,
        "name": "OTP_DATA_PAGE4_LOCK1",
        "redundancy": 1,
        "row": 3977,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration LSBs for page 50 (rows 0xc80 through 0xcbf). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "State when at least one key is registered for this page and no matching key has been entered. 0x0 -> read_only 0x1 -> inaccessible",
                "mask": 64,
                "name": "NO_KEY_STATE"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant read access, or 0 if no such key is required.",
                "mask": 56,
                "name": "KEY_R"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant write access, or 0 if no such key is required.",
                "mask": 7,
                "name": "KEY_W"
            }
        ],
        "mask": 16777087,
        "name": "OTP_DATA_PAGE50_LOCK0",
        "redundancy": 1,
        "row": 4068,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration MSBs for page 50 (rows 0xc80 through 0xcbf). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "Dummy lock bits reserved for bootloaders (including the RP2350 USB bootloader) to store their own OTP access permissions. No hardware effect, and no corresponding SW_LOCKx registers. 0x0 -> Bootloader permits user reads and writes to this page 0x1 -> Bootloader permits user reads of this page 0x2 -> Do not use. Behaves the same as INACCESSIBLE 0x3 -> Bootloader does not permit user access to this page",
                "mask": 48,
                "name": "LOCK_BL"
            },
            {
                "description": "Lock state for Non-secure accesses to this page. Thermometer- coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. Note that READ_WRITE and READ_ONLY are equivalent in hardware, as the SBPI programming interface is not accessible to Non- secure software. However, Secure software may check these bits to apply write permissions to a Non-secure OTP programming API. 0x0 -> Page can be read by Non-secure software, and Secure software may permit Non-secure writes. 0x1 -> Page can be read by Non-secure software 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Non-secure software.",
                "mask": 12,
                "name": "LOCK_NS"
            },
            {
                "description": "Lock state for Secure accesses to this page. Thermometer-coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. 0x0 -> Page is fully accessible by Secure software. 0x1 -> Page can be read by Secure software, but can not be written. 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Secure software.",
                "mask": 3,
                "name": "LOCK_S"
            }
        ],
        "mask": 16777023,
        "name": "OTP_DATA_PAGE50_LOCK1",
        "redundancy": 1,
        "row": 4069,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration LSBs for page 51 (rows 0xcc0 through 0xcff). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "State when at least one key is registered for this page and no matching key has been entered. 0x0 -> read_only 0x1 -> inaccessible",
                "mask": 64,
                "name": "NO_KEY_STATE"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant read access, or 0 if no such key is required.",
                "mask": 56,
                "name": "KEY_R"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant write access, or 0 if no such key is required.",
                "mask": 7,
                "name": "KEY_W"
            }
        ],
        "mask": 16777087,
        "name": "OTP_DATA_PAGE51_LOCK0",
        "redundancy": 1,
        "row": 4070,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration MSBs for page 51 (rows 0xcc0 through 0xcff). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "Dummy lock bits reserved for bootloaders (including the RP2350 USB bootloader) to store their own OTP access permissions. No hardware effect, and no corresponding SW_LOCKx registers. 0x0 -> Bootloader permits user reads and writes to this page 0x1 -> Bootloader permits user reads of this page 0x2 -> Do not use. Behaves the same as INACCESSIBLE 0x3 -> Bootloader does not permit user access to this page",
                "mask": 48,
                "name": "LOCK_BL"
            },
            {
                "description": "Lock state for Non-secure accesses to this page. Thermometer- coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. Note that READ_WRITE and READ_ONLY are equivalent in hardware, as the SBPI programming interface is not accessible to Non- secure software. However, Secure software may check these bits to apply write permissions to a Non-secure OTP programming API. 0x0 -> Page can be read by Non-secure software, and Secure software may permit Non-secure writes. 0x1 -> Page can be read by Non-secure software 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Non-secure software.",
                "mask": 12,
                "name": "LOCK_NS"
            },
            {
                "description": "Lock state for Secure accesses to this page. Thermometer-coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. 0x0 -> Page is fully accessible by Secure software. 0x1 -> Page can be read by Secure software, but can not be written. 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Secure software.",
                "mask": 3,
                "name": "LOCK_S"
            }
        ],
        "mask": 16777023,
        "name": "OTP_DATA_PAGE51_LOCK1",
        "redundancy": 1,
        "row": 4071,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration LSBs for page 52 (rows 0xd00 through 0xd3f). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "State when at least one key is registered for this page and no matching key has been entered. 0x0 -> read_only 0x1 -> inaccessible",
                "mask": 64,
                "name": "NO_KEY_STATE"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant read access, or 0 if no such key is required.",
                "mask": 56,
                "name": "KEY_R"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant write access, or 0 if no such key is required.",
                "mask": 7,
                "name": "KEY_W"
            }
        ],
        "mask": 16777087,
        "name": "OTP_DATA_PAGE52_LOCK0",
        "redundancy": 1,
        "row": 4072,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration MSBs for page 52 (rows 0xd00 through 0xd3f). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "Dummy lock bits reserved for bootloaders (including the RP2350 USB bootloader) to store their own OTP access permissions. No hardware effect, and no corresponding SW_LOCKx registers. 0x0 -> Bootloader permits user reads and writes to this page 0x1 -> Bootloader permits user reads of this page 0x2 -> Do not use. Behaves the same as INACCESSIBLE 0x3 -> Bootloader does not permit user access to this page",
                "mask": 48,
                "name": "LOCK_BL"
            },
            {
                "description": "Lock state for Non-secure accesses to this page. Thermometer- coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. Note that READ_WRITE and READ_ONLY are equivalent in hardware, as the SBPI programming interface is not accessible to Non- secure software. However, Secure software may check these bits to apply write permissions to a Non-secure OTP programming API. 0x0 -> Page can be read by Non-secure software, and Secure software may permit Non-secure writes. 0x1 -> Page can be read by Non-secure software 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Non-secure software.",
                "mask": 12,
                "name": "LOCK_NS"
            },
            {
                "description": "Lock state for Secure accesses to this page. Thermometer-coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. 0x0 -> Page is fully accessible by Secure software. 0x1 -> Page can be read by Secure software, but can not be written. 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Secure software.",
                "mask": 3,
                "name": "LOCK_S"
            }
        ],
        "mask": 16777023,
        "name": "OTP_DATA_PAGE52_LOCK1",
        "redundancy": 1,
        "row": 4073,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration LSBs for page 53 (rows 0xd40 through 0xd7f). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "State when at least one key is registered for this page and no matching key has been entered. 0x0 -> read_only 0x1 -> inaccessible",
                "mask": 64,
                "name": "NO_KEY_STATE"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant read access, or 0 if no such key is required.",
                "mask": 56,
                "name": "KEY_R"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant write access, or 0 if no such key is required.",
                "mask": 7,
                "name": "KEY_W"
            }
        ],
        "mask": 16777087,
        "name": "OTP_DATA_PAGE53_LOCK0",
        "redundancy": 1,
        "row": 4074,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration MSBs for page 53 (rows 0xd40 through 0xd7f). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "Dummy lock bits reserved for bootloaders (including the RP2350 USB bootloader) to store their own OTP access permissions. No hardware effect, and no corresponding SW_LOCKx registers. 0x0 -> Bootloader permits user reads and writes to this page 0x1 -> Bootloader permits user reads of this page 0x2 -> Do not use. Behaves the same as INACCESSIBLE 0x3 -> Bootloader does not permit user access to this page",
                "mask": 48,
                "name": "LOCK_BL"
            },
            {
                "description": "Lock state for Non-secure accesses to this page. Thermometer- coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. Note that READ_WRITE and READ_ONLY are equivalent in hardware, as the SBPI programming interface is not accessible to Non- secure software. However, Secure software may check these bits to apply write permissions to a Non-secure OTP programming API. 0x0 -> Page can be read by Non-secure software, and Secure software may permit Non-secure writes. 0x1 -> Page can be read by Non-secure software 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Non-secure software.",
                "mask": 12,
                "name": "LOCK_NS"
            },
            {
                "description": "Lock state for Secure accesses to this page. Thermometer-coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. 0x0 -> Page is fully accessible by Secure software. 0x1 -> Page can be read by Secure software, but can not be written. 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Secure software.",
                "mask": 3,
                "name": "LOCK_S"
            }
        ],
        "mask": 16777023,
        "name": "OTP_DATA_PAGE53_LOCK1",
        "redundancy": 1,
        "row": 4075,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration LSBs for page 54 (rows 0xd80 through 0xdbf). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "State when at least one key is registered for this page and no matching key has been entered. 0x0 -> read_only 0x1 -> inaccessible",
                "mask": 64,
                "name": "NO_KEY_STATE"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant read access, or 0 if no such key is required.",
                "mask": 56,
                "name": "KEY_R"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant write access, or 0 if no such key is required.",
                "mask": 7,
                "name": "KEY_W"
            }
        ],
        "mask": 16777087,
        "name": "OTP_DATA_PAGE54_LOCK0",
        "redundancy": 1,
        "row": 4076,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration MSBs for page 54 (rows 0xd80 through 0xdbf). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "Dummy lock bits reserved for bootloaders (including the RP2350 USB bootloader) to store their own OTP access permissions. No hardware effect, and no corresponding SW_LOCKx registers. 0x0 -> Bootloader permits user reads and writes to this page 0x1 -> Bootloader permits user reads of this page 0x2 -> Do not use. Behaves the same as INACCESSIBLE 0x3 -> Bootloader does not permit user access to this page",
                "mask": 48,
                "name": "LOCK_BL"
            },
            {
                "description": "Lock state for Non-secure accesses to this page. Thermometer- coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. Note that READ_WRITE and READ_ONLY are equivalent in hardware, as the SBPI programming interface is not accessible to Non- secure software. However, Secure software may check these bits to apply write permissions to a Non-secure OTP programming API. 0x0 -> Page can be read by Non-secure software, and Secure software may permit Non-secure writes. 0x1 -> Page can be read by Non-secure software 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Non-secure software.",
                "mask": 12,
                "name": "LOCK_NS"
            },
            {
                "description": "Lock state for Secure accesses to this page. Thermometer-coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. 0x0 -> Page is fully accessible by Secure software. 0x1 -> Page can be read by Secure software, but can not be written. 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Secure software.",
                "mask": 3,
                "name": "LOCK_S"
            }
        ],
        "mask": 16777023,
        "name": "OTP_DATA_PAGE54_LOCK1",
        "redundancy": 1,
        "row": 4077,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration LSBs for page 55 (rows 0xdc0 through 0xdff). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "State when at least one key is registered for this page and no matching key has been entered. 0x0 -> read_only 0x1 -> inaccessible",
                "mask": 64,
                "name": "NO_KEY_STATE"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant read access, or 0 if no such key is required.",
                "mask": 56,
                "name": "KEY_R"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant write access, or 0 if no such key is required.",
                "mask": 7,
                "name": "KEY_W"
            }
        ],
        "mask": 16777087,
        "name": "OTP_DATA_PAGE55_LOCK0",
        "redundancy": 1,
        "row": 4078,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration MSBs for page 55 (rows 0xdc0 through 0xdff). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "Dummy lock bits reserved for bootloaders (including the RP2350 USB bootloader) to store their own OTP access permissions. No hardware effect, and no corresponding SW_LOCKx registers. 0x0 -> Bootloader permits user reads and writes to this page 0x1 -> Bootloader permits user reads of this page 0x2 -> Do not use. Behaves the same as INACCESSIBLE 0x3 -> Bootloader does not permit user access to this page",
                "mask": 48,
                "name": "LOCK_BL"
            },
            {
                "description": "Lock state for Non-secure accesses to this page. Thermometer- coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. Note that READ_WRITE and READ_ONLY are equivalent in hardware, as the SBPI programming interface is not accessible to Non- secure software. However, Secure software may check these bits to apply write permissions to a Non-secure OTP programming API. 0x0 -> Page can be read by Non-secure software, and Secure software may permit Non-secure writes. 0x1 -> Page can be read by Non-secure software 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Non-secure software.",
                "mask": 12,
                "name": "LOCK_NS"
            },
            {
                "description": "Lock state for Secure accesses to this page. Thermometer-coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. 0x0 -> Page is fully accessible by Secure software. 0x1 -> Page can be read by Secure software, but can not be written. 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Secure software.",
                "mask": 3,
                "name": "LOCK_S"
            }
        ],
        "mask": 16777023,
        "name": "OTP_DATA_PAGE55_LOCK1",
        "redundancy": 1,
        "row": 4079,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration LSBs for page 56 (rows 0xe00 through 0xe3f). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "State when at least one key is registered for this page and no matching key has been entered. 0x0 -> read_only 0x1 -> inaccessible",
                "mask": 64,
                "name": "NO_KEY_STATE"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant read access, or 0 if no such key is required.",
                "mask": 56,
                "name": "KEY_R"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant write access, or 0 if no such key is required.",
                "mask": 7,
                "name": "KEY_W"
            }
        ],
        "mask": 16777087,
        "name": "OTP_DATA_PAGE56_LOCK0",
        "redundancy": 1,
        "row": 4080,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration MSBs for page 56 (rows 0xe00 through 0xe3f). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "Dummy lock bits reserved for bootloaders (including the RP2350 USB bootloader) to store their own OTP access permissions. No hardware effect, and no corresponding SW_LOCKx registers. 0x0 -> Bootloader permits user reads and writes to this page 0x1 -> Bootloader permits user reads of this page 0x2 -> Do not use. Behaves the same as INACCESSIBLE 0x3 -> Bootloader does not permit user access to this page",
                "mask": 48,
                "name": "LOCK_BL"
            },
            {
                "description": "Lock state for Non-secure accesses to this page. Thermometer- coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. Note that READ_WRITE and READ_ONLY are equivalent in hardware, as the SBPI programming interface is not accessible to Non- secure software. However, Secure software may check these bits to apply write permissions to a Non-secure OTP programming API. 0x0 -> Page can be read by Non-secure software, and Secure software may permit Non-secure writes. 0x1 -> Page can be read by Non-secure software 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Non-secure software.",
                "mask": 12,
                "name": "LOCK_NS"
            },
            {
                "description": "Lock state for Secure accesses to this page. Thermometer-coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. 0x0 -> Page is fully accessible by Secure software. 0x1 -> Page can be read by Secure software, but can not be written. 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Secure software.",
                "mask": 3,
                "name": "LOCK_S"
            }
        ],
        "mask": 16777023,
        "name": "OTP_DATA_PAGE56_LOCK1",
        "redundancy": 1,
        "row": 4081,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration LSBs for page 57 (rows 0xe40 through 0xe7f). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "State when at least one key is registered for this page and no matching key has been entered. 0x0 -> read_only 0x1 -> inaccessible",
                "mask": 64,
                "name": "NO_KEY_STATE"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant read access, or 0 if no such key is required.",
                "mask": 56,
                "name": "KEY_R"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant write access, or 0 if no such key is required.",
                "mask": 7,
                "name": "KEY_W"
            }
        ],
        "mask": 16777087,
        "name": "OTP_DATA_PAGE57_LOCK0",
        "redundancy": 1,
        "row": 4082,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration MSBs for page 57 (rows 0xe40 through 0xe7f). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "Dummy lock bits reserved for bootloaders (including the RP2350 USB bootloader) to store their own OTP access permissions. No hardware effect, and no corresponding SW_LOCKx registers. 0x0 -> Bootloader permits user reads and writes to this page 0x1 -> Bootloader permits user reads of this page 0x2 -> Do not use. Behaves the same as INACCESSIBLE 0x3 -> Bootloader does not permit user access to this page",
                "mask": 48,
                "name": "LOCK_BL"
            },
            {
                "description": "Lock state for Non-secure accesses to this page. Thermometer- coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. Note that READ_WRITE and READ_ONLY are equivalent in hardware, as the SBPI programming interface is not accessible to Non- secure software. However, Secure software may check these bits to apply write permissions to a Non-secure OTP programming API. 0x0 -> Page can be read by Non-secure software, and Secure software may permit Non-secure writes. 0x1 -> Page can be read by Non-secure software 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Non-secure software.",
                "mask": 12,
                "name": "LOCK_NS"
            },
            {
                "description": "Lock state for Secure accesses to this page. Thermometer-coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. 0x0 -> Page is fully accessible by Secure software. 0x1 -> Page can be read by Secure software, but can not be written. 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Secure software.",
                "mask": 3,
                "name": "LOCK_S"
            }
        ],
        "mask": 16777023,
        "name": "OTP_DATA_PAGE57_LOCK1",
        "redundancy": 1,
        "row": 4083,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration LSBs for page 58 (rows 0xe80 through 0xebf). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "State when at least one key is registered for this page and no matching key has been entered. 0x0 -> read_only 0x1 -> inaccessible",
                "mask": 64,
                "name": "NO_KEY_STATE"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant read access, or 0 if no such key is required.",
                "mask": 56,
                "name": "KEY_R"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant write access, or 0 if no such key is required.",
                "mask": 7,
                "name": "KEY_W"
            }
        ],
        "mask": 16777087,
        "name": "OTP_DATA_PAGE58_LOCK0",
        "redundancy": 1,
        "row": 4084,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration MSBs for page 58 (rows 0xe80 through 0xebf). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "Dummy lock bits reserved for bootloaders (including the RP2350 USB bootloader) to store their own OTP access permissions. No hardware effect, and no corresponding SW_LOCKx registers. 0x0 -> Bootloader permits user reads and writes to this page 0x1 -> Bootloader permits user reads of this page 0x2 -> Do not use. Behaves the same as INACCESSIBLE 0x3 -> Bootloader does not permit user access to this page",
                "mask": 48,
                "name": "LOCK_BL"
            },
            {
                "description": "Lock state for Non-secure accesses to this page. Thermometer- coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. Note that READ_WRITE and READ_ONLY are equivalent in hardware, as the SBPI programming interface is not accessible to Non- secure software. However, Secure software may check these bits to apply write permissions to a Non-secure OTP programming API. 0x0 -> Page can be read by Non-secure software, and Secure software may permit Non-secure writes. 0x1 -> Page can be read by Non-secure software 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Non-secure software.",
                "mask": 12,
                "name": "LOCK_NS"
            },
            {
                "description": "Lock state for Secure accesses to this page. Thermometer-coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. 0x0 -> Page is fully accessible by Secure software. 0x1 -> Page can be read by Secure software, but can not be written. 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Secure software.",
                "mask": 3,
                "name": "LOCK_S"
            }
        ],
        "mask": 16777023,
        "name": "OTP_DATA_PAGE58_LOCK1",
        "redundancy": 1,
        "row": 4085,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration LSBs for page 59 (rows 0xec0 through 0xeff). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "State when at least one key is registered for this page and no matching key has been entered. 0x0 -> read_only 0x1 -> inaccessible",
                "mask": 64,
                "name": "NO_KEY_STATE"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant read access, or 0 if no such key is required.",
                "mask": 56,
                "name": "KEY_R"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant write access, or 0 if no such key is required.",
                "mask": 7,
                "name": "KEY_W"
            }
        ],
        "mask": 16777087,
        "name": "OTP_DATA_PAGE59_LOCK0",
        "redundancy": 1,
        "row": 4086,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration MSBs for page 59 (rows 0xec0 through 0xeff). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "Dummy lock bits reserved for bootloaders (including the RP2350 USB bootloader) to store their own OTP access permissions. No hardware effect, and no corresponding SW_LOCKx registers. 0x0 -> Bootloader permits user reads and writes to this page 0x1 -> Bootloader permits user reads of this page 0x2 -> Do not use. Behaves the same as INACCESSIBLE 0x3 -> Bootloader does not permit user access to this page",
                "mask": 48,
                "name": "LOCK_BL"
            },
            {
                "description": "Lock state for Non-secure accesses to this page. Thermometer- coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. Note that READ_WRITE and READ_ONLY are equivalent in hardware, as the SBPI programming interface is not accessible to Non- secure software. However, Secure software may check these bits to apply write permissions to a Non-secure OTP programming API. 0x0 -> Page can be read by Non-secure software, and Secure software may permit Non-secure writes. 0x1 -> Page can be read by Non-secure software 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Non-secure software.",
                "mask": 12,
                "name": "LOCK_NS"
            },
            {
                "description": "Lock state for Secure accesses to this page. Thermometer-coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. 0x0 -> Page is fully accessible by Secure software. 0x1 -> Page can be read by Secure software, but can not be written. 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Secure software.",
                "mask": 3,
                "name": "LOCK_S"
            }
        ],
        "mask": 16777023,
        "name": "OTP_DATA_PAGE59_LOCK1",
        "redundancy": 1,
        "row": 4087,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration LSBs for page 5 (rows 0x140 through 0x17f). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "State when at least one key is registered for this page and no matching key has been entered. 0x0 -> read_only 0x1 -> inaccessible",
                "mask": 64,
                "name": "NO_KEY_STATE"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant read access, or 0 if no such key is required.",
                "mask": 56,
                "name": "KEY_R"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant write access, or 0 if no such key is required.",
                "mask": 7,
                "name": "KEY_W"
            }
        ],
        "mask": 16777087,
        "name": "OTP_DATA_PAGE5_LOCK0",
        "redundancy": 1,
        "row": 3978,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration MSBs for page 5 (rows 0x140 through 0x17f). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "Dummy lock bits reserved for bootloaders (including the RP2350 USB bootloader) to store their own OTP access permissions. No hardware effect, and no corresponding SW_LOCKx registers. 0x0 -> Bootloader permits user reads and writes to this page 0x1 -> Bootloader permits user reads of this page 0x2 -> Do not use. Behaves the same as INACCESSIBLE 0x3 -> Bootloader does not permit user access to this page",
                "mask": 48,
                "name": "LOCK_BL"
            },
            {
                "description": "Lock state for Non-secure accesses to this page. Thermometer- coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. Note that READ_WRITE and READ_ONLY are equivalent in hardware, as the SBPI programming interface is not accessible to Non- secure software. However, Secure software may check these bits to apply write permissions to a Non-secure OTP programming API. 0x0 -> Page can be read by Non-secure software, and Secure software may permit Non-secure writes. 0x1 -> Page can be read by Non-secure software 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Non-secure software.",
                "mask": 12,
                "name": "LOCK_NS"
            },
            {
                "description": "Lock state for Secure accesses to this page. Thermometer-coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. 0x0 -> Page is fully accessible by Secure software. 0x1 -> Page can be read by Secure software, but can not be written. 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Secure software.",
                "mask": 3,
                "name": "LOCK_S"
            }
        ],
        "mask": 16777023,
        "name": "OTP_DATA_PAGE5_LOCK1",
        "redundancy": 1,
        "row": 3979,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration LSBs for page 60 (rows 0xf00 through 0xf3f). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "State when at least one key is registered for this page and no matching key has been entered. 0x0 -> read_only 0x1 -> inaccessible",
                "mask": 64,
                "name": "NO_KEY_STATE"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant read access, or 0 if no such key is required.",
                "mask": 56,
                "name": "KEY_R"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant write access, or 0 if no such key is required.",
                "mask": 7,
                "name": "KEY_W"
            }
        ],
        "mask": 16777087,
        "name": "OTP_DATA_PAGE60_LOCK0",
        "redundancy": 1,
        "row": 4088,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration MSBs for page 60 (rows 0xf00 through 0xf3f). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "Dummy lock bits reserved for bootloaders (including the RP2350 USB bootloader) to store their own OTP access permissions. No hardware effect, and no corresponding SW_LOCKx registers. 0x0 -> Bootloader permits user reads and writes to this page 0x1 -> Bootloader permits user reads of this page 0x2 -> Do not use. Behaves the same as INACCESSIBLE 0x3 -> Bootloader does not permit user access to this page",
                "mask": 48,
                "name": "LOCK_BL"
            },
            {
                "description": "Lock state for Non-secure accesses to this page. Thermometer- coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. Note that READ_WRITE and READ_ONLY are equivalent in hardware, as the SBPI programming interface is not accessible to Non- secure software. However, Secure software may check these bits to apply write permissions to a Non-secure OTP programming API. 0x0 -> Page can be read by Non-secure software, and Secure software may permit Non-secure writes. 0x1 -> Page can be read by Non-secure software 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Non-secure software.",
                "mask": 12,
                "name": "LOCK_NS"
            },
            {
                "description": "Lock state for Secure accesses to this page. Thermometer-coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. 0x0 -> Page is fully accessible by Secure software. 0x1 -> Page can be read by Secure software, but can not be written. 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Secure software.",
                "mask": 3,
                "name": "LOCK_S"
            }
        ],
        "mask": 16777023,
        "name": "OTP_DATA_PAGE60_LOCK1",
        "redundancy": 1,
        "row": 4089,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration LSBs for page 61 (rows 0xf40 through 0xf7f). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "State when at least one key is registered for this page and no matching key has been entered. 0x0 -> read_only 0x1 -> inaccessible",
                "mask": 64,
                "name": "NO_KEY_STATE"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant read access, or 0 if no such key is required.",
                "mask": 56,
                "name": "KEY_R"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant write access, or 0 if no such key is required.",
                "mask": 7,
                "name": "KEY_W"
            }
        ],
        "mask": 16777087,
        "name": "OTP_DATA_PAGE61_LOCK0",
        "redundancy": 1,
        "row": 4090,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration MSBs for page 61 (rows 0xf40 through 0xf7f). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "Dummy lock bits reserved for bootloaders (including the RP2350 USB bootloader) to store their own OTP access permissions. No hardware effect, and no corresponding SW_LOCKx registers. 0x0 -> Bootloader permits user reads and writes to this page 0x1 -> Bootloader permits user reads of this page 0x2 -> Do not use. Behaves the same as INACCESSIBLE 0x3 -> Bootloader does not permit user access to this page",
                "mask": 48,
                "name": "LOCK_BL"
            },
            {
                "description": "Lock state for Non-secure accesses to this page. Thermometer- coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. Note that READ_WRITE and READ_ONLY are equivalent in hardware, as the SBPI programming interface is not accessible to Non- secure software. However, Secure software may check these bits to apply write permissions to a Non-secure OTP programming API. 0x0 -> Page can be read by Non-secure software, and Secure software may permit Non-secure writes. 0x1 -> Page can be read by Non-secure software 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Non-secure software.",
                "mask": 12,
                "name": "LOCK_NS"
            },
            {
                "description": "Lock state for Secure accesses to this page. Thermometer-coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. 0x0 -> Page is fully accessible by Secure software. 0x1 -> Page can be read by Secure software, but can not be written. 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Secure software.",
                "mask": 3,
                "name": "LOCK_S"
            }
        ],
        "mask": 16777023,
        "name": "OTP_DATA_PAGE61_LOCK1",
        "redundancy": 1,
        "row": 4091,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration LSBs for page 62 (rows 0xf80 through 0xfbf). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "State when at least one key is registered for this page and no matching key has been entered. 0x0 -> read_only 0x1 -> inaccessible",
                "mask": 64,
                "name": "NO_KEY_STATE"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant read access, or 0 if no such key is required.",
                "mask": 56,
                "name": "KEY_R"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant write access, or 0 if no such key is required.",
                "mask": 7,
                "name": "KEY_W"
            }
        ],
        "mask": 16777087,
        "name": "OTP_DATA_PAGE62_LOCK0",
        "redundancy": 1,
        "row": 4092,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration MSBs for page 62 (rows 0xf80 through 0xfbf). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "Dummy lock bits reserved for bootloaders (including the RP2350 USB bootloader) to store their own OTP access permissions. No hardware effect, and no corresponding SW_LOCKx registers. 0x0 -> Bootloader permits user reads and writes to this page 0x1 -> Bootloader permits user reads of this page 0x2 -> Do not use. Behaves the same as INACCESSIBLE 0x3 -> Bootloader does not permit user access to this page",
                "mask": 48,
                "name": "LOCK_BL"
            },
            {
                "description": "Lock state for Non-secure accesses to this page. Thermometer- coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. Note that READ_WRITE and READ_ONLY are equivalent in hardware, as the SBPI programming interface is not accessible to Non- secure software. However, Secure software may check these bits to apply write permissions to a Non-secure OTP programming API. 0x0 -> Page can be read by Non-secure software, and Secure software may permit Non-secure writes. 0x1 -> Page can be read by Non-secure software 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Non-secure software.",
                "mask": 12,
                "name": "LOCK_NS"
            },
            {
                "description": "Lock state for Secure accesses to this page. Thermometer-coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. 0x0 -> Page is fully accessible by Secure software. 0x1 -> Page can be read by Secure software, but can not be written. 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Secure software.",
                "mask": 3,
                "name": "LOCK_S"
            }
        ],
        "mask": 16777023,
        "name": "OTP_DATA_PAGE62_LOCK1",
        "redundancy": 1,
        "row": 4093,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration LSBs for page 63 (rows 0xfc0 through 0xfff). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "Decommission for RMA of a suspected faulty device. This re- enables the factory test JTAG interface, and makes pages 3 through 61 of the OTP permanently inaccessible.",
                "mask": 128,
                "name": "RMA"
            },
            {
                "description": "State when at least one key is registered for this page and no matching key has been entered. 0x0 -> read_only 0x1 -> inaccessible",
                "mask": 64,
                "name": "NO_KEY_STATE"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant read access, or 0 if no such key is required.",
                "mask": 56,
                "name": "KEY_R"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant write access, or 0 if no such key is required.",
                "mask": 7,
                "name": "KEY_W"
            }
        ],
        "mask": 16777215,
        "name": "OTP_DATA_PAGE63_LOCK0",
        "redundancy": 1,
        "row": 4094,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration MSBs for page 63 (rows 0xfc0 through 0xfff). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "Dummy lock bits reserved for bootloaders (including the RP2350 USB bootloader) to store their own OTP access permissions. No hardware effect, and no corresponding SW_LOCKx registers. 0x0 -> Bootloader permits user reads and writes to this page 0x1 -> Bootloader permits user reads of this page 0x2 -> Do not use. Behaves the same as INACCESSIBLE 0x3 -> Bootloader does not permit user access to this page",
                "mask": 48,
                "name": "LOCK_BL"
            },
            {
                "description": "Lock state for Non-secure accesses to this page. Thermometer- coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. Note that READ_WRITE and READ_ONLY are equivalent in hardware, as the SBPI programming interface is not accessible to Non- secure software. However, Secure software may check these bits to apply write permissions to a Non-secure OTP programming API. 0x0 -> Page can be read by Non-secure software, and Secure software may permit Non-secure writes. 0x1 -> Page can be read by Non-secure software 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Non-secure software.",
                "mask": 12,
                "name": "LOCK_NS"
            },
            {
                "description": "Lock state for Secure accesses to this page. Thermometer-coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. 0x0 -> Page is fully accessible by Secure software. 0x1 -> Page can be read by Secure software, but can not be written. 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Secure software.",
                "mask": 3,
                "name": "LOCK_S"
            }
        ],
        "mask": 16777023,
        "name": "OTP_DATA_PAGE63_LOCK1",
        "redundancy": 1,
        "row": 4095,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration LSBs for page 6 (rows 0x180 through 0x1bf). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "State when at least one key is registered for this page and no matching key has been entered. 0x0 -> read_only 0x1 -> inaccessible",
                "mask": 64,
                "name": "NO_KEY_STATE"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant read access, or 0 if no such key is required.",
                "mask": 56,
                "name": "KEY_R"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant write access, or 0 if no such key is required.",
                "mask": 7,
                "name": "KEY_W"
            }
        ],
        "mask": 16777087,
        "name": "OTP_DATA_PAGE6_LOCK0",
        "redundancy": 1,
        "row": 3980,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration MSBs for page 6 (rows 0x180 through 0x1bf). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "Dummy lock bits reserved for bootloaders (including the RP2350 USB bootloader) to store their own OTP access permissions. No hardware effect, and no corresponding SW_LOCKx registers. 0x0 -> Bootloader permits user reads and writes to this page 0x1 -> Bootloader permits user reads of this page 0x2 -> Do not use. Behaves the same as INACCESSIBLE 0x3 -> Bootloader does not permit user access to this page",
                "mask": 48,
                "name": "LOCK_BL"
            },
            {
                "description": "Lock state for Non-secure accesses to this page. Thermometer- coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. Note that READ_WRITE and READ_ONLY are equivalent in hardware, as the SBPI programming interface is not accessible to Non- secure software. However, Secure software may check these bits to apply write permissions to a Non-secure OTP programming API. 0x0 -> Page can be read by Non-secure software, and Secure software may permit Non-secure writes. 0x1 -> Page can be read by Non-secure software 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Non-secure software.",
                "mask": 12,
                "name": "LOCK_NS"
            },
            {
                "description": "Lock state for Secure accesses to this page. Thermometer-coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. 0x0 -> Page is fully accessible by Secure software. 0x1 -> Page can be read by Secure software, but can not be written. 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Secure software.",
                "mask": 3,
                "name": "LOCK_S"
            }
        ],
        "mask": 16777023,
        "name": "OTP_DATA_PAGE6_LOCK1",
        "redundancy": 1,
        "row": 3981,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration LSBs for page 7 (rows 0x1c0 through 0x1ff). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "State when at least one key is registered for this page and no matching key has been entered. 0x0 -> read_only 0x1 -> inaccessible",
                "mask": 64,
                "name": "NO_KEY_STATE"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant read access, or 0 if no such key is required.",
                "mask": 56,
                "name": "KEY_R"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant write access, or 0 if no such key is required.",
                "mask": 7,
                "name": "KEY_W"
            }
        ],
        "mask": 16777087,
        "name": "OTP_DATA_PAGE7_LOCK0",
        "redundancy": 1,
        "row": 3982,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration MSBs for page 7 (rows 0x1c0 through 0x1ff). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "Dummy lock bits reserved for bootloaders (including the RP2350 USB bootloader) to store their own OTP access permissions. No hardware effect, and no corresponding SW_LOCKx registers. 0x0 -> Bootloader permits user reads and writes to this page 0x1 -> Bootloader permits user reads of this page 0x2 -> Do not use. Behaves the same as INACCESSIBLE 0x3 -> Bootloader does not permit user access to this page",
                "mask": 48,
                "name": "LOCK_BL"
            },
            {
                "description": "Lock state for Non-secure accesses to this page. Thermometer- coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. Note that READ_WRITE and READ_ONLY are equivalent in hardware, as the SBPI programming interface is not accessible to Non- secure software. However, Secure software may check these bits to apply write permissions to a Non-secure OTP programming API. 0x0 -> Page can be read by Non-secure software, and Secure software may permit Non-secure writes. 0x1 -> Page can be read by Non-secure software 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Non-secure software.",
                "mask": 12,
                "name": "LOCK_NS"
            },
            {
                "description": "Lock state for Secure accesses to this page. Thermometer-coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. 0x0 -> Page is fully accessible by Secure software. 0x1 -> Page can be read by Secure software, but can not be written. 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Secure software.",
                "mask": 3,
                "name": "LOCK_S"
            }
        ],
        "mask": 16777023,
        "name": "OTP_DATA_PAGE7_LOCK1",
        "redundancy": 1,
        "row": 3983,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration LSBs for page 8 (rows 0x200 through 0x23f). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "State when at least one key is registered for this page and no matching key has been entered. 0x0 -> read_only 0x1 -> inaccessible",
                "mask": 64,
                "name": "NO_KEY_STATE"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant read access, or 0 if no such key is required.",
                "mask": 56,
                "name": "KEY_R"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant write access, or 0 if no such key is required.",
                "mask": 7,
                "name": "KEY_W"
            }
        ],
        "mask": 16777087,
        "name": "OTP_DATA_PAGE8_LOCK0",
        "redundancy": 1,
        "row": 3984,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration MSBs for page 8 (rows 0x200 through 0x23f). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "Dummy lock bits reserved for bootloaders (including the RP2350 USB bootloader) to store their own OTP access permissions. No hardware effect, and no corresponding SW_LOCKx registers. 0x0 -> Bootloader permits user reads and writes to this page 0x1 -> Bootloader permits user reads of this page 0x2 -> Do not use. Behaves the same as INACCESSIBLE 0x3 -> Bootloader does not permit user access to this page",
                "mask": 48,
                "name": "LOCK_BL"
            },
            {
                "description": "Lock state for Non-secure accesses to this page. Thermometer- coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. Note that READ_WRITE and READ_ONLY are equivalent in hardware, as the SBPI programming interface is not accessible to Non- secure software. However, Secure software may check these bits to apply write permissions to a Non-secure OTP programming API. 0x0 -> Page can be read by Non-secure software, and Secure software may permit Non-secure writes. 0x1 -> Page can be read by Non-secure software 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Non-secure software.",
                "mask": 12,
                "name": "LOCK_NS"
            },
            {
                "description": "Lock state for Secure accesses to this page. Thermometer-coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. 0x0 -> Page is fully accessible by Secure software. 0x1 -> Page can be read by Secure software, but can not be written. 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Secure software.",
                "mask": 3,
                "name": "LOCK_S"
            }
        ],
        "mask": 16777023,
        "name": "OTP_DATA_PAGE8_LOCK1",
        "redundancy": 1,
        "row": 3985,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration LSBs for page 9 (rows 0x240 through 0x27f). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "State when at least one key is registered for this page and no matching key has been entered. 0x0 -> read_only 0x1 -> inaccessible",
                "mask": 64,
                "name": "NO_KEY_STATE"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant read access, or 0 if no such key is required.",
                "mask": 56,
                "name": "KEY_R"
            },
            {
                "description": "Index 1-6 of a hardware key which must be entered to grant write access, or 0 if no such key is required.",
                "mask": 7,
                "name": "KEY_W"
            }
        ],
        "mask": 16777087,
        "name": "OTP_DATA_PAGE9_LOCK0",
        "redundancy": 1,
        "row": 3986,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Lock configuration MSBs for page 9 (rows 0x240 through 0x27f). Locks are stored with 3-way majority vote encoding, so that bits can be set independently. This OTP location is always readable, and is write-protected by its own permissions.",
        "ecc": false,
        "fields": [
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 16711680,
                "name": "R2"
            },
            {
                "description": "Redundant copy of bits 7:0",
                "mask": 65280,
                "name": "R1"
            },
            {
                "description": "Dummy lock bits reserved for bootloaders (including the RP2350 USB bootloader) to store their own OTP access permissions. No hardware effect, and no corresponding SW_LOCKx registers. 0x0 -> Bootloader permits user reads and writes to this page 0x1 -> Bootloader permits user reads of this page 0x2 -> Do not use. Behaves the same as INACCESSIBLE 0x3 -> Bootloader does not permit user access to this page",
                "mask": 48,
                "name": "LOCK_BL"
            },
            {
                "description": "Lock state for Non-secure accesses to this page. Thermometer- coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. Note that READ_WRITE and READ_ONLY are equivalent in hardware, as the SBPI programming interface is not accessible to Non- secure software. However, Secure software may check these bits to apply write permissions to a Non-secure OTP programming API. 0x0 -> Page can be read by Non-secure software, and Secure software may permit Non-secure writes. 0x1 -> Page can be read by Non-secure software 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Non-secure software.",
                "mask": 12,
                "name": "LOCK_NS"
            },
            {
                "description": "Lock state for Secure accesses to this page. Thermometer-coded, so lock state can be advanced permanently from any state to any less-permissive state by programming OTP. Software can also advance the lock state temporarily (until next OTP reset) using the SW_LOCKx registers. 0x0 -> Page is fully accessible by Secure software. 0x1 -> Page can be read by Secure software, but can not be written. 0x2 -> Do not use. Behaves the same as INACCESSIBLE. 0x3 -> Page can not be accessed by Secure software.",
                "mask": 3,
                "name": "LOCK_S"
            }
        ],
        "mask": 16777023,
        "name": "OTP_DATA_PAGE9_LOCK1",
        "redundancy": 1,
        "row": 3987,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Bits 15:0 of private per-device random number (ECC) The RANDID0..7 rows form a 128-bit random number generated during device test. This ID is not exposed through the USB PICOBOOT GET_INFO command or the ROM `get_sys_info()` API. However note that the USB PICOBOOT OTP access point can read the entirety of page 0, so this value is not meaningfully private unless the USB PICOBOOT interface is disabled via the DISABLE_BOOTSEL_USB_PICOBOOT_IFC flag in BOOT_FLAGS0.",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_RANDID0",
        "redundancy": 1,
        "row": 4,
        "seq_index": 0,
        "seq_length": 8,
        "seq_prefix": "OTP_DATA_RANDID"
    },
    {
        "crit": false,
        "description": "Bits 31:16 of private per-device random number (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_RANDID1",
        "redundancy": 1,
        "row": 5,
        "seq_index": 1,
        "seq_length": 8,
        "seq_prefix": "OTP_DATA_RANDID"
    },
    {
        "crit": false,
        "description": "Bits 47:32 of private per-device random number (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_RANDID2",
        "redundancy": 1,
        "row": 6,
        "seq_index": 2,
        "seq_length": 8,
        "seq_prefix": "OTP_DATA_RANDID"
    },
    {
        "crit": false,
        "description": "Bits 63:48 of private per-device random number (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_RANDID3",
        "redundancy": 1,
        "row": 7,
        "seq_index": 3,
        "seq_length": 8,
        "seq_prefix": "OTP_DATA_RANDID"
    },
    {
        "crit": false,
        "description": "Bits 79:64 of private per-device random number (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_RANDID4",
        "redundancy": 1,
        "row": 8,
        "seq_index": 4,
        "seq_length": 8,
        "seq_prefix": "OTP_DATA_RANDID"
    },
    {
        "crit": false,
        "description": "Bits 95:80 of private per-device random number (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_RANDID5",
        "redundancy": 1,
        "row": 9,
        "seq_index": 5,
        "seq_length": 8,
        "seq_prefix": "OTP_DATA_RANDID"
    },
    {
        "crit": false,
        "description": "Bits 111:96 of private per-device random number (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_RANDID6",
        "redundancy": 1,
        "row": 10,
        "seq_index": 6,
        "seq_length": 8,
        "seq_prefix": "OTP_DATA_RANDID"
    },
    {
        "crit": false,
        "description": "Bits 127:112 of private per-device random number (ECC)",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_RANDID7",
        "redundancy": 1,
        "row": 11,
        "seq_index": 7,
        "seq_length": 8,
        "seq_prefix": "OTP_DATA_RANDID"
    },
    {
        "crit": false,
        "description": "Ring oscillator frequency in kHz, measured during manufacturing (ECC) This is measured at 1.1 V, at room temperature, with the ROSC configuration registers in their reset state.",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_ROSC_CALIB",
        "redundancy": 1,
        "row": 16,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "USB boot specific feature flags (RBIT-3)",
        "ecc": false,
        "fields": [
            {
                "description": "Swap DM/DP during USB boot, to support board layouts with mirrored USB routing (deliberate or accidental).",
                "mask": 8388608,
                "name": "DP_DM_SWAP"
            },
            {
                "description": "valid flag for INFO_UF2_TXT_BOARD_ID_STRDEF entry of the USB_WHITE_LABEL struct (index 15)",
                "mask": 4194304,
                "name": "WHITE_LABEL_ADDR_VALID"
            },
            {
                "description": "valid flag for the USB_WHITE_LABEL_ADDR field",
                "mask": 32768,
                "name": "WL_INFO_UF2_TXT_BOARD_ID_STRDEF_VALID"
            },
            {
                "description": "valid flag for INFO_UF2_TXT_MODEL_STRDEF entry of the USB_WHITE_LABEL struct (index 14)",
                "mask": 16384,
                "name": "WL_INFO_UF2_TXT_MODEL_STRDEF_VALID"
            },
            {
                "description": "valid flag for INDEX_HTM_REDIRECT_NAME_STRDEF entry of the USB_WHITE_LABEL struct (index 13)",
                "mask": 8192,
                "name": "WL_INDEX_HTM_REDIRECT_NAME_STRDEF_VALID"
            },
            {
                "description": "valid flag for INDEX_HTM_REDIRECT_URL_STRDEF entry of the USB_WHITE_LABEL struct (index 12)",
                "mask": 4096,
                "name": "WL_INDEX_HTM_REDIRECT_URL_STRDEF_VALID"
            },
            {
                "description": "valid flag for SCSI_INQUIRY_VERSION_STRDEF entry of the USB_WHITE_LABEL struct (index 11)",
                "mask": 2048,
                "name": "WL_SCSI_INQUIRY_VERSION_STRDEF_VALID"
            },
            {
                "description": "valid flag for SCSI_INQUIRY_PRODUCT_STRDEF entry of the USB_WHITE_LABEL struct (index 10)",
                "mask": 1024,
                "name": "WL_SCSI_INQUIRY_PRODUCT_STRDEF_VALID"
            },
            {
                "description": "valid flag for SCSI_INQUIRY_VENDOR_STRDEF entry of the USB_WHITE_LABEL struct (index 9)",
                "mask": 512,
                "name": "WL_SCSI_INQUIRY_VENDOR_STRDEF_VALID"
            },
            {
                "description": "valid flag for VOLUME_LABEL_STRDEF entry of the USB_WHITE_LABEL struct (index 8)",
                "mask": 256,
                "name": "WL_VOLUME_LABEL_STRDEF_VALID"
            },
            {
                "description": "valid flag for USB_CONFIG_ATTRIBUTES_MAX_POWER_VALUES entry of the USB_WHITE_LABEL struct (index 7)",
                "mask": 128,
                "name": "WL_USB_CONFIG_ATTRIBUTES_MAX_POWER_VALUES_VALID"
            },
            {
                "description": "valid flag for USB_DEVICE_SERIAL_NUMBER_STRDEF entry of the USB_WHITE_LABEL struct (index 6)",
                "mask": 64,
                "name": "WL_USB_DEVICE_SERIAL_NUMBER_STRDEF_VALID"
            },
            {
                "description": "valid flag for USB_DEVICE_PRODUCT_STRDEF entry of the USB_WHITE_LABEL struct (index 5)",
                "mask": 32,
                "name": "WL_USB_DEVICE_PRODUCT_STRDEF_VALID"
            },
            {
                "description": "valid flag for USB_DEVICE_MANUFACTURER_STRDEF entry of the USB_WHITE_LABEL struct (index 4)",
                "mask": 16,
                "name": "WL_USB_DEVICE_MANUFACTURER_STRDEF_VALID"
            },
            {
                "description": "valid flag for USB_DEVICE_LANG_ID_VALUE entry of the USB_WHITE_LABEL struct (index 3)",
                "mask": 8,
                "name": "WL_USB_DEVICE_LANG_ID_VALUE_VALID"
            },
            {
                "description": "valid flag for USB_DEVICE_BCD_DEVICEVALUE entry of the USB_WHITE_LABEL struct (index 2)",
                "mask": 4,
                "name": "WL_USB_DEVICE_SERIAL_NUMBER_VALUE_VALID"
            },
            {
                "description": "valid flag for USB_DEVICE_PID_VALUE entry of the USB_WHITE_LABEL struct (index 1)",
                "mask": 2,
                "name": "WL_USB_DEVICE_PID_VALUE_VALID"
            },
            {
                "description": "valid flag for USB_DEVICE_VID_VALUE entry of the USB_WHITE_LABEL struct (index 0)",
                "mask": 1,
                "name": "WL_USB_DEVICE_VID_VALUE_VALID"
            }
        ],
        "mask": 12648447,
        "name": "OTP_DATA_USB_BOOT_FLAGS",
        "redundancy": 3,
        "row": 89,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    },
    {
        "crit": false,
        "description": "Row index of the USB_WHITE_LABEL structure within OTP (ECC) The table has 16 rows, each of which are also ECC and marked valid by the corresponding valid bit in USB_BOOT_FLAGS (ECC). The entries are either _VALUEs where the 16 bit value is used as is, or _STRDEFs which acts as a pointers to a string value. The value stored in a _STRDEF is two separate bytes: The low seven bits of the first (LSB) byte indicates the number of characters in the string, and the top bit of the first (LSB) byte if set to indicate that each character in the string is two bytes (Unicode) versus one byte if unset. The second (MSB) byte represents the location of the string data, and is encoded as the number of rows from this USB_WHITE_LABEL_ADDR; i.e. the row of the start of the string is USB_WHITE_LABEL_ADDR value + msb_byte. In each case, the corresponding valid bit enables replacing the default value for the corresponding item provided by the boot rom. Note that Unicode _STRDEFs are only supported for USB_DEVICE_PRODUCT_STRDEF, USB_DEVICE_SERIAL_NUMBER_STRDEF and USB_DEVICE_MANUFACTURER_STRDEF. Unicode values will be ignored if specified for other fields, and non-unicode values for these three items will be converted to Unicode characters by setting the upper 8 bits to zero. Note that if the USB_WHITE_LABEL structure or the corresponding strings are not readable by BOOTSEL mode based on OTP permissions, or if alignment requirements are not met, then the corresponding default values are used. The index values indicate where each field is located (row USB_WHITE_LABEL_ADDR value + index): 0x0000 -> INDEX_USB_DEVICE_VID_VALUE 0x0001 -> INDEX_USB_DEVICE_PID_VALUE 0x0002 -> INDEX_USB_DEVICE_BCD_DEVICE_VALUE 0x0003 -> INDEX_USB_DEVICE_LANG_ID_VALUE 0x0004 -> INDEX_USB_DEVICE_MANUFACTURER_STRDEF 0x0005 -> INDEX_USB_DEVICE_PRODUCT_STRDEF 0x0006 -> INDEX_USB_DEVICE_SERIAL_NUMBER_STRDEF 0x0007 -> INDEX_USB_CONFIG_ATTRIBUTES_MAX_POWER_VALUES 0x0008 -> INDEX_VOLUME_LABEL_STRDEF 0x0009 -> INDEX_SCSI_INQUIRY_VENDOR_STRDEF 0x000a -> INDEX_SCSI_INQUIRY_PRODUCT_STRDEF 0x000b -> INDEX_SCSI_INQUIRY_VERSION_STRDEF 0x000c -> INDEX_INDEX_HTM_REDIRECT_URL_STRDEF 0x000d -> INDEX_INDEX_HTM_REDIRECT_NAME_STRDEF 0x000e -> INDEX_INFO_UF2_TXT_MODEL_STRDEF 0x000f -> INDEX_INFO_UF2_TXT_BOARD_ID_STRDEF",
        "ecc": true,
        "fields": [],
        "mask": 65535,
        "name": "OTP_DATA_USB_WHITE_LABEL_ADDR",
        "redundancy": 1,
        "row": 92,
        "seq_index": 0,
        "seq_length": 0,
        "seq_prefix": ""
    }
]

)""";
