from chardet.enums import CharacterCategory, SequenceLikelihood
from chardet.sbcharsetprober import SingleByteCharSetModel

UKRAINIAN_LANG_MODEL = {
    67: {  # 'ʼ'
        67: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        57: SequenceLikelihood.UNLIKELY,  # 'Є'
        46: SequenceLikelihood.NEGATIVE,  # 'І'
        63: SequenceLikelihood.NEGATIVE,  # 'Ї'
        39: SequenceLikelihood.NEGATIVE,  # 'А'
        47: SequenceLikelihood.NEGATIVE,  # 'Б'
        34: SequenceLikelihood.NEGATIVE,  # 'В'
        48: SequenceLikelihood.NEGATIVE,  # 'Г'
        40: SequenceLikelihood.NEGATIVE,  # 'Д'
        54: SequenceLikelihood.NEGATIVE,  # 'Е'
        60: SequenceLikelihood.NEGATIVE,  # 'Ж'
        44: SequenceLikelihood.NEGATIVE,  # 'З'
        58: SequenceLikelihood.NEGATIVE,  # 'И'
        62: SequenceLikelihood.NEGATIVE,  # 'Й'
        36: SequenceLikelihood.NEGATIVE,  # 'К'
        49: SequenceLikelihood.NEGATIVE,  # 'Л'
        42: SequenceLikelihood.NEGATIVE,  # 'М'
        37: SequenceLikelihood.NEGATIVE,  # 'Н'
        41: SequenceLikelihood.NEGATIVE,  # 'О'
        33: SequenceLikelihood.NEGATIVE,  # 'П'
        45: SequenceLikelihood.NEGATIVE,  # 'Р'
        35: SequenceLikelihood.NEGATIVE,  # 'С'
        43: SequenceLikelihood.NEGATIVE,  # 'Т'
        38: SequenceLikelihood.NEGATIVE,  # 'У'
        53: SequenceLikelihood.NEGATIVE,  # 'Ф'
        55: SequenceLikelihood.NEGATIVE,  # 'Х'
        51: SequenceLikelihood.NEGATIVE,  # 'Ц'
        52: SequenceLikelihood.NEGATIVE,  # 'Ч'
        56: SequenceLikelihood.NEGATIVE,  # 'Ш'
        59: SequenceLikelihood.NEGATIVE,  # 'Щ'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        61: SequenceLikelihood.NEGATIVE,  # 'Ю'
        50: SequenceLikelihood.NEGATIVE,  # 'Я'
        2: SequenceLikelihood.NEGATIVE,  # 'а'
        21: SequenceLikelihood.NEGATIVE,  # 'б'
        7: SequenceLikelihood.NEGATIVE,  # 'в'
        20: SequenceLikelihood.NEGATIVE,  # 'г'
        13: SequenceLikelihood.NEGATIVE,  # 'д'
        9: SequenceLikelihood.NEGATIVE,  # 'е'
        26: SequenceLikelihood.NEGATIVE,  # 'ж'
        18: SequenceLikelihood.NEGATIVE,  # 'з'
        4: SequenceLikelihood.NEGATIVE,  # 'и'
        23: SequenceLikelihood.NEGATIVE,  # 'й'
        11: SequenceLikelihood.NEGATIVE,  # 'к'
        12: SequenceLikelihood.NEGATIVE,  # 'л'
        15: SequenceLikelihood.UNLIKELY,  # 'м'
        3: SequenceLikelihood.NEGATIVE,  # 'н'
        1: SequenceLikelihood.NEGATIVE,  # 'о'
        16: SequenceLikelihood.NEGATIVE,  # 'п'
        8: SequenceLikelihood.NEGATIVE,  # 'р'
        10: SequenceLikelihood.NEGATIVE,  # 'с'
        6: SequenceLikelihood.NEGATIVE,  # 'т'
        14: SequenceLikelihood.NEGATIVE,  # 'у'
        32: SequenceLikelihood.NEGATIVE,  # 'ф'
        24: SequenceLikelihood.NEGATIVE,  # 'х'
        25: SequenceLikelihood.NEGATIVE,  # 'ц'
        22: SequenceLikelihood.NEGATIVE,  # 'ч'
        29: SequenceLikelihood.NEGATIVE,  # 'ш'
        31: SequenceLikelihood.NEGATIVE,  # 'щ'
        19: SequenceLikelihood.NEGATIVE,  # 'ь'
        27: SequenceLikelihood.UNLIKELY,  # 'ю'
        17: SequenceLikelihood.UNLIKELY,  # 'я'
        30: SequenceLikelihood.UNLIKELY,  # 'є'
        5: SequenceLikelihood.NEGATIVE,  # 'і'
        28: SequenceLikelihood.UNLIKELY,  # 'ї'
        66: SequenceLikelihood.NEGATIVE,  # 'Ґ'
        65: SequenceLikelihood.NEGATIVE,  # 'ґ'
    },
    57: {  # 'Є'
        67: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        57: SequenceLikelihood.UNLIKELY,  # 'Є'
        46: SequenceLikelihood.UNLIKELY,  # 'І'
        63: SequenceLikelihood.UNLIKELY,  # 'Ї'
        39: SequenceLikelihood.UNLIKELY,  # 'А'
        47: SequenceLikelihood.UNLIKELY,  # 'Б'
        34: SequenceLikelihood.UNLIKELY,  # 'В'
        48: SequenceLikelihood.UNLIKELY,  # 'Г'
        40: SequenceLikelihood.UNLIKELY,  # 'Д'
        54: SequenceLikelihood.UNLIKELY,  # 'Е'
        60: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        58: SequenceLikelihood.NEGATIVE,  # 'И'
        62: SequenceLikelihood.UNLIKELY,  # 'Й'
        36: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        42: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        33: SequenceLikelihood.UNLIKELY,  # 'П'
        45: SequenceLikelihood.UNLIKELY,  # 'Р'
        35: SequenceLikelihood.LIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        38: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        55: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        52: SequenceLikelihood.UNLIKELY,  # 'Ч'
        56: SequenceLikelihood.UNLIKELY,  # 'Ш'
        59: SequenceLikelihood.NEGATIVE,  # 'Щ'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        61: SequenceLikelihood.UNLIKELY,  # 'Ю'
        50: SequenceLikelihood.NEGATIVE,  # 'Я'
        2: SequenceLikelihood.UNLIKELY,  # 'а'
        21: SequenceLikelihood.NEGATIVE,  # 'б'
        7: SequenceLikelihood.LIKELY,  # 'в'
        20: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.LIKELY,  # 'д'
        9: SequenceLikelihood.UNLIKELY,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.NEGATIVE,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        12: SequenceLikelihood.UNLIKELY,  # 'л'
        15: SequenceLikelihood.UNLIKELY,  # 'м'
        3: SequenceLikelihood.UNLIKELY,  # 'н'
        1: SequenceLikelihood.NEGATIVE,  # 'о'
        16: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        6: SequenceLikelihood.UNLIKELY,  # 'т'
        14: SequenceLikelihood.UNLIKELY,  # 'у'
        32: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        25: SequenceLikelihood.NEGATIVE,  # 'ц'
        22: SequenceLikelihood.NEGATIVE,  # 'ч'
        29: SequenceLikelihood.UNLIKELY,  # 'ш'
        31: SequenceLikelihood.UNLIKELY,  # 'щ'
        19: SequenceLikelihood.NEGATIVE,  # 'ь'
        27: SequenceLikelihood.NEGATIVE,  # 'ю'
        17: SequenceLikelihood.UNLIKELY,  # 'я'
        30: SequenceLikelihood.UNLIKELY,  # 'є'
        5: SequenceLikelihood.UNLIKELY,  # 'і'
        28: SequenceLikelihood.NEGATIVE,  # 'ї'
        66: SequenceLikelihood.NEGATIVE,  # 'Ґ'
        65: SequenceLikelihood.UNLIKELY,  # 'ґ'
    },
    46: {  # 'І'
        67: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        57: SequenceLikelihood.UNLIKELY,  # 'Є'
        46: SequenceLikelihood.LIKELY,  # 'І'
        63: SequenceLikelihood.UNLIKELY,  # 'Ї'
        39: SequenceLikelihood.UNLIKELY,  # 'А'
        47: SequenceLikelihood.UNLIKELY,  # 'Б'
        34: SequenceLikelihood.LIKELY,  # 'В'
        48: SequenceLikelihood.UNLIKELY,  # 'Г'
        40: SequenceLikelihood.LIKELY,  # 'Д'
        54: SequenceLikelihood.UNLIKELY,  # 'Е'
        60: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        58: SequenceLikelihood.UNLIKELY,  # 'И'
        62: SequenceLikelihood.UNLIKELY,  # 'Й'
        36: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.LIKELY,  # 'Л'
        42: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.LIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        33: SequenceLikelihood.UNLIKELY,  # 'П'
        45: SequenceLikelihood.UNLIKELY,  # 'Р'
        35: SequenceLikelihood.LIKELY,  # 'С'
        43: SequenceLikelihood.LIKELY,  # 'Т'
        38: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        55: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        52: SequenceLikelihood.UNLIKELY,  # 'Ч'
        56: SequenceLikelihood.UNLIKELY,  # 'Ш'
        59: SequenceLikelihood.UNLIKELY,  # 'Щ'
        64: SequenceLikelihood.UNLIKELY,  # 'Ь'
        61: SequenceLikelihood.UNLIKELY,  # 'Ю'
        50: SequenceLikelihood.UNLIKELY,  # 'Я'
        2: SequenceLikelihood.UNLIKELY,  # 'а'
        21: SequenceLikelihood.UNLIKELY,  # 'б'
        7: SequenceLikelihood.LIKELY,  # 'в'
        20: SequenceLikelihood.LIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        9: SequenceLikelihood.UNLIKELY,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.LIKELY,  # 'з'
        4: SequenceLikelihood.UNLIKELY,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        12: SequenceLikelihood.LIKELY,  # 'л'
        15: SequenceLikelihood.UNLIKELY,  # 'м'
        3: SequenceLikelihood.POSITIVE,  # 'н'
        1: SequenceLikelihood.UNLIKELY,  # 'о'
        16: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.LIKELY,  # 'р'
        10: SequenceLikelihood.LIKELY,  # 'с'
        6: SequenceLikelihood.LIKELY,  # 'т'
        14: SequenceLikelihood.UNLIKELY,  # 'у'
        32: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        25: SequenceLikelihood.UNLIKELY,  # 'ц'
        22: SequenceLikelihood.UNLIKELY,  # 'ч'
        29: SequenceLikelihood.UNLIKELY,  # 'ш'
        31: SequenceLikelihood.UNLIKELY,  # 'щ'
        19: SequenceLikelihood.NEGATIVE,  # 'ь'
        27: SequenceLikelihood.UNLIKELY,  # 'ю'
        17: SequenceLikelihood.UNLIKELY,  # 'я'
        30: SequenceLikelihood.UNLIKELY,  # 'є'
        5: SequenceLikelihood.UNLIKELY,  # 'і'
        28: SequenceLikelihood.UNLIKELY,  # 'ї'
        66: SequenceLikelihood.UNLIKELY,  # 'Ґ'
        65: SequenceLikelihood.UNLIKELY,  # 'ґ'
    },
    63: {  # 'Ї'
        67: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        57: SequenceLikelihood.NEGATIVE,  # 'Є'
        46: SequenceLikelihood.UNLIKELY,  # 'І'
        63: SequenceLikelihood.UNLIKELY,  # 'Ї'
        39: SequenceLikelihood.UNLIKELY,  # 'А'
        47: SequenceLikelihood.UNLIKELY,  # 'Б'
        34: SequenceLikelihood.UNLIKELY,  # 'В'
        48: SequenceLikelihood.NEGATIVE,  # 'Г'
        40: SequenceLikelihood.UNLIKELY,  # 'Д'
        54: SequenceLikelihood.UNLIKELY,  # 'Е'
        60: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        58: SequenceLikelihood.UNLIKELY,  # 'И'
        62: SequenceLikelihood.UNLIKELY,  # 'Й'
        36: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        42: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.NEGATIVE,  # 'О'
        33: SequenceLikelihood.UNLIKELY,  # 'П'
        45: SequenceLikelihood.UNLIKELY,  # 'Р'
        35: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        38: SequenceLikelihood.NEGATIVE,  # 'У'
        53: SequenceLikelihood.NEGATIVE,  # 'Ф'
        55: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        52: SequenceLikelihood.UNLIKELY,  # 'Ч'
        56: SequenceLikelihood.NEGATIVE,  # 'Ш'
        59: SequenceLikelihood.NEGATIVE,  # 'Щ'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        61: SequenceLikelihood.NEGATIVE,  # 'Ю'
        50: SequenceLikelihood.NEGATIVE,  # 'Я'
        2: SequenceLikelihood.NEGATIVE,  # 'а'
        21: SequenceLikelihood.UNLIKELY,  # 'б'
        7: SequenceLikelihood.UNLIKELY,  # 'в'
        20: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        9: SequenceLikelihood.NEGATIVE,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.NEGATIVE,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.NEGATIVE,  # 'к'
        12: SequenceLikelihood.UNLIKELY,  # 'л'
        15: SequenceLikelihood.UNLIKELY,  # 'м'
        3: SequenceLikelihood.UNLIKELY,  # 'н'
        1: SequenceLikelihood.NEGATIVE,  # 'о'
        16: SequenceLikelihood.NEGATIVE,  # 'п'
        8: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        6: SequenceLikelihood.NEGATIVE,  # 'т'
        14: SequenceLikelihood.NEGATIVE,  # 'у'
        32: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.LIKELY,  # 'х'
        25: SequenceLikelihood.NEGATIVE,  # 'ц'
        22: SequenceLikelihood.UNLIKELY,  # 'ч'
        29: SequenceLikelihood.UNLIKELY,  # 'ш'
        31: SequenceLikelihood.NEGATIVE,  # 'щ'
        19: SequenceLikelihood.NEGATIVE,  # 'ь'
        27: SequenceLikelihood.NEGATIVE,  # 'ю'
        17: SequenceLikelihood.NEGATIVE,  # 'я'
        30: SequenceLikelihood.NEGATIVE,  # 'є'
        5: SequenceLikelihood.UNLIKELY,  # 'і'
        28: SequenceLikelihood.LIKELY,  # 'ї'
        66: SequenceLikelihood.NEGATIVE,  # 'Ґ'
        65: SequenceLikelihood.NEGATIVE,  # 'ґ'
    },
    39: {  # 'А'
        67: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        57: SequenceLikelihood.UNLIKELY,  # 'Є'
        46: SequenceLikelihood.UNLIKELY,  # 'І'
        63: SequenceLikelihood.UNLIKELY,  # 'Ї'
        39: SequenceLikelihood.UNLIKELY,  # 'А'
        47: SequenceLikelihood.LIKELY,  # 'Б'
        34: SequenceLikelihood.LIKELY,  # 'В'
        48: SequenceLikelihood.UNLIKELY,  # 'Г'
        40: SequenceLikelihood.LIKELY,  # 'Д'
        54: SequenceLikelihood.UNLIKELY,  # 'Е'
        60: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.LIKELY,  # 'З'
        58: SequenceLikelihood.UNLIKELY,  # 'И'
        62: SequenceLikelihood.UNLIKELY,  # 'Й'
        36: SequenceLikelihood.LIKELY,  # 'К'
        49: SequenceLikelihood.LIKELY,  # 'Л'
        42: SequenceLikelihood.LIKELY,  # 'М'
        37: SequenceLikelihood.LIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        33: SequenceLikelihood.LIKELY,  # 'П'
        45: SequenceLikelihood.LIKELY,  # 'Р'
        35: SequenceLikelihood.LIKELY,  # 'С'
        43: SequenceLikelihood.LIKELY,  # 'Т'
        38: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        55: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        52: SequenceLikelihood.UNLIKELY,  # 'Ч'
        56: SequenceLikelihood.UNLIKELY,  # 'Ш'
        59: SequenceLikelihood.UNLIKELY,  # 'Щ'
        64: SequenceLikelihood.UNLIKELY,  # 'Ь'
        61: SequenceLikelihood.UNLIKELY,  # 'Ю'
        50: SequenceLikelihood.UNLIKELY,  # 'Я'
        2: SequenceLikelihood.UNLIKELY,  # 'а'
        21: SequenceLikelihood.LIKELY,  # 'б'
        7: SequenceLikelihood.LIKELY,  # 'в'
        20: SequenceLikelihood.LIKELY,  # 'г'
        13: SequenceLikelihood.LIKELY,  # 'д'
        9: SequenceLikelihood.UNLIKELY,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.LIKELY,  # 'з'
        4: SequenceLikelihood.UNLIKELY,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.LIKELY,  # 'к'
        12: SequenceLikelihood.POSITIVE,  # 'л'
        15: SequenceLikelihood.LIKELY,  # 'м'
        3: SequenceLikelihood.POSITIVE,  # 'н'
        1: SequenceLikelihood.UNLIKELY,  # 'о'
        16: SequenceLikelihood.LIKELY,  # 'п'
        8: SequenceLikelihood.LIKELY,  # 'р'
        10: SequenceLikelihood.LIKELY,  # 'с'
        6: SequenceLikelihood.UNLIKELY,  # 'т'
        14: SequenceLikelihood.UNLIKELY,  # 'у'
        32: SequenceLikelihood.LIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        25: SequenceLikelihood.UNLIKELY,  # 'ц'
        22: SequenceLikelihood.UNLIKELY,  # 'ч'
        29: SequenceLikelihood.UNLIKELY,  # 'ш'
        31: SequenceLikelihood.UNLIKELY,  # 'щ'
        19: SequenceLikelihood.NEGATIVE,  # 'ь'
        27: SequenceLikelihood.UNLIKELY,  # 'ю'
        17: SequenceLikelihood.UNLIKELY,  # 'я'
        30: SequenceLikelihood.UNLIKELY,  # 'є'
        5: SequenceLikelihood.UNLIKELY,  # 'і'
        28: SequenceLikelihood.UNLIKELY,  # 'ї'
        66: SequenceLikelihood.UNLIKELY,  # 'Ґ'
        65: SequenceLikelihood.UNLIKELY,  # 'ґ'
    },
    47: {  # 'Б'
        67: SequenceLikelihood.UNLIKELY,  # 'ʼ'
        57: SequenceLikelihood.UNLIKELY,  # 'Є'
        46: SequenceLikelihood.UNLIKELY,  # 'І'
        63: SequenceLikelihood.NEGATIVE,  # 'Ї'
        39: SequenceLikelihood.LIKELY,  # 'А'
        47: SequenceLikelihood.UNLIKELY,  # 'Б'
        34: SequenceLikelihood.UNLIKELY,  # 'В'
        48: SequenceLikelihood.UNLIKELY,  # 'Г'
        40: SequenceLikelihood.UNLIKELY,  # 'Д'
        54: SequenceLikelihood.UNLIKELY,  # 'Е'
        60: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        58: SequenceLikelihood.UNLIKELY,  # 'И'
        62: SequenceLikelihood.NEGATIVE,  # 'Й'
        36: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        42: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.LIKELY,  # 'О'
        33: SequenceLikelihood.UNLIKELY,  # 'П'
        45: SequenceLikelihood.UNLIKELY,  # 'Р'
        35: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        38: SequenceLikelihood.LIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        55: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        52: SequenceLikelihood.UNLIKELY,  # 'Ч'
        56: SequenceLikelihood.UNLIKELY,  # 'Ш'
        59: SequenceLikelihood.UNLIKELY,  # 'Щ'
        64: SequenceLikelihood.UNLIKELY,  # 'Ь'
        61: SequenceLikelihood.UNLIKELY,  # 'Ю'
        50: SequenceLikelihood.UNLIKELY,  # 'Я'
        2: SequenceLikelihood.POSITIVE,  # 'а'
        21: SequenceLikelihood.UNLIKELY,  # 'б'
        7: SequenceLikelihood.NEGATIVE,  # 'в'
        20: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        9: SequenceLikelihood.LIKELY,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.UNLIKELY,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        12: SequenceLikelihood.LIKELY,  # 'л'
        15: SequenceLikelihood.UNLIKELY,  # 'м'
        3: SequenceLikelihood.UNLIKELY,  # 'н'
        1: SequenceLikelihood.POSITIVE,  # 'о'
        16: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.LIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        6: SequenceLikelihood.UNLIKELY,  # 'т'
        14: SequenceLikelihood.LIKELY,  # 'у'
        32: SequenceLikelihood.NEGATIVE,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        25: SequenceLikelihood.NEGATIVE,  # 'ц'
        22: SequenceLikelihood.UNLIKELY,  # 'ч'
        29: SequenceLikelihood.UNLIKELY,  # 'ш'
        31: SequenceLikelihood.NEGATIVE,  # 'щ'
        19: SequenceLikelihood.UNLIKELY,  # 'ь'
        27: SequenceLikelihood.UNLIKELY,  # 'ю'
        17: SequenceLikelihood.UNLIKELY,  # 'я'
        30: SequenceLikelihood.UNLIKELY,  # 'є'
        5: SequenceLikelihood.LIKELY,  # 'і'
        28: SequenceLikelihood.NEGATIVE,  # 'ї'
        66: SequenceLikelihood.UNLIKELY,  # 'Ґ'
        65: SequenceLikelihood.NEGATIVE,  # 'ґ'
    },
    34: {  # 'В'
        67: SequenceLikelihood.UNLIKELY,  # 'ʼ'
        57: SequenceLikelihood.UNLIKELY,  # 'Є'
        46: SequenceLikelihood.LIKELY,  # 'І'
        63: SequenceLikelihood.UNLIKELY,  # 'Ї'
        39: SequenceLikelihood.LIKELY,  # 'А'
        47: SequenceLikelihood.UNLIKELY,  # 'Б'
        34: SequenceLikelihood.UNLIKELY,  # 'В'
        48: SequenceLikelihood.UNLIKELY,  # 'Г'
        40: SequenceLikelihood.UNLIKELY,  # 'Д'
        54: SequenceLikelihood.UNLIKELY,  # 'Е'
        60: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        58: SequenceLikelihood.LIKELY,  # 'И'
        62: SequenceLikelihood.UNLIKELY,  # 'Й'
        36: SequenceLikelihood.LIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        42: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.LIKELY,  # 'Н'
        41: SequenceLikelihood.LIKELY,  # 'О'
        33: SequenceLikelihood.LIKELY,  # 'П'
        45: SequenceLikelihood.UNLIKELY,  # 'Р'
        35: SequenceLikelihood.LIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        38: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        55: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        52: SequenceLikelihood.UNLIKELY,  # 'Ч'
        56: SequenceLikelihood.UNLIKELY,  # 'Ш'
        59: SequenceLikelihood.UNLIKELY,  # 'Щ'
        64: SequenceLikelihood.UNLIKELY,  # 'Ь'
        61: SequenceLikelihood.UNLIKELY,  # 'Ю'
        50: SequenceLikelihood.UNLIKELY,  # 'Я'
        2: SequenceLikelihood.POSITIVE,  # 'а'
        21: SequenceLikelihood.UNLIKELY,  # 'б'
        7: SequenceLikelihood.UNLIKELY,  # 'в'
        20: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        9: SequenceLikelihood.POSITIVE,  # 'е'
        26: SequenceLikelihood.LIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.POSITIVE,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        12: SequenceLikelihood.LIKELY,  # 'л'
        15: SequenceLikelihood.UNLIKELY,  # 'м'
        3: SequenceLikelihood.LIKELY,  # 'н'
        1: SequenceLikelihood.POSITIVE,  # 'о'
        16: SequenceLikelihood.LIKELY,  # 'п'
        8: SequenceLikelihood.LIKELY,  # 'р'
        10: SequenceLikelihood.POSITIVE,  # 'с'
        6: SequenceLikelihood.LIKELY,  # 'т'
        14: SequenceLikelihood.UNLIKELY,  # 'у'
        32: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        25: SequenceLikelihood.UNLIKELY,  # 'ц'
        22: SequenceLikelihood.LIKELY,  # 'ч'
        29: SequenceLikelihood.UNLIKELY,  # 'ш'
        31: SequenceLikelihood.UNLIKELY,  # 'щ'
        19: SequenceLikelihood.UNLIKELY,  # 'ь'
        27: SequenceLikelihood.UNLIKELY,  # 'ю'
        17: SequenceLikelihood.UNLIKELY,  # 'я'
        30: SequenceLikelihood.UNLIKELY,  # 'є'
        5: SequenceLikelihood.POSITIVE,  # 'і'
        28: SequenceLikelihood.UNLIKELY,  # 'ї'
        66: SequenceLikelihood.NEGATIVE,  # 'Ґ'
        65: SequenceLikelihood.NEGATIVE,  # 'ґ'
    },
    48: {  # 'Г'
        67: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        57: SequenceLikelihood.UNLIKELY,  # 'Є'
        46: SequenceLikelihood.UNLIKELY,  # 'І'
        63: SequenceLikelihood.UNLIKELY,  # 'Ї'
        39: SequenceLikelihood.LIKELY,  # 'А'
        47: SequenceLikelihood.UNLIKELY,  # 'Б'
        34: SequenceLikelihood.UNLIKELY,  # 'В'
        48: SequenceLikelihood.UNLIKELY,  # 'Г'
        40: SequenceLikelihood.UNLIKELY,  # 'Д'
        54: SequenceLikelihood.UNLIKELY,  # 'Е'
        60: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        58: SequenceLikelihood.UNLIKELY,  # 'И'
        62: SequenceLikelihood.NEGATIVE,  # 'Й'
        36: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        42: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.LIKELY,  # 'О'
        33: SequenceLikelihood.UNLIKELY,  # 'П'
        45: SequenceLikelihood.LIKELY,  # 'Р'
        35: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        38: SequenceLikelihood.LIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        55: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        52: SequenceLikelihood.UNLIKELY,  # 'Ч'
        56: SequenceLikelihood.UNLIKELY,  # 'Ш'
        59: SequenceLikelihood.NEGATIVE,  # 'Щ'
        64: SequenceLikelihood.UNLIKELY,  # 'Ь'
        61: SequenceLikelihood.UNLIKELY,  # 'Ю'
        50: SequenceLikelihood.NEGATIVE,  # 'Я'
        2: SequenceLikelihood.LIKELY,  # 'а'
        21: SequenceLikelihood.UNLIKELY,  # 'б'
        7: SequenceLikelihood.UNLIKELY,  # 'в'
        20: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        9: SequenceLikelihood.LIKELY,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.UNLIKELY,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        12: SequenceLikelihood.LIKELY,  # 'л'
        15: SequenceLikelihood.UNLIKELY,  # 'м'
        3: SequenceLikelihood.UNLIKELY,  # 'н'
        1: SequenceLikelihood.POSITIVE,  # 'о'
        16: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.POSITIVE,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        6: SequenceLikelihood.UNLIKELY,  # 'т'
        14: SequenceLikelihood.LIKELY,  # 'у'
        32: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        25: SequenceLikelihood.UNLIKELY,  # 'ц'
        22: SequenceLikelihood.UNLIKELY,  # 'ч'
        29: SequenceLikelihood.UNLIKELY,  # 'ш'
        31: SequenceLikelihood.NEGATIVE,  # 'щ'
        19: SequenceLikelihood.UNLIKELY,  # 'ь'
        27: SequenceLikelihood.UNLIKELY,  # 'ю'
        17: SequenceLikelihood.UNLIKELY,  # 'я'
        30: SequenceLikelihood.UNLIKELY,  # 'є'
        5: SequenceLikelihood.LIKELY,  # 'і'
        28: SequenceLikelihood.UNLIKELY,  # 'ї'
        66: SequenceLikelihood.NEGATIVE,  # 'Ґ'
        65: SequenceLikelihood.NEGATIVE,  # 'ґ'
    },
    40: {  # 'Д'
        67: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        57: SequenceLikelihood.UNLIKELY,  # 'Є'
        46: SequenceLikelihood.LIKELY,  # 'І'
        63: SequenceLikelihood.NEGATIVE,  # 'Ї'
        39: SequenceLikelihood.LIKELY,  # 'А'
        47: SequenceLikelihood.UNLIKELY,  # 'Б'
        34: SequenceLikelihood.LIKELY,  # 'В'
        48: SequenceLikelihood.UNLIKELY,  # 'Г'
        40: SequenceLikelihood.UNLIKELY,  # 'Д'
        54: SequenceLikelihood.LIKELY,  # 'Е'
        60: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        58: SequenceLikelihood.LIKELY,  # 'И'
        62: SequenceLikelihood.UNLIKELY,  # 'Й'
        36: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        42: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.LIKELY,  # 'Н'
        41: SequenceLikelihood.LIKELY,  # 'О'
        33: SequenceLikelihood.LIKELY,  # 'П'
        45: SequenceLikelihood.UNLIKELY,  # 'Р'
        35: SequenceLikelihood.LIKELY,  # 'С'
        43: SequenceLikelihood.LIKELY,  # 'Т'
        38: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        55: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        52: SequenceLikelihood.UNLIKELY,  # 'Ч'
        56: SequenceLikelihood.UNLIKELY,  # 'Ш'
        59: SequenceLikelihood.UNLIKELY,  # 'Щ'
        64: SequenceLikelihood.UNLIKELY,  # 'Ь'
        61: SequenceLikelihood.UNLIKELY,  # 'Ю'
        50: SequenceLikelihood.UNLIKELY,  # 'Я'
        2: SequenceLikelihood.LIKELY,  # 'а'
        21: SequenceLikelihood.UNLIKELY,  # 'б'
        7: SequenceLikelihood.LIKELY,  # 'в'
        20: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        9: SequenceLikelihood.POSITIVE,  # 'е'
        26: SequenceLikelihood.LIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.LIKELY,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        12: SequenceLikelihood.POSITIVE,  # 'л'
        15: SequenceLikelihood.LIKELY,  # 'м'
        3: SequenceLikelihood.LIKELY,  # 'н'
        1: SequenceLikelihood.POSITIVE,  # 'о'
        16: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.LIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        6: SequenceLikelihood.UNLIKELY,  # 'т'
        14: SequenceLikelihood.LIKELY,  # 'у'
        32: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        25: SequenceLikelihood.UNLIKELY,  # 'ц'
        22: SequenceLikelihood.UNLIKELY,  # 'ч'
        29: SequenceLikelihood.UNLIKELY,  # 'ш'
        31: SequenceLikelihood.UNLIKELY,  # 'щ'
        19: SequenceLikelihood.UNLIKELY,  # 'ь'
        27: SequenceLikelihood.UNLIKELY,  # 'ю'
        17: SequenceLikelihood.LIKELY,  # 'я'
        30: SequenceLikelihood.UNLIKELY,  # 'є'
        5: SequenceLikelihood.LIKELY,  # 'і'
        28: SequenceLikelihood.UNLIKELY,  # 'ї'
        66: SequenceLikelihood.UNLIKELY,  # 'Ґ'
        65: SequenceLikelihood.NEGATIVE,  # 'ґ'
    },
    54: {  # 'Е'
        67: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        57: SequenceLikelihood.UNLIKELY,  # 'Є'
        46: SequenceLikelihood.UNLIKELY,  # 'І'
        63: SequenceLikelihood.UNLIKELY,  # 'Ї'
        39: SequenceLikelihood.UNLIKELY,  # 'А'
        47: SequenceLikelihood.UNLIKELY,  # 'Б'
        34: SequenceLikelihood.UNLIKELY,  # 'В'
        48: SequenceLikelihood.UNLIKELY,  # 'Г'
        40: SequenceLikelihood.UNLIKELY,  # 'Д'
        54: SequenceLikelihood.UNLIKELY,  # 'Е'
        60: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        58: SequenceLikelihood.UNLIKELY,  # 'И'
        62: SequenceLikelihood.UNLIKELY,  # 'Й'
        36: SequenceLikelihood.LIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        42: SequenceLikelihood.LIKELY,  # 'М'
        37: SequenceLikelihood.LIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        33: SequenceLikelihood.UNLIKELY,  # 'П'
        45: SequenceLikelihood.LIKELY,  # 'Р'
        35: SequenceLikelihood.LIKELY,  # 'С'
        43: SequenceLikelihood.LIKELY,  # 'Т'
        38: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        55: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        52: SequenceLikelihood.UNLIKELY,  # 'Ч'
        56: SequenceLikelihood.UNLIKELY,  # 'Ш'
        59: SequenceLikelihood.UNLIKELY,  # 'Щ'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        61: SequenceLikelihood.UNLIKELY,  # 'Ю'
        50: SequenceLikelihood.UNLIKELY,  # 'Я'
        2: SequenceLikelihood.UNLIKELY,  # 'а'
        21: SequenceLikelihood.UNLIKELY,  # 'б'
        7: SequenceLikelihood.UNLIKELY,  # 'в'
        20: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        9: SequenceLikelihood.UNLIKELY,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.UNLIKELY,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.LIKELY,  # 'к'
        12: SequenceLikelihood.LIKELY,  # 'л'
        15: SequenceLikelihood.UNLIKELY,  # 'м'
        3: SequenceLikelihood.LIKELY,  # 'н'
        1: SequenceLikelihood.UNLIKELY,  # 'о'
        16: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        6: SequenceLikelihood.UNLIKELY,  # 'т'
        14: SequenceLikelihood.UNLIKELY,  # 'у'
        32: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        25: SequenceLikelihood.UNLIKELY,  # 'ц'
        22: SequenceLikelihood.UNLIKELY,  # 'ч'
        29: SequenceLikelihood.UNLIKELY,  # 'ш'
        31: SequenceLikelihood.UNLIKELY,  # 'щ'
        19: SequenceLikelihood.NEGATIVE,  # 'ь'
        27: SequenceLikelihood.UNLIKELY,  # 'ю'
        17: SequenceLikelihood.UNLIKELY,  # 'я'
        30: SequenceLikelihood.UNLIKELY,  # 'є'
        5: SequenceLikelihood.UNLIKELY,  # 'і'
        28: SequenceLikelihood.NEGATIVE,  # 'ї'
        66: SequenceLikelihood.UNLIKELY,  # 'Ґ'
        65: SequenceLikelihood.UNLIKELY,  # 'ґ'
    },
    60: {  # 'Ж'
        67: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        57: SequenceLikelihood.UNLIKELY,  # 'Є'
        46: SequenceLikelihood.UNLIKELY,  # 'І'
        63: SequenceLikelihood.NEGATIVE,  # 'Ї'
        39: SequenceLikelihood.UNLIKELY,  # 'А'
        47: SequenceLikelihood.UNLIKELY,  # 'Б'
        34: SequenceLikelihood.UNLIKELY,  # 'В'
        48: SequenceLikelihood.UNLIKELY,  # 'Г'
        40: SequenceLikelihood.UNLIKELY,  # 'Д'
        54: SequenceLikelihood.UNLIKELY,  # 'Е'
        60: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        58: SequenceLikelihood.UNLIKELY,  # 'И'
        62: SequenceLikelihood.NEGATIVE,  # 'Й'
        36: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        42: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        33: SequenceLikelihood.UNLIKELY,  # 'П'
        45: SequenceLikelihood.UNLIKELY,  # 'Р'
        35: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        38: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        55: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        52: SequenceLikelihood.UNLIKELY,  # 'Ч'
        56: SequenceLikelihood.UNLIKELY,  # 'Ш'
        59: SequenceLikelihood.NEGATIVE,  # 'Щ'
        64: SequenceLikelihood.UNLIKELY,  # 'Ь'
        61: SequenceLikelihood.NEGATIVE,  # 'Ю'
        50: SequenceLikelihood.UNLIKELY,  # 'Я'
        2: SequenceLikelihood.LIKELY,  # 'а'
        21: SequenceLikelihood.UNLIKELY,  # 'б'
        7: SequenceLikelihood.UNLIKELY,  # 'в'
        20: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        9: SequenceLikelihood.UNLIKELY,  # 'е'
        26: SequenceLikelihood.NEGATIVE,  # 'ж'
        18: SequenceLikelihood.NEGATIVE,  # 'з'
        4: SequenceLikelihood.LIKELY,  # 'и'
        23: SequenceLikelihood.NEGATIVE,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        12: SequenceLikelihood.UNLIKELY,  # 'л'
        15: SequenceLikelihood.UNLIKELY,  # 'м'
        3: SequenceLikelihood.UNLIKELY,  # 'н'
        1: SequenceLikelihood.LIKELY,  # 'о'
        16: SequenceLikelihood.NEGATIVE,  # 'п'
        8: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.NEGATIVE,  # 'с'
        6: SequenceLikelihood.UNLIKELY,  # 'т'
        14: SequenceLikelihood.LIKELY,  # 'у'
        32: SequenceLikelihood.NEGATIVE,  # 'ф'
        24: SequenceLikelihood.NEGATIVE,  # 'х'
        25: SequenceLikelihood.NEGATIVE,  # 'ц'
        22: SequenceLikelihood.NEGATIVE,  # 'ч'
        29: SequenceLikelihood.UNLIKELY,  # 'ш'
        31: SequenceLikelihood.NEGATIVE,  # 'щ'
        19: SequenceLikelihood.NEGATIVE,  # 'ь'
        27: SequenceLikelihood.UNLIKELY,  # 'ю'
        17: SequenceLikelihood.UNLIKELY,  # 'я'
        30: SequenceLikelihood.NEGATIVE,  # 'є'
        5: SequenceLikelihood.LIKELY,  # 'і'
        28: SequenceLikelihood.NEGATIVE,  # 'ї'
        66: SequenceLikelihood.NEGATIVE,  # 'Ґ'
        65: SequenceLikelihood.NEGATIVE,  # 'ґ'
    },
    44: {  # 'З'
        67: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        57: SequenceLikelihood.UNLIKELY,  # 'Є'
        46: SequenceLikelihood.UNLIKELY,  # 'І'
        63: SequenceLikelihood.UNLIKELY,  # 'Ї'
        39: SequenceLikelihood.LIKELY,  # 'А'
        47: SequenceLikelihood.UNLIKELY,  # 'Б'
        34: SequenceLikelihood.UNLIKELY,  # 'В'
        48: SequenceLikelihood.UNLIKELY,  # 'Г'
        40: SequenceLikelihood.UNLIKELY,  # 'Д'
        54: SequenceLikelihood.UNLIKELY,  # 'Е'
        60: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        58: SequenceLikelihood.UNLIKELY,  # 'И'
        62: SequenceLikelihood.UNLIKELY,  # 'Й'
        36: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        42: SequenceLikelihood.LIKELY,  # 'М'
        37: SequenceLikelihood.LIKELY,  # 'Н'
        41: SequenceLikelihood.LIKELY,  # 'О'
        33: SequenceLikelihood.UNLIKELY,  # 'П'
        45: SequenceLikelihood.UNLIKELY,  # 'Р'
        35: SequenceLikelihood.LIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        38: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        55: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        52: SequenceLikelihood.UNLIKELY,  # 'Ч'
        56: SequenceLikelihood.UNLIKELY,  # 'Ш'
        59: SequenceLikelihood.UNLIKELY,  # 'Щ'
        64: SequenceLikelihood.UNLIKELY,  # 'Ь'
        61: SequenceLikelihood.UNLIKELY,  # 'Ю'
        50: SequenceLikelihood.UNLIKELY,  # 'Я'
        2: SequenceLikelihood.POSITIVE,  # 'а'
        21: SequenceLikelihood.LIKELY,  # 'б'
        7: SequenceLikelihood.LIKELY,  # 'в'
        20: SequenceLikelihood.LIKELY,  # 'г'
        13: SequenceLikelihood.LIKELY,  # 'д'
        9: SequenceLikelihood.LIKELY,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.UNLIKELY,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        12: SequenceLikelihood.UNLIKELY,  # 'л'
        15: SequenceLikelihood.LIKELY,  # 'м'
        3: SequenceLikelihood.LIKELY,  # 'н'
        1: SequenceLikelihood.LIKELY,  # 'о'
        16: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.LIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        6: SequenceLikelihood.UNLIKELY,  # 'т'
        14: SequenceLikelihood.LIKELY,  # 'у'
        32: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        25: SequenceLikelihood.UNLIKELY,  # 'ц'
        22: SequenceLikelihood.UNLIKELY,  # 'ч'
        29: SequenceLikelihood.UNLIKELY,  # 'ш'
        31: SequenceLikelihood.NEGATIVE,  # 'щ'
        19: SequenceLikelihood.UNLIKELY,  # 'ь'
        27: SequenceLikelihood.UNLIKELY,  # 'ю'
        17: SequenceLikelihood.UNLIKELY,  # 'я'
        30: SequenceLikelihood.UNLIKELY,  # 'є'
        5: SequenceLikelihood.LIKELY,  # 'і'
        28: SequenceLikelihood.UNLIKELY,  # 'ї'
        66: SequenceLikelihood.UNLIKELY,  # 'Ґ'
        65: SequenceLikelihood.UNLIKELY,  # 'ґ'
    },
    58: {  # 'И'
        67: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        57: SequenceLikelihood.UNLIKELY,  # 'Є'
        46: SequenceLikelihood.UNLIKELY,  # 'І'
        63: SequenceLikelihood.UNLIKELY,  # 'Ї'
        39: SequenceLikelihood.UNLIKELY,  # 'А'
        47: SequenceLikelihood.UNLIKELY,  # 'Б'
        34: SequenceLikelihood.UNLIKELY,  # 'В'
        48: SequenceLikelihood.UNLIKELY,  # 'Г'
        40: SequenceLikelihood.UNLIKELY,  # 'Д'
        54: SequenceLikelihood.UNLIKELY,  # 'Е'
        60: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        58: SequenceLikelihood.UNLIKELY,  # 'И'
        62: SequenceLikelihood.LIKELY,  # 'Й'
        36: SequenceLikelihood.LIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        42: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.LIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        33: SequenceLikelihood.UNLIKELY,  # 'П'
        45: SequenceLikelihood.UNLIKELY,  # 'Р'
        35: SequenceLikelihood.LIKELY,  # 'С'
        43: SequenceLikelihood.LIKELY,  # 'Т'
        38: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        55: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        52: SequenceLikelihood.UNLIKELY,  # 'Ч'
        56: SequenceLikelihood.UNLIKELY,  # 'Ш'
        59: SequenceLikelihood.UNLIKELY,  # 'Щ'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        61: SequenceLikelihood.UNLIKELY,  # 'Ю'
        50: SequenceLikelihood.UNLIKELY,  # 'Я'
        2: SequenceLikelihood.UNLIKELY,  # 'а'
        21: SequenceLikelihood.UNLIKELY,  # 'б'
        7: SequenceLikelihood.UNLIKELY,  # 'в'
        20: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        9: SequenceLikelihood.UNLIKELY,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.UNLIKELY,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        12: SequenceLikelihood.UNLIKELY,  # 'л'
        15: SequenceLikelihood.UNLIKELY,  # 'м'
        3: SequenceLikelihood.UNLIKELY,  # 'н'
        1: SequenceLikelihood.UNLIKELY,  # 'о'
        16: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        6: SequenceLikelihood.UNLIKELY,  # 'т'
        14: SequenceLikelihood.UNLIKELY,  # 'у'
        32: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        25: SequenceLikelihood.UNLIKELY,  # 'ц'
        22: SequenceLikelihood.UNLIKELY,  # 'ч'
        29: SequenceLikelihood.UNLIKELY,  # 'ш'
        31: SequenceLikelihood.UNLIKELY,  # 'щ'
        19: SequenceLikelihood.NEGATIVE,  # 'ь'
        27: SequenceLikelihood.UNLIKELY,  # 'ю'
        17: SequenceLikelihood.UNLIKELY,  # 'я'
        30: SequenceLikelihood.UNLIKELY,  # 'є'
        5: SequenceLikelihood.NEGATIVE,  # 'і'
        28: SequenceLikelihood.NEGATIVE,  # 'ї'
        66: SequenceLikelihood.UNLIKELY,  # 'Ґ'
        65: SequenceLikelihood.NEGATIVE,  # 'ґ'
    },
    62: {  # 'Й'
        67: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        57: SequenceLikelihood.UNLIKELY,  # 'Є'
        46: SequenceLikelihood.UNLIKELY,  # 'І'
        63: SequenceLikelihood.UNLIKELY,  # 'Ї'
        39: SequenceLikelihood.UNLIKELY,  # 'А'
        47: SequenceLikelihood.UNLIKELY,  # 'Б'
        34: SequenceLikelihood.UNLIKELY,  # 'В'
        48: SequenceLikelihood.UNLIKELY,  # 'Г'
        40: SequenceLikelihood.UNLIKELY,  # 'Д'
        54: SequenceLikelihood.UNLIKELY,  # 'Е'
        60: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        58: SequenceLikelihood.NEGATIVE,  # 'И'
        62: SequenceLikelihood.UNLIKELY,  # 'Й'
        36: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        42: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        33: SequenceLikelihood.UNLIKELY,  # 'П'
        45: SequenceLikelihood.UNLIKELY,  # 'Р'
        35: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        38: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        55: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        52: SequenceLikelihood.UNLIKELY,  # 'Ч'
        56: SequenceLikelihood.UNLIKELY,  # 'Ш'
        59: SequenceLikelihood.NEGATIVE,  # 'Щ'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        61: SequenceLikelihood.UNLIKELY,  # 'Ю'
        50: SequenceLikelihood.UNLIKELY,  # 'Я'
        2: SequenceLikelihood.UNLIKELY,  # 'а'
        21: SequenceLikelihood.NEGATIVE,  # 'б'
        7: SequenceLikelihood.UNLIKELY,  # 'в'
        20: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        9: SequenceLikelihood.UNLIKELY,  # 'е'
        26: SequenceLikelihood.NEGATIVE,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.UNLIKELY,  # 'и'
        23: SequenceLikelihood.NEGATIVE,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        12: SequenceLikelihood.NEGATIVE,  # 'л'
        15: SequenceLikelihood.UNLIKELY,  # 'м'
        3: SequenceLikelihood.UNLIKELY,  # 'н'
        1: SequenceLikelihood.LIKELY,  # 'о'
        16: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.NEGATIVE,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        6: SequenceLikelihood.UNLIKELY,  # 'т'
        14: SequenceLikelihood.UNLIKELY,  # 'у'
        32: SequenceLikelihood.NEGATIVE,  # 'ф'
        24: SequenceLikelihood.NEGATIVE,  # 'х'
        25: SequenceLikelihood.UNLIKELY,  # 'ц'
        22: SequenceLikelihood.NEGATIVE,  # 'ч'
        29: SequenceLikelihood.UNLIKELY,  # 'ш'
        31: SequenceLikelihood.NEGATIVE,  # 'щ'
        19: SequenceLikelihood.UNLIKELY,  # 'ь'
        27: SequenceLikelihood.UNLIKELY,  # 'ю'
        17: SequenceLikelihood.NEGATIVE,  # 'я'
        30: SequenceLikelihood.UNLIKELY,  # 'є'
        5: SequenceLikelihood.UNLIKELY,  # 'і'
        28: SequenceLikelihood.UNLIKELY,  # 'ї'
        66: SequenceLikelihood.NEGATIVE,  # 'Ґ'
        65: SequenceLikelihood.NEGATIVE,  # 'ґ'
    },
    36: {  # 'К'
        67: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        57: SequenceLikelihood.UNLIKELY,  # 'Є'
        46: SequenceLikelihood.UNLIKELY,  # 'І'
        63: SequenceLikelihood.NEGATIVE,  # 'Ї'
        39: SequenceLikelihood.LIKELY,  # 'А'
        47: SequenceLikelihood.UNLIKELY,  # 'Б'
        34: SequenceLikelihood.UNLIKELY,  # 'В'
        48: SequenceLikelihood.UNLIKELY,  # 'Г'
        40: SequenceLikelihood.UNLIKELY,  # 'Д'
        54: SequenceLikelihood.UNLIKELY,  # 'Е'
        60: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        58: SequenceLikelihood.LIKELY,  # 'И'
        62: SequenceLikelihood.NEGATIVE,  # 'Й'
        36: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        42: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.LIKELY,  # 'О'
        33: SequenceLikelihood.LIKELY,  # 'П'
        45: SequenceLikelihood.LIKELY,  # 'Р'
        35: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.LIKELY,  # 'Т'
        38: SequenceLikelihood.LIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        55: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        52: SequenceLikelihood.UNLIKELY,  # 'Ч'
        56: SequenceLikelihood.UNLIKELY,  # 'Ш'
        59: SequenceLikelihood.UNLIKELY,  # 'Щ'
        64: SequenceLikelihood.UNLIKELY,  # 'Ь'
        61: SequenceLikelihood.UNLIKELY,  # 'Ю'
        50: SequenceLikelihood.UNLIKELY,  # 'Я'
        2: SequenceLikelihood.POSITIVE,  # 'а'
        21: SequenceLikelihood.UNLIKELY,  # 'б'
        7: SequenceLikelihood.LIKELY,  # 'в'
        20: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        9: SequenceLikelihood.LIKELY,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.POSITIVE,  # 'и'
        23: SequenceLikelihood.NEGATIVE,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        12: SequenceLikelihood.LIKELY,  # 'л'
        15: SequenceLikelihood.UNLIKELY,  # 'м'
        3: SequenceLikelihood.LIKELY,  # 'н'
        1: SequenceLikelihood.POSITIVE,  # 'о'
        16: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.POSITIVE,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        6: SequenceLikelihood.UNLIKELY,  # 'т'
        14: SequenceLikelihood.LIKELY,  # 'у'
        32: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        25: SequenceLikelihood.UNLIKELY,  # 'ц'
        22: SequenceLikelihood.UNLIKELY,  # 'ч'
        29: SequenceLikelihood.UNLIKELY,  # 'ш'
        31: SequenceLikelihood.UNLIKELY,  # 'щ'
        19: SequenceLikelihood.UNLIKELY,  # 'ь'
        27: SequenceLikelihood.UNLIKELY,  # 'ю'
        17: SequenceLikelihood.UNLIKELY,  # 'я'
        30: SequenceLikelihood.UNLIKELY,  # 'є'
        5: SequenceLikelihood.LIKELY,  # 'і'
        28: SequenceLikelihood.NEGATIVE,  # 'ї'
        66: SequenceLikelihood.UNLIKELY,  # 'Ґ'
        65: SequenceLikelihood.UNLIKELY,  # 'ґ'
    },
    49: {  # 'Л'
        67: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        57: SequenceLikelihood.UNLIKELY,  # 'Є'
        46: SequenceLikelihood.LIKELY,  # 'І'
        63: SequenceLikelihood.NEGATIVE,  # 'Ї'
        39: SequenceLikelihood.LIKELY,  # 'А'
        47: SequenceLikelihood.UNLIKELY,  # 'Б'
        34: SequenceLikelihood.UNLIKELY,  # 'В'
        48: SequenceLikelihood.UNLIKELY,  # 'Г'
        40: SequenceLikelihood.UNLIKELY,  # 'Д'
        54: SequenceLikelihood.LIKELY,  # 'Е'
        60: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        58: SequenceLikelihood.LIKELY,  # 'И'
        62: SequenceLikelihood.NEGATIVE,  # 'Й'
        36: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        42: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.LIKELY,  # 'О'
        33: SequenceLikelihood.UNLIKELY,  # 'П'
        45: SequenceLikelihood.UNLIKELY,  # 'Р'
        35: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        38: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        55: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        52: SequenceLikelihood.UNLIKELY,  # 'Ч'
        56: SequenceLikelihood.UNLIKELY,  # 'Ш'
        59: SequenceLikelihood.UNLIKELY,  # 'Щ'
        64: SequenceLikelihood.LIKELY,  # 'Ь'
        61: SequenceLikelihood.UNLIKELY,  # 'Ю'
        50: SequenceLikelihood.UNLIKELY,  # 'Я'
        2: SequenceLikelihood.LIKELY,  # 'а'
        21: SequenceLikelihood.UNLIKELY,  # 'б'
        7: SequenceLikelihood.UNLIKELY,  # 'в'
        20: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        9: SequenceLikelihood.LIKELY,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.LIKELY,  # 'и'
        23: SequenceLikelihood.NEGATIVE,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        12: SequenceLikelihood.UNLIKELY,  # 'л'
        15: SequenceLikelihood.UNLIKELY,  # 'м'
        3: SequenceLikelihood.UNLIKELY,  # 'н'
        1: SequenceLikelihood.LIKELY,  # 'о'
        16: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        6: SequenceLikelihood.UNLIKELY,  # 'т'
        14: SequenceLikelihood.LIKELY,  # 'у'
        32: SequenceLikelihood.NEGATIVE,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        25: SequenceLikelihood.UNLIKELY,  # 'ц'
        22: SequenceLikelihood.NEGATIVE,  # 'ч'
        29: SequenceLikelihood.UNLIKELY,  # 'ш'
        31: SequenceLikelihood.NEGATIVE,  # 'щ'
        19: SequenceLikelihood.LIKELY,  # 'ь'
        27: SequenceLikelihood.LIKELY,  # 'ю'
        17: SequenceLikelihood.UNLIKELY,  # 'я'
        30: SequenceLikelihood.UNLIKELY,  # 'є'
        5: SequenceLikelihood.LIKELY,  # 'і'
        28: SequenceLikelihood.UNLIKELY,  # 'ї'
        66: SequenceLikelihood.UNLIKELY,  # 'Ґ'
        65: SequenceLikelihood.NEGATIVE,  # 'ґ'
    },
    42: {  # 'М'
        67: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        57: SequenceLikelihood.UNLIKELY,  # 'Є'
        46: SequenceLikelihood.LIKELY,  # 'І'
        63: SequenceLikelihood.UNLIKELY,  # 'Ї'
        39: SequenceLikelihood.LIKELY,  # 'А'
        47: SequenceLikelihood.UNLIKELY,  # 'Б'
        34: SequenceLikelihood.LIKELY,  # 'В'
        48: SequenceLikelihood.UNLIKELY,  # 'Г'
        40: SequenceLikelihood.UNLIKELY,  # 'Д'
        54: SequenceLikelihood.LIKELY,  # 'Е'
        60: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        58: SequenceLikelihood.UNLIKELY,  # 'И'
        62: SequenceLikelihood.NEGATIVE,  # 'Й'
        36: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        42: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.LIKELY,  # 'О'
        33: SequenceLikelihood.UNLIKELY,  # 'П'
        45: SequenceLikelihood.UNLIKELY,  # 'Р'
        35: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        38: SequenceLikelihood.LIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        55: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        52: SequenceLikelihood.UNLIKELY,  # 'Ч'
        56: SequenceLikelihood.UNLIKELY,  # 'Ш'
        59: SequenceLikelihood.UNLIKELY,  # 'Щ'
        64: SequenceLikelihood.UNLIKELY,  # 'Ь'
        61: SequenceLikelihood.UNLIKELY,  # 'Ю'
        50: SequenceLikelihood.UNLIKELY,  # 'Я'
        2: SequenceLikelihood.POSITIVE,  # 'а'
        21: SequenceLikelihood.UNLIKELY,  # 'б'
        7: SequenceLikelihood.UNLIKELY,  # 'в'
        20: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        9: SequenceLikelihood.POSITIVE,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.POSITIVE,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        12: SequenceLikelihood.UNLIKELY,  # 'л'
        15: SequenceLikelihood.UNLIKELY,  # 'м'
        3: SequenceLikelihood.UNLIKELY,  # 'н'
        1: SequenceLikelihood.POSITIVE,  # 'о'
        16: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        6: SequenceLikelihood.UNLIKELY,  # 'т'
        14: SequenceLikelihood.LIKELY,  # 'у'
        32: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        25: SequenceLikelihood.UNLIKELY,  # 'ц'
        22: SequenceLikelihood.UNLIKELY,  # 'ч'
        29: SequenceLikelihood.UNLIKELY,  # 'ш'
        31: SequenceLikelihood.NEGATIVE,  # 'щ'
        19: SequenceLikelihood.UNLIKELY,  # 'ь'
        27: SequenceLikelihood.UNLIKELY,  # 'ю'
        17: SequenceLikelihood.UNLIKELY,  # 'я'
        30: SequenceLikelihood.UNLIKELY,  # 'є'
        5: SequenceLikelihood.POSITIVE,  # 'і'
        28: SequenceLikelihood.UNLIKELY,  # 'ї'
        66: SequenceLikelihood.UNLIKELY,  # 'Ґ'
        65: SequenceLikelihood.UNLIKELY,  # 'ґ'
    },
    37: {  # 'Н'
        67: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        57: SequenceLikelihood.UNLIKELY,  # 'Є'
        46: SequenceLikelihood.LIKELY,  # 'І'
        63: SequenceLikelihood.NEGATIVE,  # 'Ї'
        39: SequenceLikelihood.LIKELY,  # 'А'
        47: SequenceLikelihood.LIKELY,  # 'Б'
        34: SequenceLikelihood.UNLIKELY,  # 'В'
        48: SequenceLikelihood.UNLIKELY,  # 'Г'
        40: SequenceLikelihood.LIKELY,  # 'Д'
        54: SequenceLikelihood.LIKELY,  # 'Е'
        60: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        58: SequenceLikelihood.LIKELY,  # 'И'
        62: SequenceLikelihood.UNLIKELY,  # 'Й'
        36: SequenceLikelihood.LIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        42: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.LIKELY,  # 'Н'
        41: SequenceLikelihood.LIKELY,  # 'О'
        33: SequenceLikelihood.UNLIKELY,  # 'П'
        45: SequenceLikelihood.LIKELY,  # 'Р'
        35: SequenceLikelihood.LIKELY,  # 'С'
        43: SequenceLikelihood.LIKELY,  # 'Т'
        38: SequenceLikelihood.LIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        55: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        52: SequenceLikelihood.UNLIKELY,  # 'Ч'
        56: SequenceLikelihood.UNLIKELY,  # 'Ш'
        59: SequenceLikelihood.UNLIKELY,  # 'Щ'
        64: SequenceLikelihood.UNLIKELY,  # 'Ь'
        61: SequenceLikelihood.UNLIKELY,  # 'Ю'
        50: SequenceLikelihood.LIKELY,  # 'Я'
        2: SequenceLikelihood.POSITIVE,  # 'а'
        21: SequenceLikelihood.UNLIKELY,  # 'б'
        7: SequenceLikelihood.UNLIKELY,  # 'в'
        20: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        9: SequenceLikelihood.POSITIVE,  # 'е'
        26: SequenceLikelihood.NEGATIVE,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.LIKELY,  # 'и'
        23: SequenceLikelihood.NEGATIVE,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        12: SequenceLikelihood.NEGATIVE,  # 'л'
        15: SequenceLikelihood.UNLIKELY,  # 'м'
        3: SequenceLikelihood.UNLIKELY,  # 'н'
        1: SequenceLikelihood.POSITIVE,  # 'о'
        16: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        6: SequenceLikelihood.UNLIKELY,  # 'т'
        14: SequenceLikelihood.LIKELY,  # 'у'
        32: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        25: SequenceLikelihood.UNLIKELY,  # 'ц'
        22: SequenceLikelihood.UNLIKELY,  # 'ч'
        29: SequenceLikelihood.UNLIKELY,  # 'ш'
        31: SequenceLikelihood.UNLIKELY,  # 'щ'
        19: SequenceLikelihood.UNLIKELY,  # 'ь'
        27: SequenceLikelihood.UNLIKELY,  # 'ю'
        17: SequenceLikelihood.UNLIKELY,  # 'я'
        30: SequenceLikelihood.UNLIKELY,  # 'є'
        5: SequenceLikelihood.LIKELY,  # 'і'
        28: SequenceLikelihood.UNLIKELY,  # 'ї'
        66: SequenceLikelihood.UNLIKELY,  # 'Ґ'
        65: SequenceLikelihood.UNLIKELY,  # 'ґ'
    },
    41: {  # 'О'
        67: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        57: SequenceLikelihood.UNLIKELY,  # 'Є'
        46: SequenceLikelihood.UNLIKELY,  # 'І'
        63: SequenceLikelihood.UNLIKELY,  # 'Ї'
        39: SequenceLikelihood.UNLIKELY,  # 'А'
        47: SequenceLikelihood.LIKELY,  # 'Б'
        34: SequenceLikelihood.LIKELY,  # 'В'
        48: SequenceLikelihood.LIKELY,  # 'Г'
        40: SequenceLikelihood.LIKELY,  # 'Д'
        54: SequenceLikelihood.UNLIKELY,  # 'Е'
        60: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.LIKELY,  # 'З'
        58: SequenceLikelihood.UNLIKELY,  # 'И'
        62: SequenceLikelihood.UNLIKELY,  # 'Й'
        36: SequenceLikelihood.LIKELY,  # 'К'
        49: SequenceLikelihood.LIKELY,  # 'Л'
        42: SequenceLikelihood.LIKELY,  # 'М'
        37: SequenceLikelihood.LIKELY,  # 'Н'
        41: SequenceLikelihood.LIKELY,  # 'О'
        33: SequenceLikelihood.LIKELY,  # 'П'
        45: SequenceLikelihood.LIKELY,  # 'Р'
        35: SequenceLikelihood.LIKELY,  # 'С'
        43: SequenceLikelihood.LIKELY,  # 'Т'
        38: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        55: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        52: SequenceLikelihood.UNLIKELY,  # 'Ч'
        56: SequenceLikelihood.UNLIKELY,  # 'Ш'
        59: SequenceLikelihood.UNLIKELY,  # 'Щ'
        64: SequenceLikelihood.UNLIKELY,  # 'Ь'
        61: SequenceLikelihood.UNLIKELY,  # 'Ю'
        50: SequenceLikelihood.UNLIKELY,  # 'Я'
        2: SequenceLikelihood.UNLIKELY,  # 'а'
        21: SequenceLikelihood.LIKELY,  # 'б'
        7: SequenceLikelihood.UNLIKELY,  # 'в'
        20: SequenceLikelihood.LIKELY,  # 'г'
        13: SequenceLikelihood.POSITIVE,  # 'д'
        9: SequenceLikelihood.UNLIKELY,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.UNLIKELY,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.LIKELY,  # 'к'
        12: SequenceLikelihood.POSITIVE,  # 'л'
        15: SequenceLikelihood.UNLIKELY,  # 'м'
        3: SequenceLikelihood.LIKELY,  # 'н'
        1: SequenceLikelihood.UNLIKELY,  # 'о'
        16: SequenceLikelihood.LIKELY,  # 'п'
        8: SequenceLikelihood.LIKELY,  # 'р'
        10: SequenceLikelihood.POSITIVE,  # 'с'
        6: SequenceLikelihood.LIKELY,  # 'т'
        14: SequenceLikelihood.UNLIKELY,  # 'у'
        32: SequenceLikelihood.LIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        25: SequenceLikelihood.UNLIKELY,  # 'ц'
        22: SequenceLikelihood.LIKELY,  # 'ч'
        29: SequenceLikelihood.UNLIKELY,  # 'ш'
        31: SequenceLikelihood.UNLIKELY,  # 'щ'
        19: SequenceLikelihood.NEGATIVE,  # 'ь'
        27: SequenceLikelihood.UNLIKELY,  # 'ю'
        17: SequenceLikelihood.UNLIKELY,  # 'я'
        30: SequenceLikelihood.NEGATIVE,  # 'є'
        5: SequenceLikelihood.UNLIKELY,  # 'і'
        28: SequenceLikelihood.UNLIKELY,  # 'ї'
        66: SequenceLikelihood.NEGATIVE,  # 'Ґ'
        65: SequenceLikelihood.UNLIKELY,  # 'ґ'
    },
    33: {  # 'П'
        67: SequenceLikelihood.UNLIKELY,  # 'ʼ'
        57: SequenceLikelihood.UNLIKELY,  # 'Є'
        46: SequenceLikelihood.LIKELY,  # 'І'
        63: SequenceLikelihood.UNLIKELY,  # 'Ї'
        39: SequenceLikelihood.LIKELY,  # 'А'
        47: SequenceLikelihood.UNLIKELY,  # 'Б'
        34: SequenceLikelihood.UNLIKELY,  # 'В'
        48: SequenceLikelihood.UNLIKELY,  # 'Г'
        40: SequenceLikelihood.LIKELY,  # 'Д'
        54: SequenceLikelihood.LIKELY,  # 'Е'
        60: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        58: SequenceLikelihood.UNLIKELY,  # 'И'
        62: SequenceLikelihood.UNLIKELY,  # 'Й'
        36: SequenceLikelihood.LIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        42: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.LIKELY,  # 'О'
        33: SequenceLikelihood.LIKELY,  # 'П'
        45: SequenceLikelihood.LIKELY,  # 'Р'
        35: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        38: SequenceLikelihood.LIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        55: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        52: SequenceLikelihood.UNLIKELY,  # 'Ч'
        56: SequenceLikelihood.UNLIKELY,  # 'Ш'
        59: SequenceLikelihood.UNLIKELY,  # 'Щ'
        64: SequenceLikelihood.UNLIKELY,  # 'Ь'
        61: SequenceLikelihood.UNLIKELY,  # 'Ю'
        50: SequenceLikelihood.UNLIKELY,  # 'Я'
        2: SequenceLikelihood.POSITIVE,  # 'а'
        21: SequenceLikelihood.UNLIKELY,  # 'б'
        7: SequenceLikelihood.UNLIKELY,  # 'в'
        20: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        9: SequenceLikelihood.POSITIVE,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.LIKELY,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        12: SequenceLikelihood.LIKELY,  # 'л'
        15: SequenceLikelihood.UNLIKELY,  # 'м'
        3: SequenceLikelihood.UNLIKELY,  # 'н'
        1: SequenceLikelihood.POSITIVE,  # 'о'
        16: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.POSITIVE,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        6: SequenceLikelihood.UNLIKELY,  # 'т'
        14: SequenceLikelihood.LIKELY,  # 'у'
        32: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        25: SequenceLikelihood.UNLIKELY,  # 'ц'
        22: SequenceLikelihood.UNLIKELY,  # 'ч'
        29: SequenceLikelihood.UNLIKELY,  # 'ш'
        31: SequenceLikelihood.UNLIKELY,  # 'щ'
        19: SequenceLikelihood.UNLIKELY,  # 'ь'
        27: SequenceLikelihood.UNLIKELY,  # 'ю'
        17: SequenceLikelihood.UNLIKELY,  # 'я'
        30: SequenceLikelihood.UNLIKELY,  # 'є'
        5: SequenceLikelihood.POSITIVE,  # 'і'
        28: SequenceLikelihood.NEGATIVE,  # 'ї'
        66: SequenceLikelihood.NEGATIVE,  # 'Ґ'
        65: SequenceLikelihood.NEGATIVE,  # 'ґ'
    },
    45: {  # 'Р'
        67: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        57: SequenceLikelihood.UNLIKELY,  # 'Є'
        46: SequenceLikelihood.LIKELY,  # 'І'
        63: SequenceLikelihood.NEGATIVE,  # 'Ї'
        39: SequenceLikelihood.LIKELY,  # 'А'
        47: SequenceLikelihood.UNLIKELY,  # 'Б'
        34: SequenceLikelihood.UNLIKELY,  # 'В'
        48: SequenceLikelihood.UNLIKELY,  # 'Г'
        40: SequenceLikelihood.UNLIKELY,  # 'Д'
        54: SequenceLikelihood.LIKELY,  # 'Е'
        60: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        58: SequenceLikelihood.LIKELY,  # 'И'
        62: SequenceLikelihood.UNLIKELY,  # 'Й'
        36: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        42: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.LIKELY,  # 'Н'
        41: SequenceLikelihood.LIKELY,  # 'О'
        33: SequenceLikelihood.UNLIKELY,  # 'П'
        45: SequenceLikelihood.UNLIKELY,  # 'Р'
        35: SequenceLikelihood.LIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        38: SequenceLikelihood.LIKELY,  # 'У'
        53: SequenceLikelihood.LIKELY,  # 'Ф'
        55: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        52: SequenceLikelihood.UNLIKELY,  # 'Ч'
        56: SequenceLikelihood.UNLIKELY,  # 'Ш'
        59: SequenceLikelihood.UNLIKELY,  # 'Щ'
        64: SequenceLikelihood.UNLIKELY,  # 'Ь'
        61: SequenceLikelihood.UNLIKELY,  # 'Ю'
        50: SequenceLikelihood.UNLIKELY,  # 'Я'
        2: SequenceLikelihood.POSITIVE,  # 'а'
        21: SequenceLikelihood.UNLIKELY,  # 'б'
        7: SequenceLikelihood.UNLIKELY,  # 'в'
        20: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        9: SequenceLikelihood.POSITIVE,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.LIKELY,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        12: SequenceLikelihood.NEGATIVE,  # 'л'
        15: SequenceLikelihood.UNLIKELY,  # 'м'
        3: SequenceLikelihood.UNLIKELY,  # 'н'
        1: SequenceLikelihood.POSITIVE,  # 'о'
        16: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        6: SequenceLikelihood.UNLIKELY,  # 'т'
        14: SequenceLikelihood.LIKELY,  # 'у'
        32: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        25: SequenceLikelihood.UNLIKELY,  # 'ц'
        22: SequenceLikelihood.UNLIKELY,  # 'ч'
        29: SequenceLikelihood.UNLIKELY,  # 'ш'
        31: SequenceLikelihood.UNLIKELY,  # 'щ'
        19: SequenceLikelihood.UNLIKELY,  # 'ь'
        27: SequenceLikelihood.UNLIKELY,  # 'ю'
        17: SequenceLikelihood.UNLIKELY,  # 'я'
        30: SequenceLikelihood.UNLIKELY,  # 'є'
        5: SequenceLikelihood.LIKELY,  # 'і'
        28: SequenceLikelihood.NEGATIVE,  # 'ї'
        66: SequenceLikelihood.UNLIKELY,  # 'Ґ'
        65: SequenceLikelihood.NEGATIVE,  # 'ґ'
    },
    35: {  # 'С'
        67: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        57: SequenceLikelihood.UNLIKELY,  # 'Є'
        46: SequenceLikelihood.UNLIKELY,  # 'І'
        63: SequenceLikelihood.UNLIKELY,  # 'Ї'
        39: SequenceLikelihood.UNLIKELY,  # 'А'
        47: SequenceLikelihood.LIKELY,  # 'Б'
        34: SequenceLikelihood.UNLIKELY,  # 'В'
        48: SequenceLikelihood.UNLIKELY,  # 'Г'
        40: SequenceLikelihood.UNLIKELY,  # 'Д'
        54: SequenceLikelihood.UNLIKELY,  # 'Е'
        60: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        58: SequenceLikelihood.UNLIKELY,  # 'И'
        62: SequenceLikelihood.UNLIKELY,  # 'Й'
        36: SequenceLikelihood.LIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        42: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.LIKELY,  # 'Н'
        41: SequenceLikelihood.LIKELY,  # 'О'
        33: SequenceLikelihood.LIKELY,  # 'П'
        45: SequenceLikelihood.LIKELY,  # 'Р'
        35: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.LIKELY,  # 'Т'
        38: SequenceLikelihood.LIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        55: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        52: SequenceLikelihood.UNLIKELY,  # 'Ч'
        56: SequenceLikelihood.LIKELY,  # 'Ш'
        59: SequenceLikelihood.UNLIKELY,  # 'Щ'
        64: SequenceLikelihood.LIKELY,  # 'Ь'
        61: SequenceLikelihood.UNLIKELY,  # 'Ю'
        50: SequenceLikelihood.UNLIKELY,  # 'Я'
        2: SequenceLikelihood.POSITIVE,  # 'а'
        21: SequenceLikelihood.UNLIKELY,  # 'б'
        7: SequenceLikelihood.LIKELY,  # 'в'
        20: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        9: SequenceLikelihood.POSITIVE,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.LIKELY,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.LIKELY,  # 'к'
        12: SequenceLikelihood.LIKELY,  # 'л'
        15: SequenceLikelihood.LIKELY,  # 'м'
        3: SequenceLikelihood.UNLIKELY,  # 'н'
        1: SequenceLikelihood.LIKELY,  # 'о'
        16: SequenceLikelihood.POSITIVE,  # 'п'
        8: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        6: SequenceLikelihood.POSITIVE,  # 'т'
        14: SequenceLikelihood.LIKELY,  # 'у'
        32: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.LIKELY,  # 'х'
        25: SequenceLikelihood.UNLIKELY,  # 'ц'
        22: SequenceLikelihood.UNLIKELY,  # 'ч'
        29: SequenceLikelihood.UNLIKELY,  # 'ш'
        31: SequenceLikelihood.UNLIKELY,  # 'щ'
        19: SequenceLikelihood.LIKELY,  # 'ь'
        27: SequenceLikelihood.UNLIKELY,  # 'ю'
        17: SequenceLikelihood.UNLIKELY,  # 'я'
        30: SequenceLikelihood.UNLIKELY,  # 'є'
        5: SequenceLikelihood.LIKELY,  # 'і'
        28: SequenceLikelihood.UNLIKELY,  # 'ї'
        66: SequenceLikelihood.NEGATIVE,  # 'Ґ'
        65: SequenceLikelihood.NEGATIVE,  # 'ґ'
    },
    43: {  # 'Т'
        67: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        57: SequenceLikelihood.UNLIKELY,  # 'Є'
        46: SequenceLikelihood.LIKELY,  # 'І'
        63: SequenceLikelihood.NEGATIVE,  # 'Ї'
        39: SequenceLikelihood.LIKELY,  # 'А'
        47: SequenceLikelihood.UNLIKELY,  # 'Б'
        34: SequenceLikelihood.LIKELY,  # 'В'
        48: SequenceLikelihood.UNLIKELY,  # 'Г'
        40: SequenceLikelihood.UNLIKELY,  # 'Д'
        54: SequenceLikelihood.LIKELY,  # 'Е'
        60: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        58: SequenceLikelihood.LIKELY,  # 'И'
        62: SequenceLikelihood.UNLIKELY,  # 'Й'
        36: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        42: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.LIKELY,  # 'О'
        33: SequenceLikelihood.LIKELY,  # 'П'
        45: SequenceLikelihood.LIKELY,  # 'Р'
        35: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        38: SequenceLikelihood.LIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        55: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        52: SequenceLikelihood.UNLIKELY,  # 'Ч'
        56: SequenceLikelihood.UNLIKELY,  # 'Ш'
        59: SequenceLikelihood.NEGATIVE,  # 'Щ'
        64: SequenceLikelihood.UNLIKELY,  # 'Ь'
        61: SequenceLikelihood.UNLIKELY,  # 'Ю'
        50: SequenceLikelihood.UNLIKELY,  # 'Я'
        2: SequenceLikelihood.POSITIVE,  # 'а'
        21: SequenceLikelihood.UNLIKELY,  # 'б'
        7: SequenceLikelihood.LIKELY,  # 'в'
        20: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        9: SequenceLikelihood.POSITIVE,  # 'е'
        26: SequenceLikelihood.NEGATIVE,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.LIKELY,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        12: SequenceLikelihood.UNLIKELY,  # 'л'
        15: SequenceLikelihood.UNLIKELY,  # 'м'
        3: SequenceLikelihood.UNLIKELY,  # 'н'
        1: SequenceLikelihood.POSITIVE,  # 'о'
        16: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.LIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        6: SequenceLikelihood.UNLIKELY,  # 'т'
        14: SequenceLikelihood.LIKELY,  # 'у'
        32: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        25: SequenceLikelihood.UNLIKELY,  # 'ц'
        22: SequenceLikelihood.UNLIKELY,  # 'ч'
        29: SequenceLikelihood.UNLIKELY,  # 'ш'
        31: SequenceLikelihood.UNLIKELY,  # 'щ'
        19: SequenceLikelihood.UNLIKELY,  # 'ь'
        27: SequenceLikelihood.UNLIKELY,  # 'ю'
        17: SequenceLikelihood.UNLIKELY,  # 'я'
        30: SequenceLikelihood.UNLIKELY,  # 'є'
        5: SequenceLikelihood.LIKELY,  # 'і'
        28: SequenceLikelihood.UNLIKELY,  # 'ї'
        66: SequenceLikelihood.NEGATIVE,  # 'Ґ'
        65: SequenceLikelihood.NEGATIVE,  # 'ґ'
    },
    38: {  # 'У'
        67: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        57: SequenceLikelihood.UNLIKELY,  # 'Є'
        46: SequenceLikelihood.UNLIKELY,  # 'І'
        63: SequenceLikelihood.UNLIKELY,  # 'Ї'
        39: SequenceLikelihood.UNLIKELY,  # 'А'
        47: SequenceLikelihood.UNLIKELY,  # 'Б'
        34: SequenceLikelihood.UNLIKELY,  # 'В'
        48: SequenceLikelihood.UNLIKELY,  # 'Г'
        40: SequenceLikelihood.UNLIKELY,  # 'Д'
        54: SequenceLikelihood.UNLIKELY,  # 'Е'
        60: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        58: SequenceLikelihood.UNLIKELY,  # 'И'
        62: SequenceLikelihood.UNLIKELY,  # 'Й'
        36: SequenceLikelihood.LIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        42: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.LIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        33: SequenceLikelihood.LIKELY,  # 'П'
        45: SequenceLikelihood.LIKELY,  # 'Р'
        35: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        38: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        55: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        52: SequenceLikelihood.UNLIKELY,  # 'Ч'
        56: SequenceLikelihood.UNLIKELY,  # 'Ш'
        59: SequenceLikelihood.UNLIKELY,  # 'Щ'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        61: SequenceLikelihood.UNLIKELY,  # 'Ю'
        50: SequenceLikelihood.UNLIKELY,  # 'Я'
        2: SequenceLikelihood.UNLIKELY,  # 'а'
        21: SequenceLikelihood.UNLIKELY,  # 'б'
        7: SequenceLikelihood.UNLIKELY,  # 'в'
        20: SequenceLikelihood.LIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        9: SequenceLikelihood.UNLIKELY,  # 'е'
        26: SequenceLikelihood.LIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.UNLIKELY,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        12: SequenceLikelihood.UNLIKELY,  # 'л'
        15: SequenceLikelihood.LIKELY,  # 'м'
        3: SequenceLikelihood.LIKELY,  # 'н'
        1: SequenceLikelihood.UNLIKELY,  # 'о'
        16: SequenceLikelihood.LIKELY,  # 'п'
        8: SequenceLikelihood.LIKELY,  # 'р'
        10: SequenceLikelihood.LIKELY,  # 'с'
        6: SequenceLikelihood.UNLIKELY,  # 'т'
        14: SequenceLikelihood.UNLIKELY,  # 'у'
        32: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        25: SequenceLikelihood.UNLIKELY,  # 'ц'
        22: SequenceLikelihood.LIKELY,  # 'ч'
        29: SequenceLikelihood.UNLIKELY,  # 'ш'
        31: SequenceLikelihood.UNLIKELY,  # 'щ'
        19: SequenceLikelihood.NEGATIVE,  # 'ь'
        27: SequenceLikelihood.UNLIKELY,  # 'ю'
        17: SequenceLikelihood.UNLIKELY,  # 'я'
        30: SequenceLikelihood.UNLIKELY,  # 'є'
        5: SequenceLikelihood.UNLIKELY,  # 'і'
        28: SequenceLikelihood.UNLIKELY,  # 'ї'
        66: SequenceLikelihood.NEGATIVE,  # 'Ґ'
        65: SequenceLikelihood.UNLIKELY,  # 'ґ'
    },
    53: {  # 'Ф'
        67: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        57: SequenceLikelihood.UNLIKELY,  # 'Є'
        46: SequenceLikelihood.UNLIKELY,  # 'І'
        63: SequenceLikelihood.NEGATIVE,  # 'Ї'
        39: SequenceLikelihood.UNLIKELY,  # 'А'
        47: SequenceLikelihood.UNLIKELY,  # 'Б'
        34: SequenceLikelihood.UNLIKELY,  # 'В'
        48: SequenceLikelihood.UNLIKELY,  # 'Г'
        40: SequenceLikelihood.UNLIKELY,  # 'Д'
        54: SequenceLikelihood.UNLIKELY,  # 'Е'
        60: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        58: SequenceLikelihood.UNLIKELY,  # 'И'
        62: SequenceLikelihood.UNLIKELY,  # 'Й'
        36: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        42: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.LIKELY,  # 'О'
        33: SequenceLikelihood.UNLIKELY,  # 'П'
        45: SequenceLikelihood.UNLIKELY,  # 'Р'
        35: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        38: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        55: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        52: SequenceLikelihood.UNLIKELY,  # 'Ч'
        56: SequenceLikelihood.UNLIKELY,  # 'Ш'
        59: SequenceLikelihood.NEGATIVE,  # 'Щ'
        64: SequenceLikelihood.UNLIKELY,  # 'Ь'
        61: SequenceLikelihood.UNLIKELY,  # 'Ю'
        50: SequenceLikelihood.UNLIKELY,  # 'Я'
        2: SequenceLikelihood.LIKELY,  # 'а'
        21: SequenceLikelihood.UNLIKELY,  # 'б'
        7: SequenceLikelihood.UNLIKELY,  # 'в'
        20: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        9: SequenceLikelihood.LIKELY,  # 'е'
        26: SequenceLikelihood.NEGATIVE,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.UNLIKELY,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        12: SequenceLikelihood.UNLIKELY,  # 'л'
        15: SequenceLikelihood.UNLIKELY,  # 'м'
        3: SequenceLikelihood.UNLIKELY,  # 'н'
        1: SequenceLikelihood.LIKELY,  # 'о'
        16: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.LIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        6: SequenceLikelihood.UNLIKELY,  # 'т'
        14: SequenceLikelihood.LIKELY,  # 'у'
        32: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        25: SequenceLikelihood.NEGATIVE,  # 'ц'
        22: SequenceLikelihood.NEGATIVE,  # 'ч'
        29: SequenceLikelihood.NEGATIVE,  # 'ш'
        31: SequenceLikelihood.NEGATIVE,  # 'щ'
        19: SequenceLikelihood.UNLIKELY,  # 'ь'
        27: SequenceLikelihood.UNLIKELY,  # 'ю'
        17: SequenceLikelihood.UNLIKELY,  # 'я'
        30: SequenceLikelihood.UNLIKELY,  # 'є'
        5: SequenceLikelihood.LIKELY,  # 'і'
        28: SequenceLikelihood.NEGATIVE,  # 'ї'
        66: SequenceLikelihood.NEGATIVE,  # 'Ґ'
        65: SequenceLikelihood.NEGATIVE,  # 'ґ'
    },
    55: {  # 'Х'
        67: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        57: SequenceLikelihood.UNLIKELY,  # 'Є'
        46: SequenceLikelihood.UNLIKELY,  # 'І'
        63: SequenceLikelihood.UNLIKELY,  # 'Ї'
        39: SequenceLikelihood.UNLIKELY,  # 'А'
        47: SequenceLikelihood.UNLIKELY,  # 'Б'
        34: SequenceLikelihood.UNLIKELY,  # 'В'
        48: SequenceLikelihood.UNLIKELY,  # 'Г'
        40: SequenceLikelihood.UNLIKELY,  # 'Д'
        54: SequenceLikelihood.UNLIKELY,  # 'Е'
        60: SequenceLikelihood.NEGATIVE,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        58: SequenceLikelihood.UNLIKELY,  # 'И'
        62: SequenceLikelihood.UNLIKELY,  # 'Й'
        36: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        42: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        33: SequenceLikelihood.UNLIKELY,  # 'П'
        45: SequenceLikelihood.UNLIKELY,  # 'Р'
        35: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        38: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        55: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        52: SequenceLikelihood.UNLIKELY,  # 'Ч'
        56: SequenceLikelihood.UNLIKELY,  # 'Ш'
        59: SequenceLikelihood.NEGATIVE,  # 'Щ'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        61: SequenceLikelihood.NEGATIVE,  # 'Ю'
        50: SequenceLikelihood.NEGATIVE,  # 'Я'
        2: SequenceLikelihood.LIKELY,  # 'а'
        21: SequenceLikelihood.UNLIKELY,  # 'б'
        7: SequenceLikelihood.UNLIKELY,  # 'в'
        20: SequenceLikelihood.NEGATIVE,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        9: SequenceLikelihood.LIKELY,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.UNLIKELY,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        12: SequenceLikelihood.UNLIKELY,  # 'л'
        15: SequenceLikelihood.LIKELY,  # 'м'
        3: SequenceLikelihood.UNLIKELY,  # 'н'
        1: SequenceLikelihood.LIKELY,  # 'о'
        16: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.LIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        6: SequenceLikelihood.LIKELY,  # 'т'
        14: SequenceLikelihood.UNLIKELY,  # 'у'
        32: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        25: SequenceLikelihood.NEGATIVE,  # 'ц'
        22: SequenceLikelihood.NEGATIVE,  # 'ч'
        29: SequenceLikelihood.UNLIKELY,  # 'ш'
        31: SequenceLikelihood.NEGATIVE,  # 'щ'
        19: SequenceLikelihood.UNLIKELY,  # 'ь'
        27: SequenceLikelihood.UNLIKELY,  # 'ю'
        17: SequenceLikelihood.UNLIKELY,  # 'я'
        30: SequenceLikelihood.UNLIKELY,  # 'є'
        5: SequenceLikelihood.LIKELY,  # 'і'
        28: SequenceLikelihood.NEGATIVE,  # 'ї'
        66: SequenceLikelihood.NEGATIVE,  # 'Ґ'
        65: SequenceLikelihood.NEGATIVE,  # 'ґ'
    },
    51: {  # 'Ц'
        67: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        57: SequenceLikelihood.UNLIKELY,  # 'Є'
        46: SequenceLikelihood.LIKELY,  # 'І'
        63: SequenceLikelihood.UNLIKELY,  # 'Ї'
        39: SequenceLikelihood.UNLIKELY,  # 'А'
        47: SequenceLikelihood.UNLIKELY,  # 'Б'
        34: SequenceLikelihood.UNLIKELY,  # 'В'
        48: SequenceLikelihood.UNLIKELY,  # 'Г'
        40: SequenceLikelihood.UNLIKELY,  # 'Д'
        54: SequenceLikelihood.UNLIKELY,  # 'Е'
        60: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        58: SequenceLikelihood.UNLIKELY,  # 'И'
        62: SequenceLikelihood.NEGATIVE,  # 'Й'
        36: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        42: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        33: SequenceLikelihood.UNLIKELY,  # 'П'
        45: SequenceLikelihood.UNLIKELY,  # 'Р'
        35: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        38: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        55: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        52: SequenceLikelihood.UNLIKELY,  # 'Ч'
        56: SequenceLikelihood.UNLIKELY,  # 'Ш'
        59: SequenceLikelihood.UNLIKELY,  # 'Щ'
        64: SequenceLikelihood.UNLIKELY,  # 'Ь'
        61: SequenceLikelihood.UNLIKELY,  # 'Ю'
        50: SequenceLikelihood.UNLIKELY,  # 'Я'
        2: SequenceLikelihood.UNLIKELY,  # 'а'
        21: SequenceLikelihood.UNLIKELY,  # 'б'
        7: SequenceLikelihood.UNLIKELY,  # 'в'
        20: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        9: SequenceLikelihood.POSITIVE,  # 'е'
        26: SequenceLikelihood.NEGATIVE,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.LIKELY,  # 'и'
        23: SequenceLikelihood.NEGATIVE,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        12: SequenceLikelihood.NEGATIVE,  # 'л'
        15: SequenceLikelihood.UNLIKELY,  # 'м'
        3: SequenceLikelihood.UNLIKELY,  # 'н'
        1: SequenceLikelihood.UNLIKELY,  # 'о'
        16: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        6: SequenceLikelihood.UNLIKELY,  # 'т'
        14: SequenceLikelihood.UNLIKELY,  # 'у'
        32: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        25: SequenceLikelihood.UNLIKELY,  # 'ц'
        22: SequenceLikelihood.NEGATIVE,  # 'ч'
        29: SequenceLikelihood.UNLIKELY,  # 'ш'
        31: SequenceLikelihood.NEGATIVE,  # 'щ'
        19: SequenceLikelihood.LIKELY,  # 'ь'
        27: SequenceLikelihood.UNLIKELY,  # 'ю'
        17: SequenceLikelihood.LIKELY,  # 'я'
        30: SequenceLikelihood.UNLIKELY,  # 'є'
        5: SequenceLikelihood.LIKELY,  # 'і'
        28: SequenceLikelihood.UNLIKELY,  # 'ї'
        66: SequenceLikelihood.NEGATIVE,  # 'Ґ'
        65: SequenceLikelihood.NEGATIVE,  # 'ґ'
    },
    52: {  # 'Ч'
        67: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        57: SequenceLikelihood.UNLIKELY,  # 'Є'
        46: SequenceLikelihood.UNLIKELY,  # 'І'
        63: SequenceLikelihood.NEGATIVE,  # 'Ї'
        39: SequenceLikelihood.UNLIKELY,  # 'А'
        47: SequenceLikelihood.UNLIKELY,  # 'Б'
        34: SequenceLikelihood.UNLIKELY,  # 'В'
        48: SequenceLikelihood.UNLIKELY,  # 'Г'
        40: SequenceLikelihood.UNLIKELY,  # 'Д'
        54: SequenceLikelihood.UNLIKELY,  # 'Е'
        60: SequenceLikelihood.NEGATIVE,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        58: SequenceLikelihood.UNLIKELY,  # 'И'
        62: SequenceLikelihood.NEGATIVE,  # 'Й'
        36: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        42: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        33: SequenceLikelihood.UNLIKELY,  # 'П'
        45: SequenceLikelihood.UNLIKELY,  # 'Р'
        35: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        38: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        55: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        52: SequenceLikelihood.UNLIKELY,  # 'Ч'
        56: SequenceLikelihood.UNLIKELY,  # 'Ш'
        59: SequenceLikelihood.NEGATIVE,  # 'Щ'
        64: SequenceLikelihood.UNLIKELY,  # 'Ь'
        61: SequenceLikelihood.UNLIKELY,  # 'Ю'
        50: SequenceLikelihood.UNLIKELY,  # 'Я'
        2: SequenceLikelihood.LIKELY,  # 'а'
        21: SequenceLikelihood.UNLIKELY,  # 'б'
        7: SequenceLikelihood.UNLIKELY,  # 'в'
        20: SequenceLikelihood.NEGATIVE,  # 'г'
        13: SequenceLikelihood.NEGATIVE,  # 'д'
        9: SequenceLikelihood.POSITIVE,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.NEGATIVE,  # 'з'
        4: SequenceLikelihood.LIKELY,  # 'и'
        23: SequenceLikelihood.NEGATIVE,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        12: SequenceLikelihood.UNLIKELY,  # 'л'
        15: SequenceLikelihood.UNLIKELY,  # 'м'
        3: SequenceLikelihood.UNLIKELY,  # 'н'
        1: SequenceLikelihood.LIKELY,  # 'о'
        16: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        6: SequenceLikelihood.UNLIKELY,  # 'т'
        14: SequenceLikelihood.LIKELY,  # 'у'
        32: SequenceLikelihood.NEGATIVE,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        25: SequenceLikelihood.UNLIKELY,  # 'ц'
        22: SequenceLikelihood.NEGATIVE,  # 'ч'
        29: SequenceLikelihood.UNLIKELY,  # 'ш'
        31: SequenceLikelihood.NEGATIVE,  # 'щ'
        19: SequenceLikelihood.UNLIKELY,  # 'ь'
        27: SequenceLikelihood.UNLIKELY,  # 'ю'
        17: SequenceLikelihood.UNLIKELY,  # 'я'
        30: SequenceLikelihood.UNLIKELY,  # 'є'
        5: SequenceLikelihood.UNLIKELY,  # 'і'
        28: SequenceLikelihood.NEGATIVE,  # 'ї'
        66: SequenceLikelihood.NEGATIVE,  # 'Ґ'
        65: SequenceLikelihood.NEGATIVE,  # 'ґ'
    },
    56: {  # 'Ш'
        67: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        57: SequenceLikelihood.UNLIKELY,  # 'Є'
        46: SequenceLikelihood.UNLIKELY,  # 'І'
        63: SequenceLikelihood.NEGATIVE,  # 'Ї'
        39: SequenceLikelihood.LIKELY,  # 'А'
        47: SequenceLikelihood.UNLIKELY,  # 'Б'
        34: SequenceLikelihood.UNLIKELY,  # 'В'
        48: SequenceLikelihood.UNLIKELY,  # 'Г'
        40: SequenceLikelihood.UNLIKELY,  # 'Д'
        54: SequenceLikelihood.UNLIKELY,  # 'Е'
        60: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        58: SequenceLikelihood.UNLIKELY,  # 'И'
        62: SequenceLikelihood.NEGATIVE,  # 'Й'
        36: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        42: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        33: SequenceLikelihood.UNLIKELY,  # 'П'
        45: SequenceLikelihood.UNLIKELY,  # 'Р'
        35: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        38: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        55: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        52: SequenceLikelihood.UNLIKELY,  # 'Ч'
        56: SequenceLikelihood.UNLIKELY,  # 'Ш'
        59: SequenceLikelihood.UNLIKELY,  # 'Щ'
        64: SequenceLikelihood.UNLIKELY,  # 'Ь'
        61: SequenceLikelihood.UNLIKELY,  # 'Ю'
        50: SequenceLikelihood.UNLIKELY,  # 'Я'
        2: SequenceLikelihood.LIKELY,  # 'а'
        21: SequenceLikelihood.NEGATIVE,  # 'б'
        7: SequenceLikelihood.LIKELY,  # 'в'
        20: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        9: SequenceLikelihood.LIKELY,  # 'е'
        26: SequenceLikelihood.NEGATIVE,  # 'ж'
        18: SequenceLikelihood.NEGATIVE,  # 'з'
        4: SequenceLikelihood.LIKELY,  # 'и'
        23: SequenceLikelihood.NEGATIVE,  # 'й'
        11: SequenceLikelihood.LIKELY,  # 'к'
        12: SequenceLikelihood.UNLIKELY,  # 'л'
        15: SequenceLikelihood.UNLIKELY,  # 'м'
        3: SequenceLikelihood.UNLIKELY,  # 'н'
        1: SequenceLikelihood.LIKELY,  # 'о'
        16: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        6: SequenceLikelihood.LIKELY,  # 'т'
        14: SequenceLikelihood.LIKELY,  # 'у'
        32: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        25: SequenceLikelihood.UNLIKELY,  # 'ц'
        22: SequenceLikelihood.UNLIKELY,  # 'ч'
        29: SequenceLikelihood.UNLIKELY,  # 'ш'
        31: SequenceLikelihood.NEGATIVE,  # 'щ'
        19: SequenceLikelihood.UNLIKELY,  # 'ь'
        27: SequenceLikelihood.UNLIKELY,  # 'ю'
        17: SequenceLikelihood.UNLIKELY,  # 'я'
        30: SequenceLikelihood.UNLIKELY,  # 'є'
        5: SequenceLikelihood.UNLIKELY,  # 'і'
        28: SequenceLikelihood.NEGATIVE,  # 'ї'
        66: SequenceLikelihood.NEGATIVE,  # 'Ґ'
        65: SequenceLikelihood.NEGATIVE,  # 'ґ'
    },
    59: {  # 'Щ'
        67: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        57: SequenceLikelihood.UNLIKELY,  # 'Є'
        46: SequenceLikelihood.UNLIKELY,  # 'І'
        63: SequenceLikelihood.UNLIKELY,  # 'Ї'
        39: SequenceLikelihood.UNLIKELY,  # 'А'
        47: SequenceLikelihood.UNLIKELY,  # 'Б'
        34: SequenceLikelihood.UNLIKELY,  # 'В'
        48: SequenceLikelihood.NEGATIVE,  # 'Г'
        40: SequenceLikelihood.UNLIKELY,  # 'Д'
        54: SequenceLikelihood.UNLIKELY,  # 'Е'
        60: SequenceLikelihood.NEGATIVE,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        58: SequenceLikelihood.UNLIKELY,  # 'И'
        62: SequenceLikelihood.NEGATIVE,  # 'Й'
        36: SequenceLikelihood.NEGATIVE,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        42: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        33: SequenceLikelihood.UNLIKELY,  # 'П'
        45: SequenceLikelihood.UNLIKELY,  # 'Р'
        35: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        38: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.NEGATIVE,  # 'Ф'
        55: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        52: SequenceLikelihood.NEGATIVE,  # 'Ч'
        56: SequenceLikelihood.UNLIKELY,  # 'Ш'
        59: SequenceLikelihood.UNLIKELY,  # 'Щ'
        64: SequenceLikelihood.UNLIKELY,  # 'Ь'
        61: SequenceLikelihood.UNLIKELY,  # 'Ю'
        50: SequenceLikelihood.UNLIKELY,  # 'Я'
        2: SequenceLikelihood.UNLIKELY,  # 'а'
        21: SequenceLikelihood.UNLIKELY,  # 'б'
        7: SequenceLikelihood.UNLIKELY,  # 'в'
        20: SequenceLikelihood.NEGATIVE,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        9: SequenceLikelihood.LIKELY,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.NEGATIVE,  # 'з'
        4: SequenceLikelihood.UNLIKELY,  # 'и'
        23: SequenceLikelihood.NEGATIVE,  # 'й'
        11: SequenceLikelihood.NEGATIVE,  # 'к'
        12: SequenceLikelihood.UNLIKELY,  # 'л'
        15: SequenceLikelihood.UNLIKELY,  # 'м'
        3: SequenceLikelihood.UNLIKELY,  # 'н'
        1: SequenceLikelihood.POSITIVE,  # 'о'
        16: SequenceLikelihood.NEGATIVE,  # 'п'
        8: SequenceLikelihood.NEGATIVE,  # 'р'
        10: SequenceLikelihood.NEGATIVE,  # 'с'
        6: SequenceLikelihood.NEGATIVE,  # 'т'
        14: SequenceLikelihood.UNLIKELY,  # 'у'
        32: SequenceLikelihood.NEGATIVE,  # 'ф'
        24: SequenceLikelihood.NEGATIVE,  # 'х'
        25: SequenceLikelihood.UNLIKELY,  # 'ц'
        22: SequenceLikelihood.NEGATIVE,  # 'ч'
        29: SequenceLikelihood.NEGATIVE,  # 'ш'
        31: SequenceLikelihood.NEGATIVE,  # 'щ'
        19: SequenceLikelihood.UNLIKELY,  # 'ь'
        27: SequenceLikelihood.NEGATIVE,  # 'ю'
        17: SequenceLikelihood.NEGATIVE,  # 'я'
        30: SequenceLikelihood.UNLIKELY,  # 'є'
        5: SequenceLikelihood.UNLIKELY,  # 'і'
        28: SequenceLikelihood.NEGATIVE,  # 'ї'
        66: SequenceLikelihood.NEGATIVE,  # 'Ґ'
        65: SequenceLikelihood.NEGATIVE,  # 'ґ'
    },
    64: {  # 'Ь'
        67: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        57: SequenceLikelihood.UNLIKELY,  # 'Є'
        46: SequenceLikelihood.UNLIKELY,  # 'І'
        63: SequenceLikelihood.UNLIKELY,  # 'Ї'
        39: SequenceLikelihood.NEGATIVE,  # 'А'
        47: SequenceLikelihood.UNLIKELY,  # 'Б'
        34: SequenceLikelihood.UNLIKELY,  # 'В'
        48: SequenceLikelihood.UNLIKELY,  # 'Г'
        40: SequenceLikelihood.UNLIKELY,  # 'Д'
        54: SequenceLikelihood.UNLIKELY,  # 'Е'
        60: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        58: SequenceLikelihood.UNLIKELY,  # 'И'
        62: SequenceLikelihood.UNLIKELY,  # 'Й'
        36: SequenceLikelihood.LIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        42: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.LIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        33: SequenceLikelihood.UNLIKELY,  # 'П'
        45: SequenceLikelihood.UNLIKELY,  # 'Р'
        35: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        38: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        55: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        52: SequenceLikelihood.UNLIKELY,  # 'Ч'
        56: SequenceLikelihood.UNLIKELY,  # 'Ш'
        59: SequenceLikelihood.UNLIKELY,  # 'Щ'
        64: SequenceLikelihood.UNLIKELY,  # 'Ь'
        61: SequenceLikelihood.UNLIKELY,  # 'Ю'
        50: SequenceLikelihood.UNLIKELY,  # 'Я'
        2: SequenceLikelihood.UNLIKELY,  # 'а'
        21: SequenceLikelihood.NEGATIVE,  # 'б'
        7: SequenceLikelihood.UNLIKELY,  # 'в'
        20: SequenceLikelihood.NEGATIVE,  # 'г'
        13: SequenceLikelihood.NEGATIVE,  # 'д'
        9: SequenceLikelihood.UNLIKELY,  # 'е'
        26: SequenceLikelihood.NEGATIVE,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.NEGATIVE,  # 'и'
        23: SequenceLikelihood.NEGATIVE,  # 'й'
        11: SequenceLikelihood.NEGATIVE,  # 'к'
        12: SequenceLikelihood.UNLIKELY,  # 'л'
        15: SequenceLikelihood.UNLIKELY,  # 'м'
        3: SequenceLikelihood.UNLIKELY,  # 'н'
        1: SequenceLikelihood.UNLIKELY,  # 'о'
        16: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        6: SequenceLikelihood.UNLIKELY,  # 'т'
        14: SequenceLikelihood.UNLIKELY,  # 'у'
        32: SequenceLikelihood.NEGATIVE,  # 'ф'
        24: SequenceLikelihood.NEGATIVE,  # 'х'
        25: SequenceLikelihood.NEGATIVE,  # 'ц'
        22: SequenceLikelihood.UNLIKELY,  # 'ч'
        29: SequenceLikelihood.NEGATIVE,  # 'ш'
        31: SequenceLikelihood.NEGATIVE,  # 'щ'
        19: SequenceLikelihood.NEGATIVE,  # 'ь'
        27: SequenceLikelihood.UNLIKELY,  # 'ю'
        17: SequenceLikelihood.NEGATIVE,  # 'я'
        30: SequenceLikelihood.UNLIKELY,  # 'є'
        5: SequenceLikelihood.UNLIKELY,  # 'і'
        28: SequenceLikelihood.NEGATIVE,  # 'ї'
        66: SequenceLikelihood.NEGATIVE,  # 'Ґ'
        65: SequenceLikelihood.NEGATIVE,  # 'ґ'
    },
    61: {  # 'Ю'
        67: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        57: SequenceLikelihood.UNLIKELY,  # 'Є'
        46: SequenceLikelihood.UNLIKELY,  # 'І'
        63: SequenceLikelihood.UNLIKELY,  # 'Ї'
        39: SequenceLikelihood.UNLIKELY,  # 'А'
        47: SequenceLikelihood.UNLIKELY,  # 'Б'
        34: SequenceLikelihood.UNLIKELY,  # 'В'
        48: SequenceLikelihood.UNLIKELY,  # 'Г'
        40: SequenceLikelihood.UNLIKELY,  # 'Д'
        54: SequenceLikelihood.UNLIKELY,  # 'Е'
        60: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        58: SequenceLikelihood.NEGATIVE,  # 'И'
        62: SequenceLikelihood.UNLIKELY,  # 'Й'
        36: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        42: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        33: SequenceLikelihood.UNLIKELY,  # 'П'
        45: SequenceLikelihood.UNLIKELY,  # 'Р'
        35: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        38: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        55: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        52: SequenceLikelihood.UNLIKELY,  # 'Ч'
        56: SequenceLikelihood.UNLIKELY,  # 'Ш'
        59: SequenceLikelihood.UNLIKELY,  # 'Щ'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        61: SequenceLikelihood.UNLIKELY,  # 'Ю'
        50: SequenceLikelihood.UNLIKELY,  # 'Я'
        2: SequenceLikelihood.UNLIKELY,  # 'а'
        21: SequenceLikelihood.UNLIKELY,  # 'б'
        7: SequenceLikelihood.UNLIKELY,  # 'в'
        20: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        9: SequenceLikelihood.UNLIKELY,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.NEGATIVE,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        12: SequenceLikelihood.LIKELY,  # 'л'
        15: SequenceLikelihood.UNLIKELY,  # 'м'
        3: SequenceLikelihood.UNLIKELY,  # 'н'
        1: SequenceLikelihood.UNLIKELY,  # 'о'
        16: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.LIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        6: SequenceLikelihood.UNLIKELY,  # 'т'
        14: SequenceLikelihood.UNLIKELY,  # 'у'
        32: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        25: SequenceLikelihood.UNLIKELY,  # 'ц'
        22: SequenceLikelihood.UNLIKELY,  # 'ч'
        29: SequenceLikelihood.UNLIKELY,  # 'ш'
        31: SequenceLikelihood.UNLIKELY,  # 'щ'
        19: SequenceLikelihood.NEGATIVE,  # 'ь'
        27: SequenceLikelihood.UNLIKELY,  # 'ю'
        17: SequenceLikelihood.UNLIKELY,  # 'я'
        30: SequenceLikelihood.UNLIKELY,  # 'є'
        5: SequenceLikelihood.UNLIKELY,  # 'і'
        28: SequenceLikelihood.UNLIKELY,  # 'ї'
        66: SequenceLikelihood.NEGATIVE,  # 'Ґ'
        65: SequenceLikelihood.UNLIKELY,  # 'ґ'
    },
    50: {  # 'Я'
        67: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        57: SequenceLikelihood.UNLIKELY,  # 'Є'
        46: SequenceLikelihood.UNLIKELY,  # 'І'
        63: SequenceLikelihood.UNLIKELY,  # 'Ї'
        39: SequenceLikelihood.UNLIKELY,  # 'А'
        47: SequenceLikelihood.UNLIKELY,  # 'Б'
        34: SequenceLikelihood.UNLIKELY,  # 'В'
        48: SequenceLikelihood.UNLIKELY,  # 'Г'
        40: SequenceLikelihood.UNLIKELY,  # 'Д'
        54: SequenceLikelihood.UNLIKELY,  # 'Е'
        60: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        58: SequenceLikelihood.UNLIKELY,  # 'И'
        62: SequenceLikelihood.UNLIKELY,  # 'Й'
        36: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        42: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        33: SequenceLikelihood.UNLIKELY,  # 'П'
        45: SequenceLikelihood.UNLIKELY,  # 'Р'
        35: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        38: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        55: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        52: SequenceLikelihood.UNLIKELY,  # 'Ч'
        56: SequenceLikelihood.UNLIKELY,  # 'Ш'
        59: SequenceLikelihood.UNLIKELY,  # 'Щ'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        61: SequenceLikelihood.UNLIKELY,  # 'Ю'
        50: SequenceLikelihood.UNLIKELY,  # 'Я'
        2: SequenceLikelihood.UNLIKELY,  # 'а'
        21: SequenceLikelihood.UNLIKELY,  # 'б'
        7: SequenceLikelihood.UNLIKELY,  # 'в'
        20: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        9: SequenceLikelihood.UNLIKELY,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.UNLIKELY,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        12: SequenceLikelihood.UNLIKELY,  # 'л'
        15: SequenceLikelihood.UNLIKELY,  # 'м'
        3: SequenceLikelihood.LIKELY,  # 'н'
        1: SequenceLikelihood.UNLIKELY,  # 'о'
        16: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.LIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        6: SequenceLikelihood.UNLIKELY,  # 'т'
        14: SequenceLikelihood.UNLIKELY,  # 'у'
        32: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        25: SequenceLikelihood.UNLIKELY,  # 'ц'
        22: SequenceLikelihood.UNLIKELY,  # 'ч'
        29: SequenceLikelihood.UNLIKELY,  # 'ш'
        31: SequenceLikelihood.UNLIKELY,  # 'щ'
        19: SequenceLikelihood.NEGATIVE,  # 'ь'
        27: SequenceLikelihood.NEGATIVE,  # 'ю'
        17: SequenceLikelihood.UNLIKELY,  # 'я'
        30: SequenceLikelihood.UNLIKELY,  # 'є'
        5: SequenceLikelihood.UNLIKELY,  # 'і'
        28: SequenceLikelihood.UNLIKELY,  # 'ї'
        66: SequenceLikelihood.NEGATIVE,  # 'Ґ'
        65: SequenceLikelihood.UNLIKELY,  # 'ґ'
    },
    2: {  # 'а'
        67: SequenceLikelihood.UNLIKELY,  # 'ʼ'
        57: SequenceLikelihood.UNLIKELY,  # 'Є'
        46: SequenceLikelihood.UNLIKELY,  # 'І'
        63: SequenceLikelihood.UNLIKELY,  # 'Ї'
        39: SequenceLikelihood.UNLIKELY,  # 'А'
        47: SequenceLikelihood.UNLIKELY,  # 'Б'
        34: SequenceLikelihood.UNLIKELY,  # 'В'
        48: SequenceLikelihood.UNLIKELY,  # 'Г'
        40: SequenceLikelihood.UNLIKELY,  # 'Д'
        54: SequenceLikelihood.UNLIKELY,  # 'Е'
        60: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        58: SequenceLikelihood.UNLIKELY,  # 'И'
        62: SequenceLikelihood.UNLIKELY,  # 'Й'
        36: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        42: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        33: SequenceLikelihood.UNLIKELY,  # 'П'
        45: SequenceLikelihood.UNLIKELY,  # 'Р'
        35: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        38: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        55: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        52: SequenceLikelihood.UNLIKELY,  # 'Ч'
        56: SequenceLikelihood.UNLIKELY,  # 'Ш'
        59: SequenceLikelihood.UNLIKELY,  # 'Щ'
        64: SequenceLikelihood.UNLIKELY,  # 'Ь'
        61: SequenceLikelihood.UNLIKELY,  # 'Ю'
        50: SequenceLikelihood.UNLIKELY,  # 'Я'
        2: SequenceLikelihood.LIKELY,  # 'а'
        21: SequenceLikelihood.POSITIVE,  # 'б'
        7: SequenceLikelihood.POSITIVE,  # 'в'
        20: SequenceLikelihood.POSITIVE,  # 'г'
        13: SequenceLikelihood.POSITIVE,  # 'д'
        9: SequenceLikelihood.LIKELY,  # 'е'
        26: SequenceLikelihood.POSITIVE,  # 'ж'
        18: SequenceLikelihood.POSITIVE,  # 'з'
        4: SequenceLikelihood.LIKELY,  # 'и'
        23: SequenceLikelihood.POSITIVE,  # 'й'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        12: SequenceLikelihood.POSITIVE,  # 'л'
        15: SequenceLikelihood.POSITIVE,  # 'м'
        3: SequenceLikelihood.POSITIVE,  # 'н'
        1: SequenceLikelihood.LIKELY,  # 'о'
        16: SequenceLikelihood.POSITIVE,  # 'п'
        8: SequenceLikelihood.POSITIVE,  # 'р'
        10: SequenceLikelihood.POSITIVE,  # 'с'
        6: SequenceLikelihood.POSITIVE,  # 'т'
        14: SequenceLikelihood.POSITIVE,  # 'у'
        32: SequenceLikelihood.POSITIVE,  # 'ф'
        24: SequenceLikelihood.POSITIVE,  # 'х'
        25: SequenceLikelihood.POSITIVE,  # 'ц'
        22: SequenceLikelihood.POSITIVE,  # 'ч'
        29: SequenceLikelihood.POSITIVE,  # 'ш'
        31: SequenceLikelihood.POSITIVE,  # 'щ'
        19: SequenceLikelihood.UNLIKELY,  # 'ь'
        27: SequenceLikelihood.POSITIVE,  # 'ю'
        17: SequenceLikelihood.POSITIVE,  # 'я'
        30: SequenceLikelihood.POSITIVE,  # 'є'
        5: SequenceLikelihood.UNLIKELY,  # 'і'
        28: SequenceLikelihood.POSITIVE,  # 'ї'
        66: SequenceLikelihood.NEGATIVE,  # 'Ґ'
        65: SequenceLikelihood.UNLIKELY,  # 'ґ'
    },
    21: {  # 'б'
        67: SequenceLikelihood.UNLIKELY,  # 'ʼ'
        57: SequenceLikelihood.NEGATIVE,  # 'Є'
        46: SequenceLikelihood.UNLIKELY,  # 'І'
        63: SequenceLikelihood.NEGATIVE,  # 'Ї'
        39: SequenceLikelihood.UNLIKELY,  # 'А'
        47: SequenceLikelihood.UNLIKELY,  # 'Б'
        34: SequenceLikelihood.UNLIKELY,  # 'В'
        48: SequenceLikelihood.UNLIKELY,  # 'Г'
        40: SequenceLikelihood.UNLIKELY,  # 'Д'
        54: SequenceLikelihood.UNLIKELY,  # 'Е'
        60: SequenceLikelihood.NEGATIVE,  # 'Ж'
        44: SequenceLikelihood.NEGATIVE,  # 'З'
        58: SequenceLikelihood.UNLIKELY,  # 'И'
        62: SequenceLikelihood.NEGATIVE,  # 'Й'
        36: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.NEGATIVE,  # 'Л'
        42: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        33: SequenceLikelihood.UNLIKELY,  # 'П'
        45: SequenceLikelihood.NEGATIVE,  # 'Р'
        35: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        38: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.NEGATIVE,  # 'Ф'
        55: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.NEGATIVE,  # 'Ц'
        52: SequenceLikelihood.UNLIKELY,  # 'Ч'
        56: SequenceLikelihood.UNLIKELY,  # 'Ш'
        59: SequenceLikelihood.UNLIKELY,  # 'Щ'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        61: SequenceLikelihood.NEGATIVE,  # 'Ю'
        50: SequenceLikelihood.NEGATIVE,  # 'Я'
        2: SequenceLikelihood.POSITIVE,  # 'а'
        21: SequenceLikelihood.UNLIKELY,  # 'б'
        7: SequenceLikelihood.LIKELY,  # 'в'
        20: SequenceLikelihood.LIKELY,  # 'г'
        13: SequenceLikelihood.LIKELY,  # 'д'
        9: SequenceLikelihood.POSITIVE,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.POSITIVE,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        12: SequenceLikelihood.POSITIVE,  # 'л'
        15: SequenceLikelihood.LIKELY,  # 'м'
        3: SequenceLikelihood.POSITIVE,  # 'н'
        1: SequenceLikelihood.POSITIVE,  # 'о'
        16: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.POSITIVE,  # 'р'
        10: SequenceLikelihood.POSITIVE,  # 'с'
        6: SequenceLikelihood.LIKELY,  # 'т'
        14: SequenceLikelihood.POSITIVE,  # 'у'
        32: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.POSITIVE,  # 'х'
        25: SequenceLikelihood.LIKELY,  # 'ц'
        22: SequenceLikelihood.LIKELY,  # 'ч'
        29: SequenceLikelihood.LIKELY,  # 'ш'
        31: SequenceLikelihood.UNLIKELY,  # 'щ'
        19: SequenceLikelihood.UNLIKELY,  # 'ь'
        27: SequenceLikelihood.LIKELY,  # 'ю'
        17: SequenceLikelihood.UNLIKELY,  # 'я'
        30: SequenceLikelihood.UNLIKELY,  # 'є'
        5: SequenceLikelihood.POSITIVE,  # 'і'
        28: SequenceLikelihood.UNLIKELY,  # 'ї'
        66: SequenceLikelihood.NEGATIVE,  # 'Ґ'
        65: SequenceLikelihood.LIKELY,  # 'ґ'
    },
    7: {  # 'в'
        67: SequenceLikelihood.UNLIKELY,  # 'ʼ'
        57: SequenceLikelihood.UNLIKELY,  # 'Є'
        46: SequenceLikelihood.UNLIKELY,  # 'І'
        63: SequenceLikelihood.UNLIKELY,  # 'Ї'
        39: SequenceLikelihood.UNLIKELY,  # 'А'
        47: SequenceLikelihood.UNLIKELY,  # 'Б'
        34: SequenceLikelihood.UNLIKELY,  # 'В'
        48: SequenceLikelihood.UNLIKELY,  # 'Г'
        40: SequenceLikelihood.UNLIKELY,  # 'Д'
        54: SequenceLikelihood.UNLIKELY,  # 'Е'
        60: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        58: SequenceLikelihood.UNLIKELY,  # 'И'
        62: SequenceLikelihood.NEGATIVE,  # 'Й'
        36: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        42: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        33: SequenceLikelihood.UNLIKELY,  # 'П'
        45: SequenceLikelihood.UNLIKELY,  # 'Р'
        35: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        38: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        55: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        52: SequenceLikelihood.UNLIKELY,  # 'Ч'
        56: SequenceLikelihood.UNLIKELY,  # 'Ш'
        59: SequenceLikelihood.UNLIKELY,  # 'Щ'
        64: SequenceLikelihood.UNLIKELY,  # 'Ь'
        61: SequenceLikelihood.UNLIKELY,  # 'Ю'
        50: SequenceLikelihood.UNLIKELY,  # 'Я'
        2: SequenceLikelihood.POSITIVE,  # 'а'
        21: SequenceLikelihood.LIKELY,  # 'б'
        7: SequenceLikelihood.POSITIVE,  # 'в'
        20: SequenceLikelihood.LIKELY,  # 'г'
        13: SequenceLikelihood.POSITIVE,  # 'д'
        9: SequenceLikelihood.POSITIVE,  # 'е'
        26: SequenceLikelihood.POSITIVE,  # 'ж'
        18: SequenceLikelihood.POSITIVE,  # 'з'
        4: SequenceLikelihood.POSITIVE,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        12: SequenceLikelihood.POSITIVE,  # 'л'
        15: SequenceLikelihood.LIKELY,  # 'м'
        3: SequenceLikelihood.POSITIVE,  # 'н'
        1: SequenceLikelihood.POSITIVE,  # 'о'
        16: SequenceLikelihood.POSITIVE,  # 'п'
        8: SequenceLikelihood.POSITIVE,  # 'р'
        10: SequenceLikelihood.POSITIVE,  # 'с'
        6: SequenceLikelihood.POSITIVE,  # 'т'
        14: SequenceLikelihood.POSITIVE,  # 'у'
        32: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.LIKELY,  # 'х'
        25: SequenceLikelihood.POSITIVE,  # 'ц'
        22: SequenceLikelihood.POSITIVE,  # 'ч'
        29: SequenceLikelihood.POSITIVE,  # 'ш'
        31: SequenceLikelihood.LIKELY,  # 'щ'
        19: SequenceLikelihood.UNLIKELY,  # 'ь'
        27: SequenceLikelihood.UNLIKELY,  # 'ю'
        17: SequenceLikelihood.POSITIVE,  # 'я'
        30: SequenceLikelihood.UNLIKELY,  # 'є'
        5: SequenceLikelihood.POSITIVE,  # 'і'
        28: SequenceLikelihood.UNLIKELY,  # 'ї'
        66: SequenceLikelihood.NEGATIVE,  # 'Ґ'
        65: SequenceLikelihood.UNLIKELY,  # 'ґ'
    },
    20: {  # 'г'
        67: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        57: SequenceLikelihood.NEGATIVE,  # 'Є'
        46: SequenceLikelihood.UNLIKELY,  # 'І'
        63: SequenceLikelihood.NEGATIVE,  # 'Ї'
        39: SequenceLikelihood.UNLIKELY,  # 'А'
        47: SequenceLikelihood.UNLIKELY,  # 'Б'
        34: SequenceLikelihood.UNLIKELY,  # 'В'
        48: SequenceLikelihood.UNLIKELY,  # 'Г'
        40: SequenceLikelihood.UNLIKELY,  # 'Д'
        54: SequenceLikelihood.UNLIKELY,  # 'Е'
        60: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        58: SequenceLikelihood.NEGATIVE,  # 'И'
        62: SequenceLikelihood.UNLIKELY,  # 'Й'
        36: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        42: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        33: SequenceLikelihood.UNLIKELY,  # 'П'
        45: SequenceLikelihood.UNLIKELY,  # 'Р'
        35: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        38: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        55: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        52: SequenceLikelihood.UNLIKELY,  # 'Ч'
        56: SequenceLikelihood.UNLIKELY,  # 'Ш'
        59: SequenceLikelihood.NEGATIVE,  # 'Щ'
        64: SequenceLikelihood.UNLIKELY,  # 'Ь'
        61: SequenceLikelihood.NEGATIVE,  # 'Ю'
        50: SequenceLikelihood.UNLIKELY,  # 'Я'
        2: SequenceLikelihood.POSITIVE,  # 'а'
        21: SequenceLikelihood.UNLIKELY,  # 'б'
        7: SequenceLikelihood.LIKELY,  # 'в'
        20: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.LIKELY,  # 'д'
        9: SequenceLikelihood.POSITIVE,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.POSITIVE,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.LIKELY,  # 'к'
        12: SequenceLikelihood.POSITIVE,  # 'л'
        15: SequenceLikelihood.LIKELY,  # 'м'
        3: SequenceLikelihood.POSITIVE,  # 'н'
        1: SequenceLikelihood.POSITIVE,  # 'о'
        16: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.POSITIVE,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        6: SequenceLikelihood.LIKELY,  # 'т'
        14: SequenceLikelihood.POSITIVE,  # 'у'
        32: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        25: SequenceLikelihood.UNLIKELY,  # 'ц'
        22: SequenceLikelihood.UNLIKELY,  # 'ч'
        29: SequenceLikelihood.LIKELY,  # 'ш'
        31: SequenceLikelihood.UNLIKELY,  # 'щ'
        19: SequenceLikelihood.UNLIKELY,  # 'ь'
        27: SequenceLikelihood.UNLIKELY,  # 'ю'
        17: SequenceLikelihood.UNLIKELY,  # 'я'
        30: SequenceLikelihood.UNLIKELY,  # 'є'
        5: SequenceLikelihood.POSITIVE,  # 'і'
        28: SequenceLikelihood.UNLIKELY,  # 'ї'
        66: SequenceLikelihood.NEGATIVE,  # 'Ґ'
        65: SequenceLikelihood.UNLIKELY,  # 'ґ'
    },
    13: {  # 'д'
        67: SequenceLikelihood.UNLIKELY,  # 'ʼ'
        57: SequenceLikelihood.UNLIKELY,  # 'Є'
        46: SequenceLikelihood.UNLIKELY,  # 'І'
        63: SequenceLikelihood.UNLIKELY,  # 'Ї'
        39: SequenceLikelihood.UNLIKELY,  # 'А'
        47: SequenceLikelihood.UNLIKELY,  # 'Б'
        34: SequenceLikelihood.UNLIKELY,  # 'В'
        48: SequenceLikelihood.UNLIKELY,  # 'Г'
        40: SequenceLikelihood.UNLIKELY,  # 'Д'
        54: SequenceLikelihood.UNLIKELY,  # 'Е'
        60: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        58: SequenceLikelihood.UNLIKELY,  # 'И'
        62: SequenceLikelihood.NEGATIVE,  # 'Й'
        36: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        42: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        33: SequenceLikelihood.UNLIKELY,  # 'П'
        45: SequenceLikelihood.UNLIKELY,  # 'Р'
        35: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        38: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        55: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        52: SequenceLikelihood.UNLIKELY,  # 'Ч'
        56: SequenceLikelihood.UNLIKELY,  # 'Ш'
        59: SequenceLikelihood.NEGATIVE,  # 'Щ'
        64: SequenceLikelihood.UNLIKELY,  # 'Ь'
        61: SequenceLikelihood.NEGATIVE,  # 'Ю'
        50: SequenceLikelihood.UNLIKELY,  # 'Я'
        2: SequenceLikelihood.POSITIVE,  # 'а'
        21: SequenceLikelihood.POSITIVE,  # 'б'
        7: SequenceLikelihood.POSITIVE,  # 'в'
        20: SequenceLikelihood.POSITIVE,  # 'г'
        13: SequenceLikelihood.POSITIVE,  # 'д'
        9: SequenceLikelihood.POSITIVE,  # 'е'
        26: SequenceLikelihood.POSITIVE,  # 'ж'
        18: SequenceLikelihood.POSITIVE,  # 'з'
        4: SequenceLikelihood.POSITIVE,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        12: SequenceLikelihood.POSITIVE,  # 'л'
        15: SequenceLikelihood.POSITIVE,  # 'м'
        3: SequenceLikelihood.POSITIVE,  # 'н'
        1: SequenceLikelihood.POSITIVE,  # 'о'
        16: SequenceLikelihood.POSITIVE,  # 'п'
        8: SequenceLikelihood.POSITIVE,  # 'р'
        10: SequenceLikelihood.POSITIVE,  # 'с'
        6: SequenceLikelihood.POSITIVE,  # 'т'
        14: SequenceLikelihood.POSITIVE,  # 'у'
        32: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.LIKELY,  # 'х'
        25: SequenceLikelihood.LIKELY,  # 'ц'
        22: SequenceLikelihood.POSITIVE,  # 'ч'
        29: SequenceLikelihood.LIKELY,  # 'ш'
        31: SequenceLikelihood.LIKELY,  # 'щ'
        19: SequenceLikelihood.POSITIVE,  # 'ь'
        27: SequenceLikelihood.LIKELY,  # 'ю'
        17: SequenceLikelihood.POSITIVE,  # 'я'
        30: SequenceLikelihood.UNLIKELY,  # 'є'
        5: SequenceLikelihood.POSITIVE,  # 'і'
        28: SequenceLikelihood.UNLIKELY,  # 'ї'
        66: SequenceLikelihood.NEGATIVE,  # 'Ґ'
        65: SequenceLikelihood.UNLIKELY,  # 'ґ'
    },
    9: {  # 'е'
        67: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        57: SequenceLikelihood.UNLIKELY,  # 'Є'
        46: SequenceLikelihood.UNLIKELY,  # 'І'
        63: SequenceLikelihood.NEGATIVE,  # 'Ї'
        39: SequenceLikelihood.UNLIKELY,  # 'А'
        47: SequenceLikelihood.UNLIKELY,  # 'Б'
        34: SequenceLikelihood.UNLIKELY,  # 'В'
        48: SequenceLikelihood.UNLIKELY,  # 'Г'
        40: SequenceLikelihood.UNLIKELY,  # 'Д'
        54: SequenceLikelihood.UNLIKELY,  # 'Е'
        60: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        58: SequenceLikelihood.UNLIKELY,  # 'И'
        62: SequenceLikelihood.UNLIKELY,  # 'Й'
        36: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        42: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        33: SequenceLikelihood.UNLIKELY,  # 'П'
        45: SequenceLikelihood.UNLIKELY,  # 'Р'
        35: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        38: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        55: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        52: SequenceLikelihood.UNLIKELY,  # 'Ч'
        56: SequenceLikelihood.UNLIKELY,  # 'Ш'
        59: SequenceLikelihood.UNLIKELY,  # 'Щ'
        64: SequenceLikelihood.UNLIKELY,  # 'Ь'
        61: SequenceLikelihood.UNLIKELY,  # 'Ю'
        50: SequenceLikelihood.UNLIKELY,  # 'Я'
        2: SequenceLikelihood.POSITIVE,  # 'а'
        21: SequenceLikelihood.POSITIVE,  # 'б'
        7: SequenceLikelihood.POSITIVE,  # 'в'
        20: SequenceLikelihood.POSITIVE,  # 'г'
        13: SequenceLikelihood.POSITIVE,  # 'д'
        9: SequenceLikelihood.LIKELY,  # 'е'
        26: SequenceLikelihood.POSITIVE,  # 'ж'
        18: SequenceLikelihood.POSITIVE,  # 'з'
        4: SequenceLikelihood.UNLIKELY,  # 'и'
        23: SequenceLikelihood.POSITIVE,  # 'й'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        12: SequenceLikelihood.POSITIVE,  # 'л'
        15: SequenceLikelihood.POSITIVE,  # 'м'
        3: SequenceLikelihood.POSITIVE,  # 'н'
        1: SequenceLikelihood.POSITIVE,  # 'о'
        16: SequenceLikelihood.POSITIVE,  # 'п'
        8: SequenceLikelihood.POSITIVE,  # 'р'
        10: SequenceLikelihood.POSITIVE,  # 'с'
        6: SequenceLikelihood.POSITIVE,  # 'т'
        14: SequenceLikelihood.LIKELY,  # 'у'
        32: SequenceLikelihood.POSITIVE,  # 'ф'
        24: SequenceLikelihood.POSITIVE,  # 'х'
        25: SequenceLikelihood.POSITIVE,  # 'ц'
        22: SequenceLikelihood.POSITIVE,  # 'ч'
        29: SequenceLikelihood.POSITIVE,  # 'ш'
        31: SequenceLikelihood.LIKELY,  # 'щ'
        19: SequenceLikelihood.UNLIKELY,  # 'ь'
        27: SequenceLikelihood.POSITIVE,  # 'ю'
        17: SequenceLikelihood.POSITIVE,  # 'я'
        30: SequenceLikelihood.LIKELY,  # 'є'
        5: SequenceLikelihood.UNLIKELY,  # 'і'
        28: SequenceLikelihood.POSITIVE,  # 'ї'
        66: SequenceLikelihood.NEGATIVE,  # 'Ґ'
        65: SequenceLikelihood.UNLIKELY,  # 'ґ'
    },
    26: {  # 'ж'
        67: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        57: SequenceLikelihood.UNLIKELY,  # 'Є'
        46: SequenceLikelihood.UNLIKELY,  # 'І'
        63: SequenceLikelihood.NEGATIVE,  # 'Ї'
        39: SequenceLikelihood.UNLIKELY,  # 'А'
        47: SequenceLikelihood.UNLIKELY,  # 'Б'
        34: SequenceLikelihood.UNLIKELY,  # 'В'
        48: SequenceLikelihood.UNLIKELY,  # 'Г'
        40: SequenceLikelihood.UNLIKELY,  # 'Д'
        54: SequenceLikelihood.UNLIKELY,  # 'Е'
        60: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        58: SequenceLikelihood.NEGATIVE,  # 'И'
        62: SequenceLikelihood.NEGATIVE,  # 'Й'
        36: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        42: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        33: SequenceLikelihood.UNLIKELY,  # 'П'
        45: SequenceLikelihood.UNLIKELY,  # 'Р'
        35: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        38: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        55: SequenceLikelihood.NEGATIVE,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        52: SequenceLikelihood.UNLIKELY,  # 'Ч'
        56: SequenceLikelihood.UNLIKELY,  # 'Ш'
        59: SequenceLikelihood.NEGATIVE,  # 'Щ'
        64: SequenceLikelihood.UNLIKELY,  # 'Ь'
        61: SequenceLikelihood.NEGATIVE,  # 'Ю'
        50: SequenceLikelihood.UNLIKELY,  # 'Я'
        2: SequenceLikelihood.POSITIVE,  # 'а'
        21: SequenceLikelihood.POSITIVE,  # 'б'
        7: SequenceLikelihood.UNLIKELY,  # 'в'
        20: SequenceLikelihood.LIKELY,  # 'г'
        13: SequenceLikelihood.POSITIVE,  # 'д'
        9: SequenceLikelihood.POSITIVE,  # 'е'
        26: SequenceLikelihood.LIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.POSITIVE,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        12: SequenceLikelihood.POSITIVE,  # 'л'
        15: SequenceLikelihood.LIKELY,  # 'м'
        3: SequenceLikelihood.POSITIVE,  # 'н'
        1: SequenceLikelihood.POSITIVE,  # 'о'
        16: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        6: SequenceLikelihood.UNLIKELY,  # 'т'
        14: SequenceLikelihood.POSITIVE,  # 'у'
        32: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        25: SequenceLikelihood.LIKELY,  # 'ц'
        22: SequenceLikelihood.LIKELY,  # 'ч'
        29: SequenceLikelihood.UNLIKELY,  # 'ш'
        31: SequenceLikelihood.UNLIKELY,  # 'щ'
        19: SequenceLikelihood.UNLIKELY,  # 'ь'
        27: SequenceLikelihood.UNLIKELY,  # 'ю'
        17: SequenceLikelihood.LIKELY,  # 'я'
        30: SequenceLikelihood.UNLIKELY,  # 'є'
        5: SequenceLikelihood.POSITIVE,  # 'і'
        28: SequenceLikelihood.NEGATIVE,  # 'ї'
        66: SequenceLikelihood.NEGATIVE,  # 'Ґ'
        65: SequenceLikelihood.NEGATIVE,  # 'ґ'
    },
    18: {  # 'з'
        67: SequenceLikelihood.UNLIKELY,  # 'ʼ'
        57: SequenceLikelihood.UNLIKELY,  # 'Є'
        46: SequenceLikelihood.UNLIKELY,  # 'І'
        63: SequenceLikelihood.NEGATIVE,  # 'Ї'
        39: SequenceLikelihood.UNLIKELY,  # 'А'
        47: SequenceLikelihood.UNLIKELY,  # 'Б'
        34: SequenceLikelihood.UNLIKELY,  # 'В'
        48: SequenceLikelihood.UNLIKELY,  # 'Г'
        40: SequenceLikelihood.UNLIKELY,  # 'Д'
        54: SequenceLikelihood.UNLIKELY,  # 'Е'
        60: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        58: SequenceLikelihood.UNLIKELY,  # 'И'
        62: SequenceLikelihood.NEGATIVE,  # 'Й'
        36: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        42: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        33: SequenceLikelihood.UNLIKELY,  # 'П'
        45: SequenceLikelihood.UNLIKELY,  # 'Р'
        35: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        38: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        55: SequenceLikelihood.NEGATIVE,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        52: SequenceLikelihood.UNLIKELY,  # 'Ч'
        56: SequenceLikelihood.UNLIKELY,  # 'Ш'
        59: SequenceLikelihood.NEGATIVE,  # 'Щ'
        64: SequenceLikelihood.UNLIKELY,  # 'Ь'
        61: SequenceLikelihood.NEGATIVE,  # 'Ю'
        50: SequenceLikelihood.UNLIKELY,  # 'Я'
        2: SequenceLikelihood.POSITIVE,  # 'а'
        21: SequenceLikelihood.POSITIVE,  # 'б'
        7: SequenceLikelihood.POSITIVE,  # 'в'
        20: SequenceLikelihood.POSITIVE,  # 'г'
        13: SequenceLikelihood.POSITIVE,  # 'д'
        9: SequenceLikelihood.POSITIVE,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.LIKELY,  # 'з'
        4: SequenceLikelihood.POSITIVE,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        12: SequenceLikelihood.POSITIVE,  # 'л'
        15: SequenceLikelihood.POSITIVE,  # 'м'
        3: SequenceLikelihood.POSITIVE,  # 'н'
        1: SequenceLikelihood.POSITIVE,  # 'о'
        16: SequenceLikelihood.POSITIVE,  # 'п'
        8: SequenceLikelihood.POSITIVE,  # 'р'
        10: SequenceLikelihood.LIKELY,  # 'с'
        6: SequenceLikelihood.LIKELY,  # 'т'
        14: SequenceLikelihood.POSITIVE,  # 'у'
        32: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        25: SequenceLikelihood.UNLIKELY,  # 'ц'
        22: SequenceLikelihood.LIKELY,  # 'ч'
        29: SequenceLikelihood.LIKELY,  # 'ш'
        31: SequenceLikelihood.UNLIKELY,  # 'щ'
        19: SequenceLikelihood.POSITIVE,  # 'ь'
        27: SequenceLikelihood.LIKELY,  # 'ю'
        17: SequenceLikelihood.LIKELY,  # 'я'
        30: SequenceLikelihood.UNLIKELY,  # 'є'
        5: SequenceLikelihood.POSITIVE,  # 'і'
        28: SequenceLikelihood.UNLIKELY,  # 'ї'
        66: SequenceLikelihood.NEGATIVE,  # 'Ґ'
        65: SequenceLikelihood.UNLIKELY,  # 'ґ'
    },
    4: {  # 'и'
        67: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        57: SequenceLikelihood.UNLIKELY,  # 'Є'
        46: SequenceLikelihood.UNLIKELY,  # 'І'
        63: SequenceLikelihood.UNLIKELY,  # 'Ї'
        39: SequenceLikelihood.UNLIKELY,  # 'А'
        47: SequenceLikelihood.UNLIKELY,  # 'Б'
        34: SequenceLikelihood.UNLIKELY,  # 'В'
        48: SequenceLikelihood.UNLIKELY,  # 'Г'
        40: SequenceLikelihood.UNLIKELY,  # 'Д'
        54: SequenceLikelihood.UNLIKELY,  # 'Е'
        60: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        58: SequenceLikelihood.UNLIKELY,  # 'И'
        62: SequenceLikelihood.UNLIKELY,  # 'Й'
        36: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        42: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        33: SequenceLikelihood.UNLIKELY,  # 'П'
        45: SequenceLikelihood.UNLIKELY,  # 'Р'
        35: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        38: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        55: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        52: SequenceLikelihood.UNLIKELY,  # 'Ч'
        56: SequenceLikelihood.UNLIKELY,  # 'Ш'
        59: SequenceLikelihood.UNLIKELY,  # 'Щ'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        61: SequenceLikelihood.UNLIKELY,  # 'Ю'
        50: SequenceLikelihood.UNLIKELY,  # 'Я'
        2: SequenceLikelihood.LIKELY,  # 'а'
        21: SequenceLikelihood.POSITIVE,  # 'б'
        7: SequenceLikelihood.POSITIVE,  # 'в'
        20: SequenceLikelihood.POSITIVE,  # 'г'
        13: SequenceLikelihood.POSITIVE,  # 'д'
        9: SequenceLikelihood.LIKELY,  # 'е'
        26: SequenceLikelihood.POSITIVE,  # 'ж'
        18: SequenceLikelihood.POSITIVE,  # 'з'
        4: SequenceLikelihood.LIKELY,  # 'и'
        23: SequenceLikelihood.POSITIVE,  # 'й'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        12: SequenceLikelihood.POSITIVE,  # 'л'
        15: SequenceLikelihood.POSITIVE,  # 'м'
        3: SequenceLikelihood.POSITIVE,  # 'н'
        1: SequenceLikelihood.LIKELY,  # 'о'
        16: SequenceLikelihood.POSITIVE,  # 'п'
        8: SequenceLikelihood.POSITIVE,  # 'р'
        10: SequenceLikelihood.POSITIVE,  # 'с'
        6: SequenceLikelihood.POSITIVE,  # 'т'
        14: SequenceLikelihood.UNLIKELY,  # 'у'
        32: SequenceLikelihood.POSITIVE,  # 'ф'
        24: SequenceLikelihood.POSITIVE,  # 'х'
        25: SequenceLikelihood.POSITIVE,  # 'ц'
        22: SequenceLikelihood.POSITIVE,  # 'ч'
        29: SequenceLikelihood.POSITIVE,  # 'ш'
        31: SequenceLikelihood.POSITIVE,  # 'щ'
        19: SequenceLikelihood.UNLIKELY,  # 'ь'
        27: SequenceLikelihood.LIKELY,  # 'ю'
        17: SequenceLikelihood.POSITIVE,  # 'я'
        30: SequenceLikelihood.POSITIVE,  # 'є'
        5: SequenceLikelihood.UNLIKELY,  # 'і'
        28: SequenceLikelihood.POSITIVE,  # 'ї'
        66: SequenceLikelihood.NEGATIVE,  # 'Ґ'
        65: SequenceLikelihood.UNLIKELY,  # 'ґ'
    },
    23: {  # 'й'
        67: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        57: SequenceLikelihood.NEGATIVE,  # 'Є'
        46: SequenceLikelihood.UNLIKELY,  # 'І'
        63: SequenceLikelihood.NEGATIVE,  # 'Ї'
        39: SequenceLikelihood.UNLIKELY,  # 'А'
        47: SequenceLikelihood.UNLIKELY,  # 'Б'
        34: SequenceLikelihood.UNLIKELY,  # 'В'
        48: SequenceLikelihood.UNLIKELY,  # 'Г'
        40: SequenceLikelihood.UNLIKELY,  # 'Д'
        54: SequenceLikelihood.UNLIKELY,  # 'Е'
        60: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        58: SequenceLikelihood.NEGATIVE,  # 'И'
        62: SequenceLikelihood.NEGATIVE,  # 'Й'
        36: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        42: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        33: SequenceLikelihood.UNLIKELY,  # 'П'
        45: SequenceLikelihood.UNLIKELY,  # 'Р'
        35: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        38: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        55: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        52: SequenceLikelihood.UNLIKELY,  # 'Ч'
        56: SequenceLikelihood.UNLIKELY,  # 'Ш'
        59: SequenceLikelihood.UNLIKELY,  # 'Щ'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        61: SequenceLikelihood.UNLIKELY,  # 'Ю'
        50: SequenceLikelihood.UNLIKELY,  # 'Я'
        2: SequenceLikelihood.UNLIKELY,  # 'а'
        21: SequenceLikelihood.POSITIVE,  # 'б'
        7: SequenceLikelihood.LIKELY,  # 'в'
        20: SequenceLikelihood.LIKELY,  # 'г'
        13: SequenceLikelihood.POSITIVE,  # 'д'
        9: SequenceLikelihood.UNLIKELY,  # 'е'
        26: SequenceLikelihood.LIKELY,  # 'ж'
        18: SequenceLikelihood.LIKELY,  # 'з'
        4: SequenceLikelihood.UNLIKELY,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        12: SequenceLikelihood.LIKELY,  # 'л'
        15: SequenceLikelihood.POSITIVE,  # 'м'
        3: SequenceLikelihood.POSITIVE,  # 'н'
        1: SequenceLikelihood.POSITIVE,  # 'о'
        16: SequenceLikelihood.LIKELY,  # 'п'
        8: SequenceLikelihood.LIKELY,  # 'р'
        10: SequenceLikelihood.POSITIVE,  # 'с'
        6: SequenceLikelihood.POSITIVE,  # 'т'
        14: SequenceLikelihood.UNLIKELY,  # 'у'
        32: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        25: SequenceLikelihood.LIKELY,  # 'ц'
        22: SequenceLikelihood.LIKELY,  # 'ч'
        29: SequenceLikelihood.POSITIVE,  # 'ш'
        31: SequenceLikelihood.UNLIKELY,  # 'щ'
        19: SequenceLikelihood.UNLIKELY,  # 'ь'
        27: SequenceLikelihood.UNLIKELY,  # 'ю'
        17: SequenceLikelihood.UNLIKELY,  # 'я'
        30: SequenceLikelihood.UNLIKELY,  # 'є'
        5: SequenceLikelihood.UNLIKELY,  # 'і'
        28: SequenceLikelihood.UNLIKELY,  # 'ї'
        66: SequenceLikelihood.NEGATIVE,  # 'Ґ'
        65: SequenceLikelihood.UNLIKELY,  # 'ґ'
    },
    11: {  # 'к'
        67: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        57: SequenceLikelihood.UNLIKELY,  # 'Є'
        46: SequenceLikelihood.UNLIKELY,  # 'І'
        63: SequenceLikelihood.UNLIKELY,  # 'Ї'
        39: SequenceLikelihood.UNLIKELY,  # 'А'
        47: SequenceLikelihood.UNLIKELY,  # 'Б'
        34: SequenceLikelihood.UNLIKELY,  # 'В'
        48: SequenceLikelihood.UNLIKELY,  # 'Г'
        40: SequenceLikelihood.UNLIKELY,  # 'Д'
        54: SequenceLikelihood.UNLIKELY,  # 'Е'
        60: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        58: SequenceLikelihood.UNLIKELY,  # 'И'
        62: SequenceLikelihood.UNLIKELY,  # 'Й'
        36: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        42: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        33: SequenceLikelihood.UNLIKELY,  # 'П'
        45: SequenceLikelihood.UNLIKELY,  # 'Р'
        35: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        38: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        55: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        52: SequenceLikelihood.UNLIKELY,  # 'Ч'
        56: SequenceLikelihood.UNLIKELY,  # 'Ш'
        59: SequenceLikelihood.UNLIKELY,  # 'Щ'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        61: SequenceLikelihood.UNLIKELY,  # 'Ю'
        50: SequenceLikelihood.UNLIKELY,  # 'Я'
        2: SequenceLikelihood.POSITIVE,  # 'а'
        21: SequenceLikelihood.LIKELY,  # 'б'
        7: SequenceLikelihood.POSITIVE,  # 'в'
        20: SequenceLikelihood.LIKELY,  # 'г'
        13: SequenceLikelihood.LIKELY,  # 'д'
        9: SequenceLikelihood.POSITIVE,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.LIKELY,  # 'з'
        4: SequenceLikelihood.POSITIVE,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.LIKELY,  # 'к'
        12: SequenceLikelihood.POSITIVE,  # 'л'
        15: SequenceLikelihood.LIKELY,  # 'м'
        3: SequenceLikelihood.POSITIVE,  # 'н'
        1: SequenceLikelihood.POSITIVE,  # 'о'
        16: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.POSITIVE,  # 'р'
        10: SequenceLikelihood.POSITIVE,  # 'с'
        6: SequenceLikelihood.POSITIVE,  # 'т'
        14: SequenceLikelihood.POSITIVE,  # 'у'
        32: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        25: SequenceLikelihood.POSITIVE,  # 'ц'
        22: SequenceLikelihood.UNLIKELY,  # 'ч'
        29: SequenceLikelihood.LIKELY,  # 'ш'
        31: SequenceLikelihood.POSITIVE,  # 'щ'
        19: SequenceLikelihood.UNLIKELY,  # 'ь'
        27: SequenceLikelihood.UNLIKELY,  # 'ю'
        17: SequenceLikelihood.UNLIKELY,  # 'я'
        30: SequenceLikelihood.UNLIKELY,  # 'є'
        5: SequenceLikelihood.POSITIVE,  # 'і'
        28: SequenceLikelihood.UNLIKELY,  # 'ї'
        66: SequenceLikelihood.UNLIKELY,  # 'Ґ'
        65: SequenceLikelihood.UNLIKELY,  # 'ґ'
    },
    12: {  # 'л'
        67: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        57: SequenceLikelihood.UNLIKELY,  # 'Є'
        46: SequenceLikelihood.UNLIKELY,  # 'І'
        63: SequenceLikelihood.NEGATIVE,  # 'Ї'
        39: SequenceLikelihood.UNLIKELY,  # 'А'
        47: SequenceLikelihood.UNLIKELY,  # 'Б'
        34: SequenceLikelihood.UNLIKELY,  # 'В'
        48: SequenceLikelihood.UNLIKELY,  # 'Г'
        40: SequenceLikelihood.UNLIKELY,  # 'Д'
        54: SequenceLikelihood.UNLIKELY,  # 'Е'
        60: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        58: SequenceLikelihood.UNLIKELY,  # 'И'
        62: SequenceLikelihood.NEGATIVE,  # 'Й'
        36: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        42: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        33: SequenceLikelihood.UNLIKELY,  # 'П'
        45: SequenceLikelihood.UNLIKELY,  # 'Р'
        35: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        38: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        55: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        52: SequenceLikelihood.NEGATIVE,  # 'Ч'
        56: SequenceLikelihood.UNLIKELY,  # 'Ш'
        59: SequenceLikelihood.UNLIKELY,  # 'Щ'
        64: SequenceLikelihood.UNLIKELY,  # 'Ь'
        61: SequenceLikelihood.UNLIKELY,  # 'Ю'
        50: SequenceLikelihood.UNLIKELY,  # 'Я'
        2: SequenceLikelihood.POSITIVE,  # 'а'
        21: SequenceLikelihood.UNLIKELY,  # 'б'
        7: SequenceLikelihood.UNLIKELY,  # 'в'
        20: SequenceLikelihood.LIKELY,  # 'г'
        13: SequenceLikelihood.LIKELY,  # 'д'
        9: SequenceLikelihood.POSITIVE,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.POSITIVE,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        12: SequenceLikelihood.POSITIVE,  # 'л'
        15: SequenceLikelihood.UNLIKELY,  # 'м'
        3: SequenceLikelihood.LIKELY,  # 'н'
        1: SequenceLikelihood.POSITIVE,  # 'о'
        16: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.LIKELY,  # 'р'
        10: SequenceLikelihood.LIKELY,  # 'с'
        6: SequenceLikelihood.LIKELY,  # 'т'
        14: SequenceLikelihood.POSITIVE,  # 'у'
        32: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        25: SequenceLikelihood.UNLIKELY,  # 'ц'
        22: SequenceLikelihood.UNLIKELY,  # 'ч'
        29: SequenceLikelihood.UNLIKELY,  # 'ш'
        31: SequenceLikelihood.UNLIKELY,  # 'щ'
        19: SequenceLikelihood.POSITIVE,  # 'ь'
        27: SequenceLikelihood.POSITIVE,  # 'ю'
        17: SequenceLikelihood.POSITIVE,  # 'я'
        30: SequenceLikelihood.UNLIKELY,  # 'є'
        5: SequenceLikelihood.POSITIVE,  # 'і'
        28: SequenceLikelihood.UNLIKELY,  # 'ї'
        66: SequenceLikelihood.NEGATIVE,  # 'Ґ'
        65: SequenceLikelihood.UNLIKELY,  # 'ґ'
    },
    15: {  # 'м'
        67: SequenceLikelihood.UNLIKELY,  # 'ʼ'
        57: SequenceLikelihood.UNLIKELY,  # 'Є'
        46: SequenceLikelihood.UNLIKELY,  # 'І'
        63: SequenceLikelihood.NEGATIVE,  # 'Ї'
        39: SequenceLikelihood.UNLIKELY,  # 'А'
        47: SequenceLikelihood.UNLIKELY,  # 'Б'
        34: SequenceLikelihood.UNLIKELY,  # 'В'
        48: SequenceLikelihood.UNLIKELY,  # 'Г'
        40: SequenceLikelihood.UNLIKELY,  # 'Д'
        54: SequenceLikelihood.UNLIKELY,  # 'Е'
        60: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        58: SequenceLikelihood.UNLIKELY,  # 'И'
        62: SequenceLikelihood.UNLIKELY,  # 'Й'
        36: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        42: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        33: SequenceLikelihood.UNLIKELY,  # 'П'
        45: SequenceLikelihood.UNLIKELY,  # 'Р'
        35: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        38: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        55: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        52: SequenceLikelihood.UNLIKELY,  # 'Ч'
        56: SequenceLikelihood.UNLIKELY,  # 'Ш'
        59: SequenceLikelihood.UNLIKELY,  # 'Щ'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        61: SequenceLikelihood.UNLIKELY,  # 'Ю'
        50: SequenceLikelihood.UNLIKELY,  # 'Я'
        2: SequenceLikelihood.POSITIVE,  # 'а'
        21: SequenceLikelihood.LIKELY,  # 'б'
        7: SequenceLikelihood.LIKELY,  # 'в'
        20: SequenceLikelihood.LIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        9: SequenceLikelihood.POSITIVE,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.POSITIVE,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        12: SequenceLikelihood.POSITIVE,  # 'л'
        15: SequenceLikelihood.LIKELY,  # 'м'
        3: SequenceLikelihood.POSITIVE,  # 'н'
        1: SequenceLikelihood.POSITIVE,  # 'о'
        16: SequenceLikelihood.POSITIVE,  # 'п'
        8: SequenceLikelihood.LIKELY,  # 'р'
        10: SequenceLikelihood.POSITIVE,  # 'с'
        6: SequenceLikelihood.LIKELY,  # 'т'
        14: SequenceLikelihood.POSITIVE,  # 'у'
        32: SequenceLikelihood.LIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        25: SequenceLikelihood.LIKELY,  # 'ц'
        22: SequenceLikelihood.LIKELY,  # 'ч'
        29: SequenceLikelihood.UNLIKELY,  # 'ш'
        31: SequenceLikelihood.UNLIKELY,  # 'щ'
        19: SequenceLikelihood.UNLIKELY,  # 'ь'
        27: SequenceLikelihood.UNLIKELY,  # 'ю'
        17: SequenceLikelihood.UNLIKELY,  # 'я'
        30: SequenceLikelihood.UNLIKELY,  # 'є'
        5: SequenceLikelihood.POSITIVE,  # 'і'
        28: SequenceLikelihood.UNLIKELY,  # 'ї'
        66: SequenceLikelihood.NEGATIVE,  # 'Ґ'
        65: SequenceLikelihood.UNLIKELY,  # 'ґ'
    },
    3: {  # 'н'
        67: SequenceLikelihood.UNLIKELY,  # 'ʼ'
        57: SequenceLikelihood.UNLIKELY,  # 'Є'
        46: SequenceLikelihood.UNLIKELY,  # 'І'
        63: SequenceLikelihood.NEGATIVE,  # 'Ї'
        39: SequenceLikelihood.UNLIKELY,  # 'А'
        47: SequenceLikelihood.UNLIKELY,  # 'Б'
        34: SequenceLikelihood.UNLIKELY,  # 'В'
        48: SequenceLikelihood.UNLIKELY,  # 'Г'
        40: SequenceLikelihood.UNLIKELY,  # 'Д'
        54: SequenceLikelihood.UNLIKELY,  # 'Е'
        60: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        58: SequenceLikelihood.UNLIKELY,  # 'И'
        62: SequenceLikelihood.NEGATIVE,  # 'Й'
        36: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        42: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        33: SequenceLikelihood.UNLIKELY,  # 'П'
        45: SequenceLikelihood.UNLIKELY,  # 'Р'
        35: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        38: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        55: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        52: SequenceLikelihood.UNLIKELY,  # 'Ч'
        56: SequenceLikelihood.UNLIKELY,  # 'Ш'
        59: SequenceLikelihood.NEGATIVE,  # 'Щ'
        64: SequenceLikelihood.UNLIKELY,  # 'Ь'
        61: SequenceLikelihood.UNLIKELY,  # 'Ю'
        50: SequenceLikelihood.UNLIKELY,  # 'Я'
        2: SequenceLikelihood.POSITIVE,  # 'а'
        21: SequenceLikelihood.LIKELY,  # 'б'
        7: SequenceLikelihood.LIKELY,  # 'в'
        20: SequenceLikelihood.POSITIVE,  # 'г'
        13: SequenceLikelihood.POSITIVE,  # 'д'
        9: SequenceLikelihood.POSITIVE,  # 'е'
        26: SequenceLikelihood.LIKELY,  # 'ж'
        18: SequenceLikelihood.LIKELY,  # 'з'
        4: SequenceLikelihood.POSITIVE,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        12: SequenceLikelihood.LIKELY,  # 'л'
        15: SequenceLikelihood.UNLIKELY,  # 'м'
        3: SequenceLikelihood.POSITIVE,  # 'н'
        1: SequenceLikelihood.POSITIVE,  # 'о'
        16: SequenceLikelihood.LIKELY,  # 'п'
        8: SequenceLikelihood.LIKELY,  # 'р'
        10: SequenceLikelihood.POSITIVE,  # 'с'
        6: SequenceLikelihood.POSITIVE,  # 'т'
        14: SequenceLikelihood.POSITIVE,  # 'у'
        32: SequenceLikelihood.POSITIVE,  # 'ф'
        24: SequenceLikelihood.LIKELY,  # 'х'
        25: SequenceLikelihood.POSITIVE,  # 'ц'
        22: SequenceLikelihood.POSITIVE,  # 'ч'
        29: SequenceLikelihood.POSITIVE,  # 'ш'
        31: SequenceLikelihood.LIKELY,  # 'щ'
        19: SequenceLikelihood.POSITIVE,  # 'ь'
        27: SequenceLikelihood.POSITIVE,  # 'ю'
        17: SequenceLikelihood.POSITIVE,  # 'я'
        30: SequenceLikelihood.LIKELY,  # 'є'
        5: SequenceLikelihood.POSITIVE,  # 'і'
        28: SequenceLikelihood.UNLIKELY,  # 'ї'
        66: SequenceLikelihood.NEGATIVE,  # 'Ґ'
        65: SequenceLikelihood.UNLIKELY,  # 'ґ'
    },
    1: {  # 'о'
        67: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        57: SequenceLikelihood.UNLIKELY,  # 'Є'
        46: SequenceLikelihood.UNLIKELY,  # 'І'
        63: SequenceLikelihood.UNLIKELY,  # 'Ї'
        39: SequenceLikelihood.UNLIKELY,  # 'А'
        47: SequenceLikelihood.UNLIKELY,  # 'Б'
        34: SequenceLikelihood.UNLIKELY,  # 'В'
        48: SequenceLikelihood.UNLIKELY,  # 'Г'
        40: SequenceLikelihood.UNLIKELY,  # 'Д'
        54: SequenceLikelihood.UNLIKELY,  # 'Е'
        60: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        58: SequenceLikelihood.UNLIKELY,  # 'И'
        62: SequenceLikelihood.NEGATIVE,  # 'Й'
        36: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        42: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        33: SequenceLikelihood.UNLIKELY,  # 'П'
        45: SequenceLikelihood.UNLIKELY,  # 'Р'
        35: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        38: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        55: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        52: SequenceLikelihood.UNLIKELY,  # 'Ч'
        56: SequenceLikelihood.UNLIKELY,  # 'Ш'
        59: SequenceLikelihood.UNLIKELY,  # 'Щ'
        64: SequenceLikelihood.UNLIKELY,  # 'Ь'
        61: SequenceLikelihood.UNLIKELY,  # 'Ю'
        50: SequenceLikelihood.UNLIKELY,  # 'Я'
        2: SequenceLikelihood.LIKELY,  # 'а'
        21: SequenceLikelihood.POSITIVE,  # 'б'
        7: SequenceLikelihood.POSITIVE,  # 'в'
        20: SequenceLikelihood.POSITIVE,  # 'г'
        13: SequenceLikelihood.POSITIVE,  # 'д'
        9: SequenceLikelihood.POSITIVE,  # 'е'
        26: SequenceLikelihood.POSITIVE,  # 'ж'
        18: SequenceLikelihood.POSITIVE,  # 'з'
        4: SequenceLikelihood.LIKELY,  # 'и'
        23: SequenceLikelihood.POSITIVE,  # 'й'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        12: SequenceLikelihood.POSITIVE,  # 'л'
        15: SequenceLikelihood.POSITIVE,  # 'м'
        3: SequenceLikelihood.POSITIVE,  # 'н'
        1: SequenceLikelihood.POSITIVE,  # 'о'
        16: SequenceLikelihood.POSITIVE,  # 'п'
        8: SequenceLikelihood.POSITIVE,  # 'р'
        10: SequenceLikelihood.POSITIVE,  # 'с'
        6: SequenceLikelihood.POSITIVE,  # 'т'
        14: SequenceLikelihood.LIKELY,  # 'у'
        32: SequenceLikelihood.POSITIVE,  # 'ф'
        24: SequenceLikelihood.POSITIVE,  # 'х'
        25: SequenceLikelihood.POSITIVE,  # 'ц'
        22: SequenceLikelihood.POSITIVE,  # 'ч'
        29: SequenceLikelihood.POSITIVE,  # 'ш'
        31: SequenceLikelihood.POSITIVE,  # 'щ'
        19: SequenceLikelihood.UNLIKELY,  # 'ь'
        27: SequenceLikelihood.POSITIVE,  # 'ю'
        17: SequenceLikelihood.POSITIVE,  # 'я'
        30: SequenceLikelihood.POSITIVE,  # 'є'
        5: SequenceLikelihood.LIKELY,  # 'і'
        28: SequenceLikelihood.POSITIVE,  # 'ї'
        66: SequenceLikelihood.NEGATIVE,  # 'Ґ'
        65: SequenceLikelihood.UNLIKELY,  # 'ґ'
    },
    16: {  # 'п'
        67: SequenceLikelihood.UNLIKELY,  # 'ʼ'
        57: SequenceLikelihood.NEGATIVE,  # 'Є'
        46: SequenceLikelihood.UNLIKELY,  # 'І'
        63: SequenceLikelihood.NEGATIVE,  # 'Ї'
        39: SequenceLikelihood.UNLIKELY,  # 'А'
        47: SequenceLikelihood.UNLIKELY,  # 'Б'
        34: SequenceLikelihood.UNLIKELY,  # 'В'
        48: SequenceLikelihood.NEGATIVE,  # 'Г'
        40: SequenceLikelihood.UNLIKELY,  # 'Д'
        54: SequenceLikelihood.UNLIKELY,  # 'Е'
        60: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        58: SequenceLikelihood.UNLIKELY,  # 'И'
        62: SequenceLikelihood.NEGATIVE,  # 'Й'
        36: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        42: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        33: SequenceLikelihood.UNLIKELY,  # 'П'
        45: SequenceLikelihood.UNLIKELY,  # 'Р'
        35: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        38: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        55: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        52: SequenceLikelihood.NEGATIVE,  # 'Ч'
        56: SequenceLikelihood.UNLIKELY,  # 'Ш'
        59: SequenceLikelihood.NEGATIVE,  # 'Щ'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        61: SequenceLikelihood.NEGATIVE,  # 'Ю'
        50: SequenceLikelihood.NEGATIVE,  # 'Я'
        2: SequenceLikelihood.POSITIVE,  # 'а'
        21: SequenceLikelihood.UNLIKELY,  # 'б'
        7: SequenceLikelihood.UNLIKELY,  # 'в'
        20: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        9: SequenceLikelihood.POSITIVE,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.POSITIVE,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.LIKELY,  # 'к'
        12: SequenceLikelihood.POSITIVE,  # 'л'
        15: SequenceLikelihood.UNLIKELY,  # 'м'
        3: SequenceLikelihood.POSITIVE,  # 'н'
        1: SequenceLikelihood.POSITIVE,  # 'о'
        16: SequenceLikelihood.LIKELY,  # 'п'
        8: SequenceLikelihood.POSITIVE,  # 'р'
        10: SequenceLikelihood.LIKELY,  # 'с'
        6: SequenceLikelihood.POSITIVE,  # 'т'
        14: SequenceLikelihood.POSITIVE,  # 'у'
        32: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        25: SequenceLikelihood.LIKELY,  # 'ц'
        22: SequenceLikelihood.LIKELY,  # 'ч'
        29: SequenceLikelihood.LIKELY,  # 'ш'
        31: SequenceLikelihood.UNLIKELY,  # 'щ'
        19: SequenceLikelihood.UNLIKELY,  # 'ь'
        27: SequenceLikelihood.UNLIKELY,  # 'ю'
        17: SequenceLikelihood.UNLIKELY,  # 'я'
        30: SequenceLikelihood.UNLIKELY,  # 'є'
        5: SequenceLikelihood.POSITIVE,  # 'і'
        28: SequenceLikelihood.UNLIKELY,  # 'ї'
        66: SequenceLikelihood.NEGATIVE,  # 'Ґ'
        65: SequenceLikelihood.UNLIKELY,  # 'ґ'
    },
    8: {  # 'р'
        67: SequenceLikelihood.UNLIKELY,  # 'ʼ'
        57: SequenceLikelihood.UNLIKELY,  # 'Є'
        46: SequenceLikelihood.UNLIKELY,  # 'І'
        63: SequenceLikelihood.NEGATIVE,  # 'Ї'
        39: SequenceLikelihood.UNLIKELY,  # 'А'
        47: SequenceLikelihood.UNLIKELY,  # 'Б'
        34: SequenceLikelihood.UNLIKELY,  # 'В'
        48: SequenceLikelihood.UNLIKELY,  # 'Г'
        40: SequenceLikelihood.UNLIKELY,  # 'Д'
        54: SequenceLikelihood.UNLIKELY,  # 'Е'
        60: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        58: SequenceLikelihood.UNLIKELY,  # 'И'
        62: SequenceLikelihood.NEGATIVE,  # 'Й'
        36: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        42: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        33: SequenceLikelihood.UNLIKELY,  # 'П'
        45: SequenceLikelihood.UNLIKELY,  # 'Р'
        35: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        38: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        55: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        52: SequenceLikelihood.UNLIKELY,  # 'Ч'
        56: SequenceLikelihood.UNLIKELY,  # 'Ш'
        59: SequenceLikelihood.NEGATIVE,  # 'Щ'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        61: SequenceLikelihood.UNLIKELY,  # 'Ю'
        50: SequenceLikelihood.UNLIKELY,  # 'Я'
        2: SequenceLikelihood.POSITIVE,  # 'а'
        21: SequenceLikelihood.POSITIVE,  # 'б'
        7: SequenceLikelihood.POSITIVE,  # 'в'
        20: SequenceLikelihood.POSITIVE,  # 'г'
        13: SequenceLikelihood.POSITIVE,  # 'д'
        9: SequenceLikelihood.POSITIVE,  # 'е'
        26: SequenceLikelihood.POSITIVE,  # 'ж'
        18: SequenceLikelihood.LIKELY,  # 'з'
        4: SequenceLikelihood.POSITIVE,  # 'и'
        23: SequenceLikelihood.LIKELY,  # 'й'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        12: SequenceLikelihood.LIKELY,  # 'л'
        15: SequenceLikelihood.POSITIVE,  # 'м'
        3: SequenceLikelihood.POSITIVE,  # 'н'
        1: SequenceLikelihood.POSITIVE,  # 'о'
        16: SequenceLikelihood.POSITIVE,  # 'п'
        8: SequenceLikelihood.LIKELY,  # 'р'
        10: SequenceLikelihood.POSITIVE,  # 'с'
        6: SequenceLikelihood.POSITIVE,  # 'т'
        14: SequenceLikelihood.POSITIVE,  # 'у'
        32: SequenceLikelihood.LIKELY,  # 'ф'
        24: SequenceLikelihood.POSITIVE,  # 'х'
        25: SequenceLikelihood.POSITIVE,  # 'ц'
        22: SequenceLikelihood.POSITIVE,  # 'ч'
        29: SequenceLikelihood.POSITIVE,  # 'ш'
        31: SequenceLikelihood.LIKELY,  # 'щ'
        19: SequenceLikelihood.LIKELY,  # 'ь'
        27: SequenceLikelihood.POSITIVE,  # 'ю'
        17: SequenceLikelihood.POSITIVE,  # 'я'
        30: SequenceLikelihood.UNLIKELY,  # 'є'
        5: SequenceLikelihood.POSITIVE,  # 'і'
        28: SequenceLikelihood.UNLIKELY,  # 'ї'
        66: SequenceLikelihood.UNLIKELY,  # 'Ґ'
        65: SequenceLikelihood.UNLIKELY,  # 'ґ'
    },
    10: {  # 'с'
        67: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        57: SequenceLikelihood.UNLIKELY,  # 'Є'
        46: SequenceLikelihood.UNLIKELY,  # 'І'
        63: SequenceLikelihood.NEGATIVE,  # 'Ї'
        39: SequenceLikelihood.UNLIKELY,  # 'А'
        47: SequenceLikelihood.UNLIKELY,  # 'Б'
        34: SequenceLikelihood.UNLIKELY,  # 'В'
        48: SequenceLikelihood.UNLIKELY,  # 'Г'
        40: SequenceLikelihood.UNLIKELY,  # 'Д'
        54: SequenceLikelihood.UNLIKELY,  # 'Е'
        60: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        58: SequenceLikelihood.UNLIKELY,  # 'И'
        62: SequenceLikelihood.UNLIKELY,  # 'Й'
        36: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        42: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        33: SequenceLikelihood.UNLIKELY,  # 'П'
        45: SequenceLikelihood.UNLIKELY,  # 'Р'
        35: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        38: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        55: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        52: SequenceLikelihood.UNLIKELY,  # 'Ч'
        56: SequenceLikelihood.UNLIKELY,  # 'Ш'
        59: SequenceLikelihood.NEGATIVE,  # 'Щ'
        64: SequenceLikelihood.UNLIKELY,  # 'Ь'
        61: SequenceLikelihood.UNLIKELY,  # 'Ю'
        50: SequenceLikelihood.UNLIKELY,  # 'Я'
        2: SequenceLikelihood.POSITIVE,  # 'а'
        21: SequenceLikelihood.LIKELY,  # 'б'
        7: SequenceLikelihood.POSITIVE,  # 'в'
        20: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        9: SequenceLikelihood.POSITIVE,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.POSITIVE,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        12: SequenceLikelihood.POSITIVE,  # 'л'
        15: SequenceLikelihood.POSITIVE,  # 'м'
        3: SequenceLikelihood.POSITIVE,  # 'н'
        1: SequenceLikelihood.POSITIVE,  # 'о'
        16: SequenceLikelihood.POSITIVE,  # 'п'
        8: SequenceLikelihood.LIKELY,  # 'р'
        10: SequenceLikelihood.LIKELY,  # 'с'
        6: SequenceLikelihood.POSITIVE,  # 'т'
        14: SequenceLikelihood.POSITIVE,  # 'у'
        32: SequenceLikelihood.POSITIVE,  # 'ф'
        24: SequenceLikelihood.POSITIVE,  # 'х'
        25: SequenceLikelihood.POSITIVE,  # 'ц'
        22: SequenceLikelihood.UNLIKELY,  # 'ч'
        29: SequenceLikelihood.LIKELY,  # 'ш'
        31: SequenceLikelihood.UNLIKELY,  # 'щ'
        19: SequenceLikelihood.POSITIVE,  # 'ь'
        27: SequenceLikelihood.LIKELY,  # 'ю'
        17: SequenceLikelihood.POSITIVE,  # 'я'
        30: SequenceLikelihood.UNLIKELY,  # 'є'
        5: SequenceLikelihood.POSITIVE,  # 'і'
        28: SequenceLikelihood.UNLIKELY,  # 'ї'
        66: SequenceLikelihood.NEGATIVE,  # 'Ґ'
        65: SequenceLikelihood.UNLIKELY,  # 'ґ'
    },
    6: {  # 'т'
        67: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        57: SequenceLikelihood.UNLIKELY,  # 'Є'
        46: SequenceLikelihood.UNLIKELY,  # 'І'
        63: SequenceLikelihood.NEGATIVE,  # 'Ї'
        39: SequenceLikelihood.UNLIKELY,  # 'А'
        47: SequenceLikelihood.UNLIKELY,  # 'Б'
        34: SequenceLikelihood.UNLIKELY,  # 'В'
        48: SequenceLikelihood.UNLIKELY,  # 'Г'
        40: SequenceLikelihood.UNLIKELY,  # 'Д'
        54: SequenceLikelihood.UNLIKELY,  # 'Е'
        60: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        58: SequenceLikelihood.UNLIKELY,  # 'И'
        62: SequenceLikelihood.NEGATIVE,  # 'Й'
        36: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        42: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        33: SequenceLikelihood.UNLIKELY,  # 'П'
        45: SequenceLikelihood.UNLIKELY,  # 'Р'
        35: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        38: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        55: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        52: SequenceLikelihood.UNLIKELY,  # 'Ч'
        56: SequenceLikelihood.UNLIKELY,  # 'Ш'
        59: SequenceLikelihood.UNLIKELY,  # 'Щ'
        64: SequenceLikelihood.UNLIKELY,  # 'Ь'
        61: SequenceLikelihood.UNLIKELY,  # 'Ю'
        50: SequenceLikelihood.UNLIKELY,  # 'Я'
        2: SequenceLikelihood.POSITIVE,  # 'а'
        21: SequenceLikelihood.LIKELY,  # 'б'
        7: SequenceLikelihood.POSITIVE,  # 'в'
        20: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        9: SequenceLikelihood.POSITIVE,  # 'е'
        26: SequenceLikelihood.LIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.POSITIVE,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        12: SequenceLikelihood.POSITIVE,  # 'л'
        15: SequenceLikelihood.LIKELY,  # 'м'
        3: SequenceLikelihood.POSITIVE,  # 'н'
        1: SequenceLikelihood.POSITIVE,  # 'о'
        16: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.POSITIVE,  # 'р'
        10: SequenceLikelihood.POSITIVE,  # 'с'
        6: SequenceLikelihood.POSITIVE,  # 'т'
        14: SequenceLikelihood.POSITIVE,  # 'у'
        32: SequenceLikelihood.LIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        25: SequenceLikelihood.LIKELY,  # 'ц'
        22: SequenceLikelihood.LIKELY,  # 'ч'
        29: SequenceLikelihood.UNLIKELY,  # 'ш'
        31: SequenceLikelihood.UNLIKELY,  # 'щ'
        19: SequenceLikelihood.POSITIVE,  # 'ь'
        27: SequenceLikelihood.POSITIVE,  # 'ю'
        17: SequenceLikelihood.POSITIVE,  # 'я'
        30: SequenceLikelihood.LIKELY,  # 'є'
        5: SequenceLikelihood.POSITIVE,  # 'і'
        28: SequenceLikelihood.UNLIKELY,  # 'ї'
        66: SequenceLikelihood.NEGATIVE,  # 'Ґ'
        65: SequenceLikelihood.UNLIKELY,  # 'ґ'
    },
    14: {  # 'у'
        67: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        57: SequenceLikelihood.UNLIKELY,  # 'Є'
        46: SequenceLikelihood.UNLIKELY,  # 'І'
        63: SequenceLikelihood.NEGATIVE,  # 'Ї'
        39: SequenceLikelihood.UNLIKELY,  # 'А'
        47: SequenceLikelihood.UNLIKELY,  # 'Б'
        34: SequenceLikelihood.UNLIKELY,  # 'В'
        48: SequenceLikelihood.UNLIKELY,  # 'Г'
        40: SequenceLikelihood.UNLIKELY,  # 'Д'
        54: SequenceLikelihood.UNLIKELY,  # 'Е'
        60: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        58: SequenceLikelihood.UNLIKELY,  # 'И'
        62: SequenceLikelihood.UNLIKELY,  # 'Й'
        36: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        42: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        33: SequenceLikelihood.UNLIKELY,  # 'П'
        45: SequenceLikelihood.UNLIKELY,  # 'Р'
        35: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        38: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        55: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        52: SequenceLikelihood.UNLIKELY,  # 'Ч'
        56: SequenceLikelihood.UNLIKELY,  # 'Ш'
        59: SequenceLikelihood.UNLIKELY,  # 'Щ'
        64: SequenceLikelihood.UNLIKELY,  # 'Ь'
        61: SequenceLikelihood.NEGATIVE,  # 'Ю'
        50: SequenceLikelihood.UNLIKELY,  # 'Я'
        2: SequenceLikelihood.POSITIVE,  # 'а'
        21: SequenceLikelihood.POSITIVE,  # 'б'
        7: SequenceLikelihood.POSITIVE,  # 'в'
        20: SequenceLikelihood.POSITIVE,  # 'г'
        13: SequenceLikelihood.POSITIVE,  # 'д'
        9: SequenceLikelihood.LIKELY,  # 'е'
        26: SequenceLikelihood.POSITIVE,  # 'ж'
        18: SequenceLikelihood.POSITIVE,  # 'з'
        4: SequenceLikelihood.UNLIKELY,  # 'и'
        23: SequenceLikelihood.LIKELY,  # 'й'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        12: SequenceLikelihood.POSITIVE,  # 'л'
        15: SequenceLikelihood.POSITIVE,  # 'м'
        3: SequenceLikelihood.POSITIVE,  # 'н'
        1: SequenceLikelihood.UNLIKELY,  # 'о'
        16: SequenceLikelihood.POSITIVE,  # 'п'
        8: SequenceLikelihood.POSITIVE,  # 'р'
        10: SequenceLikelihood.POSITIVE,  # 'с'
        6: SequenceLikelihood.POSITIVE,  # 'т'
        14: SequenceLikelihood.UNLIKELY,  # 'у'
        32: SequenceLikelihood.LIKELY,  # 'ф'
        24: SequenceLikelihood.POSITIVE,  # 'х'
        25: SequenceLikelihood.LIKELY,  # 'ц'
        22: SequenceLikelihood.POSITIVE,  # 'ч'
        29: SequenceLikelihood.POSITIVE,  # 'ш'
        31: SequenceLikelihood.LIKELY,  # 'щ'
        19: SequenceLikelihood.UNLIKELY,  # 'ь'
        27: SequenceLikelihood.POSITIVE,  # 'ю'
        17: SequenceLikelihood.LIKELY,  # 'я'
        30: SequenceLikelihood.POSITIVE,  # 'є'
        5: SequenceLikelihood.UNLIKELY,  # 'і'
        28: SequenceLikelihood.LIKELY,  # 'ї'
        66: SequenceLikelihood.NEGATIVE,  # 'Ґ'
        65: SequenceLikelihood.UNLIKELY,  # 'ґ'
    },
    32: {  # 'ф'
        67: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        57: SequenceLikelihood.NEGATIVE,  # 'Є'
        46: SequenceLikelihood.UNLIKELY,  # 'І'
        63: SequenceLikelihood.NEGATIVE,  # 'Ї'
        39: SequenceLikelihood.UNLIKELY,  # 'А'
        47: SequenceLikelihood.NEGATIVE,  # 'Б'
        34: SequenceLikelihood.UNLIKELY,  # 'В'
        48: SequenceLikelihood.UNLIKELY,  # 'Г'
        40: SequenceLikelihood.NEGATIVE,  # 'Д'
        54: SequenceLikelihood.UNLIKELY,  # 'Е'
        60: SequenceLikelihood.NEGATIVE,  # 'Ж'
        44: SequenceLikelihood.NEGATIVE,  # 'З'
        58: SequenceLikelihood.NEGATIVE,  # 'И'
        62: SequenceLikelihood.NEGATIVE,  # 'Й'
        36: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.NEGATIVE,  # 'Л'
        42: SequenceLikelihood.NEGATIVE,  # 'М'
        37: SequenceLikelihood.NEGATIVE,  # 'Н'
        41: SequenceLikelihood.NEGATIVE,  # 'О'
        33: SequenceLikelihood.UNLIKELY,  # 'П'
        45: SequenceLikelihood.UNLIKELY,  # 'Р'
        35: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.NEGATIVE,  # 'Т'
        38: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        55: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.NEGATIVE,  # 'Ц'
        52: SequenceLikelihood.NEGATIVE,  # 'Ч'
        56: SequenceLikelihood.NEGATIVE,  # 'Ш'
        59: SequenceLikelihood.NEGATIVE,  # 'Щ'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        61: SequenceLikelihood.NEGATIVE,  # 'Ю'
        50: SequenceLikelihood.NEGATIVE,  # 'Я'
        2: SequenceLikelihood.POSITIVE,  # 'а'
        21: SequenceLikelihood.UNLIKELY,  # 'б'
        7: SequenceLikelihood.UNLIKELY,  # 'в'
        20: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        9: SequenceLikelihood.POSITIVE,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.LIKELY,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        12: SequenceLikelihood.LIKELY,  # 'л'
        15: SequenceLikelihood.UNLIKELY,  # 'м'
        3: SequenceLikelihood.UNLIKELY,  # 'н'
        1: SequenceLikelihood.POSITIVE,  # 'о'
        16: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.POSITIVE,  # 'р'
        10: SequenceLikelihood.LIKELY,  # 'с'
        6: SequenceLikelihood.LIKELY,  # 'т'
        14: SequenceLikelihood.POSITIVE,  # 'у'
        32: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        25: SequenceLikelihood.UNLIKELY,  # 'ц'
        22: SequenceLikelihood.UNLIKELY,  # 'ч'
        29: SequenceLikelihood.UNLIKELY,  # 'ш'
        31: SequenceLikelihood.UNLIKELY,  # 'щ'
        19: SequenceLikelihood.UNLIKELY,  # 'ь'
        27: SequenceLikelihood.UNLIKELY,  # 'ю'
        17: SequenceLikelihood.UNLIKELY,  # 'я'
        30: SequenceLikelihood.UNLIKELY,  # 'є'
        5: SequenceLikelihood.POSITIVE,  # 'і'
        28: SequenceLikelihood.UNLIKELY,  # 'ї'
        66: SequenceLikelihood.NEGATIVE,  # 'Ґ'
        65: SequenceLikelihood.UNLIKELY,  # 'ґ'
    },
    24: {  # 'х'
        67: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        57: SequenceLikelihood.UNLIKELY,  # 'Є'
        46: SequenceLikelihood.UNLIKELY,  # 'І'
        63: SequenceLikelihood.NEGATIVE,  # 'Ї'
        39: SequenceLikelihood.UNLIKELY,  # 'А'
        47: SequenceLikelihood.UNLIKELY,  # 'Б'
        34: SequenceLikelihood.UNLIKELY,  # 'В'
        48: SequenceLikelihood.UNLIKELY,  # 'Г'
        40: SequenceLikelihood.UNLIKELY,  # 'Д'
        54: SequenceLikelihood.UNLIKELY,  # 'Е'
        60: SequenceLikelihood.NEGATIVE,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        58: SequenceLikelihood.UNLIKELY,  # 'И'
        62: SequenceLikelihood.NEGATIVE,  # 'Й'
        36: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        42: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        33: SequenceLikelihood.UNLIKELY,  # 'П'
        45: SequenceLikelihood.UNLIKELY,  # 'Р'
        35: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        38: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        55: SequenceLikelihood.NEGATIVE,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        52: SequenceLikelihood.UNLIKELY,  # 'Ч'
        56: SequenceLikelihood.UNLIKELY,  # 'Ш'
        59: SequenceLikelihood.UNLIKELY,  # 'Щ'
        64: SequenceLikelihood.UNLIKELY,  # 'Ь'
        61: SequenceLikelihood.NEGATIVE,  # 'Ю'
        50: SequenceLikelihood.UNLIKELY,  # 'Я'
        2: SequenceLikelihood.POSITIVE,  # 'а'
        21: SequenceLikelihood.UNLIKELY,  # 'б'
        7: SequenceLikelihood.POSITIVE,  # 'в'
        20: SequenceLikelihood.LIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        9: SequenceLikelihood.LIKELY,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.POSITIVE,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        12: SequenceLikelihood.LIKELY,  # 'л'
        15: SequenceLikelihood.LIKELY,  # 'м'
        3: SequenceLikelihood.POSITIVE,  # 'н'
        1: SequenceLikelihood.POSITIVE,  # 'о'
        16: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.LIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        6: SequenceLikelihood.POSITIVE,  # 'т'
        14: SequenceLikelihood.POSITIVE,  # 'у'
        32: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        25: SequenceLikelihood.UNLIKELY,  # 'ц'
        22: SequenceLikelihood.UNLIKELY,  # 'ч'
        29: SequenceLikelihood.UNLIKELY,  # 'ш'
        31: SequenceLikelihood.UNLIKELY,  # 'щ'
        19: SequenceLikelihood.UNLIKELY,  # 'ь'
        27: SequenceLikelihood.UNLIKELY,  # 'ю'
        17: SequenceLikelihood.UNLIKELY,  # 'я'
        30: SequenceLikelihood.UNLIKELY,  # 'є'
        5: SequenceLikelihood.POSITIVE,  # 'і'
        28: SequenceLikelihood.UNLIKELY,  # 'ї'
        66: SequenceLikelihood.NEGATIVE,  # 'Ґ'
        65: SequenceLikelihood.NEGATIVE,  # 'ґ'
    },
    25: {  # 'ц'
        67: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        57: SequenceLikelihood.NEGATIVE,  # 'Є'
        46: SequenceLikelihood.UNLIKELY,  # 'І'
        63: SequenceLikelihood.NEGATIVE,  # 'Ї'
        39: SequenceLikelihood.UNLIKELY,  # 'А'
        47: SequenceLikelihood.NEGATIVE,  # 'Б'
        34: SequenceLikelihood.UNLIKELY,  # 'В'
        48: SequenceLikelihood.UNLIKELY,  # 'Г'
        40: SequenceLikelihood.UNLIKELY,  # 'Д'
        54: SequenceLikelihood.NEGATIVE,  # 'Е'
        60: SequenceLikelihood.NEGATIVE,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        58: SequenceLikelihood.UNLIKELY,  # 'И'
        62: SequenceLikelihood.NEGATIVE,  # 'Й'
        36: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.NEGATIVE,  # 'Л'
        42: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.NEGATIVE,  # 'Н'
        41: SequenceLikelihood.NEGATIVE,  # 'О'
        33: SequenceLikelihood.UNLIKELY,  # 'П'
        45: SequenceLikelihood.UNLIKELY,  # 'Р'
        35: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        38: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.NEGATIVE,  # 'Ф'
        55: SequenceLikelihood.NEGATIVE,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        52: SequenceLikelihood.NEGATIVE,  # 'Ч'
        56: SequenceLikelihood.UNLIKELY,  # 'Ш'
        59: SequenceLikelihood.NEGATIVE,  # 'Щ'
        64: SequenceLikelihood.UNLIKELY,  # 'Ь'
        61: SequenceLikelihood.NEGATIVE,  # 'Ю'
        50: SequenceLikelihood.NEGATIVE,  # 'Я'
        2: SequenceLikelihood.LIKELY,  # 'а'
        21: SequenceLikelihood.UNLIKELY,  # 'б'
        7: SequenceLikelihood.LIKELY,  # 'в'
        20: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        9: SequenceLikelihood.POSITIVE,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.POSITIVE,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        12: SequenceLikelihood.UNLIKELY,  # 'л'
        15: SequenceLikelihood.UNLIKELY,  # 'м'
        3: SequenceLikelihood.LIKELY,  # 'н'
        1: SequenceLikelihood.LIKELY,  # 'о'
        16: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        6: SequenceLikelihood.POSITIVE,  # 'т'
        14: SequenceLikelihood.LIKELY,  # 'у'
        32: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        25: SequenceLikelihood.UNLIKELY,  # 'ц'
        22: SequenceLikelihood.UNLIKELY,  # 'ч'
        29: SequenceLikelihood.UNLIKELY,  # 'ш'
        31: SequenceLikelihood.UNLIKELY,  # 'щ'
        19: SequenceLikelihood.POSITIVE,  # 'ь'
        27: SequenceLikelihood.POSITIVE,  # 'ю'
        17: SequenceLikelihood.POSITIVE,  # 'я'
        30: SequenceLikelihood.UNLIKELY,  # 'є'
        5: SequenceLikelihood.POSITIVE,  # 'і'
        28: SequenceLikelihood.UNLIKELY,  # 'ї'
        66: SequenceLikelihood.NEGATIVE,  # 'Ґ'
        65: SequenceLikelihood.NEGATIVE,  # 'ґ'
    },
    22: {  # 'ч'
        67: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        57: SequenceLikelihood.NEGATIVE,  # 'Є'
        46: SequenceLikelihood.UNLIKELY,  # 'І'
        63: SequenceLikelihood.NEGATIVE,  # 'Ї'
        39: SequenceLikelihood.UNLIKELY,  # 'А'
        47: SequenceLikelihood.UNLIKELY,  # 'Б'
        34: SequenceLikelihood.UNLIKELY,  # 'В'
        48: SequenceLikelihood.UNLIKELY,  # 'Г'
        40: SequenceLikelihood.UNLIKELY,  # 'Д'
        54: SequenceLikelihood.UNLIKELY,  # 'Е'
        60: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        58: SequenceLikelihood.UNLIKELY,  # 'И'
        62: SequenceLikelihood.NEGATIVE,  # 'Й'
        36: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        42: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        33: SequenceLikelihood.UNLIKELY,  # 'П'
        45: SequenceLikelihood.UNLIKELY,  # 'Р'
        35: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        38: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        55: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        52: SequenceLikelihood.UNLIKELY,  # 'Ч'
        56: SequenceLikelihood.UNLIKELY,  # 'Ш'
        59: SequenceLikelihood.UNLIKELY,  # 'Щ'
        64: SequenceLikelihood.UNLIKELY,  # 'Ь'
        61: SequenceLikelihood.NEGATIVE,  # 'Ю'
        50: SequenceLikelihood.NEGATIVE,  # 'Я'
        2: SequenceLikelihood.POSITIVE,  # 'а'
        21: SequenceLikelihood.UNLIKELY,  # 'б'
        7: SequenceLikelihood.UNLIKELY,  # 'в'
        20: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        9: SequenceLikelihood.POSITIVE,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.POSITIVE,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        12: SequenceLikelihood.LIKELY,  # 'л'
        15: SequenceLikelihood.UNLIKELY,  # 'м'
        3: SequenceLikelihood.POSITIVE,  # 'н'
        1: SequenceLikelihood.POSITIVE,  # 'о'
        16: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        6: SequenceLikelihood.LIKELY,  # 'т'
        14: SequenceLikelihood.POSITIVE,  # 'у'
        32: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        25: SequenceLikelihood.LIKELY,  # 'ц'
        22: SequenceLikelihood.LIKELY,  # 'ч'
        29: SequenceLikelihood.UNLIKELY,  # 'ш'
        31: SequenceLikelihood.NEGATIVE,  # 'щ'
        19: SequenceLikelihood.UNLIKELY,  # 'ь'
        27: SequenceLikelihood.UNLIKELY,  # 'ю'
        17: SequenceLikelihood.LIKELY,  # 'я'
        30: SequenceLikelihood.UNLIKELY,  # 'є'
        5: SequenceLikelihood.POSITIVE,  # 'і'
        28: SequenceLikelihood.NEGATIVE,  # 'ї'
        66: SequenceLikelihood.NEGATIVE,  # 'Ґ'
        65: SequenceLikelihood.NEGATIVE,  # 'ґ'
    },
    29: {  # 'ш'
        67: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        57: SequenceLikelihood.NEGATIVE,  # 'Є'
        46: SequenceLikelihood.UNLIKELY,  # 'І'
        63: SequenceLikelihood.NEGATIVE,  # 'Ї'
        39: SequenceLikelihood.UNLIKELY,  # 'А'
        47: SequenceLikelihood.UNLIKELY,  # 'Б'
        34: SequenceLikelihood.UNLIKELY,  # 'В'
        48: SequenceLikelihood.UNLIKELY,  # 'Г'
        40: SequenceLikelihood.UNLIKELY,  # 'Д'
        54: SequenceLikelihood.NEGATIVE,  # 'Е'
        60: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.NEGATIVE,  # 'З'
        58: SequenceLikelihood.NEGATIVE,  # 'И'
        62: SequenceLikelihood.NEGATIVE,  # 'Й'
        36: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        42: SequenceLikelihood.NEGATIVE,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.NEGATIVE,  # 'О'
        33: SequenceLikelihood.UNLIKELY,  # 'П'
        45: SequenceLikelihood.UNLIKELY,  # 'Р'
        35: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        38: SequenceLikelihood.NEGATIVE,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        55: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.NEGATIVE,  # 'Ц'
        52: SequenceLikelihood.NEGATIVE,  # 'Ч'
        56: SequenceLikelihood.UNLIKELY,  # 'Ш'
        59: SequenceLikelihood.NEGATIVE,  # 'Щ'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        61: SequenceLikelihood.UNLIKELY,  # 'Ю'
        50: SequenceLikelihood.NEGATIVE,  # 'Я'
        2: SequenceLikelihood.POSITIVE,  # 'а'
        21: SequenceLikelihood.UNLIKELY,  # 'б'
        7: SequenceLikelihood.POSITIVE,  # 'в'
        20: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        9: SequenceLikelihood.POSITIVE,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.POSITIVE,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        12: SequenceLikelihood.POSITIVE,  # 'л'
        15: SequenceLikelihood.LIKELY,  # 'м'
        3: SequenceLikelihood.POSITIVE,  # 'н'
        1: SequenceLikelihood.POSITIVE,  # 'о'
        16: SequenceLikelihood.LIKELY,  # 'п'
        8: SequenceLikelihood.LIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        6: SequenceLikelihood.POSITIVE,  # 'т'
        14: SequenceLikelihood.POSITIVE,  # 'у'
        32: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        25: SequenceLikelihood.UNLIKELY,  # 'ц'
        22: SequenceLikelihood.UNLIKELY,  # 'ч'
        29: SequenceLikelihood.UNLIKELY,  # 'ш'
        31: SequenceLikelihood.UNLIKELY,  # 'щ'
        19: SequenceLikelihood.UNLIKELY,  # 'ь'
        27: SequenceLikelihood.UNLIKELY,  # 'ю'
        17: SequenceLikelihood.UNLIKELY,  # 'я'
        30: SequenceLikelihood.UNLIKELY,  # 'є'
        5: SequenceLikelihood.POSITIVE,  # 'і'
        28: SequenceLikelihood.UNLIKELY,  # 'ї'
        66: SequenceLikelihood.NEGATIVE,  # 'Ґ'
        65: SequenceLikelihood.NEGATIVE,  # 'ґ'
    },
    31: {  # 'щ'
        67: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        57: SequenceLikelihood.NEGATIVE,  # 'Є'
        46: SequenceLikelihood.UNLIKELY,  # 'І'
        63: SequenceLikelihood.NEGATIVE,  # 'Ї'
        39: SequenceLikelihood.UNLIKELY,  # 'А'
        47: SequenceLikelihood.UNLIKELY,  # 'Б'
        34: SequenceLikelihood.NEGATIVE,  # 'В'
        48: SequenceLikelihood.NEGATIVE,  # 'Г'
        40: SequenceLikelihood.NEGATIVE,  # 'Д'
        54: SequenceLikelihood.NEGATIVE,  # 'Е'
        60: SequenceLikelihood.NEGATIVE,  # 'Ж'
        44: SequenceLikelihood.NEGATIVE,  # 'З'
        58: SequenceLikelihood.NEGATIVE,  # 'И'
        62: SequenceLikelihood.NEGATIVE,  # 'Й'
        36: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.NEGATIVE,  # 'Л'
        42: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.NEGATIVE,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        33: SequenceLikelihood.UNLIKELY,  # 'П'
        45: SequenceLikelihood.UNLIKELY,  # 'Р'
        35: SequenceLikelihood.NEGATIVE,  # 'С'
        43: SequenceLikelihood.NEGATIVE,  # 'Т'
        38: SequenceLikelihood.NEGATIVE,  # 'У'
        53: SequenceLikelihood.NEGATIVE,  # 'Ф'
        55: SequenceLikelihood.NEGATIVE,  # 'Х'
        51: SequenceLikelihood.NEGATIVE,  # 'Ц'
        52: SequenceLikelihood.NEGATIVE,  # 'Ч'
        56: SequenceLikelihood.NEGATIVE,  # 'Ш'
        59: SequenceLikelihood.NEGATIVE,  # 'Щ'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        61: SequenceLikelihood.NEGATIVE,  # 'Ю'
        50: SequenceLikelihood.NEGATIVE,  # 'Я'
        2: SequenceLikelihood.POSITIVE,  # 'а'
        21: SequenceLikelihood.UNLIKELY,  # 'б'
        7: SequenceLikelihood.UNLIKELY,  # 'в'
        20: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        9: SequenceLikelihood.POSITIVE,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.POSITIVE,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        12: SequenceLikelihood.UNLIKELY,  # 'л'
        15: SequenceLikelihood.UNLIKELY,  # 'м'
        3: SequenceLikelihood.UNLIKELY,  # 'н'
        1: SequenceLikelihood.POSITIVE,  # 'о'
        16: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        6: SequenceLikelihood.UNLIKELY,  # 'т'
        14: SequenceLikelihood.LIKELY,  # 'у'
        32: SequenceLikelihood.NEGATIVE,  # 'ф'
        24: SequenceLikelihood.NEGATIVE,  # 'х'
        25: SequenceLikelihood.UNLIKELY,  # 'ц'
        22: SequenceLikelihood.UNLIKELY,  # 'ч'
        29: SequenceLikelihood.UNLIKELY,  # 'ш'
        31: SequenceLikelihood.UNLIKELY,  # 'щ'
        19: SequenceLikelihood.UNLIKELY,  # 'ь'
        27: SequenceLikelihood.UNLIKELY,  # 'ю'
        17: SequenceLikelihood.UNLIKELY,  # 'я'
        30: SequenceLikelihood.UNLIKELY,  # 'є'
        5: SequenceLikelihood.POSITIVE,  # 'і'
        28: SequenceLikelihood.UNLIKELY,  # 'ї'
        66: SequenceLikelihood.NEGATIVE,  # 'Ґ'
        65: SequenceLikelihood.NEGATIVE,  # 'ґ'
    },
    19: {  # 'ь'
        67: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        57: SequenceLikelihood.UNLIKELY,  # 'Є'
        46: SequenceLikelihood.UNLIKELY,  # 'І'
        63: SequenceLikelihood.UNLIKELY,  # 'Ї'
        39: SequenceLikelihood.UNLIKELY,  # 'А'
        47: SequenceLikelihood.UNLIKELY,  # 'Б'
        34: SequenceLikelihood.UNLIKELY,  # 'В'
        48: SequenceLikelihood.UNLIKELY,  # 'Г'
        40: SequenceLikelihood.UNLIKELY,  # 'Д'
        54: SequenceLikelihood.UNLIKELY,  # 'Е'
        60: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        58: SequenceLikelihood.UNLIKELY,  # 'И'
        62: SequenceLikelihood.NEGATIVE,  # 'Й'
        36: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        42: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        33: SequenceLikelihood.UNLIKELY,  # 'П'
        45: SequenceLikelihood.UNLIKELY,  # 'Р'
        35: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        38: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        55: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        52: SequenceLikelihood.UNLIKELY,  # 'Ч'
        56: SequenceLikelihood.UNLIKELY,  # 'Ш'
        59: SequenceLikelihood.UNLIKELY,  # 'Щ'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        61: SequenceLikelihood.UNLIKELY,  # 'Ю'
        50: SequenceLikelihood.UNLIKELY,  # 'Я'
        2: SequenceLikelihood.UNLIKELY,  # 'а'
        21: SequenceLikelihood.LIKELY,  # 'б'
        7: SequenceLikelihood.POSITIVE,  # 'в'
        20: SequenceLikelihood.LIKELY,  # 'г'
        13: SequenceLikelihood.LIKELY,  # 'д'
        9: SequenceLikelihood.UNLIKELY,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.UNLIKELY,  # 'и'
        23: SequenceLikelihood.LIKELY,  # 'й'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        12: SequenceLikelihood.UNLIKELY,  # 'л'
        15: SequenceLikelihood.POSITIVE,  # 'м'
        3: SequenceLikelihood.POSITIVE,  # 'н'
        1: SequenceLikelihood.POSITIVE,  # 'о'
        16: SequenceLikelihood.LIKELY,  # 'п'
        8: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.POSITIVE,  # 'с'
        6: SequenceLikelihood.POSITIVE,  # 'т'
        14: SequenceLikelihood.UNLIKELY,  # 'у'
        32: SequenceLikelihood.LIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        25: SequenceLikelihood.LIKELY,  # 'ц'
        22: SequenceLikelihood.LIKELY,  # 'ч'
        29: SequenceLikelihood.POSITIVE,  # 'ш'
        31: SequenceLikelihood.LIKELY,  # 'щ'
        19: SequenceLikelihood.UNLIKELY,  # 'ь'
        27: SequenceLikelihood.LIKELY,  # 'ю'
        17: SequenceLikelihood.LIKELY,  # 'я'
        30: SequenceLikelihood.LIKELY,  # 'є'
        5: SequenceLikelihood.UNLIKELY,  # 'і'
        28: SequenceLikelihood.UNLIKELY,  # 'ї'
        66: SequenceLikelihood.NEGATIVE,  # 'Ґ'
        65: SequenceLikelihood.UNLIKELY,  # 'ґ'
    },
    27: {  # 'ю'
        67: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        57: SequenceLikelihood.NEGATIVE,  # 'Є'
        46: SequenceLikelihood.UNLIKELY,  # 'І'
        63: SequenceLikelihood.UNLIKELY,  # 'Ї'
        39: SequenceLikelihood.UNLIKELY,  # 'А'
        47: SequenceLikelihood.UNLIKELY,  # 'Б'
        34: SequenceLikelihood.UNLIKELY,  # 'В'
        48: SequenceLikelihood.UNLIKELY,  # 'Г'
        40: SequenceLikelihood.UNLIKELY,  # 'Д'
        54: SequenceLikelihood.UNLIKELY,  # 'Е'
        60: SequenceLikelihood.NEGATIVE,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        58: SequenceLikelihood.UNLIKELY,  # 'И'
        62: SequenceLikelihood.UNLIKELY,  # 'Й'
        36: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        42: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        33: SequenceLikelihood.UNLIKELY,  # 'П'
        45: SequenceLikelihood.UNLIKELY,  # 'Р'
        35: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        38: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        55: SequenceLikelihood.NEGATIVE,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        52: SequenceLikelihood.UNLIKELY,  # 'Ч'
        56: SequenceLikelihood.NEGATIVE,  # 'Ш'
        59: SequenceLikelihood.UNLIKELY,  # 'Щ'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        61: SequenceLikelihood.UNLIKELY,  # 'Ю'
        50: SequenceLikelihood.UNLIKELY,  # 'Я'
        2: SequenceLikelihood.UNLIKELY,  # 'а'
        21: SequenceLikelihood.POSITIVE,  # 'б'
        7: SequenceLikelihood.POSITIVE,  # 'в'
        20: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.POSITIVE,  # 'д'
        9: SequenceLikelihood.UNLIKELY,  # 'е'
        26: SequenceLikelihood.LIKELY,  # 'ж'
        18: SequenceLikelihood.LIKELY,  # 'з'
        4: SequenceLikelihood.UNLIKELY,  # 'и'
        23: SequenceLikelihood.LIKELY,  # 'й'
        11: SequenceLikelihood.LIKELY,  # 'к'
        12: SequenceLikelihood.LIKELY,  # 'л'
        15: SequenceLikelihood.LIKELY,  # 'м'
        3: SequenceLikelihood.LIKELY,  # 'н'
        1: SequenceLikelihood.UNLIKELY,  # 'о'
        16: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.LIKELY,  # 'р'
        10: SequenceLikelihood.LIKELY,  # 'с'
        6: SequenceLikelihood.POSITIVE,  # 'т'
        14: SequenceLikelihood.UNLIKELY,  # 'у'
        32: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        25: SequenceLikelihood.LIKELY,  # 'ц'
        22: SequenceLikelihood.POSITIVE,  # 'ч'
        29: SequenceLikelihood.UNLIKELY,  # 'ш'
        31: SequenceLikelihood.LIKELY,  # 'щ'
        19: SequenceLikelihood.UNLIKELY,  # 'ь'
        27: SequenceLikelihood.POSITIVE,  # 'ю'
        17: SequenceLikelihood.UNLIKELY,  # 'я'
        30: SequenceLikelihood.POSITIVE,  # 'є'
        5: SequenceLikelihood.UNLIKELY,  # 'і'
        28: SequenceLikelihood.UNLIKELY,  # 'ї'
        66: SequenceLikelihood.NEGATIVE,  # 'Ґ'
        65: SequenceLikelihood.UNLIKELY,  # 'ґ'
    },
    17: {  # 'я'
        67: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        57: SequenceLikelihood.UNLIKELY,  # 'Є'
        46: SequenceLikelihood.UNLIKELY,  # 'І'
        63: SequenceLikelihood.UNLIKELY,  # 'Ї'
        39: SequenceLikelihood.UNLIKELY,  # 'А'
        47: SequenceLikelihood.UNLIKELY,  # 'Б'
        34: SequenceLikelihood.UNLIKELY,  # 'В'
        48: SequenceLikelihood.UNLIKELY,  # 'Г'
        40: SequenceLikelihood.UNLIKELY,  # 'Д'
        54: SequenceLikelihood.UNLIKELY,  # 'Е'
        60: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        58: SequenceLikelihood.UNLIKELY,  # 'И'
        62: SequenceLikelihood.NEGATIVE,  # 'Й'
        36: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        42: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        33: SequenceLikelihood.UNLIKELY,  # 'П'
        45: SequenceLikelihood.UNLIKELY,  # 'Р'
        35: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        38: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        55: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        52: SequenceLikelihood.UNLIKELY,  # 'Ч'
        56: SequenceLikelihood.UNLIKELY,  # 'Ш'
        59: SequenceLikelihood.UNLIKELY,  # 'Щ'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        61: SequenceLikelihood.UNLIKELY,  # 'Ю'
        50: SequenceLikelihood.UNLIKELY,  # 'Я'
        2: SequenceLikelihood.UNLIKELY,  # 'а'
        21: SequenceLikelihood.LIKELY,  # 'б'
        7: SequenceLikelihood.POSITIVE,  # 'в'
        20: SequenceLikelihood.POSITIVE,  # 'г'
        13: SequenceLikelihood.POSITIVE,  # 'д'
        9: SequenceLikelihood.UNLIKELY,  # 'е'
        26: SequenceLikelihood.LIKELY,  # 'ж'
        18: SequenceLikelihood.POSITIVE,  # 'з'
        4: SequenceLikelihood.UNLIKELY,  # 'и'
        23: SequenceLikelihood.LIKELY,  # 'й'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        12: SequenceLikelihood.POSITIVE,  # 'л'
        15: SequenceLikelihood.POSITIVE,  # 'м'
        3: SequenceLikelihood.POSITIVE,  # 'н'
        1: SequenceLikelihood.UNLIKELY,  # 'о'
        16: SequenceLikelihood.LIKELY,  # 'п'
        8: SequenceLikelihood.POSITIVE,  # 'р'
        10: SequenceLikelihood.POSITIVE,  # 'с'
        6: SequenceLikelihood.POSITIVE,  # 'т'
        14: SequenceLikelihood.UNLIKELY,  # 'у'
        32: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.POSITIVE,  # 'х'
        25: SequenceLikelihood.POSITIVE,  # 'ц'
        22: SequenceLikelihood.POSITIVE,  # 'ч'
        29: SequenceLikelihood.LIKELY,  # 'ш'
        31: SequenceLikelihood.LIKELY,  # 'щ'
        19: SequenceLikelihood.UNLIKELY,  # 'ь'
        27: SequenceLikelihood.POSITIVE,  # 'ю'
        17: SequenceLikelihood.UNLIKELY,  # 'я'
        30: SequenceLikelihood.POSITIVE,  # 'є'
        5: SequenceLikelihood.UNLIKELY,  # 'і'
        28: SequenceLikelihood.UNLIKELY,  # 'ї'
        66: SequenceLikelihood.NEGATIVE,  # 'Ґ'
        65: SequenceLikelihood.UNLIKELY,  # 'ґ'
    },
    30: {  # 'є'
        67: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        57: SequenceLikelihood.NEGATIVE,  # 'Є'
        46: SequenceLikelihood.UNLIKELY,  # 'І'
        63: SequenceLikelihood.NEGATIVE,  # 'Ї'
        39: SequenceLikelihood.UNLIKELY,  # 'А'
        47: SequenceLikelihood.UNLIKELY,  # 'Б'
        34: SequenceLikelihood.UNLIKELY,  # 'В'
        48: SequenceLikelihood.NEGATIVE,  # 'Г'
        40: SequenceLikelihood.UNLIKELY,  # 'Д'
        54: SequenceLikelihood.UNLIKELY,  # 'Е'
        60: SequenceLikelihood.NEGATIVE,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        58: SequenceLikelihood.NEGATIVE,  # 'И'
        62: SequenceLikelihood.NEGATIVE,  # 'Й'
        36: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        42: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        33: SequenceLikelihood.UNLIKELY,  # 'П'
        45: SequenceLikelihood.UNLIKELY,  # 'Р'
        35: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        38: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.NEGATIVE,  # 'Ф'
        55: SequenceLikelihood.NEGATIVE,  # 'Х'
        51: SequenceLikelihood.NEGATIVE,  # 'Ц'
        52: SequenceLikelihood.UNLIKELY,  # 'Ч'
        56: SequenceLikelihood.NEGATIVE,  # 'Ш'
        59: SequenceLikelihood.UNLIKELY,  # 'Щ'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        61: SequenceLikelihood.UNLIKELY,  # 'Ю'
        50: SequenceLikelihood.UNLIKELY,  # 'Я'
        2: SequenceLikelihood.UNLIKELY,  # 'а'
        21: SequenceLikelihood.UNLIKELY,  # 'б'
        7: SequenceLikelihood.POSITIVE,  # 'в'
        20: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.POSITIVE,  # 'д'
        9: SequenceLikelihood.UNLIKELY,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.LIKELY,  # 'з'
        4: SequenceLikelihood.UNLIKELY,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        12: SequenceLikelihood.UNLIKELY,  # 'л'
        15: SequenceLikelihood.POSITIVE,  # 'м'
        3: SequenceLikelihood.POSITIVE,  # 'н'
        1: SequenceLikelihood.UNLIKELY,  # 'о'
        16: SequenceLikelihood.LIKELY,  # 'п'
        8: SequenceLikelihood.LIKELY,  # 'р'
        10: SequenceLikelihood.LIKELY,  # 'с'
        6: SequenceLikelihood.POSITIVE,  # 'т'
        14: SequenceLikelihood.UNLIKELY,  # 'у'
        32: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        25: SequenceLikelihood.UNLIKELY,  # 'ц'
        22: SequenceLikelihood.LIKELY,  # 'ч'
        29: SequenceLikelihood.LIKELY,  # 'ш'
        31: SequenceLikelihood.UNLIKELY,  # 'щ'
        19: SequenceLikelihood.UNLIKELY,  # 'ь'
        27: SequenceLikelihood.POSITIVE,  # 'ю'
        17: SequenceLikelihood.UNLIKELY,  # 'я'
        30: SequenceLikelihood.UNLIKELY,  # 'є'
        5: SequenceLikelihood.UNLIKELY,  # 'і'
        28: SequenceLikelihood.POSITIVE,  # 'ї'
        66: SequenceLikelihood.NEGATIVE,  # 'Ґ'
        65: SequenceLikelihood.UNLIKELY,  # 'ґ'
    },
    5: {  # 'і'
        67: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        57: SequenceLikelihood.UNLIKELY,  # 'Є'
        46: SequenceLikelihood.UNLIKELY,  # 'І'
        63: SequenceLikelihood.UNLIKELY,  # 'Ї'
        39: SequenceLikelihood.UNLIKELY,  # 'А'
        47: SequenceLikelihood.UNLIKELY,  # 'Б'
        34: SequenceLikelihood.UNLIKELY,  # 'В'
        48: SequenceLikelihood.UNLIKELY,  # 'Г'
        40: SequenceLikelihood.UNLIKELY,  # 'Д'
        54: SequenceLikelihood.UNLIKELY,  # 'Е'
        60: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        58: SequenceLikelihood.UNLIKELY,  # 'И'
        62: SequenceLikelihood.UNLIKELY,  # 'Й'
        36: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        42: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        33: SequenceLikelihood.UNLIKELY,  # 'П'
        45: SequenceLikelihood.UNLIKELY,  # 'Р'
        35: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        38: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        55: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        52: SequenceLikelihood.UNLIKELY,  # 'Ч'
        56: SequenceLikelihood.UNLIKELY,  # 'Ш'
        59: SequenceLikelihood.UNLIKELY,  # 'Щ'
        64: SequenceLikelihood.UNLIKELY,  # 'Ь'
        61: SequenceLikelihood.UNLIKELY,  # 'Ю'
        50: SequenceLikelihood.UNLIKELY,  # 'Я'
        2: SequenceLikelihood.POSITIVE,  # 'а'
        21: SequenceLikelihood.POSITIVE,  # 'б'
        7: SequenceLikelihood.POSITIVE,  # 'в'
        20: SequenceLikelihood.POSITIVE,  # 'г'
        13: SequenceLikelihood.POSITIVE,  # 'д'
        9: SequenceLikelihood.LIKELY,  # 'е'
        26: SequenceLikelihood.POSITIVE,  # 'ж'
        18: SequenceLikelihood.POSITIVE,  # 'з'
        4: SequenceLikelihood.UNLIKELY,  # 'и'
        23: SequenceLikelihood.POSITIVE,  # 'й'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        12: SequenceLikelihood.POSITIVE,  # 'л'
        15: SequenceLikelihood.POSITIVE,  # 'м'
        3: SequenceLikelihood.POSITIVE,  # 'н'
        1: SequenceLikelihood.POSITIVE,  # 'о'
        16: SequenceLikelihood.POSITIVE,  # 'п'
        8: SequenceLikelihood.POSITIVE,  # 'р'
        10: SequenceLikelihood.POSITIVE,  # 'с'
        6: SequenceLikelihood.POSITIVE,  # 'т'
        14: SequenceLikelihood.LIKELY,  # 'у'
        32: SequenceLikelihood.LIKELY,  # 'ф'
        24: SequenceLikelihood.POSITIVE,  # 'х'
        25: SequenceLikelihood.POSITIVE,  # 'ц'
        22: SequenceLikelihood.POSITIVE,  # 'ч'
        29: SequenceLikelihood.POSITIVE,  # 'ш'
        31: SequenceLikelihood.POSITIVE,  # 'щ'
        19: SequenceLikelihood.UNLIKELY,  # 'ь'
        27: SequenceLikelihood.POSITIVE,  # 'ю'
        17: SequenceLikelihood.POSITIVE,  # 'я'
        30: SequenceLikelihood.POSITIVE,  # 'є'
        5: SequenceLikelihood.UNLIKELY,  # 'і'
        28: SequenceLikelihood.POSITIVE,  # 'ї'
        66: SequenceLikelihood.NEGATIVE,  # 'Ґ'
        65: SequenceLikelihood.UNLIKELY,  # 'ґ'
    },
    28: {  # 'ї'
        67: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        57: SequenceLikelihood.NEGATIVE,  # 'Є'
        46: SequenceLikelihood.UNLIKELY,  # 'І'
        63: SequenceLikelihood.NEGATIVE,  # 'Ї'
        39: SequenceLikelihood.UNLIKELY,  # 'А'
        47: SequenceLikelihood.UNLIKELY,  # 'Б'
        34: SequenceLikelihood.UNLIKELY,  # 'В'
        48: SequenceLikelihood.UNLIKELY,  # 'Г'
        40: SequenceLikelihood.UNLIKELY,  # 'Д'
        54: SequenceLikelihood.UNLIKELY,  # 'Е'
        60: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        58: SequenceLikelihood.UNLIKELY,  # 'И'
        62: SequenceLikelihood.NEGATIVE,  # 'Й'
        36: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        42: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        33: SequenceLikelihood.UNLIKELY,  # 'П'
        45: SequenceLikelihood.UNLIKELY,  # 'Р'
        35: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        38: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        55: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        52: SequenceLikelihood.UNLIKELY,  # 'Ч'
        56: SequenceLikelihood.UNLIKELY,  # 'Ш'
        59: SequenceLikelihood.UNLIKELY,  # 'Щ'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        61: SequenceLikelihood.NEGATIVE,  # 'Ю'
        50: SequenceLikelihood.UNLIKELY,  # 'Я'
        2: SequenceLikelihood.UNLIKELY,  # 'а'
        21: SequenceLikelihood.UNLIKELY,  # 'б'
        7: SequenceLikelihood.POSITIVE,  # 'в'
        20: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.LIKELY,  # 'д'
        9: SequenceLikelihood.UNLIKELY,  # 'е'
        26: SequenceLikelihood.LIKELY,  # 'ж'
        18: SequenceLikelihood.LIKELY,  # 'з'
        4: SequenceLikelihood.UNLIKELY,  # 'и'
        23: SequenceLikelihood.LIKELY,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        12: SequenceLikelihood.LIKELY,  # 'л'
        15: SequenceLikelihood.LIKELY,  # 'м'
        3: SequenceLikelihood.POSITIVE,  # 'н'
        1: SequenceLikelihood.UNLIKELY,  # 'о'
        16: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.LIKELY,  # 'с'
        6: SequenceLikelihood.LIKELY,  # 'т'
        14: SequenceLikelihood.UNLIKELY,  # 'у'
        32: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.POSITIVE,  # 'х'
        25: SequenceLikelihood.UNLIKELY,  # 'ц'
        22: SequenceLikelihood.UNLIKELY,  # 'ч'
        29: SequenceLikelihood.UNLIKELY,  # 'ш'
        31: SequenceLikelihood.UNLIKELY,  # 'щ'
        19: SequenceLikelihood.UNLIKELY,  # 'ь'
        27: SequenceLikelihood.UNLIKELY,  # 'ю'
        17: SequenceLikelihood.UNLIKELY,  # 'я'
        30: SequenceLikelihood.UNLIKELY,  # 'є'
        5: SequenceLikelihood.UNLIKELY,  # 'і'
        28: SequenceLikelihood.POSITIVE,  # 'ї'
        66: SequenceLikelihood.NEGATIVE,  # 'Ґ'
        65: SequenceLikelihood.UNLIKELY,  # 'ґ'
    },
    66: {  # 'Ґ'
        67: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        57: SequenceLikelihood.UNLIKELY,  # 'Є'
        46: SequenceLikelihood.UNLIKELY,  # 'І'
        63: SequenceLikelihood.NEGATIVE,  # 'Ї'
        39: SequenceLikelihood.UNLIKELY,  # 'А'
        47: SequenceLikelihood.UNLIKELY,  # 'Б'
        34: SequenceLikelihood.UNLIKELY,  # 'В'
        48: SequenceLikelihood.NEGATIVE,  # 'Г'
        40: SequenceLikelihood.NEGATIVE,  # 'Д'
        54: SequenceLikelihood.UNLIKELY,  # 'Е'
        60: SequenceLikelihood.NEGATIVE,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        58: SequenceLikelihood.UNLIKELY,  # 'И'
        62: SequenceLikelihood.NEGATIVE,  # 'Й'
        36: SequenceLikelihood.NEGATIVE,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        42: SequenceLikelihood.NEGATIVE,  # 'М'
        37: SequenceLikelihood.NEGATIVE,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        33: SequenceLikelihood.UNLIKELY,  # 'П'
        45: SequenceLikelihood.UNLIKELY,  # 'Р'
        35: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.NEGATIVE,  # 'Т'
        38: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.NEGATIVE,  # 'Ф'
        55: SequenceLikelihood.NEGATIVE,  # 'Х'
        51: SequenceLikelihood.NEGATIVE,  # 'Ц'
        52: SequenceLikelihood.NEGATIVE,  # 'Ч'
        56: SequenceLikelihood.NEGATIVE,  # 'Ш'
        59: SequenceLikelihood.NEGATIVE,  # 'Щ'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        61: SequenceLikelihood.NEGATIVE,  # 'Ю'
        50: SequenceLikelihood.NEGATIVE,  # 'Я'
        2: SequenceLikelihood.UNLIKELY,  # 'а'
        21: SequenceLikelihood.UNLIKELY,  # 'б'
        7: SequenceLikelihood.UNLIKELY,  # 'в'
        20: SequenceLikelihood.NEGATIVE,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        9: SequenceLikelihood.UNLIKELY,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.NEGATIVE,  # 'з'
        4: SequenceLikelihood.UNLIKELY,  # 'и'
        23: SequenceLikelihood.NEGATIVE,  # 'й'
        11: SequenceLikelihood.NEGATIVE,  # 'к'
        12: SequenceLikelihood.UNLIKELY,  # 'л'
        15: SequenceLikelihood.UNLIKELY,  # 'м'
        3: SequenceLikelihood.UNLIKELY,  # 'н'
        1: SequenceLikelihood.UNLIKELY,  # 'о'
        16: SequenceLikelihood.NEGATIVE,  # 'п'
        8: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.NEGATIVE,  # 'с'
        6: SequenceLikelihood.NEGATIVE,  # 'т'
        14: SequenceLikelihood.UNLIKELY,  # 'у'
        32: SequenceLikelihood.NEGATIVE,  # 'ф'
        24: SequenceLikelihood.NEGATIVE,  # 'х'
        25: SequenceLikelihood.NEGATIVE,  # 'ц'
        22: SequenceLikelihood.NEGATIVE,  # 'ч'
        29: SequenceLikelihood.UNLIKELY,  # 'ш'
        31: SequenceLikelihood.NEGATIVE,  # 'щ'
        19: SequenceLikelihood.UNLIKELY,  # 'ь'
        27: SequenceLikelihood.UNLIKELY,  # 'ю'
        17: SequenceLikelihood.NEGATIVE,  # 'я'
        30: SequenceLikelihood.UNLIKELY,  # 'є'
        5: SequenceLikelihood.UNLIKELY,  # 'і'
        28: SequenceLikelihood.NEGATIVE,  # 'ї'
        66: SequenceLikelihood.NEGATIVE,  # 'Ґ'
        65: SequenceLikelihood.UNLIKELY,  # 'ґ'
    },
    65: {  # 'ґ'
        67: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        57: SequenceLikelihood.NEGATIVE,  # 'Є'
        46: SequenceLikelihood.NEGATIVE,  # 'І'
        63: SequenceLikelihood.NEGATIVE,  # 'Ї'
        39: SequenceLikelihood.NEGATIVE,  # 'А'
        47: SequenceLikelihood.NEGATIVE,  # 'Б'
        34: SequenceLikelihood.NEGATIVE,  # 'В'
        48: SequenceLikelihood.NEGATIVE,  # 'Г'
        40: SequenceLikelihood.NEGATIVE,  # 'Д'
        54: SequenceLikelihood.NEGATIVE,  # 'Е'
        60: SequenceLikelihood.NEGATIVE,  # 'Ж'
        44: SequenceLikelihood.NEGATIVE,  # 'З'
        58: SequenceLikelihood.NEGATIVE,  # 'И'
        62: SequenceLikelihood.NEGATIVE,  # 'Й'
        36: SequenceLikelihood.NEGATIVE,  # 'К'
        49: SequenceLikelihood.NEGATIVE,  # 'Л'
        42: SequenceLikelihood.NEGATIVE,  # 'М'
        37: SequenceLikelihood.NEGATIVE,  # 'Н'
        41: SequenceLikelihood.NEGATIVE,  # 'О'
        33: SequenceLikelihood.UNLIKELY,  # 'П'
        45: SequenceLikelihood.NEGATIVE,  # 'Р'
        35: SequenceLikelihood.NEGATIVE,  # 'С'
        43: SequenceLikelihood.NEGATIVE,  # 'Т'
        38: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.NEGATIVE,  # 'Ф'
        55: SequenceLikelihood.NEGATIVE,  # 'Х'
        51: SequenceLikelihood.NEGATIVE,  # 'Ц'
        52: SequenceLikelihood.NEGATIVE,  # 'Ч'
        56: SequenceLikelihood.NEGATIVE,  # 'Ш'
        59: SequenceLikelihood.NEGATIVE,  # 'Щ'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        61: SequenceLikelihood.NEGATIVE,  # 'Ю'
        50: SequenceLikelihood.NEGATIVE,  # 'Я'
        2: SequenceLikelihood.UNLIKELY,  # 'а'
        21: SequenceLikelihood.UNLIKELY,  # 'б'
        7: SequenceLikelihood.UNLIKELY,  # 'в'
        20: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        9: SequenceLikelihood.UNLIKELY,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.UNLIKELY,  # 'и'
        23: SequenceLikelihood.NEGATIVE,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        12: SequenceLikelihood.UNLIKELY,  # 'л'
        15: SequenceLikelihood.UNLIKELY,  # 'м'
        3: SequenceLikelihood.UNLIKELY,  # 'н'
        1: SequenceLikelihood.UNLIKELY,  # 'о'
        16: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.LIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        6: SequenceLikelihood.UNLIKELY,  # 'т'
        14: SequenceLikelihood.UNLIKELY,  # 'у'
        32: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        25: SequenceLikelihood.NEGATIVE,  # 'ц'
        22: SequenceLikelihood.UNLIKELY,  # 'ч'
        29: SequenceLikelihood.UNLIKELY,  # 'ш'
        31: SequenceLikelihood.NEGATIVE,  # 'щ'
        19: SequenceLikelihood.UNLIKELY,  # 'ь'
        27: SequenceLikelihood.UNLIKELY,  # 'ю'
        17: SequenceLikelihood.UNLIKELY,  # 'я'
        30: SequenceLikelihood.UNLIKELY,  # 'є'
        5: SequenceLikelihood.UNLIKELY,  # 'і'
        28: SequenceLikelihood.UNLIKELY,  # 'ї'
        66: SequenceLikelihood.NEGATIVE,  # 'Ґ'
        65: SequenceLikelihood.UNLIKELY,  # 'ґ'
    },
}

# Character Mapping Table(s):
CP855_UKRAINIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 0,  # 'A'
    66: 0,  # 'B'
    67: 0,  # 'C'
    68: 0,  # 'D'
    69: 0,  # 'E'
    70: 0,  # 'F'
    71: 0,  # 'G'
    72: 0,  # 'H'
    73: 0,  # 'I'
    74: 0,  # 'J'
    75: 0,  # 'K'
    76: 0,  # 'L'
    77: 0,  # 'M'
    78: 0,  # 'N'
    79: 0,  # 'O'
    80: 0,  # 'P'
    81: 0,  # 'Q'
    82: 0,  # 'R'
    83: 0,  # 'S'
    84: 0,  # 'T'
    85: 0,  # 'U'
    86: 0,  # 'V'
    87: 0,  # 'W'
    88: 0,  # 'X'
    89: 0,  # 'Y'
    90: 0,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 0,  # 'a'
    98: 0,  # 'b'
    99: 0,  # 'c'
    100: 0,  # 'd'
    101: 0,  # 'e'
    102: 0,  # 'f'
    103: 0,  # 'g'
    104: 0,  # 'h'
    105: 0,  # 'i'
    106: 0,  # 'j'
    107: 0,  # 'k'
    108: 0,  # 'l'
    109: 0,  # 'm'
    110: 0,  # 'n'
    111: 0,  # 'o'
    112: 0,  # 'p'
    113: 0,  # 'q'
    114: 0,  # 'r'
    115: 0,  # 's'
    116: 0,  # 't'
    117: 0,  # 'u'
    118: 0,  # 'v'
    119: 0,  # 'w'
    120: 0,  # 'x'
    121: 0,  # 'y'
    122: 0,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 0,  # 'ђ'
    129: 0,  # 'Ђ'
    130: 0,  # 'ѓ'
    131: 0,  # 'Ѓ'
    132: 0,  # 'ё'
    133: 0,  # 'Ё'
    134: 30,  # 'є'
    135: 57,  # 'Є'
    136: 0,  # 'ѕ'
    137: 0,  # 'Ѕ'
    138: 5,  # 'і'
    139: 46,  # 'І'
    140: 28,  # 'ї'
    141: 63,  # 'Ї'
    142: 0,  # 'ј'
    143: 0,  # 'Ј'
    144: 0,  # 'љ'
    145: 0,  # 'Љ'
    146: 0,  # 'њ'
    147: 0,  # 'Њ'
    148: 0,  # 'ћ'
    149: 0,  # 'Ћ'
    150: 0,  # 'ќ'
    151: 0,  # 'Ќ'
    152: 0,  # 'ў'
    153: 0,  # 'Ў'
    154: 0,  # 'џ'
    155: 0,  # 'Џ'
    156: 27,  # 'ю'
    157: 61,  # 'Ю'
    158: 0,  # 'ъ'
    159: 0,  # 'Ъ'
    160: 2,  # 'а'
    161: 39,  # 'А'
    162: 21,  # 'б'
    163: 47,  # 'Б'
    164: 25,  # 'ц'
    165: 51,  # 'Ц'
    166: 13,  # 'д'
    167: 40,  # 'Д'
    168: 9,  # 'е'
    169: 54,  # 'Е'
    170: 32,  # 'ф'
    171: 53,  # 'Ф'
    172: 20,  # 'г'
    173: 48,  # 'Г'
    174: CharacterCategory.SYMBOL,  # '«'
    175: CharacterCategory.SYMBOL,  # '»'
    176: CharacterCategory.SYMBOL,  # '░'
    177: CharacterCategory.SYMBOL,  # '▒'
    178: CharacterCategory.SYMBOL,  # '▓'
    179: CharacterCategory.SYMBOL,  # '│'
    180: CharacterCategory.SYMBOL,  # '┤'
    181: 24,  # 'х'
    182: 55,  # 'Х'
    183: 4,  # 'и'
    184: 58,  # 'И'
    185: CharacterCategory.SYMBOL,  # '╣'
    186: CharacterCategory.SYMBOL,  # '║'
    187: CharacterCategory.SYMBOL,  # '╗'
    188: CharacterCategory.SYMBOL,  # '╝'
    189: 23,  # 'й'
    190: 62,  # 'Й'
    191: CharacterCategory.SYMBOL,  # '┐'
    192: CharacterCategory.SYMBOL,  # '└'
    193: CharacterCategory.SYMBOL,  # '┴'
    194: CharacterCategory.SYMBOL,  # '┬'
    195: CharacterCategory.SYMBOL,  # '├'
    196: CharacterCategory.SYMBOL,  # '─'
    197: CharacterCategory.SYMBOL,  # '┼'
    198: 11,  # 'к'
    199: 36,  # 'К'
    200: CharacterCategory.SYMBOL,  # '╚'
    201: CharacterCategory.SYMBOL,  # '╔'
    202: CharacterCategory.SYMBOL,  # '╩'
    203: CharacterCategory.SYMBOL,  # '╦'
    204: CharacterCategory.SYMBOL,  # '╠'
    205: CharacterCategory.SYMBOL,  # '═'
    206: CharacterCategory.SYMBOL,  # '╬'
    207: CharacterCategory.SYMBOL,  # '¤'
    208: 12,  # 'л'
    209: 49,  # 'Л'
    210: 15,  # 'м'
    211: 42,  # 'М'
    212: 3,  # 'н'
    213: 37,  # 'Н'
    214: 1,  # 'о'
    215: 41,  # 'О'
    216: 16,  # 'п'
    217: CharacterCategory.SYMBOL,  # '┘'
    218: CharacterCategory.SYMBOL,  # '┌'
    219: CharacterCategory.SYMBOL,  # '█'
    220: CharacterCategory.SYMBOL,  # '▄'
    221: 33,  # 'П'
    222: 17,  # 'я'
    223: CharacterCategory.SYMBOL,  # '▀'
    224: 50,  # 'Я'
    225: 8,  # 'р'
    226: 45,  # 'Р'
    227: 10,  # 'с'
    228: 35,  # 'С'
    229: 6,  # 'т'
    230: 43,  # 'Т'
    231: 14,  # 'у'
    232: 38,  # 'У'
    233: 26,  # 'ж'
    234: 60,  # 'Ж'
    235: 7,  # 'в'
    236: 34,  # 'В'
    237: 19,  # 'ь'
    238: 64,  # 'Ь'
    239: CharacterCategory.SYMBOL,  # '№'
    240: CharacterCategory.CONTROL,  # '\xad'
    241: 0,  # 'ы'
    242: 0,  # 'Ы'
    243: 18,  # 'з'
    244: 44,  # 'З'
    245: 29,  # 'ш'
    246: 56,  # 'Ш'
    247: 0,  # 'э'
    248: 0,  # 'Э'
    249: 31,  # 'щ'
    250: 59,  # 'Щ'
    251: 22,  # 'ч'
    252: 52,  # 'Ч'
    253: CharacterCategory.SYMBOL,  # '§'
    254: CharacterCategory.SYMBOL,  # '■'
    255: CharacterCategory.CONTROL,  # '\xa0'
}

CP855_UKRAINIAN_MODEL = SingleByteCharSetModel(
    charset_name="CP855",
    language="Ukrainian",
    char_to_order_map=CP855_UKRAINIAN_CHAR_TO_ORDER,
    language_model=UKRAINIAN_LANG_MODEL,
    typical_positive_ratio=0.972901294935246,
    keep_ascii_letters=False,
    alphabet="ʼЄІЇАБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЬЮЯабвгдежзийклмнопрстуфхцчшщьюяєіїҐґ",
)

CP866_UKRAINIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 0,  # 'A'
    66: 0,  # 'B'
    67: 0,  # 'C'
    68: 0,  # 'D'
    69: 0,  # 'E'
    70: 0,  # 'F'
    71: 0,  # 'G'
    72: 0,  # 'H'
    73: 0,  # 'I'
    74: 0,  # 'J'
    75: 0,  # 'K'
    76: 0,  # 'L'
    77: 0,  # 'M'
    78: 0,  # 'N'
    79: 0,  # 'O'
    80: 0,  # 'P'
    81: 0,  # 'Q'
    82: 0,  # 'R'
    83: 0,  # 'S'
    84: 0,  # 'T'
    85: 0,  # 'U'
    86: 0,  # 'V'
    87: 0,  # 'W'
    88: 0,  # 'X'
    89: 0,  # 'Y'
    90: 0,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 0,  # 'a'
    98: 0,  # 'b'
    99: 0,  # 'c'
    100: 0,  # 'd'
    101: 0,  # 'e'
    102: 0,  # 'f'
    103: 0,  # 'g'
    104: 0,  # 'h'
    105: 0,  # 'i'
    106: 0,  # 'j'
    107: 0,  # 'k'
    108: 0,  # 'l'
    109: 0,  # 'm'
    110: 0,  # 'n'
    111: 0,  # 'o'
    112: 0,  # 'p'
    113: 0,  # 'q'
    114: 0,  # 'r'
    115: 0,  # 's'
    116: 0,  # 't'
    117: 0,  # 'u'
    118: 0,  # 'v'
    119: 0,  # 'w'
    120: 0,  # 'x'
    121: 0,  # 'y'
    122: 0,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 39,  # 'А'
    129: 47,  # 'Б'
    130: 34,  # 'В'
    131: 48,  # 'Г'
    132: 40,  # 'Д'
    133: 54,  # 'Е'
    134: 60,  # 'Ж'
    135: 44,  # 'З'
    136: 46,  # 'И'
    137: 62,  # 'Й'
    138: 36,  # 'К'
    139: 49,  # 'Л'
    140: 42,  # 'М'
    141: 37,  # 'Н'
    142: 41,  # 'О'
    143: 33,  # 'П'
    144: 45,  # 'Р'
    145: 35,  # 'С'
    146: 43,  # 'Т'
    147: 38,  # 'У'
    148: 53,  # 'Ф'
    149: 55,  # 'Х'
    150: 51,  # 'Ц'
    151: 52,  # 'Ч'
    152: 56,  # 'Ш'
    153: 59,  # 'Щ'
    154: 0,  # 'Ъ'
    155: 0,  # 'Ы'
    156: 64,  # 'Ь'
    157: 0,  # 'Э'
    158: 61,  # 'Ю'
    159: 50,  # 'Я'
    160: 2,  # 'а'
    161: 21,  # 'б'
    162: 7,  # 'в'
    163: 20,  # 'г'
    164: 13,  # 'д'
    165: 9,  # 'е'
    166: 26,  # 'ж'
    167: 18,  # 'з'
    168: 5,  # 'и'
    169: 23,  # 'й'
    170: 11,  # 'к'
    171: 12,  # 'л'
    172: 15,  # 'м'
    173: 3,  # 'н'
    174: 1,  # 'о'
    175: 16,  # 'п'
    176: CharacterCategory.SYMBOL,  # '░'
    177: CharacterCategory.SYMBOL,  # '▒'
    178: CharacterCategory.SYMBOL,  # '▓'
    179: CharacterCategory.SYMBOL,  # '│'
    180: CharacterCategory.SYMBOL,  # '┤'
    181: CharacterCategory.SYMBOL,  # '╡'
    182: CharacterCategory.SYMBOL,  # '╢'
    183: CharacterCategory.SYMBOL,  # '╖'
    184: CharacterCategory.SYMBOL,  # '╕'
    185: CharacterCategory.SYMBOL,  # '╣'
    186: CharacterCategory.SYMBOL,  # '║'
    187: CharacterCategory.SYMBOL,  # '╗'
    188: CharacterCategory.SYMBOL,  # '╝'
    189: CharacterCategory.SYMBOL,  # '╜'
    190: CharacterCategory.SYMBOL,  # '╛'
    191: CharacterCategory.SYMBOL,  # '┐'
    192: CharacterCategory.SYMBOL,  # '└'
    193: CharacterCategory.SYMBOL,  # '┴'
    194: CharacterCategory.SYMBOL,  # '┬'
    195: CharacterCategory.SYMBOL,  # '├'
    196: CharacterCategory.SYMBOL,  # '─'
    197: CharacterCategory.SYMBOL,  # '┼'
    198: CharacterCategory.SYMBOL,  # '╞'
    199: CharacterCategory.SYMBOL,  # '╟'
    200: CharacterCategory.SYMBOL,  # '╚'
    201: CharacterCategory.SYMBOL,  # '╔'
    202: CharacterCategory.SYMBOL,  # '╩'
    203: CharacterCategory.SYMBOL,  # '╦'
    204: CharacterCategory.SYMBOL,  # '╠'
    205: CharacterCategory.SYMBOL,  # '═'
    206: CharacterCategory.SYMBOL,  # '╬'
    207: CharacterCategory.SYMBOL,  # '╧'
    208: CharacterCategory.SYMBOL,  # '╨'
    209: CharacterCategory.SYMBOL,  # '╤'
    210: CharacterCategory.SYMBOL,  # '╥'
    211: CharacterCategory.SYMBOL,  # '╙'
    212: CharacterCategory.SYMBOL,  # '╘'
    213: CharacterCategory.SYMBOL,  # '╒'
    214: CharacterCategory.SYMBOL,  # '╓'
    215: CharacterCategory.SYMBOL,  # '╫'
    216: CharacterCategory.SYMBOL,  # '╪'
    217: CharacterCategory.SYMBOL,  # '┘'
    218: CharacterCategory.SYMBOL,  # '┌'
    219: CharacterCategory.SYMBOL,  # '█'
    220: CharacterCategory.SYMBOL,  # '▄'
    221: CharacterCategory.SYMBOL,  # '▌'
    222: CharacterCategory.SYMBOL,  # '▐'
    223: CharacterCategory.SYMBOL,  # '▀'
    224: 8,  # 'р'
    225: 10,  # 'с'
    226: 6,  # 'т'
    227: 14,  # 'у'
    228: 32,  # 'ф'
    229: 24,  # 'х'
    230: 25,  # 'ц'
    231: 22,  # 'ч'
    232: 29,  # 'ш'
    233: 31,  # 'щ'
    234: 0,  # 'ъ'
    235: 0,  # 'ы'
    236: 19,  # 'ь'
    237: 0,  # 'э'
    238: 27,  # 'ю'
    239: 17,  # 'я'
    240: 0,  # 'Ё'
    241: 0,  # 'ё'
    242: 57,  # 'Є'
    243: 30,  # 'є'
    244: 63,  # 'Ї'
    245: 28,  # 'ї'
    246: 0,  # 'Ў'
    247: 0,  # 'ў'
    248: CharacterCategory.SYMBOL,  # '°'
    249: CharacterCategory.SYMBOL,  # '∙'
    250: CharacterCategory.SYMBOL,  # '·'
    251: CharacterCategory.SYMBOL,  # '√'
    252: CharacterCategory.SYMBOL,  # '№'
    253: CharacterCategory.SYMBOL,  # '¤'
    254: CharacterCategory.SYMBOL,  # '■'
    255: CharacterCategory.CONTROL,  # '\xa0'
}

CP866_UKRAINIAN_MODEL = SingleByteCharSetModel(
    charset_name="CP866",
    language="Ukrainian",
    char_to_order_map=CP866_UKRAINIAN_CHAR_TO_ORDER,
    language_model=UKRAINIAN_LANG_MODEL,
    typical_positive_ratio=0.9716748990594304,
    keep_ascii_letters=False,
    alphabet="ʼЄІЇАБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЬЮЯабвгдежзийклмнопрстуфхцчшщьюяєіїҐґ",
)

CP1125_UKRAINIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 0,  # 'A'
    66: 0,  # 'B'
    67: 0,  # 'C'
    68: 0,  # 'D'
    69: 0,  # 'E'
    70: 0,  # 'F'
    71: 0,  # 'G'
    72: 0,  # 'H'
    73: 0,  # 'I'
    74: 0,  # 'J'
    75: 0,  # 'K'
    76: 0,  # 'L'
    77: 0,  # 'M'
    78: 0,  # 'N'
    79: 0,  # 'O'
    80: 0,  # 'P'
    81: 0,  # 'Q'
    82: 0,  # 'R'
    83: 0,  # 'S'
    84: 0,  # 'T'
    85: 0,  # 'U'
    86: 0,  # 'V'
    87: 0,  # 'W'
    88: 0,  # 'X'
    89: 0,  # 'Y'
    90: 0,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 0,  # 'a'
    98: 0,  # 'b'
    99: 0,  # 'c'
    100: 0,  # 'd'
    101: 0,  # 'e'
    102: 0,  # 'f'
    103: 0,  # 'g'
    104: 0,  # 'h'
    105: 0,  # 'i'
    106: 0,  # 'j'
    107: 0,  # 'k'
    108: 0,  # 'l'
    109: 0,  # 'm'
    110: 0,  # 'n'
    111: 0,  # 'o'
    112: 0,  # 'p'
    113: 0,  # 'q'
    114: 0,  # 'r'
    115: 0,  # 's'
    116: 0,  # 't'
    117: 0,  # 'u'
    118: 0,  # 'v'
    119: 0,  # 'w'
    120: 0,  # 'x'
    121: 0,  # 'y'
    122: 0,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 39,  # 'А'
    129: 47,  # 'Б'
    130: 34,  # 'В'
    131: 48,  # 'Г'
    132: 40,  # 'Д'
    133: 54,  # 'Е'
    134: 60,  # 'Ж'
    135: 44,  # 'З'
    136: 58,  # 'И'
    137: 62,  # 'Й'
    138: 36,  # 'К'
    139: 49,  # 'Л'
    140: 42,  # 'М'
    141: 37,  # 'Н'
    142: 41,  # 'О'
    143: 33,  # 'П'
    144: 45,  # 'Р'
    145: 35,  # 'С'
    146: 43,  # 'Т'
    147: 38,  # 'У'
    148: 53,  # 'Ф'
    149: 55,  # 'Х'
    150: 51,  # 'Ц'
    151: 52,  # 'Ч'
    152: 56,  # 'Ш'
    153: 59,  # 'Щ'
    154: 0,  # 'Ъ'
    155: 0,  # 'Ы'
    156: 64,  # 'Ь'
    157: 0,  # 'Э'
    158: 61,  # 'Ю'
    159: 50,  # 'Я'
    160: 2,  # 'а'
    161: 21,  # 'б'
    162: 7,  # 'в'
    163: 20,  # 'г'
    164: 13,  # 'д'
    165: 9,  # 'е'
    166: 26,  # 'ж'
    167: 18,  # 'з'
    168: 4,  # 'и'
    169: 23,  # 'й'
    170: 11,  # 'к'
    171: 12,  # 'л'
    172: 15,  # 'м'
    173: 3,  # 'н'
    174: 1,  # 'о'
    175: 16,  # 'п'
    176: CharacterCategory.SYMBOL,  # '░'
    177: CharacterCategory.SYMBOL,  # '▒'
    178: CharacterCategory.SYMBOL,  # '▓'
    179: CharacterCategory.SYMBOL,  # '│'
    180: CharacterCategory.SYMBOL,  # '┤'
    181: CharacterCategory.SYMBOL,  # '╡'
    182: CharacterCategory.SYMBOL,  # '╢'
    183: CharacterCategory.SYMBOL,  # '╖'
    184: CharacterCategory.SYMBOL,  # '╕'
    185: CharacterCategory.SYMBOL,  # '╣'
    186: CharacterCategory.SYMBOL,  # '║'
    187: CharacterCategory.SYMBOL,  # '╗'
    188: CharacterCategory.SYMBOL,  # '╝'
    189: CharacterCategory.SYMBOL,  # '╜'
    190: CharacterCategory.SYMBOL,  # '╛'
    191: CharacterCategory.SYMBOL,  # '┐'
    192: CharacterCategory.SYMBOL,  # '└'
    193: CharacterCategory.SYMBOL,  # '┴'
    194: CharacterCategory.SYMBOL,  # '┬'
    195: CharacterCategory.SYMBOL,  # '├'
    196: CharacterCategory.SYMBOL,  # '─'
    197: CharacterCategory.SYMBOL,  # '┼'
    198: CharacterCategory.SYMBOL,  # '╞'
    199: CharacterCategory.SYMBOL,  # '╟'
    200: CharacterCategory.SYMBOL,  # '╚'
    201: CharacterCategory.SYMBOL,  # '╔'
    202: CharacterCategory.SYMBOL,  # '╩'
    203: CharacterCategory.SYMBOL,  # '╦'
    204: CharacterCategory.SYMBOL,  # '╠'
    205: CharacterCategory.SYMBOL,  # '═'
    206: CharacterCategory.SYMBOL,  # '╬'
    207: CharacterCategory.SYMBOL,  # '╧'
    208: CharacterCategory.SYMBOL,  # '╨'
    209: CharacterCategory.SYMBOL,  # '╤'
    210: CharacterCategory.SYMBOL,  # '╥'
    211: CharacterCategory.SYMBOL,  # '╙'
    212: CharacterCategory.SYMBOL,  # '╘'
    213: CharacterCategory.SYMBOL,  # '╒'
    214: CharacterCategory.SYMBOL,  # '╓'
    215: CharacterCategory.SYMBOL,  # '╫'
    216: CharacterCategory.SYMBOL,  # '╪'
    217: CharacterCategory.SYMBOL,  # '┘'
    218: CharacterCategory.SYMBOL,  # '┌'
    219: CharacterCategory.SYMBOL,  # '█'
    220: CharacterCategory.SYMBOL,  # '▄'
    221: CharacterCategory.SYMBOL,  # '▌'
    222: CharacterCategory.SYMBOL,  # '▐'
    223: CharacterCategory.SYMBOL,  # '▀'
    224: 8,  # 'р'
    225: 10,  # 'с'
    226: 6,  # 'т'
    227: 14,  # 'у'
    228: 32,  # 'ф'
    229: 24,  # 'х'
    230: 25,  # 'ц'
    231: 22,  # 'ч'
    232: 29,  # 'ш'
    233: 31,  # 'щ'
    234: 0,  # 'ъ'
    235: 0,  # 'ы'
    236: 19,  # 'ь'
    237: 0,  # 'э'
    238: 27,  # 'ю'
    239: 17,  # 'я'
    240: 0,  # 'Ё'
    241: 0,  # 'ё'
    242: 66,  # 'Ґ'
    243: 65,  # 'ґ'
    244: 57,  # 'Є'
    245: 30,  # 'є'
    246: 46,  # 'І'
    247: 5,  # 'і'
    248: 63,  # 'Ї'
    249: 28,  # 'ї'
    250: CharacterCategory.SYMBOL,  # '·'
    251: CharacterCategory.SYMBOL,  # '√'
    252: CharacterCategory.SYMBOL,  # '№'
    253: CharacterCategory.SYMBOL,  # '¤'
    254: CharacterCategory.SYMBOL,  # '■'
    255: CharacterCategory.CONTROL,  # '\xa0'
}

CP1125_UKRAINIAN_MODEL = SingleByteCharSetModel(
    charset_name="CP1125",
    language="Ukrainian",
    char_to_order_map=CP1125_UKRAINIAN_CHAR_TO_ORDER,
    language_model=UKRAINIAN_LANG_MODEL,
    typical_positive_ratio=0.9727888617453615,
    keep_ascii_letters=False,
    alphabet="ʼЄІЇАБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЬЮЯабвгдежзийклмнопрстуфхцчшщьюяєіїҐґ",
)

ISO_8859_5_UKRAINIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 0,  # 'A'
    66: 0,  # 'B'
    67: 0,  # 'C'
    68: 0,  # 'D'
    69: 0,  # 'E'
    70: 0,  # 'F'
    71: 0,  # 'G'
    72: 0,  # 'H'
    73: 0,  # 'I'
    74: 0,  # 'J'
    75: 0,  # 'K'
    76: 0,  # 'L'
    77: 0,  # 'M'
    78: 0,  # 'N'
    79: 0,  # 'O'
    80: 0,  # 'P'
    81: 0,  # 'Q'
    82: 0,  # 'R'
    83: 0,  # 'S'
    84: 0,  # 'T'
    85: 0,  # 'U'
    86: 0,  # 'V'
    87: 0,  # 'W'
    88: 0,  # 'X'
    89: 0,  # 'Y'
    90: 0,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 0,  # 'a'
    98: 0,  # 'b'
    99: 0,  # 'c'
    100: 0,  # 'd'
    101: 0,  # 'e'
    102: 0,  # 'f'
    103: 0,  # 'g'
    104: 0,  # 'h'
    105: 0,  # 'i'
    106: 0,  # 'j'
    107: 0,  # 'k'
    108: 0,  # 'l'
    109: 0,  # 'm'
    110: 0,  # 'n'
    111: 0,  # 'o'
    112: 0,  # 'p'
    113: 0,  # 'q'
    114: 0,  # 'r'
    115: 0,  # 's'
    116: 0,  # 't'
    117: 0,  # 'u'
    118: 0,  # 'v'
    119: 0,  # 'w'
    120: 0,  # 'x'
    121: 0,  # 'y'
    122: 0,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.CONTROL,  # '\x80'
    129: CharacterCategory.CONTROL,  # '\x81'
    130: CharacterCategory.CONTROL,  # '\x82'
    131: CharacterCategory.CONTROL,  # '\x83'
    132: CharacterCategory.CONTROL,  # '\x84'
    133: CharacterCategory.CONTROL,  # '\x85'
    134: CharacterCategory.CONTROL,  # '\x86'
    135: CharacterCategory.CONTROL,  # '\x87'
    136: CharacterCategory.CONTROL,  # '\x88'
    137: CharacterCategory.CONTROL,  # '\x89'
    138: CharacterCategory.CONTROL,  # '\x8a'
    139: CharacterCategory.CONTROL,  # '\x8b'
    140: CharacterCategory.CONTROL,  # '\x8c'
    141: CharacterCategory.CONTROL,  # '\x8d'
    142: CharacterCategory.CONTROL,  # '\x8e'
    143: CharacterCategory.CONTROL,  # '\x8f'
    144: CharacterCategory.CONTROL,  # '\x90'
    145: CharacterCategory.CONTROL,  # '\x91'
    146: CharacterCategory.CONTROL,  # '\x92'
    147: CharacterCategory.CONTROL,  # '\x93'
    148: CharacterCategory.CONTROL,  # '\x94'
    149: CharacterCategory.CONTROL,  # '\x95'
    150: CharacterCategory.CONTROL,  # '\x96'
    151: CharacterCategory.CONTROL,  # '\x97'
    152: CharacterCategory.CONTROL,  # '\x98'
    153: CharacterCategory.CONTROL,  # '\x99'
    154: CharacterCategory.CONTROL,  # '\x9a'
    155: CharacterCategory.CONTROL,  # '\x9b'
    156: CharacterCategory.CONTROL,  # '\x9c'
    157: CharacterCategory.CONTROL,  # '\x9d'
    158: CharacterCategory.CONTROL,  # '\x9e'
    159: CharacterCategory.CONTROL,  # '\x9f'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: 0,  # 'Ё'
    162: 0,  # 'Ђ'
    163: 0,  # 'Ѓ'
    164: 57,  # 'Є'
    165: 0,  # 'Ѕ'
    166: 46,  # 'І'
    167: 63,  # 'Ї'
    168: 0,  # 'Ј'
    169: 0,  # 'Љ'
    170: 0,  # 'Њ'
    171: 0,  # 'Ћ'
    172: 0,  # 'Ќ'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: 0,  # 'Ў'
    175: 0,  # 'Џ'
    176: 39,  # 'А'
    177: 47,  # 'Б'
    178: 34,  # 'В'
    179: 48,  # 'Г'
    180: 40,  # 'Д'
    181: 54,  # 'Е'
    182: 60,  # 'Ж'
    183: 44,  # 'З'
    184: 58,  # 'И'
    185: 62,  # 'Й'
    186: 36,  # 'К'
    187: 49,  # 'Л'
    188: 42,  # 'М'
    189: 37,  # 'Н'
    190: 41,  # 'О'
    191: 33,  # 'П'
    192: 45,  # 'Р'
    193: 35,  # 'С'
    194: 43,  # 'Т'
    195: 38,  # 'У'
    196: 53,  # 'Ф'
    197: 55,  # 'Х'
    198: 51,  # 'Ц'
    199: 52,  # 'Ч'
    200: 56,  # 'Ш'
    201: 59,  # 'Щ'
    202: 0,  # 'Ъ'
    203: 0,  # 'Ы'
    204: 64,  # 'Ь'
    205: 0,  # 'Э'
    206: 61,  # 'Ю'
    207: 50,  # 'Я'
    208: 2,  # 'а'
    209: 21,  # 'б'
    210: 7,  # 'в'
    211: 20,  # 'г'
    212: 13,  # 'д'
    213: 9,  # 'е'
    214: 26,  # 'ж'
    215: 18,  # 'з'
    216: 4,  # 'и'
    217: 23,  # 'й'
    218: 11,  # 'к'
    219: 12,  # 'л'
    220: 15,  # 'м'
    221: 3,  # 'н'
    222: 1,  # 'о'
    223: 16,  # 'п'
    224: 8,  # 'р'
    225: 10,  # 'с'
    226: 6,  # 'т'
    227: 14,  # 'у'
    228: 32,  # 'ф'
    229: 24,  # 'х'
    230: 25,  # 'ц'
    231: 22,  # 'ч'
    232: 29,  # 'ш'
    233: 31,  # 'щ'
    234: 0,  # 'ъ'
    235: 0,  # 'ы'
    236: 19,  # 'ь'
    237: 0,  # 'э'
    238: 27,  # 'ю'
    239: 17,  # 'я'
    240: CharacterCategory.SYMBOL,  # '№'
    241: 0,  # 'ё'
    242: 0,  # 'ђ'
    243: 0,  # 'ѓ'
    244: 30,  # 'є'
    245: 0,  # 'ѕ'
    246: 5,  # 'і'
    247: 28,  # 'ї'
    248: 0,  # 'ј'
    249: 0,  # 'љ'
    250: 0,  # 'њ'
    251: 0,  # 'ћ'
    252: 0,  # 'ќ'
    253: CharacterCategory.SYMBOL,  # '§'
    254: 0,  # 'ў'
    255: 0,  # 'џ'
}

ISO_8859_5_UKRAINIAN_MODEL = SingleByteCharSetModel(
    charset_name="ISO-8859-5",
    language="Ukrainian",
    char_to_order_map=ISO_8859_5_UKRAINIAN_CHAR_TO_ORDER,
    language_model=UKRAINIAN_LANG_MODEL,
    typical_positive_ratio=0.972901294935246,
    keep_ascii_letters=False,
    alphabet="ʼЄІЇАБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЬЮЯабвгдежзийклмнопрстуфхцчшщьюяєіїҐґ",
)

KOI8_R_UKRAINIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 0,  # 'A'
    66: 0,  # 'B'
    67: 0,  # 'C'
    68: 0,  # 'D'
    69: 0,  # 'E'
    70: 0,  # 'F'
    71: 0,  # 'G'
    72: 0,  # 'H'
    73: 0,  # 'I'
    74: 0,  # 'J'
    75: 0,  # 'K'
    76: 0,  # 'L'
    77: 0,  # 'M'
    78: 0,  # 'N'
    79: 0,  # 'O'
    80: 0,  # 'P'
    81: 0,  # 'Q'
    82: 0,  # 'R'
    83: 0,  # 'S'
    84: 0,  # 'T'
    85: 0,  # 'U'
    86: 0,  # 'V'
    87: 0,  # 'W'
    88: 0,  # 'X'
    89: 0,  # 'Y'
    90: 0,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 0,  # 'a'
    98: 0,  # 'b'
    99: 0,  # 'c'
    100: 0,  # 'd'
    101: 0,  # 'e'
    102: 0,  # 'f'
    103: 0,  # 'g'
    104: 0,  # 'h'
    105: 0,  # 'i'
    106: 0,  # 'j'
    107: 0,  # 'k'
    108: 0,  # 'l'
    109: 0,  # 'm'
    110: 0,  # 'n'
    111: 0,  # 'o'
    112: 0,  # 'p'
    113: 0,  # 'q'
    114: 0,  # 'r'
    115: 0,  # 's'
    116: 0,  # 't'
    117: 0,  # 'u'
    118: 0,  # 'v'
    119: 0,  # 'w'
    120: 0,  # 'x'
    121: 0,  # 'y'
    122: 0,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.SYMBOL,  # '─'
    129: CharacterCategory.SYMBOL,  # '│'
    130: CharacterCategory.SYMBOL,  # '┌'
    131: CharacterCategory.SYMBOL,  # '┐'
    132: CharacterCategory.SYMBOL,  # '└'
    133: CharacterCategory.SYMBOL,  # '┘'
    134: CharacterCategory.SYMBOL,  # '├'
    135: CharacterCategory.SYMBOL,  # '┤'
    136: CharacterCategory.SYMBOL,  # '┬'
    137: CharacterCategory.SYMBOL,  # '┴'
    138: CharacterCategory.SYMBOL,  # '┼'
    139: CharacterCategory.SYMBOL,  # '▀'
    140: CharacterCategory.SYMBOL,  # '▄'
    141: CharacterCategory.SYMBOL,  # '█'
    142: CharacterCategory.SYMBOL,  # '▌'
    143: CharacterCategory.SYMBOL,  # '▐'
    144: CharacterCategory.SYMBOL,  # '░'
    145: CharacterCategory.SYMBOL,  # '▒'
    146: CharacterCategory.SYMBOL,  # '▓'
    147: CharacterCategory.SYMBOL,  # '⌠'
    148: CharacterCategory.SYMBOL,  # '■'
    149: CharacterCategory.SYMBOL,  # '∙'
    150: CharacterCategory.SYMBOL,  # '√'
    151: CharacterCategory.SYMBOL,  # '≈'
    152: CharacterCategory.SYMBOL,  # '≤'
    153: CharacterCategory.SYMBOL,  # '≥'
    154: CharacterCategory.CONTROL,  # '\xa0'
    155: CharacterCategory.SYMBOL,  # '⌡'
    156: CharacterCategory.SYMBOL,  # '°'
    157: CharacterCategory.DIGIT,  # '²'
    158: CharacterCategory.SYMBOL,  # '·'
    159: CharacterCategory.SYMBOL,  # '÷'
    160: CharacterCategory.SYMBOL,  # '═'
    161: CharacterCategory.SYMBOL,  # '║'
    162: CharacterCategory.SYMBOL,  # '╒'
    163: 0,  # 'ё'
    164: CharacterCategory.SYMBOL,  # '╓'
    165: CharacterCategory.SYMBOL,  # '╔'
    166: CharacterCategory.SYMBOL,  # '╕'
    167: CharacterCategory.SYMBOL,  # '╖'
    168: CharacterCategory.SYMBOL,  # '╗'
    169: CharacterCategory.SYMBOL,  # '╘'
    170: CharacterCategory.SYMBOL,  # '╙'
    171: CharacterCategory.SYMBOL,  # '╚'
    172: CharacterCategory.SYMBOL,  # '╛'
    173: CharacterCategory.SYMBOL,  # '╜'
    174: CharacterCategory.SYMBOL,  # '╝'
    175: CharacterCategory.SYMBOL,  # '╞'
    176: CharacterCategory.SYMBOL,  # '╟'
    177: CharacterCategory.SYMBOL,  # '╠'
    178: CharacterCategory.SYMBOL,  # '╡'
    179: 0,  # 'Ё'
    180: CharacterCategory.SYMBOL,  # '╢'
    181: CharacterCategory.SYMBOL,  # '╣'
    182: CharacterCategory.SYMBOL,  # '╤'
    183: CharacterCategory.SYMBOL,  # '╥'
    184: CharacterCategory.SYMBOL,  # '╦'
    185: CharacterCategory.SYMBOL,  # '╧'
    186: CharacterCategory.SYMBOL,  # '╨'
    187: CharacterCategory.SYMBOL,  # '╩'
    188: CharacterCategory.SYMBOL,  # '╪'
    189: CharacterCategory.SYMBOL,  # '╫'
    190: CharacterCategory.SYMBOL,  # '╬'
    191: CharacterCategory.SYMBOL,  # '©'
    192: 27,  # 'ю'
    193: 2,  # 'а'
    194: 21,  # 'б'
    195: 25,  # 'ц'
    196: 13,  # 'д'
    197: 9,  # 'е'
    198: 32,  # 'ф'
    199: 20,  # 'г'
    200: 24,  # 'х'
    201: 4,  # 'и'
    202: 23,  # 'й'
    203: 11,  # 'к'
    204: 12,  # 'л'
    205: 15,  # 'м'
    206: 3,  # 'н'
    207: 1,  # 'о'
    208: 16,  # 'п'
    209: 17,  # 'я'
    210: 8,  # 'р'
    211: 10,  # 'с'
    212: 6,  # 'т'
    213: 14,  # 'у'
    214: 26,  # 'ж'
    215: 7,  # 'в'
    216: 19,  # 'ь'
    217: 0,  # 'ы'
    218: 18,  # 'з'
    219: 29,  # 'ш'
    220: 0,  # 'э'
    221: 31,  # 'щ'
    222: 22,  # 'ч'
    223: 0,  # 'ъ'
    224: 61,  # 'Ю'
    225: 39,  # 'А'
    226: 47,  # 'Б'
    227: 51,  # 'Ц'
    228: 40,  # 'Д'
    229: 54,  # 'Е'
    230: 53,  # 'Ф'
    231: 48,  # 'Г'
    232: 55,  # 'Х'
    233: 58,  # 'И'
    234: 62,  # 'Й'
    235: 36,  # 'К'
    236: 49,  # 'Л'
    237: 42,  # 'М'
    238: 37,  # 'Н'
    239: 41,  # 'О'
    240: 33,  # 'П'
    241: 50,  # 'Я'
    242: 45,  # 'Р'
    243: 35,  # 'С'
    244: 43,  # 'Т'
    245: 38,  # 'У'
    246: 60,  # 'Ж'
    247: 34,  # 'В'
    248: 64,  # 'Ь'
    249: 0,  # 'Ы'
    250: 44,  # 'З'
    251: 56,  # 'Ш'
    252: 0,  # 'Э'
    253: 59,  # 'Щ'
    254: 52,  # 'Ч'
    255: 0,  # 'Ъ'
}

KOI8_R_UKRAINIAN_MODEL = SingleByteCharSetModel(
    charset_name="KOI8-R",
    language="Ukrainian",
    char_to_order_map=KOI8_R_UKRAINIAN_CHAR_TO_ORDER,
    language_model=UKRAINIAN_LANG_MODEL,
    typical_positive_ratio=0.9730370170750058,
    keep_ascii_letters=False,
    alphabet="ʼЄІЇАБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЬЮЯабвгдежзийклмнопрстуфхцчшщьюяєіїҐґ",
)

KOI8_U_UKRAINIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 0,  # 'A'
    66: 0,  # 'B'
    67: 0,  # 'C'
    68: 0,  # 'D'
    69: 0,  # 'E'
    70: 0,  # 'F'
    71: 0,  # 'G'
    72: 0,  # 'H'
    73: 0,  # 'I'
    74: 0,  # 'J'
    75: 0,  # 'K'
    76: 0,  # 'L'
    77: 0,  # 'M'
    78: 0,  # 'N'
    79: 0,  # 'O'
    80: 0,  # 'P'
    81: 0,  # 'Q'
    82: 0,  # 'R'
    83: 0,  # 'S'
    84: 0,  # 'T'
    85: 0,  # 'U'
    86: 0,  # 'V'
    87: 0,  # 'W'
    88: 0,  # 'X'
    89: 0,  # 'Y'
    90: 0,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 0,  # 'a'
    98: 0,  # 'b'
    99: 0,  # 'c'
    100: 0,  # 'd'
    101: 0,  # 'e'
    102: 0,  # 'f'
    103: 0,  # 'g'
    104: 0,  # 'h'
    105: 0,  # 'i'
    106: 0,  # 'j'
    107: 0,  # 'k'
    108: 0,  # 'l'
    109: 0,  # 'm'
    110: 0,  # 'n'
    111: 0,  # 'o'
    112: 0,  # 'p'
    113: 0,  # 'q'
    114: 0,  # 'r'
    115: 0,  # 's'
    116: 0,  # 't'
    117: 0,  # 'u'
    118: 0,  # 'v'
    119: 0,  # 'w'
    120: 0,  # 'x'
    121: 0,  # 'y'
    122: 0,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.SYMBOL,  # '─'
    129: CharacterCategory.SYMBOL,  # '│'
    130: CharacterCategory.SYMBOL,  # '┌'
    131: CharacterCategory.SYMBOL,  # '┐'
    132: CharacterCategory.SYMBOL,  # '└'
    133: CharacterCategory.SYMBOL,  # '┘'
    134: CharacterCategory.SYMBOL,  # '├'
    135: CharacterCategory.SYMBOL,  # '┤'
    136: CharacterCategory.SYMBOL,  # '┬'
    137: CharacterCategory.SYMBOL,  # '┴'
    138: CharacterCategory.SYMBOL,  # '┼'
    139: CharacterCategory.SYMBOL,  # '▀'
    140: CharacterCategory.SYMBOL,  # '▄'
    141: CharacterCategory.SYMBOL,  # '█'
    142: CharacterCategory.SYMBOL,  # '▌'
    143: CharacterCategory.SYMBOL,  # '▐'
    144: CharacterCategory.SYMBOL,  # '░'
    145: CharacterCategory.SYMBOL,  # '▒'
    146: CharacterCategory.SYMBOL,  # '▓'
    147: CharacterCategory.SYMBOL,  # '⌠'
    148: CharacterCategory.SYMBOL,  # '■'
    149: CharacterCategory.SYMBOL,  # '∙'
    150: CharacterCategory.SYMBOL,  # '√'
    151: CharacterCategory.SYMBOL,  # '≈'
    152: CharacterCategory.SYMBOL,  # '≤'
    153: CharacterCategory.SYMBOL,  # '≥'
    154: CharacterCategory.CONTROL,  # '\xa0'
    155: CharacterCategory.SYMBOL,  # '⌡'
    156: CharacterCategory.SYMBOL,  # '°'
    157: CharacterCategory.DIGIT,  # '²'
    158: CharacterCategory.SYMBOL,  # '·'
    159: CharacterCategory.SYMBOL,  # '÷'
    160: CharacterCategory.SYMBOL,  # '═'
    161: CharacterCategory.SYMBOL,  # '║'
    162: CharacterCategory.SYMBOL,  # '╒'
    163: 0,  # 'ё'
    164: 30,  # 'є'
    165: CharacterCategory.SYMBOL,  # '╔'
    166: 5,  # 'і'
    167: 28,  # 'ї'
    168: CharacterCategory.SYMBOL,  # '╗'
    169: CharacterCategory.SYMBOL,  # '╘'
    170: CharacterCategory.SYMBOL,  # '╙'
    171: CharacterCategory.SYMBOL,  # '╚'
    172: CharacterCategory.SYMBOL,  # '╛'
    173: 65,  # 'ґ'
    174: CharacterCategory.SYMBOL,  # '╝'
    175: CharacterCategory.SYMBOL,  # '╞'
    176: CharacterCategory.SYMBOL,  # '╟'
    177: CharacterCategory.SYMBOL,  # '╠'
    178: CharacterCategory.SYMBOL,  # '╡'
    179: 0,  # 'Ё'
    180: 57,  # 'Є'
    181: CharacterCategory.SYMBOL,  # '╣'
    182: 46,  # 'І'
    183: 63,  # 'Ї'
    184: CharacterCategory.SYMBOL,  # '╦'
    185: CharacterCategory.SYMBOL,  # '╧'
    186: CharacterCategory.SYMBOL,  # '╨'
    187: CharacterCategory.SYMBOL,  # '╩'
    188: CharacterCategory.SYMBOL,  # '╪'
    189: 66,  # 'Ґ'
    190: CharacterCategory.SYMBOL,  # '╬'
    191: CharacterCategory.SYMBOL,  # '©'
    192: 27,  # 'ю'
    193: 2,  # 'а'
    194: 21,  # 'б'
    195: 25,  # 'ц'
    196: 13,  # 'д'
    197: 9,  # 'е'
    198: 32,  # 'ф'
    199: 20,  # 'г'
    200: 24,  # 'х'
    201: 4,  # 'и'
    202: 23,  # 'й'
    203: 11,  # 'к'
    204: 12,  # 'л'
    205: 15,  # 'м'
    206: 3,  # 'н'
    207: 1,  # 'о'
    208: 16,  # 'п'
    209: 17,  # 'я'
    210: 8,  # 'р'
    211: 10,  # 'с'
    212: 6,  # 'т'
    213: 14,  # 'у'
    214: 26,  # 'ж'
    215: 7,  # 'в'
    216: 19,  # 'ь'
    217: 0,  # 'ы'
    218: 18,  # 'з'
    219: 29,  # 'ш'
    220: 0,  # 'э'
    221: 31,  # 'щ'
    222: 22,  # 'ч'
    223: 0,  # 'ъ'
    224: 61,  # 'Ю'
    225: 39,  # 'А'
    226: 47,  # 'Б'
    227: 51,  # 'Ц'
    228: 40,  # 'Д'
    229: 54,  # 'Е'
    230: 53,  # 'Ф'
    231: 48,  # 'Г'
    232: 55,  # 'Х'
    233: 58,  # 'И'
    234: 62,  # 'Й'
    235: 36,  # 'К'
    236: 49,  # 'Л'
    237: 42,  # 'М'
    238: 37,  # 'Н'
    239: 41,  # 'О'
    240: 33,  # 'П'
    241: 50,  # 'Я'
    242: 45,  # 'Р'
    243: 35,  # 'С'
    244: 43,  # 'Т'
    245: 38,  # 'У'
    246: 60,  # 'Ж'
    247: 34,  # 'В'
    248: 64,  # 'Ь'
    249: 0,  # 'Ы'
    250: 44,  # 'З'
    251: 56,  # 'Ш'
    252: 0,  # 'Э'
    253: 59,  # 'Щ'
    254: 52,  # 'Ч'
    255: 0,  # 'Ъ'
}

KOI8_U_UKRAINIAN_MODEL = SingleByteCharSetModel(
    charset_name="KOI8-U",
    language="Ukrainian",
    char_to_order_map=KOI8_U_UKRAINIAN_CHAR_TO_ORDER,
    language_model=UKRAINIAN_LANG_MODEL,
    typical_positive_ratio=0.9727888617453615,
    keep_ascii_letters=False,
    alphabet="ʼЄІЇАБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЬЮЯабвгдежзийклмнопрстуфхцчшщьюяєіїҐґ",
)

MACCYRILLIC_UKRAINIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 0,  # 'A'
    66: 0,  # 'B'
    67: 0,  # 'C'
    68: 0,  # 'D'
    69: 0,  # 'E'
    70: 0,  # 'F'
    71: 0,  # 'G'
    72: 0,  # 'H'
    73: 0,  # 'I'
    74: 0,  # 'J'
    75: 0,  # 'K'
    76: 0,  # 'L'
    77: 0,  # 'M'
    78: 0,  # 'N'
    79: 0,  # 'O'
    80: 0,  # 'P'
    81: 0,  # 'Q'
    82: 0,  # 'R'
    83: 0,  # 'S'
    84: 0,  # 'T'
    85: 0,  # 'U'
    86: 0,  # 'V'
    87: 0,  # 'W'
    88: 0,  # 'X'
    89: 0,  # 'Y'
    90: 0,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 0,  # 'a'
    98: 0,  # 'b'
    99: 0,  # 'c'
    100: 0,  # 'd'
    101: 0,  # 'e'
    102: 0,  # 'f'
    103: 0,  # 'g'
    104: 0,  # 'h'
    105: 0,  # 'i'
    106: 0,  # 'j'
    107: 0,  # 'k'
    108: 0,  # 'l'
    109: 0,  # 'm'
    110: 0,  # 'n'
    111: 0,  # 'o'
    112: 0,  # 'p'
    113: 0,  # 'q'
    114: 0,  # 'r'
    115: 0,  # 's'
    116: 0,  # 't'
    117: 0,  # 'u'
    118: 0,  # 'v'
    119: 0,  # 'w'
    120: 0,  # 'x'
    121: 0,  # 'y'
    122: 0,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 39,  # 'А'
    129: 47,  # 'Б'
    130: 34,  # 'В'
    131: 48,  # 'Г'
    132: 40,  # 'Д'
    133: 54,  # 'Е'
    134: 60,  # 'Ж'
    135: 44,  # 'З'
    136: 58,  # 'И'
    137: 62,  # 'Й'
    138: 36,  # 'К'
    139: 49,  # 'Л'
    140: 42,  # 'М'
    141: 37,  # 'Н'
    142: 41,  # 'О'
    143: 33,  # 'П'
    144: 45,  # 'Р'
    145: 35,  # 'С'
    146: 43,  # 'Т'
    147: 38,  # 'У'
    148: 53,  # 'Ф'
    149: 55,  # 'Х'
    150: 51,  # 'Ц'
    151: 52,  # 'Ч'
    152: 56,  # 'Ш'
    153: 59,  # 'Щ'
    154: 0,  # 'Ъ'
    155: 0,  # 'Ы'
    156: 64,  # 'Ь'
    157: 0,  # 'Э'
    158: 61,  # 'Ю'
    159: 50,  # 'Я'
    160: CharacterCategory.SYMBOL,  # '†'
    161: CharacterCategory.SYMBOL,  # '°'
    162: 66,  # 'Ґ'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '§'
    165: CharacterCategory.SYMBOL,  # '•'
    166: CharacterCategory.SYMBOL,  # '¶'
    167: 46,  # 'І'
    168: CharacterCategory.SYMBOL,  # '®'
    169: CharacterCategory.SYMBOL,  # '©'
    170: CharacterCategory.SYMBOL,  # '™'
    171: 0,  # 'Ђ'
    172: 0,  # 'ђ'
    173: CharacterCategory.SYMBOL,  # '≠'
    174: 0,  # 'Ѓ'
    175: 0,  # 'ѓ'
    176: CharacterCategory.SYMBOL,  # '∞'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.SYMBOL,  # '≤'
    179: CharacterCategory.SYMBOL,  # '≥'
    180: 5,  # 'і'
    181: 0,  # 'µ'
    182: 65,  # 'ґ'
    183: 0,  # 'Ј'
    184: 57,  # 'Є'
    185: 30,  # 'є'
    186: 63,  # 'Ї'
    187: 28,  # 'ї'
    188: 0,  # 'Љ'
    189: 0,  # 'љ'
    190: 0,  # 'Њ'
    191: 0,  # 'њ'
    192: 0,  # 'ј'
    193: 0,  # 'Ѕ'
    194: CharacterCategory.SYMBOL,  # '¬'
    195: CharacterCategory.SYMBOL,  # '√'
    196: 0,  # 'ƒ'
    197: CharacterCategory.SYMBOL,  # '≈'
    198: CharacterCategory.SYMBOL,  # '∆'
    199: CharacterCategory.SYMBOL,  # '«'
    200: CharacterCategory.SYMBOL,  # '»'
    201: CharacterCategory.SYMBOL,  # '…'
    202: CharacterCategory.CONTROL,  # '\xa0'
    203: 0,  # 'Ћ'
    204: 0,  # 'ћ'
    205: 0,  # 'Ќ'
    206: 0,  # 'ќ'
    207: 0,  # 'ѕ'
    208: CharacterCategory.SYMBOL,  # '–'
    209: CharacterCategory.SYMBOL,  # '—'
    210: CharacterCategory.SYMBOL,  # '“'
    211: CharacterCategory.SYMBOL,  # '”'
    212: CharacterCategory.SYMBOL,  # '‘'
    213: CharacterCategory.SYMBOL,  # '’'
    214: CharacterCategory.SYMBOL,  # '÷'
    215: CharacterCategory.SYMBOL,  # '„'
    216: 0,  # 'Ў'
    217: 0,  # 'ў'
    218: 0,  # 'Џ'
    219: 0,  # 'џ'
    220: CharacterCategory.SYMBOL,  # '№'
    221: 0,  # 'Ё'
    222: 0,  # 'ё'
    223: 17,  # 'я'
    224: 2,  # 'а'
    225: 21,  # 'б'
    226: 7,  # 'в'
    227: 20,  # 'г'
    228: 13,  # 'д'
    229: 9,  # 'е'
    230: 26,  # 'ж'
    231: 18,  # 'з'
    232: 4,  # 'и'
    233: 23,  # 'й'
    234: 11,  # 'к'
    235: 12,  # 'л'
    236: 15,  # 'м'
    237: 3,  # 'н'
    238: 1,  # 'о'
    239: 16,  # 'п'
    240: 8,  # 'р'
    241: 10,  # 'с'
    242: 6,  # 'т'
    243: 14,  # 'у'
    244: 32,  # 'ф'
    245: 24,  # 'х'
    246: 25,  # 'ц'
    247: 22,  # 'ч'
    248: 29,  # 'ш'
    249: 31,  # 'щ'
    250: 0,  # 'ъ'
    251: 0,  # 'ы'
    252: 19,  # 'ь'
    253: 0,  # 'э'
    254: 27,  # 'ю'
    255: CharacterCategory.SYMBOL,  # '€'
}

MACCYRILLIC_UKRAINIAN_MODEL = SingleByteCharSetModel(
    charset_name="MacCyrillic",
    language="Ukrainian",
    char_to_order_map=MACCYRILLIC_UKRAINIAN_CHAR_TO_ORDER,
    language_model=UKRAINIAN_LANG_MODEL,
    typical_positive_ratio=0.9727888617453615,
    keep_ascii_letters=False,
    alphabet="ʼЄІЇАБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЬЮЯабвгдежзийклмнопрстуфхцчшщьюяєіїҐґ",
)

WINDOWS_1251_UKRAINIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 0,  # 'A'
    66: 0,  # 'B'
    67: 0,  # 'C'
    68: 0,  # 'D'
    69: 0,  # 'E'
    70: 0,  # 'F'
    71: 0,  # 'G'
    72: 0,  # 'H'
    73: 0,  # 'I'
    74: 0,  # 'J'
    75: 0,  # 'K'
    76: 0,  # 'L'
    77: 0,  # 'M'
    78: 0,  # 'N'
    79: 0,  # 'O'
    80: 0,  # 'P'
    81: 0,  # 'Q'
    82: 0,  # 'R'
    83: 0,  # 'S'
    84: 0,  # 'T'
    85: 0,  # 'U'
    86: 0,  # 'V'
    87: 0,  # 'W'
    88: 0,  # 'X'
    89: 0,  # 'Y'
    90: 0,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 0,  # 'a'
    98: 0,  # 'b'
    99: 0,  # 'c'
    100: 0,  # 'd'
    101: 0,  # 'e'
    102: 0,  # 'f'
    103: 0,  # 'g'
    104: 0,  # 'h'
    105: 0,  # 'i'
    106: 0,  # 'j'
    107: 0,  # 'k'
    108: 0,  # 'l'
    109: 0,  # 'm'
    110: 0,  # 'n'
    111: 0,  # 'o'
    112: 0,  # 'p'
    113: 0,  # 'q'
    114: 0,  # 'r'
    115: 0,  # 's'
    116: 0,  # 't'
    117: 0,  # 'u'
    118: 0,  # 'v'
    119: 0,  # 'w'
    120: 0,  # 'x'
    121: 0,  # 'y'
    122: 0,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 0,  # 'Ђ'
    129: 0,  # 'Ѓ'
    130: CharacterCategory.SYMBOL,  # '‚'
    131: 0,  # 'ѓ'
    132: CharacterCategory.SYMBOL,  # '„'
    133: CharacterCategory.SYMBOL,  # '…'
    134: CharacterCategory.SYMBOL,  # '†'
    135: CharacterCategory.SYMBOL,  # '‡'
    136: CharacterCategory.SYMBOL,  # '€'
    137: CharacterCategory.SYMBOL,  # '‰'
    138: 0,  # 'Љ'
    139: CharacterCategory.SYMBOL,  # '‹'
    140: 0,  # 'Њ'
    141: 0,  # 'Ќ'
    142: 0,  # 'Ћ'
    143: 0,  # 'Џ'
    144: 0,  # 'ђ'
    145: CharacterCategory.SYMBOL,  # '‘'
    146: CharacterCategory.SYMBOL,  # '’'
    147: CharacterCategory.SYMBOL,  # '“'
    148: CharacterCategory.SYMBOL,  # '”'
    149: CharacterCategory.SYMBOL,  # '•'
    150: CharacterCategory.SYMBOL,  # '–'
    151: CharacterCategory.SYMBOL,  # '—'
    152: CharacterCategory.UNDEFINED,  # None
    153: CharacterCategory.SYMBOL,  # '™'
    154: 0,  # 'љ'
    155: CharacterCategory.SYMBOL,  # '›'
    156: 0,  # 'њ'
    157: 0,  # 'ќ'
    158: 0,  # 'ћ'
    159: 0,  # 'џ'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: 0,  # 'Ў'
    162: 0,  # 'ў'
    163: 0,  # 'Ј'
    164: CharacterCategory.SYMBOL,  # '¤'
    165: 66,  # 'Ґ'
    166: CharacterCategory.SYMBOL,  # '¦'
    167: CharacterCategory.SYMBOL,  # '§'
    168: 0,  # 'Ё'
    169: CharacterCategory.SYMBOL,  # '©'
    170: 57,  # 'Є'
    171: CharacterCategory.SYMBOL,  # '«'
    172: CharacterCategory.SYMBOL,  # '¬'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: CharacterCategory.SYMBOL,  # '®'
    175: 63,  # 'Ї'
    176: CharacterCategory.SYMBOL,  # '°'
    177: CharacterCategory.SYMBOL,  # '±'
    178: 46,  # 'І'
    179: 5,  # 'і'
    180: 65,  # 'ґ'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.SYMBOL,  # '·'
    184: 0,  # 'ё'
    185: CharacterCategory.SYMBOL,  # '№'
    186: 30,  # 'є'
    187: CharacterCategory.SYMBOL,  # '»'
    188: 0,  # 'ј'
    189: 0,  # 'Ѕ'
    190: 0,  # 'ѕ'
    191: 28,  # 'ї'
    192: 39,  # 'А'
    193: 47,  # 'Б'
    194: 34,  # 'В'
    195: 48,  # 'Г'
    196: 40,  # 'Д'
    197: 54,  # 'Е'
    198: 60,  # 'Ж'
    199: 44,  # 'З'
    200: 58,  # 'И'
    201: 62,  # 'Й'
    202: 36,  # 'К'
    203: 49,  # 'Л'
    204: 42,  # 'М'
    205: 37,  # 'Н'
    206: 41,  # 'О'
    207: 33,  # 'П'
    208: 45,  # 'Р'
    209: 35,  # 'С'
    210: 43,  # 'Т'
    211: 38,  # 'У'
    212: 53,  # 'Ф'
    213: 55,  # 'Х'
    214: 51,  # 'Ц'
    215: 52,  # 'Ч'
    216: 56,  # 'Ш'
    217: 59,  # 'Щ'
    218: 0,  # 'Ъ'
    219: 0,  # 'Ы'
    220: 64,  # 'Ь'
    221: 0,  # 'Э'
    222: 61,  # 'Ю'
    223: 50,  # 'Я'
    224: 2,  # 'а'
    225: 21,  # 'б'
    226: 7,  # 'в'
    227: 20,  # 'г'
    228: 13,  # 'д'
    229: 9,  # 'е'
    230: 26,  # 'ж'
    231: 18,  # 'з'
    232: 4,  # 'и'
    233: 23,  # 'й'
    234: 11,  # 'к'
    235: 12,  # 'л'
    236: 15,  # 'м'
    237: 3,  # 'н'
    238: 1,  # 'о'
    239: 16,  # 'п'
    240: 8,  # 'р'
    241: 10,  # 'с'
    242: 6,  # 'т'
    243: 14,  # 'у'
    244: 32,  # 'ф'
    245: 24,  # 'х'
    246: 25,  # 'ц'
    247: 22,  # 'ч'
    248: 29,  # 'ш'
    249: 31,  # 'щ'
    250: 0,  # 'ъ'
    251: 0,  # 'ы'
    252: 19,  # 'ь'
    253: 0,  # 'э'
    254: 27,  # 'ю'
    255: 17,  # 'я'
}

WINDOWS_1251_UKRAINIAN_MODEL = SingleByteCharSetModel(
    charset_name="WINDOWS-1251",
    language="Ukrainian",
    char_to_order_map=WINDOWS_1251_UKRAINIAN_CHAR_TO_ORDER,
    language_model=UKRAINIAN_LANG_MODEL,
    typical_positive_ratio=0.9727888617453615,
    keep_ascii_letters=False,
    alphabet="ʼЄІЇАБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЬЮЯабвгдежзийклмнопрстуфхцчшщьюяєіїҐґ",
)
