﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/auditmanager/AuditManager_EXPORTS.h>
#include <aws/auditmanager/model/ControlInsightsMetadataItem.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace AuditManager {
namespace Model {
class ListControlInsightsByControlDomainResult {
 public:
  AWS_AUDITMANAGER_API ListControlInsightsByControlDomainResult() = default;
  AWS_AUDITMANAGER_API ListControlInsightsByControlDomainResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_AUDITMANAGER_API ListControlInsightsByControlDomainResult& operator=(
      const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The control analytics data that the
   * <code>ListControlInsightsByControlDomain</code> API returned. </p>
   */
  inline const Aws::Vector<ControlInsightsMetadataItem>& GetControlInsightsMetadata() const { return m_controlInsightsMetadata; }
  template <typename ControlInsightsMetadataT = Aws::Vector<ControlInsightsMetadataItem>>
  void SetControlInsightsMetadata(ControlInsightsMetadataT&& value) {
    m_controlInsightsMetadataHasBeenSet = true;
    m_controlInsightsMetadata = std::forward<ControlInsightsMetadataT>(value);
  }
  template <typename ControlInsightsMetadataT = Aws::Vector<ControlInsightsMetadataItem>>
  ListControlInsightsByControlDomainResult& WithControlInsightsMetadata(ControlInsightsMetadataT&& value) {
    SetControlInsightsMetadata(std::forward<ControlInsightsMetadataT>(value));
    return *this;
  }
  template <typename ControlInsightsMetadataT = ControlInsightsMetadataItem>
  ListControlInsightsByControlDomainResult& AddControlInsightsMetadata(ControlInsightsMetadataT&& value) {
    m_controlInsightsMetadataHasBeenSet = true;
    m_controlInsightsMetadata.emplace_back(std::forward<ControlInsightsMetadataT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The pagination token that's used to fetch the next set of results. </p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListControlInsightsByControlDomainResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListControlInsightsByControlDomainResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<ControlInsightsMetadataItem> m_controlInsightsMetadata;

  Aws::String m_nextToken;

  Aws::String m_requestId;
  bool m_controlInsightsMetadataHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace AuditManager
}  // namespace Aws
