/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ha.backend;

import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.ha.backend.CollectedInfo;
import org.apache.catalina.ha.backend.MultiCastSender;
import org.apache.catalina.ha.backend.Sender;
import org.apache.catalina.ha.backend.TcpSender;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public class HeartbeatListener
implements LifecycleListener {
    private static final Log log = LogFactory.getLog(HeartbeatListener.class);
    private static final StringManager sm = StringManager.getManager(HeartbeatListener.class);
    protected int port = 8009;
    protected String host = null;
    protected String ip = "224.0.1.105";
    protected int multiport = 23364;
    protected int ttl = 16;
    protected String proxyList = null;
    protected String proxyURL = "/HeartbeatListener";
    private CollectedInfo coll = null;
    private Sender sender = null;

    public String getHost() {
        return this.host;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public String getGroup() {
        return this.ip;
    }

    public void setGroup(String string) {
        this.ip = string;
    }

    public int getMultiport() {
        return this.multiport;
    }

    public void setMultiport(int n) {
        this.multiport = n;
    }

    public int getTtl() {
        return this.ttl;
    }

    public void setTtl(int n) {
        this.ttl = n;
    }

    public String getProxyList() {
        return this.proxyList;
    }

    public void setProxyList(String string) {
        this.proxyList = string;
    }

    public String getProxyURL() {
        return this.proxyURL;
    }

    public void setProxyURLString(String string) {
        this.proxyURL = string;
    }

    public void lifecycleEvent(LifecycleEvent lifecycleEvent) {
        if ("periodic".equals(lifecycleEvent.getType())) {
            if (this.sender == null) {
                this.sender = this.proxyList == null ? new MultiCastSender() : new TcpSender();
            }
            if (this.coll == null) {
                try {
                    this.coll = new CollectedInfo(this.host, this.port);
                    this.port = this.coll.port;
                    this.host = this.coll.host;
                }
                catch (Exception exception) {
                    log.error((Object)sm.getString("heartbeatListener.errorCollectingInfo"), (Throwable)exception);
                    this.coll = null;
                    return;
                }
            }
            try {
                this.sender.init(this);
            }
            catch (Exception exception) {
                log.error((Object)sm.getString("heartbeatListener.senderInitError"), (Throwable)exception);
                this.sender = null;
                return;
            }
            try {
                this.coll.refresh();
            }
            catch (Exception exception) {
                log.error((Object)sm.getString("heartbeatListener.refreshError"), (Throwable)exception);
                this.coll = null;
                return;
            }
            String string = "v=1&ready=" + this.coll.ready + "&busy=" + this.coll.busy + "&port=" + this.port;
            try {
                this.sender.send(string);
            }
            catch (Exception exception) {
                log.error((Object)sm.getString("heartbeatListener.sendError"), (Throwable)exception);
            }
        }
    }
}

