/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.nativewindow.egl;

import com.jogamp.common.util.VersionNumber;
import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.nativewindow.DefaultGraphicsDevice;
import com.jogamp.nativewindow.NativeWindowException;

public class EGLGraphicsDevice
extends DefaultGraphicsDevice
implements Cloneable {
    public static final int EGL_DEFAULT_DISPLAY = 0;
    public static final int EGL_NO_DISPLAY = 0;
    private final long[] nativeDisplayID = new long[1];
    private EGLDisplayLifecycleCallback eglLifecycleCallback;
    private VersionNumber eglVersion = VersionNumber.zeroVersion;

    public static long getNativeDisplayID(AbstractGraphicsDevice abstractGraphicsDevice) {
        if (abstractGraphicsDevice instanceof EGLGraphicsDevice) {
            return ((EGLGraphicsDevice)abstractGraphicsDevice).getNativeDisplayID();
        }
        return abstractGraphicsDevice.getHandle();
    }

    private EGLGraphicsDevice(long l, String string, int n, long l2, EGLDisplayLifecycleCallback eGLDisplayLifecycleCallback) {
        super(".egl", string, n, l2);
        this.nativeDisplayID[0] = l;
        this.eglLifecycleCallback = eGLDisplayLifecycleCallback;
    }

    public EGLGraphicsDevice() {
        this(0L, DefaultGraphicsDevice.getDefaultDisplayConnection(), 0, 0L, null);
    }

    public EGLGraphicsDevice(long l, String string, int n) {
        this(l, string, n, 0L, null);
    }

    public EGLGraphicsDevice(long l, long l2, String string, int n) {
        this(l, string, n, l2, null);
        if (0L == this.nativeDisplayID[0]) {
            throw new NativeWindowException("Invalid EGL_NO_DISPLAY display handle");
        }
    }

    public EGLGraphicsDevice(AbstractGraphicsDevice abstractGraphicsDevice, EGLDisplayLifecycleCallback eGLDisplayLifecycleCallback) {
        this(EGLGraphicsDevice.getNativeDisplayID(abstractGraphicsDevice), abstractGraphicsDevice.getConnection(), abstractGraphicsDevice.getUnitID(), 0L, eGLDisplayLifecycleCallback);
        if (null == eGLDisplayLifecycleCallback) {
            throw new NativeWindowException("Null EGLDisplayLifecycleCallback");
        }
    }

    public EGLGraphicsDevice(long l, String string, int n, EGLDisplayLifecycleCallback eGLDisplayLifecycleCallback) {
        this(l, string, n, 0L, eGLDisplayLifecycleCallback);
        if (null == eGLDisplayLifecycleCallback) {
            throw new NativeWindowException("Null EGLDisplayLifecycleCallback");
        }
    }

    public VersionNumber getEGLVersion() {
        return this.eglVersion;
    }

    public long getNativeDisplayID() {
        return this.nativeDisplayID[0];
    }

    public boolean sameNativeDisplayID(AbstractGraphicsDevice abstractGraphicsDevice) {
        return EGLGraphicsDevice.getNativeDisplayID(abstractGraphicsDevice) == this.getNativeDisplayID();
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    @Override
    public boolean open() {
        if (null != this.eglLifecycleCallback && 0L == this.handle) {
            if (DEBUG) {
                System.err.println(Thread.currentThread().getName() + " - EGLGraphicsDevice.open(): " + this);
            }
            int[] nArray = new int[]{0};
            int[] nArray2 = new int[]{0};
            this.handle = this.eglLifecycleCallback.eglGetAndInitDisplay(this.nativeDisplayID, nArray, nArray2);
            if (0L == this.handle) {
                this.eglVersion = VersionNumber.zeroVersion;
                throw new NativeWindowException("EGLGraphicsDevice.open() failed: " + this);
            }
            this.eglVersion = new VersionNumber(nArray[0], nArray2[0], 0);
            return true;
        }
        return false;
    }

    @Override
    public boolean close() {
        if (null != this.eglLifecycleCallback && 0L != this.handle) {
            if (DEBUG) {
                System.err.println(Thread.currentThread().getName() + " - EGLGraphicsDevice.close(): " + this);
            }
            this.eglLifecycleCallback.eglTerminate(this.handle);
        }
        return super.close();
    }

    @Override
    public boolean isHandleOwner() {
        return null != this.eglLifecycleCallback;
    }

    @Override
    public void clearHandleOwner() {
        this.eglLifecycleCallback = null;
    }

    @Override
    protected Object getHandleOwnership() {
        return this.eglLifecycleCallback;
    }

    @Override
    protected Object setHandleOwnership(Object object) {
        EGLDisplayLifecycleCallback eGLDisplayLifecycleCallback = this.eglLifecycleCallback;
        this.eglLifecycleCallback = (EGLDisplayLifecycleCallback)object;
        return eGLDisplayLifecycleCallback;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[type " + this.getType() + ", v" + this.eglVersion + ", nativeDisplayID 0x" + Long.toHexString(this.nativeDisplayID[0]) + ", connection " + this.getConnection() + ", unitID " + this.getUnitID() + ", handle 0x" + Long.toHexString(this.getHandle()) + ", owner " + this.isHandleOwner() + ", " + this.toolkitLock + "]";
    }

    public static interface EGLDisplayLifecycleCallback {
        public long eglGetAndInitDisplay(long[] var1, int[] var2, int[] var3);

        public void eglTerminate(long var1);
    }
}

