/*
 * Decompiled with CFR 0.152.
 */
package hughai.ui;

import hughai.GameAdapter;
import hughai.PlayerObjects;
import hughai.building.Workflows;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class WorkflowUI {
    PlayerObjects playerObjects;
    JPanel panel;
    private JList workflowNames;

    public WorkflowUI(PlayerObjects playerObjects) {
        this.playerObjects = playerObjects;
        this.setup();
        playerObjects.getCSAI().registerGameListener(new GameListener());
    }

    void setup() {
        this.panel = new JPanel();
        this.workflowNames = new JList();
        Workflows workflows = this.playerObjects.getWorkflows();
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        for (String string : workflows.getWorkflowsByName().keySet()) {
            defaultListModel.addElement(string);
        }
        this.workflowNames.setModel(defaultListModel);
        this.workflowNames.addListSelectionListener(new WorkflowNamesSelectionListener());
        this.panel.add(this.workflowNames);
        JTable jTable = new JTable(0, 3);
        this.refresh();
        this.playerObjects.getMainUI().addPanelToTabbedPanel("Workflows", this.panel);
    }

    void displaySelectedWorkflow() {
        String string = (String)this.workflowNames.getSelectedValue();
        Workflows workflows = this.playerObjects.getWorkflows();
        Workflows.Workflow workflow = workflows.getWorkflowsByName().get(string);
        for (Workflows.Workflow.Order order : workflow.orders) {
        }
    }

    void refresh() {
        Workflows workflows = this.playerObjects.getWorkflows();
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        for (String string : workflows.getWorkflowsByName().keySet()) {
            defaultListModel.addElement(string);
        }
        this.workflowNames.setModel(defaultListModel);
        this.panel.validate();
    }

    class GameListener
    extends GameAdapter {
        GameListener() {
        }

        @Override
        public void Tick(int n) {
            WorkflowUI.this.refresh();
        }
    }

    class WorkflowNamesSelectionListener
    implements ListSelectionListener {
        WorkflowNamesSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            WorkflowUI.this.displaySelectedWorkflow();
        }
    }
}

