# Copyright (c) ONNX Project Contributors
#
# SPDX-License-Identifier: Apache-2.0

# This file contains freeze NumPy array for ImageDecoder backend test's input/output
# They were generated by image_decoder.py's generate_test_data with pillow
# To make ONNX backend test generation simple, use freeze NumPy array directly
# People can still use generate_test_data to get these data here with installed pillow

from typing import NamedTuple

import numpy as np


class ImageData(NamedTuple):
    data: np.ndarray
    output: np.ndarray


# Remove black check for better readability with large NumPy array
# fmt: off
image_decoder_decode_jpeg_rgb = ImageData(
    np.array([255, 216, 255, 224,   0,  16,  74,  70,  73,  70,   0,   1,   1,
         0,   0,   1,   0,   1,   0,   0, 255, 219,   0,  67,   0,   8,
         6,   6,   7,   6,   5,   8,   7,   7,   7,   9,   9,   8,  10,
        12,  20,  13,  12,  11,  11,  12,  25,  18,  19,  15,  20,  29,
        26,  31,  30,  29,  26,  28,  28,  32,  36,  46,  39,  32,  34,
        44,  35,  28,  28,  40,  55,  41,  44,  48,  49,  52,  52,  52,
        31,  39,  57,  61,  56,  50,  60,  46,  51,  52,  50, 255, 219,
         0,  67,   1,   9,   9,   9,  12,  11,  12,  24,  13,  13,  24,
        50,  33,  28,  33,  50,  50,  50,  50,  50,  50,  50,  50,  50,
        50,  50,  50,  50,  50,  50,  50,  50,  50,  50,  50,  50,  50,
        50,  50,  50,  50,  50,  50,  50,  50,  50,  50,  50,  50,  50,
        50,  50,  50,  50,  50,  50,  50,  50,  50,  50,  50,  50,  50,
        50,  50, 255, 192,   0,  17,   8,   0,  32,   0,  32,   3,   1,
        34,   0,   2,  17,   1,   3,  17,   1, 255, 196,   0,  31,   0,
         0,   1,   5,   1,   1,   1,   1,   1,   1,   0,   0,   0,   0,
         0,   0,   0,   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,
        10,  11, 255, 196,   0, 181,  16,   0,   2,   1,   3,   3,   2,
         4,   3,   5,   5,   4,   4,   0,   0,   1, 125,   1,   2,   3,
         0,   4,  17,   5,  18,  33,  49,  65,   6,  19,  81,  97,   7,
        34, 113,  20,  50, 129, 145, 161,   8,  35,  66, 177, 193,  21,
        82, 209, 240,  36,  51,  98, 114, 130,   9,  10,  22,  23,  24,
        25,  26,  37,  38,  39,  40,  41,  42,  52,  53,  54,  55,  56,
        57,  58,  67,  68,  69,  70,  71,  72,  73,  74,  83,  84,  85,
        86,  87,  88,  89,  90,  99, 100, 101, 102, 103, 104, 105, 106,
       115, 116, 117, 118, 119, 120, 121, 122, 131, 132, 133, 134, 135,
       136, 137, 138, 146, 147, 148, 149, 150, 151, 152, 153, 154, 162,
       163, 164, 165, 166, 167, 168, 169, 170, 178, 179, 180, 181, 182,
       183, 184, 185, 186, 194, 195, 196, 197, 198, 199, 200, 201, 202,
       210, 211, 212, 213, 214, 215, 216, 217, 218, 225, 226, 227, 228,
       229, 230, 231, 232, 233, 234, 241, 242, 243, 244, 245, 246, 247,
       248, 249, 250, 255, 196,   0,  31,   1,   0,   3,   1,   1,   1,
         1,   1,   1,   1,   1,   1,   0,   0,   0,   0,   0,   0,   1,
         2,   3,   4,   5,   6,   7,   8,   9,  10,  11, 255, 196,   0,
       181,  17,   0,   2,   1,   2,   4,   4,   3,   4,   7,   5,   4,
         4,   0,   1,   2, 119,   0,   1,   2,   3,  17,   4,   5,  33,
        49,   6,  18,  65,  81,   7,  97, 113,  19,  34,  50, 129,   8,
        20,  66, 145, 161, 177, 193,   9,  35,  51,  82, 240,  21,  98,
       114, 209,  10,  22,  36,  52, 225,  37, 241,  23,  24,  25,  26,
        38,  39,  40,  41,  42,  53,  54,  55,  56,  57,  58,  67,  68,
        69,  70,  71,  72,  73,  74,  83,  84,  85,  86,  87,  88,  89,
        90,  99, 100, 101, 102, 103, 104, 105, 106, 115, 116, 117, 118,
       119, 120, 121, 122, 130, 131, 132, 133, 134, 135, 136, 137, 138,
       146, 147, 148, 149, 150, 151, 152, 153, 154, 162, 163, 164, 165,
       166, 167, 168, 169, 170, 178, 179, 180, 181, 182, 183, 184, 185,
       186, 194, 195, 196, 197, 198, 199, 200, 201, 202, 210, 211, 212,
       213, 214, 215, 216, 217, 218, 226, 227, 228, 229, 230, 231, 232,
       233, 234, 242, 243, 244, 245, 246, 247, 248, 249, 250, 255, 218,
         0,  12,   3,   1,   0,   2,  17,   3,  17,   0,  63,   0,  93,
        15, 199, 122,  93, 181, 235, 187, 193, 120,  65, 140, 143, 149,
        23, 212, 127, 181,  93,  36,  95,  16, 180, 150, 145,  36,  22,
       247, 187, 119,   3, 247,  19, 255,   0, 138, 175,  29, 180, 183,
       153,  37,  36, 195,  32, 249, 123, 169, 174, 175,  68, 138, 194,
        73, 108, 226, 187, 104, 193, 105,  66, 186, 180, 155,  78,  11,
       125, 120, 226, 184, 243, 204,  13,  12, 101, 117, 141, 154, 110,
        46, 209, 211, 123, 247, 125,  45, 243,  61, 156,  62,  34, 141,
        92,  59, 173, 137,  77, 201, 221,  46,  94, 253,  14, 135, 198,
        14,  62,  32, 253, 139, 251,  39,  48, 253, 135, 127, 153, 246,
       191, 151,  59, 246, 227,  27, 119, 127, 112, 245, 199, 106, 224,
       124,  90, 134, 211, 194, 183, 118, 114,  96, 201,   8, 142,  54,
        43, 208, 149, 117,   7,  30, 220,  87, 166, 234,  22, 182, 250,
       103, 151, 253, 132, 163, 247, 153, 243, 188, 166,  50, 244, 198,
       220, 231,  56, 234, 107, 142, 241, 245, 157, 168, 240,  86, 161,
       114,  80,  11, 179, 229, 179,  18, 199,  59, 140, 139, 158,  51,
       238, 107, 179,  15, 130, 246,  20,  21,  55,  36, 224, 175, 202,
       147, 214, 251, 235, 243,  60, 117,  78, 166,  38,  42,  53, 218,
        92, 154, 174, 154, 147,  29,  35,  96, 207, 159, 159, 248,   7,
       255,   0,  94, 179, 100, 180, 251,  62, 168, 178, 239, 221, 229,
       186, 182,  49, 140, 227,   6, 181, 173, 124, 127, 224, 229, 148,
       153, 181,   4,  43, 142,  51, 107,  33, 231, 254, 248, 170,  26,
       151, 141, 124,  35,  52, 243,  52,  23, 145, 144, 203, 242, 145,
       107,  32, 231,  31, 238, 215,   6,  89, 154,  85, 141,  79,  99,
        94, 140, 185,  31, 149, 149, 219,  93, 108, 107,  71,  56, 132,
        40, 243, 209, 161,  40, 174, 145, 123, 223, 190, 167,  75, 164,
       106, 249, 243, 191, 113, 253, 223, 227, 250, 251,  86, 119, 196,
       109,  63,  30,   0, 212, 175, 124, 223, 188,  34, 125, 155, 122,
       110, 149,  56, 206, 125, 235, 147, 255,   0, 132, 199,  71, 143,
       253,  86, 160, 201, 158, 187,  99, 144, 103, 244, 170, 158,  37,
       241, 133, 166, 167, 225, 155, 155,   8, 181,  73, 166, 103,   8,
         4,  76,  36, 193, 195,  41, 238,  49, 218, 175,  49, 194,  42,
        88, 181, 245,  95, 134, 234, 246, 215,  77,  58, 234,  24,  90,
        95,  95, 162, 241,  56, 185, 165,  36, 155,  73, 232, 238, 180,
        90, 105, 216, 255, 217], dtype=np.uint8),
    np.array([[[230,  73, 255],
        [227,  76, 255],
        [222,  81, 255],
        [211,  95, 206],
        [204, 123, 142],
        [251, 202, 133],
        [245, 226,  72],
        [234, 230,  34],
        [235, 234,  32],
        [231, 229,  32],
        [227, 221,  37],
        [233, 224,  45],
        [237, 227,  42],
        [232, 216,  32],
        [243, 219,  35],
        [255, 247,  63],
        [246, 255,  71],
        [249, 255,  83],
        [243, 253,  68],
        [255, 251, 134],
        [ 97,  23,  46],
        [127,  19, 121],
        [123,   0, 124],
        [118,  19, 128],
        [ 63,  28,  82],
        [ 99, 133, 143],
        [ 39, 146, 128],
        [ 24, 162, 110],
        [ 26, 157,  64],
        [ 66, 154,  76],
        [  0,   9,   0],
        [ 15,   0,   9]],

       [[232,  77, 255],
        [228,  79, 255],
        [221,  83, 254],
        [210,  93, 208],
        [202, 117, 146],
        [248, 193, 137],
        [242, 216,  77],
        [230, 222,  35],
        [239, 237,  40],
        [235, 233,  36],
        [230, 225,  37],
        [235, 227,  41],
        [238, 228,  42],
        [230, 220,  34],
        [237, 225,  41],
        [255, 253,  70],
        [242, 250,  68],
        [242, 251,  70],
        [255, 255,  79],
        [255, 232, 124],
        [112,  32,  57],
        [119,   9, 108],
        [132,  10, 129],
        [117,  21, 121],
        [ 83,  50,  95],
        [ 98, 132, 134],
        [ 34, 137, 108],
        [ 31, 165, 106],
        [ 40, 168,  75],
        [ 62, 151,  71],
        [  0,   9,   0],
        [ 11,   0,   5]],

       [[234,  81, 255],
        [229,  82, 255],
        [221,  86, 250],
        [211,  95, 218],
        [207, 115, 164],
        [254, 189, 161],
        [249, 213, 101],
        [238, 224,  57],
        [235, 232,  41],
        [231, 229,  30],
        [229, 221,  26],
        [229, 221,  26],
        [231, 225,  29],
        [218, 219,  27],
        [215, 229,  45],
        [237, 252,  71],
        [252, 252,  76],
        [255, 248,  80],
        [255, 249,  94],
        [255, 225, 135],
        [120,  30,  58],
        [120,   6, 101],
        [126,   9, 116],
        [109,  20, 104],
        [ 75,  47,  72],
        [ 97, 130, 113],
        [ 48, 144,  98],
        [ 37, 163,  89],
        [ 48, 169,  72],
        [ 59, 151,  66],
        [  0,  16,   0],
        [  0,  13,   0]],

       [[216,  83, 236],
        [211,  83, 238],
        [205,  88, 246],
        [203,  98, 226],
        [205, 114, 181],
        [255, 184, 178],
        [255, 207, 120],
        [251, 220,  77],
        [246, 228,  56],
        [247, 228,  46],
        [248, 216,  43],
        [251, 214,  45],
        [250, 217,  50],
        [234, 217,  51],
        [217, 232,  69],
        [234, 255,  95],
        [245, 251,  93],
        [255, 254, 104],
        [252, 232, 101],
        [255, 228, 153],
        [111,  34,  52],
        [126,  33, 103],
        [109,  15,  93],
        [103,  34,  91],
        [ 52,  33,  39],
        [ 98, 127,  99],
        [ 75, 152, 106],
        [ 48, 148,  86],
        [ 53, 151,  78],
        [ 69, 148,  83],
        [  0,  16,   0],
        [  0,  15,   0]],

       [[202, 104, 227],
        [196, 103, 235],
        [191, 106, 253],
        [192, 111, 242],
        [200, 117, 199],
        [253, 176, 192],
        [255, 193, 127],
        [255, 204,  85],
        [255, 210,  67],
        [255, 209,  67],
        [255, 195,  76],
        [255, 189,  82],
        [255, 193,  88],
        [255, 197,  88],
        [229, 217,  97],
        [229, 246, 118],
        [228, 250, 123],
        [249, 255, 148],
        [245, 251, 145],
        [239, 224, 155],
        [ 97,  57,  49],
        [ 87,  35,  58],
        [ 72,  21,  52],
        [ 83,  48,  68],
        [ 80,  76,  65],
        [ 99, 122,  96],
        [ 88, 136, 110],
        [ 63, 123,  98],
        [ 70, 127, 108],
        [ 86, 130, 115],
        [  0,   9,   0],
        [  0,   7,   0]],

       [[ 83,  27, 128],
        [ 76,  23, 137],
        [ 70,  23, 161],
        [ 73,  22, 151],
        [ 84,  16, 103],
        [138,  60,  86],
        [146,  66,  13],
        [150,  72,   0],
        [146,  73,   0],
        [164,  71,   0],
        [186,  55,   0],
        [198,  48,  15],
        [202,  51,  24],
        [176,  56,  19],
        [136,  81,  16],
        [116, 114,  31],
        [ 94, 131,  38],
        [ 62, 112,  17],
        [ 75, 109,  23],
        [108, 125,  55],
        [173, 175, 128],
        [200, 194, 162],
        [203, 197, 175],
        [175, 174, 153],
        [150, 161, 131],
        [ 98, 117,  95],
        [ 83, 105, 102],
        [ 80, 103, 117],
        [ 92, 111, 143],
        [ 92, 107, 138],
        [  0,   3,  12],
        [  0,   5,   2]],

       [[ 52,  43, 132],
        [ 45,  40, 142],
        [ 41,  38, 167],
        [ 51,  35, 159],
        [ 70,  21, 103],
        [129,  55,  82],
        [144,  53,   6],
        [155,  53,   0],
        [163,  53,   0],
        [189,  52,  10],
        [224,  32,  53],
        [242,  23,  77],
        [251,  25,  88],
        [223,  33,  77],
        [172,  59,  61],
        [131,  98,  65],
        [ 62, 111,  55],
        [ 47, 130,  58],
        [ 80, 146,  72],
        [ 73, 128,  44],
        [153, 200, 104],
        [139, 183,  86],
        [160, 202, 120],
        [169, 206, 139],
        [174, 203, 155],
        [ 92, 109,  91],
        [ 92,  92, 116],
        [101,  90, 148],
        [103,  88, 171],
        [ 97,  87, 160],
        [  0,   0,  23],
        [  0,   4,   4]],

       [[ 26,  47, 140],
        [ 21,  44, 146],
        [ 22,  48, 169],
        [ 39,  47, 158],
        [ 67,  31, 103],
        [131,  62,  83],
        [153,  56,  14],
        [170,  52,   0],
        [164,  37,   0],
        [195,  37,  25],
        [233,  21,  71],
        [255,  13, 100],
        [255,  14, 111],
        [236,  20, 103],
        [180,  45,  88],
        [131,  84,  92],
        [ 70, 118,  92],
        [ 46, 136,  85],
        [ 43, 118,  59],
        [ 53, 122,  41],
        [153, 222, 106],
        [156, 225, 100],
        [143, 209, 101],
        [150, 205, 122],
        [155, 192, 141],
        [ 89, 101,  91],
        [119,  98, 137],
        [120,  83, 161],
        [104,  65, 174],
        [104,  78, 167],
        [  4,   6,  27],
        [  0,   7,   0]],

       [[ 18,  50, 161],
        [ 20,  54, 164],
        [ 13,  53, 166],
        [ 26,  47, 140],
        [ 69,  44,  99],
        [118,  52,  64],
        [155,  55,  23],
        [170,  48,   0],
        [169,  41,   2],
        [190,  36,  26],
        [233,  35,  71],
        [249,  26,  91],
        [239,  10,  92],
        [218,  23, 102],
        [177,  54, 117],
        [129,  83, 119],
        [ 75, 112, 105],
        [ 58, 131, 101],
        [ 56, 116,  78],
        [ 64, 120,  57],
        [151, 214, 110],
        [153, 217, 103],
        [138, 203, 109],
        [147, 202, 134],
        [169, 199, 163],
        [102, 102, 104],
        [124,  88, 132],
        [120,  67, 147],
        [131,  78, 184],
        [101,  68, 147],
        [  3,   9,   7],
        [  0,  18,   0]],

       [[ 15,  46, 136],
        [ 16,  52, 138],
        [ 11,  53, 135],
        [ 23,  46, 114],
        [ 66,  43,  89],
        [114,  48,  76],
        [151,  46,  60],
        [164,  39,  45],
        [167,  43,  51],
        [164,  28,  38],
        [200,  43,  54],
        [214,  43,  59],
        [210,  42,  59],
        [195,  56,  79],
        [144,  65,  94],
        [115,  93, 114],
        [ 72, 103, 106],
        [ 63, 116, 108],
        [ 70, 111, 103],
        [ 87, 127, 103],
        [139, 187, 129],
        [151, 201, 138],
        [147, 198, 155],
        [160, 198, 177],
        [150, 162, 162],
        [117,  97, 124],
        [143,  86, 141],
        [142,  68, 147],
        [148,  76, 176],
        [124,  74, 145],
        [  6,   0,   0],
        [  0,  10,   0]],

       [[ 36,  57,  88],
        [ 37,  62,  92],
        [ 29,  65,  91],
        [ 39,  55,  88],
        [ 76,  47,  95],
        [118,  47, 115],
        [150,  39, 134],
        [158,  32, 132],
        [154,  41, 123],
        [146,  43,  86],
        [196, 101,  79],
        [194, 111,  45],
        [180, 109,  17],
        [170, 126,  37],
        [140, 138,  77],
        [173, 197, 165],
        [185, 215, 215],
        [183, 214, 235],
        [186, 206, 239],
        [173, 192, 225],
        [120, 142, 165],
        [107, 128, 157],
        [101, 121, 171],
        [112, 118, 178],
        [158, 138, 199],
        [180, 129, 195],
        [215, 130, 198],
        [226, 125, 203],
        [222, 126, 216],
        [201, 125, 189],
        [ 44,   6,   3],
        [ 23,   5,   0]],

       [[ 43,  58,  65],
        [ 43,  62,  66],
        [ 36,  65,  63],
        [ 42,  55,  64],
        [ 72,  44,  84],
        [112,  41, 121],
        [140,  28, 156],
        [143,  21, 158],
        [130,  28, 140],
        [115,  39,  86],
        [164, 121,  70],
        [151, 132,  14],
        [131, 127,   0],
        [127, 142,   0],
        [115, 151,  55],
        [196, 235, 190],
        [189, 214, 218],
        [192, 206, 245],
        [201, 208, 255],
        [202, 207, 255],
        [110, 114, 188],
        [109, 113, 202],
        [117, 115, 225],
        [126, 109, 224],
        [137,  95, 195],
        [195, 127, 212],
        [225, 129, 201],
        [237, 127, 200],
        [229, 120, 203],
        [217, 125, 188],
        [ 41,   0,   0],
        [ 32,   0,   0]],

       [[ 44,  55,  73],
        [ 46,  63,  73],
        [ 41,  66,  63],
        [ 46,  57,  59],
        [ 74,  50,  76],
        [111,  47, 108],
        [141,  35, 146],
        [142,  27, 148],
        [146,  52, 148],
        [114,  55,  85],
        [139, 130,  55],
        [125, 147,  10],
        [119, 155,   0],
        [115, 158,  16],
        [104, 140,  68],
        [186, 213, 194],
        [196, 209, 226],
        [186, 190, 235],
        [187, 187, 247],
        [198, 197, 255],
        [109, 105, 202],
        [121, 113, 232],
        [123, 108, 249],
        [122,  91, 231],
        [149,  99, 214],
        [211, 141, 230],
        [225, 133, 200],
        [232, 126, 190],
        [224, 118, 192],
        [227, 132, 196],
        [ 51,   0,  14],
        [ 43,   0,   4]],

       [[ 33,  57,  59],
        [ 36,  62,  59],
        [ 34,  66,  53],
        [ 39,  58,  52],
        [ 69,  52,  70],
        [107,  50, 105],
        [137,  36, 140],
        [142,  27, 148],
        [128,  30, 131],
        [110,  49,  93],
        [126, 120,  68],
        [116, 146,  32],
        [115, 160,  18],
        [112, 150,  31],
        [121, 131,  81],
        [205, 200, 196],
        [215, 206, 227],
        [218, 206, 242],
        [215, 207, 248],
        [214, 206, 255],
        [120, 113, 193],
        [121, 110, 215],
        [125, 106, 234],
        [135, 105, 229],
        [141,  97, 192],
        [190, 133, 202],
        [206, 133, 178],
        [216, 135, 176],
        [210, 132, 184],
        [209, 139, 193],
        [ 36,   0,  21],
        [ 29,   0,  18]],

       [[ 22,  75,  33],
        [ 27,  79,  40],
        [ 26,  77,  44],
        [ 33,  65,  50],
        [ 61,  57,  72],
        [ 99,  50, 106],
        [134,  32, 141],
        [143,  19, 153],
        [146,  29, 162],
        [142,  57, 150],
        [136, 108, 120],
        [123, 131,  84],
        [123, 141,  57],
        [123, 124,  48],
        [162, 121,  91],
        [248, 192, 193],
        [227, 185, 197],
        [233, 201, 214],
        [221, 199, 201],
        [207, 192, 197],
        [134, 126, 150],
        [122, 114, 161],
        [116, 105, 174],
        [133, 116, 184],
        [150, 127, 171],
        [171, 143, 165],
        [181, 149, 154],
        [189, 157, 160],
        [188, 156, 177],
        [175, 152, 181],
        [ 11,   0,  30],
        [  1,   0,  27]],

       [[ 58, 122,  61],
        [ 61, 125,  64],
        [ 60, 121,  64],
        [ 66, 106,  71],
        [ 92,  93,  97],
        [129,  81, 133],
        [165,  59, 170],
        [174,  41, 184],
        [172,  40, 185],
        [151,  48, 165],
        [102,  50, 112],
        [ 82,  60,  73],
        [ 91,  77,  50],
        [ 94,  59,  27],
        [134,  53,  50],
        [199, 106, 114],
        [193, 121, 124],
        [186, 127, 121],
        [173, 115, 101],
        [184, 143, 121],
        [179, 165, 139],
        [192, 189, 170],
        [181, 172, 175],
        [180, 174, 176],
        [168, 169, 155],
        [150, 158, 134],
        [134, 151, 119],
        [125, 148, 120],
        [123, 150, 133],
        [121, 143, 140],
        [  0,   4,  17],
        [  0,   3,  26]],

       [[ 61, 119,  61],
        [ 60, 121,  54],
        [ 60, 124,  38],
        [ 71, 116,  47],
        [ 96,  97,  79],
        [127,  76, 119],
        [164,  51, 167],
        [181,  39, 183],
        [181,  41, 172],
        [164,  45, 161],
        [118,  40, 139],
        [100,  45, 113],
        [106,  56,  85],
        [124,  56,  71],
        [140,  31,  60],
        [224, 107, 126],
        [212, 114, 105],
        [213, 116,  97],
        [223, 109,  99],
        [206, 116,  89],
        [205, 181, 109],
        [185, 190, 100],
        [192, 182, 110],
        [188, 185, 116],
        [170, 194, 118],
        [112, 162,  89],
        [104, 180, 118],
        [ 87, 176, 120],
        [ 76, 166, 105],
        [ 98, 165, 121],
        [  0,  20,   7],
        [  0,   0,   5]],

       [[ 61, 114,  72],
        [ 61, 116,  59],
        [ 63, 121,  37],
        [ 77, 114,  44],
        [100,  97,  78],
        [128,  77, 120],
        [161,  54, 168],
        [178,  43, 182],
        [183,  50, 169],
        [174,  52, 163],
        [135,  37, 158],
        [120,  35, 139],
        [120,  38, 104],
        [135,  39,  87],
        [151,  24,  77],
        [231, 100, 132],
        [223, 109,  98],
        [227, 111,  86],
        [240, 101,  94],
        [220, 111,  82],
        [210, 183,  92],
        [186, 193,  79],
        [195, 186,  85],
        [189, 191,  94],
        [161, 199,  98],
        [ 94, 165,  71],
        [ 80, 181, 105],
        [ 76, 190, 118],
        [ 72, 184, 100],
        [ 91, 174, 104],
        [  0,  13,   0],
        [  0,   1,   0]],

       [[ 59, 110,  91],
        [ 65, 111,  82],
        [ 73, 113,  63],
        [ 86, 107,  68],
        [106,  94,  98],
        [127,  79, 131],
        [149,  62, 169],
        [163,  54, 179],
        [163,  47, 154],
        [164,  48, 155],
        [138,  26, 154],
        [134,  23, 144],
        [136,  23, 111],
        [149,  30,  98],
        [162,  27,  94],
        [231,  98, 141],
        [223, 106,  99],
        [226, 110,  87],
        [235, 102,  95],
        [214, 110,  85],
        [208, 181, 102],
        [184, 190,  92],
        [189, 184, 103],
        [181, 189, 112],
        [167, 211, 126],
        [102, 174,  90],
        [ 81, 173,  98],
        [ 83, 181, 104],
        [ 86, 179,  88],
        [102, 173,  95],
        [  0,  14,   0],
        [  1,  12,   0]],

       [[ 88,  95,  88],
        [ 94,  95,  81],
        [104,  95,  64],
        [114,  90,  66],
        [124,  81,  88],
        [133,  73, 111],
        [138,  65, 138],
        [143,  60, 142],
        [155,  66, 132],
        [163,  62, 142],
        [144,  29, 148],
        [151,  26, 154],
        [152,  25, 130],
        [160,  33, 124],
        [162,  35, 124],
        [204,  91, 157],
        [200, 115, 138],
        [199, 120, 125],
        [207, 115, 130],
        [190, 121, 114],
        [196, 187, 128],
        [180, 194, 115],
        [186, 189, 122],
        [182, 193, 125],
        [145, 189, 102],
        [115, 176,  81],
        [104, 170,  80],
        [105, 171,  74],
        [110, 167,  60],
        [124, 167,  75],
        [  0,  12,   0],
        [  0,   7,   0]],

       [[194, 115, 111],
        [198, 114, 103],
        [207, 113,  88],
        [210, 112,  87],
        [204, 111,  96],
        [192, 111, 108],
        [178, 113, 121],
        [171, 114, 123],
        [171, 111, 111],
        [175,  99, 127],
        [159,  49, 144],
        [170,  44, 169],
        [167,  39, 158],
        [164,  43, 159],
        [146,  43, 160],
        [148,  77, 181],
        [108,  84, 162],
        [ 99,  93, 155],
        [107,  89, 147],
        [100,  94, 122],
        [124, 153, 122],
        [121, 157,  96],
        [135, 148,  92],
        [139, 152,  82],
        [142, 179,  76],
        [170, 211,  91],
        [191, 217,  92],
        [200, 212,  84],
        [202, 206,  70],
        [207, 207,  93],
        [ 14,  19,   0],
        [  2,   8,   0]],

       [[230,  98,  93],
        [234,  97,  87],
        [239,  97,  77],
        [236,  97,  74],
        [220, 101,  79],
        [197, 105,  80],
        [170, 113,  84],
        [158, 117,  85],
        [170, 127,  92],
        [177, 112, 118],
        [159,  53, 143],
        [180,  50, 184],
        [175,  44, 182],
        [167,  48, 192],
        [143,  51, 198],
        [117,  69, 205],
        [ 81,  93, 205],
        [ 66, 105, 198],
        [ 73, 105, 182],
        [ 73, 108, 148],
        [113, 160, 142],
        [117, 161, 112],
        [134, 154, 103],
        [140, 158,  84],
        [122, 156,  44],
        [185, 213,  77],
        [214, 213,  73],
        [223, 200,  58],
        [225, 192,  51],
        [224, 201,  89],
        [  4,   7,   0],
        [  0,   8,   0]],

       [[245,  93,  82],
        [247,  93,  81],
        [250,  92,  80],
        [242,  95,  79],
        [222, 101,  82],
        [196, 109,  81],
        [168, 119,  79],
        [155, 122,  79],
        [158, 120,  81],
        [169, 106, 115],
        [156,  45, 148],
        [179,  44, 199],
        [173,  36, 201],
        [166,  44, 215],
        [148,  53, 233],
        [113,  66, 232],
        [ 73,  92, 220],
        [ 54, 108, 204],
        [ 56, 110, 184],
        [ 59, 113, 147],
        [111, 160, 139],
        [119, 159, 109],
        [133, 153, 100],
        [137, 158,  83],
        [133, 170,  54],
        [198, 222,  84],
        [220, 203,  63],
        [231, 189,  53],
        [235, 183,  61],
        [229, 197, 110],
        [  0,   8,   0],
        [  0,  18,  21]],

       [[222, 106,  57],
        [223, 107,  60],
        [225, 106,  66],
        [218, 109,  70],
        [202, 115,  72],
        [182, 120,  69],
        [159, 128,  64],
        [150, 129,  64],
        [158, 129,  71],
        [170, 118, 107],
        [150,  59, 138],
        [167,  58, 185],
        [152,  46, 178],
        [142,  54, 192],
        [128,  68, 216],
        [ 95,  76, 218],
        [ 60,  99, 218],
        [ 44, 113, 208],
        [ 42, 116, 187],
        [ 49, 117, 152],
        [111, 159, 147],
        [124, 154, 116],
        [135, 149, 113],
        [142, 153,  93],
        [137, 162,  61],
        [205, 209,  86],
        [230, 185,  58],
        [255, 183,  62],
        [255, 182,  73],
        [246, 190, 116],
        [  0,   5,   0],
        [  0,  12,  25]],

       [[167, 145,  26],
        [163, 140,  28],
        [162, 137,  37],
        [162, 137,  45],
        [153, 136,  46],
        [145, 134,  42],
        [144, 140,  40],
        [150, 146,  46],
        [156, 142,  45],
        [153, 122,  65],
        [134,  81,  99],
        [130,  76, 126],
        [123,  85, 126],
        [105,  89, 128],
        [ 92, 102, 153],
        [ 60,  97, 165],
        [ 50, 114, 202],
        [ 31, 115, 205],
        [ 28, 119, 189],
        [ 54, 131, 173],
        [105, 144, 151],
        [138, 151, 141],
        [147, 146, 141],
        [149, 143, 117],
        [160, 159,  92],
        [217, 188,  96],
        [255, 176,  77],
        [255, 179,  77],
        [255, 162,  64],
        [255, 159,  89],
        [ 31,   6,   0],
        [  0,   3,   5]],

       [[119, 197,  23],
        [121, 197,  29],
        [124, 193,  42],
        [132, 194,  49],
        [145, 196,  55],
        [161, 203,  59],
        [178, 206,  59],
        [191, 207,  59],
        [196, 199,  58],
        [187, 183,  75],
        [153, 145,  99],
        [135, 138, 117],
        [118, 148, 110],
        [ 96, 152, 115],
        [ 78, 155, 139],
        [ 46, 135, 153],
        [ 33, 125, 192],
        [ 26, 121, 205],
        [ 21, 122, 192],
        [ 43, 117, 166],
        [ 87, 105, 127],
        [114,  97, 107],
        [121,  90, 105],
        [126,  86,  84],
        [132,  88,  49],
        [175, 104,  42],
        [205,  78,   9],
        [231,  73,   0],
        [230,  69,   0],
        [219,  95,  35],
        [ 34,   0,   0],
        [  7,   3,   2]],

       [[ 41, 226,  10],
        [ 46, 226,  15],
        [ 51, 219,  20],
        [ 62, 212,  16],
        [ 93, 215,  16],
        [131, 224,  22],
        [164, 223,  21],
        [177, 214,  13],
        [191, 217,  22],
        [180, 207,  42],
        [131, 173,  63],
        [102, 168,  78],
        [ 82, 184,  82],
        [ 64, 193, 101],
        [ 45, 188, 134],
        [ 13, 152, 147],
        [ 28, 143, 198],
        [ 36, 139, 218],
        [ 37, 140, 209],
        [ 62, 125, 178],
        [111,  96, 127],
        [140,  78, 101],
        [151,  73,  97],
        [164,  72,  83],
        [167,  65,  50],
        [210,  83,  50],
        [234,  64,  28],
        [252,  67,  23],
        [238,  63,   8],
        [210,  82,  37],
        [ 34,   0,   0],
        [  1,   0,   4]],

       [[ 14, 255,  23],
        [ 22, 255,  27],
        [ 27, 248,  23],
        [ 38, 234,  10],
        [ 77, 234,   5],
        [127, 245,  13],
        [163, 239,   7],
        [176, 225,   0],
        [178, 216,   0],
        [166, 209,  15],
        [113, 177,  29],
        [ 78, 171,  41],
        [ 62, 189,  50],
        [ 53, 200,  83],
        [ 38, 191, 127],
        [  2, 149, 143],
        [  4, 133, 190],
        [ 12, 131, 213],
        [ 20, 132, 206],
        [ 52, 116, 177],
        [113,  85, 125],
        [150,  67,  95],
        [164,  66,  91],
        [181,  66,  81],
        [194,  63,  55],
        [226,  71,  51],
        [239,  52,  33],
        [250,  56,  29],
        [234,  57,  15],
        [203,  75,  38],
        [ 42,   0,   0],
        [ 10,   2,   0]],

       [[  0, 251,  19],
        [  5, 252,  23],
        [ 15, 241,  17],
        [ 29, 228,   1],
        [ 70, 231,   0],
        [122, 242,   4],
        [159, 237,   3],
        [171, 222,   0],
        [186, 228,   6],
        [175, 222,  22],
        [126, 188,  29],
        [ 93, 174,  33],
        [ 80, 184,  37],
        [ 76, 189,  73],
        [ 69, 175, 127],
        [ 25, 138, 154],
        [  8, 140, 212],
        [  1, 140, 235],
        [  8, 138, 224],
        [ 44, 121, 191],
        [113,  91, 137],
        [150,  74, 102],
        [160,  72,  88],
        [174,  68,  70],
        [195,  65,  51],
        [224,  69,  49],
        [235,  53,  40],
        [248,  63,  43],
        [230,  67,  26],
        [192,  70,  29],
        [ 46,   0,   0],
        [ 15,   0,   0]],

       [[ 37, 234,  58],
        [ 45, 233,  60],
        [ 55, 225,  58],
        [ 70, 216,  47],
        [101, 215,  39],
        [137, 220,  44],
        [163, 216,  48],
        [170, 207,  42],
        [170, 205,  43],
        [163, 203,  55],
        [125, 176,  55],
        [103, 168,  52],
        [ 96, 173,  43],
        [ 94, 170,  70],
        [ 99, 159, 133],
        [ 66, 133, 160],
        [ 33, 131, 192],
        [ 19, 133, 206],
        [ 17, 130, 200],
        [ 48, 117, 174],
        [114,  93, 126],
        [144,  80,  96],
        [141,  81,  83],
        [146,  78,  69],
        [166,  73,  58],
        [191,  77,  66],
        [204,  68,  70],
        [219,  81,  78],
        [205,  83,  59],
        [168,  79,  47],
        [ 50,  13,   0],
        [ 10,   1,   0]],

       [[  0,  28,   0],
        [  0,  25,   0],
        [  0,  19,   0],
        [  0,  15,   0],
        [  0,  10,   0],
        [  0,   7,   0],
        [  5,   4,   0],
        [  5,   6,   0],
        [  1,  13,   0],
        [  0,  21,   0],
        [  0,  15,   0],
        [  0,  19,   0],
        [  0,  24,   0],
        [  0,  20,   0],
        [  0,   8,   6],
        [  0,   1,  30],
        [  0,   5,  28],
        [  0,  10,  32],
        [  0,  15,  41],
        [  0,   9,  28],
        [ 18,   0,   0],
        [ 31,   0,   0],
        [ 10,   0,   0],
        [  4,   1,   0],
        [ 18,   0,   0],
        [ 27,   0,   0],
        [ 32,   0,   7],
        [ 36,   0,   5],
        [ 35,   0,   0],
        [ 31,   1,   0],
        [  0,   1,   0],
        [  0,   5,   7]],

       [[  0,   2,   0],
        [  3,   0,   0],
        [ 10,   0,   4],
        [ 17,   0,  10],
        [ 22,   0,  11],
        [ 18,   0,  14],
        [ 15,   0,  25],
        [  9,   0,  29],
        [  0,   0,  21],
        [  0,   5,  18],
        [  0,   8,  11],
        [  0,  16,   0],
        [  0,  20,   0],
        [  0,  13,   0],
        [  7,   4,  15],
        [  8,   0,  25],
        [  6,   0,   2],
        [  0,   4,   0],
        [  0,  13,  16],
        [  0,   8,   9],
        [ 22,   0,   0],
        [ 25,   0,   0],
        [  0,   7,   0],
        [  0,  12,   0],
        [  0,   7,   0],
        [  0,   5,  15],
        [  1,   0,  32],
        [ 10,   0,  33],
        [  9,   0,  10],
        [  8,   6,  11],
        [  0,   5,  14],
        [  0,  16,  27]]], dtype=np.uint8),
)

image_decoder_decode_jpeg_grayscale = ImageData(
    image_decoder_decode_jpeg_rgb.data,
    np.array([[[141], [142], [143], [142], [149], [209], [214], [209], [211], [207], [202], [206], [209], [200], [205], [228], [231], [234], [229], [239], [ 48], [ 63], [ 51], [ 61], [ 45], [124], [112], [115], [107], [119], [  5], [  6]],[[144], [144], [144], [141], [146], [203], [208], [203], [215], [211], [205], [208], [210], [202], [208], [233], [227], [228], [235], [227], [ 59], [ 53], [ 60], [ 61], [ 65], [122], [103], [118], [119], [115], [  5], [  4]],[[147], [146], [145], [144], [148], [205], [211], [209], [211], [207], [201], [201], [204], [197], [204], [227], [232], [231], [233], [224], [ 60], [ 51], [ 56], [ 56], [ 58], [118], [110], [117], [122], [114], [  9], [  8]],[[140], [139], [141], [144], [149], [205], [211], [213], [214], [213], [206], [206], [208], [203], [209], [230], [231], [237], [223], [228], [ 59], [ 69], [ 52], [ 61], [ 39], [115], [124], [111], [113], [117], [  9], [  9]],[[147], [146], [148], [150], [151], [201], [204], [206], [207], [207], [199], [197], [200], [202], [207], [226], [229], [241], [237], [221], [ 68], [ 53], [ 40], [ 61], [ 76], [112], [119], [102], [108], [115], [  5], [  4]],[[ 55], [ 52], [ 53], [ 52], [ 46], [ 86], [ 84], [ 87], [ 87], [ 91], [ 88], [ 89], [ 93], [ 88], [ 90], [105], [109], [ 86], [ 89], [112], [169], [192], [196], [172], [154], [109], [ 98], [ 98], [109], [106], [  3], [  3]],[[ 56], [ 53], [ 54], [ 54], [ 45], [ 80], [ 75], [ 77], [ 80], [ 88], [ 92], [ 95], [100], [ 95], [ 93], [104], [ 90], [ 97], [118], [102], [175], [159], [180], [187], [189], [102], [ 95], [100], [102], [ 98], [  3], [  3]],[[ 51], [ 49], [ 54], [ 57], [ 50], [ 85], [ 80], [ 81], [ 71], [ 83], [ 90], [ 95], [ 97], [ 94], [ 90], [ 99], [101], [103], [ 89], [ 92], [188], [190], [177], [179], [175], [ 96], [109], [103], [ 89], [ 96], [  8], [  4]],[[ 53], [ 56], [ 54], [ 51], [ 58], [ 73], [ 81], [ 79], [ 75], [ 81], [ 98], [100], [ 88], [ 90], [ 98], [101], [100], [106], [ 94], [ 96], [183], [185], [173], [178], [186], [102], [104], [ 92], [106], [ 87], [  7], [ 11]],[[ 47], [ 51], [ 50], [ 47], [ 55], [ 71], [ 79], [ 77], [ 81], [ 70], [ 91], [ 96], [ 94], [100], [ 92], [102], [ 94], [ 99], [ 98], [112], [166], [179], [178], [184], [158], [106], [109], [ 99], [109], [ 97], [  2], [  6]],[[ 54], [ 58], [ 57], [ 54], [ 61], [ 76], [ 83], [ 81], [ 84], [ 79], [127], [128], [120], [129], [132], [186], [206], [207], [204], [190], [138], [125], [121], [123], [151], [152], [163], [164], [165], [155], [ 17], [ 10]],[[ 54], [ 57], [ 56], [ 52], [ 57], [ 71], [ 76], [ 73], [ 71], [ 67], [128], [124], [114], [121], [129], [218], [207], [206], [211], [211], [121], [122], [128], [127], [119], [157], [166], [168], [162], [160], [ 12], [ 10]],[[ 54], [ 59], [ 58], [ 54], [ 60], [ 73], [ 79], [ 75], [ 91], [ 76], [124], [125], [127], [129], [121], [203], [207], [194], [194], [204], [117], [129], [129], [116], [127], [172], [168], [165], [158], [168], [ 17], [ 13]],[[ 50], [ 54], [ 55], [ 52], [ 59], [ 73], [ 78], [ 75], [ 71], [ 72], [116], [124], [130], [125], [122], [201], [211], [214], [214], [214], [124], [125], [126], [128], [121], [158], [160], [164], [161], [166], [ 13], [ 11]],[[ 54], [ 59], [ 58], [ 54], [ 60], [ 71], [ 75], [ 71], [ 79], [ 93], [118], [123], [126], [115], [130], [209], [199], [212], [206], [197], [131], [122], [116], [129], [139], [154], [159], [167], [168], [162], [  7], [  3]],[[ 96], [ 99], [ 96], [ 90], [ 93], [101], [103], [ 97], [ 96], [ 92], [ 73], [ 68], [ 78], [ 66], [ 77], [135], [143], [144], [131], [153], [166], [188], [175], [176], [167], [153], [142], [138], [140], [136], [  4], [  5]],[[ 95], [ 95], [ 95], [ 95], [ 95], [ 96], [ 98], [ 98], [ 98], [ 94], [ 75], [ 69], [ 74], [ 78], [ 67], [144], [142], [143], [142], [140], [180], [178], [177], [178], [178], [139], [150], [143], [132], [140], [ 13], [  1]],[[ 93], [ 93], [ 94], [ 95], [ 96], [ 97], [ 99], [ 99], [103], [101], [ 80], [ 72], [ 70], [ 73], [ 68], [143], [142], [143], [142], [140], [181], [178], [177], [179], [176], [133], [142], [148], [141], [141], [  8], [  1]],[[ 93], [ 94], [ 95], [ 96], [ 98], [ 99], [100], [101], [ 94], [ 95], [ 74], [ 70], [ 67], [ 73], [ 75], [143], [140], [142], [141], [138], [180], [177], [176], [178], [188], [143], [137], [143], [141], [143], [  8], [  7]],[[ 92], [ 93], [ 94], [ 94], [ 95], [ 95], [ 95], [ 94], [100], [101], [ 77], [ 78], [ 75], [ 81], [ 83], [132], [143], [144], [144], [141], [183], [181], [180], [182], [166], [147], [140], [140], [138], [144], [  7], [  4]],[[138], [138], [138], [138], [137], [135], [133], [132], [129], [125], [ 93], [ 96], [ 91], [ 92], [ 87], [110], [100], [102], [101], [ 99], [141], [139], [138], [140], [156], [185], [195], [194], [189], [194], [ 15], [  5]],[[137], [137], [137], [136], [134], [130], [127], [126], [136], [132], [ 95], [104], [ 99], [100], [ 95], [ 99], [102], [104], [104], [102], [144], [142], [142], [144], [133], [189], [197], [191], [186], [195], [  5], [  5]],[[137], [138], [138], [137], [135], [132], [129], [127], [127], [126], [ 90], [102], [ 96], [100], [102], [ 99], [101], [103], [102], [101], [143], [141], [141], [143], [146], [199], [192], [186], [185], [197], [  5], [ 13]],[[135], [136], [137], [137], [136], [133], [130], [128], [131], [132], [ 95], [105], [ 93], [ 96], [103], [ 98], [101], [103], [102], [101], [143], [141], [141], [143], [143], [194], [184], [191], [191], [198], [  3], [ 10]],[[138], [134], [133], [134], [131], [127], [130], [136], [135], [125], [ 99], [ 98], [101], [ 98], [105], [ 94], [105], [100], [100], [113], [133], [146], [146], [142], [152], [186], [188], [190], [179], [180], [ 13], [  2]],[[154], [155], [155], [159], [165], [174], [181], [185], [182], [172], [142], [135], [135], [131], [130], [110], [105], [102], [100], [100], [102], [103], [101], [ 98], [ 97], [118], [108], [112], [109], [125], [ 10], [  4]],[[146], [148], [146], [145], [156], [173], [182], [180], [187], [180], [148], [138], [142], [144], [139], [110], [115], [117], [117], [112], [104], [ 99], [ 99], [101], [ 94], [117], [111], [117], [109], [115], [ 10], [  1]],[[156], [159], [156], [150], [161], [183], [190], [185], [180], [174], [141], [128], [135], [143], [138], [104], [101], [105], [107], [104], [ 98], [ 95], [ 98], [102], [101], [115], [106], [111], [105], [109], [ 13], [  4]],[[150], [152], [148], [143], [157], [179], [187], [181], [190], [185], [151], [134], [136], [142], [138], [106], [109], [109], [109], [106], [103], [100], [100], [100], [102], [113], [106], [116], [111], [102], [ 14], [  4]],[[155], [157], [155], [153], [161], [175], [181], [177], [176], [174], [147], [135], [135], [136], [138], [116], [109], [107], [104], [103], [103], [101], [ 99], [ 97], [ 99], [110], [109], [122], [117], [102], [ 23], [  4]],[[ 16], [ 15], [ 11], [  9], [  6], [  4], [  4], [  5], [  8], [ 12], [  9], [ 11], [ 14], [ 12], [  5], [  4], [  6], [ 10], [ 13], [  8], [  5], [  9], [  3], [  2], [  5], [  8], [ 10], [ 11], [ 10], [ 10], [  1], [  4]],[[  1], [  1], [  3], [  6], [  8], [  7], [  7], [  6], [  2], [  5], [  6], [  9], [ 12], [  8], [  6], [  5], [  2], [  2], [  9], [  6], [  7], [  7], [  4], [  7], [  4], [  5], [  4], [  7], [  4], [  7], [  5], [ 12]]], dtype=np.uint8),
)

image_decoder_decode_jpeg_bgr = ImageData(
    image_decoder_decode_jpeg_rgb.data,
    np.array([[[255,  73, 230],
        [255,  76, 227],
        [255,  81, 222],
        [206,  95, 211],
        [142, 123, 204],
        [133, 202, 251],
        [ 72, 226, 245],
        [ 34, 230, 234],
        [ 32, 234, 235],
        [ 32, 229, 231],
        [ 37, 221, 227],
        [ 45, 224, 233],
        [ 42, 227, 237],
        [ 32, 216, 232],
        [ 35, 219, 243],
        [ 63, 247, 255],
        [ 71, 255, 246],
        [ 83, 255, 249],
        [ 68, 253, 243],
        [134, 251, 255],
        [ 46,  23,  97],
        [121,  19, 127],
        [124,   0, 123],
        [128,  19, 118],
        [ 82,  28,  63],
        [143, 133,  99],
        [128, 146,  39],
        [110, 162,  24],
        [ 64, 157,  26],
        [ 76, 154,  66],
        [  0,   9,   0],
        [  9,   0,  15]],

       [[255,  77, 232],
        [255,  79, 228],
        [254,  83, 221],
        [208,  93, 210],
        [146, 117, 202],
        [137, 193, 248],
        [ 77, 216, 242],
        [ 35, 222, 230],
        [ 40, 237, 239],
        [ 36, 233, 235],
        [ 37, 225, 230],
        [ 41, 227, 235],
        [ 42, 228, 238],
        [ 34, 220, 230],
        [ 41, 225, 237],
        [ 70, 253, 255],
        [ 68, 250, 242],
        [ 70, 251, 242],
        [ 79, 255, 255],
        [124, 232, 255],
        [ 57,  32, 112],
        [108,   9, 119],
        [129,  10, 132],
        [121,  21, 117],
        [ 95,  50,  83],
        [134, 132,  98],
        [108, 137,  34],
        [106, 165,  31],
        [ 75, 168,  40],
        [ 71, 151,  62],
        [  0,   9,   0],
        [  5,   0,  11]],

       [[255,  81, 234],
        [255,  82, 229],
        [250,  86, 221],
        [218,  95, 211],
        [164, 115, 207],
        [161, 189, 254],
        [101, 213, 249],
        [ 57, 224, 238],
        [ 41, 232, 235],
        [ 30, 229, 231],
        [ 26, 221, 229],
        [ 26, 221, 229],
        [ 29, 225, 231],
        [ 27, 219, 218],
        [ 45, 229, 215],
        [ 71, 252, 237],
        [ 76, 252, 252],
        [ 80, 248, 255],
        [ 94, 249, 255],
        [135, 225, 255],
        [ 58,  30, 120],
        [101,   6, 120],
        [116,   9, 126],
        [104,  20, 109],
        [ 72,  47,  75],
        [113, 130,  97],
        [ 98, 144,  48],
        [ 89, 163,  37],
        [ 72, 169,  48],
        [ 66, 151,  59],
        [  0,  16,   0],
        [  0,  13,   0]],

       [[236,  83, 216],
        [238,  83, 211],
        [246,  88, 205],
        [226,  98, 203],
        [181, 114, 205],
        [178, 184, 255],
        [120, 207, 255],
        [ 77, 220, 251],
        [ 56, 228, 246],
        [ 46, 228, 247],
        [ 43, 216, 248],
        [ 45, 214, 251],
        [ 50, 217, 250],
        [ 51, 217, 234],
        [ 69, 232, 217],
        [ 95, 255, 234],
        [ 93, 251, 245],
        [104, 254, 255],
        [101, 232, 252],
        [153, 228, 255],
        [ 52,  34, 111],
        [103,  33, 126],
        [ 93,  15, 109],
        [ 91,  34, 103],
        [ 39,  33,  52],
        [ 99, 127,  98],
        [106, 152,  75],
        [ 86, 148,  48],
        [ 78, 151,  53],
        [ 83, 148,  69],
        [  0,  16,   0],
        [  0,  15,   0]],

       [[227, 104, 202],
        [235, 103, 196],
        [253, 106, 191],
        [242, 111, 192],
        [199, 117, 200],
        [192, 176, 253],
        [127, 193, 255],
        [ 85, 204, 255],
        [ 67, 210, 255],
        [ 67, 209, 255],
        [ 76, 195, 255],
        [ 82, 189, 255],
        [ 88, 193, 255],
        [ 88, 197, 255],
        [ 97, 217, 229],
        [118, 246, 229],
        [123, 250, 228],
        [148, 255, 249],
        [145, 251, 245],
        [155, 224, 239],
        [ 49,  57,  97],
        [ 58,  35,  87],
        [ 52,  21,  72],
        [ 68,  48,  83],
        [ 65,  76,  80],
        [ 96, 122,  99],
        [110, 136,  88],
        [ 98, 123,  63],
        [108, 127,  70],
        [115, 130,  86],
        [  0,   9,   0],
        [  0,   7,   0]],

       [[128,  27,  83],
        [137,  23,  76],
        [161,  23,  70],
        [151,  22,  73],
        [103,  16,  84],
        [ 86,  60, 138],
        [ 13,  66, 146],
        [  0,  72, 150],
        [  0,  73, 146],
        [  0,  71, 164],
        [  0,  55, 186],
        [ 15,  48, 198],
        [ 24,  51, 202],
        [ 19,  56, 176],
        [ 16,  81, 136],
        [ 31, 114, 116],
        [ 38, 131,  94],
        [ 17, 112,  62],
        [ 23, 109,  75],
        [ 55, 125, 108],
        [128, 175, 173],
        [162, 194, 200],
        [175, 197, 203],
        [153, 174, 175],
        [131, 161, 150],
        [ 95, 117,  98],
        [102, 105,  83],
        [117, 103,  80],
        [143, 111,  92],
        [138, 107,  92],
        [ 12,   3,   0],
        [  2,   5,   0]],

       [[132,  43,  52],
        [142,  40,  45],
        [167,  38,  41],
        [159,  35,  51],
        [103,  21,  70],
        [ 82,  55, 129],
        [  6,  53, 144],
        [  0,  53, 155],
        [  0,  53, 163],
        [ 10,  52, 189],
        [ 53,  32, 224],
        [ 77,  23, 242],
        [ 88,  25, 251],
        [ 77,  33, 223],
        [ 61,  59, 172],
        [ 65,  98, 131],
        [ 55, 111,  62],
        [ 58, 130,  47],
        [ 72, 146,  80],
        [ 44, 128,  73],
        [104, 200, 153],
        [ 86, 183, 139],
        [120, 202, 160],
        [139, 206, 169],
        [155, 203, 174],
        [ 91, 109,  92],
        [116,  92,  92],
        [148,  90, 101],
        [171,  88, 103],
        [160,  87,  97],
        [ 23,   0,   0],
        [  4,   4,   0]],

       [[140,  47,  26],
        [146,  44,  21],
        [169,  48,  22],
        [158,  47,  39],
        [103,  31,  67],
        [ 83,  62, 131],
        [ 14,  56, 153],
        [  0,  52, 170],
        [  0,  37, 164],
        [ 25,  37, 195],
        [ 71,  21, 233],
        [100,  13, 255],
        [111,  14, 255],
        [103,  20, 236],
        [ 88,  45, 180],
        [ 92,  84, 131],
        [ 92, 118,  70],
        [ 85, 136,  46],
        [ 59, 118,  43],
        [ 41, 122,  53],
        [106, 222, 153],
        [100, 225, 156],
        [101, 209, 143],
        [122, 205, 150],
        [141, 192, 155],
        [ 91, 101,  89],
        [137,  98, 119],
        [161,  83, 120],
        [174,  65, 104],
        [167,  78, 104],
        [ 27,   6,   4],
        [  0,   7,   0]],

       [[161,  50,  18],
        [164,  54,  20],
        [166,  53,  13],
        [140,  47,  26],
        [ 99,  44,  69],
        [ 64,  52, 118],
        [ 23,  55, 155],
        [  0,  48, 170],
        [  2,  41, 169],
        [ 26,  36, 190],
        [ 71,  35, 233],
        [ 91,  26, 249],
        [ 92,  10, 239],
        [102,  23, 218],
        [117,  54, 177],
        [119,  83, 129],
        [105, 112,  75],
        [101, 131,  58],
        [ 78, 116,  56],
        [ 57, 120,  64],
        [110, 214, 151],
        [103, 217, 153],
        [109, 203, 138],
        [134, 202, 147],
        [163, 199, 169],
        [104, 102, 102],
        [132,  88, 124],
        [147,  67, 120],
        [184,  78, 131],
        [147,  68, 101],
        [  7,   9,   3],
        [  0,  18,   0]],

       [[136,  46,  15],
        [138,  52,  16],
        [135,  53,  11],
        [114,  46,  23],
        [ 89,  43,  66],
        [ 76,  48, 114],
        [ 60,  46, 151],
        [ 45,  39, 164],
        [ 51,  43, 167],
        [ 38,  28, 164],
        [ 54,  43, 200],
        [ 59,  43, 214],
        [ 59,  42, 210],
        [ 79,  56, 195],
        [ 94,  65, 144],
        [114,  93, 115],
        [106, 103,  72],
        [108, 116,  63],
        [103, 111,  70],
        [103, 127,  87],
        [129, 187, 139],
        [138, 201, 151],
        [155, 198, 147],
        [177, 198, 160],
        [162, 162, 150],
        [124,  97, 117],
        [141,  86, 143],
        [147,  68, 142],
        [176,  76, 148],
        [145,  74, 124],
        [  0,   0,   6],
        [  0,  10,   0]],

       [[ 88,  57,  36],
        [ 92,  62,  37],
        [ 91,  65,  29],
        [ 88,  55,  39],
        [ 95,  47,  76],
        [115,  47, 118],
        [134,  39, 150],
        [132,  32, 158],
        [123,  41, 154],
        [ 86,  43, 146],
        [ 79, 101, 196],
        [ 45, 111, 194],
        [ 17, 109, 180],
        [ 37, 126, 170],
        [ 77, 138, 140],
        [165, 197, 173],
        [215, 215, 185],
        [235, 214, 183],
        [239, 206, 186],
        [225, 192, 173],
        [165, 142, 120],
        [157, 128, 107],
        [171, 121, 101],
        [178, 118, 112],
        [199, 138, 158],
        [195, 129, 180],
        [198, 130, 215],
        [203, 125, 226],
        [216, 126, 222],
        [189, 125, 201],
        [  3,   6,  44],
        [  0,   5,  23]],

       [[ 65,  58,  43],
        [ 66,  62,  43],
        [ 63,  65,  36],
        [ 64,  55,  42],
        [ 84,  44,  72],
        [121,  41, 112],
        [156,  28, 140],
        [158,  21, 143],
        [140,  28, 130],
        [ 86,  39, 115],
        [ 70, 121, 164],
        [ 14, 132, 151],
        [  0, 127, 131],
        [  0, 142, 127],
        [ 55, 151, 115],
        [190, 235, 196],
        [218, 214, 189],
        [245, 206, 192],
        [255, 208, 201],
        [255, 207, 202],
        [188, 114, 110],
        [202, 113, 109],
        [225, 115, 117],
        [224, 109, 126],
        [195,  95, 137],
        [212, 127, 195],
        [201, 129, 225],
        [200, 127, 237],
        [203, 120, 229],
        [188, 125, 217],
        [  0,   0,  41],
        [  0,   0,  32]],

       [[ 73,  55,  44],
        [ 73,  63,  46],
        [ 63,  66,  41],
        [ 59,  57,  46],
        [ 76,  50,  74],
        [108,  47, 111],
        [146,  35, 141],
        [148,  27, 142],
        [148,  52, 146],
        [ 85,  55, 114],
        [ 55, 130, 139],
        [ 10, 147, 125],
        [  0, 155, 119],
        [ 16, 158, 115],
        [ 68, 140, 104],
        [194, 213, 186],
        [226, 209, 196],
        [235, 190, 186],
        [247, 187, 187],
        [255, 197, 198],
        [202, 105, 109],
        [232, 113, 121],
        [249, 108, 123],
        [231,  91, 122],
        [214,  99, 149],
        [230, 141, 211],
        [200, 133, 225],
        [190, 126, 232],
        [192, 118, 224],
        [196, 132, 227],
        [ 14,   0,  51],
        [  4,   0,  43]],

       [[ 59,  57,  33],
        [ 59,  62,  36],
        [ 53,  66,  34],
        [ 52,  58,  39],
        [ 70,  52,  69],
        [105,  50, 107],
        [140,  36, 137],
        [148,  27, 142],
        [131,  30, 128],
        [ 93,  49, 110],
        [ 68, 120, 126],
        [ 32, 146, 116],
        [ 18, 160, 115],
        [ 31, 150, 112],
        [ 81, 131, 121],
        [196, 200, 205],
        [227, 206, 215],
        [242, 206, 218],
        [248, 207, 215],
        [255, 206, 214],
        [193, 113, 120],
        [215, 110, 121],
        [234, 106, 125],
        [229, 105, 135],
        [192,  97, 141],
        [202, 133, 190],
        [178, 133, 206],
        [176, 135, 216],
        [184, 132, 210],
        [193, 139, 209],
        [ 21,   0,  36],
        [ 18,   0,  29]],

       [[ 33,  75,  22],
        [ 40,  79,  27],
        [ 44,  77,  26],
        [ 50,  65,  33],
        [ 72,  57,  61],
        [106,  50,  99],
        [141,  32, 134],
        [153,  19, 143],
        [162,  29, 146],
        [150,  57, 142],
        [120, 108, 136],
        [ 84, 131, 123],
        [ 57, 141, 123],
        [ 48, 124, 123],
        [ 91, 121, 162],
        [193, 192, 248],
        [197, 185, 227],
        [214, 201, 233],
        [201, 199, 221],
        [197, 192, 207],
        [150, 126, 134],
        [161, 114, 122],
        [174, 105, 116],
        [184, 116, 133],
        [171, 127, 150],
        [165, 143, 171],
        [154, 149, 181],
        [160, 157, 189],
        [177, 156, 188],
        [181, 152, 175],
        [ 30,   0,  11],
        [ 27,   0,   1]],

       [[ 61, 122,  58],
        [ 64, 125,  61],
        [ 64, 121,  60],
        [ 71, 106,  66],
        [ 97,  93,  92],
        [133,  81, 129],
        [170,  59, 165],
        [184,  41, 174],
        [185,  40, 172],
        [165,  48, 151],
        [112,  50, 102],
        [ 73,  60,  82],
        [ 50,  77,  91],
        [ 27,  59,  94],
        [ 50,  53, 134],
        [114, 106, 199],
        [124, 121, 193],
        [121, 127, 186],
        [101, 115, 173],
        [121, 143, 184],
        [139, 165, 179],
        [170, 189, 192],
        [175, 172, 181],
        [176, 174, 180],
        [155, 169, 168],
        [134, 158, 150],
        [119, 151, 134],
        [120, 148, 125],
        [133, 150, 123],
        [140, 143, 121],
        [ 17,   4,   0],
        [ 26,   3,   0]],

       [[ 61, 119,  61],
        [ 54, 121,  60],
        [ 38, 124,  60],
        [ 47, 116,  71],
        [ 79,  97,  96],
        [119,  76, 127],
        [167,  51, 164],
        [183,  39, 181],
        [172,  41, 181],
        [161,  45, 164],
        [139,  40, 118],
        [113,  45, 100],
        [ 85,  56, 106],
        [ 71,  56, 124],
        [ 60,  31, 140],
        [126, 107, 224],
        [105, 114, 212],
        [ 97, 116, 213],
        [ 99, 109, 223],
        [ 89, 116, 206],
        [109, 181, 205],
        [100, 190, 185],
        [110, 182, 192],
        [116, 185, 188],
        [118, 194, 170],
        [ 89, 162, 112],
        [118, 180, 104],
        [120, 176,  87],
        [105, 166,  76],
        [121, 165,  98],
        [  7,  20,   0],
        [  5,   0,   0]],

       [[ 72, 114,  61],
        [ 59, 116,  61],
        [ 37, 121,  63],
        [ 44, 114,  77],
        [ 78,  97, 100],
        [120,  77, 128],
        [168,  54, 161],
        [182,  43, 178],
        [169,  50, 183],
        [163,  52, 174],
        [158,  37, 135],
        [139,  35, 120],
        [104,  38, 120],
        [ 87,  39, 135],
        [ 77,  24, 151],
        [132, 100, 231],
        [ 98, 109, 223],
        [ 86, 111, 227],
        [ 94, 101, 240],
        [ 82, 111, 220],
        [ 92, 183, 210],
        [ 79, 193, 186],
        [ 85, 186, 195],
        [ 94, 191, 189],
        [ 98, 199, 161],
        [ 71, 165,  94],
        [105, 181,  80],
        [118, 190,  76],
        [100, 184,  72],
        [104, 174,  91],
        [  0,  13,   0],
        [  0,   1,   0]],

       [[ 91, 110,  59],
        [ 82, 111,  65],
        [ 63, 113,  73],
        [ 68, 107,  86],
        [ 98,  94, 106],
        [131,  79, 127],
        [169,  62, 149],
        [179,  54, 163],
        [154,  47, 163],
        [155,  48, 164],
        [154,  26, 138],
        [144,  23, 134],
        [111,  23, 136],
        [ 98,  30, 149],
        [ 94,  27, 162],
        [141,  98, 231],
        [ 99, 106, 223],
        [ 87, 110, 226],
        [ 95, 102, 235],
        [ 85, 110, 214],
        [102, 181, 208],
        [ 92, 190, 184],
        [103, 184, 189],
        [112, 189, 181],
        [126, 211, 167],
        [ 90, 174, 102],
        [ 98, 173,  81],
        [104, 181,  83],
        [ 88, 179,  86],
        [ 95, 173, 102],
        [  0,  14,   0],
        [  0,  12,   1]],

       [[ 88,  95,  88],
        [ 81,  95,  94],
        [ 64,  95, 104],
        [ 66,  90, 114],
        [ 88,  81, 124],
        [111,  73, 133],
        [138,  65, 138],
        [142,  60, 143],
        [132,  66, 155],
        [142,  62, 163],
        [148,  29, 144],
        [154,  26, 151],
        [130,  25, 152],
        [124,  33, 160],
        [124,  35, 162],
        [157,  91, 204],
        [138, 115, 200],
        [125, 120, 199],
        [130, 115, 207],
        [114, 121, 190],
        [128, 187, 196],
        [115, 194, 180],
        [122, 189, 186],
        [125, 193, 182],
        [102, 189, 145],
        [ 81, 176, 115],
        [ 80, 170, 104],
        [ 74, 171, 105],
        [ 60, 167, 110],
        [ 75, 167, 124],
        [  0,  12,   0],
        [  0,   7,   0]],

       [[111, 115, 194],
        [103, 114, 198],
        [ 88, 113, 207],
        [ 87, 112, 210],
        [ 96, 111, 204],
        [108, 111, 192],
        [121, 113, 178],
        [123, 114, 171],
        [111, 111, 171],
        [127,  99, 175],
        [144,  49, 159],
        [169,  44, 170],
        [158,  39, 167],
        [159,  43, 164],
        [160,  43, 146],
        [181,  77, 148],
        [162,  84, 108],
        [155,  93,  99],
        [147,  89, 107],
        [122,  94, 100],
        [122, 153, 124],
        [ 96, 157, 121],
        [ 92, 148, 135],
        [ 82, 152, 139],
        [ 76, 179, 142],
        [ 91, 211, 170],
        [ 92, 217, 191],
        [ 84, 212, 200],
        [ 70, 206, 202],
        [ 93, 207, 207],
        [  0,  19,  14],
        [  0,   8,   2]],

       [[ 93,  98, 230],
        [ 87,  97, 234],
        [ 77,  97, 239],
        [ 74,  97, 236],
        [ 79, 101, 220],
        [ 80, 105, 197],
        [ 84, 113, 170],
        [ 85, 117, 158],
        [ 92, 127, 170],
        [118, 112, 177],
        [143,  53, 159],
        [184,  50, 180],
        [182,  44, 175],
        [192,  48, 167],
        [198,  51, 143],
        [205,  69, 117],
        [205,  93,  81],
        [198, 105,  66],
        [182, 105,  73],
        [148, 108,  73],
        [142, 160, 113],
        [112, 161, 117],
        [103, 154, 134],
        [ 84, 158, 140],
        [ 44, 156, 122],
        [ 77, 213, 185],
        [ 73, 213, 214],
        [ 58, 200, 223],
        [ 51, 192, 225],
        [ 89, 201, 224],
        [  0,   7,   4],
        [  0,   8,   0]],

       [[ 82,  93, 245],
        [ 81,  93, 247],
        [ 80,  92, 250],
        [ 79,  95, 242],
        [ 82, 101, 222],
        [ 81, 109, 196],
        [ 79, 119, 168],
        [ 79, 122, 155],
        [ 81, 120, 158],
        [115, 106, 169],
        [148,  45, 156],
        [199,  44, 179],
        [201,  36, 173],
        [215,  44, 166],
        [233,  53, 148],
        [232,  66, 113],
        [220,  92,  73],
        [204, 108,  54],
        [184, 110,  56],
        [147, 113,  59],
        [139, 160, 111],
        [109, 159, 119],
        [100, 153, 133],
        [ 83, 158, 137],
        [ 54, 170, 133],
        [ 84, 222, 198],
        [ 63, 203, 220],
        [ 53, 189, 231],
        [ 61, 183, 235],
        [110, 197, 229],
        [  0,   8,   0],
        [ 21,  18,   0]],

       [[ 57, 106, 222],
        [ 60, 107, 223],
        [ 66, 106, 225],
        [ 70, 109, 218],
        [ 72, 115, 202],
        [ 69, 120, 182],
        [ 64, 128, 159],
        [ 64, 129, 150],
        [ 71, 129, 158],
        [107, 118, 170],
        [138,  59, 150],
        [185,  58, 167],
        [178,  46, 152],
        [192,  54, 142],
        [216,  68, 128],
        [218,  76,  95],
        [218,  99,  60],
        [208, 113,  44],
        [187, 116,  42],
        [152, 117,  49],
        [147, 159, 111],
        [116, 154, 124],
        [113, 149, 135],
        [ 93, 153, 142],
        [ 61, 162, 137],
        [ 86, 209, 205],
        [ 58, 185, 230],
        [ 62, 183, 255],
        [ 73, 182, 255],
        [116, 190, 246],
        [  0,   5,   0],
        [ 25,  12,   0]],

       [[ 26, 145, 167],
        [ 28, 140, 163],
        [ 37, 137, 162],
        [ 45, 137, 162],
        [ 46, 136, 153],
        [ 42, 134, 145],
        [ 40, 140, 144],
        [ 46, 146, 150],
        [ 45, 142, 156],
        [ 65, 122, 153],
        [ 99,  81, 134],
        [126,  76, 130],
        [126,  85, 123],
        [128,  89, 105],
        [153, 102,  92],
        [165,  97,  60],
        [202, 114,  50],
        [205, 115,  31],
        [189, 119,  28],
        [173, 131,  54],
        [151, 144, 105],
        [141, 151, 138],
        [141, 146, 147],
        [117, 143, 149],
        [ 92, 159, 160],
        [ 96, 188, 217],
        [ 77, 176, 255],
        [ 77, 179, 255],
        [ 64, 162, 255],
        [ 89, 159, 255],
        [  0,   6,  31],
        [  5,   3,   0]],

       [[ 23, 197, 119],
        [ 29, 197, 121],
        [ 42, 193, 124],
        [ 49, 194, 132],
        [ 55, 196, 145],
        [ 59, 203, 161],
        [ 59, 206, 178],
        [ 59, 207, 191],
        [ 58, 199, 196],
        [ 75, 183, 187],
        [ 99, 145, 153],
        [117, 138, 135],
        [110, 148, 118],
        [115, 152,  96],
        [139, 155,  78],
        [153, 135,  46],
        [192, 125,  33],
        [205, 121,  26],
        [192, 122,  21],
        [166, 117,  43],
        [127, 105,  87],
        [107,  97, 114],
        [105,  90, 121],
        [ 84,  86, 126],
        [ 49,  88, 132],
        [ 42, 104, 175],
        [  9,  78, 205],
        [  0,  73, 231],
        [  0,  69, 230],
        [ 35,  95, 219],
        [  0,   0,  34],
        [  2,   3,   7]],

       [[ 10, 226,  41],
        [ 15, 226,  46],
        [ 20, 219,  51],
        [ 16, 212,  62],
        [ 16, 215,  93],
        [ 22, 224, 131],
        [ 21, 223, 164],
        [ 13, 214, 177],
        [ 22, 217, 191],
        [ 42, 207, 180],
        [ 63, 173, 131],
        [ 78, 168, 102],
        [ 82, 184,  82],
        [101, 193,  64],
        [134, 188,  45],
        [147, 152,  13],
        [198, 143,  28],
        [218, 139,  36],
        [209, 140,  37],
        [178, 125,  62],
        [127,  96, 111],
        [101,  78, 140],
        [ 97,  73, 151],
        [ 83,  72, 164],
        [ 50,  65, 167],
        [ 50,  83, 210],
        [ 28,  64, 234],
        [ 23,  67, 252],
        [  8,  63, 238],
        [ 37,  82, 210],
        [  0,   0,  34],
        [  4,   0,   1]],

       [[ 23, 255,  14],
        [ 27, 255,  22],
        [ 23, 248,  27],
        [ 10, 234,  38],
        [  5, 234,  77],
        [ 13, 245, 127],
        [  7, 239, 163],
        [  0, 225, 176],
        [  0, 216, 178],
        [ 15, 209, 166],
        [ 29, 177, 113],
        [ 41, 171,  78],
        [ 50, 189,  62],
        [ 83, 200,  53],
        [127, 191,  38],
        [143, 149,   2],
        [190, 133,   4],
        [213, 131,  12],
        [206, 132,  20],
        [177, 116,  52],
        [125,  85, 113],
        [ 95,  67, 150],
        [ 91,  66, 164],
        [ 81,  66, 181],
        [ 55,  63, 194],
        [ 51,  71, 226],
        [ 33,  52, 239],
        [ 29,  56, 250],
        [ 15,  57, 234],
        [ 38,  75, 203],
        [  0,   0,  42],
        [  0,   2,  10]],

       [[ 19, 251,   0],
        [ 23, 252,   5],
        [ 17, 241,  15],
        [  1, 228,  29],
        [  0, 231,  70],
        [  4, 242, 122],
        [  3, 237, 159],
        [  0, 222, 171],
        [  6, 228, 186],
        [ 22, 222, 175],
        [ 29, 188, 126],
        [ 33, 174,  93],
        [ 37, 184,  80],
        [ 73, 189,  76],
        [127, 175,  69],
        [154, 138,  25],
        [212, 140,   8],
        [235, 140,   1],
        [224, 138,   8],
        [191, 121,  44],
        [137,  91, 113],
        [102,  74, 150],
        [ 88,  72, 160],
        [ 70,  68, 174],
        [ 51,  65, 195],
        [ 49,  69, 224],
        [ 40,  53, 235],
        [ 43,  63, 248],
        [ 26,  67, 230],
        [ 29,  70, 192],
        [  0,   0,  46],
        [  0,   0,  15]],

       [[ 58, 234,  37],
        [ 60, 233,  45],
        [ 58, 225,  55],
        [ 47, 216,  70],
        [ 39, 215, 101],
        [ 44, 220, 137],
        [ 48, 216, 163],
        [ 42, 207, 170],
        [ 43, 205, 170],
        [ 55, 203, 163],
        [ 55, 176, 125],
        [ 52, 168, 103],
        [ 43, 173,  96],
        [ 70, 170,  94],
        [133, 159,  99],
        [160, 133,  66],
        [192, 131,  33],
        [206, 133,  19],
        [200, 130,  17],
        [174, 117,  48],
        [126,  93, 114],
        [ 96,  80, 144],
        [ 83,  81, 141],
        [ 69,  78, 146],
        [ 58,  73, 166],
        [ 66,  77, 191],
        [ 70,  68, 204],
        [ 78,  81, 219],
        [ 59,  83, 205],
        [ 47,  79, 168],
        [  0,  13,  50],
        [  0,   1,  10]],

       [[  0,  28,   0],
        [  0,  25,   0],
        [  0,  19,   0],
        [  0,  15,   0],
        [  0,  10,   0],
        [  0,   7,   0],
        [  0,   4,   5],
        [  0,   6,   5],
        [  0,  13,   1],
        [  0,  21,   0],
        [  0,  15,   0],
        [  0,  19,   0],
        [  0,  24,   0],
        [  0,  20,   0],
        [  6,   8,   0],
        [ 30,   1,   0],
        [ 28,   5,   0],
        [ 32,  10,   0],
        [ 41,  15,   0],
        [ 28,   9,   0],
        [  0,   0,  18],
        [  0,   0,  31],
        [  0,   0,  10],
        [  0,   1,   4],
        [  0,   0,  18],
        [  0,   0,  27],
        [  7,   0,  32],
        [  5,   0,  36],
        [  0,   0,  35],
        [  0,   1,  31],
        [  0,   1,   0],
        [  7,   5,   0]],

       [[  0,   2,   0],
        [  0,   0,   3],
        [  4,   0,  10],
        [ 10,   0,  17],
        [ 11,   0,  22],
        [ 14,   0,  18],
        [ 25,   0,  15],
        [ 29,   0,   9],
        [ 21,   0,   0],
        [ 18,   5,   0],
        [ 11,   8,   0],
        [  0,  16,   0],
        [  0,  20,   0],
        [  0,  13,   0],
        [ 15,   4,   7],
        [ 25,   0,   8],
        [  2,   0,   6],
        [  0,   4,   0],
        [ 16,  13,   0],
        [  9,   8,   0],
        [  0,   0,  22],
        [  0,   0,  25],
        [  0,   7,   0],
        [  0,  12,   0],
        [  0,   7,   0],
        [ 15,   5,   0],
        [ 32,   0,   1],
        [ 33,   0,  10],
        [ 10,   0,   9],
        [ 11,   6,   8],
        [ 14,   5,   0],
        [ 27,  16,   0]]], dtype=np.uint8),
)

image_decoder_decode_jpeg2k_rgb = ImageData(
  np.array([  0,   0,   0,  12, 106,  80,  32,  32,  13,  10, 135,  10,   0,
         0,   0,  20, 102, 116, 121, 112, 106, 112,  50,  32,   0,   0,
         0,   0, 106, 112,  50,  32,   0,   0,   0,  45, 106, 112,  50,
       104,   0,   0,   0,  22, 105, 104, 100, 114,   0,   0,   0,  32,
         0,   0,   0,  32,   0,   3,   7,   7,   0,   0,   0,   0,   0,
        15,  99, 111, 108, 114,   1,   0,   0,   0,   0,   0,  16,   0,
         0,   7,  18, 106, 112,  50,  99, 255,  79, 255,  81,   0,  47,
         0,   0,   0,   0,   0,  32,   0,   0,   0,  32,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,  32,   0,   0,   0,  32,
         0,   0,   0,   0,   0,   0,   0,   0,   0,   3,   7,   1,   1,
         7,   1,   1,   7,   1,   1, 255,  82,   0,  12,   0,   0,   0,
         1,   0,   5,   4,   4,   0,   1, 255,  92,   0,  19,  64,  64,
        72,  72,  80,  72,  72,  80,  72,  72,  80,  72,  72,  80,  72,
        72,  80, 255, 100,   0,  37,   0,   1,  67, 114, 101,  97, 116,
       101, 100,  32,  98, 121,  32,  79, 112, 101, 110,  74,  80,  69,
        71,  32, 118, 101, 114, 115, 105, 111, 110,  32,  50,  46,  53,
        46,  48, 255, 144,   0,  10,   0,   0,   0,   0,   6, 139,   0,
         1, 255, 147, 195, 231,   4,   0,  31, 193, 242,   2,   9, 127,
       195, 231,   2,   7, 195, 234,   2, 143, 180,  10,  31, 104,  16,
         4, 115,   5, 159,   0,  79, 199, 218,   5,  15, 168,  10,  31,
       104,   8,   3,  25,   8, 159,   9, 193, 243, 130, 131, 231,   5,
        63,  48,  32,   9, 111,   8, 127,   4, 167, 199, 218,  11,  63,
         0, 104, 252,   1,  64,  14,  25, 236, 129,  63,  10, 242, 160,
       112,  52, 191,   3,  34, 223, 152,  23, 207, 192,  22,  62, 208,
        88, 125, 160, 192,  14, 120, 105, 193, 230,   9, 210, 147, 177,
        25,   9, 144, 148, 195, 126, 191, 207, 192,  26,  62, 208,  88,
       252,   1,  64,   7, 247, 239,  48, 181, 159,  12,  90,  58, 122,
         9,  12,  13, 199, 195, 143, 207, 192,  78, 126,   2, 113, 248,
        10,   0,  22, 170,  96,  67, 117, 221, 185, 238, 123, 216, 135,
       177,  65,  60,  79, 209, 148,   7, 159,   1,  17,  79, 179, 172,
        17,  21,  60, 101,  99, 223,  82, 254, 246, 110,  40,  44,   0,
       127,  21, 238, 219,  43, 124, 121, 243, 213, 250,  63,  49,  33,
        98,  47, 113,  45, 170, 153, 160, 243, 207, 192,  78, 126,   2,
       144, 251,  68,  64,  34, 100, 150, 169,  72,  29, 190, 139,  77,
       175, 243, 121,  86, 141,  46, 115,  17, 255, 127,  27, 206, 245,
        36, 137,   3,  88, 150, 229,  17,  22,  80, 214, 179, 155, 191,
         9, 119, 234, 159,  22, 133, 163,  43,  90,  41, 169,  46,  72,
        36, 172,  70,  56,  17, 202, 131, 183, 199, 218,  37,  63,   1,
        41, 249, 137, 128,  20, 147, 110, 123, 141, 178, 193,  87, 126,
       222,  22,  15,  24,  73,  29, 111, 114, 149,  32, 218, 201,  39,
       120, 134, 155, 184, 134,  66,  58, 217,  10,   0, 156,  49,  44,
       239,  22,   2, 193,  92, 254, 178, 255,  95,  37, 196,  94,  93,
        83, 106,   3,  55, 215,  87,  63, 223, 154,  12, 252,  17,  35,
       240,  60,  57,  83,  92,   9, 186, 184, 253,  97, 108, 204,  42,
       121, 198,  54, 152, 214, 158, 133, 109, 255,  22,  77, 129, 217,
       162, 182, 150,  79, 119,  10, 227,  28, 236,  98, 161,  32, 251,
       158, 183, 120,  79, 138, 187, 174, 187, 111, 254,  30, 115,  99,
        23, 127,  60, 252,  16, 118, 155,  70,  55, 232, 247,  73, 175,
       224, 111,  60, 142,  99, 107, 203,  71, 232,  40, 144,  21, 187,
        70,  32, 169, 182, 179, 169, 171,  82, 155,  15, 190, 227, 163,
       167,  10, 254, 246, 118,  49, 244, 220, 255, 116, 207, 201,  87,
       180,  16, 121,  97, 154,  12, 240, 180, 206, 164,   0,  13, 219,
       227, 153,  33,  36, 212,  33,  89, 109,   6, 212, 168, 226, 221,
       243,   0,  50,  17, 127,  97, 234, 151,  12,  94, 181,  84, 194,
         7, 118,  33,  72, 104,   4, 221,  22,  70, 229,  50,  52,  80,
       241, 134,  38, 236,  26,  66,  70,  23,  53, 244, 221, 116,  56,
       165, 197, 163,  99,   7, 113,  30, 233, 241,  30,  91, 217, 146,
        56, 101, 216,  39,  56, 250, 172, 211,  15,  16,  47,  65, 127,
       207, 192, 254, 126,   7, 208, 251,  77, 192,  39,  93, 199, 157,
       201, 217,   6,  20,  49, 113,  89,  51, 238, 155, 138, 137, 202,
        96, 134, 221, 198,  47, 240, 209, 203,  72,  12, 202, 155,  22,
       157,  81, 250,   5, 207,  71,  13, 208,  91,  14, 180,  66,  25,
       170, 123, 251, 123, 200,  96, 140, 228, 107,  89,  93,  20,  28,
        69, 249, 146, 179, 144, 250, 127,  62,  97, 226, 175, 173,  54,
       142, 247,   5,  69, 105,  71, 176,  25,  38, 200, 187, 193, 148,
       222, 254,  21, 255, 122, 230,  25, 106,  31, 176,  84,  10, 231,
       179, 117, 255,  50, 202,  29, 225, 188,  22, 227,  11, 177, 103,
        37, 205, 237,  14,  73,  88,  35,  83, 169, 242,  85, 211, 102,
         4, 142,  68,  95,  37,  82,  80, 214,  20,  11,  88, 115, 195,
        98, 106, 218, 114, 145, 123,  75,  75, 137, 231,  55,  77, 234,
       255,  15,  84, 210, 255,  64,  64,  20, 121,  57,  78, 253, 249,
       212,  65, 128, 151,  92,  94, 202, 110, 182,  34, 187,   7,  53,
        92,  36,  83, 100, 165, 121,  71, 207, 192, 250, 126,   7, 176,
       251,  77, 128,  36, 198, 178,  18,  76, 218, 211, 240, 218,  60,
        13, 248,  75, 214,  67,  64,  18,  66, 236, 198,  84, 245,  51,
        12,   3,   1,  92,  45,  35, 139, 118,  66, 222, 137,  88, 222,
        75,  85,  44, 193, 125, 206,  91, 163,  92, 147, 203,  52,  24,
       223, 120,  99, 100,  87,  72,  29,  61, 233,  70, 212, 108, 239,
        82, 243,  93, 156, 226,  55, 118, 254, 179,  72, 189,  40, 125,
       216, 140, 179, 219, 226, 142, 202, 239,  14, 133, 104, 196, 156,
        84, 111, 170, 186, 228, 127, 214,  32, 165,  68, 129, 204, 171,
         3, 120, 212,   6, 164, 158, 250, 178, 132, 138,  76, 206,  80,
        43, 120,   0, 235, 221, 142, 194, 133, 111,  76, 233,  61, 247,
         7, 103,  43, 113,  35, 140,  59, 224,  80, 183, 221,  52, 198,
        22, 127, 253, 147, 102,  60, 126, 241,  91, 200, 146, 170,  69,
       217, 123,  36, 141,  88, 160, 132, 121, 239, 104, 123, 227, 227,
       123, 190, 157,  71,  12, 179,  28, 187, 245,  45, 111, 207, 193,
       146, 126,  12, 112, 251,  77, 192, 172, 193, 118, 152,  92, 250,
       245, 178, 145, 220,   2, 246, 200, 173, 130, 233,  43,  23, 207,
       176, 154, 220,  79, 208, 152, 232,  49, 148, 197,  12,  28, 187,
       215, 231,  74, 253, 114, 157,  45,  56,  62,  45,  55,  37,  63,
       220, 131, 255,  32, 189, 251, 116,  36, 204,  16,  72, 124, 138,
        94,  44,  96, 110,  62, 104,  57, 246,  44, 174, 179, 147, 146,
        32,  91,  92, 114, 196,  87, 209, 170,  88,  95,  21, 139, 254,
        78, 207, 156, 124, 151, 116, 227,  49,  30, 171, 162,  67, 120,
        31, 199, 127, 172, 192,  52,  46, 151, 230, 141, 248, 110,  35,
       243, 135, 232,  26,  43, 142, 196, 185,  12,  31, 123, 137, 118,
       145,  48,  91,  56,  46,  85,  72,  18,  97,  34, 253, 207,  73,
         6, 204, 217, 124, 228,  59, 146, 216,  33,  21, 121, 105, 196,
        65, 232, 214, 181,  33, 112,  35,  55,  32,  33, 125,  46, 251,
       203, 242, 226, 175, 225, 187, 121, 111, 111, 255,  29,  75,   9,
         3, 194, 219, 238,  88, 133,  72, 196, 238,  51, 233, 109,  12,
        25,  10, 233, 187,   9, 192, 207,  13, 156,  39, 179, 130, 200,
        62, 211, 143, 151,  41, 170,  39,  11, 131,  60, 130,  78, 123,
        42, 202,  95,  61, 144, 135,  25,  74, 217, 191, 126,  75,   2,
       248, 229, 162, 158, 203, 118, 243, 164, 243,  12,  46,   4, 178,
       182, 205,  93,  28, 245, 197, 208,  12, 129, 253, 202, 125,  52,
       175, 199, 218, 191,  31, 106, 252,  62, 211,  16,  28, 232,  48,
       162,  23, 193, 178,  85, 202, 167,  50, 213, 135, 203, 213,  27,
        46,  88, 209,  38, 100, 195, 157,  78,   8,  92,  80, 131,   1,
        63, 224, 212,   8,  26,  89,  41, 113,  24, 140,  81,  51, 226,
       213,  93, 247, 195,  32, 162,  62,  37,  90, 178, 221,  91,  29,
       208, 212,  99, 228,  11,  68,  39, 232, 182, 168, 128,  68,  47,
       120,  91, 215,  14,  39, 113, 211, 156,  72, 108,  30, 128, 171,
        43, 176, 182, 171, 113, 246, 165, 179, 121,  20, 155,  19, 123,
       199,  34, 225, 202,  31,  38,  55, 160, 175, 114,  38, 236,  62,
        89, 241, 175,  49, 106, 198,  41,  44, 173,  11, 243,  12,   6,
       173, 111, 165,  11, 112, 162, 192,  47, 188, 234,  18,  87, 128,
       156, 125,  24, 251,  76, 185, 246,  22, 208, 211, 181,  43,   9,
         5, 168,  66, 222, 117,  48,  39, 165, 199, 250, 206,  38,  56,
       205,  16,  78, 244,  43, 227, 148,  36,  44,  93, 250,   6, 159,
        16,  86,   5,  48, 155, 224, 126,  49, 225, 114, 202,  48, 143,
       249,  97, 218, 162,  47,  65, 170,  89, 251, 164, 134, 209,  85,
        26,  37, 116,  11, 118, 109,   5,  54,   2, 191, 141, 206, 195,
        31, 248,  32, 125,   3,  11, 136, 183,  82,   5,  75,  21,  29,
         7, 133,  33, 216, 139,  51,  76,   2,  21, 246, 232, 226, 180,
       170,  62, 199, 218, 181,  31, 106, 236,  62, 211,  80,  28,  76,
        84, 159,   4,  65,  45,  39, 210, 159,  35, 192, 202, 118, 120,
       113, 103, 253,  75,  75,  29,  51, 207,  47, 118,  61, 205,  24,
        61,  63,   1,  17,  52, 104, 120, 192, 211, 103,  43, 123,  71,
       170, 107,   8, 243,  28,  56, 166,  39, 181, 109, 213,   6,  39,
        56, 190, 181,  90,  56,  15, 152, 255,  45,  19, 192, 235, 243,
        23, 245, 230, 151, 239,  68,  55, 179,  23,  15, 235,  29,  68,
       125, 242,   9, 113,  86,  86,  21,  82, 207,  67, 115, 187,  10,
        73,  82, 210, 112,  95, 199, 163, 129,  28, 179,  43,  72, 187,
       122,  30, 152, 227,  80, 163,  50, 129, 121, 138,   9,  19,  10,
        19,  44, 101, 108,  69, 246, 105,  58,  85, 146, 155, 114, 216,
       168,  49,  23, 223,  94, 202, 124,  62, 127,  16,  20,  86,  26,
       183,  95, 189, 192, 165, 141,  55,  91,  79,  49, 229, 108,  77,
       250, 123, 247, 184, 138,  47, 103, 176, 157,   8,  81, 201, 192,
       156,  59, 240, 251,  47,  34,  71,  39,   3, 179,  38, 223, 110,
       159, 133, 196,  85,  72, 241, 227, 104, 224, 110, 127, 216, 242,
        88,  42, 220,  81,  93, 138,  63,  86,  78,  76, 149, 234, 116,
       126,  32,   5,  40,  46, 103, 109, 144, 200, 232,  34, 217, 153,
        38,  76, 185, 122, 147, 225, 110, 237, 245,  41, 121, 206, 151,
       255, 217], dtype=np.uint8),
    np.array([[[226,  81, 251],
        [226,  81, 251],
        [226,  81, 251],
        [226,  81, 251],
        [226,  81, 251],
        [237, 229,  45],
        [237, 229,  45],
        [237, 229,  45],
        [237, 229,  45],
        [237, 229,  45],
        [225, 227,  29],
        [225, 227,  29],
        [225, 227,  29],
        [225, 227,  29],
        [225, 227,  29],
        [253, 253,  80],
        [253, 253,  80],
        [253, 253,  80],
        [253, 253,  80],
        [253, 253,  80],
        [129,   8, 118],
        [129,   8, 118],
        [129,   8, 118],
        [129,   8, 118],
        [129,   8, 118],
        [ 33, 164,  77],
        [ 33, 164,  77],
        [ 33, 164,  77],
        [ 33, 164,  77],
        [ 33, 164,  77],
        [  0,   0,   0],
        [  0,   0,   0]],

       [[226,  81, 251],
        [226,  81, 251],
        [226,  81, 251],
        [226,  81, 251],
        [226,  81, 251],
        [237, 229,  45],
        [237, 229,  45],
        [237, 229,  45],
        [237, 229,  45],
        [237, 229,  45],
        [225, 227,  29],
        [225, 227,  29],
        [225, 227,  29],
        [225, 227,  29],
        [225, 227,  29],
        [253, 253,  80],
        [253, 253,  80],
        [253, 253,  80],
        [253, 253,  80],
        [253, 253,  80],
        [129,   8, 118],
        [129,   8, 118],
        [129,   8, 118],
        [129,   8, 118],
        [129,   8, 118],
        [ 33, 164,  77],
        [ 33, 164,  77],
        [ 33, 164,  77],
        [ 33, 164,  77],
        [ 33, 164,  77],
        [  0,   0,   0],
        [  0,   0,   0]],

       [[226,  81, 251],
        [226,  81, 251],
        [226,  81, 251],
        [226,  81, 251],
        [226,  81, 251],
        [237, 229,  45],
        [237, 229,  45],
        [237, 229,  45],
        [237, 229,  45],
        [237, 229,  45],
        [225, 227,  29],
        [225, 227,  29],
        [225, 227,  29],
        [225, 227,  29],
        [225, 227,  29],
        [253, 253,  80],
        [253, 253,  80],
        [253, 253,  80],
        [253, 253,  80],
        [253, 253,  80],
        [129,   8, 118],
        [129,   8, 118],
        [129,   8, 118],
        [129,   8, 118],
        [129,   8, 118],
        [ 33, 164,  77],
        [ 33, 164,  77],
        [ 33, 164,  77],
        [ 33, 164,  77],
        [ 33, 164,  77],
        [  0,   0,   0],
        [  0,   0,   0]],

       [[226,  81, 251],
        [226,  81, 251],
        [226,  81, 251],
        [226,  81, 251],
        [226,  81, 251],
        [237, 229,  45],
        [237, 229,  45],
        [237, 229,  45],
        [237, 229,  45],
        [237, 229,  45],
        [225, 227,  29],
        [225, 227,  29],
        [225, 227,  29],
        [225, 227,  29],
        [225, 227,  29],
        [253, 253,  80],
        [253, 253,  80],
        [253, 253,  80],
        [253, 253,  80],
        [253, 253,  80],
        [129,   8, 118],
        [129,   8, 118],
        [129,   8, 118],
        [129,   8, 118],
        [129,   8, 118],
        [ 33, 164,  77],
        [ 33, 164,  77],
        [ 33, 164,  77],
        [ 33, 164,  77],
        [ 33, 164,  77],
        [  0,   0,   0],
        [  0,   0,   0]],

       [[226,  81, 251],
        [226,  81, 251],
        [226,  81, 251],
        [226,  81, 251],
        [226,  81, 251],
        [237, 229,  45],
        [237, 229,  45],
        [237, 229,  45],
        [237, 229,  45],
        [237, 229,  45],
        [225, 227,  29],
        [225, 227,  29],
        [225, 227,  29],
        [225, 227,  29],
        [225, 227,  29],
        [253, 253,  80],
        [253, 253,  80],
        [253, 253,  80],
        [253, 253,  80],
        [253, 253,  80],
        [129,   8, 118],
        [129,   8, 118],
        [129,   8, 118],
        [129,   8, 118],
        [129,   8, 118],
        [ 33, 164,  77],
        [ 33, 164,  77],
        [ 33, 164,  77],
        [ 33, 164,  77],
        [ 33, 164,  77],
        [  0,   0,   0],
        [  0,   0,   0]],

       [[ 21,  47, 169],
        [ 21,  47, 169],
        [ 21,  47, 169],
        [ 21,  47, 169],
        [ 21,  47, 169],
        [173,  45,  10],
        [173,  45,  10],
        [173,  45,  10],
        [173,  45,  10],
        [173,  45,  10],
        [254,  15,  94],
        [254,  15,  94],
        [254,  15,  94],
        [254,  15,  94],
        [254,  15,  94],
        [ 52, 126,  81],
        [ 52, 126,  81],
        [ 52, 126,  81],
        [ 52, 126,  81],
        [ 52, 126,  81],
        [145, 211, 101],
        [145, 211, 101],
        [145, 211, 101],
        [145, 211, 101],
        [145, 211, 101],
        [109,  86, 145],
        [109,  86, 145],
        [109,  86, 145],
        [109,  86, 145],
        [109,  86, 145],
        [  0,   0,   0],
        [  0,   0,   0]],

       [[ 21,  47, 169],
        [ 21,  47, 169],
        [ 21,  47, 169],
        [ 21,  47, 169],
        [ 21,  47, 169],
        [173,  45,  10],
        [173,  45,  10],
        [173,  45,  10],
        [173,  45,  10],
        [173,  45,  10],
        [254,  15,  94],
        [254,  15,  94],
        [254,  15,  94],
        [254,  15,  94],
        [254,  15,  94],
        [ 52, 126,  81],
        [ 52, 126,  81],
        [ 52, 126,  81],
        [ 52, 126,  81],
        [ 52, 126,  81],
        [145, 211, 101],
        [145, 211, 101],
        [145, 211, 101],
        [145, 211, 101],
        [145, 211, 101],
        [109,  86, 145],
        [109,  86, 145],
        [109,  86, 145],
        [109,  86, 145],
        [109,  86, 145],
        [  0,   0,   0],
        [  0,   0,   0]],

       [[ 21,  47, 169],
        [ 21,  47, 169],
        [ 21,  47, 169],
        [ 21,  47, 169],
        [ 21,  47, 169],
        [173,  45,  10],
        [173,  45,  10],
        [173,  45,  10],
        [173,  45,  10],
        [173,  45,  10],
        [254,  15,  94],
        [254,  15,  94],
        [254,  15,  94],
        [254,  15,  94],
        [254,  15,  94],
        [ 52, 126,  81],
        [ 52, 126,  81],
        [ 52, 126,  81],
        [ 52, 126,  81],
        [ 52, 126,  81],
        [145, 211, 101],
        [145, 211, 101],
        [145, 211, 101],
        [145, 211, 101],
        [145, 211, 101],
        [109,  86, 145],
        [109,  86, 145],
        [109,  86, 145],
        [109,  86, 145],
        [109,  86, 145],
        [  0,   0,   0],
        [  0,   0,   0]],

       [[ 21,  47, 169],
        [ 21,  47, 169],
        [ 21,  47, 169],
        [ 21,  47, 169],
        [ 21,  47, 169],
        [173,  45,  10],
        [173,  45,  10],
        [173,  45,  10],
        [173,  45,  10],
        [173,  45,  10],
        [254,  15,  94],
        [254,  15,  94],
        [254,  15,  94],
        [254,  15,  94],
        [254,  15,  94],
        [ 52, 126,  81],
        [ 52, 126,  81],
        [ 52, 126,  81],
        [ 52, 126,  81],
        [ 52, 126,  81],
        [145, 211, 101],
        [145, 211, 101],
        [145, 211, 101],
        [145, 211, 101],
        [145, 211, 101],
        [109,  86, 145],
        [109,  86, 145],
        [109,  86, 145],
        [109,  86, 145],
        [109,  86, 145],
        [  0,   0,   0],
        [  0,   0,   0]],

       [[ 21,  47, 169],
        [ 21,  47, 169],
        [ 21,  47, 169],
        [ 21,  47, 169],
        [ 21,  47, 169],
        [173,  45,  10],
        [173,  45,  10],
        [173,  45,  10],
        [173,  45,  10],
        [173,  45,  10],
        [254,  15,  94],
        [254,  15,  94],
        [254,  15,  94],
        [254,  15,  94],
        [254,  15,  94],
        [ 52, 126,  81],
        [ 52, 126,  81],
        [ 52, 126,  81],
        [ 52, 126,  81],
        [ 52, 126,  81],
        [145, 211, 101],
        [145, 211, 101],
        [145, 211, 101],
        [145, 211, 101],
        [145, 211, 101],
        [109,  86, 145],
        [109,  86, 145],
        [109,  86, 145],
        [109,  86, 145],
        [109,  86, 145],
        [  0,   0,   0],
        [  0,   0,   0]],

       [[ 34,  66,  54],
        [ 34,  66,  54],
        [ 34,  66,  54],
        [ 34,  66,  54],
        [ 34,  66,  54],
        [136,  29, 158],
        [136,  29, 158],
        [136,  29, 158],
        [136,  29, 158],
        [136,  29, 158],
        [117, 152,   1],
        [117, 152,   1],
        [117, 152,   1],
        [117, 152,   1],
        [117, 152,   1],
        [187, 208, 244],
        [187, 208, 244],
        [187, 208, 244],
        [187, 208, 244],
        [187, 208, 244],
        [118, 108, 234],
        [118, 108, 234],
        [118, 108, 234],
        [118, 108, 234],
        [118, 108, 234],
        [246, 113, 205],
        [246, 113, 205],
        [246, 113, 205],
        [246, 113, 205],
        [246, 113, 205],
        [  0,   0,   0],
        [  0,   0,   0]],

       [[ 34,  66,  54],
        [ 34,  66,  54],
        [ 34,  66,  54],
        [ 34,  66,  54],
        [ 34,  66,  54],
        [136,  29, 158],
        [136,  29, 158],
        [136,  29, 158],
        [136,  29, 158],
        [136,  29, 158],
        [117, 152,   1],
        [117, 152,   1],
        [117, 152,   1],
        [117, 152,   1],
        [117, 152,   1],
        [187, 208, 244],
        [187, 208, 244],
        [187, 208, 244],
        [187, 208, 244],
        [187, 208, 244],
        [118, 108, 234],
        [118, 108, 234],
        [118, 108, 234],
        [118, 108, 234],
        [118, 108, 234],
        [246, 113, 205],
        [246, 113, 205],
        [246, 113, 205],
        [246, 113, 205],
        [246, 113, 205],
        [  0,   0,   0],
        [  0,   0,   0]],

       [[ 34,  66,  54],
        [ 34,  66,  54],
        [ 34,  66,  54],
        [ 34,  66,  54],
        [ 34,  66,  54],
        [136,  29, 158],
        [136,  29, 158],
        [136,  29, 158],
        [136,  29, 158],
        [136,  29, 158],
        [117, 152,   1],
        [117, 152,   1],
        [117, 152,   1],
        [117, 152,   1],
        [117, 152,   1],
        [187, 208, 244],
        [187, 208, 244],
        [187, 208, 244],
        [187, 208, 244],
        [187, 208, 244],
        [118, 108, 234],
        [118, 108, 234],
        [118, 108, 234],
        [118, 108, 234],
        [118, 108, 234],
        [246, 113, 205],
        [246, 113, 205],
        [246, 113, 205],
        [246, 113, 205],
        [246, 113, 205],
        [  0,   0,   0],
        [  0,   0,   0]],

       [[ 34,  66,  54],
        [ 34,  66,  54],
        [ 34,  66,  54],
        [ 34,  66,  54],
        [ 34,  66,  54],
        [136,  29, 158],
        [136,  29, 158],
        [136,  29, 158],
        [136,  29, 158],
        [136,  29, 158],
        [117, 152,   1],
        [117, 152,   1],
        [117, 152,   1],
        [117, 152,   1],
        [117, 152,   1],
        [187, 208, 244],
        [187, 208, 244],
        [187, 208, 244],
        [187, 208, 244],
        [187, 208, 244],
        [118, 108, 234],
        [118, 108, 234],
        [118, 108, 234],
        [118, 108, 234],
        [118, 108, 234],
        [246, 113, 205],
        [246, 113, 205],
        [246, 113, 205],
        [246, 113, 205],
        [246, 113, 205],
        [  0,   0,   0],
        [  0,   0,   0]],

       [[ 34,  66,  54],
        [ 34,  66,  54],
        [ 34,  66,  54],
        [ 34,  66,  54],
        [ 34,  66,  54],
        [136,  29, 158],
        [136,  29, 158],
        [136,  29, 158],
        [136,  29, 158],
        [136,  29, 158],
        [117, 152,   1],
        [117, 152,   1],
        [117, 152,   1],
        [117, 152,   1],
        [117, 152,   1],
        [187, 208, 244],
        [187, 208, 244],
        [187, 208, 244],
        [187, 208, 244],
        [187, 208, 244],
        [118, 108, 234],
        [118, 108, 234],
        [118, 108, 234],
        [118, 108, 234],
        [118, 108, 234],
        [246, 113, 205],
        [246, 113, 205],
        [246, 113, 205],
        [246, 113, 205],
        [246, 113, 205],
        [  0,   0,   0],
        [  0,   0,   0]],

       [[ 64, 118,  59],
        [ 64, 118,  59],
        [ 64, 118,  59],
        [ 64, 118,  59],
        [ 64, 118,  59],
        [157,  54, 167],
        [157,  54, 167],
        [157,  54, 167],
        [157,  54, 167],
        [157,  54, 167],
        [142,  26, 122],
        [142,  26, 122],
        [142,  26, 122],
        [142,  26, 122],
        [142,  26, 122],
        [236, 105,  88],
        [236, 105,  88],
        [236, 105,  88],
        [236, 105,  88],
        [236, 105,  88],
        [184, 191,  91],
        [184, 191,  91],
        [184, 191,  91],
        [184, 191,  91],
        [184, 191,  91],
        [ 76, 185,  95],
        [ 76, 185,  95],
        [ 76, 185,  95],
        [ 76, 185,  95],
        [ 76, 185,  95],
        [  0,   0,   0],
        [  0,   0,   0]],

       [[ 64, 118,  59],
        [ 64, 118,  59],
        [ 64, 118,  59],
        [ 64, 118,  59],
        [ 64, 118,  59],
        [157,  54, 167],
        [157,  54, 167],
        [157,  54, 167],
        [157,  54, 167],
        [157,  54, 167],
        [142,  26, 122],
        [142,  26, 122],
        [142,  26, 122],
        [142,  26, 122],
        [142,  26, 122],
        [236, 105,  88],
        [236, 105,  88],
        [236, 105,  88],
        [236, 105,  88],
        [236, 105,  88],
        [184, 191,  91],
        [184, 191,  91],
        [184, 191,  91],
        [184, 191,  91],
        [184, 191,  91],
        [ 76, 185,  95],
        [ 76, 185,  95],
        [ 76, 185,  95],
        [ 76, 185,  95],
        [ 76, 185,  95],
        [  0,   0,   0],
        [  0,   0,   0]],

       [[ 64, 118,  59],
        [ 64, 118,  59],
        [ 64, 118,  59],
        [ 64, 118,  59],
        [ 64, 118,  59],
        [157,  54, 167],
        [157,  54, 167],
        [157,  54, 167],
        [157,  54, 167],
        [157,  54, 167],
        [142,  26, 122],
        [142,  26, 122],
        [142,  26, 122],
        [142,  26, 122],
        [142,  26, 122],
        [236, 105,  88],
        [236, 105,  88],
        [236, 105,  88],
        [236, 105,  88],
        [236, 105,  88],
        [184, 191,  91],
        [184, 191,  91],
        [184, 191,  91],
        [184, 191,  91],
        [184, 191,  91],
        [ 76, 185,  95],
        [ 76, 185,  95],
        [ 76, 185,  95],
        [ 76, 185,  95],
        [ 76, 185,  95],
        [  0,   0,   0],
        [  0,   0,   0]],

       [[ 64, 118,  59],
        [ 64, 118,  59],
        [ 64, 118,  59],
        [ 64, 118,  59],
        [ 64, 118,  59],
        [157,  54, 167],
        [157,  54, 167],
        [157,  54, 167],
        [157,  54, 167],
        [157,  54, 167],
        [142,  26, 122],
        [142,  26, 122],
        [142,  26, 122],
        [142,  26, 122],
        [142,  26, 122],
        [236, 105,  88],
        [236, 105,  88],
        [236, 105,  88],
        [236, 105,  88],
        [236, 105,  88],
        [184, 191,  91],
        [184, 191,  91],
        [184, 191,  91],
        [184, 191,  91],
        [184, 191,  91],
        [ 76, 185,  95],
        [ 76, 185,  95],
        [ 76, 185,  95],
        [ 76, 185,  95],
        [ 76, 185,  95],
        [  0,   0,   0],
        [  0,   0,   0]],

       [[ 64, 118,  59],
        [ 64, 118,  59],
        [ 64, 118,  59],
        [ 64, 118,  59],
        [ 64, 118,  59],
        [157,  54, 167],
        [157,  54, 167],
        [157,  54, 167],
        [157,  54, 167],
        [157,  54, 167],
        [142,  26, 122],
        [142,  26, 122],
        [142,  26, 122],
        [142,  26, 122],
        [142,  26, 122],
        [236, 105,  88],
        [236, 105,  88],
        [236, 105,  88],
        [236, 105,  88],
        [236, 105,  88],
        [184, 191,  91],
        [184, 191,  91],
        [184, 191,  91],
        [184, 191,  91],
        [184, 191,  91],
        [ 76, 185,  95],
        [ 76, 185,  95],
        [ 76, 185,  95],
        [ 76, 185,  95],
        [ 76, 185,  95],
        [  0,   0,   0],
        [  0,   0,   0]],

       [[247,  90,  80],
        [247,  90,  80],
        [247,  90,  80],
        [247,  90,  80],
        [247,  90,  80],
        [167, 118,  85],
        [167, 118,  85],
        [167, 118,  85],
        [167, 118,  85],
        [167, 118,  85],
        [172,  39, 208],
        [172,  39, 208],
        [172,  39, 208],
        [172,  39, 208],
        [172,  39, 208],
        [ 60, 106, 191],
        [ 60, 106, 191],
        [ 60, 106, 191],
        [ 60, 106, 191],
        [ 60, 106, 191],
        [114, 163, 112],
        [114, 163, 112],
        [114, 163, 112],
        [114, 163, 112],
        [114, 163, 112],
        [228, 201,  50],
        [228, 201,  50],
        [228, 201,  50],
        [228, 201,  50],
        [228, 201,  50],
        [  0,   0,   0],
        [  0,   0,   0]],

       [[247,  90,  80],
        [247,  90,  80],
        [247,  90,  80],
        [247,  90,  80],
        [247,  90,  80],
        [167, 118,  85],
        [167, 118,  85],
        [167, 118,  85],
        [167, 118,  85],
        [167, 118,  85],
        [172,  39, 208],
        [172,  39, 208],
        [172,  39, 208],
        [172,  39, 208],
        [172,  39, 208],
        [ 60, 106, 191],
        [ 60, 106, 191],
        [ 60, 106, 191],
        [ 60, 106, 191],
        [ 60, 106, 191],
        [114, 163, 112],
        [114, 163, 112],
        [114, 163, 112],
        [114, 163, 112],
        [114, 163, 112],
        [228, 201,  50],
        [228, 201,  50],
        [228, 201,  50],
        [228, 201,  50],
        [228, 201,  50],
        [  0,   0,   0],
        [  0,   0,   0]],

       [[247,  90,  80],
        [247,  90,  80],
        [247,  90,  80],
        [247,  90,  80],
        [247,  90,  80],
        [167, 118,  85],
        [167, 118,  85],
        [167, 118,  85],
        [167, 118,  85],
        [167, 118,  85],
        [172,  39, 208],
        [172,  39, 208],
        [172,  39, 208],
        [172,  39, 208],
        [172,  39, 208],
        [ 60, 106, 191],
        [ 60, 106, 191],
        [ 60, 106, 191],
        [ 60, 106, 191],
        [ 60, 106, 191],
        [114, 163, 112],
        [114, 163, 112],
        [114, 163, 112],
        [114, 163, 112],
        [114, 163, 112],
        [228, 201,  50],
        [228, 201,  50],
        [228, 201,  50],
        [228, 201,  50],
        [228, 201,  50],
        [  0,   0,   0],
        [  0,   0,   0]],

       [[247,  90,  80],
        [247,  90,  80],
        [247,  90,  80],
        [247,  90,  80],
        [247,  90,  80],
        [167, 118,  85],
        [167, 118,  85],
        [167, 118,  85],
        [167, 118,  85],
        [167, 118,  85],
        [172,  39, 208],
        [172,  39, 208],
        [172,  39, 208],
        [172,  39, 208],
        [172,  39, 208],
        [ 60, 106, 191],
        [ 60, 106, 191],
        [ 60, 106, 191],
        [ 60, 106, 191],
        [ 60, 106, 191],
        [114, 163, 112],
        [114, 163, 112],
        [114, 163, 112],
        [114, 163, 112],
        [114, 163, 112],
        [228, 201,  50],
        [228, 201,  50],
        [228, 201,  50],
        [228, 201,  50],
        [228, 201,  50],
        [  0,   0,   0],
        [  0,   0,   0]],

       [[247,  90,  80],
        [247,  90,  80],
        [247,  90,  80],
        [247,  90,  80],
        [247,  90,  80],
        [167, 118,  85],
        [167, 118,  85],
        [167, 118,  85],
        [167, 118,  85],
        [167, 118,  85],
        [172,  39, 208],
        [172,  39, 208],
        [172,  39, 208],
        [172,  39, 208],
        [172,  39, 208],
        [ 60, 106, 191],
        [ 60, 106, 191],
        [ 60, 106, 191],
        [ 60, 106, 191],
        [ 60, 106, 191],
        [114, 163, 112],
        [114, 163, 112],
        [114, 163, 112],
        [114, 163, 112],
        [114, 163, 112],
        [228, 201,  50],
        [228, 201,  50],
        [228, 201,  50],
        [228, 201,  50],
        [228, 201,  50],
        [  0,   0,   0],
        [  0,   0,   0]],

       [[ 24, 246,  11],
        [ 24, 246,  11],
        [ 24, 246,  11],
        [ 24, 246,  11],
        [ 24, 246,  11],
        [177, 219,   6],
        [177, 219,   6],
        [177, 219,   6],
        [177, 219,   6],
        [177, 219,   6],
        [ 77, 188,  37],
        [ 77, 188,  37],
        [ 77, 188,  37],
        [ 77, 188,  37],
        [ 77, 188,  37],
        [  2, 138, 230],
        [  2, 138, 230],
        [  2, 138, 230],
        [  2, 138, 230],
        [  2, 138, 230],
        [159,  74,  81],
        [159,  74,  81],
        [159,  74,  81],
        [159,  74,  81],
        [159,  74,  81],
        [240,  63,  27],
        [240,  63,  27],
        [240,  63,  27],
        [240,  63,  27],
        [240,  63,  27],
        [  0,   0,   0],
        [  0,   0,   0]],

       [[ 24, 246,  11],
        [ 24, 246,  11],
        [ 24, 246,  11],
        [ 24, 246,  11],
        [ 24, 246,  11],
        [177, 219,   6],
        [177, 219,   6],
        [177, 219,   6],
        [177, 219,   6],
        [177, 219,   6],
        [ 77, 188,  37],
        [ 77, 188,  37],
        [ 77, 188,  37],
        [ 77, 188,  37],
        [ 77, 188,  37],
        [  2, 138, 230],
        [  2, 138, 230],
        [  2, 138, 230],
        [  2, 138, 230],
        [  2, 138, 230],
        [159,  74,  81],
        [159,  74,  81],
        [159,  74,  81],
        [159,  74,  81],
        [159,  74,  81],
        [240,  63,  27],
        [240,  63,  27],
        [240,  63,  27],
        [240,  63,  27],
        [240,  63,  27],
        [  0,   0,   0],
        [  0,   0,   0]],

       [[ 24, 246,  11],
        [ 24, 246,  11],
        [ 24, 246,  11],
        [ 24, 246,  11],
        [ 24, 246,  11],
        [177, 219,   6],
        [177, 219,   6],
        [177, 219,   6],
        [177, 219,   6],
        [177, 219,   6],
        [ 77, 188,  37],
        [ 77, 188,  37],
        [ 77, 188,  37],
        [ 77, 188,  37],
        [ 77, 188,  37],
        [  2, 138, 230],
        [  2, 138, 230],
        [  2, 138, 230],
        [  2, 138, 230],
        [  2, 138, 230],
        [159,  74,  81],
        [159,  74,  81],
        [159,  74,  81],
        [159,  74,  81],
        [159,  74,  81],
        [240,  63,  27],
        [240,  63,  27],
        [240,  63,  27],
        [240,  63,  27],
        [240,  63,  27],
        [  0,   0,   0],
        [  0,   0,   0]],

       [[ 24, 246,  11],
        [ 24, 246,  11],
        [ 24, 246,  11],
        [ 24, 246,  11],
        [ 24, 246,  11],
        [177, 219,   6],
        [177, 219,   6],
        [177, 219,   6],
        [177, 219,   6],
        [177, 219,   6],
        [ 77, 188,  37],
        [ 77, 188,  37],
        [ 77, 188,  37],
        [ 77, 188,  37],
        [ 77, 188,  37],
        [  2, 138, 230],
        [  2, 138, 230],
        [  2, 138, 230],
        [  2, 138, 230],
        [  2, 138, 230],
        [159,  74,  81],
        [159,  74,  81],
        [159,  74,  81],
        [159,  74,  81],
        [159,  74,  81],
        [240,  63,  27],
        [240,  63,  27],
        [240,  63,  27],
        [240,  63,  27],
        [240,  63,  27],
        [  0,   0,   0],
        [  0,   0,   0]],

       [[ 24, 246,  11],
        [ 24, 246,  11],
        [ 24, 246,  11],
        [ 24, 246,  11],
        [ 24, 246,  11],
        [177, 219,   6],
        [177, 219,   6],
        [177, 219,   6],
        [177, 219,   6],
        [177, 219,   6],
        [ 77, 188,  37],
        [ 77, 188,  37],
        [ 77, 188,  37],
        [ 77, 188,  37],
        [ 77, 188,  37],
        [  2, 138, 230],
        [  2, 138, 230],
        [  2, 138, 230],
        [  2, 138, 230],
        [  2, 138, 230],
        [159,  74,  81],
        [159,  74,  81],
        [159,  74,  81],
        [159,  74,  81],
        [159,  74,  81],
        [240,  63,  27],
        [240,  63,  27],
        [240,  63,  27],
        [240,  63,  27],
        [240,  63,  27],
        [  0,   0,   0],
        [  0,   0,   0]],

       [[  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0]],

       [[  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0]]], dtype=np.uint8),
)

image_decoder_decode_bmp_rgb = ImageData(
    np.array([ 66,  77,  54,  12,   0,   0,   0,   0,   0,   0,  54,   0,   0,
         0,  40,   0,   0,   0,  32,   0,   0,   0,  32,   0,   0,   0,
         1,   0,  24,   0,   0,   0,   0,   0,   0,  12,   0,   0, 196,
        14,   0,   0, 196,  14,   0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  11,
       246,  24,  11, 246,  24,  11, 246,  24,  11, 246,  24,  11, 246,
        24,   6, 219, 177,   6, 219, 177,   6, 219, 177,   6, 219, 177,
         6, 219, 177,  37, 188,  77,  37, 188,  77,  37, 188,  77,  37,
       188,  77,  37, 188,  77, 230, 138,   2, 230, 138,   2, 230, 138,
         2, 230, 138,   2, 230, 138,   2,  81,  74, 159,  81,  74, 159,
        81,  74, 159,  81,  74, 159,  81,  74, 159,  27,  63, 240,  27,
        63, 240,  27,  63, 240,  27,  63, 240,  27,  63, 240,   0,   0,
         0,   0,   0,   0,  11, 246,  24,  11, 246,  24,  11, 246,  24,
        11, 246,  24,  11, 246,  24,   6, 219, 177,   6, 219, 177,   6,
       219, 177,   6, 219, 177,   6, 219, 177,  37, 188,  77,  37, 188,
        77,  37, 188,  77,  37, 188,  77,  37, 188,  77, 230, 138,   2,
       230, 138,   2, 230, 138,   2, 230, 138,   2, 230, 138,   2,  81,
        74, 159,  81,  74, 159,  81,  74, 159,  81,  74, 159,  81,  74,
       159,  27,  63, 240,  27,  63, 240,  27,  63, 240,  27,  63, 240,
        27,  63, 240,   0,   0,   0,   0,   0,   0,  11, 246,  24,  11,
       246,  24,  11, 246,  24,  11, 246,  24,  11, 246,  24,   6, 219,
       177,   6, 219, 177,   6, 219, 177,   6, 219, 177,   6, 219, 177,
        37, 188,  77,  37, 188,  77,  37, 188,  77,  37, 188,  77,  37,
       188,  77, 230, 138,   2, 230, 138,   2, 230, 138,   2, 230, 138,
         2, 230, 138,   2,  81,  74, 159,  81,  74, 159,  81,  74, 159,
        81,  74, 159,  81,  74, 159,  27,  63, 240,  27,  63, 240,  27,
        63, 240,  27,  63, 240,  27,  63, 240,   0,   0,   0,   0,   0,
         0,  11, 246,  24,  11, 246,  24,  11, 246,  24,  11, 246,  24,
        11, 246,  24,   6, 219, 177,   6, 219, 177,   6, 219, 177,   6,
       219, 177,   6, 219, 177,  37, 188,  77,  37, 188,  77,  37, 188,
        77,  37, 188,  77,  37, 188,  77, 230, 138,   2, 230, 138,   2,
       230, 138,   2, 230, 138,   2, 230, 138,   2,  81,  74, 159,  81,
        74, 159,  81,  74, 159,  81,  74, 159,  81,  74, 159,  27,  63,
       240,  27,  63, 240,  27,  63, 240,  27,  63, 240,  27,  63, 240,
         0,   0,   0,   0,   0,   0,  11, 246,  24,  11, 246,  24,  11,
       246,  24,  11, 246,  24,  11, 246,  24,   6, 219, 177,   6, 219,
       177,   6, 219, 177,   6, 219, 177,   6, 219, 177,  37, 188,  77,
        37, 188,  77,  37, 188,  77,  37, 188,  77,  37, 188,  77, 230,
       138,   2, 230, 138,   2, 230, 138,   2, 230, 138,   2, 230, 138,
         2,  81,  74, 159,  81,  74, 159,  81,  74, 159,  81,  74, 159,
        81,  74, 159,  27,  63, 240,  27,  63, 240,  27,  63, 240,  27,
        63, 240,  27,  63, 240,   0,   0,   0,   0,   0,   0,  80,  90,
       247,  80,  90, 247,  80,  90, 247,  80,  90, 247,  80,  90, 247,
        85, 118, 167,  85, 118, 167,  85, 118, 167,  85, 118, 167,  85,
       118, 167, 208,  39, 172, 208,  39, 172, 208,  39, 172, 208,  39,
       172, 208,  39, 172, 191, 106,  60, 191, 106,  60, 191, 106,  60,
       191, 106,  60, 191, 106,  60, 112, 163, 114, 112, 163, 114, 112,
       163, 114, 112, 163, 114, 112, 163, 114,  50, 201, 228,  50, 201,
       228,  50, 201, 228,  50, 201, 228,  50, 201, 228,   0,   0,   0,
         0,   0,   0,  80,  90, 247,  80,  90, 247,  80,  90, 247,  80,
        90, 247,  80,  90, 247,  85, 118, 167,  85, 118, 167,  85, 118,
       167,  85, 118, 167,  85, 118, 167, 208,  39, 172, 208,  39, 172,
       208,  39, 172, 208,  39, 172, 208,  39, 172, 191, 106,  60, 191,
       106,  60, 191, 106,  60, 191, 106,  60, 191, 106,  60, 112, 163,
       114, 112, 163, 114, 112, 163, 114, 112, 163, 114, 112, 163, 114,
        50, 201, 228,  50, 201, 228,  50, 201, 228,  50, 201, 228,  50,
       201, 228,   0,   0,   0,   0,   0,   0,  80,  90, 247,  80,  90,
       247,  80,  90, 247,  80,  90, 247,  80,  90, 247,  85, 118, 167,
        85, 118, 167,  85, 118, 167,  85, 118, 167,  85, 118, 167, 208,
        39, 172, 208,  39, 172, 208,  39, 172, 208,  39, 172, 208,  39,
       172, 191, 106,  60, 191, 106,  60, 191, 106,  60, 191, 106,  60,
       191, 106,  60, 112, 163, 114, 112, 163, 114, 112, 163, 114, 112,
       163, 114, 112, 163, 114,  50, 201, 228,  50, 201, 228,  50, 201,
       228,  50, 201, 228,  50, 201, 228,   0,   0,   0,   0,   0,   0,
        80,  90, 247,  80,  90, 247,  80,  90, 247,  80,  90, 247,  80,
        90, 247,  85, 118, 167,  85, 118, 167,  85, 118, 167,  85, 118,
       167,  85, 118, 167, 208,  39, 172, 208,  39, 172, 208,  39, 172,
       208,  39, 172, 208,  39, 172, 191, 106,  60, 191, 106,  60, 191,
       106,  60, 191, 106,  60, 191, 106,  60, 112, 163, 114, 112, 163,
       114, 112, 163, 114, 112, 163, 114, 112, 163, 114,  50, 201, 228,
        50, 201, 228,  50, 201, 228,  50, 201, 228,  50, 201, 228,   0,
         0,   0,   0,   0,   0,  80,  90, 247,  80,  90, 247,  80,  90,
       247,  80,  90, 247,  80,  90, 247,  85, 118, 167,  85, 118, 167,
        85, 118, 167,  85, 118, 167,  85, 118, 167, 208,  39, 172, 208,
        39, 172, 208,  39, 172, 208,  39, 172, 208,  39, 172, 191, 106,
        60, 191, 106,  60, 191, 106,  60, 191, 106,  60, 191, 106,  60,
       112, 163, 114, 112, 163, 114, 112, 163, 114, 112, 163, 114, 112,
       163, 114,  50, 201, 228,  50, 201, 228,  50, 201, 228,  50, 201,
       228,  50, 201, 228,   0,   0,   0,   0,   0,   0,  59, 118,  64,
        59, 118,  64,  59, 118,  64,  59, 118,  64,  59, 118,  64, 167,
        54, 157, 167,  54, 157, 167,  54, 157, 167,  54, 157, 167,  54,
       157, 122,  26, 142, 122,  26, 142, 122,  26, 142, 122,  26, 142,
       122,  26, 142,  88, 105, 236,  88, 105, 236,  88, 105, 236,  88,
       105, 236,  88, 105, 236,  91, 191, 184,  91, 191, 184,  91, 191,
       184,  91, 191, 184,  91, 191, 184,  95, 185,  76,  95, 185,  76,
        95, 185,  76,  95, 185,  76,  95, 185,  76,   0,   0,   0,   0,
         0,   0,  59, 118,  64,  59, 118,  64,  59, 118,  64,  59, 118,
        64,  59, 118,  64, 167,  54, 157, 167,  54, 157, 167,  54, 157,
       167,  54, 157, 167,  54, 157, 122,  26, 142, 122,  26, 142, 122,
        26, 142, 122,  26, 142, 122,  26, 142,  88, 105, 236,  88, 105,
       236,  88, 105, 236,  88, 105, 236,  88, 105, 236,  91, 191, 184,
        91, 191, 184,  91, 191, 184,  91, 191, 184,  91, 191, 184,  95,
       185,  76,  95, 185,  76,  95, 185,  76,  95, 185,  76,  95, 185,
        76,   0,   0,   0,   0,   0,   0,  59, 118,  64,  59, 118,  64,
        59, 118,  64,  59, 118,  64,  59, 118,  64, 167,  54, 157, 167,
        54, 157, 167,  54, 157, 167,  54, 157, 167,  54, 157, 122,  26,
       142, 122,  26, 142, 122,  26, 142, 122,  26, 142, 122,  26, 142,
        88, 105, 236,  88, 105, 236,  88, 105, 236,  88, 105, 236,  88,
       105, 236,  91, 191, 184,  91, 191, 184,  91, 191, 184,  91, 191,
       184,  91, 191, 184,  95, 185,  76,  95, 185,  76,  95, 185,  76,
        95, 185,  76,  95, 185,  76,   0,   0,   0,   0,   0,   0,  59,
       118,  64,  59, 118,  64,  59, 118,  64,  59, 118,  64,  59, 118,
        64, 167,  54, 157, 167,  54, 157, 167,  54, 157, 167,  54, 157,
       167,  54, 157, 122,  26, 142, 122,  26, 142, 122,  26, 142, 122,
        26, 142, 122,  26, 142,  88, 105, 236,  88, 105, 236,  88, 105,
       236,  88, 105, 236,  88, 105, 236,  91, 191, 184,  91, 191, 184,
        91, 191, 184,  91, 191, 184,  91, 191, 184,  95, 185,  76,  95,
       185,  76,  95, 185,  76,  95, 185,  76,  95, 185,  76,   0,   0,
         0,   0,   0,   0,  59, 118,  64,  59, 118,  64,  59, 118,  64,
        59, 118,  64,  59, 118,  64, 167,  54, 157, 167,  54, 157, 167,
        54, 157, 167,  54, 157, 167,  54, 157, 122,  26, 142, 122,  26,
       142, 122,  26, 142, 122,  26, 142, 122,  26, 142,  88, 105, 236,
        88, 105, 236,  88, 105, 236,  88, 105, 236,  88, 105, 236,  91,
       191, 184,  91, 191, 184,  91, 191, 184,  91, 191, 184,  91, 191,
       184,  95, 185,  76,  95, 185,  76,  95, 185,  76,  95, 185,  76,
        95, 185,  76,   0,   0,   0,   0,   0,   0,  54,  66,  34,  54,
        66,  34,  54,  66,  34,  54,  66,  34,  54,  66,  34, 158,  29,
       136, 158,  29, 136, 158,  29, 136, 158,  29, 136, 158,  29, 136,
         1, 152, 117,   1, 152, 117,   1, 152, 117,   1, 152, 117,   1,
       152, 117, 244, 208, 187, 244, 208, 187, 244, 208, 187, 244, 208,
       187, 244, 208, 187, 234, 108, 118, 234, 108, 118, 234, 108, 118,
       234, 108, 118, 234, 108, 118, 205, 113, 246, 205, 113, 246, 205,
       113, 246, 205, 113, 246, 205, 113, 246,   0,   0,   0,   0,   0,
         0,  54,  66,  34,  54,  66,  34,  54,  66,  34,  54,  66,  34,
        54,  66,  34, 158,  29, 136, 158,  29, 136, 158,  29, 136, 158,
        29, 136, 158,  29, 136,   1, 152, 117,   1, 152, 117,   1, 152,
       117,   1, 152, 117,   1, 152, 117, 244, 208, 187, 244, 208, 187,
       244, 208, 187, 244, 208, 187, 244, 208, 187, 234, 108, 118, 234,
       108, 118, 234, 108, 118, 234, 108, 118, 234, 108, 118, 205, 113,
       246, 205, 113, 246, 205, 113, 246, 205, 113, 246, 205, 113, 246,
         0,   0,   0,   0,   0,   0,  54,  66,  34,  54,  66,  34,  54,
        66,  34,  54,  66,  34,  54,  66,  34, 158,  29, 136, 158,  29,
       136, 158,  29, 136, 158,  29, 136, 158,  29, 136,   1, 152, 117,
         1, 152, 117,   1, 152, 117,   1, 152, 117,   1, 152, 117, 244,
       208, 187, 244, 208, 187, 244, 208, 187, 244, 208, 187, 244, 208,
       187, 234, 108, 118, 234, 108, 118, 234, 108, 118, 234, 108, 118,
       234, 108, 118, 205, 113, 246, 205, 113, 246, 205, 113, 246, 205,
       113, 246, 205, 113, 246,   0,   0,   0,   0,   0,   0,  54,  66,
        34,  54,  66,  34,  54,  66,  34,  54,  66,  34,  54,  66,  34,
       158,  29, 136, 158,  29, 136, 158,  29, 136, 158,  29, 136, 158,
        29, 136,   1, 152, 117,   1, 152, 117,   1, 152, 117,   1, 152,
       117,   1, 152, 117, 244, 208, 187, 244, 208, 187, 244, 208, 187,
       244, 208, 187, 244, 208, 187, 234, 108, 118, 234, 108, 118, 234,
       108, 118, 234, 108, 118, 234, 108, 118, 205, 113, 246, 205, 113,
       246, 205, 113, 246, 205, 113, 246, 205, 113, 246,   0,   0,   0,
         0,   0,   0,  54,  66,  34,  54,  66,  34,  54,  66,  34,  54,
        66,  34,  54,  66,  34, 158,  29, 136, 158,  29, 136, 158,  29,
       136, 158,  29, 136, 158,  29, 136,   1, 152, 117,   1, 152, 117,
         1, 152, 117,   1, 152, 117,   1, 152, 117, 244, 208, 187, 244,
       208, 187, 244, 208, 187, 244, 208, 187, 244, 208, 187, 234, 108,
       118, 234, 108, 118, 234, 108, 118, 234, 108, 118, 234, 108, 118,
       205, 113, 246, 205, 113, 246, 205, 113, 246, 205, 113, 246, 205,
       113, 246,   0,   0,   0,   0,   0,   0, 169,  47,  21, 169,  47,
        21, 169,  47,  21, 169,  47,  21, 169,  47,  21,  10,  45, 173,
        10,  45, 173,  10,  45, 173,  10,  45, 173,  10,  45, 173,  94,
        15, 254,  94,  15, 254,  94,  15, 254,  94,  15, 254,  94,  15,
       254,  81, 126,  52,  81, 126,  52,  81, 126,  52,  81, 126,  52,
        81, 126,  52, 101, 211, 145, 101, 211, 145, 101, 211, 145, 101,
       211, 145, 101, 211, 145, 145,  86, 109, 145,  86, 109, 145,  86,
       109, 145,  86, 109, 145,  86, 109,   0,   0,   0,   0,   0,   0,
       169,  47,  21, 169,  47,  21, 169,  47,  21, 169,  47,  21, 169,
        47,  21,  10,  45, 173,  10,  45, 173,  10,  45, 173,  10,  45,
       173,  10,  45, 173,  94,  15, 254,  94,  15, 254,  94,  15, 254,
        94,  15, 254,  94,  15, 254,  81, 126,  52,  81, 126,  52,  81,
       126,  52,  81, 126,  52,  81, 126,  52, 101, 211, 145, 101, 211,
       145, 101, 211, 145, 101, 211, 145, 101, 211, 145, 145,  86, 109,
       145,  86, 109, 145,  86, 109, 145,  86, 109, 145,  86, 109,   0,
         0,   0,   0,   0,   0, 169,  47,  21, 169,  47,  21, 169,  47,
        21, 169,  47,  21, 169,  47,  21,  10,  45, 173,  10,  45, 173,
        10,  45, 173,  10,  45, 173,  10,  45, 173,  94,  15, 254,  94,
        15, 254,  94,  15, 254,  94,  15, 254,  94,  15, 254,  81, 126,
        52,  81, 126,  52,  81, 126,  52,  81, 126,  52,  81, 126,  52,
       101, 211, 145, 101, 211, 145, 101, 211, 145, 101, 211, 145, 101,
       211, 145, 145,  86, 109, 145,  86, 109, 145,  86, 109, 145,  86,
       109, 145,  86, 109,   0,   0,   0,   0,   0,   0, 169,  47,  21,
       169,  47,  21, 169,  47,  21, 169,  47,  21, 169,  47,  21,  10,
        45, 173,  10,  45, 173,  10,  45, 173,  10,  45, 173,  10,  45,
       173,  94,  15, 254,  94,  15, 254,  94,  15, 254,  94,  15, 254,
        94,  15, 254,  81, 126,  52,  81, 126,  52,  81, 126,  52,  81,
       126,  52,  81, 126,  52, 101, 211, 145, 101, 211, 145, 101, 211,
       145, 101, 211, 145, 101, 211, 145, 145,  86, 109, 145,  86, 109,
       145,  86, 109, 145,  86, 109, 145,  86, 109,   0,   0,   0,   0,
         0,   0, 169,  47,  21, 169,  47,  21, 169,  47,  21, 169,  47,
        21, 169,  47,  21,  10,  45, 173,  10,  45, 173,  10,  45, 173,
        10,  45, 173,  10,  45, 173,  94,  15, 254,  94,  15, 254,  94,
        15, 254,  94,  15, 254,  94,  15, 254,  81, 126,  52,  81, 126,
        52,  81, 126,  52,  81, 126,  52,  81, 126,  52, 101, 211, 145,
       101, 211, 145, 101, 211, 145, 101, 211, 145, 101, 211, 145, 145,
        86, 109, 145,  86, 109, 145,  86, 109, 145,  86, 109, 145,  86,
       109,   0,   0,   0,   0,   0,   0, 251,  81, 226, 251,  81, 226,
       251,  81, 226, 251,  81, 226, 251,  81, 226,  45, 229, 237,  45,
       229, 237,  45, 229, 237,  45, 229, 237,  45, 229, 237,  29, 227,
       225,  29, 227, 225,  29, 227, 225,  29, 227, 225,  29, 227, 225,
        80, 253, 253,  80, 253, 253,  80, 253, 253,  80, 253, 253,  80,
       253, 253, 118,   8, 129, 118,   8, 129, 118,   8, 129, 118,   8,
       129, 118,   8, 129,  77, 164,  33,  77, 164,  33,  77, 164,  33,
        77, 164,  33,  77, 164,  33,   0,   0,   0,   0,   0,   0, 251,
        81, 226, 251,  81, 226, 251,  81, 226, 251,  81, 226, 251,  81,
       226,  45, 229, 237,  45, 229, 237,  45, 229, 237,  45, 229, 237,
        45, 229, 237,  29, 227, 225,  29, 227, 225,  29, 227, 225,  29,
       227, 225,  29, 227, 225,  80, 253, 253,  80, 253, 253,  80, 253,
       253,  80, 253, 253,  80, 253, 253, 118,   8, 129, 118,   8, 129,
       118,   8, 129, 118,   8, 129, 118,   8, 129,  77, 164,  33,  77,
       164,  33,  77, 164,  33,  77, 164,  33,  77, 164,  33,   0,   0,
         0,   0,   0,   0, 251,  81, 226, 251,  81, 226, 251,  81, 226,
       251,  81, 226, 251,  81, 226,  45, 229, 237,  45, 229, 237,  45,
       229, 237,  45, 229, 237,  45, 229, 237,  29, 227, 225,  29, 227,
       225,  29, 227, 225,  29, 227, 225,  29, 227, 225,  80, 253, 253,
        80, 253, 253,  80, 253, 253,  80, 253, 253,  80, 253, 253, 118,
         8, 129, 118,   8, 129, 118,   8, 129, 118,   8, 129, 118,   8,
       129,  77, 164,  33,  77, 164,  33,  77, 164,  33,  77, 164,  33,
        77, 164,  33,   0,   0,   0,   0,   0,   0, 251,  81, 226, 251,
        81, 226, 251,  81, 226, 251,  81, 226, 251,  81, 226,  45, 229,
       237,  45, 229, 237,  45, 229, 237,  45, 229, 237,  45, 229, 237,
        29, 227, 225,  29, 227, 225,  29, 227, 225,  29, 227, 225,  29,
       227, 225,  80, 253, 253,  80, 253, 253,  80, 253, 253,  80, 253,
       253,  80, 253, 253, 118,   8, 129, 118,   8, 129, 118,   8, 129,
       118,   8, 129, 118,   8, 129,  77, 164,  33,  77, 164,  33,  77,
       164,  33,  77, 164,  33,  77, 164,  33,   0,   0,   0,   0,   0,
         0, 251,  81, 226, 251,  81, 226, 251,  81, 226, 251,  81, 226,
       251,  81, 226,  45, 229, 237,  45, 229, 237,  45, 229, 237,  45,
       229, 237,  45, 229, 237,  29, 227, 225,  29, 227, 225,  29, 227,
       225,  29, 227, 225,  29, 227, 225,  80, 253, 253,  80, 253, 253,
        80, 253, 253,  80, 253, 253,  80, 253, 253, 118,   8, 129, 118,
         8, 129, 118,   8, 129, 118,   8, 129, 118,   8, 129,  77, 164,
        33,  77, 164,  33,  77, 164,  33,  77, 164,  33,  77, 164,  33,
         0,   0,   0,   0,   0,   0], dtype=np.uint8),
    image_decoder_decode_jpeg2k_rgb.output,
)

image_decoder_decode_png_rgb = ImageData(
    np.array([137,  80,  78,  71,  13,  10,  26,  10,   0,   0,   0,  13,  73,
        72,  68,  82,   0,   0,   0,  32,   0,   0,   0,  32,   8,   2,
         0,   0,   0, 252,  24, 237, 163,   0,   0,   0, 255,  73,  68,
        65,  84, 120, 156,  99, 124,  20, 248, 155,   1,   9, 112,  79,
        49,  66, 230, 126, 249, 247,   1, 153,  43,  35, 101, 140, 204,
       109, 225,  86,  67, 230,  46, 152, 115,  29, 153, 123,  63, 102,
        51,   3,   3,   3,  19,   3, 141, 193, 168,   5,   4,   1, 139,
       241, 189, 117, 200, 252,  25,  30, 119, 145, 185, 129, 143,  66,
       144, 185, 102, 249, 159, 145, 185, 177, 167, 223,  35, 115, 125,
       154,  93, 144, 185, 147,  25,  70,  35, 121, 112,  88, 192, 168,
       228, 100, 134, 204,  79, 187, 157, 129, 204, 125,  91, 157, 140,
       204, 117, 179,  64, 137, 228, 221, 115, 190,  33, 115,  27,  88,
        31,  35, 115, 185, 250, 141,  25, 134,  67,  16,  13, 125,  11,
        88, 228,  76,  88, 145, 249, 162,  95,  56, 145, 185, 108,  77,
       149, 200,  92,  67, 255,  20, 100, 238, 223,  48, 102, 100, 110,
       216,  47,  22,  20, 179, 251,  25,  24, 134,  67,  16,  13, 125,
        11,  88, 182,  63,  17,  69, 230, 111, 112,  64,  41, 189, 249,
        55,  86,  35, 115,   3,  24,  81, 202, 103, 179,  39,  27, 145,
       185,  51, 212,  14,  33, 115, 101,  24,  24,  24, 134,  67,  16,
        13, 125,  11,  88,  20, 231, 236,  70, 230, 207, 124, 138, 210,
        14, 155, 227, 118,   1, 153, 123, 236, 220,  65, 100, 110, 242,
       242, 135, 200,  92, 158, 175,  47,  49,  45,  24, 250,  65,  52,
       244,  45,  24, 250,   0,   0,  70, 253,  59, 210,  74,  38,  46,
       197,   0,   0,   0,   0,  73,  69,  78,  68, 174,  66,  96, 130],
      dtype=np.uint8),
    image_decoder_decode_bmp_rgb.output,
)

image_decoder_decode_tiff_rgb = ImageData(
    np.array([ 73,  73,  42,   0,   8,   0,   0,   0,  10,   0,   0,   1,   4,
         0,   1,   0,   0,   0,  32,   0,   0,   0,   1,   1,   4,   0,
         1,   0,   0,   0,  32,   0,   0,   0,   2,   1,   3,   0,   3,
         0,   0,   0, 134,   0,   0,   0,   3,   1,   3,   0,   1,   0,
         0,   0,   1,   0,   0,   0,   6,   1,   3,   0,   1,   0,   0,
         0,   2,   0,   0,   0,  17,   1,   4,   0,   1,   0,   0,   0,
       140,   0,   0,   0,  21,   1,   3,   0,   1,   0,   0,   0,   3,
         0,   0,   0,  22,   1,   4,   0,   1,   0,   0,   0,  32,   0,
         0,   0,  23,   1,   4,   0,   1,   0,   0,   0,   0,  12,   0,
         0,  28,   1,   3,   0,   1,   0,   0,   0,   1,   0,   0,   0,
         0,   0,   0,   0,   8,   0,   8,   0,   8,   0, 226,  81, 251,
       226,  81, 251, 226,  81, 251, 226,  81, 251, 226,  81, 251, 237,
       229,  45, 237, 229,  45, 237, 229,  45, 237, 229,  45, 237, 229,
        45, 225, 227,  29, 225, 227,  29, 225, 227,  29, 225, 227,  29,
       225, 227,  29, 253, 253,  80, 253, 253,  80, 253, 253,  80, 253,
       253,  80, 253, 253,  80, 129,   8, 118, 129,   8, 118, 129,   8,
       118, 129,   8, 118, 129,   8, 118,  33, 164,  77,  33, 164,  77,
        33, 164,  77,  33, 164,  77,  33, 164,  77,   0,   0,   0,   0,
         0,   0, 226,  81, 251, 226,  81, 251, 226,  81, 251, 226,  81,
       251, 226,  81, 251, 237, 229,  45, 237, 229,  45, 237, 229,  45,
       237, 229,  45, 237, 229,  45, 225, 227,  29, 225, 227,  29, 225,
       227,  29, 225, 227,  29, 225, 227,  29, 253, 253,  80, 253, 253,
        80, 253, 253,  80, 253, 253,  80, 253, 253,  80, 129,   8, 118,
       129,   8, 118, 129,   8, 118, 129,   8, 118, 129,   8, 118,  33,
       164,  77,  33, 164,  77,  33, 164,  77,  33, 164,  77,  33, 164,
        77,   0,   0,   0,   0,   0,   0, 226,  81, 251, 226,  81, 251,
       226,  81, 251, 226,  81, 251, 226,  81, 251, 237, 229,  45, 237,
       229,  45, 237, 229,  45, 237, 229,  45, 237, 229,  45, 225, 227,
        29, 225, 227,  29, 225, 227,  29, 225, 227,  29, 225, 227,  29,
       253, 253,  80, 253, 253,  80, 253, 253,  80, 253, 253,  80, 253,
       253,  80, 129,   8, 118, 129,   8, 118, 129,   8, 118, 129,   8,
       118, 129,   8, 118,  33, 164,  77,  33, 164,  77,  33, 164,  77,
        33, 164,  77,  33, 164,  77,   0,   0,   0,   0,   0,   0, 226,
        81, 251, 226,  81, 251, 226,  81, 251, 226,  81, 251, 226,  81,
       251, 237, 229,  45, 237, 229,  45, 237, 229,  45, 237, 229,  45,
       237, 229,  45, 225, 227,  29, 225, 227,  29, 225, 227,  29, 225,
       227,  29, 225, 227,  29, 253, 253,  80, 253, 253,  80, 253, 253,
        80, 253, 253,  80, 253, 253,  80, 129,   8, 118, 129,   8, 118,
       129,   8, 118, 129,   8, 118, 129,   8, 118,  33, 164,  77,  33,
       164,  77,  33, 164,  77,  33, 164,  77,  33, 164,  77,   0,   0,
         0,   0,   0,   0, 226,  81, 251, 226,  81, 251, 226,  81, 251,
       226,  81, 251, 226,  81, 251, 237, 229,  45, 237, 229,  45, 237,
       229,  45, 237, 229,  45, 237, 229,  45, 225, 227,  29, 225, 227,
        29, 225, 227,  29, 225, 227,  29, 225, 227,  29, 253, 253,  80,
       253, 253,  80, 253, 253,  80, 253, 253,  80, 253, 253,  80, 129,
         8, 118, 129,   8, 118, 129,   8, 118, 129,   8, 118, 129,   8,
       118,  33, 164,  77,  33, 164,  77,  33, 164,  77,  33, 164,  77,
        33, 164,  77,   0,   0,   0,   0,   0,   0,  21,  47, 169,  21,
        47, 169,  21,  47, 169,  21,  47, 169,  21,  47, 169, 173,  45,
        10, 173,  45,  10, 173,  45,  10, 173,  45,  10, 173,  45,  10,
       254,  15,  94, 254,  15,  94, 254,  15,  94, 254,  15,  94, 254,
        15,  94,  52, 126,  81,  52, 126,  81,  52, 126,  81,  52, 126,
        81,  52, 126,  81, 145, 211, 101, 145, 211, 101, 145, 211, 101,
       145, 211, 101, 145, 211, 101, 109,  86, 145, 109,  86, 145, 109,
        86, 145, 109,  86, 145, 109,  86, 145,   0,   0,   0,   0,   0,
         0,  21,  47, 169,  21,  47, 169,  21,  47, 169,  21,  47, 169,
        21,  47, 169, 173,  45,  10, 173,  45,  10, 173,  45,  10, 173,
        45,  10, 173,  45,  10, 254,  15,  94, 254,  15,  94, 254,  15,
        94, 254,  15,  94, 254,  15,  94,  52, 126,  81,  52, 126,  81,
        52, 126,  81,  52, 126,  81,  52, 126,  81, 145, 211, 101, 145,
       211, 101, 145, 211, 101, 145, 211, 101, 145, 211, 101, 109,  86,
       145, 109,  86, 145, 109,  86, 145, 109,  86, 145, 109,  86, 145,
         0,   0,   0,   0,   0,   0,  21,  47, 169,  21,  47, 169,  21,
        47, 169,  21,  47, 169,  21,  47, 169, 173,  45,  10, 173,  45,
        10, 173,  45,  10, 173,  45,  10, 173,  45,  10, 254,  15,  94,
       254,  15,  94, 254,  15,  94, 254,  15,  94, 254,  15,  94,  52,
       126,  81,  52, 126,  81,  52, 126,  81,  52, 126,  81,  52, 126,
        81, 145, 211, 101, 145, 211, 101, 145, 211, 101, 145, 211, 101,
       145, 211, 101, 109,  86, 145, 109,  86, 145, 109,  86, 145, 109,
        86, 145, 109,  86, 145,   0,   0,   0,   0,   0,   0,  21,  47,
       169,  21,  47, 169,  21,  47, 169,  21,  47, 169,  21,  47, 169,
       173,  45,  10, 173,  45,  10, 173,  45,  10, 173,  45,  10, 173,
        45,  10, 254,  15,  94, 254,  15,  94, 254,  15,  94, 254,  15,
        94, 254,  15,  94,  52, 126,  81,  52, 126,  81,  52, 126,  81,
        52, 126,  81,  52, 126,  81, 145, 211, 101, 145, 211, 101, 145,
       211, 101, 145, 211, 101, 145, 211, 101, 109,  86, 145, 109,  86,
       145, 109,  86, 145, 109,  86, 145, 109,  86, 145,   0,   0,   0,
         0,   0,   0,  21,  47, 169,  21,  47, 169,  21,  47, 169,  21,
        47, 169,  21,  47, 169, 173,  45,  10, 173,  45,  10, 173,  45,
        10, 173,  45,  10, 173,  45,  10, 254,  15,  94, 254,  15,  94,
       254,  15,  94, 254,  15,  94, 254,  15,  94,  52, 126,  81,  52,
       126,  81,  52, 126,  81,  52, 126,  81,  52, 126,  81, 145, 211,
       101, 145, 211, 101, 145, 211, 101, 145, 211, 101, 145, 211, 101,
       109,  86, 145, 109,  86, 145, 109,  86, 145, 109,  86, 145, 109,
        86, 145,   0,   0,   0,   0,   0,   0,  34,  66,  54,  34,  66,
        54,  34,  66,  54,  34,  66,  54,  34,  66,  54, 136,  29, 158,
       136,  29, 158, 136,  29, 158, 136,  29, 158, 136,  29, 158, 117,
       152,   1, 117, 152,   1, 117, 152,   1, 117, 152,   1, 117, 152,
         1, 187, 208, 244, 187, 208, 244, 187, 208, 244, 187, 208, 244,
       187, 208, 244, 118, 108, 234, 118, 108, 234, 118, 108, 234, 118,
       108, 234, 118, 108, 234, 246, 113, 205, 246, 113, 205, 246, 113,
       205, 246, 113, 205, 246, 113, 205,   0,   0,   0,   0,   0,   0,
        34,  66,  54,  34,  66,  54,  34,  66,  54,  34,  66,  54,  34,
        66,  54, 136,  29, 158, 136,  29, 158, 136,  29, 158, 136,  29,
       158, 136,  29, 158, 117, 152,   1, 117, 152,   1, 117, 152,   1,
       117, 152,   1, 117, 152,   1, 187, 208, 244, 187, 208, 244, 187,
       208, 244, 187, 208, 244, 187, 208, 244, 118, 108, 234, 118, 108,
       234, 118, 108, 234, 118, 108, 234, 118, 108, 234, 246, 113, 205,
       246, 113, 205, 246, 113, 205, 246, 113, 205, 246, 113, 205,   0,
         0,   0,   0,   0,   0,  34,  66,  54,  34,  66,  54,  34,  66,
        54,  34,  66,  54,  34,  66,  54, 136,  29, 158, 136,  29, 158,
       136,  29, 158, 136,  29, 158, 136,  29, 158, 117, 152,   1, 117,
       152,   1, 117, 152,   1, 117, 152,   1, 117, 152,   1, 187, 208,
       244, 187, 208, 244, 187, 208, 244, 187, 208, 244, 187, 208, 244,
       118, 108, 234, 118, 108, 234, 118, 108, 234, 118, 108, 234, 118,
       108, 234, 246, 113, 205, 246, 113, 205, 246, 113, 205, 246, 113,
       205, 246, 113, 205,   0,   0,   0,   0,   0,   0,  34,  66,  54,
        34,  66,  54,  34,  66,  54,  34,  66,  54,  34,  66,  54, 136,
        29, 158, 136,  29, 158, 136,  29, 158, 136,  29, 158, 136,  29,
       158, 117, 152,   1, 117, 152,   1, 117, 152,   1, 117, 152,   1,
       117, 152,   1, 187, 208, 244, 187, 208, 244, 187, 208, 244, 187,
       208, 244, 187, 208, 244, 118, 108, 234, 118, 108, 234, 118, 108,
       234, 118, 108, 234, 118, 108, 234, 246, 113, 205, 246, 113, 205,
       246, 113, 205, 246, 113, 205, 246, 113, 205,   0,   0,   0,   0,
         0,   0,  34,  66,  54,  34,  66,  54,  34,  66,  54,  34,  66,
        54,  34,  66,  54, 136,  29, 158, 136,  29, 158, 136,  29, 158,
       136,  29, 158, 136,  29, 158, 117, 152,   1, 117, 152,   1, 117,
       152,   1, 117, 152,   1, 117, 152,   1, 187, 208, 244, 187, 208,
       244, 187, 208, 244, 187, 208, 244, 187, 208, 244, 118, 108, 234,
       118, 108, 234, 118, 108, 234, 118, 108, 234, 118, 108, 234, 246,
       113, 205, 246, 113, 205, 246, 113, 205, 246, 113, 205, 246, 113,
       205,   0,   0,   0,   0,   0,   0,  64, 118,  59,  64, 118,  59,
        64, 118,  59,  64, 118,  59,  64, 118,  59, 157,  54, 167, 157,
        54, 167, 157,  54, 167, 157,  54, 167, 157,  54, 167, 142,  26,
       122, 142,  26, 122, 142,  26, 122, 142,  26, 122, 142,  26, 122,
       236, 105,  88, 236, 105,  88, 236, 105,  88, 236, 105,  88, 236,
       105,  88, 184, 191,  91, 184, 191,  91, 184, 191,  91, 184, 191,
        91, 184, 191,  91,  76, 185,  95,  76, 185,  95,  76, 185,  95,
        76, 185,  95,  76, 185,  95,   0,   0,   0,   0,   0,   0,  64,
       118,  59,  64, 118,  59,  64, 118,  59,  64, 118,  59,  64, 118,
        59, 157,  54, 167, 157,  54, 167, 157,  54, 167, 157,  54, 167,
       157,  54, 167, 142,  26, 122, 142,  26, 122, 142,  26, 122, 142,
        26, 122, 142,  26, 122, 236, 105,  88, 236, 105,  88, 236, 105,
        88, 236, 105,  88, 236, 105,  88, 184, 191,  91, 184, 191,  91,
       184, 191,  91, 184, 191,  91, 184, 191,  91,  76, 185,  95,  76,
       185,  95,  76, 185,  95,  76, 185,  95,  76, 185,  95,   0,   0,
         0,   0,   0,   0,  64, 118,  59,  64, 118,  59,  64, 118,  59,
        64, 118,  59,  64, 118,  59, 157,  54, 167, 157,  54, 167, 157,
        54, 167, 157,  54, 167, 157,  54, 167, 142,  26, 122, 142,  26,
       122, 142,  26, 122, 142,  26, 122, 142,  26, 122, 236, 105,  88,
       236, 105,  88, 236, 105,  88, 236, 105,  88, 236, 105,  88, 184,
       191,  91, 184, 191,  91, 184, 191,  91, 184, 191,  91, 184, 191,
        91,  76, 185,  95,  76, 185,  95,  76, 185,  95,  76, 185,  95,
        76, 185,  95,   0,   0,   0,   0,   0,   0,  64, 118,  59,  64,
       118,  59,  64, 118,  59,  64, 118,  59,  64, 118,  59, 157,  54,
       167, 157,  54, 167, 157,  54, 167, 157,  54, 167, 157,  54, 167,
       142,  26, 122, 142,  26, 122, 142,  26, 122, 142,  26, 122, 142,
        26, 122, 236, 105,  88, 236, 105,  88, 236, 105,  88, 236, 105,
        88, 236, 105,  88, 184, 191,  91, 184, 191,  91, 184, 191,  91,
       184, 191,  91, 184, 191,  91,  76, 185,  95,  76, 185,  95,  76,
       185,  95,  76, 185,  95,  76, 185,  95,   0,   0,   0,   0,   0,
         0,  64, 118,  59,  64, 118,  59,  64, 118,  59,  64, 118,  59,
        64, 118,  59, 157,  54, 167, 157,  54, 167, 157,  54, 167, 157,
        54, 167, 157,  54, 167, 142,  26, 122, 142,  26, 122, 142,  26,
       122, 142,  26, 122, 142,  26, 122, 236, 105,  88, 236, 105,  88,
       236, 105,  88, 236, 105,  88, 236, 105,  88, 184, 191,  91, 184,
       191,  91, 184, 191,  91, 184, 191,  91, 184, 191,  91,  76, 185,
        95,  76, 185,  95,  76, 185,  95,  76, 185,  95,  76, 185,  95,
         0,   0,   0,   0,   0,   0, 247,  90,  80, 247,  90,  80, 247,
        90,  80, 247,  90,  80, 247,  90,  80, 167, 118,  85, 167, 118,
        85, 167, 118,  85, 167, 118,  85, 167, 118,  85, 172,  39, 208,
       172,  39, 208, 172,  39, 208, 172,  39, 208, 172,  39, 208,  60,
       106, 191,  60, 106, 191,  60, 106, 191,  60, 106, 191,  60, 106,
       191, 114, 163, 112, 114, 163, 112, 114, 163, 112, 114, 163, 112,
       114, 163, 112, 228, 201,  50, 228, 201,  50, 228, 201,  50, 228,
       201,  50, 228, 201,  50,   0,   0,   0,   0,   0,   0, 247,  90,
        80, 247,  90,  80, 247,  90,  80, 247,  90,  80, 247,  90,  80,
       167, 118,  85, 167, 118,  85, 167, 118,  85, 167, 118,  85, 167,
       118,  85, 172,  39, 208, 172,  39, 208, 172,  39, 208, 172,  39,
       208, 172,  39, 208,  60, 106, 191,  60, 106, 191,  60, 106, 191,
        60, 106, 191,  60, 106, 191, 114, 163, 112, 114, 163, 112, 114,
       163, 112, 114, 163, 112, 114, 163, 112, 228, 201,  50, 228, 201,
        50, 228, 201,  50, 228, 201,  50, 228, 201,  50,   0,   0,   0,
         0,   0,   0, 247,  90,  80, 247,  90,  80, 247,  90,  80, 247,
        90,  80, 247,  90,  80, 167, 118,  85, 167, 118,  85, 167, 118,
        85, 167, 118,  85, 167, 118,  85, 172,  39, 208, 172,  39, 208,
       172,  39, 208, 172,  39, 208, 172,  39, 208,  60, 106, 191,  60,
       106, 191,  60, 106, 191,  60, 106, 191,  60, 106, 191, 114, 163,
       112, 114, 163, 112, 114, 163, 112, 114, 163, 112, 114, 163, 112,
       228, 201,  50, 228, 201,  50, 228, 201,  50, 228, 201,  50, 228,
       201,  50,   0,   0,   0,   0,   0,   0, 247,  90,  80, 247,  90,
        80, 247,  90,  80, 247,  90,  80, 247,  90,  80, 167, 118,  85,
       167, 118,  85, 167, 118,  85, 167, 118,  85, 167, 118,  85, 172,
        39, 208, 172,  39, 208, 172,  39, 208, 172,  39, 208, 172,  39,
       208,  60, 106, 191,  60, 106, 191,  60, 106, 191,  60, 106, 191,
        60, 106, 191, 114, 163, 112, 114, 163, 112, 114, 163, 112, 114,
       163, 112, 114, 163, 112, 228, 201,  50, 228, 201,  50, 228, 201,
        50, 228, 201,  50, 228, 201,  50,   0,   0,   0,   0,   0,   0,
       247,  90,  80, 247,  90,  80, 247,  90,  80, 247,  90,  80, 247,
        90,  80, 167, 118,  85, 167, 118,  85, 167, 118,  85, 167, 118,
        85, 167, 118,  85, 172,  39, 208, 172,  39, 208, 172,  39, 208,
       172,  39, 208, 172,  39, 208,  60, 106, 191,  60, 106, 191,  60,
       106, 191,  60, 106, 191,  60, 106, 191, 114, 163, 112, 114, 163,
       112, 114, 163, 112, 114, 163, 112, 114, 163, 112, 228, 201,  50,
       228, 201,  50, 228, 201,  50, 228, 201,  50, 228, 201,  50,   0,
         0,   0,   0,   0,   0,  24, 246,  11,  24, 246,  11,  24, 246,
        11,  24, 246,  11,  24, 246,  11, 177, 219,   6, 177, 219,   6,
       177, 219,   6, 177, 219,   6, 177, 219,   6,  77, 188,  37,  77,
       188,  37,  77, 188,  37,  77, 188,  37,  77, 188,  37,   2, 138,
       230,   2, 138, 230,   2, 138, 230,   2, 138, 230,   2, 138, 230,
       159,  74,  81, 159,  74,  81, 159,  74,  81, 159,  74,  81, 159,
        74,  81, 240,  63,  27, 240,  63,  27, 240,  63,  27, 240,  63,
        27, 240,  63,  27,   0,   0,   0,   0,   0,   0,  24, 246,  11,
        24, 246,  11,  24, 246,  11,  24, 246,  11,  24, 246,  11, 177,
       219,   6, 177, 219,   6, 177, 219,   6, 177, 219,   6, 177, 219,
         6,  77, 188,  37,  77, 188,  37,  77, 188,  37,  77, 188,  37,
        77, 188,  37,   2, 138, 230,   2, 138, 230,   2, 138, 230,   2,
       138, 230,   2, 138, 230, 159,  74,  81, 159,  74,  81, 159,  74,
        81, 159,  74,  81, 159,  74,  81, 240,  63,  27, 240,  63,  27,
       240,  63,  27, 240,  63,  27, 240,  63,  27,   0,   0,   0,   0,
         0,   0,  24, 246,  11,  24, 246,  11,  24, 246,  11,  24, 246,
        11,  24, 246,  11, 177, 219,   6, 177, 219,   6, 177, 219,   6,
       177, 219,   6, 177, 219,   6,  77, 188,  37,  77, 188,  37,  77,
       188,  37,  77, 188,  37,  77, 188,  37,   2, 138, 230,   2, 138,
       230,   2, 138, 230,   2, 138, 230,   2, 138, 230, 159,  74,  81,
       159,  74,  81, 159,  74,  81, 159,  74,  81, 159,  74,  81, 240,
        63,  27, 240,  63,  27, 240,  63,  27, 240,  63,  27, 240,  63,
        27,   0,   0,   0,   0,   0,   0,  24, 246,  11,  24, 246,  11,
        24, 246,  11,  24, 246,  11,  24, 246,  11, 177, 219,   6, 177,
       219,   6, 177, 219,   6, 177, 219,   6, 177, 219,   6,  77, 188,
        37,  77, 188,  37,  77, 188,  37,  77, 188,  37,  77, 188,  37,
         2, 138, 230,   2, 138, 230,   2, 138, 230,   2, 138, 230,   2,
       138, 230, 159,  74,  81, 159,  74,  81, 159,  74,  81, 159,  74,
        81, 159,  74,  81, 240,  63,  27, 240,  63,  27, 240,  63,  27,
       240,  63,  27, 240,  63,  27,   0,   0,   0,   0,   0,   0,  24,
       246,  11,  24, 246,  11,  24, 246,  11,  24, 246,  11,  24, 246,
        11, 177, 219,   6, 177, 219,   6, 177, 219,   6, 177, 219,   6,
       177, 219,   6,  77, 188,  37,  77, 188,  37,  77, 188,  37,  77,
       188,  37,  77, 188,  37,   2, 138, 230,   2, 138, 230,   2, 138,
       230,   2, 138, 230,   2, 138, 230, 159,  74,  81, 159,  74,  81,
       159,  74,  81, 159,  74,  81, 159,  74,  81, 240,  63,  27, 240,
        63,  27, 240,  63,  27, 240,  63,  27, 240,  63,  27,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
         0], dtype=np.uint8),
    image_decoder_decode_bmp_rgb.output,
)

image_decoder_decode_webp_rgb = ImageData(
    np.array([ 82,  73,  70,  70,  32,   2,   0,   0,  87,  69,  66,  80,  86,
        80,  56,  32,  20,   2,   0,   0,  80,  13,   0, 157,   1,  42,
        32,   0,  32,   0,  62, 109,  46, 146,  70, 164,  34, 161, 161,
        40,  13,  80, 128,  13, 137, 108,   0, 157,  50, 132, 112,  55,
       151, 254,  57, 126,  51, 115, 134, 108,  25, 128,  93, 115, 126,
        83, 204,   7, 168,  15, 178, 191,  82,  95,  48,  15, 232,  29,
        32,  63,  93, 191, 183, 117, 128, 253,  57, 246,   0, 255, 147,
       230, 171, 236,   1, 232,   1, 230, 153, 254, 107, 245, 239, 225,
        11, 246,  51, 246, 239, 218, 118, 236, 247,  43, 147,  15, 163,
       180,   0, 165,  21, 251,  68,  81,  89, 121,  30,  65, 221, 213,
       115, 111, 216, 229,  96,   0, 253, 210, 122, 138,  75,  92, 219,
       102,  22,  86, 171, 131, 154,   9,  97, 230, 179, 178,  43,  43,
       206,  57, 143,  19, 232, 129,  21, 139,  23, 214, 170,  75,  14,
        52,  78, 111,  88,  54,   0, 216, 240,  73,  98, 154, 194,  36,
        47,  34,  68, 148, 194, 197,  79,  81, 220, 205, 223,  88, 250,
        42,  71, 218,  15, 124, 129,  12,  38, 200, 116, 251,  93, 147,
        57,  36, 183, 245,  31, 100, 160, 116, 212, 180,  65, 118,  26,
         4, 133, 242, 198,  50,  89,  34, 109, 244, 199, 253,  50, 134,
       185,  19, 231, 104,  63, 202, 255, 252, 169,  61, 255, 112,  75,
        33, 165, 235, 249, 208, 254,  59, 253,  66, 115, 104,   1, 198,
        21, 242, 126, 158, 181, 152,  55,  50,  77,  29,  83,   7,  74,
       139,   7, 157, 145, 131, 163,   5, 105, 181, 174,  38, 245,  83,
        73, 183, 195, 243, 162, 207, 173, 142,  14,  38, 114, 149, 107,
       162,   8,  74, 172,  85, 135, 196,  54,  62,  66, 159,  28, 239,
       150,  13,   1, 197, 236, 121, 183,  69, 189,  23, 138,  22,  15,
       245, 216, 244,  67, 220, 105,  77,  80, 101, 145,  47, 254,  82,
        86, 190, 233,  60, 253, 192, 109,  30, 199, 255, 255,  11, 191,
       132, 172, 157, 189, 172,  98,  91, 223,  41, 168,  79, 177, 124,
       248, 219,  66,  28,  89, 184, 193, 218,  73, 123, 199, 170, 197,
        85,  60, 244, 144,  65, 180,  53,  51,  76, 101, 246,  98, 255,
       202, 147, 239, 114,  41,  19, 231, 202, 205,   1,  24,  55,  73,
       164, 212,  62, 253, 138, 147, 181,  58, 249, 167,  19, 186, 248,
       198, 120,  78, 227, 215,   3, 206, 125, 176, 241, 255, 249, 143,
        31,  16, 189, 165, 240, 216,  14,  60,  28, 102, 246,  10, 178,
         9,  29, 179, 207, 170,  34,  51, 136, 167, 194, 160,  17, 118,
       203, 188,  35, 229, 124, 128, 245, 253, 232, 250,  94,  77, 150,
       161,  46,   3, 185, 215,  69, 122, 167, 159, 211, 209, 119, 111,
       211, 153, 178, 160, 153, 174, 180, 229,  61,  15, 196, 225,  48,
        93, 243, 101,  64, 200,  23,  47, 211, 242,  50,  31, 133, 231,
        63, 151, 123,  87, 178,  77, 165, 172, 205,  35, 249, 186, 231,
       150, 205, 218, 230, 245,  10,  39,  42, 157, 116, 223, 241, 120,
       201,  34,  28,  59, 113,  38, 151,  73,  39, 119, 255, 227, 105,
        45, 148,  84,   0,   0,   0], dtype=np.uint8),
    np.array([[[230,  84, 242],
        [230,  84, 240],
        [232,  84, 238],
        [225,  94, 202],
        [207, 108, 126],
        [255, 199, 131],
        [243, 221,  74],
        [229, 229,  47],
        [232, 234,  65],
        [228, 231,  61],
        [228, 226,  43],
        [228, 223,  31],
        [232, 225,  31],
        [227, 221,  34],
        [224, 219,  43],
        [255, 250,  82],
        [255, 247,  84],
        [255, 248,  82],
        [254, 253,  76],
        [255, 236, 130],
        [121,  22,  71],
        [132,   5, 128],
        [126,  10, 122],
        [105,  23, 107],
        [ 70,  43,  86],
        [ 90, 125, 122],
        [ 49, 154,  98],
        [ 27, 166,  83],
        [ 29, 168,  80],
        [ 48, 155,  87],
        [  0,  13,   0],
        [  0,   0,   0]],

       [[229,  84, 244],
        [229,  84, 242],
        [229,  85, 240],
        [222,  95, 204],
        [205, 108, 130],
        [255, 198, 137],
        [244, 219,  80],
        [232, 227,  49],
        [235, 233,  61],
        [232, 230,  55],
        [228, 227,  39],
        [227, 224,  29],
        [230, 226,  31],
        [225, 222,  32],
        [223, 220,  41],
        [255, 251,  80],
        [255, 249,  82],
        [255, 250,  80],
        [252, 254,  76],
        [255, 237, 130],
        [118,  23,  71],
        [130,   6, 126],
        [126,  10, 122],
        [107,  22, 109],
        [ 70,  43,  84],
        [ 90, 125, 120],
        [ 51, 153,  98],
        [ 31, 165,  83],
        [ 32, 167,  80],
        [ 50, 154,  87],
        [  0,  13,   0],
        [  0,   0,   0]],

       [[224,  86, 246],
        [224,  86, 246],
        [222,  87, 244],
        [217,  96, 210],
        [202, 108, 138],
        [255, 196, 147],
        [249, 215,  90],
        [239, 223,  55],
        [240, 233,  53],
        [235, 231,  43],
        [230, 228,  33],
        [227, 224,  27],
        [227, 227,  31],
        [224, 223,  32],
        [221, 221,  37],
        [252, 254,  76],
        [252, 254,  76],
        [250, 254,  76],
        [247, 255,  76],
        [255, 238, 132],
        [115,  25,  69],
        [129,   7, 126],
        [126,   9, 126],
        [107,  21, 112],
        [ 70,  43,  82],
        [ 92, 125, 116],
        [ 56, 152,  94],
        [ 35, 163,  81],
        [ 37, 164,  80],
        [ 55, 151,  89],
        [  0,  11,   0],
        [  0,   0,   2]],

       [[208,  93, 250],
        [208,  93, 250],
        [208,  93, 250],
        [205, 101, 218],
        [194, 111, 148],
        [255, 195, 157],
        [255, 209, 104],
        [250, 215,  67],
        [255, 222,  63],
        [252, 220,  53],
        [249, 215,  49],
        [246, 211,  47],
        [245, 214,  54],
        [237, 212,  56],
        [231, 212,  59],
        [255, 249,  94],
        [244, 254,  94],
        [239, 255,  94],
        [239, 255,  96],
        [252, 241, 142],
        [103,  33,  59],
        [116,  17, 107],
        [116,  17, 107],
        [100,  27,  97],
        [ 69,  46,  74],
        [ 95, 124, 112],
        [ 64, 147,  98],
        [ 47, 156,  87],
        [ 48, 157,  88],
        [ 63, 146,  95],
        [  0,   9,   0],
        [  0,   0,   2]],

       [[183, 109, 255],
        [183, 109, 255],
        [185, 108, 255],
        [186, 113, 229],
        [189, 120, 166],
        [255, 195, 174],
        [255, 217, 133],
        [255, 208,  93],
        [255, 202,  86],
        [255, 195,  84],
        [255, 183,  86],
        [255, 176,  88],
        [255, 180,  98],
        [255, 183, 101],
        [255, 202, 115],
        [255, 230, 132],
        [235, 247, 134],
        [223, 254, 132],
        [224, 253, 130],
        [235, 242, 158],
        [ 84,  46,  41],
        [ 95,  35,  69],
        [ 97,  34,  69],
        [ 86,  41,  65],
        [ 70,  57,  64],
        [102, 125, 112],
        [ 77, 135, 104],
        [ 69, 143, 104],
        [ 72, 147, 108],
        [ 77, 134, 108],
        [  0,  11,   3],
        [  0,   0,   2]],

       [[ 55,  31, 165],
        [ 57,  30, 167],
        [ 62,  27, 171],
        [ 70,  28, 142],
        [ 78,  26,  78],
        [123,  60,  52],
        [140,  64,   1],
        [155,  66,   0],
        [155,  55,   0],
        [174,  52,   0],
        [199,  48,  10],
        [208,  48,  25],
        [204,  54,  38],
        [183,  56,  38],
        [164,  79,  44],
        [146, 109,  58],
        [ 93, 112,  37],
        [ 75, 121,  35],
        [ 77, 121,  33],
        [ 85, 115,  43],
        [184, 183, 147],
        [194, 177, 155],
        [195, 176, 153],
        [190, 178, 157],
        [176, 176, 163],
        [ 92, 107,  97],
        [ 83, 114, 106],
        [ 77, 116, 110],
        [ 75, 115, 111],
        [ 81, 110, 109],
        [  0,   1,   4],
        [  0,   0,   1]],

       [[ 20,  51, 168],
        [ 23,  48, 172],
        [ 31,  43, 176],
        [ 47,  40, 150],
        [ 78,  46, 100],
        [121,  61,  63],
        [142,  53,   8],
        [165,  60,   0],
        [163,  46,   0],
        [189,  45,  18],
        [229,  39,  48],
        [248,  40,  72],
        [233,  35,  75],
        [201,  39,  71],
        [163,  64,  72],
        [131,  95,  79],
        [ 84, 113,  74],
        [ 63, 124,  72],
        [ 63, 124,  72],
        [ 70, 123,  64],
        [158, 197, 127],
        [164, 195, 118],
        [164, 195, 116],
        [167, 191, 129],
        [170, 182, 150],
        [103, 108, 104],
        [ 98,  99, 119],
        [ 93,  93, 125],
        [ 95,  93, 130],
        [ 96,  96, 125],
        [  0,   0,  11],
        [  0,   2,   7]],

       [[  0,  55, 168],
        [  3,  53, 168],
        [ 13,  47, 172],
        [ 32,  43, 146],
        [ 58,  36,  91],
        [121,  63,  71],
        [155,  58,  22],
        [173,  56,   4],
        [170,  47,   9],
        [191,  38,  30],
        [232,  22,  63],
        [249,  17,  84],
        [255,  30, 102],
        [220,  32,  93],
        [171,  56,  90],
        [128,  89,  95],
        [ 77, 112,  89],
        [ 53, 125,  85],
        [ 51, 126,  85],
        [ 56, 127,  69],
        [147, 207, 119],
        [152, 208, 103],
        [151, 209, 101],
        [157, 203, 117],
        [166, 187, 146],
        [105, 105, 105],
        [102,  87, 122],
        [106,  84, 139],
        [113,  92, 149],
        [108,  95, 138],
        [  1,   0,  13],
        [  0,   2,   3]],

       [[  7,  56, 174],
        [ 10,  55, 172],
        [ 16,  52, 168],
        [ 34,  48, 141],
        [ 61,  38,  94],
        [122,  60,  74],
        [152,  50,  20],
        [167,  45,   0],
        [171,  48,   8],
        [184,  32,  26],
        [232,  28,  78],
        [248,  16,  96],
        [254,  20,  99],
        [228,  28,  95],
        [180,  53,  93],
        [120,  73,  82],
        [ 78, 114,  88],
        [ 49, 129,  84],
        [ 47, 131,  80],
        [ 54, 130,  66],
        [145, 210, 118],
        [152, 210, 102],
        [150, 212, 100],
        [157, 205, 116],
        [169, 189, 148],
        [104, 102, 102],
        [112,  92, 133],
        [111,  86, 145],
        [108,  89, 148],
        [104,  93, 134],
        [  2,   0,   4],
        [  1,   3,   0]],

       [[ 15,  58, 141],
        [ 16,  58, 139],
        [ 21,  56, 137],
        [ 36,  51, 123],
        [ 59,  39,  94],
        [119,  58,  92],
        [149,  44,  57],
        [162,  39,  39],
        [165,  44,  48],
        [168,  36,  49],
        [197,  45,  71],
        [199,  35,  65],
        [210,  39,  65],
        [201,  54,  72],
        [157,  65,  73],
        [116,  83,  78],
        [ 78, 111,  91],
        [ 56, 122,  93],
        [ 54, 123,  91],
        [ 59, 122,  85],
        [152, 200, 154],
        [157, 199, 146],
        [155, 200, 146],
        [163, 194, 156],
        [175, 178, 177],
        [114,  93, 123],
        [123,  80, 135],
        [125,  73, 143],
        [125,  80, 148],
        [117,  83, 133],
        [  6,   0,   6],
        [  0,   0,   0]],

       [[ 28,  65,  73],
        [ 28,  64,  77],
        [ 28,  63,  83],
        [ 39,  56,  91],
        [ 56,  41,  94],
        [111,  56, 127],
        [137,  37, 125],
        [149,  29, 124],
        [141,  26, 117],
        [144,  50,  98],
        [168, 112,  76],
        [164, 128,  45],
        [163, 130,  36],
        [151, 124,  40],
        [149, 134,  75],
        [206, 206, 174],
        [191, 212, 205],
        [181, 214, 221],
        [179, 214, 225],
        [183, 210, 235],
        [113, 125, 173],
        [116, 122, 183],
        [114, 122, 187],
        [124, 116, 189],
        [142, 109, 189],
        [195, 134, 218],
        [215, 126, 210],
        [228, 123, 209],
        [223, 120, 207],
        [209, 129, 199],
        [ 20,   0,  18],
        [  6,   0,   8]],

       [[ 37,  66,  43],
        [ 36,  66,  47],
        [ 34,  65,  55],
        [ 40,  59,  69],
        [ 54,  43,  88],
        [106,  56, 137],
        [130,  35, 156],
        [140,  26, 164],
        [133,  25, 157],
        [128,  56, 119],
        [133, 126,  55],
        [117, 147,   5],
        [118, 151,   4],
        [119, 152,  20],
        [123, 147,  55],
        [197, 218, 170],
        [191, 211, 211],
        [189, 208, 233],
        [189, 206, 239],
        [192, 201, 255],
        [117, 115, 212],
        [121, 110, 230],
        [121, 109, 234],
        [130, 105, 230],
        [148,  97, 215],
        [207, 125, 234],
        [228, 114, 212],
        [242, 111, 203],
        [244, 109, 207],
        [222, 118, 197],
        [ 26,   0,  20],
        [  3,   0,  10]],

       [[ 42,  62,  49],
        [ 40,  63,  49],
        [ 37,  64,  51],
        [ 42,  60,  61],
        [ 55,  48,  78],
        [ 96,  53, 120],
        [118,  31, 142],
        [137,  31, 163],
        [133,  32, 160],
        [120,  54, 113],
        [129, 125,  49],
        [113, 143,   0],
        [114, 149,   7],
        [115, 149,  24],
        [117, 146,  54],
        [191, 217, 167],
        [186, 213, 213],
        [186, 208, 237],
        [189, 206, 239],
        [191, 202, 255],
        [113, 115, 215],
        [115, 111, 233],
        [118, 109, 233],
        [129, 105, 227],
        [150, 100, 213],
        [204, 123, 228],
        [230, 117, 212],
        [242, 111, 203],
        [246, 112, 207],
        [223, 120, 194],
        [ 27,   0,  18],
        [  3,   0,   4]],

       [[ 42,  63,  45],
        [ 40,  64,  45],
        [ 37,  65,  47],
        [ 42,  61,  57],
        [ 61,  55,  80],
        [102,  60, 122],
        [124,  38, 144],
        [143,  38, 165],
        [139,  37, 162],
        [123,  49, 112],
        [149, 134,  73],
        [129, 142,  22],
        [131, 143,  27],
        [131, 143,  41],
        [132, 142,  66],
        [206, 215, 173],
        [201, 209, 213],
        [201, 206, 231],
        [204, 204, 231],
        [202, 202, 246],
        [119, 119, 199],
        [119, 117, 213],
        [120, 116, 211],
        [130, 112, 205],
        [142, 105, 190],
        [198, 137, 215],
        [212, 126, 196],
        [225, 122, 191],
        [231, 131, 199],
        [212, 135, 188],
        [ 21,   0,  14],
        [  2,   0,   3]],

       [[ 41,  72,  34],
        [ 39,  72,  38],
        [ 37,  71,  46],
        [ 44,  65,  60],
        [ 61,  52,  82],
        [104,  56, 122],
        [127,  35, 139],
        [148,  34, 159],
        [139,  23, 151],
        [134,  41, 122],
        [157, 110,  92],
        [152, 124,  56],
        [151, 119,  50],
        [155, 120,  59],
        [156, 120,  77],
        [231, 193, 174],
        [230, 195, 202],
        [228, 194, 212],
        [228, 194, 208],
        [222, 196, 216],
        [129, 120, 157],
        [122, 122, 165],
        [122, 123, 161],
        [124, 123, 157],
        [131, 121, 154],
        [174, 153, 183],
        [187, 149, 173],
        [185, 140, 162],
        [188, 151, 170],
        [178, 151, 167],
        [ 10,   0,  10],
        [  2,   0,   6]],

       [[ 72, 113,  67],
        [ 72, 112,  71],
        [ 70, 112,  79],
        [ 80, 104,  93],
        [ 86,  77, 103],
        [128,  82, 143],
        [152,  60, 162],
        [174,  58, 182],
        [165,  47, 173],
        [162,  58, 153],
        [125,  50,  76],
        [122,  58,  47],
        [120,  49,  36],
        [125,  50,  39],
        [128,  51,  45],
        [204, 127, 128],
        [195, 118, 126],
        [193, 119, 126],
        [193, 120, 122],
        [179, 127, 124],
        [190, 176, 169],
        [178, 182, 171],
        [178, 182, 167],
        [175, 184, 167],
        [167, 184, 165],
        [136, 155, 135],
        [137, 150, 127],
        [138, 151, 128],
        [134, 154, 129],
        [137, 154, 137],
        [  0,   0,   0],
        [  2,   0,   4]],

       [[ 64, 116,  73],
        [ 65, 115,  73],
        [ 67, 114,  73],
        [ 76, 108,  83],
        [ 97,  95, 107],
        [121,  78, 129],
        [146,  60, 155],
        [159,  51, 169],
        [159,  49, 168],
        [163,  55, 159],
        [135,  37, 111],
        [137,  38,  97],
        [139,  35,  90],
        [141,  33,  81],
        [143,  35,  67],
        [221, 110, 129],
        [220, 108, 112],
        [222, 109, 104],
        [222, 109, 102],
        [201, 121,  98],
        [200, 179, 129],
        [181, 189, 125],
        [181, 189, 125],
        [173, 193, 125],
        [153, 199, 125],
        [112, 174,  98],
        [103, 172, 101],
        [101, 174, 106],
        [ 96, 171, 105],
        [112, 168, 117],
        [  0,   8,   0],
        [  2,   3,   0]],

       [[ 60, 118,  71],
        [ 62, 117,  71],
        [ 64, 117,  69],
        [ 75, 109,  79],
        [ 95,  97, 101],
        [117,  81, 125],
        [143,  62, 153],
        [157,  52, 167],
        [159,  50, 164],
        [164,  53, 164],
        [143,  29, 129],
        [145,  30, 121],
        [146,  26, 117],
        [149,  25, 103],
        [152,  28,  81],
        [232, 104, 131],
        [233, 104, 102],
        [236, 104,  90],
        [238, 103,  90],
        [214, 117,  84],
        [203, 181, 107],
        [181, 194, 101],
        [181, 194, 101],
        [171, 198, 103],
        [147, 207, 104],
        [102, 182,  80],
        [ 87, 183,  87],
        [ 84, 185,  94],
        [ 80, 181,  92],
        [ 99, 177, 107],
        [  0,  12,   0],
        [  0,   7,   0]],

       [[ 62, 119,  63],
        [ 62, 119,  63],
        [ 64, 118,  65],
        [ 73, 110,  77],
        [ 93,  98,  99],
        [117,  81, 123],
        [143,  63, 149],
        [159,  52, 163],
        [163,  48, 164],
        [169,  51, 162],
        [145,  29, 125],
        [145,  30, 119],
        [146,  27, 115],
        [148,  26, 103],
        [151,  28,  81],
        [232, 105, 129],
        [236, 102, 100],
        [239, 103,  88],
        [239, 103,  90],
        [215, 116,  82],
        [203, 182, 101],
        [179, 196,  95],
        [179, 195,  97],
        [170, 199, 101],
        [148, 206, 104],
        [104, 182,  80],
        [ 91, 181,  85],
        [ 87, 184,  90],
        [ 82, 181,  88],
        [ 99, 177, 105],
        [  0,  14,   0],
        [  0,   9,   0]],

       [[ 97, 102,  55],
        [ 97, 102,  57],
        [ 99, 101,  59],
        [105,  96,  67],
        [117,  88,  85],
        [130,  78, 105],
        [145,  67, 125],
        [153,  61, 135],
        [155,  58, 134],
        [163,  58, 143],
        [143,  29, 129],
        [146,  26, 135],
        [144,  24, 131],
        [141,  25, 121],
        [138,  30, 105],
        [211, 109, 162],
        [206, 111, 134],
        [204, 114, 124],
        [204, 114, 124],
        [187, 125, 112],
        [189, 186, 121],
        [171, 197, 107],
        [171, 197, 109],
        [167, 200, 109],
        [155, 202, 106],
        [118, 175,  74],
        [113, 173,  69],
        [111, 176,  68],
        [106, 173,  66],
        [117, 171,  89],
        [  0,  11,   0],
        [  0,   7,   0]],

       [[205, 108,  89],
        [207, 107,  89],
        [210, 106,  89],
        [210, 105,  91],
        [204, 107,  99],
        [192, 106, 103],
        [180, 107, 111],
        [172, 107, 113],
        [167, 110, 111],
        [174, 103, 138],
        [164,  55, 167],
        [170,  43, 193],
        [170,  43, 191],
        [161,  50, 188],
        [142,  60, 186],
        [124,  73, 179],
        [103,  86, 165],
        [ 92,  96, 156],
        [ 89,  98, 152],
        [ 88, 104, 131],
        [123, 153, 125],
        [122, 158, 101],
        [119, 161,  97],
        [122, 160,  90],
        [129, 161,  77],
        [188, 209, 108],
        [202, 208,  85],
        [205, 206,  74],
        [204, 212,  79],
        [197, 205, 104],
        [  6,   5,   0],
        [  1,   0,   0]],

       [[240,  92,  81],
        [242,  91,  81],
        [245,  90,  81],
        [240,  92,  83],
        [228,  98,  85],
        [207, 102,  85],
        [182, 111,  87],
        [165, 116,  85],
        [159, 119,  83],
        [170, 108, 122],
        [164,  53, 173],
        [171,  39, 207],
        [168,  41, 205],
        [156,  49, 208],
        [131,  61, 212],
        [103,  77, 209],
        [ 73,  95, 199],
        [ 58, 106, 192],
        [ 53, 109, 188],
        [ 59, 113, 159],
        [111, 156, 143],
        [115, 159, 113],
        [112, 162, 109],
        [117, 161,  99],
        [134, 158,  82],
        [201, 203, 102],
        [222, 201,  69],
        [229, 198,  52],
        [226, 205,  57],
        [215, 199,  86],
        [ 14,   2,   0],
        [  4,   0,   0]],

       [[242,  93,  73],
        [242,  92,  75],
        [245,  90,  79],
        [239,  93,  81],
        [226,  99,  85],
        [205, 104,  83],
        [182, 111,  83],
        [167, 116,  81],
        [164, 117,  81],
        [173, 107, 120],
        [166,  53, 169],
        [171,  40, 205],
        [168,  42, 203],
        [155,  50, 206],
        [129,  62, 212],
        [103,  77, 209],
        [ 75,  94, 197],
        [ 60, 105, 190],
        [ 57, 107, 188],
        [ 61, 113, 157],
        [111, 157, 137],
        [114, 161, 107],
        [111, 163, 105],
        [117, 162,  94],
        [134, 158,  80],
        [202, 202, 102],
        [226, 199,  67],
        [231, 198,  48],
        [228, 205,  53],
        [215, 200,  84],
        [ 12,   3,   0],
        [  1,   0,   0]],

       [[212, 111,  58],
        [212, 111,  60],
        [213, 109,  64],
        [210, 110,  66],
        [201, 115,  68],
        [187, 116,  67],
        [172, 120,  65],
        [162, 121,  64],
        [159, 123,  64],
        [166, 114, 102],
        [154,  64, 142],
        [157,  52, 176],
        [152,  55, 176],
        [140,  61, 184],
        [118,  71, 192],
        [ 95,  84, 197],
        [ 67,  98, 197],
        [ 53, 107, 196],
        [ 50, 110, 192],
        [ 59, 113, 161],
        [115, 155, 137],
        [123, 157, 105],
        [120, 159, 103],
        [127, 157,  94],
        [145, 153,  80],
        [213, 196, 104],
        [238, 192,  73],
        [245, 190,  56],
        [241, 197,  61],
        [224, 193,  92],
        [ 14,   2,   0],
        [  0,   0,   0]],

       [[149, 147,  36],
        [149, 147,  38],
        [151, 146,  38],
        [151, 145,  40],
        [154, 144,  40],
        [158, 145,  43],
        [153, 135,  34],
        [160, 142,  43],
        [152, 139,  39],
        [160, 139,  73],
        [127,  84,  92],
        [129,  81, 124],
        [122,  83, 128],
        [104,  80, 131],
        [ 99,  94, 155],
        [ 76,  98, 173],
        [ 58, 114, 204],
        [ 43, 119, 214],
        [ 40, 121, 210],
        [ 58, 119, 176],
        [125, 146, 144],
        [141, 145, 109],
        [140, 146, 107],
        [146, 145,  97],
        [167, 144,  86],
        [232, 182, 108],
        [255, 181,  91],
        [255, 168,  68],
        [255, 179,  80],
        [238, 174, 102],
        [ 26,   3,   0],
        [  1,   0,   0]],

       [[106, 198,  38],
        [108, 198,  36],
        [108, 198,  36],
        [114, 195,  34],
        [130, 193,  35],
        [173, 212,  60],
        [190, 205,  59],
        [195, 197,  55],
        [190, 198,  52],
        [191, 199,  80],
        [142, 150,  88],
        [136, 148, 115],
        [120, 142, 109],
        [117, 148, 128],
        [104, 149, 152],
        [ 60, 122, 161],
        [ 39, 124, 202],
        [ 27, 125, 222],
        [ 24, 127, 220],
        [ 51, 121, 184],
        [ 97,  98, 107],
        [123,  92,  73],
        [121,  93,  71],
        [128,  92,  61],
        [142,  86,  43],
        [183,  98,  45],
        [205,  88,  22],
        [214,  84,  14],
        [206,  83,  15],
        [181,  89,  40],
        [ 23,   0,   0],
        [  3,   0,   2]],

       [[ 46, 230,  22],
        [ 48, 230,  20],
        [ 51, 229,  16],
        [ 64, 223,  10],
        [ 80, 207,   0],
        [143, 231,  30],
        [180, 220,  31],
        [186, 207,  20],
        [186, 213,  21],
        [175, 214,  44],
        [111, 171,  42],
        [ 95, 170,  60],
        [ 92, 172,  60],
        [ 91, 181,  87],
        [ 73, 177, 124],
        [ 23, 137, 135],
        [ 18, 135, 196],
        [ 11, 133, 224],
        [  8, 134, 226],
        [ 43, 124, 190],
        [115,  94, 111],
        [152,  83,  74],
        [147,  84,  78],
        [155,  82,  70],
        [182,  80,  60],
        [209,  84,  53],
        [219,  71,  30],
        [232,  73,  29],
        [220,  66,  20],
        [194,  79,  45],
        [ 29,   0,   0],
        [  8,   3,   7]],

       [[ 22, 251,  21],
        [ 24, 250,  19],
        [ 27, 250,  13],
        [ 43, 243,   5],
        [ 73, 231,   0],
        [130, 241,  19],
        [167, 224,  13],
        [182, 213,   7],
        [185, 221,  13],
        [169, 225,  31],
        [ 95, 184,  20],
        [ 76, 182,  35],
        [ 75, 183,  35],
        [ 69, 187,  61],
        [ 53, 186, 109],
        [ 16, 155, 138],
        [  7, 141, 194],
        [  2, 138, 224],
        [  0, 139, 226],
        [ 40, 125, 192],
        [119,  88, 110],
        [161,  74,  76],
        [158,  75,  80],
        [166,  72,  74],
        [181,  62,  54],
        [217,  76,  60],
        [231,  69,  41],
        [237,  67,  35],
        [235,  65,  31],
        [205,  74,  50],
        [ 30,   0,   0],
        [  3,   0,   2]],

       [[ 24, 246,  19],
        [ 24, 246,  17],
        [ 28, 246,  10],
        [ 42, 240,   4],
        [ 71, 232,   0],
        [130, 243,  21],
        [164, 225,  13],
        [175, 213,   9],
        [176, 219,  15],
        [163, 224,  33],
        [ 85, 179,  11],
        [ 69, 176,  24],
        [ 79, 184,  39],
        [ 73, 185,  70],
        [ 53, 179, 114],
        [ 11, 145, 136],
        [  6, 145, 198],
        [  1, 142, 226],
        [  1, 142, 224],
        [ 42, 128, 192],
        [117,  90, 117],
        [159,  76,  83],
        [159,  76,  83],
        [167,  72,  79],
        [188,  74,  74],
        [209,  74,  63],
        [229,  70,  49],
        [237,  66,  37],
        [239,  70,  36],
        [202,  72,  46],
        [ 37,   0,   0],
        [  4,   0,   0]],

       [[ 60, 221,  53],
        [ 58, 222,  51],
        [ 58, 223,  47],
        [ 68, 219,  43],
        [ 87, 211,  37],
        [135, 224,  55],
        [166, 214,  55],
        [181, 210,  57],
        [174, 208,  57],
        [163, 211,  70],
        [106, 175,  47],
        [ 94, 171,  56],
        [ 96, 172,  67],
        [ 90, 169,  88],
        [ 76, 167, 125],
        [ 43, 141, 140],
        [ 28, 132, 175],
        [ 25, 131, 193],
        [ 25, 131, 193],
        [ 56, 119, 166],
        [113,  91, 112],
        [143,  81,  88],
        [145,  80,  88],
        [151,  78,  82],
        [164,  80,  77],
        [180,  81,  71],
        [196,  78,  63],
        [203,  74,  54],
        [206,  76,  51],
        [178,  79,  58],
        [ 31,   0,   0],
        [  8,   0,   0]],

       [[  0,  24,   0],
        [  0,  25,   0],
        [  0,  27,   0],
        [  0,  26,   0],
        [  0,  24,   0],
        [  0,  28,   0],
        [  0,  13,   0],
        [  1,  11,   0],
        [  0,  14,   0],
        [  0,  13,   0],
        [  0,  10,   0],
        [  0,   7,   0],
        [  0,  15,   0],
        [  0,  10,   0],
        [  0,  13,   7],
        [  0,   4,   9],
        [  0,   5,  24],
        [  0,   5,  28],
        [  0,   6,  28],
        [  0,   1,  17],
        [  4,   0,   0],
        [ 16,   0,   0],
        [ 15,   0,   0],
        [ 16,   0,   0],
        [ 20,   0,   0],
        [ 28,   0,   0],
        [ 33,   0,   0],
        [ 34,   0,   0],
        [ 36,   0,   0],
        [ 29,   0,   0],
        [ 10,   0,   0],
        [  2,   0,   0]],

       [[  4,   0,   1],
        [  1,   1,   1],
        [  0,   4,   1],
        [  0,   5,   1],
        [  0,   3,   0],
        [  0,   8,   5],
        [  0,   0,   0],
        [  4,   7,   6],
        [  0,   1,   0],
        [  0,   0,   0],
        [  6,   0,   0],
        [  7,   0,   0],
        [ 12,   0,   6],
        [  2,   0,   2],
        [  2,   0,   9],
        [  0,   0,   3],
        [  1,   0,   2],
        [  0,   0,   0],
        [  0,   0,   2],
        [  0,   0,   0],
        [  4,   0,   0],
        [  7,   0,   0],
        [  6,   0,   0],
        [  4,   0,   0],
        [  3,   0,   0],
        [  6,   2,   0],
        [  5,   2,   6],
        [  4,   0,   8],
        [  6,   1,   2],
        [  8,   0,   0],
        [  8,   0,   0],
        [ 10,   0,   0]]], dtype=np.uint8),
)

image_decoder_decode_pnm_rgb = ImageData(
  np.array([ 80,  54,  10,  51,  50,  32,  51,  50,  10,  50,  53,  53,  10,
       226,  81, 251, 226,  81, 251, 226,  81, 251, 226,  81, 251, 226,
        81, 251, 237, 229,  45, 237, 229,  45, 237, 229,  45, 237, 229,
        45, 237, 229,  45, 225, 227,  29, 225, 227,  29, 225, 227,  29,
       225, 227,  29, 225, 227,  29, 253, 253,  80, 253, 253,  80, 253,
       253,  80, 253, 253,  80, 253, 253,  80, 129,   8, 118, 129,   8,
       118, 129,   8, 118, 129,   8, 118, 129,   8, 118,  33, 164,  77,
        33, 164,  77,  33, 164,  77,  33, 164,  77,  33, 164,  77,   0,
         0,   0,   0,   0,   0, 226,  81, 251, 226,  81, 251, 226,  81,
       251, 226,  81, 251, 226,  81, 251, 237, 229,  45, 237, 229,  45,
       237, 229,  45, 237, 229,  45, 237, 229,  45, 225, 227,  29, 225,
       227,  29, 225, 227,  29, 225, 227,  29, 225, 227,  29, 253, 253,
        80, 253, 253,  80, 253, 253,  80, 253, 253,  80, 253, 253,  80,
       129,   8, 118, 129,   8, 118, 129,   8, 118, 129,   8, 118, 129,
         8, 118,  33, 164,  77,  33, 164,  77,  33, 164,  77,  33, 164,
        77,  33, 164,  77,   0,   0,   0,   0,   0,   0, 226,  81, 251,
       226,  81, 251, 226,  81, 251, 226,  81, 251, 226,  81, 251, 237,
       229,  45, 237, 229,  45, 237, 229,  45, 237, 229,  45, 237, 229,
        45, 225, 227,  29, 225, 227,  29, 225, 227,  29, 225, 227,  29,
       225, 227,  29, 253, 253,  80, 253, 253,  80, 253, 253,  80, 253,
       253,  80, 253, 253,  80, 129,   8, 118, 129,   8, 118, 129,   8,
       118, 129,   8, 118, 129,   8, 118,  33, 164,  77,  33, 164,  77,
        33, 164,  77,  33, 164,  77,  33, 164,  77,   0,   0,   0,   0,
         0,   0, 226,  81, 251, 226,  81, 251, 226,  81, 251, 226,  81,
       251, 226,  81, 251, 237, 229,  45, 237, 229,  45, 237, 229,  45,
       237, 229,  45, 237, 229,  45, 225, 227,  29, 225, 227,  29, 225,
       227,  29, 225, 227,  29, 225, 227,  29, 253, 253,  80, 253, 253,
        80, 253, 253,  80, 253, 253,  80, 253, 253,  80, 129,   8, 118,
       129,   8, 118, 129,   8, 118, 129,   8, 118, 129,   8, 118,  33,
       164,  77,  33, 164,  77,  33, 164,  77,  33, 164,  77,  33, 164,
        77,   0,   0,   0,   0,   0,   0, 226,  81, 251, 226,  81, 251,
       226,  81, 251, 226,  81, 251, 226,  81, 251, 237, 229,  45, 237,
       229,  45, 237, 229,  45, 237, 229,  45, 237, 229,  45, 225, 227,
        29, 225, 227,  29, 225, 227,  29, 225, 227,  29, 225, 227,  29,
       253, 253,  80, 253, 253,  80, 253, 253,  80, 253, 253,  80, 253,
       253,  80, 129,   8, 118, 129,   8, 118, 129,   8, 118, 129,   8,
       118, 129,   8, 118,  33, 164,  77,  33, 164,  77,  33, 164,  77,
        33, 164,  77,  33, 164,  77,   0,   0,   0,   0,   0,   0,  21,
        47, 169,  21,  47, 169,  21,  47, 169,  21,  47, 169,  21,  47,
       169, 173,  45,  10, 173,  45,  10, 173,  45,  10, 173,  45,  10,
       173,  45,  10, 254,  15,  94, 254,  15,  94, 254,  15,  94, 254,
        15,  94, 254,  15,  94,  52, 126,  81,  52, 126,  81,  52, 126,
        81,  52, 126,  81,  52, 126,  81, 145, 211, 101, 145, 211, 101,
       145, 211, 101, 145, 211, 101, 145, 211, 101, 109,  86, 145, 109,
        86, 145, 109,  86, 145, 109,  86, 145, 109,  86, 145,   0,   0,
         0,   0,   0,   0,  21,  47, 169,  21,  47, 169,  21,  47, 169,
        21,  47, 169,  21,  47, 169, 173,  45,  10, 173,  45,  10, 173,
        45,  10, 173,  45,  10, 173,  45,  10, 254,  15,  94, 254,  15,
        94, 254,  15,  94, 254,  15,  94, 254,  15,  94,  52, 126,  81,
        52, 126,  81,  52, 126,  81,  52, 126,  81,  52, 126,  81, 145,
       211, 101, 145, 211, 101, 145, 211, 101, 145, 211, 101, 145, 211,
       101, 109,  86, 145, 109,  86, 145, 109,  86, 145, 109,  86, 145,
       109,  86, 145,   0,   0,   0,   0,   0,   0,  21,  47, 169,  21,
        47, 169,  21,  47, 169,  21,  47, 169,  21,  47, 169, 173,  45,
        10, 173,  45,  10, 173,  45,  10, 173,  45,  10, 173,  45,  10,
       254,  15,  94, 254,  15,  94, 254,  15,  94, 254,  15,  94, 254,
        15,  94,  52, 126,  81,  52, 126,  81,  52, 126,  81,  52, 126,
        81,  52, 126,  81, 145, 211, 101, 145, 211, 101, 145, 211, 101,
       145, 211, 101, 145, 211, 101, 109,  86, 145, 109,  86, 145, 109,
        86, 145, 109,  86, 145, 109,  86, 145,   0,   0,   0,   0,   0,
         0,  21,  47, 169,  21,  47, 169,  21,  47, 169,  21,  47, 169,
        21,  47, 169, 173,  45,  10, 173,  45,  10, 173,  45,  10, 173,
        45,  10, 173,  45,  10, 254,  15,  94, 254,  15,  94, 254,  15,
        94, 254,  15,  94, 254,  15,  94,  52, 126,  81,  52, 126,  81,
        52, 126,  81,  52, 126,  81,  52, 126,  81, 145, 211, 101, 145,
       211, 101, 145, 211, 101, 145, 211, 101, 145, 211, 101, 109,  86,
       145, 109,  86, 145, 109,  86, 145, 109,  86, 145, 109,  86, 145,
         0,   0,   0,   0,   0,   0,  21,  47, 169,  21,  47, 169,  21,
        47, 169,  21,  47, 169,  21,  47, 169, 173,  45,  10, 173,  45,
        10, 173,  45,  10, 173,  45,  10, 173,  45,  10, 254,  15,  94,
       254,  15,  94, 254,  15,  94, 254,  15,  94, 254,  15,  94,  52,
       126,  81,  52, 126,  81,  52, 126,  81,  52, 126,  81,  52, 126,
        81, 145, 211, 101, 145, 211, 101, 145, 211, 101, 145, 211, 101,
       145, 211, 101, 109,  86, 145, 109,  86, 145, 109,  86, 145, 109,
        86, 145, 109,  86, 145,   0,   0,   0,   0,   0,   0,  34,  66,
        54,  34,  66,  54,  34,  66,  54,  34,  66,  54,  34,  66,  54,
       136,  29, 158, 136,  29, 158, 136,  29, 158, 136,  29, 158, 136,
        29, 158, 117, 152,   1, 117, 152,   1, 117, 152,   1, 117, 152,
         1, 117, 152,   1, 187, 208, 244, 187, 208, 244, 187, 208, 244,
       187, 208, 244, 187, 208, 244, 118, 108, 234, 118, 108, 234, 118,
       108, 234, 118, 108, 234, 118, 108, 234, 246, 113, 205, 246, 113,
       205, 246, 113, 205, 246, 113, 205, 246, 113, 205,   0,   0,   0,
         0,   0,   0,  34,  66,  54,  34,  66,  54,  34,  66,  54,  34,
        66,  54,  34,  66,  54, 136,  29, 158, 136,  29, 158, 136,  29,
       158, 136,  29, 158, 136,  29, 158, 117, 152,   1, 117, 152,   1,
       117, 152,   1, 117, 152,   1, 117, 152,   1, 187, 208, 244, 187,
       208, 244, 187, 208, 244, 187, 208, 244, 187, 208, 244, 118, 108,
       234, 118, 108, 234, 118, 108, 234, 118, 108, 234, 118, 108, 234,
       246, 113, 205, 246, 113, 205, 246, 113, 205, 246, 113, 205, 246,
       113, 205,   0,   0,   0,   0,   0,   0,  34,  66,  54,  34,  66,
        54,  34,  66,  54,  34,  66,  54,  34,  66,  54, 136,  29, 158,
       136,  29, 158, 136,  29, 158, 136,  29, 158, 136,  29, 158, 117,
       152,   1, 117, 152,   1, 117, 152,   1, 117, 152,   1, 117, 152,
         1, 187, 208, 244, 187, 208, 244, 187, 208, 244, 187, 208, 244,
       187, 208, 244, 118, 108, 234, 118, 108, 234, 118, 108, 234, 118,
       108, 234, 118, 108, 234, 246, 113, 205, 246, 113, 205, 246, 113,
       205, 246, 113, 205, 246, 113, 205,   0,   0,   0,   0,   0,   0,
        34,  66,  54,  34,  66,  54,  34,  66,  54,  34,  66,  54,  34,
        66,  54, 136,  29, 158, 136,  29, 158, 136,  29, 158, 136,  29,
       158, 136,  29, 158, 117, 152,   1, 117, 152,   1, 117, 152,   1,
       117, 152,   1, 117, 152,   1, 187, 208, 244, 187, 208, 244, 187,
       208, 244, 187, 208, 244, 187, 208, 244, 118, 108, 234, 118, 108,
       234, 118, 108, 234, 118, 108, 234, 118, 108, 234, 246, 113, 205,
       246, 113, 205, 246, 113, 205, 246, 113, 205, 246, 113, 205,   0,
         0,   0,   0,   0,   0,  34,  66,  54,  34,  66,  54,  34,  66,
        54,  34,  66,  54,  34,  66,  54, 136,  29, 158, 136,  29, 158,
       136,  29, 158, 136,  29, 158, 136,  29, 158, 117, 152,   1, 117,
       152,   1, 117, 152,   1, 117, 152,   1, 117, 152,   1, 187, 208,
       244, 187, 208, 244, 187, 208, 244, 187, 208, 244, 187, 208, 244,
       118, 108, 234, 118, 108, 234, 118, 108, 234, 118, 108, 234, 118,
       108, 234, 246, 113, 205, 246, 113, 205, 246, 113, 205, 246, 113,
       205, 246, 113, 205,   0,   0,   0,   0,   0,   0,  64, 118,  59,
        64, 118,  59,  64, 118,  59,  64, 118,  59,  64, 118,  59, 157,
        54, 167, 157,  54, 167, 157,  54, 167, 157,  54, 167, 157,  54,
       167, 142,  26, 122, 142,  26, 122, 142,  26, 122, 142,  26, 122,
       142,  26, 122, 236, 105,  88, 236, 105,  88, 236, 105,  88, 236,
       105,  88, 236, 105,  88, 184, 191,  91, 184, 191,  91, 184, 191,
        91, 184, 191,  91, 184, 191,  91,  76, 185,  95,  76, 185,  95,
        76, 185,  95,  76, 185,  95,  76, 185,  95,   0,   0,   0,   0,
         0,   0,  64, 118,  59,  64, 118,  59,  64, 118,  59,  64, 118,
        59,  64, 118,  59, 157,  54, 167, 157,  54, 167, 157,  54, 167,
       157,  54, 167, 157,  54, 167, 142,  26, 122, 142,  26, 122, 142,
        26, 122, 142,  26, 122, 142,  26, 122, 236, 105,  88, 236, 105,
        88, 236, 105,  88, 236, 105,  88, 236, 105,  88, 184, 191,  91,
       184, 191,  91, 184, 191,  91, 184, 191,  91, 184, 191,  91,  76,
       185,  95,  76, 185,  95,  76, 185,  95,  76, 185,  95,  76, 185,
        95,   0,   0,   0,   0,   0,   0,  64, 118,  59,  64, 118,  59,
        64, 118,  59,  64, 118,  59,  64, 118,  59, 157,  54, 167, 157,
        54, 167, 157,  54, 167, 157,  54, 167, 157,  54, 167, 142,  26,
       122, 142,  26, 122, 142,  26, 122, 142,  26, 122, 142,  26, 122,
       236, 105,  88, 236, 105,  88, 236, 105,  88, 236, 105,  88, 236,
       105,  88, 184, 191,  91, 184, 191,  91, 184, 191,  91, 184, 191,
        91, 184, 191,  91,  76, 185,  95,  76, 185,  95,  76, 185,  95,
        76, 185,  95,  76, 185,  95,   0,   0,   0,   0,   0,   0,  64,
       118,  59,  64, 118,  59,  64, 118,  59,  64, 118,  59,  64, 118,
        59, 157,  54, 167, 157,  54, 167, 157,  54, 167, 157,  54, 167,
       157,  54, 167, 142,  26, 122, 142,  26, 122, 142,  26, 122, 142,
        26, 122, 142,  26, 122, 236, 105,  88, 236, 105,  88, 236, 105,
        88, 236, 105,  88, 236, 105,  88, 184, 191,  91, 184, 191,  91,
       184, 191,  91, 184, 191,  91, 184, 191,  91,  76, 185,  95,  76,
       185,  95,  76, 185,  95,  76, 185,  95,  76, 185,  95,   0,   0,
         0,   0,   0,   0,  64, 118,  59,  64, 118,  59,  64, 118,  59,
        64, 118,  59,  64, 118,  59, 157,  54, 167, 157,  54, 167, 157,
        54, 167, 157,  54, 167, 157,  54, 167, 142,  26, 122, 142,  26,
       122, 142,  26, 122, 142,  26, 122, 142,  26, 122, 236, 105,  88,
       236, 105,  88, 236, 105,  88, 236, 105,  88, 236, 105,  88, 184,
       191,  91, 184, 191,  91, 184, 191,  91, 184, 191,  91, 184, 191,
        91,  76, 185,  95,  76, 185,  95,  76, 185,  95,  76, 185,  95,
        76, 185,  95,   0,   0,   0,   0,   0,   0, 247,  90,  80, 247,
        90,  80, 247,  90,  80, 247,  90,  80, 247,  90,  80, 167, 118,
        85, 167, 118,  85, 167, 118,  85, 167, 118,  85, 167, 118,  85,
       172,  39, 208, 172,  39, 208, 172,  39, 208, 172,  39, 208, 172,
        39, 208,  60, 106, 191,  60, 106, 191,  60, 106, 191,  60, 106,
       191,  60, 106, 191, 114, 163, 112, 114, 163, 112, 114, 163, 112,
       114, 163, 112, 114, 163, 112, 228, 201,  50, 228, 201,  50, 228,
       201,  50, 228, 201,  50, 228, 201,  50,   0,   0,   0,   0,   0,
         0, 247,  90,  80, 247,  90,  80, 247,  90,  80, 247,  90,  80,
       247,  90,  80, 167, 118,  85, 167, 118,  85, 167, 118,  85, 167,
       118,  85, 167, 118,  85, 172,  39, 208, 172,  39, 208, 172,  39,
       208, 172,  39, 208, 172,  39, 208,  60, 106, 191,  60, 106, 191,
        60, 106, 191,  60, 106, 191,  60, 106, 191, 114, 163, 112, 114,
       163, 112, 114, 163, 112, 114, 163, 112, 114, 163, 112, 228, 201,
        50, 228, 201,  50, 228, 201,  50, 228, 201,  50, 228, 201,  50,
         0,   0,   0,   0,   0,   0, 247,  90,  80, 247,  90,  80, 247,
        90,  80, 247,  90,  80, 247,  90,  80, 167, 118,  85, 167, 118,
        85, 167, 118,  85, 167, 118,  85, 167, 118,  85, 172,  39, 208,
       172,  39, 208, 172,  39, 208, 172,  39, 208, 172,  39, 208,  60,
       106, 191,  60, 106, 191,  60, 106, 191,  60, 106, 191,  60, 106,
       191, 114, 163, 112, 114, 163, 112, 114, 163, 112, 114, 163, 112,
       114, 163, 112, 228, 201,  50, 228, 201,  50, 228, 201,  50, 228,
       201,  50, 228, 201,  50,   0,   0,   0,   0,   0,   0, 247,  90,
        80, 247,  90,  80, 247,  90,  80, 247,  90,  80, 247,  90,  80,
       167, 118,  85, 167, 118,  85, 167, 118,  85, 167, 118,  85, 167,
       118,  85, 172,  39, 208, 172,  39, 208, 172,  39, 208, 172,  39,
       208, 172,  39, 208,  60, 106, 191,  60, 106, 191,  60, 106, 191,
        60, 106, 191,  60, 106, 191, 114, 163, 112, 114, 163, 112, 114,
       163, 112, 114, 163, 112, 114, 163, 112, 228, 201,  50, 228, 201,
        50, 228, 201,  50, 228, 201,  50, 228, 201,  50,   0,   0,   0,
         0,   0,   0, 247,  90,  80, 247,  90,  80, 247,  90,  80, 247,
        90,  80, 247,  90,  80, 167, 118,  85, 167, 118,  85, 167, 118,
        85, 167, 118,  85, 167, 118,  85, 172,  39, 208, 172,  39, 208,
       172,  39, 208, 172,  39, 208, 172,  39, 208,  60, 106, 191,  60,
       106, 191,  60, 106, 191,  60, 106, 191,  60, 106, 191, 114, 163,
       112, 114, 163, 112, 114, 163, 112, 114, 163, 112, 114, 163, 112,
       228, 201,  50, 228, 201,  50, 228, 201,  50, 228, 201,  50, 228,
       201,  50,   0,   0,   0,   0,   0,   0,  24, 246,  11,  24, 246,
        11,  24, 246,  11,  24, 246,  11,  24, 246,  11, 177, 219,   6,
       177, 219,   6, 177, 219,   6, 177, 219,   6, 177, 219,   6,  77,
       188,  37,  77, 188,  37,  77, 188,  37,  77, 188,  37,  77, 188,
        37,   2, 138, 230,   2, 138, 230,   2, 138, 230,   2, 138, 230,
         2, 138, 230, 159,  74,  81, 159,  74,  81, 159,  74,  81, 159,
        74,  81, 159,  74,  81, 240,  63,  27, 240,  63,  27, 240,  63,
        27, 240,  63,  27, 240,  63,  27,   0,   0,   0,   0,   0,   0,
        24, 246,  11,  24, 246,  11,  24, 246,  11,  24, 246,  11,  24,
       246,  11, 177, 219,   6, 177, 219,   6, 177, 219,   6, 177, 219,
         6, 177, 219,   6,  77, 188,  37,  77, 188,  37,  77, 188,  37,
        77, 188,  37,  77, 188,  37,   2, 138, 230,   2, 138, 230,   2,
       138, 230,   2, 138, 230,   2, 138, 230, 159,  74,  81, 159,  74,
        81, 159,  74,  81, 159,  74,  81, 159,  74,  81, 240,  63,  27,
       240,  63,  27, 240,  63,  27, 240,  63,  27, 240,  63,  27,   0,
         0,   0,   0,   0,   0,  24, 246,  11,  24, 246,  11,  24, 246,
        11,  24, 246,  11,  24, 246,  11, 177, 219,   6, 177, 219,   6,
       177, 219,   6, 177, 219,   6, 177, 219,   6,  77, 188,  37,  77,
       188,  37,  77, 188,  37,  77, 188,  37,  77, 188,  37,   2, 138,
       230,   2, 138, 230,   2, 138, 230,   2, 138, 230,   2, 138, 230,
       159,  74,  81, 159,  74,  81, 159,  74,  81, 159,  74,  81, 159,
        74,  81, 240,  63,  27, 240,  63,  27, 240,  63,  27, 240,  63,
        27, 240,  63,  27,   0,   0,   0,   0,   0,   0,  24, 246,  11,
        24, 246,  11,  24, 246,  11,  24, 246,  11,  24, 246,  11, 177,
       219,   6, 177, 219,   6, 177, 219,   6, 177, 219,   6, 177, 219,
         6,  77, 188,  37,  77, 188,  37,  77, 188,  37,  77, 188,  37,
        77, 188,  37,   2, 138, 230,   2, 138, 230,   2, 138, 230,   2,
       138, 230,   2, 138, 230, 159,  74,  81, 159,  74,  81, 159,  74,
        81, 159,  74,  81, 159,  74,  81, 240,  63,  27, 240,  63,  27,
       240,  63,  27, 240,  63,  27, 240,  63,  27,   0,   0,   0,   0,
         0,   0,  24, 246,  11,  24, 246,  11,  24, 246,  11,  24, 246,
        11,  24, 246,  11, 177, 219,   6, 177, 219,   6, 177, 219,   6,
       177, 219,   6, 177, 219,   6,  77, 188,  37,  77, 188,  37,  77,
       188,  37,  77, 188,  37,  77, 188,  37,   2, 138, 230,   2, 138,
       230,   2, 138, 230,   2, 138, 230,   2, 138, 230, 159,  74,  81,
       159,  74,  81, 159,  74,  81, 159,  74,  81, 159,  74,  81, 240,
        63,  27, 240,  63,  27, 240,  63,  27, 240,  63,  27, 240,  63,
        27,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0], dtype=np.uint8),
    np.array([[[226,  81, 251],
        [226,  81, 251],
        [226,  81, 251],
        [226,  81, 251],
        [226,  81, 251],
        [237, 229,  45],
        [237, 229,  45],
        [237, 229,  45],
        [237, 229,  45],
        [237, 229,  45],
        [225, 227,  29],
        [225, 227,  29],
        [225, 227,  29],
        [225, 227,  29],
        [225, 227,  29],
        [253, 253,  80],
        [253, 253,  80],
        [253, 253,  80],
        [253, 253,  80],
        [253, 253,  80],
        [129,   8, 118],
        [129,   8, 118],
        [129,   8, 118],
        [129,   8, 118],
        [129,   8, 118],
        [ 33, 164,  77],
        [ 33, 164,  77],
        [ 33, 164,  77],
        [ 33, 164,  77],
        [ 33, 164,  77],
        [  0,   0,   0],
        [  0,   0,   0]],

       [[226,  81, 251],
        [226,  81, 251],
        [226,  81, 251],
        [226,  81, 251],
        [226,  81, 251],
        [237, 229,  45],
        [237, 229,  45],
        [237, 229,  45],
        [237, 229,  45],
        [237, 229,  45],
        [225, 227,  29],
        [225, 227,  29],
        [225, 227,  29],
        [225, 227,  29],
        [225, 227,  29],
        [253, 253,  80],
        [253, 253,  80],
        [253, 253,  80],
        [253, 253,  80],
        [253, 253,  80],
        [129,   8, 118],
        [129,   8, 118],
        [129,   8, 118],
        [129,   8, 118],
        [129,   8, 118],
        [ 33, 164,  77],
        [ 33, 164,  77],
        [ 33, 164,  77],
        [ 33, 164,  77],
        [ 33, 164,  77],
        [  0,   0,   0],
        [  0,   0,   0]],

       [[226,  81, 251],
        [226,  81, 251],
        [226,  81, 251],
        [226,  81, 251],
        [226,  81, 251],
        [237, 229,  45],
        [237, 229,  45],
        [237, 229,  45],
        [237, 229,  45],
        [237, 229,  45],
        [225, 227,  29],
        [225, 227,  29],
        [225, 227,  29],
        [225, 227,  29],
        [225, 227,  29],
        [253, 253,  80],
        [253, 253,  80],
        [253, 253,  80],
        [253, 253,  80],
        [253, 253,  80],
        [129,   8, 118],
        [129,   8, 118],
        [129,   8, 118],
        [129,   8, 118],
        [129,   8, 118],
        [ 33, 164,  77],
        [ 33, 164,  77],
        [ 33, 164,  77],
        [ 33, 164,  77],
        [ 33, 164,  77],
        [  0,   0,   0],
        [  0,   0,   0]],

       [[226,  81, 251],
        [226,  81, 251],
        [226,  81, 251],
        [226,  81, 251],
        [226,  81, 251],
        [237, 229,  45],
        [237, 229,  45],
        [237, 229,  45],
        [237, 229,  45],
        [237, 229,  45],
        [225, 227,  29],
        [225, 227,  29],
        [225, 227,  29],
        [225, 227,  29],
        [225, 227,  29],
        [253, 253,  80],
        [253, 253,  80],
        [253, 253,  80],
        [253, 253,  80],
        [253, 253,  80],
        [129,   8, 118],
        [129,   8, 118],
        [129,   8, 118],
        [129,   8, 118],
        [129,   8, 118],
        [ 33, 164,  77],
        [ 33, 164,  77],
        [ 33, 164,  77],
        [ 33, 164,  77],
        [ 33, 164,  77],
        [  0,   0,   0],
        [  0,   0,   0]],

       [[226,  81, 251],
        [226,  81, 251],
        [226,  81, 251],
        [226,  81, 251],
        [226,  81, 251],
        [237, 229,  45],
        [237, 229,  45],
        [237, 229,  45],
        [237, 229,  45],
        [237, 229,  45],
        [225, 227,  29],
        [225, 227,  29],
        [225, 227,  29],
        [225, 227,  29],
        [225, 227,  29],
        [253, 253,  80],
        [253, 253,  80],
        [253, 253,  80],
        [253, 253,  80],
        [253, 253,  80],
        [129,   8, 118],
        [129,   8, 118],
        [129,   8, 118],
        [129,   8, 118],
        [129,   8, 118],
        [ 33, 164,  77],
        [ 33, 164,  77],
        [ 33, 164,  77],
        [ 33, 164,  77],
        [ 33, 164,  77],
        [  0,   0,   0],
        [  0,   0,   0]],

       [[ 21,  47, 169],
        [ 21,  47, 169],
        [ 21,  47, 169],
        [ 21,  47, 169],
        [ 21,  47, 169],
        [173,  45,  10],
        [173,  45,  10],
        [173,  45,  10],
        [173,  45,  10],
        [173,  45,  10],
        [254,  15,  94],
        [254,  15,  94],
        [254,  15,  94],
        [254,  15,  94],
        [254,  15,  94],
        [ 52, 126,  81],
        [ 52, 126,  81],
        [ 52, 126,  81],
        [ 52, 126,  81],
        [ 52, 126,  81],
        [145, 211, 101],
        [145, 211, 101],
        [145, 211, 101],
        [145, 211, 101],
        [145, 211, 101],
        [109,  86, 145],
        [109,  86, 145],
        [109,  86, 145],
        [109,  86, 145],
        [109,  86, 145],
        [  0,   0,   0],
        [  0,   0,   0]],

       [[ 21,  47, 169],
        [ 21,  47, 169],
        [ 21,  47, 169],
        [ 21,  47, 169],
        [ 21,  47, 169],
        [173,  45,  10],
        [173,  45,  10],
        [173,  45,  10],
        [173,  45,  10],
        [173,  45,  10],
        [254,  15,  94],
        [254,  15,  94],
        [254,  15,  94],
        [254,  15,  94],
        [254,  15,  94],
        [ 52, 126,  81],
        [ 52, 126,  81],
        [ 52, 126,  81],
        [ 52, 126,  81],
        [ 52, 126,  81],
        [145, 211, 101],
        [145, 211, 101],
        [145, 211, 101],
        [145, 211, 101],
        [145, 211, 101],
        [109,  86, 145],
        [109,  86, 145],
        [109,  86, 145],
        [109,  86, 145],
        [109,  86, 145],
        [  0,   0,   0],
        [  0,   0,   0]],

       [[ 21,  47, 169],
        [ 21,  47, 169],
        [ 21,  47, 169],
        [ 21,  47, 169],
        [ 21,  47, 169],
        [173,  45,  10],
        [173,  45,  10],
        [173,  45,  10],
        [173,  45,  10],
        [173,  45,  10],
        [254,  15,  94],
        [254,  15,  94],
        [254,  15,  94],
        [254,  15,  94],
        [254,  15,  94],
        [ 52, 126,  81],
        [ 52, 126,  81],
        [ 52, 126,  81],
        [ 52, 126,  81],
        [ 52, 126,  81],
        [145, 211, 101],
        [145, 211, 101],
        [145, 211, 101],
        [145, 211, 101],
        [145, 211, 101],
        [109,  86, 145],
        [109,  86, 145],
        [109,  86, 145],
        [109,  86, 145],
        [109,  86, 145],
        [  0,   0,   0],
        [  0,   0,   0]],

       [[ 21,  47, 169],
        [ 21,  47, 169],
        [ 21,  47, 169],
        [ 21,  47, 169],
        [ 21,  47, 169],
        [173,  45,  10],
        [173,  45,  10],
        [173,  45,  10],
        [173,  45,  10],
        [173,  45,  10],
        [254,  15,  94],
        [254,  15,  94],
        [254,  15,  94],
        [254,  15,  94],
        [254,  15,  94],
        [ 52, 126,  81],
        [ 52, 126,  81],
        [ 52, 126,  81],
        [ 52, 126,  81],
        [ 52, 126,  81],
        [145, 211, 101],
        [145, 211, 101],
        [145, 211, 101],
        [145, 211, 101],
        [145, 211, 101],
        [109,  86, 145],
        [109,  86, 145],
        [109,  86, 145],
        [109,  86, 145],
        [109,  86, 145],
        [  0,   0,   0],
        [  0,   0,   0]],

       [[ 21,  47, 169],
        [ 21,  47, 169],
        [ 21,  47, 169],
        [ 21,  47, 169],
        [ 21,  47, 169],
        [173,  45,  10],
        [173,  45,  10],
        [173,  45,  10],
        [173,  45,  10],
        [173,  45,  10],
        [254,  15,  94],
        [254,  15,  94],
        [254,  15,  94],
        [254,  15,  94],
        [254,  15,  94],
        [ 52, 126,  81],
        [ 52, 126,  81],
        [ 52, 126,  81],
        [ 52, 126,  81],
        [ 52, 126,  81],
        [145, 211, 101],
        [145, 211, 101],
        [145, 211, 101],
        [145, 211, 101],
        [145, 211, 101],
        [109,  86, 145],
        [109,  86, 145],
        [109,  86, 145],
        [109,  86, 145],
        [109,  86, 145],
        [  0,   0,   0],
        [  0,   0,   0]],

       [[ 34,  66,  54],
        [ 34,  66,  54],
        [ 34,  66,  54],
        [ 34,  66,  54],
        [ 34,  66,  54],
        [136,  29, 158],
        [136,  29, 158],
        [136,  29, 158],
        [136,  29, 158],
        [136,  29, 158],
        [117, 152,   1],
        [117, 152,   1],
        [117, 152,   1],
        [117, 152,   1],
        [117, 152,   1],
        [187, 208, 244],
        [187, 208, 244],
        [187, 208, 244],
        [187, 208, 244],
        [187, 208, 244],
        [118, 108, 234],
        [118, 108, 234],
        [118, 108, 234],
        [118, 108, 234],
        [118, 108, 234],
        [246, 113, 205],
        [246, 113, 205],
        [246, 113, 205],
        [246, 113, 205],
        [246, 113, 205],
        [  0,   0,   0],
        [  0,   0,   0]],

       [[ 34,  66,  54],
        [ 34,  66,  54],
        [ 34,  66,  54],
        [ 34,  66,  54],
        [ 34,  66,  54],
        [136,  29, 158],
        [136,  29, 158],
        [136,  29, 158],
        [136,  29, 158],
        [136,  29, 158],
        [117, 152,   1],
        [117, 152,   1],
        [117, 152,   1],
        [117, 152,   1],
        [117, 152,   1],
        [187, 208, 244],
        [187, 208, 244],
        [187, 208, 244],
        [187, 208, 244],
        [187, 208, 244],
        [118, 108, 234],
        [118, 108, 234],
        [118, 108, 234],
        [118, 108, 234],
        [118, 108, 234],
        [246, 113, 205],
        [246, 113, 205],
        [246, 113, 205],
        [246, 113, 205],
        [246, 113, 205],
        [  0,   0,   0],
        [  0,   0,   0]],

       [[ 34,  66,  54],
        [ 34,  66,  54],
        [ 34,  66,  54],
        [ 34,  66,  54],
        [ 34,  66,  54],
        [136,  29, 158],
        [136,  29, 158],
        [136,  29, 158],
        [136,  29, 158],
        [136,  29, 158],
        [117, 152,   1],
        [117, 152,   1],
        [117, 152,   1],
        [117, 152,   1],
        [117, 152,   1],
        [187, 208, 244],
        [187, 208, 244],
        [187, 208, 244],
        [187, 208, 244],
        [187, 208, 244],
        [118, 108, 234],
        [118, 108, 234],
        [118, 108, 234],
        [118, 108, 234],
        [118, 108, 234],
        [246, 113, 205],
        [246, 113, 205],
        [246, 113, 205],
        [246, 113, 205],
        [246, 113, 205],
        [  0,   0,   0],
        [  0,   0,   0]],

       [[ 34,  66,  54],
        [ 34,  66,  54],
        [ 34,  66,  54],
        [ 34,  66,  54],
        [ 34,  66,  54],
        [136,  29, 158],
        [136,  29, 158],
        [136,  29, 158],
        [136,  29, 158],
        [136,  29, 158],
        [117, 152,   1],
        [117, 152,   1],
        [117, 152,   1],
        [117, 152,   1],
        [117, 152,   1],
        [187, 208, 244],
        [187, 208, 244],
        [187, 208, 244],
        [187, 208, 244],
        [187, 208, 244],
        [118, 108, 234],
        [118, 108, 234],
        [118, 108, 234],
        [118, 108, 234],
        [118, 108, 234],
        [246, 113, 205],
        [246, 113, 205],
        [246, 113, 205],
        [246, 113, 205],
        [246, 113, 205],
        [  0,   0,   0],
        [  0,   0,   0]],

       [[ 34,  66,  54],
        [ 34,  66,  54],
        [ 34,  66,  54],
        [ 34,  66,  54],
        [ 34,  66,  54],
        [136,  29, 158],
        [136,  29, 158],
        [136,  29, 158],
        [136,  29, 158],
        [136,  29, 158],
        [117, 152,   1],
        [117, 152,   1],
        [117, 152,   1],
        [117, 152,   1],
        [117, 152,   1],
        [187, 208, 244],
        [187, 208, 244],
        [187, 208, 244],
        [187, 208, 244],
        [187, 208, 244],
        [118, 108, 234],
        [118, 108, 234],
        [118, 108, 234],
        [118, 108, 234],
        [118, 108, 234],
        [246, 113, 205],
        [246, 113, 205],
        [246, 113, 205],
        [246, 113, 205],
        [246, 113, 205],
        [  0,   0,   0],
        [  0,   0,   0]],

       [[ 64, 118,  59],
        [ 64, 118,  59],
        [ 64, 118,  59],
        [ 64, 118,  59],
        [ 64, 118,  59],
        [157,  54, 167],
        [157,  54, 167],
        [157,  54, 167],
        [157,  54, 167],
        [157,  54, 167],
        [142,  26, 122],
        [142,  26, 122],
        [142,  26, 122],
        [142,  26, 122],
        [142,  26, 122],
        [236, 105,  88],
        [236, 105,  88],
        [236, 105,  88],
        [236, 105,  88],
        [236, 105,  88],
        [184, 191,  91],
        [184, 191,  91],
        [184, 191,  91],
        [184, 191,  91],
        [184, 191,  91],
        [ 76, 185,  95],
        [ 76, 185,  95],
        [ 76, 185,  95],
        [ 76, 185,  95],
        [ 76, 185,  95],
        [  0,   0,   0],
        [  0,   0,   0]],

       [[ 64, 118,  59],
        [ 64, 118,  59],
        [ 64, 118,  59],
        [ 64, 118,  59],
        [ 64, 118,  59],
        [157,  54, 167],
        [157,  54, 167],
        [157,  54, 167],
        [157,  54, 167],
        [157,  54, 167],
        [142,  26, 122],
        [142,  26, 122],
        [142,  26, 122],
        [142,  26, 122],
        [142,  26, 122],
        [236, 105,  88],
        [236, 105,  88],
        [236, 105,  88],
        [236, 105,  88],
        [236, 105,  88],
        [184, 191,  91],
        [184, 191,  91],
        [184, 191,  91],
        [184, 191,  91],
        [184, 191,  91],
        [ 76, 185,  95],
        [ 76, 185,  95],
        [ 76, 185,  95],
        [ 76, 185,  95],
        [ 76, 185,  95],
        [  0,   0,   0],
        [  0,   0,   0]],

       [[ 64, 118,  59],
        [ 64, 118,  59],
        [ 64, 118,  59],
        [ 64, 118,  59],
        [ 64, 118,  59],
        [157,  54, 167],
        [157,  54, 167],
        [157,  54, 167],
        [157,  54, 167],
        [157,  54, 167],
        [142,  26, 122],
        [142,  26, 122],
        [142,  26, 122],
        [142,  26, 122],
        [142,  26, 122],
        [236, 105,  88],
        [236, 105,  88],
        [236, 105,  88],
        [236, 105,  88],
        [236, 105,  88],
        [184, 191,  91],
        [184, 191,  91],
        [184, 191,  91],
        [184, 191,  91],
        [184, 191,  91],
        [ 76, 185,  95],
        [ 76, 185,  95],
        [ 76, 185,  95],
        [ 76, 185,  95],
        [ 76, 185,  95],
        [  0,   0,   0],
        [  0,   0,   0]],

       [[ 64, 118,  59],
        [ 64, 118,  59],
        [ 64, 118,  59],
        [ 64, 118,  59],
        [ 64, 118,  59],
        [157,  54, 167],
        [157,  54, 167],
        [157,  54, 167],
        [157,  54, 167],
        [157,  54, 167],
        [142,  26, 122],
        [142,  26, 122],
        [142,  26, 122],
        [142,  26, 122],
        [142,  26, 122],
        [236, 105,  88],
        [236, 105,  88],
        [236, 105,  88],
        [236, 105,  88],
        [236, 105,  88],
        [184, 191,  91],
        [184, 191,  91],
        [184, 191,  91],
        [184, 191,  91],
        [184, 191,  91],
        [ 76, 185,  95],
        [ 76, 185,  95],
        [ 76, 185,  95],
        [ 76, 185,  95],
        [ 76, 185,  95],
        [  0,   0,   0],
        [  0,   0,   0]],

       [[ 64, 118,  59],
        [ 64, 118,  59],
        [ 64, 118,  59],
        [ 64, 118,  59],
        [ 64, 118,  59],
        [157,  54, 167],
        [157,  54, 167],
        [157,  54, 167],
        [157,  54, 167],
        [157,  54, 167],
        [142,  26, 122],
        [142,  26, 122],
        [142,  26, 122],
        [142,  26, 122],
        [142,  26, 122],
        [236, 105,  88],
        [236, 105,  88],
        [236, 105,  88],
        [236, 105,  88],
        [236, 105,  88],
        [184, 191,  91],
        [184, 191,  91],
        [184, 191,  91],
        [184, 191,  91],
        [184, 191,  91],
        [ 76, 185,  95],
        [ 76, 185,  95],
        [ 76, 185,  95],
        [ 76, 185,  95],
        [ 76, 185,  95],
        [  0,   0,   0],
        [  0,   0,   0]],

       [[247,  90,  80],
        [247,  90,  80],
        [247,  90,  80],
        [247,  90,  80],
        [247,  90,  80],
        [167, 118,  85],
        [167, 118,  85],
        [167, 118,  85],
        [167, 118,  85],
        [167, 118,  85],
        [172,  39, 208],
        [172,  39, 208],
        [172,  39, 208],
        [172,  39, 208],
        [172,  39, 208],
        [ 60, 106, 191],
        [ 60, 106, 191],
        [ 60, 106, 191],
        [ 60, 106, 191],
        [ 60, 106, 191],
        [114, 163, 112],
        [114, 163, 112],
        [114, 163, 112],
        [114, 163, 112],
        [114, 163, 112],
        [228, 201,  50],
        [228, 201,  50],
        [228, 201,  50],
        [228, 201,  50],
        [228, 201,  50],
        [  0,   0,   0],
        [  0,   0,   0]],

       [[247,  90,  80],
        [247,  90,  80],
        [247,  90,  80],
        [247,  90,  80],
        [247,  90,  80],
        [167, 118,  85],
        [167, 118,  85],
        [167, 118,  85],
        [167, 118,  85],
        [167, 118,  85],
        [172,  39, 208],
        [172,  39, 208],
        [172,  39, 208],
        [172,  39, 208],
        [172,  39, 208],
        [ 60, 106, 191],
        [ 60, 106, 191],
        [ 60, 106, 191],
        [ 60, 106, 191],
        [ 60, 106, 191],
        [114, 163, 112],
        [114, 163, 112],
        [114, 163, 112],
        [114, 163, 112],
        [114, 163, 112],
        [228, 201,  50],
        [228, 201,  50],
        [228, 201,  50],
        [228, 201,  50],
        [228, 201,  50],
        [  0,   0,   0],
        [  0,   0,   0]],

       [[247,  90,  80],
        [247,  90,  80],
        [247,  90,  80],
        [247,  90,  80],
        [247,  90,  80],
        [167, 118,  85],
        [167, 118,  85],
        [167, 118,  85],
        [167, 118,  85],
        [167, 118,  85],
        [172,  39, 208],
        [172,  39, 208],
        [172,  39, 208],
        [172,  39, 208],
        [172,  39, 208],
        [ 60, 106, 191],
        [ 60, 106, 191],
        [ 60, 106, 191],
        [ 60, 106, 191],
        [ 60, 106, 191],
        [114, 163, 112],
        [114, 163, 112],
        [114, 163, 112],
        [114, 163, 112],
        [114, 163, 112],
        [228, 201,  50],
        [228, 201,  50],
        [228, 201,  50],
        [228, 201,  50],
        [228, 201,  50],
        [  0,   0,   0],
        [  0,   0,   0]],

       [[247,  90,  80],
        [247,  90,  80],
        [247,  90,  80],
        [247,  90,  80],
        [247,  90,  80],
        [167, 118,  85],
        [167, 118,  85],
        [167, 118,  85],
        [167, 118,  85],
        [167, 118,  85],
        [172,  39, 208],
        [172,  39, 208],
        [172,  39, 208],
        [172,  39, 208],
        [172,  39, 208],
        [ 60, 106, 191],
        [ 60, 106, 191],
        [ 60, 106, 191],
        [ 60, 106, 191],
        [ 60, 106, 191],
        [114, 163, 112],
        [114, 163, 112],
        [114, 163, 112],
        [114, 163, 112],
        [114, 163, 112],
        [228, 201,  50],
        [228, 201,  50],
        [228, 201,  50],
        [228, 201,  50],
        [228, 201,  50],
        [  0,   0,   0],
        [  0,   0,   0]],

       [[247,  90,  80],
        [247,  90,  80],
        [247,  90,  80],
        [247,  90,  80],
        [247,  90,  80],
        [167, 118,  85],
        [167, 118,  85],
        [167, 118,  85],
        [167, 118,  85],
        [167, 118,  85],
        [172,  39, 208],
        [172,  39, 208],
        [172,  39, 208],
        [172,  39, 208],
        [172,  39, 208],
        [ 60, 106, 191],
        [ 60, 106, 191],
        [ 60, 106, 191],
        [ 60, 106, 191],
        [ 60, 106, 191],
        [114, 163, 112],
        [114, 163, 112],
        [114, 163, 112],
        [114, 163, 112],
        [114, 163, 112],
        [228, 201,  50],
        [228, 201,  50],
        [228, 201,  50],
        [228, 201,  50],
        [228, 201,  50],
        [  0,   0,   0],
        [  0,   0,   0]],

       [[ 24, 246,  11],
        [ 24, 246,  11],
        [ 24, 246,  11],
        [ 24, 246,  11],
        [ 24, 246,  11],
        [177, 219,   6],
        [177, 219,   6],
        [177, 219,   6],
        [177, 219,   6],
        [177, 219,   6],
        [ 77, 188,  37],
        [ 77, 188,  37],
        [ 77, 188,  37],
        [ 77, 188,  37],
        [ 77, 188,  37],
        [  2, 138, 230],
        [  2, 138, 230],
        [  2, 138, 230],
        [  2, 138, 230],
        [  2, 138, 230],
        [159,  74,  81],
        [159,  74,  81],
        [159,  74,  81],
        [159,  74,  81],
        [159,  74,  81],
        [240,  63,  27],
        [240,  63,  27],
        [240,  63,  27],
        [240,  63,  27],
        [240,  63,  27],
        [  0,   0,   0],
        [  0,   0,   0]],

       [[ 24, 246,  11],
        [ 24, 246,  11],
        [ 24, 246,  11],
        [ 24, 246,  11],
        [ 24, 246,  11],
        [177, 219,   6],
        [177, 219,   6],
        [177, 219,   6],
        [177, 219,   6],
        [177, 219,   6],
        [ 77, 188,  37],
        [ 77, 188,  37],
        [ 77, 188,  37],
        [ 77, 188,  37],
        [ 77, 188,  37],
        [  2, 138, 230],
        [  2, 138, 230],
        [  2, 138, 230],
        [  2, 138, 230],
        [  2, 138, 230],
        [159,  74,  81],
        [159,  74,  81],
        [159,  74,  81],
        [159,  74,  81],
        [159,  74,  81],
        [240,  63,  27],
        [240,  63,  27],
        [240,  63,  27],
        [240,  63,  27],
        [240,  63,  27],
        [  0,   0,   0],
        [  0,   0,   0]],

       [[ 24, 246,  11],
        [ 24, 246,  11],
        [ 24, 246,  11],
        [ 24, 246,  11],
        [ 24, 246,  11],
        [177, 219,   6],
        [177, 219,   6],
        [177, 219,   6],
        [177, 219,   6],
        [177, 219,   6],
        [ 77, 188,  37],
        [ 77, 188,  37],
        [ 77, 188,  37],
        [ 77, 188,  37],
        [ 77, 188,  37],
        [  2, 138, 230],
        [  2, 138, 230],
        [  2, 138, 230],
        [  2, 138, 230],
        [  2, 138, 230],
        [159,  74,  81],
        [159,  74,  81],
        [159,  74,  81],
        [159,  74,  81],
        [159,  74,  81],
        [240,  63,  27],
        [240,  63,  27],
        [240,  63,  27],
        [240,  63,  27],
        [240,  63,  27],
        [  0,   0,   0],
        [  0,   0,   0]],

       [[ 24, 246,  11],
        [ 24, 246,  11],
        [ 24, 246,  11],
        [ 24, 246,  11],
        [ 24, 246,  11],
        [177, 219,   6],
        [177, 219,   6],
        [177, 219,   6],
        [177, 219,   6],
        [177, 219,   6],
        [ 77, 188,  37],
        [ 77, 188,  37],
        [ 77, 188,  37],
        [ 77, 188,  37],
        [ 77, 188,  37],
        [  2, 138, 230],
        [  2, 138, 230],
        [  2, 138, 230],
        [  2, 138, 230],
        [  2, 138, 230],
        [159,  74,  81],
        [159,  74,  81],
        [159,  74,  81],
        [159,  74,  81],
        [159,  74,  81],
        [240,  63,  27],
        [240,  63,  27],
        [240,  63,  27],
        [240,  63,  27],
        [240,  63,  27],
        [  0,   0,   0],
        [  0,   0,   0]],

       [[ 24, 246,  11],
        [ 24, 246,  11],
        [ 24, 246,  11],
        [ 24, 246,  11],
        [ 24, 246,  11],
        [177, 219,   6],
        [177, 219,   6],
        [177, 219,   6],
        [177, 219,   6],
        [177, 219,   6],
        [ 77, 188,  37],
        [ 77, 188,  37],
        [ 77, 188,  37],
        [ 77, 188,  37],
        [ 77, 188,  37],
        [  2, 138, 230],
        [  2, 138, 230],
        [  2, 138, 230],
        [  2, 138, 230],
        [  2, 138, 230],
        [159,  74,  81],
        [159,  74,  81],
        [159,  74,  81],
        [159,  74,  81],
        [159,  74,  81],
        [240,  63,  27],
        [240,  63,  27],
        [240,  63,  27],
        [240,  63,  27],
        [240,  63,  27],
        [  0,   0,   0],
        [  0,   0,   0]],

       [[  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0]],

       [[  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0],
        [  0,   0,   0]]], dtype=np.uint8),
)
# fmt: on
