/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.user;

import io.airlift.airline.Command;
import io.airlift.airline.Option;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.user.PasswordAction;
import org.apache.activemq.artemis.cli.commands.util.HashUtil;
import org.apache.activemq.artemis.spi.core.security.jaas.PropertiesLoginModuleConfigurator;
import org.apache.commons.lang3.StringUtils;

@Command(name="add", description="Add a new user")
public class AddUser
extends PasswordAction {
    @Option(name={"--plaintext"}, description="using plaintext (Default false)")
    boolean plaintext = false;

    @Override
    public Object execute(ActionContext context) throws Exception {
        super.execute(context);
        this.checkInputUser();
        this.checkInputPassword();
        this.checkInputRole();
        String hash = this.plaintext ? this.password : HashUtil.tryHash(context, this.password);
        this.add(hash, StringUtils.split((String)this.role, (String)","));
        return null;
    }

    private void add(String hash, String ... role) throws Exception {
        PropertiesLoginModuleConfigurator config = new PropertiesLoginModuleConfigurator(this.entry, this.getBrokerEtc());
        config.addNewUser(this.username, hash, role);
        config.save();
        this.context.out.println("User added successfully.");
    }
}

