/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.extension;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.webauthn4j.util.AssertUtil;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class AuthenticationExtensionsSupported
extends AbstractList<String>
implements Serializable {
    private final int size;
    private String[] extensions;

    @JsonCreator
    public AuthenticationExtensionsSupported(List<String> extensions) {
        AssertUtil.notNull(extensions, (String)"extensions must not be null");
        this.size = extensions.size();
        this.extensions = extensions.toArray(new String[this.size]);
    }

    @Override
    public String get(int index) {
        return this.extensions[index];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AuthenticationExtensionsSupported strings = (AuthenticationExtensionsSupported)o;
        return this.size == strings.size && Arrays.equals(this.extensions, strings.extensions);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(super.hashCode(), this.size);
        result = 31 * result + Arrays.hashCode(this.extensions);
        return result;
    }
}

