/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.offheap;

import org.infinispan.commons.hash.Hash;
import org.infinispan.commons.hash.MurmurHash3;
import org.infinispan.container.offheap.OffsetCalculator;

class ContiguousOffsetCalculator
implements OffsetCalculator {
    private static final int MAXIMUM_CAPACITY = Integer.MIN_VALUE;
    private static final int HASH_BITS = Integer.MAX_VALUE;
    private final int offsetDivisor;
    private static final Hash hash = MurmurHash3.getInstance();

    ContiguousOffsetCalculator(int numBlocks) {
        if (numBlocks <= 0 && (numBlocks & numBlocks - 1) == 0) {
            throw new IllegalArgumentException("maxOffset " + numBlocks + " must be greater than 0 and a power of 2");
        }
        this.offsetDivisor = Integer.MIN_VALUE >>> Integer.numberOfTrailingZeros(numBlocks);
    }

    @Override
    public int calculateOffsetUsingHashCode(int hashCode) {
        return ContiguousOffsetCalculator.spread(hashCode) / this.offsetDivisor;
    }

    private static int spread(int h) {
        return hash.hash(h) & Integer.MAX_VALUE;
    }
}

