/*
 * Decompiled with CFR 0.152.
 */
package org.kie.api.builder.helper;

import java.util.ArrayList;
import java.util.List;
import org.drools.compiler.kie.builder.impl.KieRepositoryImpl;
import org.drools.compiler.kie.builder.impl.KieServicesImpl;
import org.drools.compiler.kproject.ReleaseIdImpl;
import org.kie.api.KieServices;
import org.kie.api.builder.KieRepository;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.helper.KieModuleDeploymentHelper;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;

public class KieModuleDeploymentConfig {
    private String groupId = null;
    private String artifactId = null;
    private String version = null;
    private ReleaseId releaseId = null;
    private String kbaseName = null;
    private String ksessionName = null;
    List<String> resourceFilePaths = new ArrayList<String>();
    List<Class<?>> classes = new ArrayList();
    List<String> dependencies = new ArrayList<String>();
    private KieModuleModel kproj = null;
    String pomText;
    private final ThreadLocal<KieServices> kieServicesLocal = new ThreadLocal();

    public KieModuleDeploymentConfig() {
        KieServicesImpl ks = new KieServicesImpl(){

            public KieRepository getRepository() {
                return new KieRepositoryImpl();
            }
        };
        this.kieServicesLocal.set((KieServices)ks);
    }

    KieServices getKieServicesInstance() {
        KieServices ks = this.kieServicesLocal.get();
        if (ks == null) {
            throw new IllegalStateException(KieModuleDeploymentHelper.class.getSimpleName() + " instances are not thread-safe!");
        }
        return ks;
    }

    void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    void setVersion(String version) {
        this.version = version;
    }

    ReleaseId getReleaseId() {
        if (this.releaseId == null) {
            this.releaseId = new ReleaseIdImpl(this.groupId, this.artifactId, this.version);
        }
        return this.releaseId;
    }

    void setKbaseName(String kbaseName) {
        this.kbaseName = kbaseName;
    }

    String getKbaseName() {
        if (this.kbaseName == null) {
            this.kbaseName = "defaultKieBase";
        }
        return this.kbaseName;
    }

    void setKsessionName(String ksessionName) {
        this.ksessionName = ksessionName;
    }

    String getKsessionName() {
        if (this.ksessionName == null) {
            this.ksessionName = "defaultKieSession";
        }
        return this.ksessionName;
    }

    void checkComplete() {
        if (this.groupId != null && this.artifactId != null && this.version != null || this.releaseId != null) {
            return;
        }
        if (this.releaseId == null) {
            if (this.groupId == null) {
                throw new IllegalStateException("No groupId has been set yet.");
            }
            if (this.artifactId == null) {
                throw new IllegalStateException("No artifactId has been set yet.");
            }
            if (this.version == null) {
                throw new IllegalStateException("No version has been set yet.");
            }
            if (this.groupId.equals(this.artifactId) && this.artifactId.equals(this.version) && this.version == null) {
                throw new IllegalStateException("None of groupId, artifactId, version or releaseId have been set.");
            }
        }
    }

    KieModuleModel getKieProject() {
        if (this.kproj != null) {
            return this.kproj;
        }
        this.kproj = this.getKieServicesInstance().newKieModuleModel();
        KieBaseModel kieBaseModel = this.kproj.newKieBaseModel(this.getKbaseName()).setDefault(true);
        kieBaseModel.newKieSessionModel(this.getKsessionName()).setDefault(true);
        return this.kproj;
    }
}

