/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.model.volume.property;

import com.openshift.internal.restclient.model.volume.property.AbstractPersistentVolumeProperties;
import com.openshift.restclient.model.volume.property.INfsVolumeProperties;
import java.util.Objects;
import org.jboss.dmr.ModelNode;

public class NfsVolumeProperties
extends AbstractPersistentVolumeProperties
implements INfsVolumeProperties {
    private static final String PV_SPEC = "spec";
    private static final String PV_NFS = "nfs";
    private static final String SERVER = "server";
    private static final String PATH = "path";
    private static final String READ_ONLY = "readOnly";
    private String server;
    private String path;
    private boolean readOnly;

    public NfsVolumeProperties(String server, String path, boolean readOnly) {
        this.server = server;
        this.path = path;
        this.readOnly = readOnly;
    }

    @Override
    public String getServer() {
        return this.server;
    }

    @Override
    public void setServer(String server) {
        this.server = server;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public void setProperties(ModelNode node) {
        ModelNode nfs = node.get(new String[]{PV_SPEC, PV_NFS});
        nfs.get(SERVER).set(this.server);
        nfs.get(PATH).set(this.path);
        nfs.get(READ_ONLY).set(this.readOnly);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NfsVolumeProperties nfsVolumeProperties = (NfsVolumeProperties)o;
        return Objects.equals(this.readOnly, nfsVolumeProperties.readOnly) && Objects.equals(this.server, nfsVolumeProperties.server) && Objects.equals(this.path, nfsVolumeProperties.path);
    }

    public int hashCode() {
        return Objects.hash(this.server, this.path, this.readOnly);
    }

    public String toString() {
        return "NfsVolumeProperties{server='" + this.server + '\'' + ", path='" + this.path + '\'' + ", readOnly=" + this.readOnly + '}';
    }
}

