/*
 * Decompiled with CFR 0.152.
 */
package io.jaegertracing.internal;

import io.jaegertracing.internal.JaegerObjectFactory;
import io.jaegertracing.internal.JaegerSpan;
import io.jaegertracing.internal.JaegerSpanContext;
import io.jaegertracing.internal.PropagationRegistry;
import io.jaegertracing.internal.Reference;
import io.jaegertracing.internal.baggage.BaggageSetter;
import io.jaegertracing.internal.baggage.DefaultBaggageRestrictionManager;
import io.jaegertracing.internal.clock.Clock;
import io.jaegertracing.internal.clock.SystemClock;
import io.jaegertracing.internal.exceptions.EmptyIpException;
import io.jaegertracing.internal.exceptions.NotFourOctetsException;
import io.jaegertracing.internal.exceptions.UnsupportedFormatException;
import io.jaegertracing.internal.metrics.Metrics;
import io.jaegertracing.internal.metrics.NoopMetricsFactory;
import io.jaegertracing.internal.propagation.TextMapCodec;
import io.jaegertracing.internal.reporters.RemoteReporter;
import io.jaegertracing.internal.samplers.RemoteControlledSampler;
import io.jaegertracing.internal.samplers.SamplingStatus;
import io.jaegertracing.internal.utils.Utils;
import io.jaegertracing.spi.BaggageRestrictionManager;
import io.jaegertracing.spi.Extractor;
import io.jaegertracing.spi.Injector;
import io.jaegertracing.spi.MetricsFactory;
import io.jaegertracing.spi.Reporter;
import io.jaegertracing.spi.Sampler;
import io.opentracing.Scope;
import io.opentracing.ScopeManager;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.tag.Tags;
import io.opentracing.util.ThreadLocalScopeManager;
import java.io.Closeable;
import java.io.InputStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaegerTracer
implements Tracer,
Closeable {
    private static final Logger log = LoggerFactory.getLogger(JaegerTracer.class);
    private final String version;
    private final String serviceName;
    private final Reporter reporter;
    private final Sampler sampler;
    private final Map<String, ?> tags;
    private final boolean zipkinSharedRpcSpan;
    private final boolean expandExceptionLogs;
    private final boolean useTraceId128Bit;
    private final PropagationRegistry registry;
    private final Clock clock;
    private final Metrics metrics;
    private final ScopeManager scopeManager;
    private final BaggageSetter baggageSetter;
    private final JaegerObjectFactory objectFactory;
    private final int ipv4;

    protected JaegerTracer(Builder builder) {
        int ipv4;
        Object ipTag;
        String hostname;
        this.serviceName = builder.serviceName;
        this.reporter = builder.reporter;
        this.sampler = builder.sampler;
        this.registry = builder.registry;
        this.clock = builder.clock;
        this.metrics = builder.metrics;
        this.zipkinSharedRpcSpan = builder.zipkinSharedRpcSpan;
        this.scopeManager = builder.scopeManager;
        this.baggageSetter = new BaggageSetter(builder.baggageRestrictionManager, this.metrics);
        this.expandExceptionLogs = builder.expandExceptionLogs;
        this.objectFactory = builder.objectFactory;
        this.useTraceId128Bit = builder.useTraceId128Bit;
        this.version = JaegerTracer.loadVersion();
        HashMap<String, String> tags = new HashMap<String, String>(builder.tags);
        tags.put("jaeger.version", this.version);
        if (tags.get("hostname") == null && (hostname = this.getHostName()) != null) {
            tags.put("hostname", hostname);
        }
        if ((ipTag = tags.get("ip")) == null) {
            try {
                tags.put("ip", InetAddress.getLocalHost().getHostAddress());
                ipv4 = Utils.ipToInt(Inet4Address.getLocalHost().getHostAddress());
            }
            catch (UnknownHostException e) {
                ipv4 = 0;
            }
        } else {
            try {
                ipv4 = Utils.ipToInt(ipTag.toString());
            }
            catch (EmptyIpException e) {
                ipv4 = 0;
            }
            catch (NotFourOctetsException e) {
                ipv4 = 0;
            }
        }
        this.ipv4 = ipv4;
        this.tags = Collections.unmodifiableMap(tags);
        if (builder.manualShutdown || this.runsInGlassFish()) {
            log.info("No shutdown hook registered: Please call close() manually on application shutdown.");
        } else {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    JaegerTracer.this.close();
                }
            });
        }
    }

    private boolean runsInGlassFish() {
        return System.getProperty("com.sun.aas.instanceRoot") != null;
    }

    public String getVersion() {
        return this.version;
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public Map<String, ?> tags() {
        return this.tags;
    }

    public int getIpv4() {
        return this.ipv4;
    }

    Clock clock() {
        return this.clock;
    }

    Reporter getReporter() {
        return this.reporter;
    }

    void reportSpan(JaegerSpan span) {
        this.reporter.report(span);
        this.metrics.spansFinished.inc(1L);
    }

    public ScopeManager scopeManager() {
        return this.scopeManager;
    }

    public Span activeSpan() {
        Scope scope = this.scopeManager.active();
        return scope == null ? null : scope.span();
    }

    public SpanBuilder buildSpan(String operationName) {
        return this.objectFactory.createSpanBuilder(this, operationName);
    }

    public <T> void inject(SpanContext spanContext, Format<T> format, T carrier) {
        Injector<T> injector = this.registry.getInjector(format);
        if (injector == null) {
            throw new UnsupportedFormatException(format);
        }
        injector.inject((JaegerSpanContext)spanContext, carrier);
    }

    public <T> JaegerSpanContext extract(Format<T> format, T carrier) {
        Extractor<T> extractor = this.registry.getExtractor(format);
        if (extractor == null) {
            throw new UnsupportedFormatException(format);
        }
        return extractor.extract(carrier);
    }

    @Override
    public void close() {
        this.reporter.close();
        this.sampler.close();
    }

    private static String loadVersion() {
        return "Java-" + JaegerTracer.getVersionFromProperties();
    }

    public static String getVersionFromProperties() {
        String version;
        try {
            InputStream is = JaegerTracer.class.getResourceAsStream("jaeger.properties");
            try {
                Properties prop = new Properties();
                prop.load(is);
                version = prop.getProperty("jaeger.version");
            }
            finally {
                is.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot read jaeger.properties", e);
        }
        if (version == null) {
            throw new RuntimeException("Cannot read jaeger.version from jaeger.properties");
        }
        return version;
    }

    String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            log.error("Cannot obtain host name", (Throwable)e);
            return null;
        }
    }

    JaegerSpanContext setBaggage(JaegerSpan jaegerSpan, String key, String value) {
        return this.baggageSetter.setBaggage(jaegerSpan, key, value);
    }

    boolean isExpandExceptionLogs() {
        return this.expandExceptionLogs;
    }

    public boolean isUseTraceId128Bit() {
        return this.useTraceId128Bit;
    }

    public String toString() {
        return "JaegerTracer(version=" + this.getVersion() + ", serviceName=" + this.getServiceName() + ", reporter=" + this.getReporter() + ", sampler=" + this.sampler + ", tags=" + this.tags + ", zipkinSharedRpcSpan=" + this.zipkinSharedRpcSpan + ", expandExceptionLogs=" + this.isExpandExceptionLogs() + ", useTraceId128Bit=" + this.isUseTraceId128Bit() + ")";
    }

    public static class Builder {
        private Sampler sampler;
        private Reporter reporter;
        private final PropagationRegistry registry = new PropagationRegistry();
        private Metrics metrics = new Metrics(new NoopMetricsFactory());
        private final String serviceName;
        private Clock clock = new SystemClock();
        private Map<String, Object> tags = new HashMap<String, Object>();
        private boolean zipkinSharedRpcSpan;
        private ScopeManager scopeManager = new ThreadLocalScopeManager();
        private BaggageRestrictionManager baggageRestrictionManager = new DefaultBaggageRestrictionManager();
        private boolean expandExceptionLogs;
        private final JaegerObjectFactory objectFactory;
        private boolean useTraceId128Bit;
        private boolean manualShutdown;

        public Builder(String serviceName) {
            this(serviceName, new JaegerObjectFactory());
        }

        protected Builder(String serviceName, JaegerObjectFactory objectFactory) {
            this.serviceName = Builder.checkValidServiceName(serviceName);
            this.objectFactory = objectFactory;
            TextMapCodec textMapCodec = TextMapCodec.builder().withUrlEncoding(false).withObjectFactory(this.objectFactory).build();
            this.registerInjector(Format.Builtin.TEXT_MAP, textMapCodec);
            this.registerExtractor(Format.Builtin.TEXT_MAP, textMapCodec);
            TextMapCodec httpCodec = TextMapCodec.builder().withUrlEncoding(true).withObjectFactory(this.objectFactory).build();
            this.registerInjector(Format.Builtin.HTTP_HEADERS, httpCodec);
            this.registerExtractor(Format.Builtin.HTTP_HEADERS, httpCodec);
        }

        public Builder withReporter(Reporter reporter) {
            this.reporter = reporter;
            return this;
        }

        public Builder withSampler(Sampler sampler) {
            this.sampler = sampler;
            return this;
        }

        public <T> Builder registerInjector(Format<T> format, Injector<T> injector) {
            this.registry.register(format, injector);
            return this;
        }

        public <T> Builder registerExtractor(Format<T> format, Extractor<T> extractor) {
            this.registry.register(format, extractor);
            return this;
        }

        public Builder withMetricsFactory(MetricsFactory metricsFactory) {
            this.metrics = new Metrics(metricsFactory);
            return this;
        }

        public Builder withScopeManager(ScopeManager scopeManager) {
            this.scopeManager = scopeManager;
            return this;
        }

        public Builder withClock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder withZipkinSharedRpcSpan() {
            this.zipkinSharedRpcSpan = true;
            return this;
        }

        public Builder withExpandExceptionLogs() {
            this.expandExceptionLogs = true;
            return this;
        }

        public Builder withMetrics(Metrics metrics) {
            this.metrics = metrics;
            return this;
        }

        public Builder withTraceId128Bit() {
            this.useTraceId128Bit = true;
            return this;
        }

        public Builder withTag(String key, String value) {
            this.tags.put(key, value);
            return this;
        }

        public Builder withTag(String key, boolean value) {
            this.tags.put(key, value);
            return this;
        }

        public Builder withTag(String key, Number value) {
            this.tags.put(key, value);
            return this;
        }

        public Builder withTags(Map<String, String> tags) {
            if (tags != null) {
                this.tags.putAll(tags);
            }
            return this;
        }

        public Builder withBaggageRestrictionManager(BaggageRestrictionManager baggageRestrictionManager) {
            this.baggageRestrictionManager = baggageRestrictionManager;
            return this;
        }

        public Builder withManualShutdown() {
            this.manualShutdown = true;
            return this;
        }

        public JaegerTracer build() {
            if (this.reporter == null) {
                this.reporter = new RemoteReporter.Builder().withMetrics(this.metrics).build();
            }
            if (this.sampler == null) {
                this.sampler = new RemoteControlledSampler.Builder(this.serviceName).withMetrics(this.metrics).build();
            }
            return this.createTracer();
        }

        protected JaegerTracer createTracer() {
            return new JaegerTracer(this);
        }

        public static String checkValidServiceName(String serviceName) {
            if (serviceName == null || serviceName.trim().length() == 0) {
                throw new IllegalArgumentException("Service name must not be null or empty");
            }
            return serviceName;
        }
    }

    public class SpanBuilder
    implements Tracer.SpanBuilder {
        private String operationName;
        private long startTimeMicroseconds;
        private List<Reference> references = Collections.emptyList();
        private final Map<String, Object> tags = new HashMap<String, Object>();
        private boolean ignoreActiveSpan = false;

        protected SpanBuilder(String operationName) {
            this.operationName = operationName;
        }

        public SpanBuilder asChildOf(SpanContext parent) {
            return this.addReference("child_of", parent);
        }

        public SpanBuilder asChildOf(Span parent) {
            return this.addReference("child_of", parent != null ? parent.context() : null);
        }

        public SpanBuilder addReference(String referenceType, SpanContext reference) {
            if (reference == null) {
                return this;
            }
            if (!(reference instanceof JaegerSpanContext)) {
                log.warn("Expected to have a JaegerSpanContext but got " + reference.getClass().getName());
                return this;
            }
            JaegerSpanContext referencedContext = (JaegerSpanContext)reference;
            if (!"child_of".equals(referenceType) && !"follows_from".equals(referenceType)) {
                return this;
            }
            if (this.references.isEmpty()) {
                this.references = Collections.singletonList(new Reference(referencedContext, referenceType));
            } else {
                if (this.references.size() == 1) {
                    this.references = new ArrayList<Reference>(this.references);
                }
                this.references.add(new Reference(referencedContext, referenceType));
            }
            return this;
        }

        public SpanBuilder withTag(String key, String value) {
            this.tags.put(key, value);
            return this;
        }

        public SpanBuilder withTag(String key, boolean value) {
            this.tags.put(key, value);
            return this;
        }

        public SpanBuilder withTag(String key, Number value) {
            this.tags.put(key, value);
            return this;
        }

        public SpanBuilder withStartTimestamp(long microseconds) {
            this.startTimeMicroseconds = microseconds;
            return this;
        }

        private JaegerSpanContext createNewContext() {
            long spanId;
            String debugId = this.getDebugId();
            long traceIdLow = spanId = Utils.uniqueId();
            long traceIdHigh = JaegerTracer.this.isUseTraceId128Bit() ? Utils.uniqueId() : 0L;
            byte flags = 0;
            if (debugId != null) {
                flags = (byte)(flags | 1 | 2);
                this.tags.put("jaeger-debug-id", debugId);
                ((JaegerTracer)JaegerTracer.this).metrics.traceStartedSampled.inc(1L);
            } else {
                SamplingStatus samplingStatus = JaegerTracer.this.sampler.sample(this.operationName, spanId);
                if (samplingStatus.isSampled()) {
                    flags = (byte)(flags | 1);
                    this.tags.putAll(samplingStatus.getTags());
                    ((JaegerTracer)JaegerTracer.this).metrics.traceStartedSampled.inc(1L);
                } else {
                    ((JaegerTracer)JaegerTracer.this).metrics.traceStartedNotSampled.inc(1L);
                }
            }
            return this.getObjectFactory().createSpanContext(traceIdHigh, traceIdLow, spanId, 0L, flags, this.getBaggage(), debugId);
        }

        private Map<String, String> getBaggage() {
            HashMap<String, String> baggage = null;
            if (this.references.size() == 1) {
                return this.references.get(0).getSpanContext().baggage();
            }
            for (Reference reference : this.references) {
                if (reference.getSpanContext().baggage() == null) continue;
                if (baggage == null) {
                    baggage = new HashMap<String, String>();
                }
                baggage.putAll(reference.getSpanContext().baggage());
            }
            return baggage;
        }

        private JaegerSpanContext createChildContext() {
            JaegerSpanContext preferredReference = this.preferredReference();
            if (this.isRpcServer()) {
                if (this.isSampled()) {
                    ((JaegerTracer)JaegerTracer.this).metrics.tracesJoinedSampled.inc(1L);
                } else {
                    ((JaegerTracer)JaegerTracer.this).metrics.tracesJoinedNotSampled.inc(1L);
                }
                if (JaegerTracer.this.zipkinSharedRpcSpan) {
                    return preferredReference;
                }
            }
            return this.getObjectFactory().createSpanContext(preferredReference.getTraceIdHigh(), preferredReference.getTraceIdLow(), Utils.uniqueId(), preferredReference.getSpanId(), preferredReference.getFlags(), this.getBaggage(), null);
        }

        boolean isRpcServer() {
            return "server".equals(this.tags.get(Tags.SPAN_KIND.getKey()));
        }

        private JaegerSpanContext preferredReference() {
            Reference preferredReference = this.references.get(0);
            for (Reference reference : this.references) {
                if (!"child_of".equals(reference.getType()) || "child_of".equals(preferredReference.getType())) continue;
                preferredReference = reference;
                break;
            }
            return preferredReference.getSpanContext();
        }

        private boolean isSampled() {
            if (this.references != null) {
                for (Reference reference : this.references) {
                    if (!reference.getSpanContext().isSampled()) continue;
                    return true;
                }
            }
            return false;
        }

        private String getDebugId() {
            if (this.references.isEmpty()) {
                return null;
            }
            return this.references.get(0).getSpanContext().getDebugId();
        }

        public JaegerSpan start() {
            if (this.references.isEmpty() && !this.ignoreActiveSpan && null != JaegerTracer.this.scopeManager.active()) {
                this.asChildOf(JaegerTracer.this.scopeManager.active().span());
            }
            JaegerSpanContext context = this.references.isEmpty() || !this.references.get(0).getSpanContext().hasTrace() ? this.createNewContext() : this.createChildContext();
            long startTimeNanoTicks = 0L;
            boolean computeDurationViaNanoTicks = false;
            if (this.startTimeMicroseconds == 0L) {
                this.startTimeMicroseconds = JaegerTracer.this.clock.currentTimeMicros();
                if (!JaegerTracer.this.clock.isMicrosAccurate()) {
                    startTimeNanoTicks = JaegerTracer.this.clock.currentNanoTicks();
                    computeDurationViaNanoTicks = true;
                }
            }
            JaegerSpan jaegerSpan = this.getObjectFactory().createSpan(JaegerTracer.this, this.operationName, context, this.startTimeMicroseconds, startTimeNanoTicks, computeDurationViaNanoTicks, this.tags, this.references);
            if (context.isSampled()) {
                ((JaegerTracer)JaegerTracer.this).metrics.spansStartedSampled.inc(1L);
            } else {
                ((JaegerTracer)JaegerTracer.this).metrics.spansStartedNotSampled.inc(1L);
            }
            return jaegerSpan;
        }

        public Scope startActive(boolean finishSpanOnClose) {
            return JaegerTracer.this.scopeManager.activate((Span)this.start(), finishSpanOnClose);
        }

        public SpanBuilder ignoreActiveSpan() {
            this.ignoreActiveSpan = true;
            return this;
        }

        @Deprecated
        public JaegerSpan startManual() {
            return this.start();
        }

        private JaegerObjectFactory getObjectFactory() {
            return JaegerTracer.this.objectFactory;
        }
    }
}

