/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.conditional;

import java.util.ArrayList;
import java.util.List;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.AuthenticatorFactory;
import org.keycloak.authentication.authenticators.conditional.ConditionalAuthenticator;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;

public class ConditionalUserConfiguredAuthenticator
implements ConditionalAuthenticator {
    public static final ConditionalUserConfiguredAuthenticator SINGLETON = new ConditionalUserConfiguredAuthenticator();

    @Override
    public boolean matchCondition(AuthenticationFlowContext context) {
        return this.matchConditionInFlow(context, context.getExecution().getParentFlow());
    }

    private boolean matchConditionInFlow(AuthenticationFlowContext context, String flowId) {
        List executions = context.getRealm().getAuthenticationExecutions(flowId);
        if (executions == null) {
            return true;
        }
        ArrayList requiredExecutions = new ArrayList();
        ArrayList alternativeExecutions = new ArrayList();
        executions.forEach(e -> {
            boolean isConditionalAuthenticator = false;
            try {
                Authenticator auth;
                AuthenticatorFactory factory = (AuthenticatorFactory)context.getSession().getKeycloakSessionFactory().getProviderFactory(Authenticator.class, e.getAuthenticator());
                if (factory != null && (auth = (Authenticator)factory.create(context.getSession())) != null && auth instanceof ConditionalAuthenticator) {
                    isConditionalAuthenticator = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!(context.getExecution().getId().equals(e.getId()) || e.isAuthenticatorFlow() || isConditionalAuthenticator)) {
                if (e.isRequired()) {
                    requiredExecutions.add(e);
                } else if (e.isAlternative()) {
                    alternativeExecutions.add(e);
                }
            }
        });
        if (!requiredExecutions.isEmpty()) {
            return requiredExecutions.stream().allMatch(e -> this.isConfiguredFor((AuthenticationExecutionModel)e, context));
        }
        if (!alternativeExecutions.isEmpty()) {
            return alternativeExecutions.stream().anyMatch(e -> this.isConfiguredFor((AuthenticationExecutionModel)e, context));
        }
        return true;
    }

    private boolean isConfiguredFor(AuthenticationExecutionModel model, AuthenticationFlowContext context) {
        if (model.isAuthenticatorFlow()) {
            return this.matchConditionInFlow(context, model.getId());
        }
        AuthenticatorFactory factory = (AuthenticatorFactory)context.getSession().getKeycloakSessionFactory().getProviderFactory(Authenticator.class, model.getAuthenticator());
        Authenticator authenticator = (Authenticator)factory.create(context.getSession());
        return authenticator.configuredFor(context.getSession(), context.getRealm(), context.getUser());
    }

    public void action(AuthenticationFlowContext context) {
    }

    public boolean requiresUser() {
        return true;
    }

    public void setRequiredActions(KeycloakSession session, RealmModel realm, UserModel user) {
    }

    public void close() {
    }
}

