/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.ejb;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.AttachmentKey;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.transaction.xa.Xid;
import org.jboss.marshalling.Unmarshaller;
import org.wildfly.httpclient.ejb.EjbHttpClientMessages;
import org.wildfly.transaction.client.SimpleXid;

public abstract class RemoteHTTPHandler
implements HttpHandler {
    private final ExecutorService executorService;
    private static final AttachmentKey<ExecutorService> EXECUTOR = AttachmentKey.create(ExecutorService.class);

    public RemoteHTTPHandler(ExecutorService executorService) {
        this.executorService = executorService;
    }

    @Override
    public final void handleRequest(HttpServerExchange exchange) throws Exception {
        if (exchange.isInIoThread()) {
            if (this.executorService == null) {
                exchange.dispatch(this);
            } else {
                exchange.putAttachment(EXECUTOR, this.executorService);
                exchange.dispatch((Executor)this.executorService, this);
            }
            return;
        }
        if (this.executorService != null && exchange.getAttachment(EXECUTOR) == null) {
            exchange.putAttachment(EXECUTOR, this.executorService);
            exchange.dispatch((Executor)this.executorService, this);
            return;
        }
        exchange.startBlocking();
        this.handleInternal(exchange);
    }

    protected abstract void handleInternal(HttpServerExchange var1) throws Exception;

    protected ReceivedTransaction readTransaction(Unmarshaller unmarshaller) throws IOException {
        byte type = unmarshaller.readByte();
        if (type == 0) {
            return null;
        }
        if (type == 1 || type == 2) {
            int formatId = unmarshaller.readInt();
            int len = unmarshaller.readInt();
            byte[] globalId = new byte[len];
            unmarshaller.readFully(globalId);
            len = unmarshaller.readInt();
            byte[] branchId = new byte[len];
            unmarshaller.readFully(branchId);
            SimpleXid simpleXid = new SimpleXid(formatId, globalId, branchId);
            if (type == 2) {
                return new ReceivedTransaction(simpleXid, unmarshaller.readInt(), true);
            }
            return new ReceivedTransaction(simpleXid, 0, false);
        }
        throw EjbHttpClientMessages.MESSAGES.invalidTransactionType(type);
    }

    static class ReceivedTransaction {
        final Xid xid;
        final int remainingTime;
        final boolean outflowed;

        ReceivedTransaction(Xid xid, int remainingTime, boolean outflowed) {
            this.xid = xid;
            this.remainingTime = remainingTime;
            this.outflowed = outflowed;
        }

        public Xid getXid() {
            return this.xid;
        }

        public int getRemainingTime() {
            return this.remainingTime;
        }

        public boolean isOutflowed() {
            return this.outflowed;
        }
    }
}

