#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 what4
version:              1.0
visibility:           public
id:                   what4-1.0-4DTWM86qjYBEHVDnofI2jO
key:                  what4-1.0-4DTWM86qjYBEHVDnofI2jO
license:              BSD-3-Clause
copyright:            (c) Galois, Inc 2014-2020
maintainer:           jhendrix@galois.com, rdockins@galois.com
author:               Galois Inc.
homepage:             https://github.com/GaloisInc/what4
synopsis:             Solver-agnostic symbolic values support for issuing queries
description:
    What4 is a generic library for representing values as symbolic formulae which may
    contain references to symbolic values, representing unknown variables.
    It provides support for communicating with a variety of SAT and SMT solvers,
    including Z3, CVC4, Yices, Boolector, STP, and dReal.
    The data representation types make heavy use of GADT-style type indices
    to ensure type-correct manipulation of symbolic values.

category:             Formal Methods, Theorem Provers, Symbolic Computation, SMT
abi:                  0b22f50bbb1382ef9e9d739dca150329
exposed:              True
exposed-modules:
    Test.Verification What4.BaseTypes What4.Concrete What4.Config
    What4.Expr What4.Expr.AppTheory What4.Expr.ArrayUpdateMap
    What4.Expr.BoolMap What4.Expr.Builder What4.Expr.GroundEval
    What4.Expr.MATLAB What4.Expr.Simplify What4.Expr.StringSeq
    What4.Expr.UnaryBV What4.Expr.VarIdentification
    What4.Expr.WeightedSum What4.FunctionName What4.IndexLit
    What4.Interface What4.InterpretedFloatingPoint What4.LabeledPred
    What4.Panic What4.Partial What4.ProblemFeatures What4.ProgramLoc
    What4.Protocol.Online What4.Protocol.PolyRoot
    What4.Protocol.ReadDecimal What4.Protocol.SExp
    What4.Protocol.SMTLib2 What4.Protocol.SMTLib2.Parse
    What4.Protocol.SMTLib2.Syntax What4.Protocol.SMTWriter What4.SWord
    What4.SatResult What4.SemiRing What4.Solver What4.Solver.Adapter
    What4.Solver.Boolector What4.Solver.CVC4 What4.Solver.DReal
    What4.Solver.STP What4.Solver.Yices What4.Solver.Z3 What4.Symbol
    What4.Utils.AbstractDomains What4.Utils.AnnotatedMap
    What4.Utils.Arithmetic What4.Utils.BVDomain
    What4.Utils.BVDomain.Arith What4.Utils.BVDomain.Bitwise
    What4.Utils.BVDomain.XOR What4.Utils.Complex What4.Utils.Endian
    What4.Utils.Environment What4.Utils.HandleReader
    What4.Utils.IncrHash What4.Utils.LeqMap What4.Utils.MonadST
    What4.Utils.OnlyNatRepr What4.Utils.Process What4.Utils.Streams
    What4.Utils.StringLiteral What4.Utils.Word16String What4.WordMap

hidden-modules:       What4.Expr.App
import-dirs:          /usr/lib/ghc-8.10.2/site-local/what4-1.0
library-dirs:         /usr/lib/ghc-8.10.2/site-local/what4-1.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.2/what4-1.0
hs-libraries:         HSwhat4-1.0-4DTWM86qjYBEHVDnofI2jO
depends:
    ansi-wl-pprint-0.6.9-4tU0KPt7JPA3kQcTPEEEXE
    attoparsec-0.13.2.4-AOCP0w3yjps1ekkc06TeAr base-4.14.1.0
    bifunctors-5.5.8-A6tYbzQrPtsH4vjNxzZac4
    bimap-0.4.0-LUMEXinGxmfArXlbcvKe8X
    bv-sized-1.0.2-2Lb1Q2H9mKYADmHDvkb6ds bytestring-0.10.10.0
    containers-0.6.2.1 data-binary-ieee754-0.4.4-HlSlHq1qDaTKAKUZNW5rdz
    deepseq-1.4.4.0 deriving-compat-0.5.10-HLUmyoyq4CI7m0sd5b793S
    directory-1.3.6.0 exceptions-0.10.4
    extra-1.7.8-EdfBJ48tR0Z85l1lpNPA9g filepath-1.4.2.1
    fingertree-0.1.4.2-KupGDoKWk3A1HjWmqUxtYj ghc-prim-0.6.1
    hashable-1.3.0.0-FvkEiMgheS54ROKCBeHULc
    hashtables-1.2.4.1-8rxVTTNTGfz6Kdrsau6Nuw
    io-streams-1.5.2.0-1PoFwG2lobp1Us0It13O77
    lens-4.19.2-HdgDJZEqQbsGlphfAuieXM mtl-2.2.2
    panic-0.4.0.1-Fo4sCfDqcEkCpAt882LFEy
    parameterized-utils-2.1.1-DPxjeZL899l5OXBh1ow5VX process-1.6.9.0
    scientific-0.3.6.2-LcQZB4QBvhUBZy7r760l30 template-haskell-2.16.0.0
    temporary-1.3-6UtN1EllNOv2jltzv3wxyc text-1.2.3.2
    th-abstraction-0.4.0.0-EowzxylgIS6DLmPFoxbMpZ transformers-0.5.6.2
    unordered-containers-0.2.13.0-7BSbisgDeQuHhhzTcs4ukq
    utf8-string-1.0.1.1-G1tzxDqsWge3erFqc4Oe2R
    vector-0.12.1.2-IO5RJnkQnAxDAG50LdixTd
    versions-3.5.4-6xUxkgxUOPcKJoolNCMA6e
    zenc-0.1.1-JvaW35gFnjuHQuX4eF5ZTK

haddock-interfaces:   /usr/share/doc/haskell-what4/html/what4.haddock
haddock-html:         /usr/share/doc/haskell-what4/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

