#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 vector-algorithms
version:              0.8.0.4
visibility:           public
id:                   vector-algorithms-0.8.0.4-LzRASmIxoS1XEaN5EjNPb
key:                  vector-algorithms-0.8.0.4-LzRASmIxoS1XEaN5EjNPb
license:              BSD-3-Clause
copyright:
    (c) 2008,2009,2010,2011,2012,2013,2014,2015 Dan Doel
    (c) 2015 Tim Baumann

maintainer:
    Dan Doel <dan.doel@gmail.com>
    Erik de Castro Lopo <erikd@mega-nerd.com>

author:               Dan Doel
homepage:             https://github.com/erikd/vector-algorithms/
synopsis:             Efficient algorithms for vector arrays
description:
    Efficient algorithms for sorting vector arrays. At some stage
    other vector algorithms may be added.

category:             Data
abi:                  36ef6315540bad9f1667593cf60e4925
exposed:              True
exposed-modules:
    Data.Vector.Algorithms.AmericanFlag Data.Vector.Algorithms.Heap
    Data.Vector.Algorithms.Insertion Data.Vector.Algorithms.Intro
    Data.Vector.Algorithms.Merge Data.Vector.Algorithms.Optimal
    Data.Vector.Algorithms.Radix Data.Vector.Algorithms.Search
    Data.Vector.Algorithms.Tim

hidden-modules:       Data.Vector.Algorithms.Common
import-dirs:          /usr/lib/ghc-8.10.5/site-local/vector-algorithms-0.8.0.4
library-dirs:         /usr/lib/ghc-8.10.5/site-local/vector-algorithms-0.8.0.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/vector-algorithms-0.8.0.4
hs-libraries:         HSvector-algorithms-0.8.0.4-LzRASmIxoS1XEaN5EjNPb
include-dirs:
    /usr/lib/ghc-8.10.5/site-local/vector-algorithms-0.8.0.4/include

depends:
    base-4.14.2.0 bytestring-0.10.12.0
    primitive-0.7.1.0-H44eQ1j8hQJ3Kj2SFx0Ivh
    vector-0.12.3.0-K9OZS5OCy7cE2QKQqSO9mp

haddock-interfaces:
    /usr/share/doc/haskell-vector-algorithms/html/vector-algorithms.haddock

haddock-html:         /usr/share/doc/haskell-vector-algorithms/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

