#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 sorted-list
version:              0.2.1.0
visibility:           public
id:                   sorted-list-0.2.1.0-9nmT4tHEEdz1Ro1gJtKttX
key:                  sorted-list-0.2.1.0-9nmT4tHEEdz1Ro1gJtKttX
license:              BSD-3-Clause
maintainer:           dhelta.diaz@gmail.com
author:               Daniel Díaz
homepage:
    https://github.com/Daniel-Diaz/sorted-list/blob/master/README.md

synopsis:             Type-enforced sorted lists and related functions.
description:
    Type-enforced sorted lists and related functions.

    These are useful for:

    * Constraining the argument of a function to be a sorted list
    by stating in your type that the input list is a sorted list.

    * Avoiding sorting a list twice.

    * Creating a list that is sorted from the moment of its construction,
    so it doesn'\''t have to be sorted later.

    * Performing list operations keeping the input list sorted.

    * Improving those list operations that can be
    benefited from the ordering of its elements.

    * Creating infinite lists that are sorted!

    * And more!

    If you are missing a feature, do not hesitate
    to ask by opening an issue at the bug-tracker.

category:             Data
abi:                  fc5e03e6344fcdb83d0ac708c09f109e
exposed:              True
exposed-modules:      Data.SortedList
import-dirs:          /usr/lib/ghc-8.10.5/site-local/sorted-list-0.2.1.0
library-dirs:         /usr/lib/ghc-8.10.5/site-local/sorted-list-0.2.1.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/sorted-list-0.2.1.0
hs-libraries:         HSsorted-list-0.2.1.0-9nmT4tHEEdz1Ro1gJtKttX
depends:              base-4.14.2.0 deepseq-1.4.4.0
haddock-interfaces:   /usr/share/doc/haskell-sorted-list/html/sorted-list.haddock
haddock-html:         /usr/share/doc/haskell-sorted-list/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

