#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 language-haskell-extract
version:              0.2.4
visibility:           public
id:                   language-haskell-extract-0.2.4-wPeye7DzC36EKjMQShyiC
key:                  language-haskell-extract-0.2.4-wPeye7DzC36EKjMQShyiC
license:              BSD-3-Clause
maintainer:           Oscar Finnsson
author:               Oscar Finnsson & Emil Nordling
stability:            stable
homepage:             http://github.com/finnsson/template-helper
synopsis:
    Module to automatically extract functions from the local code.

description:
    @language-haskell-extract@ contains some useful helper functions on top of Template Haskell.

    @functionExtractor@ extracts all functions after a regexp-pattern.

    > foo = "test"
    > boo = "testing"
    > bar = $(functionExtractor "oo$")

    will automagically extract the functions ending with @oo@ such as

    > bar = [("foo",foo), ("boo",boo)]

    This can be useful if you wish to extract all functions beginning with test (for a test-framework)
    or all functions beginning with wc (for a web service).

    @functionExtractorMap@ works like @functionsExtractor@ but applies a function over all function-pairs.

    This functions is useful if the common return type of the functions is a type class.

    Example:

    > secondTypeclassTest =
    >   do let expected = ["45", "88.8", "\"hej\""]
    >          actual = $(functionExtractorMap "^tc" [|\n f -> show f|] )
    >      expected @=? actual
    >
    > tcInt :: Integer
    > tcInt = 45
    >
    > tcDouble :: Double
    > tcDouble = 88.8
    >
    > tcString :: String
    > tcString = "hej"

category:             Template Haskell
abi:                  b66af034378c0b8f7b0ecfa99aa8e0ae
exposed:              True
exposed-modules:      Language.Haskell.Extract
import-dirs:
    /usr/lib/ghc-8.10.5/site-local/language-haskell-extract-0.2.4

library-dirs:
    /usr/lib/ghc-8.10.5/site-local/language-haskell-extract-0.2.4

dynamic-library-dirs: /usr/lib
data-dir:
    /usr/share/i386-linux-ghc-8.10.5/language-haskell-extract-0.2.4

hs-libraries:         HSlanguage-haskell-extract-0.2.4-wPeye7DzC36EKjMQShyiC
depends:
    base-4.14.2.0 regex-posix-0.96.0.1-F4JSS9fGdx95aOeG6CtJBb
    template-haskell-2.16.0.0

haddock-interfaces:
    /usr/share/doc/haskell-language-haskell-extract/html/language-haskell-extract.haddock

haddock-html:         /usr/share/doc/haskell-language-haskell-extract/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

