/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.ast;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.ElementModifier;
import io.micronaut.inject.ast.ElementQuery;
import io.micronaut.inject.ast.EnumElement;
import io.micronaut.inject.ast.FieldElement;
import io.micronaut.inject.ast.GenericPlaceholderElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.PackageElement;
import io.micronaut.inject.ast.PropertyElement;
import io.micronaut.inject.ast.ReflectClassElement;
import io.micronaut.inject.ast.ReflectGenericPlaceholderElement;
import io.micronaut.inject.ast.ReflectTypeElement;
import io.micronaut.inject.ast.ReflectWildcardElement;
import io.micronaut.inject.ast.SimpleClassElement;
import io.micronaut.inject.ast.TypedElement;
import io.micronaut.inject.ast.WildcardElement;
import io.micronaut.inject.ast.beans.BeanElementBuilder;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public interface ClassElement
extends TypedElement {
    public static final ClassElement[] ZERO_CLASS_ELEMENTS = new ClassElement[0];

    public boolean isAssignable(String var1);

    default public boolean isTypeVariable() {
        return false;
    }

    default public boolean isGenericPlaceholder() {
        return this instanceof GenericPlaceholderElement;
    }

    default public boolean isWildcard() {
        return this instanceof WildcardElement;
    }

    default public boolean isAssignable(ClassElement type) {
        return this.isAssignable(type.getName());
    }

    default public boolean isOptional() {
        return this.isAssignable(Optional.class);
    }

    default public String getCanonicalName() {
        if (this.isOptional()) {
            return this.getFirstTypeArgument().map(Element::getName).orElse(Object.class.getName());
        }
        return this.getName();
    }

    default public boolean isRecord() {
        return false;
    }

    default public boolean isInner() {
        return false;
    }

    default public boolean isEnum() {
        return this instanceof EnumElement;
    }

    default public boolean isProxy() {
        return this.getSimpleName().endsWith("$Intercepted");
    }

    @NonNull
    default public Optional<MethodElement> getPrimaryConstructor() {
        return Optional.empty();
    }

    @NonNull
    default public Optional<MethodElement> getDefaultConstructor() {
        return Optional.empty();
    }

    default public Optional<ClassElement> getSuperType() {
        return Optional.empty();
    }

    default public Collection<ClassElement> getInterfaces() {
        return Collections.emptyList();
    }

    @Override
    @NonNull
    default public ClassElement getType() {
        return this;
    }

    @Override
    default public String getSimpleName() {
        return NameUtils.getSimpleName((String)this.getName());
    }

    default public String getPackageName() {
        return NameUtils.getPackageName((String)this.getName());
    }

    default public PackageElement getPackage() {
        return PackageElement.of(this.getPackageName());
    }

    default public List<PropertyElement> getBeanProperties() {
        return Collections.emptyList();
    }

    default public List<FieldElement> getFields() {
        return this.getEnclosedElements(ElementQuery.ALL_FIELDS);
    }

    @Deprecated
    default public List<FieldElement> getFields(@NonNull Predicate<Set<ElementModifier>> modifierFilter) {
        Objects.requireNonNull(modifierFilter, "The modifier filter cannot be null");
        return this.getEnclosedElements(ElementQuery.ALL_FIELDS.modifiers(modifierFilter));
    }

    default public <T extends Element> List<T> getEnclosedElements(@NonNull ElementQuery<T> query) {
        return Collections.emptyList();
    }

    default public Optional<ClassElement> getEnclosingType() {
        return Optional.empty();
    }

    default public <T extends Element> Optional<T> getEnclosedElement(@NonNull ElementQuery<T> query) {
        List<T> enclosedElements = this.getEnclosedElements(query);
        if (!enclosedElements.isEmpty()) {
            return Optional.of((Element)enclosedElements.iterator().next());
        }
        return Optional.empty();
    }

    default public boolean isInterface() {
        return false;
    }

    default public boolean isIterable() {
        return this.isArray() || this.isAssignable(Iterable.class);
    }

    @NonNull
    default public List<? extends ClassElement> getBoundGenericTypes() {
        return new ArrayList<ClassElement>(this.getTypeArguments().values());
    }

    @NonNull
    default public List<? extends GenericPlaceholderElement> getDeclaredGenericPlaceholders() {
        return Collections.emptyList();
    }

    @NonNull
    default public ClassElement getRawClassElement() {
        return this.withBoundGenericTypes(Collections.emptyList());
    }

    @NonNull
    default public ClassElement withBoundGenericTypes(@NonNull List<? extends ClassElement> typeArguments) {
        return this;
    }

    default public ClassElement foldBoundGenericTypes(@NonNull Function<ClassElement, ClassElement> fold) {
        List typeArgs = this.getBoundGenericTypes().stream().map(arg -> arg.foldBoundGenericTypes(fold)).collect(Collectors.toList());
        if (typeArgs.contains(null)) {
            typeArgs = Collections.emptyList();
        }
        return fold.apply(this.withBoundGenericTypes(typeArgs));
    }

    @NonNull
    default public Map<String, ClassElement> getTypeArguments(@NonNull String type) {
        return Collections.emptyMap();
    }

    @NonNull
    default public Map<String, ClassElement> getTypeArguments(@NonNull Class<?> type) {
        ArgumentUtils.requireNonNull((String)"type", type);
        return this.getTypeArguments(type.getName());
    }

    @NonNull
    default public Map<String, ClassElement> getTypeArguments() {
        return Collections.emptyMap();
    }

    @NonNull
    default public Map<String, Map<String, ClassElement>> getAllTypeArguments() {
        return Collections.emptyMap();
    }

    default public Optional<ClassElement> getFirstTypeArgument() {
        return this.getTypeArguments().values().stream().findFirst();
    }

    default public boolean isAssignable(Class<?> type) {
        return this.isAssignable(type.getName());
    }

    @NonNull
    public ClassElement toArray();

    @NonNull
    public ClassElement fromArray();

    @NonNull
    default public BeanElementBuilder addAssociatedBean(@NonNull ClassElement type) {
        throw new UnsupportedOperationException("Element of type [" + this.getClass() + "] does not support adding associated beans at compilation time");
    }

    @NonNull
    public static ClassElement of(@NonNull Class<?> type) {
        return new ReflectClassElement(Objects.requireNonNull(type, "Type cannot be null"));
    }

    @NonNull
    public static ClassElement of(@NonNull Type type) {
        Objects.requireNonNull(type, "Type cannot be null");
        if (type instanceof Class) {
            return new ReflectClassElement((Class)type);
        }
        if (type instanceof TypeVariable) {
            return new ReflectGenericPlaceholderElement((TypeVariable)type, 0);
        }
        if (type instanceof WildcardType) {
            return new ReflectWildcardElement((WildcardType)type);
        }
        if (type instanceof ParameterizedType) {
            final ParameterizedType pType = (ParameterizedType)type;
            if (pType.getOwnerType() != null) {
                throw new UnsupportedOperationException("Owner types are not supported");
            }
            return new ReflectClassElement(ReflectTypeElement.getErasure(type)){

                @Override
                @NonNull
                public List<? extends ClassElement> getBoundGenericTypes() {
                    return Arrays.stream(pType.getActualTypeArguments()).map(ClassElement::of).collect(Collectors.toList());
                }
            };
        }
        if (type instanceof GenericArrayType) {
            return ClassElement.of(((GenericArrayType)type).getGenericComponentType()).toArray();
        }
        throw new IllegalArgumentException("Bad type: " + type.getClass().getName());
    }

    @NonNull
    public static ClassElement of(@NonNull Class<?> type, final @NonNull AnnotationMetadata annotationMetadata, final @NonNull Map<String, ClassElement> typeArguments) {
        Objects.requireNonNull(annotationMetadata, "Annotation metadata cannot be null");
        Objects.requireNonNull(typeArguments, "Type arguments cannot be null");
        return new ReflectClassElement(Objects.requireNonNull(type, "Type cannot be null")){

            public AnnotationMetadata getAnnotationMetadata() {
                return annotationMetadata;
            }

            @Override
            public Map<String, ClassElement> getTypeArguments() {
                return Collections.unmodifiableMap(typeArguments);
            }

            @Override
            @NonNull
            public List<? extends ClassElement> getBoundGenericTypes() {
                return this.getDeclaredGenericPlaceholders().stream().map(tv -> (ClassElement)typeArguments.get(tv.getVariableName())).collect(Collectors.toList());
            }
        };
    }

    @Internal
    @NonNull
    public static ClassElement of(@NonNull String typeName) {
        return new SimpleClassElement(typeName);
    }

    @Internal
    @NonNull
    public static ClassElement of(@NonNull String typeName, boolean isInterface, @Nullable AnnotationMetadata annotationMetadata) {
        return new SimpleClassElement(typeName, isInterface, annotationMetadata);
    }

    @Internal
    @NonNull
    public static ClassElement of(@NonNull String typeName, boolean isInterface, @Nullable AnnotationMetadata annotationMetadata, Map<String, ClassElement> typeArguments) {
        return new SimpleClassElement(typeName, isInterface, annotationMetadata);
    }
}

