/*
 * This file is part of gtkD.
 *
 * gtkD is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version, with
 * some exceptions, please read the COPYING file.
 *
 * gtkD is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with gtkD; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110, USA
 */

// generated automatically - do not change
// find conversion definition on APILookup.txt
// implement new conversion functionalities the gir-to-d pakage


module glib.Relation;

private import glib.ConstructionException;
private import glib.Tuples;
private import glib.c.functions;
public  import glib.c.types;


/**
 * A `GRelation` is a table of data which can be indexed on any number
 * of fields, rather like simple database tables. A `GRelation` contains
 * a number of records, called tuples. Each record contains a number of
 * fields. Records are not ordered, so it is not possible to find the
 * record at a particular index.
 * 
 * Note that `GRelation` tables are currently limited to 2 fields.
 * 
 * To create a `GRelation`, use [func@GLib.Relation.new].
 * 
 * To specify which fields should be indexed, use [method@GLib.Relation.index].
 * Note that this must be called before any tuples are added to the
 * `GRelation`.
 * 
 * To add records to a `GRelation` use [method@GLib.Relation.insert].
 * 
 * To determine if a given record appears in a `GRelation`, use
 * [method@GLib.Relation.exists]. Note that fields are compared directly, so
 * pointers must point to the exact same position (i.e. different
 * copies of the same string will not match.)
 * 
 * To count the number of records which have a particular value in a
 * given field, use [method@GLib.Relation.count].
 * 
 * To get all the records which have a particular value in a given
 * field, use [method@GLib.Relation.select]. To access fields of the resulting
 * records, use [method@GLib.Tuples.index]. To free the resulting records use
 * [method@GLib.Tuples.destroy].
 * 
 * To delete all records which have a particular value in a given
 * field, use [method@GLib.Relation.delete].
 * 
 * To destroy the `GRelation`, use [method@GLib.Relation.destroy].
 * 
 * To help debug `GRelation` objects, use [method@GLib.Relation.print].
 * 
 * `GRelation` has been marked as deprecated, since this API has never
 * been fully implemented, is not very actively maintained and rarely
 * used.
 * 
 * Deprecated: Rarely used API
 */
public class Relation
{
	/** the main Gtk struct */
	protected GRelation* gRelation;
	protected bool ownedRef;

	/** Get the main Gtk struct */
	public GRelation* getRelationStruct(bool transferOwnership = false)
	{
		if (transferOwnership)
			ownedRef = false;
		return gRelation;
	}

	/** the main Gtk struct as a void* */
	protected void* getStruct()
	{
		return cast(void*)gRelation;
	}

	/**
	 * Sets our main struct and passes it to the parent class.
	 */
	public this (GRelation* gRelation, bool ownedRef = false)
	{
		this.gRelation = gRelation;
		this.ownedRef = ownedRef;
	}


	/**
	 * Returns the number of tuples in a #GRelation that have the given
	 * value in the given field.
	 *
	 * Deprecated: Rarely used API
	 *
	 * Params:
	 *     key = the value to compare with.
	 *     field = the field of each record to match.
	 *
	 * Returns: the number of matches.
	 */
	public int count(void* key, int field)
	{
		return g_relation_count(gRelation, key, field);
	}

	alias delet = delete_;
	/**
	 * Deletes any records from a #GRelation that have the given key value
	 * in the given field.
	 *
	 * Deprecated: Rarely used API
	 *
	 * Params:
	 *     key = the value to compare with.
	 *     field = the field of each record to match.
	 *
	 * Returns: the number of records deleted.
	 */
	public int delete_(void* key, int field)
	{
		return g_relation_delete(gRelation, key, field);
	}

	/**
	 * Destroys the #GRelation, freeing all memory allocated. However, it
	 * does not free memory allocated for the tuple data, so you should
	 * free that first if appropriate.
	 *
	 * Deprecated: Rarely used API
	 */
	public void destroy()
	{
		g_relation_destroy(gRelation);
	}

	/**
	 * Creates an index on the given field. Note that this must be called
	 * before any records are added to the #GRelation.
	 *
	 * Deprecated: Rarely used API
	 *
	 * Params:
	 *     field = the field to index, counting from 0.
	 *     hashFunc = a function to produce a hash value from the field data.
	 *     keyEqualFunc = a function to compare two values of the given field.
	 */
	public void index(int field, GHashFunc hashFunc, GEqualFunc keyEqualFunc)
	{
		g_relation_index(gRelation, field, hashFunc, keyEqualFunc);
	}

	/**
	 * Outputs information about all records in a #GRelation, as well as
	 * the indexes. It is for debugging.
	 *
	 * Deprecated: Rarely used API
	 */
	public void print()
	{
		g_relation_print(gRelation);
	}

	/**
	 * Returns all of the tuples which have the given key in the given
	 * field. Use g_tuples_index() to access the returned records. The
	 * returned records should be freed with g_tuples_destroy().
	 *
	 * Deprecated: Rarely used API
	 *
	 * Params:
	 *     key = the value to compare with.
	 *     field = the field of each record to match.
	 *
	 * Returns: the records (tuples) that matched.
	 */
	public Tuples select(void* key, int field)
	{
		auto __p = g_relation_select(gRelation, key, field);

		if(__p is null)
		{
			return null;
		}

		return new Tuples(cast(GTuples*) __p);
	}

	/**
	 * Creates a new #GRelation with the given number of fields. Note that
	 * currently the number of fields must be 2.
	 *
	 * Deprecated: Rarely used API
	 *
	 * Params:
	 *     fields = the number of fields.
	 *
	 * Returns: a new #GRelation.
	 *
	 * Throws: ConstructionException GTK+ fails to create the object.
	 */
	public this(int fields)
	{
		auto __p = g_relation_new(fields);

		if(__p is null)
		{
			throw new ConstructionException("null returned by new");
		}

		this(cast(GRelation*) __p);
	}
}
