/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.importer.plugin.file.spreadsheet;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.gephi.io.importer.api.Issue;
import org.gephi.io.importer.api.Report;
import org.gephi.io.importer.plugin.file.spreadsheet.sheet.SheetParser;
import org.gephi.utils.CharsetToolkit;
import org.openide.util.NbBundle;

public class SpreadsheetUtils {
    public static void logInfo(Report report, String message, SheetParser parser) {
        SpreadsheetUtils.logIssue(report, new Issue(message, Issue.Level.INFO), parser);
    }

    public static void logWarning(Report report, String message, SheetParser parser) {
        SpreadsheetUtils.logIssue(report, new Issue(message, Issue.Level.WARNING), parser);
    }

    public static void logError(Report report, String message, SheetParser parser) {
        SpreadsheetUtils.logIssue(report, new Issue(message, Issue.Level.SEVERE), parser);
    }

    public static void logCritical(Report report, String message, SheetParser parser) {
        SpreadsheetUtils.logIssue(report, new Issue(message, Issue.Level.CRITICAL), parser);
    }

    public static void logIssue(Report report, Issue issue, SheetParser parser) {
        if (parser != null) {
            String newMessage = "[" + NbBundle.getMessage(SpreadsheetUtils.class, (String)"SpreadsheetUtils.recordNumber", (Object)parser.getCurrentRecordNumber()) + "] " + issue.getMessage();
            issue = new Issue(newMessage, issue.getLevel());
        }
        if (report != null) {
            report.logIssue(issue);
        } else {
            Level level;
            switch (issue.getLevel()) {
                case INFO: {
                    level = Level.INFO;
                    break;
                }
                case WARNING: {
                    level = Level.WARNING;
                    break;
                }
                case SEVERE: 
                case CRITICAL: {
                    level = Level.SEVERE;
                    break;
                }
                default: {
                    level = Level.FINE;
                }
            }
            Logger.getLogger("").log(level, issue.getMessage());
        }
    }

    public static CSVParser configureCSVParser(File file, Character fieldSeparator, Charset charset, boolean withFirstRecordAsHeader) throws IOException {
        if (fieldSeparator == null) {
            fieldSeparator = Character.valueOf(',');
        }
        CSVFormat csvFormat = CSVFormat.DEFAULT.withDelimiter(fieldSeparator.charValue()).withEscape('\\').withIgnoreEmptyLines(true).withNullString("").withIgnoreSurroundingSpaces(true).withTrim(true);
        csvFormat = withFirstRecordAsHeader ? csvFormat.withFirstRecordAsHeader().withAllowMissingColumnNames(false).withIgnoreHeaderCase(false) : csvFormat.withHeader((String[])null).withSkipHeaderRecord(false);
        boolean hasBOM = false;
        try (FileInputStream is2 = new FileInputStream(file);){
            CharsetToolkit charsetToolkit = new CharsetToolkit((InputStream)is2);
            hasBOM = charsetToolkit.hasUTF8Bom() || charsetToolkit.hasUTF16BEBom() || charsetToolkit.hasUTF16LEBom();
        }
        catch (IOException is2) {
            // empty catch block
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        InputStreamReader is = new InputStreamReader((InputStream)fileInputStream, charset);
        if (hasBOM) {
            try {
                is.read();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return new CSVParser((Reader)is, csvFormat);
    }
}

