﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/rum/CloudWatchRUM_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace CloudWatchRUM
{
namespace Model
{

  /**
   * <p>A structure that contains information about the user session that this batch
   * of events was collected from.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/rum-2018-05-10/UserDetails">AWS API
   * Reference</a></p>
   */
  class UserDetails
  {
  public:
    AWS_CLOUDWATCHRUM_API UserDetails();
    AWS_CLOUDWATCHRUM_API UserDetails(Aws::Utils::Json::JsonView jsonValue);
    AWS_CLOUDWATCHRUM_API UserDetails& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_CLOUDWATCHRUM_API Aws::Utils::Json::JsonValue Jsonize() const;


    /**
     * <p>The session ID that the performance events are from.</p>
     */
    inline const Aws::String& GetSessionId() const{ return m_sessionId; }

    /**
     * <p>The session ID that the performance events are from.</p>
     */
    inline bool SessionIdHasBeenSet() const { return m_sessionIdHasBeenSet; }

    /**
     * <p>The session ID that the performance events are from.</p>
     */
    inline void SetSessionId(const Aws::String& value) { m_sessionIdHasBeenSet = true; m_sessionId = value; }

    /**
     * <p>The session ID that the performance events are from.</p>
     */
    inline void SetSessionId(Aws::String&& value) { m_sessionIdHasBeenSet = true; m_sessionId = std::move(value); }

    /**
     * <p>The session ID that the performance events are from.</p>
     */
    inline void SetSessionId(const char* value) { m_sessionIdHasBeenSet = true; m_sessionId.assign(value); }

    /**
     * <p>The session ID that the performance events are from.</p>
     */
    inline UserDetails& WithSessionId(const Aws::String& value) { SetSessionId(value); return *this;}

    /**
     * <p>The session ID that the performance events are from.</p>
     */
    inline UserDetails& WithSessionId(Aws::String&& value) { SetSessionId(std::move(value)); return *this;}

    /**
     * <p>The session ID that the performance events are from.</p>
     */
    inline UserDetails& WithSessionId(const char* value) { SetSessionId(value); return *this;}


    /**
     * <p>The ID of the user for this user session. This ID is generated by RUM and
     * does not include any personally identifiable information about the user.</p>
     */
    inline const Aws::String& GetUserId() const{ return m_userId; }

    /**
     * <p>The ID of the user for this user session. This ID is generated by RUM and
     * does not include any personally identifiable information about the user.</p>
     */
    inline bool UserIdHasBeenSet() const { return m_userIdHasBeenSet; }

    /**
     * <p>The ID of the user for this user session. This ID is generated by RUM and
     * does not include any personally identifiable information about the user.</p>
     */
    inline void SetUserId(const Aws::String& value) { m_userIdHasBeenSet = true; m_userId = value; }

    /**
     * <p>The ID of the user for this user session. This ID is generated by RUM and
     * does not include any personally identifiable information about the user.</p>
     */
    inline void SetUserId(Aws::String&& value) { m_userIdHasBeenSet = true; m_userId = std::move(value); }

    /**
     * <p>The ID of the user for this user session. This ID is generated by RUM and
     * does not include any personally identifiable information about the user.</p>
     */
    inline void SetUserId(const char* value) { m_userIdHasBeenSet = true; m_userId.assign(value); }

    /**
     * <p>The ID of the user for this user session. This ID is generated by RUM and
     * does not include any personally identifiable information about the user.</p>
     */
    inline UserDetails& WithUserId(const Aws::String& value) { SetUserId(value); return *this;}

    /**
     * <p>The ID of the user for this user session. This ID is generated by RUM and
     * does not include any personally identifiable information about the user.</p>
     */
    inline UserDetails& WithUserId(Aws::String&& value) { SetUserId(std::move(value)); return *this;}

    /**
     * <p>The ID of the user for this user session. This ID is generated by RUM and
     * does not include any personally identifiable information about the user.</p>
     */
    inline UserDetails& WithUserId(const char* value) { SetUserId(value); return *this;}

  private:

    Aws::String m_sessionId;
    bool m_sessionIdHasBeenSet = false;

    Aws::String m_userId;
    bool m_userIdHasBeenSet = false;
  };

} // namespace Model
} // namespace CloudWatchRUM
} // namespace Aws
