﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/guardduty/GuardDuty_EXPORTS.h>
#include <aws/guardduty/GuardDutyRequest.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/guardduty/model/ScanResourceCriteria.h>
#include <aws/guardduty/model/EbsSnapshotPreservation.h>
#include <utility>

namespace Aws
{
namespace GuardDuty
{
namespace Model
{

  /**
   */
  class UpdateMalwareScanSettingsRequest : public GuardDutyRequest
  {
  public:
    AWS_GUARDDUTY_API UpdateMalwareScanSettingsRequest();

    // Service request name is the Operation name which will send this request out,
    // each operation should has unique request name, so that we can get operation's name from this request.
    // Note: this is not true for response, multiple operations may have the same response name,
    // so we can not get operation's name from response.
    inline virtual const char* GetServiceRequestName() const override { return "UpdateMalwareScanSettings"; }

    AWS_GUARDDUTY_API Aws::String SerializePayload() const override;


    /**
     * <p>The unique ID of the detector that specifies the GuardDuty service where you
     * want to update scan settings.</p>
     */
    inline const Aws::String& GetDetectorId() const{ return m_detectorId; }

    /**
     * <p>The unique ID of the detector that specifies the GuardDuty service where you
     * want to update scan settings.</p>
     */
    inline bool DetectorIdHasBeenSet() const { return m_detectorIdHasBeenSet; }

    /**
     * <p>The unique ID of the detector that specifies the GuardDuty service where you
     * want to update scan settings.</p>
     */
    inline void SetDetectorId(const Aws::String& value) { m_detectorIdHasBeenSet = true; m_detectorId = value; }

    /**
     * <p>The unique ID of the detector that specifies the GuardDuty service where you
     * want to update scan settings.</p>
     */
    inline void SetDetectorId(Aws::String&& value) { m_detectorIdHasBeenSet = true; m_detectorId = std::move(value); }

    /**
     * <p>The unique ID of the detector that specifies the GuardDuty service where you
     * want to update scan settings.</p>
     */
    inline void SetDetectorId(const char* value) { m_detectorIdHasBeenSet = true; m_detectorId.assign(value); }

    /**
     * <p>The unique ID of the detector that specifies the GuardDuty service where you
     * want to update scan settings.</p>
     */
    inline UpdateMalwareScanSettingsRequest& WithDetectorId(const Aws::String& value) { SetDetectorId(value); return *this;}

    /**
     * <p>The unique ID of the detector that specifies the GuardDuty service where you
     * want to update scan settings.</p>
     */
    inline UpdateMalwareScanSettingsRequest& WithDetectorId(Aws::String&& value) { SetDetectorId(std::move(value)); return *this;}

    /**
     * <p>The unique ID of the detector that specifies the GuardDuty service where you
     * want to update scan settings.</p>
     */
    inline UpdateMalwareScanSettingsRequest& WithDetectorId(const char* value) { SetDetectorId(value); return *this;}


    /**
     * <p>Represents the criteria to be used in the filter for selecting resources to
     * scan.</p>
     */
    inline const ScanResourceCriteria& GetScanResourceCriteria() const{ return m_scanResourceCriteria; }

    /**
     * <p>Represents the criteria to be used in the filter for selecting resources to
     * scan.</p>
     */
    inline bool ScanResourceCriteriaHasBeenSet() const { return m_scanResourceCriteriaHasBeenSet; }

    /**
     * <p>Represents the criteria to be used in the filter for selecting resources to
     * scan.</p>
     */
    inline void SetScanResourceCriteria(const ScanResourceCriteria& value) { m_scanResourceCriteriaHasBeenSet = true; m_scanResourceCriteria = value; }

    /**
     * <p>Represents the criteria to be used in the filter for selecting resources to
     * scan.</p>
     */
    inline void SetScanResourceCriteria(ScanResourceCriteria&& value) { m_scanResourceCriteriaHasBeenSet = true; m_scanResourceCriteria = std::move(value); }

    /**
     * <p>Represents the criteria to be used in the filter for selecting resources to
     * scan.</p>
     */
    inline UpdateMalwareScanSettingsRequest& WithScanResourceCriteria(const ScanResourceCriteria& value) { SetScanResourceCriteria(value); return *this;}

    /**
     * <p>Represents the criteria to be used in the filter for selecting resources to
     * scan.</p>
     */
    inline UpdateMalwareScanSettingsRequest& WithScanResourceCriteria(ScanResourceCriteria&& value) { SetScanResourceCriteria(std::move(value)); return *this;}


    /**
     * <p>An enum value representing possible snapshot preservation settings.</p>
     */
    inline const EbsSnapshotPreservation& GetEbsSnapshotPreservation() const{ return m_ebsSnapshotPreservation; }

    /**
     * <p>An enum value representing possible snapshot preservation settings.</p>
     */
    inline bool EbsSnapshotPreservationHasBeenSet() const { return m_ebsSnapshotPreservationHasBeenSet; }

    /**
     * <p>An enum value representing possible snapshot preservation settings.</p>
     */
    inline void SetEbsSnapshotPreservation(const EbsSnapshotPreservation& value) { m_ebsSnapshotPreservationHasBeenSet = true; m_ebsSnapshotPreservation = value; }

    /**
     * <p>An enum value representing possible snapshot preservation settings.</p>
     */
    inline void SetEbsSnapshotPreservation(EbsSnapshotPreservation&& value) { m_ebsSnapshotPreservationHasBeenSet = true; m_ebsSnapshotPreservation = std::move(value); }

    /**
     * <p>An enum value representing possible snapshot preservation settings.</p>
     */
    inline UpdateMalwareScanSettingsRequest& WithEbsSnapshotPreservation(const EbsSnapshotPreservation& value) { SetEbsSnapshotPreservation(value); return *this;}

    /**
     * <p>An enum value representing possible snapshot preservation settings.</p>
     */
    inline UpdateMalwareScanSettingsRequest& WithEbsSnapshotPreservation(EbsSnapshotPreservation&& value) { SetEbsSnapshotPreservation(std::move(value)); return *this;}

  private:

    Aws::String m_detectorId;
    bool m_detectorIdHasBeenSet = false;

    ScanResourceCriteria m_scanResourceCriteria;
    bool m_scanResourceCriteriaHasBeenSet = false;

    EbsSnapshotPreservation m_ebsSnapshotPreservation;
    bool m_ebsSnapshotPreservationHasBeenSet = false;
  };

} // namespace Model
} // namespace GuardDuty
} // namespace Aws
