﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSStreamFwd.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/sdb/SimpleDB_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Xml {
class XmlNode;
}  // namespace Xml
}  // namespace Utils
namespace SimpleDB {
namespace Model {

/**
 * <p></p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/sdb-2009-04-15/ReplaceableAttribute">AWS
 * API Reference</a></p>
 */
class ReplaceableAttribute {
 public:
  AWS_SIMPLEDB_API ReplaceableAttribute() = default;
  AWS_SIMPLEDB_API ReplaceableAttribute(const Aws::Utils::Xml::XmlNode& xmlNode);
  AWS_SIMPLEDB_API ReplaceableAttribute& operator=(const Aws::Utils::Xml::XmlNode& xmlNode);

  AWS_SIMPLEDB_API void OutputToStream(Aws::OStream& ostream, const char* location, unsigned index, const char* locationValue) const;
  AWS_SIMPLEDB_API void OutputToStream(Aws::OStream& oStream, const char* location) const;

  ///@{
  /**
   * The name of the replaceable attribute.
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  ReplaceableAttribute& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * The value of the replaceable attribute.
   */
  inline const Aws::String& GetValue() const { return m_value; }
  inline bool ValueHasBeenSet() const { return m_valueHasBeenSet; }
  template <typename ValueT = Aws::String>
  void SetValue(ValueT&& value) {
    m_valueHasBeenSet = true;
    m_value = std::forward<ValueT>(value);
  }
  template <typename ValueT = Aws::String>
  ReplaceableAttribute& WithValue(ValueT&& value) {
    SetValue(std::forward<ValueT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * A flag specifying whether or not to replace the attribute/value pair or to add a
   * new attribute/value pair. The default setting is <code>false</code>.
   */
  inline bool GetReplace() const { return m_replace; }
  inline bool ReplaceHasBeenSet() const { return m_replaceHasBeenSet; }
  inline void SetReplace(bool value) {
    m_replaceHasBeenSet = true;
    m_replace = value;
  }
  inline ReplaceableAttribute& WithReplace(bool value) {
    SetReplace(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_name;

  Aws::String m_value;

  bool m_replace{false};
  bool m_nameHasBeenSet = false;
  bool m_valueHasBeenSet = false;
  bool m_replaceHasBeenSet = false;
};

}  // namespace Model
}  // namespace SimpleDB
}  // namespace Aws
