START TRANSACTION;
INSERT INTO users (userid,alias,name,surname,passwd,url,autologin,autologout,lang,refresh,type,theme,rows_per_page) values ('1','Admin','Zabbix','Administrator','$2y$10$92nDno4n0Zm7Ej7Jfsz8WukBfgSS/U0QkIuu8WkJPihXBb2A1UrEK','','1','0','en_GB','30s','3','default','50');
INSERT INTO users (userid,alias,name,surname,passwd,url,autologin,autologout,lang,refresh,type,theme,rows_per_page) values ('2','guest','','','$2y$10$89otZrRNmde97rIyzclecuk6LwKAsHN0BcvoOKGjbT.BwMBfm7G06','','0','15m','en_GB','30s','1','default','50');
INSERT INTO hstgrp (groupid,name,internal,flags) values ('1','Templates','0','0');
INSERT INTO hstgrp (groupid,name,internal,flags) values ('2','Linux servers','0','0');
INSERT INTO hstgrp (groupid,name,internal,flags) values ('4','Zabbix servers','0','0');
INSERT INTO hstgrp (groupid,name,internal,flags) values ('5','Discovered hosts','1','0');
INSERT INTO hstgrp (groupid,name,internal,flags) values ('6','Virtual machines','0','0');
INSERT INTO hstgrp (groupid,name,internal,flags) values ('7','Hypervisors','0','0');
INSERT INTO hstgrp (groupid,name,internal,flags) values ('8','Templates/Modules','0','0');
INSERT INTO hstgrp (groupid,name,internal,flags) values ('9','Templates/Network devices','0','0');
INSERT INTO hstgrp (groupid,name,internal,flags) values ('10','Templates/Operating systems','0','0');
INSERT INTO hstgrp (groupid,name,internal,flags) values ('11','Templates/Server hardware','0','0');
INSERT INTO hstgrp (groupid,name,internal,flags) values ('12','Templates/Applications','0','0');
INSERT INTO hstgrp (groupid,name,internal,flags) values ('13','Templates/Databases','0','0');
INSERT INTO hstgrp (groupid,name,internal,flags) values ('14','Templates/Virtualization','0','0');
INSERT INTO drules (druleid,proxy_hostid,name,iprange,delay,status) values ('2',NULL,'Local network','192.168.0.1-254','1h','1');
INSERT INTO dchecks (dcheckid,druleid,type,key_,snmp_community,ports,snmpv3_securityname,snmpv3_securitylevel,snmpv3_authpassphrase,snmpv3_privpassphrase,uniq,snmpv3_authprotocol,snmpv3_privprotocol,snmpv3_contextname,host_source,name_source) values ('2','2','9','system.uname','','10050','','0','','','0','0','0','','1','0');
INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,status,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,exec_params,maxsessions,maxattempts,attempt_interval,content_type,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description) values ('1','0','Email','mail.example.com','example.com','zabbix@example.com','','','','','0','25','0','0','0','0','','1','3','10s','0','','30s','0','0','','','');
INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,status,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,exec_params,maxsessions,maxattempts,attempt_interval,content_type,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description) values ('3','2','SMS','','','','','/dev/ttyS0','','','0','25','0','0','0','0','','1','3','10s','1','','30s','0','0','','','');
INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,status,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,exec_params,maxsessions,maxattempts,attempt_interval,content_type,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description) values ('4','0','Email (HTML)','mail.example.com','example.com','zabbix@example.com','','','','','0','25','0','0','0','0','','1','3','10s','1','','30s','0','0','','','');
INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,status,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,exec_params,maxsessions,maxattempts,attempt_interval,content_type,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description) values ('5','4','Mattermost','','','','','','','','0','25','0','0','0','0','','1','1','10s','1',E'var SEVERITY_COLORS = [
    ''#97AAB3'', ''#7499FF'', ''#FFC859'',
    ''#FFA059'', ''#E97659'', ''#E45959''
];

var RESOLVE_COLOR = ''#009900'';

var SEND_MODE_HANDLERS = {
    alarm: handlerAlarm,
    event: handlerEvent
};

if (!String.prototype.format) {
    String.prototype.format = function() {
        var args = arguments;

        return this.replace(/{(\\d+)}/g, function(match, number) {
            return number in args
                ? args[number]
                : match
            ;
        });
    };
}

function isEventProblem(params) {
    return params.event_value == 1
        && params.event_update_status == 0
    ;
}

function isEventUpdate(params) {
    return params.event_value == 1
        && params.event_update_status == 1
    ;
}

function isEventResolve(params) {
    return params.event_value == 0;
}

function getPermalink(mattermost_url, team_name, postid) {
    return ''{0}/{1}/pl/{2}''.format(
        mattermost_url.replace(/\\/+$/, ''''),
        team_name,
        postid
    );
}

function getChannel(send_to) {
    switch (true) {
        case /.+\\/#.+/.test(send_to):
            return getChannelByName(send_to);

        case /@.+/.test(send_to):
            return getDirectChannel(send_to);

        default:
            return getChannelByID(send_to);
    }
}

function getChannelByName(send_to) {
    var team_chan = send_to
        .trim()
        .split(''/#'');

    var resp = JSON.parse(req.Get(
        Mattermost.channel_byname.format(team_chan[0], team_chan[1]),
        JSON.stringify(fields)
    )
    );

    if (req.Status() != 200) {
        throw ''[{0}] {1}''.format(resp.status_code, resp.message);
    }

    return resp;
}

function getDirectChannel(send_to) {
    Zabbix.Log(5, ''[ Mattermost Webhook ] Call {0}({1})''.format(
        arguments.callee.name,
        JSON.stringify(arguments)
    ));

    var teamUser = send_to
            .trim()
            .split(''/@''),
        bot = getBotUser(),
        user = getUserByName(teamUser[1]);

    var resp = JSON.parse(req.Post(
        Mattermost.direct_channel,
        JSON.stringify([bot.id, user.id])
    )
    );

    Zabbix.Log(5, ''[ Mattermost Webhook ] Result {0}: {1}''.format(
        arguments.callee.name,
        JSON.stringify(resp)
    ));

    if (req.Status() != 201) {
        throw ''[{0}] {1}''.format(resp.status_code, resp.message);
    }

    resp.team_name = teamUser[0];

    return resp;
}

function getChannelByID(channelID) {
    Zabbix.Log(5, ''[ Mattermost Webhook ] Call {0}({1})''.format(
        arguments.callee.name,
        JSON.stringify(arguments)
    ));

    var resp = JSON.parse(req.Get(
        Mattermost.get_channel.format(channelID),
        JSON.stringify(fields)
    )
    );

    Zabbix.Log(5, ''[ Mattermost Webhook ] Result {0}: {1}''.format(
        arguments.callee.name,
        JSON.stringify(resp)
    ));

    if (req.Status() != 200) {
        throw ''[{0}] {1}''.format(resp.status_code, resp.message);
    }

    return resp;
}

function getBotUser() {
    Zabbix.Log(5, ''[ Mattermost Webhook ] Call {0}({1})''.format(
        arguments.callee.name,
        JSON.stringify(arguments)
    ));

    var resp = JSON.parse(req.Get(
        Mattermost.bot_user,
        JSON.stringify(fields)
    )
    );

    Zabbix.Log(5, ''[ Mattermost Webhook ] Result {0}: {1}''.format(
        arguments.callee.name,
        JSON.stringify(resp)
    ));

    if (req.Status() != 200) {
        throw ''[{0}] {1}''.format(resp.status_code, resp.message);
    }

    return resp;
}

function getUserByName(userName) {
    Zabbix.Log(5, ''[ Mattermost Webhook ] Call {0}({1})''.format(
        arguments.callee.name,
        JSON.stringify(arguments)
    ));

    var resp = JSON.parse(req.Get(
        Mattermost.user_byname.format(userName),
        JSON.stringify(fields)
    )
    );

    Zabbix.Log(5, ''[ Mattermost Webhook ] Result {0}: {1}''.format(
        arguments.callee.name,
        JSON.stringify(resp)
    ));

    if (req.Status() != 200) {
        throw ''[{0}] {1}''.format(resp.status_code, resp.message);
    }

    return resp;
}

function getTeamByID(teamID) {
    Zabbix.Log(5, ''[ Mattermost Webhook ] Call {0}({1})''.format(
        arguments.callee.name,
        JSON.stringify(arguments)
    ));

    var resp = JSON.parse(req.Get(
        Mattermost.get_team.format(teamID),
        JSON.stringify(fields)
    )
    );

    Zabbix.Log(5, ''[ Mattermost Webhook ] Result {0}: {1}''.format(
        arguments.callee.name,
        JSON.stringify(resp)
    ));

    if (req.Status() != 200) {
        throw ''[{0}] {1}''.format(resp.status_code, resp.message);
    }

    return resp;
}

function createProblemURL(zabbix_url, triggerid, eventid, event_source) {
    var problem_url = '''';
    if (event_source === ''0'') {
        problem_url = ''{0}/tr_events.php?triggerid={1}&eventid={2}''
            .format(
                zabbix_url,
                triggerid,
                eventid
            );
    }
    else {
        problem_url = zabbix_url;
    }

    return problem_url;
}

function getTagValue(event_tags, key) {
    var pattern = new RegExp(''('' + key + '':.+)'');
    var tagValue = event_tags
        .split('','')
        .filter(function (v) {
            return v.match(pattern);
        })
        .map(function (v) {
            return v.split('':'')[1];
        })[0]
        || 0;

    return tagValue;
}

function handlerAlarm(req, params) {
    var channel = getChannel(params.send_to);
    var fields = {
        channel_id: channel.id,
        props: {}
    };

    if (isEventProblem(params)) {
        var team_name = channel.team_name
            ? channel.team_name
            : getTeamByID(channel.team_id).name;

        fields.props.attachments = [
            createMessage(
                SEVERITY_COLORS[params.event_nseverity] || 0,
                params.event_date,
                params.event_time,
                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source)
            )
        ];

        var resp = JSON.parse(req.Post(
            Mattermost.post_message,
            JSON.stringify(fields)
        )
        );

        if (req.Status() != 201) {
            throw ''[{0}] {1}''.format(resp.status_code, resp.message);
        }

        result.tags.__mattermost_post_id = resp.id;
        result.tags.__mattermost_channel_id = channel.id;
        result.tags.__mattermost_channel_name = channel.name;
        result.tags.__mattermost_message_link = getPermalink(
            params.mattermost_url,
            team_name,
            resp.id
        );

    }
    else if (isEventUpdate(params)) {
        fields.root_id = getTagValue(params.event_tags, ''mattermost_post_id'');

        if (params.event_source === ''0'') {}
        fields.props.attachments = [
            createMessage(
                SEVERITY_COLORS[params.event_nseverity] || 0,
                params.event_update_date,
                params.event_update_time,
                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source),
                true
            )
        ];

        resp = JSON.parse(req.Post(
            Mattermost.post_message, JSON.stringify(fields)
        )
        );

        if (req.Status() != 201) {
            throw ''[{0}] {1}''.format(resp.status_code, resp.message);
        }

    }
    else if (isEventResolve(params)) {
        fields.channel_id = getTagValue(params.event_tags, ''mattermost_channel_id'');
        fields.id = getTagValue(params.event_tags, ''mattermost_post_id'');
        fields.props.attachments = [
            createMessage(
                RESOLVE_COLOR,
                params.event_date,
                params.event_time,
                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source)
            )
        ];

        var post_id = getTagValue(params.event_tags, ''mattermost_post_id'');

        resp = JSON.parse(req.Put(
            Mattermost.chat_update.format(post_id),
            JSON.stringify(fields)
        )
        );

        if (req.Status() != 200) {
            throw ''[{0}] {1}''.format(resp.status_code, resp.message);
        }
    }
}

function handlerEvent(req, params) {
    var channel = getChannel(params.send_to);
    var fields = {
        channel_id: channel.id,
        props: {}
    };

    if (isEventProblem(params)) {
        var team_name = channel.team_name
            ? channel.team_name
            : getTeamByID(channel.team_id).name;

        fields.props.attachments = [
            createMessage(
                SEVERITY_COLORS[params.event_nseverity] || 0,
                params.event_date,
                params.event_time,
                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source)
            )
        ];

        var resp = JSON.parse(req.Post(Mattermost.post_message, JSON.stringify(fields)));

        if (req.Status() != 201) {
            throw ''[{0}] {1}''.format(resp.status_code, resp.message);
        }

        result.tags.__mattermost_channel_name = channel.name;
        result.tags.__mattermost_message_link = getPermalink(
            params.mattermost_url,
            team_name,
            resp.id
        );

    }
    else if (isEventUpdate(params)) {
        fields.props.attachments = [
            createMessage(
                SEVERITY_COLORS[params.event_nseverity] || 0,
                params.event_update_date,
                params.event_update_time,
                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source),
                false
            )
        ];

        resp = JSON.parse(req.Post(Mattermost.post_message, JSON.stringify(fields)));

        if (req.Status() != 201) {
            throw ''[{0}] {1}''.format(resp.status_code, resp.message);
        }

    }
    else if (isEventResolve(params)) {
        fields.props.attachments = [
            createMessage(
                RESOLVE_COLOR,
                params.event_recovery_date,
                params.event_recovery_time,
                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source)
            )
        ];

        resp = JSON.parse(req.Post(Mattermost.post_message, JSON.stringify(fields)));

        if (req.Status() != 201) {
            throw ''[{0}] {1}''.format(resp.status_code, resp.message);
        }
    }
}

function createMessage(
    event_severity_color,
    event_date,
    event_time,
    problem_url,
    isShort
) {
    var message = {
        fallbac: params.alert_subject,
        title: params.alert_subject,
        color: event_severity_color,
        title_link: problem_url,
        footer: problem_url,

        fields: [
            {
                title: ''Host'',
                value: ''{0} [{1}]''.format(params.host_name, params.host_ip),
                short: true
            },
            {
                title: ''Event time'',
                value: ''{0} {1}''.format(event_date, event_time),
                short: true
            }
        ],
    };

    
    if (params.event_source === ''0'') {
        message.fields.push(
            {
                title: ''Severity'',
                value: params.event_severity,
                short: true
            },
            {
                title: ''Opdata'',
                value: params.event_opdata,
                short: true
            }
        );
    }

    if (!isShort && params.event_source === ''0'') {
        message.fields.push(
            {
                title: ''Event tags'',
                value: ''`{0}`''.format(params.event_tags.replace(/__.+?:(.+?,|.+)/g, '''') || ''None''),
                short: true
            },
            {
                title: ''Trigger description'',
                value: params.trigger_description,
                short: true
            }
        );
    }

    if (params.event_source !== ''0'' || params.event_update_status === ''1'') {
        message.fields.push(
            {
                title: ''Details'',
                value: params.alert_message,
                short: false
            }
        );
    }

    return message;
}

function validateParams(params) {
    if (typeof params.bot_token !== ''string'' || params.bot_token.trim() === '''') {
        throw ''Field "bot_token" cannot be empty'';
    }

    if (isNaN(params.event_id)) {
        throw ''Field "event_id" is not a number'';
    }

    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {
        throw ''Incorrect "event_source" parameter given: "'' + params.event_source + ''".\\nMust be 0-3.'';
    }

    if (params.event_source !== ''0'') {
        params.event_nseverity = ''0'';
        params.event_severity = ''Not classified'';
        params.event_update_status = ''0'';
        params.send_mode = ''event'';
    }

    if (params.event_source === ''1'' || params.event_source === ''2'') {
        params.event_value = ''1'';
    }

    if (params.event_source === ''1'') {
        params.host_name = params.discovery_host_dns;
        params.host_ip = params.discovery_host_ip;
    }

    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {
        throw ''Incorrect "event_nseverity" parameter given: '' + params.event_nseverity + ''\\nMust be 0-5.'';
    }

    if (typeof params.event_severity !== ''string'' || params.event_severity.trim() === '''') {
        throw ''Field "event_severity" cannot be empty'';
    }

    if (params.event_update_status !== ''0'' && params.event_update_status !== ''1'') {
        throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''\\nMust be 0 or 1.'';
    }

    if (params.event_value !== ''0'' && params.event_value !== ''1'') {
        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\\nMust be 0 or 1.'';
    }

    if (typeof params.host_ip !== ''string'' || params.host_ip.trim() === '''') {
        throw ''Field "host_ip" cannot be empty'';
    }

    if (typeof params.host_name !== ''string'' || params.host_name.trim() === '''') {
        throw ''Field "host_name" cannot be empty'';
    }

    if (typeof params.mattermost_url !== ''string'' || params.mattermost_url.trim() === '''') {
        throw ''Field "mattermost_url" cannot be empty'';
    }

    if (!/^(http|https):\\/\\/.+/.test(params.mattermost_url)) {
        throw ''Field "mattermost_url" must contain a schema'';
    }

    if ([''alarm'', ''event''].indexOf(params.send_mode) === -1) {
        throw ''Incorrect "send_mode" parameter given: '' + params.send_mode + ''\\nMust be "alarm" or "event".'';
    }

    if (typeof params.send_to !== ''string'' || params.send_to.trim() === '''') {
        throw ''Field "send_to" cannot be empty'';
    }

    if (isNaN(params.trigger_id) && params.event_source === ''0'') {
        throw ''field "trigger_id" is not a number'';
    }

    if (typeof params.zabbix_url !== ''string'' || params.zabbix_url.trim() === '''') {
        throw ''Field "zabbix_url" cannot be empty'';
    }

    if (!/^(http|https):\\/\\/.+/.test(params.zabbix_url)) {
        throw ''Field "zabbix_url" must contain a schema'';
    }

}

try {
    var params = JSON.parse(value);

    validateParams(params);

    var req = new CurlHttpRequest(),
        fields = {},
        result = {tags: {}};

    if (typeof params.HTTPProxy === ''string'' && params.HTTPProxy.trim() !== '''') {
        req.SetProxy(params.HTTPProxy);
    }

    req.AddHeader(''Content-Type: application/json; charset=utf-8'');
    req.AddHeader(''Authorization: Bearer '' + params.bot_token);

    params.mattermost_url = params.mattermost_url.replace(/\\/+$/, '''');
    params.zabbix_url = params.zabbix_url.replace(/\\/+$/, '''');

    var APIEndpoint = params.mattermost_url + ''/api/v4/'';

    var Mattermost = {
        post_message: APIEndpoint + ''posts'',
        get_channel: APIEndpoint + ''channels/{0}'',
        get_team: APIEndpoint + ''teams/{0}'',
        chat_update: APIEndpoint + ''posts/{0}'',
        direct_channel: APIEndpoint + ''channels/direct'',
        channel_byname: APIEndpoint + ''teams/name/{0}/channels/name/{1}'',
        user_byname: APIEndpoint + ''users/username/{0}'',
        bot_user: APIEndpoint + ''users/me''

    };

    params.send_mode = params.send_mode.toLowerCase();
    params.send_mode = params.send_mode in SEND_MODE_HANDLERS
        ? params.send_mode
        : ''alarm'';

    SEND_MODE_HANDLERS[params.send_mode](req, params);

    if (params.event_source === ''0'') {
        return JSON.stringify(result);
    }
    else {
        return ''OK'';
    }
}
catch (error) {
    Zabbix.Log(4, ''[ Mattermost Webhook ] Mattermost notification failed: '' + error);
    throw ''Mattermost notification failed: '' + error;
}','30s','1','1','{EVENT.TAGS.__mattermost_message_link}','Open in Mattermost: {EVENT.TAGS.__mattermost_channel_name}','');
INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,status,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,exec_params,maxsessions,maxattempts,attempt_interval,content_type,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description) values ('6','4','Opsgenie','','','','','','','','0','25','0','0','0','0','','1','3','10s','1',E'var Media = {
    params: {},
    name: '''',
    labels: [],
    HTTPProxy: '''',

    setParams: function (params) {
        if (typeof params !== ''object'') {
            return;
        }

        Media.params = params;
        Media.params.api += Media.params.api.endsWith(''/'') ? '''' : ''/'';
        Media.params.web += Media.params.web.endsWith(''/'') ? '''' : ''/'';
    },

    setProxy: function (HTTPProxy) {
        if (typeof HTTPProxy !== ''undefined'' && HTTPProxy.trim() !== '''') {
            Media.HTTPProxy = HTTPProxy;
        }
    },

    setTags: function(event_tags_json) {
        if (typeof event_tags_json !== ''undefined'' && event_tags_json !== ''''
                && event_tags_json !== ''{EVENT.TAGSJSON}'') {

            try {
                var tags = JSON.parse(event_tags_json),
                    label;

                tags.forEach(function (tag) {
                    if (typeof tag.tag === ''string'') {
                        label = (tag.tag + (typeof tag.value !== ''undefined''
                                && tag.value !== '''' ? ('':'' + tag.value) : '''')).replace(/\\s/g, ''_'');
                        Media.labels.push(label);
                    }
                });
            }
            catch (error) {
                Zabbix.Log(4, ''[ '' + Media.name + '' Webhook ] Failed to parse "event_tags_json" param'');
            }
        }
    },

    request: function (method, query, data, allow_404) {
        if (typeof(allow_404) === ''undefined'') {
            allow_404 = false;
        }

        [''api'', ''token''].forEach(function (field) {
            if (typeof Media.params !== ''object'' || typeof Media.params[field] === ''undefined''
                    || Media.params[field] === '''') {
                throw ''Required '' + Media.name + '' param is not set: "'' + field + ''".'';
            }
        });

        var response,
            url = Media.params.api + query,
            request = new CurlHttpRequest();

        request.AddHeader(''Content-Type: application/json'');
        request.AddHeader(''Authorization: '' + Media.params.token);
        request.SetProxy(Media.HTTPProxy);

        if (typeof data !== ''undefined'') {
            data = JSON.stringify(data);
        }

        Zabbix.Log(4, ''[ '' + Media.name + '' Webhook ] Sending request: '' +
            url + ((typeof data === ''string'') ? (''\\n'' + data) : ''''));

        switch (method) {
            case ''get'':
                response = request.Get(url, data);
                break;

            case ''post'':
                response = request.Post(url, data);
                break;

            case ''put'':
                response = request.Put(url, data);
                break;

            default:
                throw ''Unsupported HTTP request method: '' + method;
        }

        Zabbix.Log(4, ''[ '' + Media.name + '' Webhook ] Received response with status code '' +
            request.Status() + ''\\n'' + response);

        if (response !== null) {
            try {
                response = JSON.parse(response);
            }
            catch (error) {
                Zabbix.Log(4, ''[ '' + Media.name + '' Webhook ] Failed to parse response.'');
                response = null;
            }
        }

        if ((request.Status() < 200 || request.Status() >= 300)
                && (!allow_404 || request.Status() !== 404)) {
            var message = ''Request failed with status code '' + request.Status();

            if (response !== null) {
                if (typeof response.errors === ''object'' && Object.keys(response.errors).length > 0) {
                    message += '': '' + JSON.stringify(response.errors);
                }
                else if (typeof response.errorMessages === ''object'' && Object.keys(response.errorMessages).length > 0) {
                    message += '': '' + JSON.stringify(response.errorMessages);
                }
                else if (typeof response.message === ''string'') {
                    message += '': '' + response.message;
                }
            }

            throw message + '' Check debug log for more information.'';
        }

        return {
            status: request.Status(),
            response: response
        };
    },

    getAlertId: function (requestId) {
        do {
            resp = Media.request(''get'', ''requests/'' + requestId, undefined, true);
        }
        while (typeof resp.response !== ''object'' || typeof resp.response.data === ''undefined''
                || resp.response.data.success === false);

        if (typeof resp.response !== ''object'' || typeof resp.response.data === ''undefined'') {
            throw ''Cannot get '' + Media.name + '' issue ID. Check debug log for more information.'';
        }

        return resp;
    }
};

try {
    var result = {tags: {}},
        params = JSON.parse(value),
        media = {},
        fields = {},
        resp = {},
        responders = [],
        tags = [],
        required_params = [
            ''alert_subject'',
            ''alert_message'',
            ''event_id'',
            ''event_source'',
            ''event_value'',
            ''event_update_status'',
            ''opsgenie_api'',
            ''opsgenie_web'',
            ''opsgenie_token''
        ],
        severities = [
            ''not_classified'',
            ''information'',
            ''warning'',
            ''average'',
            ''high'',
            ''disaster'',
            ''resolved'',
            ''default''
        ],
        priority;

    Object.keys(params)
        .forEach(function (key) {
            if (required_params.indexOf(key) !== -1 && params[key].trim() === '''') {
                throw ''Parameter "'' + key + ''" cannot be empty.'';
            }
            if (key.startsWith(''opsgenie_'')) {
                media[key.substring(9)] = params[key];
            }
        });

    // Possible values of event_source:
    // 0 - Trigger, 1 - Discovery, 2 - Autoregistration, 3 - Internal.
    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {
        throw ''Incorrect "event_source" parameter given: "'' + params.event_source + ''".\\nMust be 0-3.'';
    }

    // Check event_value for trigger-based and internal events.
    // Possible values: 1 for problem, 0 for recovering
    if (params.event_value !== ''0'' && params.event_value !== ''1''
        && (params.event_source === ''0'' || params.event_source === ''3'')) {
        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\\nMust be 0 or 1.'';
    }

    // Check event_update_status only for trigger-based events.
    // Possible values: 0 - Webhook was called because of problem/recovery event, 1 - Update operation.
    if (params.event_source === ''0'' && params.event_update_status !== ''0'' && params.event_update_status !== ''1'') {
        throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''\\nMust be 0 or 1.'';
    }

    // Check event_id for a numeric value.
    if (isNaN(parseInt(params.event_id)) || params.event_id < 1) {
        throw ''Incorrect "event_id" parameter given: '' + params.event_id + ''\\nMust be a positive number.'';
    }

    if ((params.event_source === ''1'' || params.event_source === ''2'')  && params.event_value === ''0'') {
        throw ''Recovery operations are supported only for Trigger and Internal actions.'';
    }

    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {
        params.event_nseverity = ''7'';
    }

    if (params.event_value === ''0'') {
        params.event_nseverity = ''6'';
    }

    priority = params[''severity_'' + severities[params.event_nseverity]];
    params.zbxurl = params.zbxurl + (params.zbxurl.endsWith(''/'') ? '''' : ''/'');

    Media.name = ''Opsgenie'';
    Media.setParams(media);
    Media.params.token = ''GenieKey '' + Media.params.token;
    Media.setProxy(params.HTTPProxy);
    Media.setTags(params.event_tags_json); // Set Media.labels

    // Create an issue.
    // Numeric value of the event that triggered an action (1 for problem, 0 for recovering).
    // Numeric value of of the problem update status. Possible values:
    // 0 - Webhook was called because of problem/recovery event, 1 - Update operation.
    if ((params.event_source == 0 && params.event_value == 1 && params.event_update_status == 0)
            || (params.event_source == 3 && params.event_value == 1)
            || params.event_source == 1 || params.event_source == 2) {
        fields.message = params.alert_subject;
        fields.alias = params.event_id;
        fields.description = params.alert_message;
        fields.priority = priority;
        fields.source = ''Zabbix'';

        if (params.event_source === ''0'') {
            fields.details = {
                ''Zabbix server'': params.zbxurl,
                Problem: params.zbxurl + ''tr_events.php?triggerid='' + params.trigger_id + ''&eventid='' + params.event_id
            };
        }
        else {
            fields.details = {''Zabbix server'': params.zbxurl};
        }

        if (typeof params.opsgenie_teams === ''string'') {
            responders = params.opsgenie_teams.split('','');
            fields.responders = responders.map(function(team) {
                return {type: ''team'', name: team.trim()};
            });
        }

        fields.tags = Media.labels;
        if (typeof params.opsgenie_tags === ''string'') {
            tags = params.opsgenie_tags.split('','');
            tags.forEach(function(item) {
                fields.tags.push(item.trim());
            });
        }

        resp = Media.request(''post'', '''', fields);
        if (typeof resp.response !== ''object'' || typeof resp.response.result === ''undefined'') {
            throw ''Cannot create '' + Media.name + '' issue. Check debug log for more information.'';
        }

        if (resp.status === 202) {
            resp = Media.getAlertId(resp.response.requestId);
            if (params.event_source == 0 && params.event_value == 1 && params.event_update_status == 0) {
                result.tags.__zbx_ops_issuekey = resp.response.data.alertId;
                result.tags.__zbx_ops_issuelink = Media.params.web + ''alert/detail/'' + resp.response.data.alertId;
            }
        }
        else {
            throw Media.name + '' response code is unexpected. Check debug log for more information.'';
        }
    }
    // Update a created issue.
    else {
        fields.user = (params.event_value != 0) ? params.zbxuser : '''';
        fields.note = params.alert_message;

        resp = Media.request(''post'', params.event_id + ''/notes?identifierType=alias'', fields);
        if (typeof resp.response !== ''object'' || typeof resp.response.result === ''undefined'') {
            throw ''Cannot update '' + Media.name + '' issue. Check debug log for more information.'';
        }

        if (resp.status === 202) {
            resp = Media.getAlertId(resp.response.requestId);
        }
        else {
            throw Media.name + '' response code is unexpected. Check debug log for more information.'';
        }
    }

    return JSON.stringify(result);
}
catch (error) {
    Zabbix.Log(3, ''[ '' + Media.name + '' Webhook ] ERROR: '' + error);
    throw ''Sending failed: '' + error;
}','30s','1','1','{EVENT.TAGS.__zbx_ops_issuelink}','Opsgenie: {EVENT.TAGS.__zbx_ops_issuekey}','Please refer to https://docs.opsgenie.com/docs/alert-api and https://www.zabbix.com/documentation/current/manual/config/notifications/media/webhook#example_scripts.
  
Set global macro {$ZABBIX.URL} with your Zabbix server URL.
Add dedicated user with media type "Opsgenie".
Change the values of the variables opsgenie_api (https://api.opsgenie.com/v2/alerts or https://api.eu.opsgenie.com/v2/alerts),
opsgenie_web (for example, https://myzabbix.app.opsgenie.com), opsgenie_token.');
INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,status,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,exec_params,maxsessions,maxattempts,attempt_interval,content_type,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description) values ('7','4','PagerDuty','','','','','','','','0','25','0','0','0','0','','1','3','10s','1',E'try {

    var params = JSON.parse(value),
        req = new CurlHttpRequest(),
        fields = {},
        resp = '''';

    // Correspondence between the PagerDuty and Zabbix severity level
    var severityMapping = [
        ''info'',    // Not classified
        ''info'',    // Information
        ''warning'', // Warning
        ''warning'', // Average
        ''error'',   // High
        ''critical'' // Disaster
    ];

    if (!severityMapping[params.severity]) {
        params.severity = ''0'';
    }

    if (typeof params.HTTPProxy === ''string'' && params.HTTPProxy.trim() !== '''') {
        req.SetProxy(params.HTTPProxy);
    }

    if (isNaN(parseInt(params.eventid)) || params.eventid < 1) {
        throw ''incorrect value for variable "eventid". The value must be a positive number.'';
    }
    if (params.eventname.length < 1) {
        throw ''incorrect value for variable "eventname". The value must be a non-empty string.'';
    }
    if (isNaN(parseInt(params.severity)) || (params.severity < 0 && params.severity > 5)) {
        throw ''incorrect value for variable "severity". The value must be a number 0..5.'';
    }

    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {
        throw ''Incorrect "event_source" parameter given: "'' + params.event_source + ''".\\nMust be 0-3.'';
    }
    // Check {EVENT.VALUE} for trigger-based and internal events.
    if (params.eventvalue !== ''0'' && params.eventvalue !== ''1''
        && (params.event_source === ''0'' || params.event_source === ''3'')) {
        throw ''Incorrect "eventvalue" parameter given: "'' + params.eventvalue + ''".\\nMust be 0 or 1.'';
    }

    if (params.event_source === ''0'') {
        if (params.hostname.length < 1) {
            throw ''incorrect value for variable "hostname". The value must be a non-empty string.'';
        }
        if (isNaN(parseInt(params.triggerid)) || params.triggerid < 1) {
            throw ''incorrect value for variable "triggerid". The value must be a positive number.'';
        }
        if (params.eventack != ''Yes'' && params.eventack != ''No'') {
            throw ''incorrect value for variable "eventack". The value must be Yes or No.'';
        }
        if (isNaN(parseInt(params.eventupdate)) || (params.eventupdate < 0 || params.eventupdate > 1)) {
            throw ''incorrect value for variable "eventupdate". The value must be 0 or 1.'';
        }
    }



    req.AddHeader(''Content-Type: application/json'');

    fields.routing_key = params.token;
    fields.dedup_key = params.eventid;

    if (((params.eventvalue == 1) && (params.eventupdate == 0)) || params.event_source !== ''0'') {
        fields.event_action = ''trigger'';
        fields.payload = {
            summary: params.eventname,
            source: (params.event_source === ''1'') ? ''Discovery'' : params.hostname + '' : '' + params.hostip,
            severity: severityMapping[params.severity],
        };
        
        if (params.event_source === ''0'') {
            fields.payload.custom_details = {
                ''Event date'': params.eventdate,
                ''Event time'': params.eventtime,
                ''Trigger description'': params.triggerdesc,
                ''Trigger opdata'': params.triggeropdata,
                ''Event tags'': params.eventtags,
                ''Event host'': params.hostname,
                ''Event host ip'': params.hostip
            };
            fields.links = [{
                href: params.url + ''/tr_events.php?triggerid='' + params.triggerid + ''&eventid='' + params.eventid,
                text: ''Event link''
            }];
        }
        else {
            fields.payload.custom_details = {
                ''Alert message'': params.alert_message
            };
        }

        fields.client = ''Zabbix'';
        fields.client_url = params.url;
    }
    else if ((params.eventvalue == 1) && (params.eventupdate == 1) && (params.eventack == ''Yes''))
        fields.event_action = ''acknowledge'';
    else if (params.eventvalue == 0)
        fields.event_action = ''resolve'';
    else
        throw ''incorrect values. Update message without ack will not be sent.'';

    Zabbix.Log(4, ''[PagerDuty Webhook] Sending request:'' + JSON.stringify(fields));
    resp = req.Post(''https://events.pagerduty.com/v2/enqueue'',
        JSON.stringify(fields)
    );
    Zabbix.Log(4, ''[PagerDuty Webhook] Receiving response:'' + resp);

    try {
        resp = JSON.parse(resp);
    }
    catch (error) {
        throw ''incorrect response. PagerDuty returned a non-JSON object.'';
    }

    if (req.Status() != 202) {
        if (typeof resp === ''object'' && typeof resp.errors === ''object'' && typeof resp.errors[0] === ''string'') {
            throw resp.errors[0];
        }
        else {
            throw ''Unknown error.'';
        }
    }

    if (resp.status != ''success'') {
        throw ''Unknown error.'';
    }

    return ''OK'';
}
catch (error) {
    Zabbix.Log(3, ''[PagerDuty Webhook] Notification failed : '' + error);
    throw ''PagerDuty notification failed : '' + error;
}','30s','0','0','','','Please refer to https://v2.developer.pagerduty.com/docs/send-an-event-events-api-v2 and https://www.zabbix.com/documentation/current/manual/config/notifications/media/webhook#example_scripts.
  
Set global macro {$ZABBIX.URL} with your Zabbix server URL.
Add a dedicated user with the media type "PagerDuty" and place the integration key in the "token" parameter to integrate into the service.');
INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,status,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,exec_params,maxsessions,maxattempts,attempt_interval,content_type,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description) values ('8','4','Pushover','','','','','','','','0','25','0','0','0','0','','0','3','10s','1',E'try {
    var params = JSON.parse(value),
        request = new CurlHttpRequest(),
        data,
        response,
        severities = [
            {name: ''not_classified'', color: ''#97AAB3''},
            {name: ''information'', color: ''#7499FF''},
            {name: ''warning'', color: ''#FFC859''},
            {name: ''average'', color: ''#FFA059''},
            {name: ''high'', color: ''#E97659''},
            {name: ''disaster'', color: ''#E45959''},
            {name: ''resolved'', color: ''#009900''},
            {name: ''default'', color: ''#000000''}
        ],
        priority;

    if (typeof params.HTTPProxy === ''string'' && params.HTTPProxy.trim() !== '''') {
        request.SetProxy(params.HTTPProxy);
    }

    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {
        throw ''Incorrect "event_source" parameter given: "'' + params.event_source + ''".\\nMust be 0-3.'';
    }

    if (params.event_value !== ''0'' && params.event_value !== ''1''
        && (params.event_source === ''0'' || params.event_source === ''3'')) {
        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\\nMust be 0 or 1.'';
    }

    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {
        params.event_nseverity = ''7'';
    }

    if (params.event_value === ''0'') {
        params.event_nseverity = ''6'';
    }

    priority = params[''priority_'' + severities[params.event_nseverity].name] || params.priority_default;

    if (isNaN(priority) || priority < -2 || priority > 2) {
        throw ''"priority" should be -2..2'';
    }

    if (params.event_source === ''0'' && isNaN(params.triggerid)) {
        throw ''field "triggerid" is not a number'';
    }

    if (isNaN(params.eventid)) {
        throw ''field "eventid" is not a number'';
    }

    if (typeof params.message !== ''string'' || params.message.trim() === '''') {
        throw ''field "message" cannot be empty'';
    }

    data = {
        token: params.token,
        user: params.user,
        title: params.title,
        message: params.message,
        url: (params.event_source === ''0'') 
            ? params.url + ''/tr_events.php?triggerid='' + params.triggerid + ''&eventid='' + params.eventid
            : params.url,
        url_title: params.url_title,
        priority: priority
    };

    if (priority == 2) {
        if (isNaN(params.retry) || params.retry < 30) {
            throw ''field "retry" should be a number with value of at least 30 if "priority" is set to 2'';
        }

        if (isNaN(params.expire) || params.expire > 10800) {
            throw ''field "expire" should be a number with value of at most 10800 if "priority" is set to 2'';
        }

        data.retry = params.retry;
        data.expire = params.expire;
    }

    data = JSON.stringify(data);
    Zabbix.Log(4, ''[ Pushover Webhook ] Sending request: '' + params.endpoint + ''\\n'' + data);

    request.AddHeader(''Content-Type: application/json'');
    response = request.Post(params.endpoint, data);

    Zabbix.Log(4, ''[ Pushover Webhook ] Received response with status code '' + request.Status() + ''\\n'' + response);

    if (response !== null) {
        try {
            response = JSON.parse(response);
        }
        catch (error) {
            Zabbix.Log(4, ''[ Pushover Webhook ] Failed to parse response received from Pushover'');
            response = null;
        }
    }

    if (request.Status() != 200 || response === null || typeof response !== ''object'' || response.status !== 1) {
        if (response !== null && typeof response === ''object'' && typeof response.errors === ''object''
                && typeof response.errors[0] === ''string'') {
            throw response.errors[0];
        }
        else {
            throw ''Unknown error. Check debug log for more information.'';
        }
    }

    return ''OK'';
}
catch (error) {
    Zabbix.Log(4, ''[ Pushover Webhook ] Pushover notification failed: '' + error);
    throw ''Pushover notification failed: '' + error;
}','30s','0','0','','','Please refer to setup guide here: https://git.zabbix.com/projects/ZBX/repos/zabbix/browse/templates/media/pushover

Set token parameter with to your Pushover application key.
When assigning Pushover media to the Zabbix user - add user key into send to field.');
INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,status,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,exec_params,maxsessions,maxattempts,attempt_interval,content_type,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description) values ('9','4','Slack','','','','','','','','0','25','0','0','0','0','','1','3','10s','1',E'var SEVERITY_COLORS = [
    ''#97AAB3'', ''#7499FF'', ''#FFC859'',
    ''#FFA059'', ''#E97659'', ''#E45959''
];

var RESOLVE_COLOR = ''#009900'';

var SLACK_MODE_HANDLERS = {
    alarm: handlerAlarm,
    event: handlerEvent
};


if (!String.prototype.format) {
    String.prototype.format = function() {
        var args = arguments;

        return this.replace(/{(\\d+)}/g, function(match, number) {
            return number in args
                ? args[number]
                : match
            ;
        });
    };
}

function isEventProblem(params) {
    return params.event_value == 1
        && params.event_update_status == 0
    ;
}

function isEventUpdate(params) {
    return params.event_value == 1
        && params.event_update_status == 1
    ;
}

function isEventResolve(params) {
    return params.event_value == 0;
}

function getPermalink(channelId, messageTimestamp) {
    var req = new CurlHttpRequest();

    req.AddHeader(''Content-Type: application/x-www-form-urlencoded; charset=utf-8'');

    var resp = JSON.parse(req.Get(
        ''{0}?token={1}&channel={2}&message_ts={3}''.format(
            Slack.getPermalink,
            params.bot_token,
            channelId,
            messageTimestamp
        )
    ));

    if (req.Status != 200 && !resp.ok) {
        throw resp.error;
    }

    return resp.permalink;
}

function createProblemURL(zabbix_url, triggerid, eventid, event_source) {
    var problem_url = '''';
    if (event_source === ''0'') {
        problem_url = ''{0}/tr_events.php?triggerid={1}&eventid={2}''
            .format(
                zabbix_url,
                triggerid,
                eventid
            );
    }
    else {
        problem_url = zabbix_url;
    }

    return problem_url;
}

function getTagValue(event_tags, key) {
    var pattern = new RegExp(''('' + key + '':.+)'');
    var tag_value = event_tags
        .split('','')
        .filter(function (v) {
            return v.match(pattern);
        })
        .map(function (v) {
            return v.split('':'')[1];
        })[0]
        || 0;

    return tag_value;
}

function handlerAlarm(params) {
    var fields = {
        channel: params.channel,
        as_user: params.slack_as_user,
    };

    if (isEventProblem(params)) {
        fields.attachments = [
            createMessage(
                SEVERITY_COLORS[params.event_nseverity] || 0,
                params.event_date,
                params.event_time,
                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source)
            )
        ];

        var resp = JSON.parse(req.Post(Slack.postMessage, JSON.stringify(fields)));

        if (req.Status != 200 && !resp.ok) {
            throw resp.error;
        }

        result.tags.__message_ts = resp.ts;
        result.tags.__channel_id = resp.channel;
        result.tags.__channel_name = params.channel;
        result.tags.__message_link = getPermalink(resp.channel, resp.ts);
    }
    else if (isEventUpdate(params)) {
        fields.thread_ts = getTagValue(params.event_tags, ''message_ts'');
        fields.attachments = [
            createMessage(
                SEVERITY_COLORS[params.event_nseverity] || 0,
                params.event_update_date,
                params.event_update_time,
                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source),
                true
            )
        ];

        resp = JSON.parse(req.Post(Slack.postMessage, JSON.stringify(fields)));
        if (req.Status != 200 && !resp.ok) {
            throw resp.error;
        }

    }
    else if (isEventResolve(params)) {
        fields.channel = getTagValue(params.event_tags, ''channel_id'');
        fields.text = '''';
        fields.ts = getTagValue(params.event_tags, ''message_ts'');
        fields.attachments = [
            createMessage(
                RESOLVE_COLOR,
                params.event_date,
                params.event_time,
                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source)
            )
        ];

        resp = JSON.parse(req.Post(Slack.chatUpdate, JSON.stringify(fields)));
        if (req.Status != 200 && !resp.ok) {
            throw resp.error;
        }
    }
}

function handlerEvent(params) {
    var fields = {
        channel: params.channel,
        as_user: params.slack_as_user
    };

    if (isEventProblem(params)) {
        fields.attachments = [
            createMessage(
                SEVERITY_COLORS[params.event_nseverity] || 0,
                params.event_date,
                params.event_time,
                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source)
            )
        ];

        var resp = JSON.parse(req.Post(Slack.postMessage, JSON.stringify(fields)));

        if (req.Status != 200 && !resp.ok) {
            throw resp.error;
        }

        result.tags.__channel_name = params.channel;
        result.tags.__message_link = getPermalink(resp.channel, resp.ts);

    }
    else if (isEventUpdate(params)) {
        fields.attachments = [
            createMessage(
                SEVERITY_COLORS[params.event_nseverity] || 0,
                params.event_update_date,
                params.event_update_time,
                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source),
                false
            )
        ];

        resp = JSON.parse(req.Post(Slack.postMessage, JSON.stringify(fields)));

        if (req.Status != 200 && !resp.ok) {
            throw resp.error;
        }

    }
    else if (isEventResolve(params)) {
        fields.attachments = [
            createMessage(
                RESOLVE_COLOR,
                params.event_recovery_date,
                params.event_recovery_time,
                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source)
            )
        ];

        resp = JSON.parse(req.Post(Slack.postMessage, JSON.stringify(fields)));

        if (req.Status != 200 && !resp.ok) {
            throw resp.error;
        }
    }
}

function createMessage(
    event_severity_color,
    event_date,
    event_time,
    problem_url,
    isShort,
    messageText
) {
    var message = {
        fallback: params.alert_subject,
        title: params.alert_subject,
        color: event_severity_color,
        title_link: problem_url,
        pretext: messageText || '''',

        fields: [
            {
                title: ''Host'',
                value: ''{0} [{1}]''.format(params.host_name, params.host_conn),
                short: true
            },
            {
                title: ''Event time'',
                value: ''{0} {1}''.format(event_date, event_time),
                short: true
            }
        ],
    };

    if (params.event_source === ''0'') {
        message.fields.push(
            {
                title: ''Severity'',
                value: params.event_severity,
                short: true
            },
            {
                title: ''Opdata'',
                value: params.event_opdata,
                short: true
            }
        );
    }

    if (!isShort  && params.event_source === ''0'') {
        message[''actions''] = [
            {
                type: ''button'',
                text: ''Open in Zabbix'',
                url: problem_url
            }
        ];

        message.fields.push(
            {
                title: ''Event tags'',
                value: params.event_tags.replace(/__.+?:(.+?,|.+)/g, '''') || ''None'',
                short: true
            },
            {
                title: ''Trigger description'',
                value: params.trigger_description,
                short: true
            }
        );
    }

    if (params.event_source !== ''0'' || params.event_update_status === ''1'') {
        message.fields.push(
            {
                title: ''Details'',
                value: params.alert_message,
                short: false
            }
        );
    }

    return message;
}

function validateParams(params) {
    if (typeof params.bot_token !== ''string'' || params.bot_token.trim() === '''') {
        throw ''Field "bot_token" cannot be empty'';
    }

    if (typeof params.channel !== ''string'' || params.channel.trim() === '''') {
        throw ''Field "channel" cannot be empty'';
    }

    if (isNaN(params.event_id)) {
        throw ''Field "event_id" is not a number'';
    }

    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {
        throw ''Incorrect "event_source" parameter given: "'' + params.event_source + ''".\\nMust be 0-3.'';
    }

    if (params.event_source !== ''0'') {
        params.event_nseverity = ''0'';
        params.event_severity = ''Not classified'';
        params.event_update_status = ''0'';
        params.slack_mode = ''event'';
    }

    if (params.event_source === ''1'' || params.event_source === ''2'') {
        params.event_value = ''1'';
    }

    if (params.event_source === ''1'') {
        params.host_name = params.discovery_host_dns;
        params.host_ip = params.discovery_host_ip;
    }

    if (!~[0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity))) {
        throw ''Incorrect "event_nseverity" parameter given: '' + params.event_nseverity + ''\\nMust be 0-5.'';
    }

    if (typeof params.event_severity !== ''string'' || params.event_severity.trim() === '''') {
        throw ''Field "event_severity" cannot be empty'';
    }

    if (params.event_update_status !== ''0'' && params.event_update_status !== ''1'') {
        throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''\\nMust be 0 or 1.'';
    }

    if (params.event_value !== ''0'' && params.event_value !== ''1'') {
        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\\nMust be 0 or 1.'';
    }

    if (typeof params.host_conn !== ''string'' || params.host_conn.trim() === '''') {
        throw ''Field "host_conn" cannot be empty'';
    }

    if (typeof params.host_name !== ''string'' || params.host_name.trim() === '''') {
        throw ''Field "host_name" cannot be empty'';
    }

    if (!~[''true'', ''false''].indexOf(params.slack_as_user.toLowerCase())) {
        throw ''Incorrect "slack_as_user" parameter given: '' + params.slack_as_user + ''\\nMust be "true" or "false".'';
    }

    if (!~[''alarm'', ''event''].indexOf(params.slack_mode)) {
        throw ''Incorrect "slack_mode" parameter given: '' + params.slack_mode + ''\\nMust be "alarm" or "event".'';
    }

    if (isNaN(params.trigger_id) && params.event_source === ''0'') {
        throw ''field "trigger_id" is not a number'';
    }

    if (typeof params.zabbix_url !== ''string'' || params.zabbix_url.trim() === '''') {
        throw ''Field "zabbix_url" cannot be empty'';
    }

    if (!/^(http|https):\\/\\/.+/.test(params.zabbix_url)) {
        throw ''Field "zabbix_url" must contain a schema'';
    }
}

try {
    var params = JSON.parse(value);

    validateParams(params);

    var req = new CurlHttpRequest(),
        result = {tags: {}};

    if (typeof params.HTTPProxy === ''string'' && params.HTTPProxy.trim() !== '''') {
        req.SetProxy(params.HTTPProxy);
    }

    req.AddHeader(''Content-Type: application/json; charset=utf-8'');
    req.AddHeader(''Authorization: Bearer '' + params.bot_token);

    var slack_endpoint = ''https://slack.com/api/'';

    var Slack = {
        postMessage: slack_endpoint + ''chat.postMessage'',
        getPermalink: slack_endpoint + ''chat.getPermalink'',
        chatUpdate: slack_endpoint + ''chat.update''
    };

    params.slack_mode = params.slack_mode.toLowerCase();
    params.slack_mode = params.slack_mode in SLACK_MODE_HANDLERS
        ? params.slack_mode
        : ''alarm'';

    SLACK_MODE_HANDLERS[params.slack_mode](params);

    if (params.event_source === ''0'') {
        return JSON.stringify(result);
    }
    else {
        return ''OK'';
    }
}
catch (error) {
    Zabbix.Log(4, ''[ Slack Webhook ] Slack notification failed : '' + error);
    throw ''Slack notification failed : '' + error;
}','30s','1','1','{EVENT.TAGS.__message_link}','Open in Slack: {EVENT.TAGS.__channel_name}','');
INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,status,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,exec_params,maxsessions,maxattempts,attempt_interval,content_type,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description) values ('10','4','Discord','','','','','','','','0','25','0','0','0','0','','1','3','10s','1',E'var SEVERITY_COLORS = [
    ''#97AAB3'', // Not classified.
    ''#7499FF'', // Information.
    ''#FFC859'', // Warning.
    ''#FFA059'', // Average.
    ''#E97659'', // High.
    ''#E45959'', // Disaster.
    ''#009900''  // Resolved.
];

function stringTruncate(str, len) {
    return str.length > len ? str.substring(0, len - 3) + ''...'' : str;
}

try {
    Zabbix.Log(4, ''[ Discord Webhook ] Executed with params: '' + value);

    var params = JSON.parse(value);

    if (!params.discord_endpoint) {
        throw ''Cannot get discord_endpoint'';
    }
    else {
        params.discord_endpoint = params.discord_endpoint.replace(''/api/'', ''/api/v7/'') + ''?wait=True'';
    }

    params.zabbix_url = (params.zabbix_url.endsWith(''/''))
        ? params.zabbix_url.slice(0, -1) : params.zabbix_url;

    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {
        throw ''Incorrect "event_source" parameter given: "'' + params.event_source + ''".\\nMust be 0-3.'';
    }

    // Set params to true for non trigger-based events.
    if (params.event_source !== ''0'') {
        params.use_default_message = ''true'';
        params.event_nseverity = ''0'';
    }

    // Check {EVENT.VALUE} for trigger-based and internal events.
    if (params.event_value !== ''0'' && params.event_value !== ''1''
        && (params.event_source === ''0'' || params.event_source === ''3'')) {
        throw ''Incorrect "event_value" parameter given: "'' + params.event_value + ''".\\nMust be 0 or 1.'';
    }

    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.
    if (params.event_update_status !== ''0'' && params.event_update_status !== ''1'' && params.event_source === ''0'') {
        throw ''Incorrect "event_update_status" parameter given: "'' + params.event_update_status + ''".\\nMust be 0 or 1.'';
    }

    if (params.event_value == 0) {
        params.event_nseverity = ''6'';
    }

    if (!SEVERITY_COLORS[params.event_nseverity]) {
        throw ''Incorrect "event_nseverity" parameter given: '' + params.event_nseverity + ''\\nMust be 0-5.'';
    }

    var color = parseInt(SEVERITY_COLORS[params.event_nseverity].replace(''#'', ''''), 16),
        fields = [],
        body = {
            embeds: [
                {
                    color: color || 0,
                    url: (params.event_source === ''0'')
                        ? params.zabbix_url + ''/tr_events.php?triggerid='' + params.trigger_id +
                            ''&eventid='' + params.event_id
                        : params.zabbix_url
                }
            ]
        };

    // Default message from {ALERT.MESSAGE}.
    if (params.use_default_message.toLowerCase() == ''true'') {
        body.embeds[0].title = stringTruncate(params.alert_subject, 256);
        body.embeds[0].description = stringTruncate(params.alert_message, 2048);
    }
    else {
        fields.push(
            {
                name: ''Host'',
                value: params.host_name + '' ['' + params.host_ip + '']''
            }
        );

        // Resolved message.
        if (params.event_value == 0 && params.event_update_status == 0) {
            body.embeds[0].title = stringTruncate(''OK: '' + params.event_name, 256);
            fields.push(
                {
                    name: ''Recovery time'',
                    value: params.event_recovery_time + '' '' + params.event_recovery_date,
                    inline: ''True''
                }
            );
        }

        // Problem message.
        else if (params.event_value == 1 && params.event_update_status == 0) {
            body.embeds[0].title = stringTruncate(''PROBLEM: '' + params.event_name, 256);
            fields.push(
                {
                    name: ''Event time'',
                    value: params.event_time + '' '' + params.event_date,
                    inline: ''True''
                }
            );
        }

        // Update message.
        else if (params.event_update_status == 1) {
            body.embeds[0].title = stringTruncate(''UPDATE: '' + params.event_name, 256);
            body.embeds[0].description = params.event_update_user + '' '' + params.event_update_action + ''.'';

            if (params.event_update_message) {
                body.embeds[0].description += '' Comment:\\n>>> '' + params.event_update_message;
            }

            body.embeds[0].description = stringTruncate(body.embeds[0].description, 2048);

            fields.push(
                {
                    name: ''Event update time'',
                    value: params.event_update_time + '' '' + params.event_update_date,
                    inline: ''True''
                }
            );
        }

        fields.push(
            {
                name: ''Severity'',
                value: params.event_severity,
                inline: ''True''
            }
        );

        if (params.event_opdata) {
            fields.push(
                {
                    name: ''Operational data'',
                    value: stringTruncate(params.event_opdata, 1024),
                    inline: ''True''
                }
            );
        }

        if (params.event_value == 1 && params.event_update_status == 0 && params.trigger_description) {
            fields.push(
                {
                    name: ''Trigger description'',
                    value: stringTruncate(params.trigger_description, 1024)
                }
            );
        }

        body.embeds[0].footer = {
            text: ''Event ID: '' + params.event_id
        };

        if (params.event_tags) {
            body.embeds[0].footer.text += ''\\nEvent tags: '' + params.event_tags;
        }
        body.embeds[0].footer.text = stringTruncate(body.embeds[0].footer.text, 2048);
    }

    if (fields.length > 0) {
        body.embeds[0].fields = fields;
    }

    var req = new CurlHttpRequest();

    if (typeof params.HTTPProxy === ''string'' && params.HTTPProxy.trim() !== '''') {
        req.SetProxy(params.HTTPProxy);
    }

    req.AddHeader(''Content-Type: application/json'');

    var resp = req.Post(params.discord_endpoint, JSON.stringify(body)),
        data = JSON.parse(resp);

    Zabbix.Log(4, ''[ Discord Webhook ] JSON: '' + JSON.stringify(body));
    Zabbix.Log(4, ''[ Discord Webhook ] Response: '' + resp);

    if (data.id) {
        return resp;
    }
    else {
        var message = ((typeof data.message === ''string'') ? data.message : ''Unknown error'');

        Zabbix.Log(3, ''[ Discord Webhook ] FAILED with response: '' + resp);
        throw message + ''. For more details check zabbix server log.'';
    }
}
catch (error) {
    Zabbix.Log(3, ''[ Discord Webhook ] ERROR: '' + error);
    throw ''Sending failed: '' + error;
}','30s','0','0','','','');
INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,status,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,exec_params,maxsessions,maxattempts,attempt_interval,content_type,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description) values ('11','4','SIGNL4','','','','','','','','0','25','0','0','0','0','','1','3','10s','1',E'// SIGNL4 Webhook
try {
    var response,
        payload,
        params = JSON.parse(value),
        endpoint = ''https://connect.signl4.com/webhook/'',
        request = new CurlHttpRequest();

    if (typeof params.HTTPProxy === ''string'' && params.HTTPProxy.trim() !== '''') {
        request.SetProxy(params.HTTPProxy);
    }

    if (typeof params.teamsecret === ''string'' && params.teamsecret.trim() !== '''') {
        endpoint += params.teamsecret;
        delete params.teamsecret;
    }
    else {
        throw ''The team secret of your SIGNL4 team cannot be empty.'';
    }

    if (typeof params.Severity === ''string'' && params.Severity === ''{EVENT.SEVERITY}'') {
        params.Severity = ''Not classified'';
    }

if (typeof params.User === ''string'' && params.User === ''{USER.FULLNAME}'') {
        params.User = '''';
    }

if (typeof params.Event_Update_Action === ''string'' && params.Event_Update_Action === ''{EVENT.UPDATE.ACTION}'') {
        params.Event_Update_Action = '''';
    }

// Assemble X-S4-ExternalID for two-way integration
// Format: "ZabbixEventID: 222 ZabbixURL: https://your-zabbix-server/zabbix/"
params[''X-S4-ExternalID''] = ''ZabbixEventID: '' + params.Event_ID;
if (typeof params.Zabbix_URL === ''string'' && params.Zabbix_URL.indexOf(''http'') == 0) {
// Make sure the URL ends with ''/''
if (params.Zabbix_URL.charAt(params.Zabbix_URL.length - 1) != ''/'') {
params.Zabbix_URL = params.Zabbix_URL + ''/'';
}

params[''X-S4-ExternalID''] = params[''X-S4-ExternalID''] + '' ZabbixURL: '' +  params.Zabbix_URL;

// Add Link parameter
params[''Link''] = params.Zabbix_URL + "tr_events.php?triggerid="+params.Trigger_ID + "&eventid=" + params.Event_ID;
}

// Check if this is a new problem or a recovery
if (params.Trigger_Status == ''OK'') {
params[''X-S4-Status''] = ''resolved'';
}
else {
params[''X-S4-Status''] = ''new'';
}

    payload = JSON.stringify(params);
    Zabbix.Log(4, ''[ SIGNL4 Webhook ] Sending request: '' + payload);

    request.AddHeader(''Content-Type: application/json'');
    response = request.Post(endpoint, ''payload='' + payload);

    Zabbix.Log(4, ''[ SIGNL4 Webhook ] Received response with status code '' +
            request.Status() + ''\\n'' + response
    );

    if (request.Status() !== 201) {
        throw ''Request failed with status code '' + request.Status() +
                ''. Check debug log for more information.'';
    }

    return ''OK'';
}
catch (error) {
    Zabbix.Log(4, ''[ SIGNL4 Webhook ] ERROR: '' + error);

    throw ''Sending failed: '' + error;
}','30s','0','0','','','SIGNL4 is a mobile alert notification app for powerful alerting, alert management and mobile assignment of work items. It offers alerting via app push, SMS and voice calls including escalations, tracking, and duty scheduling.

Get the app at https://www.signl4.com.

Find out more including an integration video here: https://www.signl4.com/blog/portfolio_item/zabbix-mobile-alert-notification-duty-schedule-escalation/
');
INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,status,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,exec_params,maxsessions,maxattempts,attempt_interval,content_type,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description) values ('12','4','Jira','','','','','','','','0','25','0','0','0','0','','1','3','10s','1',E'var Jira = {
    params: {},

    setParams: function (params) {
        if (typeof params !== ''object'') {
            return;
        }

        Jira.params = params;
        if (typeof Jira.params.url === ''string'') {
            if (!Jira.params.url.endsWith(''/'')) {
                Jira.params.url += ''/'';
            }

            Jira.params.url += ''rest/api/latest/'';
        }
    },

    setProxy: function (HTTPProxy) {
        Jira.HTTPProxy = HTTPProxy;
    },

    setTags: function(event_tags_json) {
        if (typeof event_tags_json !== ''undefined'' && event_tags_json !== ''''
            && event_tags_json !== ''{EVENT.TAGSJSON}'') {
            try {
                var tags = JSON.parse(event_tags_json),
                    label;

                Jira.labels = [];

                tags.forEach(function (tag) {
                    if (typeof tag.tag !== ''undefined'' && typeof tag.value !== ''undefined''
                        && !tag.tag.startsWith(''__zbx'')) {
                        label = (tag.tag + (tag.value ? ('':'' + tag.value) : '''')).replace(/\\s/g, ''_'');
                        if (label.length < 256) {
                            Jira.labels.push(label);
                        }
                    }
                });
            }
            catch (error) {
                // Code is not missing here.
            }
        }
    },

    escapeMarkup: function (str) {
        var length = str.length,
            result = '''',
            markup = [''{'', ''|'', ''}'', ''~'', ''_'', ''\\\\'', ''['', '']'', ''^'', ''<'', ''>'', ''?'', ''!'', ''#'', ''+'', ''*'', ''&''];

        for (var i = 0; i < length; i++) {
            var char = str[i];

            result += (markup.indexOf(char) !== -1) ? (''&#'' + str[i].charCodeAt() + '';'') : char;
        }

        return result;
    },

    addCustomFields: function (data, fields) {
        if (typeof fields === ''object'' && Object.keys(fields).length) {
            var schema = Jira.getSchema(),
                path = [''projects'', 0, ''issuetypes'', 0, ''fields''],
                field;

            while ((field = path.shift()) !== undefined) {
                schema = schema[field];
                if (typeof schema === ''undefined'') {
                    schema = null;
                    break;
                }
            }

            if (schema) {
                Object.keys(fields)
                    .forEach(function(field) {
                        if (typeof schema[field] === ''object'' && typeof schema[field].schema === ''object'') {
                            switch (schema[field].schema.type) {
                                case ''number'':
                                    data.fields[field] = parseInt(fields[field]);
                                    break;

                                case ''datetime'':
                                    if (fields[field].match(/\\d+[.-]\\d+[.-]\\d+T\\d+:\\d+:\\d+/) !== null) {
                                        data.fields[field] = fields[field].replace(/\\./g, ''-'');
                                    }
                                    break;

                                case ''option'':
                                    data.fields[field] = {value: fields[field]};
                                    break;

                                case ''array'':
                                    if (schema[field].schema.items === ''option'') {
                                        data.fields[field] = [{value: fields[field]}];
                                    }
                                    else {
                                        data.fields[field] = [fields[field]];
                                    }
                                    break;

                                default:
                                    data.fields[field] = fields[field];
                            }
                        }
                    });
            }
            else {
                Zabbix.Log(4, ''[ Jira Webhook ] Failed to retrieve field schema.'');
            }
        }

        return data;
    },

    request: function (method, query, data) {
        [''url'', ''user'', ''password'', ''project_key'', ''issue_type''].forEach(function (field) {
            if (typeof Jira.params !== ''object'' || typeof Jira.params[field] === ''undefined''
                || Jira.params[field] === '''' ) {
                throw ''Required Jira param is not set: "'' + field + ''".'';
            }
        });

        var response,
            url = Jira.params.url + query,
            request = new CurlHttpRequest();

        request.AddHeader(''Content-Type: application/json'');
        request.AddHeader(''Authorization: Basic '' + btoa(Jira.params.user + '':'' + Jira.params.password));

        if (typeof Jira.HTTPProxy !== ''undefined'' && Jira.HTTPProxy !== '''') {
            request.SetProxy(Jira.HTTPProxy);
        }

        if (typeof data !== ''undefined'') {
            data = JSON.stringify(data);
        }

        Zabbix.Log(4, ''[ Jira Webhook ] Sending request: '' + url + ((typeof data === ''string'') ? (''\\n'' + data) : ''''));

        switch (method) {
            case ''get'':
                response = request.Get(url, data);
                break;

            case ''post'':
                response = request.Post(url, data);
                break;

            case ''put'':
                response = request.Put(url, data);
                break;

            default:
                throw ''Unsupported HTTP request method: '' + method;
        }

        Zabbix.Log(4, ''[ Jira Webhook ] Received response with status code '' + request.Status() + ''\\n'' + response);

        if (response !== null) {
            try {
                response = JSON.parse(response);
            }
            catch (error) {
                Zabbix.Log(4, ''[ Jira Webhook ] Failed to parse response received from Jira'');
                response = null;
            }
        }

        if (request.Status() < 200 || request.Status() >= 300) {
            var message = ''Request failed with status code '' + request.Status();

            if (response !== null && typeof response.errors !== ''undefined''
                && Object.keys(response.errors).length > 0) {
                message += '': '' + JSON.stringify(response.errors);
            }
            else if (response !== null && typeof response.errorMessages !== ''undefined''
                && Object.keys(response.errorMessages).length > 0) {
                message += '': '' + JSON.stringify(response.errorMessages);
            }

            throw message + '' Check debug log for more information.'';
        }

        return {
            status: request.Status(),
            response: response
        };
    },

    getSchema: function() {
        var result = Jira.request(''get'', ''issue/createmeta?expand=projects.issuetypes.fields&projectKeys='' +
            encodeURIComponent(Jira.params.project_key) + ''&issuetypeNames='' +
            encodeURIComponent(Jira.params.issue_type));

        return result.response;
    },

    createIssue: function(summary, description, fields) {
        var data = {
            fields: {
                project: {
                    key: Jira.params.project_key
                },
                issuetype: {
                    name: Jira.params.issue_type
                },
                summary: summary,
                description: description
            }
        };

        if (Jira.labels && Jira.labels.length > 0) {
            data.fields.labels = Jira.labels;
        }
        var result = Jira.request(''post'', ''issue'', Jira.addCustomFields(data, fields));

        if (typeof result.response !== ''object'' || typeof result.response.key === ''undefined'') {
            throw ''Cannot create Jira issue. Check debug log for more information.'';
        }

        return result.response.key;
    },

    updateIssue: function(summary, fields, update) {
        var data = {fields: {}};

        if (summary) {
            data.fields.summary = summary;
        }

        Jira.request(''put'', ''issue/'' + encodeURIComponent(Jira.params.issue_key), Jira.addCustomFields(data, fields));
        Jira.commentIssue(update);
    },

    commentIssue: function(update) {
        var data = {};

        if (typeof update === ''string'') {
            data.body = update;
            Jira.request(''post'', ''issue/'' + encodeURIComponent(Jira.params.issue_key) + ''/comment'', data);
        }
        else if (update.status === ''1'') {
            data.body = update.user + '' '' + update.action + ''.'';

            if (update.message) {
                data.body += ''\\nMessage: {quote}'' + Jira.escapeMarkup(update.message) + ''{quote}'';
            }

            Jira.request(''post'', ''issue/'' + encodeURIComponent(Jira.params.issue_key) + ''/comment'', data);
        }
    }
};

try {
    var params = JSON.parse(value),
        fields = {},
        jira = {},
        update = {},
        result = {tags: {}},
        required_params = [''alert_subject'', ''summary'', ''event_recovery_value'', ''event_source'', ''event_value''];

    Object.keys(params)
        .forEach(function (key) {
            if (key.startsWith(''jira_'')) {
                jira[key.substring(5)] = params[key];
            }
            else if (key.startsWith(''customfield_'')) {
                fields[key] = params[key];
            }
            else if (key.startsWith(''event_update_'')) {
                update[key.substring(13)] = params[key];
            }
            else if (required_params.indexOf(key) !== -1 && params[key] === '''') {
                throw ''Parameter "'' + key + ''" can\\''t be empty.'';
            }
        });

    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {
        throw ''Incorrect "event_source" parameter given: '' + params.event_source + ''\\nMust be 0-3.'';
    }

    // Check {EVENT.VALUE} for trigger-based and internal events.
    if (params.event_value !== ''0'' && params.event_value !== ''1''
        && (params.event_source === ''0'' || params.event_source === ''3'')) {
        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\\nMust be 0 or 1.'';
    }

    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.
    if (params.event_update_status !== ''0'' && params.event_update_status !== ''1'' && params.event_source === ''0'') {
        throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''\\nMust be 0 or 1.'';
    }

    if (params.event_source !== ''0'' && params.event_recovery_value === ''0'') {
        throw ''Recovery operations are supported only for trigger-based actions.'';
    }

    Jira.setParams(jira);
    Jira.setProxy(params.HTTPProxy);
    Jira.setTags(params.event_tags_json);

    // Create issue for non trigger-based events.
    if (params.event_source !== ''0'' && params.event_recovery_value !== ''0'') {
        Jira.createIssue(params.alert_subject, params.alert_message);
    }
    // Create issue for trigger-based events.
    else if (params.event_value === ''1'' && update.status === ''0'' && !jira.issue_key.startsWith(jira.project_key)) {
        var key = Jira.createIssue(params.alert_subject,
            (Object.keys(fields).length ? params.trigger_description : params.alert_message), fields);


        result.tags.__zbx_jira_issuekey = key;
        result.tags.__zbx_jira_issuelink = params.jira_url +
            (params.jira_url.endsWith(''/'') ? '''' : ''/'') + ''browse/'' + key;
    }
    // Update created issue for trigger-based event.
    else {
        if (!jira.issue_key.startsWith(jira.project_key)) {
            throw ''Incorrect Issue key given: '' + jira.issue_key;
        }
        Jira.updateIssue(params.alert_subject, fields,
            ((params.event_value === ''0'' && !Object.keys(fields).length)
                ? params.alert_message : update));
    }

    return JSON.stringify(result);
}
catch (error) {
    Zabbix.Log(3, ''[ Jira Webhook ] ERROR: '' + error);
    throw ''Sending failed: '' + error;
}','30s','1','1','{EVENT.TAGS.__zbx_jira_issuelink}','Jira: {EVENT.TAGS.__zbx_jira_issuekey}','');
INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,status,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,exec_params,maxsessions,maxattempts,attempt_interval,content_type,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description) values ('13','4','Jira with CustomFields','','','','','','','','0','25','0','0','0','0','','1','3','10s','1',E'var Jira = {
    params: {},

    setParams: function (params) {
        if (typeof params !== ''object'') {
            return;
        }

        Jira.params = params;
        if (typeof Jira.params.url === ''string'') {
            if (!Jira.params.url.endsWith(''/'')) {
                Jira.params.url += ''/'';
            }

            Jira.params.url += ''rest/api/latest/'';
        }
    },

    setProxy: function (HTTPProxy) {
        Jira.HTTPProxy = HTTPProxy;
    },

    setTags: function(event_tags_json) {
        if (typeof event_tags_json !== ''undefined'' && event_tags_json !== ''''
            && event_tags_json !== ''{EVENT.TAGSJSON}'') {
            try {
                var tags = JSON.parse(event_tags_json),
                    label;

                Jira.labels = [];

                tags.forEach(function (tag) {
                    if (typeof tag.tag !== ''undefined'' && typeof tag.value !== ''undefined'' ) {
                        label = (tag.tag + (tag.value ? ('':'' + tag.value) : '''')).replace(/\\s/g, ''_'');
                        if (label.length < 256) {
                            Jira.labels.push(label);
                        }
                    }
                });
            }
            catch (error) {
                // Code is not missing here.
            }
        }
    },

    escapeMarkup: function (str) {
        var length = str.length,
            result = '''',
            markup = [''{'', ''|'', ''}'', ''~'', ''_'', ''\\\\'', ''['', '']'', ''^'', ''<'', ''>'', ''?'', ''!'', ''#'', ''+'', ''*'', ''&''];

        for (var i = 0; i < length; i++) {
            var char = str[i];

            result += (markup.indexOf(char) !== -1) ? (''&#'' + str[i].charCodeAt() + '';'') : char;
        }

        return result;
    },

    addCustomFields: function (data, fields) {
        if (typeof fields === ''object'' && Object.keys(fields).length) {
            var schema = Jira.getSchema(),
                path = [''projects'', 0, ''issuetypes'', 0, ''fields''],
                field;

            while ((field = path.shift()) !== undefined) {
                schema = schema[field];
                if (typeof schema === ''undefined'') {
                    schema = null;
                    break;
                }
            }

            if (schema) {
                Object.keys(fields)
                    .forEach(function(field) {
                        data.fields[field] = fields[field];

                        if (typeof schema[field] === ''object'' && typeof schema[field].schema === ''object''
                            && (schema[field].schema.type === ''number'' || schema[field].schema.type === ''datetime'')) {
                            switch (schema[field].schema.type) {
                                case ''number'':
                                    data.fields[field] = parseInt(fields[field]);
                                    break;

                                case ''datetime'':
                                    if (fields[field].match(/\\d+[.-]\\d+[.-]\\d+T\\d+:\\d+:\\d+/) !== null) {
                                        data.fields[field] = fields[field].replace(/\\./g, ''-'');
                                    }
                                    else {
                                        delete data.fields[field];
                                    }
                                    break;
                            }
                        }
                    });
            }
            else {
                Zabbix.Log(4, ''[ Jira Webhook ] Failed to retrieve field schema.'');
            }
        }

        return data;
    },

    request: function (method, query, data) {
        [''url'', ''user'', ''password'', ''project_key'', ''issue_type''].forEach(function (field) {
            if (typeof Jira.params !== ''object'' || typeof Jira.params[field] === ''undefined''
                || Jira.params[field] === '''' ) {
                throw ''Required Jira param is not set: "'' + field + ''".'';
            }
        });

        var response,
            url = Jira.params.url + query,
            request = new CurlHttpRequest();

        request.AddHeader(''Content-Type: application/json'');
        request.AddHeader(''Authorization: Basic '' + btoa(Jira.params.user + '':'' + Jira.params.password));

        if (typeof Jira.HTTPProxy !== ''undefined'' && Jira.HTTPProxy !== '''') {
            request.SetProxy(Jira.HTTPProxy);
        }

        if (typeof data !== ''undefined'') {
            data = JSON.stringify(data);
        }

        Zabbix.Log(4, ''[ Jira Webhook ] Sending request: '' + url + ((typeof data === ''string'') ? (''\\n'' + data) : ''''));

        switch (method) {
            case ''get'':
                response = request.Get(url, data);
                break;

            case ''post'':
                response = request.Post(url, data);
                break;

            case ''put'':
                response = request.Put(url, data);
                break;

            default:
                throw ''Unsupported HTTP request method: '' + method;
        }

        Zabbix.Log(4, ''[ Jira Webhook ] Received response with status code '' + request.Status() + ''\\n'' + response);

        if (response !== null) {
            try {
                response = JSON.parse(response);
            }
            catch (error) {
                Zabbix.Log(4, ''[ Jira Webhook ] Failed to parse response received from Jira'');
                response = null;
            }
        }

        if (request.Status() < 200 || request.Status() >= 300) {
            var message = ''Request failed with status code '' + request.Status();

            if (response !== null && typeof response.errors !== ''undefined''
                && Object.keys(response.errors).length > 0) {
                message += '': '' + JSON.stringify(response.errors);
            }
            else if (response !== null && typeof response.errorMessages !== ''undefined''
                && Object.keys(response.errorMessages).length > 0) {
                message += '': '' + JSON.stringify(response.errorMessages);
            }

            throw message + '' Check debug log for more information.'';
        }

        return {
            status: request.Status(),
            response: response
        };
    },

    getSchema: function() {
        var result = Jira.request(''get'', ''issue/createmeta?expand=projects.issuetypes.fields&projectKeys='' +
                Jira.params.project_key + ''&issuetypeNames='' + Jira.params.issue_type);

        return result.response;
    },

    createIssue: function(summary, description, fields) {
        var data = {
            fields: {
                project: {
                    key: Jira.params.project_key
                },
                issuetype: {
                    name: Jira.params.issue_type
                },
                summary: summary,
                description: description
            }
        };

        if (Jira.labels && Jira.labels.length > 0) {
            data.fields.labels = Jira.labels;
        }
        var result = Jira.request(''post'', ''issue'', Jira.addCustomFields(data, fields));

        if (typeof result.response !== ''object'' || typeof result.response.key === ''undefined'') {
            throw ''Cannot create Jira issue. Check debug log for more information.'';
        }

        return result.response.key;
    },

    updateIssue: function(summary, fields, update) {
        var data = {fields: {}};

        if (summary) {
            data.fields.summary = summary;
        }

        Jira.request(''put'', ''issue/'' + Jira.params.issue_key, Jira.addCustomFields(data, fields));
        Jira.commentIssue(update);
    },

    commentIssue: function(update) {
        var data = {};

        if (typeof update === ''string'') {
            data.body = update;
            Jira.request(''post'', ''issue/'' + Jira.params.issue_key + ''/comment'', data);
        }
        else if (update.status === ''1'') {
            data.body = update.user + '' '' + update.action + ''.'';

            if (update.message) {
                data.body += ''\\nMessage: {quote}'' + Jira.escapeMarkup(update.message) + ''{quote}'';
            }

            Jira.request(''post'', ''issue/'' + Jira.params.issue_key + ''/comment'', data);
        }
    }
};

try {
    var params = JSON.parse(value),
        fields = {},
        jira = {},
        update = {},
        result = {tags: {}},
        required_params = [''alert_subject'', ''summary'', ''event_recovery_value'', ''event_source'', ''event_value''];

    Object.keys(params)
        .forEach(function (key) {
            if (key.startsWith(''jira_'')) {
                jira[key.substring(5)] = params[key];
            }
            else if (key.startsWith(''customfield_'')) {
                fields[key] = params[key];
            }
            else if (key.startsWith(''event_update_'')) {
                update[key.substring(13)] = params[key];
            }
            else if (required_params.indexOf(key) !== -1 && params[key] === '''') {
                throw ''Parameter "'' + key + ''" can\\''t be empty.'';
            }
        });

    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {
        throw ''Incorrect "event_source" parameter given: '' + params.event_source + ''\\nMust be 0-3.'';
    }

    // Check {EVENT.VALUE} for trigger-based and internal events.
    if (params.event_value !== ''0'' && params.event_value !== ''1''
        && (params.event_source === ''0'' || params.event_source === ''3'')) {
        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\\nMust be 0 or 1.'';
    }

    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.
    if (params.event_update_status !== ''0'' && params.event_update_status !== ''1'' && params.event_source === ''0'') {
        throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''\\nMust be 0 or 1.'';
    }

    if (params.event_source !== ''0'' && params.event_recovery_value === ''0'') {
        throw ''Recovery operations are supported only for trigger-based actions.'';
    }

    Jira.setParams(jira);
    Jira.setProxy(params.HTTPProxy);
    Jira.setTags(params.event_tags_json);

    // Create issue for non trigger-based events.
    if (params.event_source !== ''0'' && params.event_recovery_value !== ''0'') {
        Jira.createIssue(params.alert_subject, params.alert_message);
    }
    // Create issue for trigger-based events.
    else if (params.event_value === ''1'' && update.status === ''0'' && !jira.issue_key.startsWith(jira.project_key)) {
        var key = Jira.createIssue(params.alert_subject,
            (Object.keys(fields).length ? params.trigger_description : params.alert_message), fields);


        result.tags.__zbx_jira_issuekey = key;
        result.tags.__zbx_jira_issuelink = params.jira_url +
            (params.jira_url.endsWith(''/'') ? '''' : ''/'') + ''browse/'' + key;
    }
    // Update created issue for trigger-based event.
    else {
        if (!jira.issue_key.startsWith(jira.project_key)) {
            throw ''Incorrect Issue key given: '' + jira.issue_key;
        }
        Jira.updateIssue(params.alert_subject, fields,
            ((params.event_value === ''0'' && !Object.keys(fields).length)
                ? params.alert_message : update));
    }

    return JSON.stringify(result);
}
catch (error) {
    Zabbix.Log(3, ''[ Jira Webhook ] ERROR: '' + error);
    throw ''Sending failed: '' + error;
}','30s','1','1','{EVENT.TAGS.__zbx_jira_issuelink}','Jira: {EVENT.TAGS.__zbx_jira_issuekey}','');
INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,status,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,exec_params,maxsessions,maxattempts,attempt_interval,content_type,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description) values ('14','4','MS Teams','','','','','','','','0','25','0','0','0','0','','1','3','10s','1',E'var SEVERITY_COLORS = [
    ''#97AAB3'', // Not classified.
    ''#7499FF'', // Information.
    ''#FFC859'', // Warning.
    ''#FFA059'', // Average.
    ''#E97659'', // High.
    ''#E45959'', // Disaster.
    ''#009900'', // Resolved.
    ''#000000''  // Default.
];

try {
    var params = JSON.parse(value);

    if (!params.teams_endpoint) {
        throw ''Cannot get teams_endpoint'';
    }
    else if (!params.teams_endpoint.startsWith(''https://outlook.office.com/webhook/'')) {
        throw ''Invalid MS Teams webhook URL: '' + params.teams_endpoint;
    }

    params.zabbix_url = (params.zabbix_url.endsWith(''/''))
        ? params.zabbix_url.slice(0, -1) : params.zabbix_url;

    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {
        throw ''Incorrect "event_source" parameter given: "'' + params.event_source + ''".\\nMust be 0-3.'';
    }

    // Set "use_default_message" to true for non trigger-based events.
    if (params.event_source !== ''0'') {
        params.use_default_message = ''true'';
    }

    // Check {EVENT.VALUE} for trigger-based and internal events.
    if (params.event_value !== ''0'' && params.event_value !== ''1''
        && (params.event_source === ''0'' || params.event_source === ''3'')) {
        throw ''Incorrect "event_value" parameter given: "'' + params.event_value + ''".\\nMust be 0 or 1.'';
    }

    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.
    if (params.event_update_status !== ''0'' && params.event_update_status !== ''1'' && params.event_source === ''0'') {
        throw ''Incorrect "event_update_status" parameter given: "'' + params.event_update_status + ''".\\nMust be 0 or 1.'';
    }

    if (params.event_value == 0) {
        params.event_nseverity = ''6'';
    }

    if (!SEVERITY_COLORS[params.event_nseverity]) {
        params.event_nseverity = ''7'';
    }

    var request = new CurlHttpRequest(),
        facts = [],
        body = {
            themeColor: SEVERITY_COLORS[params.event_nseverity].replace(''#'', ''''),
            summary: ''Zabbix'',
            sections: [
                {
                    markdown: ''false'',
                    activityTitle: params.alert_subject,
                    activitySubtitle: ''On '' + params.host_name + '' ['' + params.host_ip + '']'',
                    text: (params.use_default_message.toLowerCase() == ''true'')
                        ? params.alert_message
                        : params.trigger_description
                }
            ],
            potentialAction: [
                {
                    ''@type'': ''OpenUri'',
                    name: (params.event_source === ''0'')
                        ? ''Event Info''
                        : ''Zabbix Home'',
                    targets: [
                        {
                            os: ''default'',
                            uri: (params.event_source === ''0'')
                                ? params.zabbix_url + ''/tr_events.php?triggerid='' +
                                    params.trigger_id + ''&eventid='' + params.event_id
                                : params.zabbix_url
                        }
                    ]
                }
            ]
        };

    if (params.use_default_message.toLowerCase() !== ''true'') {
        // Problem message.
        if (params.event_value === ''1'' && params.event_update_status === ''0'') {
            facts.push({
                name: ''Event time'',
                value: params.event_time + '' '' + params.event_date
            });
        }
        // Update message.
        else if (params.event_update_status === ''1'') {
            body.sections[0].text = params.event_update_user + '' '' + params.event_update_action + ''.'';

            if (params.event_update_message) {
                body.sections[0].text += ''<br>Message:<br>'' + params.event_update_message;
            }

            facts.push({
                name: ''Event update time'',
                value: params.event_update_time + '' '' + params.event_update_date
            });
        }
        // Resolved message.
        else {
            facts.push({
                name: ''Recovery time'',
                value: params.event_recovery_time + '' '' + params.event_recovery_date
            });
        }

        if (params.event_severity && params.event_severity !== ''{EVENT.SEVERITY}'') {
            facts.push({
                name: ''Severity'',
                value: params.event_severity
            });
        }


        if (params.event_opdata && params.event_opdata !== ''{EVENT.OPDATA}'') {
            facts.push({
                name: ''Operational data'',
                value: params.event_opdata
            });
        }

        if (params.event_tags && params.event_tags !== ''{EVENT.TAGS}'') {
            facts.push({
                name: ''Event tags'',
                value: params.event_tags
            });
        }

        Object.keys(params)
            .forEach(function (key) {
                if (key.startsWith(''fact_'') && params[key] !== '''') {
                    facts.push({
                        name: key.substring(5),
                        value: params[key]
                    });
                }
                else if (key.startsWith(''openUri_'') && params[key] !== '''' && !params[key].startsWith(''{'')) {
                    body.potentialAction.push({
                        ''@type'': ''OpenUri'',
                        name: key.substring(8),
                        targets: [
                            {
                                os: ''default'',
                                uri: params[key]
                            }
                        ]
                    });
                }
            });
        body.sections[0].facts = facts;
    }

    body.sections[0].text = body.sections[0].text.replace(/(?:\\r\\n|\\r|\\n)/g, ''<br>'');

    request.AddHeader(''Content-Type: application/json'');

    if (typeof params.HTTPProxy === ''string'' && params.HTTPProxy !== '''') {
        request.SetProxy(params.HTTPProxy);
    }

    Zabbix.Log(4, ''[ MS Teams Webhook ] JSON: '' + JSON.stringify(body));

    var response = request.Post(params.teams_endpoint, JSON.stringify(body));

    Zabbix.Log(4, ''[ MS Teams Webhook ] Response: '' + response);

    if (response === ''1'') {
        return ''OK'';
    }
    else {
        Zabbix.Log(4, ''[ MS Teams Webhook ] FAILED with response: '' + response);
        throw response;
    }
}
catch (error) {
    Zabbix.Log(3, ''[ MS Teams Webhook ] ERROR: '' + error);
    throw ''Sending failed: '' + error;
}','30s','0','0','','','');
INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,status,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,exec_params,maxsessions,maxattempts,attempt_interval,content_type,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description) values ('15','4','Redmine','','','','','','','','0','25','0','0','0','0','','1','3','10s','1',E'var Redmine = {
    params: {},

    setParams: function (params) {
        if (typeof params !== ''object'') {
            return;
        }

        Redmine.params = params;
        if (typeof Redmine.params.url === ''string'') {
            if (!Redmine.params.url.endsWith(''/'')) {
                Redmine.params.url += ''/'';
            }
        }
    },

    addCustomFields: function (data, fields) {
        if (typeof fields === ''object'' && Object.keys(fields).length) {
            var schema = Redmine.getSchema();

            if (schema) {
                data.issue.custom_fields = [];

                Object.keys(fields)
                    .forEach(function(field) {
                        for (var idx in schema.custom_fields) {
                            if (schema.custom_fields[idx].id != field) {
                                continue;
                            }

                            var field_value;

                            switch (schema.custom_fields[idx].field_format) {
                                case ''string'':
                                    field_value = fields[field];
                                    break;

                                case ''int'':
                                    field_value = parseInt(fields[field]);
                                    break;

                                case ''float'':
                                    field_value = parseFloat(fields[field]);
                                    break;

                                case ''date'':
                                    if (fields[field].match(/^\\d{4}[.-]\\d{2}[.-]\\d{2}$/)) {
                                        field_value = fields[field].replace(/\\./g, ''-'');
                                    }
                                    break;
                            }

                            if (field_value !== undefined) {
                                data.issue.custom_fields.push({id: field, value: field_value});
                            }
                        }
                    });
            }
            else {
                Zabbix.Log(4, ''[ Redmine Webhook ] Failed to retrieve field schema.'');
            }
        }

        return data;
    },

    request: function (method, query, data) {
        [''url'', ''access_key''].forEach(function (field) {
            if (typeof Redmine.params !== ''object'' || typeof Redmine.params[field] === ''undefined''
                || Redmine.params[field] === '''' ) {
                throw ''Required param is not set: "'' + field + ''".'';
            }
        });

        var response,
            url = Redmine.params.url + query,
            request = new CurlHttpRequest();

        if (typeof Redmine.HTTPProxy === ''string'' && Redmine.HTTPProxy.trim() !== '''') {
            request.SetProxy(Redmine.HTTPProxy);
        }

        request.AddHeader(''Content-Type: application/json'');
        request.AddHeader(''X-Redmine-API-Key: '' + Redmine.params.access_key);

        if (typeof data !== ''undefined'') {
            data = JSON.stringify(data);
        }

        Zabbix.Log(4, ''[ Redmine Webhook ] Sending request: '' +
            url + ((typeof data === ''string'') ? ('' '' + data) : ''''));

        switch (method) {
            case ''get'':
                response = request.Get(url, data);
                break;

            case ''post'':
                response = request.Post(url, data);
                break;

            case ''put'':
                response = request.Put(url, data);
                break;

            default:
                throw ''Unsupported HTTP request method: '' + method;
        }

        Zabbix.Log(4, ''[ Redmine Webhook ] Received response with status code '' + request.Status() + '': '' + response);

        if (response !== null) {
            try {
                response = JSON.parse(response);
            }
            catch (error) {
                Zabbix.Log(4, ''[ Redmine Webhook ] Failed to parse response received from Redmine'');
                response = null;
            }
        }

        if (request.Status() < 200 || request.Status() >= 300) {
            var message = ''Request failed with status code '' + request.Status();

            if (response !== null && typeof response.errors !== ''undefined''
                && Object.keys(response.errors).length > 0) {
                message += '': '' + JSON.stringify(response.errors);
            }
            else if (response !== null && typeof response.errorMessages !== ''undefined''
                && Object.keys(response.errorMessages).length > 0) {
                message += '': '' + JSON.stringify(response.errorMessages);
            }

            throw message + '' Check debug log for more information.'';
        }

        return {
            status: request.Status(),
            response: response
        };
    },

    getProjectID: function(name) {
        var result = Redmine.request(''get'', ''projects.json''),
            project_id;

        if (result.response) {
            var projects = result.response.projects || [];

            for (var i in projects) {
                if (projects[i].name === name) {
                    project_id = projects[i].id;
                    break;
                }
            }
        }
        else {
            Zabbix.Log(4, ''[ Redmine Webhook ] Failed to retrieve project data.'');
        }

        if (typeof project_id === ''undefined'') {
            throw ''Cannot find project with name: '' + name;
        }

        return project_id;
    },

    getSchema: function() {
        var result = Redmine.request(''get'', ''custom_fields.json'');

        return result.response;
    },

    createIssue: function(subject, description, priority, fields) {
        var project_id = /^\\d+$/.test(Redmine.params.project)
                ? Redmine.params.project
                : Redmine.getProjectID(Redmine.params.project),
            data = {
                issue: {
                    project_id: project_id,
                    tracker_id: Redmine.params.tracker_id,
                    subject: subject,
                    description: description
                }
            },
            result;

        if (priority) {
            data.issue.priority_id = priority;
        }

        result = Redmine.request(''post'', ''issues.json'', Redmine.addCustomFields(data, fields));

        if (typeof result.response !== ''object''
            || typeof result.response.issue.id === ''undefined''
            || result.status != 201) {
            throw ''Cannot create Redmine issue. Check debug log for more information.'';
        }

        return result.response.issue.id;
    },

    updateIssue: function(note, fields) {
        var data = {
            issue: {
                notes: note || ''''
            }
        };

        Redmine.request(''put'', ''issues/'' + Redmine.params.issue_key + ''.json'', Redmine.addCustomFields(data, fields));
    }
};

try {
    var params = JSON.parse(value),
        params_redmine = {},
        params_fields = {},
        params_update = {},
        result = {tags: {}},
        required_params = [
            ''alert_subject'', ''tracker_id'', ''project'',
            ''event_source'', ''event_value'',  ''event_update_status''
        ],
        severities = [
            {name: ''not_classified'', color: ''#97AAB3''},
            {name: ''information'', color: ''#7499FF''},
            {name: ''warning'', color: ''#FFC859''},
            {name: ''average'', color: ''#FFA059''},
            {name: ''high'', color: ''#E97659''},
            {name: ''disaster'', color: ''#E45959''},
            {name: ''resolved'', color: ''#009900''},
            {name: null, color: ''#000000''}
        ],
        priority;

    Object.keys(params)
        .forEach(function (key) {
            if (key.startsWith(''redmine_'')) {
                params_redmine[key.substring(8)] = params[key];
            }
            else if (key.startsWith(''customfield_'')) {
                params_fields[key.substring(12)] = params[key];
            }
            else if (key.startsWith(''event_update_'')) {
                params_update[key.substring(13)] = params[key];
            }
            else if (required_params.indexOf(key) !== -1 && params[key].trim() === '''') {
                throw ''Parameter "'' + key + ''" cannot be empty.'';
            }
        });

    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {
        throw ''Incorrect "event_source" parameter given: '' + params.event_source + ''\\nMust be 0-3.'';
    }

    // Check {EVENT.VALUE} for trigger-based and internal events.
    if (params.event_value !== ''0'' && params.event_value !== ''1''
        && (params.event_source === ''0'' || params.event_source === ''3'')) {
        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\\nMust be 0 or 1.'';
    }

    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.
    if (params.event_source === ''0'' && params.event_update_status !== ''0'' && params.event_update_status !== ''1'') {
        throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''\\nMust be 0 or 1.'';
    }

    if (params.event_source !== ''0'' && params.event_value === ''0'') {
        throw ''Recovery operations are supported only for trigger-based actions.'';
    }

    if (params.event_source === ''0''
        && ((params.event_value === ''1'' && params.event_update_status === ''1'')
            || (params.event_value === ''0''
                && (params.event_update_status === ''0'' || params.event_update_status === ''1'')))
        && (isNaN(parseInt(params.redmine_issue_key)) || parseInt(params.redmine_issue_key) < 1 )) {
        throw ''Incorrect "redmine_issue_key" parameter given: '' + params.redmine_issue_key +
            ''\\nMust be positive integer.'';
    }

    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {
        params.event_nseverity = ''7'';
    }

    if (params.event_value === ''0'') {
        params.event_nseverity = ''6'';
    }

    priority = params[''severity_'' + severities[params.event_nseverity].name];
    priority = priority && priority.trim() || severities[7].name;

    Redmine.setParams(params_redmine);
    Redmine.HTTPProxy = params.HTTPProxy;

    // Create issue for non trigger-based events.
    if (params.event_source !== ''0''
        && params.event_value !== ''0'') {
        Redmine.createIssue(params.alert_subject, params.alert_message, priority);
    }
    // Create issue for trigger-based events.
    else if (params.event_value === ''1'' && params_update.status === ''0'') {
        var issue_id = Redmine.createIssue(params.alert_subject,
            params.alert_subject + ''\\n'' + params.alert_message + ''\\n'' +
            params.zabbix_url + (params.zabbix_url.endsWith(''/'') ? '''' : ''/'') +
            ''tr_events.php?triggerid='' + params.trigger_id + ''&eventid='' + params.event_id + ''\\n'',
            priority,
            params_fields);

        result.tags.__zbx_redmine_issue_id = issue_id;
        result.tags.__zbx_redmine_issuelink = params.redmine_url +
            (params.redmine_url.endsWith(''/'') ? '''' : ''/'') + ''issues/'' + issue_id;
    }
    // Update created issue for trigger-based event.
    else {
        Redmine.updateIssue(params.alert_subject + ''\\n'' + params.alert_message, params_fields);
    }

    return JSON.stringify(result);
}
catch (error) {
    Zabbix.Log(3, ''[ Redmine Webhook ] ERROR: '' + error);
    throw ''Sending failed: '' + error;
}','30s','1','1','{EVENT.TAGS.__zbx_redmine_issuelink}','Redmine: issue #{EVENT.TAGS.__zbx_redmine_issue_id}','');
INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,status,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,exec_params,maxsessions,maxattempts,attempt_interval,content_type,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description) values ('16','4','Telegram','','','','','','','','0','25','0','0','0','0','','1','3','10s','1',E'var Telegram = {
    token: null,
    to: null,
    message: null,
    proxy: null,
    parse_mode: null,

    sendMessage: function() {
        var params = {
            chat_id: Telegram.to,
            text: Telegram.message,
            disable_web_page_preview: true,
            disable_notification: false
        },
        data,
        response,
        request = new CurlHttpRequest(),
        url = ''https://api.telegram.org/bot'' + Telegram.token + ''/sendMessage'';

        if (Telegram.parse_mode !== null) {
            params[''parse_mode''] = Telegram.parse_mode;
        }

        if (Telegram.proxy) {
            request.SetProxy(Telegram.proxy);
        }

        request.AddHeader(''Content-Type: application/json'');
        data = JSON.stringify(params);

        // Remove replace() function if you want to see the exposed token in the log file.
        Zabbix.Log(4, ''[Telegram Webhook] URL: '' + url.replace(Telegram.token, ''<TOKEN>''));
        Zabbix.Log(4, ''[Telegram Webhook] params: '' + data);
        response = request.Post(url, data);
        Zabbix.Log(4, ''[Telegram Webhook] HTTP code: '' + request.Status());

        try {
            response = JSON.parse(response);
        }
        catch (error) {
            response = null;
        }

        if (request.Status() !== 200 || typeof response.ok !== ''boolean'' || response.ok !== true) {
            if (typeof response.description === ''string'') {
                throw response.description;
            }
            else {
                throw ''Unknown error. Check debug log for more information.''
            }
        }
    }
}

try {
    var params = JSON.parse(value);

    if (typeof params.Token === ''undefined'') {
        throw ''Incorrect value is given for parameter "Token": parameter is missing'';
    }

    Telegram.token = params.Token;

    if (params.HTTPProxy) {
        Telegram.proxy = params.HTTPProxy;
    } 

    if ([''Markdown'', ''HTML'', ''MarkdownV2''].indexOf(params.ParseMode) !== -1) {
        Telegram.parse_mode = params.ParseMode;
    }

    Telegram.to = params.To;
    Telegram.message = params.Subject + ''\\n'' + params.Message;
    Telegram.sendMessage();

    return ''OK'';
}
catch (error) {
    Zabbix.Log(4, ''[Telegram Webhook] notification failed: '' + error);
    throw ''Sending failed: '' + error + ''.'';
}','10s','0','0','','','https://git.zabbix.com/projects/ZBX/repos/zabbix/browse/templates/media/telegram

1. Register bot: send "/newbot" to @BotFather and follow instructions
2. Copy and paste the obtained token into the "Token" field above
3. If you want to send personal notifications, you need to get chat id of the user you want to send messages to:
    3.1. Send "/getid" to "@myidbot" in Telegram messenger
    3.2. Copy returned chat id and save it in the "Telegram Webhook" media for the user
    3.3. Ask the user to send "/start" to your bot (Telegram bot won''t send anything to the user without it)
4. If you want to send group notifications, you need to get group id of the group you want to send messages to:
    4.1. Add "@myidbot" to your group
    4.2. Send "/getgroupid@myidbot" in your group
    4.3. Copy returned group id save it in the "Telegram Webhook" media for the user you created for  group notifications
    4.4. Send "/start@your_bot_name_here" in your group (Telegram bot won''t send anything to the group without it)');
INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,status,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,exec_params,maxsessions,maxattempts,attempt_interval,content_type,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description) values ('17','4','Zendesk','','','','','','','','0','25','0','0','0','0','','1','3','10s','1',E'var Zendesk = {
    params: {},

    setParams: function (params) {
        if (typeof params !== ''object'') {
            return;
        }

        Zendesk.params = params;
        if (typeof Zendesk.params.url === ''string'') {
            if (!Zendesk.params.url.endsWith(''/'')) {
                Zendesk.params.url += ''/'';
            }
            Zendesk.params.url += ''api/v2/'';
        }
    },

    addCustomFields: function (data, fields) {
        if (typeof fields === ''object'' && Object.keys(fields).length) {
            var schema = Zendesk.getSchema(),
                arr = [],
                i,
                n;

            if (schema) {
                Object.keys(fields)
                    .forEach(function(field) {
                        for (i = 0, n = schema.ticket_fields.length; i < n; i++) {
                            if (schema.ticket_fields[i].id == field
                                && [''text'', ''integer'', ''date''].indexOf(schema.ticket_fields[i].type) !== -1){

                                switch (schema.ticket_fields[i].type) {
                                    case ''integer'':
                                        fields[field] = parseInt(fields[field]);
                                        break;
                                    case ''date'':
                                        if (fields[field].match(/^\\d{4}[.-]\\d{2}[.-]\\d{2}$/) !== null) {
                                            fields[field] = fields[field].replace(/\\./g, ''-'');
                                        }
                                        else {
                                            fields[field] = '''';
                                        }
                                        break;
                                }

                                arr.push({id: field, value: fields[field]});
                                break;
                            }
                        }
                    });

                if (arr.length) {
                    data.ticket[''custom_fields''] = arr;
                }
            }
            else {
                Zabbix.Log(4, ''[Zendesk Webhook] Failed to retrieve field schema.'');
            }
        }

        return data;
    },

    request: function (method, query, data) {
        [''url'', ''token'', ''type''].forEach(function (field) {
            if (typeof Zendesk.params !== ''object'' || typeof Zendesk.params[field] === ''undefined'') {
                throw ''Required Zendesk param is not set: '' + field + ''\\n'' + Zendesk.params[field];
            }
        });

        var response,
            url = Zendesk.params.url + query,
            request = new CurlHttpRequest();

        if (typeof Zendesk.HTTPProxy === ''string'' && Zendesk.HTTPProxy.trim() !== '''') {
            request.SetProxy(Zendesk.HTTPProxy);
        }

        request.AddHeader(''Content-Type: application/json'');
        request.AddHeader(''Authorization: Basic '' + btoa(Zendesk.params.token));

        if (typeof data !== ''undefined'') {
            data = JSON.stringify(data);
        }

        Zabbix.Log(4, ''[Zendesk Webhook] Sending request: '' + url + ((typeof data === ''string'') ? ('' '' + data) : ''''));

        switch (method) {
            case ''get'':
                response = request.Get(url, data);
                break;

            case ''post'':
                response = request.Post(url, data);
                break;

            case ''put'':
                response = request.Put(url, data);
                break;

            default:
                throw ''Unsupported HTTP request method: '' + method;
        }

        Zabbix.Log(4, ''[Zendesk Webhook] Received response with status code '' + request.Status() + ''. '' + response);

        if (response !== null) {
            try {
                response = JSON.parse(response);
            }
            catch (error) {
                Zabbix.Log(4, ''[Zendesk Webhook] Failed to parse response received from Zendesk.'');
            }
        }

        if (request.Status() < 200 || request.Status() >= 300) {
            var message = ''Request failed with status code '' + request.Status();

            if (response !== null && typeof response.error !== ''undefined''
                && Object.keys(response.error).length > 0) {
                message += '': '' + JSON.stringify(response.error);
            }
            else if (response !== null && typeof response.description !== ''undefined''
                && Object.keys(response.description).length > 0) {
                message += '': '' + JSON.stringify(response.description);
            }
            else {
                message += ''. '' + response;
            }
            throw message + ''. Check debug log for more information.'';
        }

        return {
            status: request.Status(),
            response: response
        };
    },

    getSchema: function() {
        var result = Zendesk.request(''get'', ''ticket_fields.json'');

        return result.response;
    },

    createIssue: function(data, fields) {
        var result = Zendesk.request(''post'', ''tickets.json'', Zendesk.addCustomFields(data, fields));

        if (typeof result.response !== ''object'' || typeof result.response.ticket.id === ''undefined''
            || result.status != 201) {
            throw ''Cannot create Zendesk issue. Check debug log for more information.'';
        }

        return result.response.ticket.id;
    },

    updateIssue: function(data, fields) {
        Zendesk.request(''put'', ''tickets/'' + Zendesk.params.issue_key + ''.json'', Zendesk.addCustomFields(data, fields));
    }
};

try {
    var params = JSON.parse(value),
        fields = {},
        zendesk = {},
        update = {},
        data = {},
        result = {tags: {}},
        required_params = [
            ''alert_subject'',
            ''alert_message'',
            ''event_id'',
            ''event_source'',
            ''event_value'',
            ''event_update_status''
        ],
        severities = [
            {name: ''not_classified'', color: ''#97AAB3''},
            {name: ''information'', color: ''#7499FF''},
            {name: ''warning'', color: ''#FFC859''},
            {name: ''average'', color: ''#FFA059''},
            {name: ''high'', color: ''#E97659''},
            {name: ''disaster'', color: ''#E45959''},
            {name: ''resolved'', color: ''#009900''},
            {name: ''default'', color: ''#000000''}
        ],
        priority;

    Object.keys(params)
        .forEach(function (key) {
            if (key.startsWith(''zendesk_'')) {
                zendesk[key.substring(8)] = params[key];
            }
            else if (key.startsWith(''customfield_'')) {
                fields[key.substring(12)] = params[key];
            }
            else if (key.startsWith(''event_update_'')) {
                update[key.substring(13)] = params[key];
            }
            else if (required_params.indexOf(key) !== -1 && params[key].trim() === '''') {
                throw ''Parameter '' + key + '' cannot be empty.'';
            }
        });

    // Possible values: question, incident, problems, task
    if ([''question'', ''incident'', ''problem'', ''task''].indexOf(params.zendesk_type) === -1) {
        throw ''Incorrect "zendesk_type" parameter given: '' + params.zendesk_type +
            ''\\nMust be one of question, incident, problem, task.'';
    }

    // Possible values: 0 - Trigger, 1 - Discovery, 2 - Autoregistration, 3 - Internal.
    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {
        throw ''Incorrect "event_source" parameter given: '' + params.event_source + ''\\nMust be 0-3.'';
    }

    // Check {EVENT.VALUE} for trigger-based and internal events.
    // Possible values: 1 for problem, 0 for recovering
    if (params.event_value !== ''0'' && params.event_value !== ''1''
        && (params.event_source === ''0'' || params.event_source === ''3'')) {
        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\\nMust be 0 or 1.'';
    }

    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.
    // Possible values: 0 - Webhook was called because of problem/recovery event, 1 - Update operation.
    if (params.event_source === ''0'' && params.event_update_status !== ''0'' && params.event_update_status !== ''1'') {
        throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''\\nMust be 0 or 1.'';
    }

    if (params.event_source !== ''0'' && params.event_value === ''0'') {
        throw ''Recovery operations are supported only for trigger-based actions.'';
    }

    // Zendesk_issue_key must be a positive integer if an update action is being performed.
    if (params.event_source === ''0'' && ((params.event_value === ''1'' && params.event_update_status === ''1'')
        || (params.event_value === ''0'' && (params.event_update_status === ''0'' || params.event_update_status === ''1'')))
        && (isNaN(parseInt(params.zendesk_issue_key)) || parseInt(params.zendesk_issue_key) < 1 )) {
        throw ''Incorrect "zendesk_issue_key" parameter given: '' + params.zendesk_issue_key +
            ''\\nMust be positive integer.'';
    }

    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {
        params.event_nseverity = ''7'';
    }

    if (params.event_value === ''0'') {
        params.event_nseverity = ''6'';
    }

    priority = params[''severity_'' + severities[params.event_nseverity].name] || severities[7].name;

    Zendesk.setParams(zendesk);
    Zendesk.HTTPProxy = params.HTTPProxy;

    // Create issue for non trigger-based events.
    if (params.event_source !== ''0'' && params.event_value !== ''0'') {
        data = {
            ticket: {
                external_id: params.event_id,
                type: Zendesk.params.type,
                status: ''new'',
                subject: params.alert_subject,
                comment: {
                    body: params.alert_message,
                    public: ''false''
                },
                priority: priority,
                tags: params.event_tags
            }
        };

        Zendesk.createIssue(data, fields);
    }
    // Create issue for trigger-based events.
    else if (params.event_value === ''1'' && update.status === ''0'') {
        data = {
            ticket: {
                external_id: params.event_id,
                type: Zendesk.params.type,
                status: ''new'',
                subject: params.alert_subject,
                comment: {
                    body: params.zbxurl + (params.zbxurl.endsWith(''/'') ? '''' : ''/'') + ''tr_events.php?triggerid='' +
                        params.trigger_id + ''&eventid='' + params.event_id + ''\\n'' + params.alert_message,
                    public: ''false''
                },
                priority: priority,
                tags: params.event_tags
            }
        };
        var key = Zendesk.createIssue(data, fields);

        result.tags.__zbx_zdk_issuekey = key;
        result.tags.__zbx_zdk_issuelink = params.zendesk_url +
            (params.zendesk_url.endsWith(''/'') ? '''' : ''/'') + ''agent/tickets/'' + key;
    }
    // Update created issue for trigger-based event.
    else {
        data = {
            ticket: {
                type: Zendesk.params.type,
                subject: params.alert_subject,
                comment: {
                    body: params.alert_message,
                    public: ''false''
                }
            }
        };

        Zendesk.updateIssue(data, fields);
    }

    return JSON.stringify(result);
}
catch (error) {
    Zabbix.Log(3, ''[Zendesk Webhook] ERROR: '' + error);
    throw ''Sending failed: '' + error;
}','30s','1','1','{EVENT.TAGS.__zbx_zdk_issuelink}','Zendesk: {EVENT.TAGS.__zbx_zdk_issuekey}','');
INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,status,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,exec_params,maxsessions,maxattempts,attempt_interval,content_type,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description) values ('18','4','ServiceNow','','','','','','','','0','25','0','0','0','0','','1','3','10s','1',E'var ServiceNow = {
    params: {},

    setParams: function (params) {
        if (typeof params !== ''object'') {
            return;
        }

        ServiceNow.params = params;
        if (typeof ServiceNow.params.url === ''string'') {
            if (!ServiceNow.params.url.endsWith(''/'')) {
                ServiceNow.params.url += ''/'';
            }

            ServiceNow.params.url += ''api/now/table/incident'';
        }
    },

    setProxy: function (HTTPProxy) {
        ServiceNow.HTTPProxy = HTTPProxy;
    },

    setFields: function (data, fields) {
        if (typeof fields === ''object'' && Object.keys(fields).length) {
            Object.keys(fields)
                .forEach(function(field) {
                    data[field] = (fields[field].match(/^\\d{4}\\.\\d{2}\\.\\d{2}$/) !== null)
                        ? fields[field].replace(/\\./g, ''-'')
                        : fields[field];
                });
        }
    },

    request: function (method, data) {
        [''url'', ''user'', ''password''].forEach(function (field) {
            if (typeof ServiceNow.params !== ''object'' || typeof ServiceNow.params[field] === ''undefined''
                || ServiceNow.params[field] === '''' ) {
                throw ''Required ServiceNow param is not set: "'' + field + ''".'';
            }
        });

        var response,
            url = ServiceNow.params.url,
            request = new CurlHttpRequest();

        request.AddHeader(''Content-Type: application/json'');
        request.AddHeader(''Authorization: Basic '' + btoa(ServiceNow.params.user + '':'' + ServiceNow.params.password));

        if (typeof ServiceNow.HTTPProxy !== ''undefined'' && ServiceNow.HTTPProxy !== '''') {
            request.SetProxy(ServiceNow.HTTPProxy);
        }

        if (typeof data !== ''undefined'') {
            data = JSON.stringify(data);
        }

        Zabbix.Log(4, ''[ ServiceNow Webhook ] Sending request: '' + url + ((typeof data === ''string'')
            ? (''\\n'' + data)
            : ''''));

        switch (method) {
            case ''get'':
                response = request.Get(url, data);
                break;

            case ''post'':
                response = request.Post(url, data);
                break;

            case ''put'':
                response = request.Put(url, data);
                break;

            default:
                throw ''Unsupported HTTP request method: '' + method;
        }

        Zabbix.Log(4, ''[ ServiceNow Webhook ] Received response with status code '' +
            request.Status() + ''\\n'' + response);

        if (response !== null) {
            try {
                response = JSON.parse(response);
            }
            catch (error) {
                Zabbix.Log(4, ''[ ServiceNow Webhook ] Failed to parse response received from ServiceNow'');
                response = null;
            }
        }

        if (request.Status() < 200 || request.Status() >= 300) {
            var message = ''Request failed with status code '' + request.Status();

            if (response !== null && typeof response.error.message !== ''undefined''
                && Object.keys(response.error).length > 0) {
                message += '': '' + JSON.stringify(response.error.message);
            }

            throw message + '' Check debug log for more information.'';
        }
        else if (typeof response.result !== ''object'' || typeof response.result.sys_id === ''undefined'') {
            throw ''Cannot create ServiceNow incident. Check debug log for more information.'';
        }

        return response.result;
    }
};

try {
    var params = JSON.parse(value),
        fields = {},
        servicenow = {},
        data = {},
        result = {tags: {}},
        required_params = [
            ''alert_subject'', ''alert_message'', ''event_source'', ''event_value'',
            ''event_update_status'', ''event_recovery_value'', ''event_nseverity''
        ],
        severities = [
            {name: ''not_classified'', color: ''#97AAB3''},
            {name: ''information'', color: ''#7499FF''},
            {name: ''warning'', color: ''#FFC859''},
            {name: ''average'', color: ''#FFA059''},
            {name: ''high'', color: ''#E97659''},
            {name: ''disaster'', color: ''#E45959''},
            {name: ''resolved'', color: ''#009900''},
            {name: ''default'', color: ''#000000''}
        ],
        method = ''post'',
        process_tags = true;

    Object.keys(params)
        .forEach(function (key) {
            if (key.startsWith(''servicenow_'')) {
                servicenow[key.substring(11)] = params[key];
            }
            else if (key.startsWith(''u_'')) {
                fields[key] = params[key];
            }
            else if (required_params.indexOf(key) !== -1 && params[key] === '''') {
                throw ''Parameter "'' + key + ''" can\\''t be empty.'';
            }
        });

    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {
        throw ''Incorrect "event_source" parameter given: '' + params.event_source + ''\\nMust be 0-3.'';
    }

    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {
        params.event_nseverity = ''7'';
    }

    // Check {EVENT.VALUE} for trigger-based and internal events.
    if (params.event_value !== ''0'' && params.event_value !== ''1''
        && (params.event_source === ''0'' || params.event_source === ''3'')) {
        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\\nMust be 0 or 1.'';
    }

    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.
    if (params.event_update_status !== ''0'' && params.event_update_status !== ''1'' && params.event_source === ''0'') {
        throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''\\nMust be 0 or 1.'';
    }

    if (params.event_source !== ''0'' && params.event_recovery_value === ''0'') {
        throw ''Recovery operations are supported only for trigger-based actions.'';
    }

    data.short_description = params.alert_subject;
    data.description = params.alert_message;

    if (typeof params[''urgency_for_'' + severities[params.event_nseverity].name] !== ''undefined'') {
        data.urgency = params[''urgency_for_'' + severities[params.event_nseverity].name];
    }

    ServiceNow.setParams(servicenow);
    ServiceNow.setProxy(params.HTTPProxy);
    ServiceNow.setFields(data, fields);

    if (params.event_source === ''0'' && (params.event_value === ''0'' || params.event_update_status === ''1'')) {
        process_tags = false;
        method = ''put'';
        delete data.description;
        delete data.urgency;
        ServiceNow.params.url += ''/'' + params.servicenow_sys_id;
        data.comments = params.alert_message;
    }

    var response = ServiceNow.request(method, data);

    if (process_tags) {
        result.tags.__zbx_servicenow_sys_id = response.sys_id;
        result.tags.__zbx_servicenow_link = params.servicenow_url +
            (params.servicenow_url.endsWith(''/'') ? '''' : ''/'') + ''incident.do?sys_id='' + response.sys_id;
        result.tags.__zbx_servicenow_number = response.number;
    }

    return JSON.stringify(result);
}
catch (error) {
    Zabbix.Log(3, ''[ ServiceNow Webhook ] ERROR: '' + error);
    throw ''Sending failed: '' + error;
}','30s','1','1','{EVENT.TAGS.__zbx_servicenow_link}','ServiceNow: {EVENT.TAGS.__zbx_servicenow_number}','');
INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,status,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,exec_params,maxsessions,maxattempts,attempt_interval,content_type,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description) values ('19','4','Zammad','','','','','','','','0','25','0','0','0','0','','1','3','10s','1',E'var Zammad = {
    params: {},

    setParams: function (params) {
        if (typeof params !== ''object'') {
            return;
        }

        Zammad.params = params;
        if (typeof Zammad.params.url === ''string'') {
            if (!Zammad.params.url.endsWith(''/'')) {
                Zammad.params.url += ''/'';
            }
        }
    },

    request: function (method, query, data) {
        [''url'', ''access_token''].forEach(function (field) {
            if (typeof Zammad.params !== ''object'' || typeof Zammad.params[field] === ''undefined''
                || Zammad.params[field] === '''' ) {
                throw ''Required param is not set: "'' + field + ''".'';
            }
        });

        var response,
            url = Zammad.params.url + query,
            request = new CurlHttpRequest();

        if (typeof Zammad.HTTPProxy === ''string'' && Zammad.HTTPProxy.trim() !== '''') {
            request.SetProxy(Zammad.HTTPProxy);
        }

        request.AddHeader(''Content-Type: application/json'');
        request.AddHeader(''Authorization: Token token='' + Zammad.params.access_token);

        if (typeof data !== ''undefined'') {
            data = JSON.stringify(data);
        }

        Zabbix.Log(4, ''[ Zammad Webhook ] Sending request: '' +
            url + ((typeof data === ''string'') ? ('' '' + data) : ''''));

        switch (method) {
            case ''get'':
                response = request.Get(url, data);
                break;

            case ''post'':
                response = request.Post(url, data);
                break;

            case ''put'':
                response = request.Put(url, data);
                break;

            default:
                throw ''Unsupported HTTP request method: '' + method;
        }

        Zabbix.Log(4, ''[ Zammad Webhook ] Received response with status code '' + request.Status() + '': '' + response);

        if (response !== null) {
            try {
                response = JSON.parse(response);
            }
            catch (error) {
                Zabbix.Log(4, ''[ Zammad Webhook ] Failed to parse response received from Zammad'');
                response = null;
            }
        }

        if (request.Status() < 200 || request.Status() >= 300) {
            var message = ''Request failed with status code '' + request.Status();

            if (response !== null && typeof response.errors !== ''undefined''
                && Object.keys(response.errors).length > 0) {
                message += '': '' + JSON.stringify(response.errors);
            }
            else if (response !== null && typeof response.errorMessages !== ''undefined''
                && Object.keys(response.errorMessages).length > 0) {
                message += '': '' + JSON.stringify(response.errorMessages);
            }

            throw message + '' Check debug log for more information.'';
        }

        return {
            status: request.Status(),
            response: response
        };
    },

    setTicketTags: function(tags, ticket_id) {
        try {
            var tags_json = JSON.parse(tags),
                result;

            for (var i in tags_json) {
                result = Zammad.request(''get'',
                    ''/api/v1/tags/add?object=Ticket&o_id='' + ticket_id +
                    ''&item='' + tags_json[i].tag);

                if (typeof result.response !== ''object''
                    || result.status != 200) {
                    Zabbix.Log(4, ''[ Zammad Webhook ] Cannot add ticket tag:'' + tags_json[i].tag);
                }
            }
        }
        catch (error) {
            Zabbix.Log(4, ''[ Zammad Webhook ] Failed to add ticket tags:'' + error);
        }

        return;
    },

    createTicket: function(subject, message, priority) {
        var data = {
                title: subject,
                group: ''Users'',
                article: {
                    subject: subject,
                    body: message,
                    type: ''note'',
                    internal: false
                },
                customer: Zammad.params.customer
            },
            result;

        if (priority) {
            data.priority_id = priority;
        }

        result = Zammad.request(''post'', ''api/v1/tickets'', data);

        if (typeof result.response !== ''object''
            || typeof result.response.id === ''undefined''
            || result.status != 201) {
            throw ''Cannot create Zammad ticket. Check debug log for more information.'';
        }

        return result.response.id;
    },

    updateTicket: function(subject, message) {
        var data = {
            ticket_id: Zammad.params.ticket_id,
            subject: subject,
            body: message || '''',
            type: ''note'',
            internal: false
        };

        result = Zammad.request(''post'', ''api/v1/ticket_articles'', data);

        if (typeof result.response !== ''object''
            || typeof result.response.id === ''undefined''
            || result.status != 201) {
            throw ''Cannot update Zammad ticket. Check debug log for more information.'';
        }
    }
};

try {
    var params = JSON.parse(value),
        params_zammad = {},
        params_update = {},
        result = {tags: {}},
        required_params = [
            ''alert_subject'', ''customer'',
            ''event_source'', ''event_value'',
            ''event_update_status''
        ],
        severities = [
            {name: ''not_classified'', color: ''#97AAB3''},
            {name: ''information'', color: ''#7499FF''},
            {name: ''warning'', color: ''#FFC859''},
            {name: ''average'', color: ''#FFA059''},
            {name: ''high'', color: ''#E97659''},
            {name: ''disaster'', color: ''#E45959''},
            {name: ''resolved'', color: ''#009900''},
            {name: null, color: ''#000000''}
        ],
        priority;

    Object.keys(params)
        .forEach(function (key) {
            if (key.startsWith(''zammad_'')) {
                params_zammad[key.substring(7)] = params[key].trim();
            }
            else if (key.startsWith(''event_update_'')) {
                params_update[key.substring(13)] = params[key];
            }
            else if (required_params.indexOf(key) !== -1 && params[key].trim() === '''') {
                throw ''Parameter "'' + key + ''" cannot be empty.'';
            }
        });

    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {
        throw ''Incorrect "event_source" parameter given: '' + params.event_source + ''\\nMust be 0-3.'';
    }

    // Check {EVENT.VALUE} for trigger-based and internal events.
    if (params.event_value !== ''0'' && params.event_value !== ''1''
        && (params.event_source === ''0'' || params.event_source === ''3'')) {
        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\\nMust be 0 or 1.'';
    }

    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.
    if (params.event_source === ''0'' && params.event_update_status !== ''0'' && params.event_update_status !== ''1'') {
        throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''\\nMust be 0 or 1.'';
    }

    if (params.event_source !== ''0'' && params.event_value === ''0'') {
        throw ''Recovery operations are supported only for trigger-based actions.'';
    }

    if (params.event_source === ''0''
        && ((params.event_value === ''1'' && params.event_update_status === ''1'')
            || (params.event_value === ''0''
                && (params.event_update_status === ''0'' || params.event_update_status === ''1'')))
        && (isNaN(parseInt(params.zammad_ticket_id)) || parseInt(params.zammad_ticket_id) < 1 )) {
        throw ''Incorrect "zammad_ticket_id" parameter given: '' + params.zammad_ticket_id +
            ''\\nMust be positive integer.'';
    }

    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {
        params.event_nseverity = ''7'';
    }

    if (params.event_value === ''0'') {
        params.event_nseverity = ''6'';
    }

    priority = params[''severity_'' + severities[params.event_nseverity].name];
    priority = priority && priority.trim() || severities[7].name;

    Zammad.setParams(params_zammad);
    Zammad.HTTPProxy = params.HTTPProxy;

    // Create ticket for non trigger-based events.
    if (params.event_source !== ''0''
        && params.event_value !== ''0'') {
        Zammad.createTicket(params.alert_subject, params.alert_message, priority, params.event_tags);
    }
    // Create ticket for trigger-based events.
    else if (params.event_value === ''1'' && params_update.status === ''0'') {
        var ticket_id = Zammad.createTicket(params.alert_subject,
            params.alert_subject + ''\\n'' + params.alert_message + ''\\n'' +
            params.zabbix_url + (params.zabbix_url.endsWith(''/'') ? '''' : ''/'') +
            ''tr_events.php?triggerid='' + params.trigger_id + ''&eventid='' + params.event_id + ''\\n'',
            priority);

        result.tags.__zbx_zammad_ticket_id = ticket_id;
        result.tags.__zbx_zammad_ticketlink = params.zammad_url +
            (params.zammad_url.endsWith(''/'') ? '''' : ''/'') + ''#ticket/zoom/'' + ticket_id;

        if (Zammad.params.enable_tags.toLowerCase() === ''true'') {
            Zammad.setTicketTags(params.event_tags, ticket_id);
        }
    }
    // Update created ticket for trigger-based event.
    else {
        Zammad.updateTicket(params.alert_subject, params.alert_message);
    }

    return JSON.stringify(result);
}
catch (error) {
    Zabbix.Log(3, ''[ Zammad Webhook ] ERROR: '' + error);
    throw ''Sending failed: '' + error;
}','30s','1','1','{EVENT.TAGS.__zbx_zammad_ticketlink}','Zammad: ticket #{EVENT.TAGS.__zbx_zammad_ticket_id}','');
INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,status,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,exec_params,maxsessions,maxattempts,attempt_interval,content_type,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description) values ('20','4','Jira ServiceDesk','','','','','','','','0','25','0','0','0','0','','1','3','10s','1',E'var Jira = {
    params: {},
    schema: {},

    setParams: function (params) {
        if (typeof params !== ''object'') {
            return;
        }

        Jira.params = params;
        if (typeof Jira.params.url === ''string'') {
            if (!Jira.params.url.endsWith(''/'')) {
                Jira.params.url += ''/'';
            }

            Jira.params.url += ''rest/servicedeskapi/latest/'';
        }
    },

    setProxy: function (HTTPProxy) {
        Jira.HTTPProxy = HTTPProxy;
    },

    setTags: function(event_tags_json) {
        if (!Jira.schema) {
            Zabbix.Log(4, ''[ Jira Service Desk Webhook ] Cannot add labels because failed to retrieve field schema.'');

            return;
        }

        var block = Jira.schema.requestTypeFields.filter(function(object) {
            return object.fieldId == ''labels'';
        });

        if (block[0] && typeof event_tags_json !== ''undefined'' && event_tags_json !== ''''
            && event_tags_json !== ''{EVENT.TAGSJSON}'') {
            try {
                var tags = JSON.parse(event_tags_json),
                    label;

                Jira.labels = [];

                tags.forEach(function (tag) {
                    if (typeof tag.tag !== ''undefined'' && typeof tag.value !== ''undefined'' ) {
                        label = (tag.tag + (tag.value ? ('':'' + tag.value) : '''')).replace(/\\s/g, ''_'');
                        if (label.length < 255) {
                            Jira.labels.push(label);
                        }
                    }
                });
            }
            catch (error) {
                // Code is not missing here.
            }
        }
    },

    addCustomFields: function (data, fields) {
        if (typeof fields === ''object'' && Object.keys(fields).length) {
            if (Jira.schema) {
                Object.keys(fields)
                    .forEach(function(field) {
                        data.requestFieldValues[field] = fields[field];

                        var block = Jira.schema.requestTypeFields.filter(function(object) {
                            return object.fieldId == field;
                        });

                        if (typeof block[0] === ''object'' && typeof block[0].jiraSchema === ''object''
                            && (block[0].jiraSchema.type === ''number'' || block[0].jiraSchema.type === ''datetime'')) {
                            switch (block[0].jiraSchema.type) {
                                case ''number'':
                                    data.requestFieldValues[field] = parseInt(fields[field]);
                                    break;

                                case ''datetime'':
                                    if (fields[field].match(/\\d+[.-]\\d+[.-]\\d+T\\d+:\\d+:\\d+/) !== null) {
                                        data.requestFieldValues[field] = fields[field].replace(/\\./g, ''-'');
                                    }
                                    else {
                                        delete data.requestFieldValues[field];
                                    }
                                    break;
                            }
                        }
                    });
            }
            else {
                Zabbix.Log(4, ''[ Jira Service Desk Webhook ] Cannot add custom fields'' +
                    ''because failed to retrieve field schema.'');
            }
        }

        return data;
    },

    request: function (method, query, data) {
        [''url'', ''user'', ''password'', ''servicedesk_id'', ''request_type_id''].forEach(function (field) {
            if (typeof Jira.params !== ''object'' || typeof Jira.params[field] === ''undefined''
                || Jira.params[field] === '''' ) {
                throw ''Required Jira param is not set: "'' + field + ''".'';
            }
        });

        var response,
            url = Jira.params.url + query,
            request = new CurlHttpRequest();

        request.AddHeader(''Content-Type: application/json'');
        request.AddHeader(''Authorization: Basic '' + btoa(Jira.params.user + '':'' + Jira.params.password));
        request.AddHeader(''X-ExperimentalApi: opt-in'');

        if (typeof Jira.HTTPProxy !== ''undefined'' && Jira.HTTPProxy !== '''') {
            request.SetProxy(Jira.HTTPProxy);
        }

        if (typeof data !== ''undefined'') {
            data = JSON.stringify(data);
        }

        Zabbix.Log(4, ''[ Jira Service Desk Webhook ] Sending request: '' + url +
            ((typeof data === ''string'') ? (''\\n'' + data) : ''''));

        switch (method) {
            case ''get'':
                response = request.Get(url, data);
                break;

            case ''post'':
                response = request.Post(url, data);
                break;

            case ''put'':
                response = request.Put(url, data);
                break;

            default:
                throw ''Unsupported HTTP request method: '' + method;
        }

        Zabbix.Log(4, ''[ Jira Service Desk Webhook ] Received response with status code '' +
            request.Status() + ''\\n'' + response);

        if (response !== null) {
            try {
                response = JSON.parse(response);
            }
            catch (error) {
                Zabbix.Log(4, ''[ Jira Service Desk Webhook ] Failed to parse response received from Jira'');
                response = null;
            }
        }

        if (request.Status() < 200 || request.Status() >= 300) {
            var message = ''Request failed with status code '' + request.Status();

            if (response !== null && typeof response.errors !== ''undefined''
                && Object.keys(response.errors).length > 0) {
                message += '': '' + JSON.stringify(response.errors);
            }
            else if (response !== null && typeof response.errorMessage !== ''undefined''
                && Object.keys(response.errorMessage).length > 0) {
                message += '': '' + JSON.stringify(response.errorMessage);
            }

            throw message + '' Check debug log for more information.'';
        }

        return {
            status: request.Status(),
            response: response
        };
    },

    getSchema: function() {
        var result = Jira.request(''get'', ''servicedesk/'' + Jira.params.servicedesk_id + ''/requesttype/'' +
            Jira.params.request_type_id + ''/field'');

        if (typeof Jira.schema !== ''object'' && typeof Jira.schema.requestTypeFields !== ''object'') {
            Jira.schema = null;
        }
        else {
            Jira.schema = result.response;
        }
    },

    createRequest: function(summary, description, fields) {
        var data = {
            serviceDeskId: Jira.params.servicedesk_id,
            requestTypeId: Jira.params.request_type_id,
            requestFieldValues: {
                summary: summary,
                description: description
            }
        };

        if (Jira.labels && Jira.labels.length > 0) {
            data.requestFieldValues.labels = Jira.labels;
        }
        var result = Jira.request(''post'', ''request'', Jira.addCustomFields(data, fields));

        if (typeof result.response !== ''object'' || typeof result.response.issueKey === ''undefined'') {
            throw ''Cannot create Jira request. Check debug log for more information.'';
        }

        return result.response.issueKey;
    }
};

try {
    var params = JSON.parse(value),
        fields = {},
        jira = {},
        comment = {public: true},
        result = {tags: {}},
        required_params = [
            ''alert_subject'', ''alert_message'', ''event_source'', ''event_value'',
            ''event_update_status'', ''event_recovery_value''
        ];

    Object.keys(params)
        .forEach(function (key) {
            if (key.startsWith(''jira_'')) {
                jira[key.substring(5)] = params[key];
            }
            else if (key.startsWith(''customfield_'')) {
                fields[key] = params[key];
            }
            else if (required_params.indexOf(key) !== -1 && params[key] === '''') {
                throw ''Parameter "'' + key + ''" cannot be empty.'';
            }
        });

    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {
        throw ''Incorrect "event_source" parameter given: '' + params.event_source + ''\\nMust be 0-3.'';
    }

    // Check {EVENT.VALUE} for trigger-based and internal events.
    if (params.event_value !== ''0'' && params.event_value !== ''1''
        && (params.event_source === ''0'' || params.event_source === ''3'')) {
        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\\nMust be 0 or 1.'';
    }

    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.
    if (params.event_update_status !== ''0'' && params.event_update_status !== ''1'' && params.event_source === ''0'') {
        throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''\\nMust be 0 or 1.'';
    }

    if (params.event_source !== ''0'' && params.event_recovery_value === ''0'') {
        throw ''Recovery operations are supported only for trigger-based actions.'';
    }

    Jira.setParams(jira);
    Jira.setProxy(params.HTTPProxy);
    Jira.getSchema();
    Jira.setTags(params.event_tags_json);

    // Create request for non trigger-based events.
    if (params.event_source !== ''0'' && params.event_recovery_value !== ''0'') {
        Jira.createRequest(params.alert_subject, params.alert_message);
    }
    // Create request for trigger-based events.
    else if (params.event_value === ''1'' && params.event_update_status === ''0''
        && jira.request_key === ''{EVENT.TAGS.__zbx_jira_requestkey}'') {
        var key = Jira.createRequest(params.alert_subject, params.alert_message, fields);

        result.tags.__zbx_jira_requestkey = key;
        result.tags.__zbx_jira_requestlink = params.jira_url +
            (params.jira_url.endsWith(''/'') ? '''' : ''/'') + ''browse/'' + key;
    }
    // Comment created request for trigger-based event.
    else {
        if (jira.request_key === ''{EVENT.TAGS.__zbx_jira_requestkey}'' || jira.request_key.trim() === '''') {
            throw ''Incorrect Request key given: '' + jira.request_key;
        }
        comment.body = params.alert_message;
        Jira.request(''post'', ''request/'' + Jira.params.request_key + ''/comment'', comment);
    }

    return JSON.stringify(result);
}
catch (error) {
    Zabbix.Log(3, ''[ Jira Service Desk Webhook ] ERROR: '' + error);
    throw ''Sending failed: '' + error;
}','30s','1','1','{EVENT.TAGS.__zbx_jira_requestlink}','Jira ServiceDesk: {EVENT.TAGS.__zbx_jira_requestkey}','');
INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,status,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,exec_params,maxsessions,maxattempts,attempt_interval,content_type,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description) values ('21','4','OTRS','','','','','','','','0','25','0','0','0','0','','1','3','10s','1',E'var OTRS = {
    params: {},
    entrypoint: ''nph-genericinterface.pl/Webservice/ZabbixTicketConnector/Ticket'',

    setParams: function (params) {
        if (typeof params !== ''object'') {
            return;
        }

        OTRS.params = params;
        if (typeof OTRS.params.url === ''string'') {
            if (!OTRS.params.url.endsWith(''/'')) {
                OTRS.params.url += ''/'';
            }
        }
    },

    addDynamicFields: function (data, fields) {
        if (typeof fields === ''object'' && Object.keys(fields).length) {
            data.DynamicField = [];

            Object.keys(fields)
                .forEach(function(field) {
                    if (field !== undefined) {
                        if (fields[field].match(/^\\d{4}[.-]\\d{2}[.-]\\d{2}$/)) {
                            fields[field] = fields[field].replace(/\\./g, ''-'');
                        }

                        data.DynamicField.push({Name: field, Value: fields[field]});
                    }
                });
        }

        return data;
    },

    request: function (method, query, data) {
        [''url'', ''auth_user'', ''auth_password'', ''queue'',
            ''customer'', ''ticket_state'', ''default_priority_id'', ''time_unit''].forEach(function (field) {
            if (typeof OTRS.params !== ''object'' || typeof OTRS.params[field] === ''undefined''
                || OTRS.params[field] === '''' ) {
                throw ''Required param is not set: "'' + field + ''".'';
            }
        });

        var response,
            request = new CurlHttpRequest(),
            url = OTRS.params.url + query +
                ''?UserLogin='' + encodeURIComponent(OTRS.params.auth_user) +
                ''&Password='' + encodeURIComponent(OTRS.params.auth_password);

        if (typeof OTRS.HTTPProxy !== ''undefined'' && OTRS.HTTPProxy.trim() !== '''') {
            request.SetProxy(OTRS.HTTPProxy);
        }

        request.AddHeader(''Content-Type: application/json'');

        if (typeof data !== ''undefined'') {
            data = JSON.stringify(data);
        }

        Zabbix.Log(4, ''[ OTRS Webhook ] Sending request: '' +
            url + ((typeof data === ''string'') ? ('' '' + data) : ''''));

        switch (method) {
            case ''get'':
                response = request.Get(url, data);
                break;

            case ''post'':
                response = request.Post(url, data);
                break;

            case ''put'':
                response = request.Put(url, data);
                break;

            default:
                throw ''Unsupported HTTP request method: '' + method;
        }

        Zabbix.Log(4, ''[ OTRS Webhook ] Received response with status code '' + request.Status() + '': '' + response);

        if (request.Status() < 200 || request.Status() >= 300) {
            var message = ''Request failed with status code '' + request.Status();

            message += '': '' + response;
            throw message + '' Check debug log for more information.'';
        }

        if (response !== null) {
            try {
                response = JSON.parse(response);
            }
            catch (error) {
                Zabbix.Log(4, ''[ OTRS Webhook ] Failed to parse response received from OTRS'');
                response = null;
            }
        }

        if (typeof response.Error !== ''undefined''
            && Object.keys(response.Error).length > 0) {
            message = ''Request failed: '' + JSON.stringify(response.Error);
        }


        return {
            status: request.Status(),
            response: response
        };
    },

    createTicket: function(subject, message, priority, fields) {
        var result,
            data = {
                Ticket: {
                    Title: subject,
                    Queue: OTRS.params.queue,
                    State: OTRS.params.ticket_state,
                    PriorityID: priority || OTRS.params.default_priority_id,
                    CustomerUser: OTRS.params.customer
                },
                Article: {
                    Subject: subject,
                    Body: message,
                    TimeUnit: OTRS.params.time_unit,
                    ContentType: ''text/plain; charset=utf8''
                }
            };

        result = OTRS.request(''post'', OTRS.entrypoint, OTRS.addDynamicFields(data, fields));

        if (typeof result.response !== ''object''
            || typeof result.response.TicketID === ''undefined''
            || result.status != 200) {
            throw ''Cannot create OTRS ticket. Check debug log for more information.'';
        }

        return result.response.TicketID;
    },

    updateTicket: function(subject, message) {
        var result,
            data = {
                Article: {
                    Subject: subject,
                    Body: message || '''',
                    TimeUnit: OTRS.params.time_unit,
                    ContentType: ''text/plain; charset=utf8''
                }
            };

        result = OTRS.request(''put'', OTRS.entrypoint + ''/'' + encodeURIComponent(OTRS.params.ticket_id), data);

        if (typeof result.response !== ''object''
            || typeof result.response.TicketID === ''undefined''
            || result.status != 200) {
            throw ''Cannot update OTRS ticket. Check debug log for more information.'';
        }
    }
};

try {
    var params = JSON.parse(value),
        params_otrs = {},
        params_fields = {},
        params_update = {},
        result = {tags: {}},
        required_params = [
            ''alert_subject'', ''event_source'',
            ''event_value'',  ''event_update_status''
        ],
        severities = [
            {name: ''not_classified'', color: ''#97AAB3''},
            {name: ''information'', color: ''#7499FF''},
            {name: ''warning'', color: ''#FFC859''},
            {name: ''average'', color: ''#FFA059''},
            {name: ''high'', color: ''#E97659''},
            {name: ''disaster'', color: ''#E45959''},
            {name: ''resolved'', color: ''#009900''},
            {name: null, color: ''#000000''}
        ],
        priority;

    Object.keys(params)
        .forEach(function (key) {
            if (key.startsWith(''otrs_'')) {
                params_otrs[key.substring(5)] = params[key];
            }
            else if (key.startsWith(''dynamicfield_'')) {
                params_fields[key.substring(13)] = params[key];
            }
            else if (key.startsWith(''event_update_'')) {
                params_update[key.substring(13)] = params[key];
            }
            else if (required_params.indexOf(key) !== -1 && params[key].trim() === '''') {
                throw ''Parameter "'' + key + ''" cannot be empty.'';
            }
        });

    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {
        throw ''Incorrect "event_source" parameter given: '' + params.event_source + ''\\nMust be 0-3.'';
    }

    // Check {EVENT.VALUE} for trigger-based and internal events.
    if (params.event_value !== ''0'' && params.event_value !== ''1''
        && (params.event_source === ''0'' || params.event_source === ''3'')) {
        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\\nMust be 0 or 1.'';
    }

    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.
    if (params.event_source === ''0'' && params.event_update_status !== ''0'' && params.event_update_status !== ''1'') {
        throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''\\nMust be 0 or 1.'';
    }

    if (params.event_source !== ''0'' && params.event_value === ''0'') {
        throw ''Recovery operations are supported only for trigger-based actions.'';
    }

    if (params.event_source === ''0''
        && ((params.event_value === ''1'' && params.event_update_status === ''1'')
            || (params.event_value === ''0''
                && (params.event_update_status === ''0'' || params.event_update_status === ''1'')))
        && (isNaN(parseInt(params.otrs_ticket_id)) || parseInt(params.otrs_ticket_id) < 1 )) {
        throw ''Incorrect "otrs_ticket_id" parameter given: '' + params.otrs_ticket_id +
            ''\\nMust be positive integer.'';
    }

    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {
        params.event_nseverity = ''7'';
    }

    if (params.event_value === ''0'') {
        params.event_nseverity = ''6'';
    }

    priority = params[''severity_'' + severities[params.event_nseverity].name];
    priority = priority && priority.trim() || severities[7].name;

    OTRS.setParams(params_otrs);
    OTRS.HTTPProxy = params.HTTPProxy;

    // Create ticket for non trigger-based events.
    if (params.event_source !== ''0''
        && params.event_value !== ''0'') {
        OTRS.createTicket(params.alert_subject, params.alert_message, priority);
    }
    // Create ticket for trigger-based events.
    else if (params.event_value === ''1'' && params_update.status === ''0'') {
        var ticket_id = OTRS.createTicket(params.alert_subject,
            params.alert_subject + ''\\n'' + params.alert_message + ''\\n'' +
            params.zabbix_url + (params.zabbix_url.endsWith(''/'') ? '''' : ''/'') +
            ''tr_events.php?triggerid='' + params.trigger_id + ''&eventid='' + params.event_id + ''\\n'',
            priority,
            params_fields);

        result.tags.__zbx_otrs_ticket_id = ticket_id;
        result.tags.__zbx_otrs_ticketlink = params.otrs_url +
            (params.otrs_url.endsWith(''/'') ? '''' : ''/'') + ''index.pl?Action=AgentTicketZoom;TicketID='' + ticket_id;
    }
    // Update created ticket for trigger-based event.
    else {
        OTRS.updateTicket(params.alert_subject, params.alert_message);
    }

    return JSON.stringify(result);
}
catch (error) {
    Zabbix.Log(3, ''[ OTRS Webhook ] ERROR: '' + error);
    throw ''Sending failed: '' + error;
}','30s','1','1','{EVENT.TAGS.__zbx_otrs_ticketlink}','OTRS: ticket #{EVENT.TAGS.__zbx_otrs_ticket_id}','');
INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,status,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,exec_params,maxsessions,maxattempts,attempt_interval,content_type,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description) values ('22','4','iLert','','','','','','','','0','25','0','0','0','0','','1','3','10s','1','try {
    var result = { tags: {} },
        params = JSON.parse(value),
        req = new CurlHttpRequest(),
        resp = '''';

    if (typeof params.HTTPProxy === ''string'' && params.HTTPProxy.trim() !== '''') {
        req.SetProxy(params.HTTPProxy);
    }
    var alertSourceKey = params[''.ILERT.ALERT.SOURCE.KEY''];
    if (!alertSourceKey || (typeof alertSourceKey === ''string'' && alertSourceKey.trim() === '''')) {
        throw ''incorrect value for variable "ILERT.ALERT.SOURCE.KEY". The value must be a non-empty string.'';
    }
    delete params[''.ILERT.ALERT.SOURCE.KEY''];
    
    var ilertApiBaseURL = "https://api.ilert.com";
    var reqURL = encodeURI(ilertApiBaseURL + "/api/v1/events/zabbix-mt/" + alertSourceKey)

    var incidentKey = "zabbix-" + params[''EVENT.ID''];
    var incidentViewURL = ilertApiBaseURL + "/api/v1/incidents/resolve-ik/" + alertSourceKey + "/" + incidentKey;

    req.AddHeader(''Accept: application/json'');
    req.AddHeader(''Content-Type: application/json'');

    Zabbix.Log(4, ''[iLert Webhook] Sending request:'' + JSON.stringify(params));
    resp = req.Post(reqURL, JSON.stringify(params));
    Zabbix.Log(4, ''[iLert Webhook] Receiving response:'' + resp);

    try {
        resp = JSON.parse(resp);
    }
    catch (error) {
        throw ''incorrect response. iLert returned a non-JSON object.'';
    }

    if (req.Status() == 200) {
        result.tags.__ilert_incident_url = incidentViewURL;
        return JSON.stringify(result);
    }

    if (req.Status() == 400 && typeof resp === ''object'' && typeof resp.code === ''string'') {
        if (resp.code === ''NO_OPEN_INCIDENT_WITH_KEY'') {
          return JSON.stringify(result);
        }
        if (resp.code === ''INCIDENT_ALREADY_ACCEPTED'') {
          result.tags.__ilert_incident_url = incidentViewURL;
          return JSON.stringify(result);
        }
    }

    if (typeof resp === ''object'' && typeof resp.message === ''string'') {
        throw resp.message;
    }
    else {
        throw ''Unknown error.'';
    }
}
catch (error) {
    Zabbix.Log(3, ''[iLert Webhook] Notification failed : '' + error);
    throw ''iLert notification failed : '' + error;
}','30s','1','1','{EVENT.TAGS.__ilert_incident_url}','iLert incident','Please refer to https://docs.ilert.com/integration/zabbix 
  
Set global macro {$ZABBIX.URL} with your Zabbix server URL.
Add a dedicated user with the media type "iLert". You can also rewrite the incident summary via ".ILERT.INCIDENT.SUMMARY" parameter or leave it empty to use the standard pattern.');
INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,status,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,exec_params,maxsessions,maxattempts,attempt_interval,content_type,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description) values ('23','4','SolarWinds Service Desk','','','','','','','','0','25','0','0','0','0','','1','3','10s','1',E'var SolarWinds = {
    params: {},

    setParams: function (params) {
        if (typeof params !== ''object'') {
            return;
        }

        SolarWinds.params = params;
        SolarWinds.params.endpoint = ''https://api.samanage.com/'';
    },

    setProxy: function (HTTPProxy) {
        SolarWinds.HTTPProxy = HTTPProxy;
    },

    addCustomFields: function (data, fields) {
        if (typeof data.incident === ''object'' && typeof fields === ''object'' && Object.keys(fields).length) {
            if (typeof fields.sw_fields === ''object'' && Object.keys(fields.sw_fields).length) {
                Object.keys(fields.sw_fields)
                    .forEach(function(field) {
                        try {
                            data.incident[field] = JSON.parse(fields.sw_fields[field]);
                        }
                        catch (error) {
                            data.incident[field] = fields.sw_fields[field];
                        }
                    });
            }

            if (typeof fields.sw_customfields === ''object'' && Object.keys(fields.sw_customfields).length) {
                data.incident.custom_fields_values = {custom_fields_value: []};
                Object.keys(fields.sw_customfields)
                    .forEach(function(field) {
                        data.incident.custom_fields_values.custom_fields_value.push({
                            name: field,
                            value: fields.sw_customfields[field]
                        });
                    });
            }
        }

        return data;
    },

    request: function (method, query, data) {
        [''token''].forEach(function (field) {
            if (typeof SolarWinds.params !== ''object'' || typeof SolarWinds.params[field] === ''undefined''
                || SolarWinds.params[field] === '''' ) {
                throw ''Required SolarWinds param is not set: "'' + field + ''".'';
            }
        });

        var response,
            url = SolarWinds.params.endpoint + query,
            request = new CurlHttpRequest();

        request.AddHeader(''Content-Type: application/json'');
        request.AddHeader(''X-Samanage-Authorization: Bearer '' + SolarWinds.params.token);
        request.AddHeader(''Accept: application/vnd.samanage.v2.1+json'');

        if (typeof SolarWinds.HTTPProxy !== ''undefined'' && SolarWinds.HTTPProxy !== '''') {
            request.SetProxy(SolarWinds.HTTPProxy);
        }

        if (typeof data !== ''undefined'') {
            data = JSON.stringify(data);
        }

        Zabbix.Log(4, ''[ SolarWinds SD Webhook ] Sending request: '' + url + ((typeof data === ''string'')
            ? (''\\n'' + data)
            : ''''));

        switch (method) {
            case ''get'':
                response = request.Get(url, data);
                break;

            case ''post'':
                response = request.Post(url, data);
                break;

            case ''put'':
                response = request.Put(url, data);
                break;

            default:
                throw ''Unsupported HTTP request method: '' + method;
        }

        Zabbix.Log(4, ''[ SolarWinds SD Webhook ] Received response with status code '' + request.Status() +
            ''\\n'' + response);

        if (response !== null) {
            try {
                response = JSON.parse(response);
            }
            catch (error) {
                Zabbix.Log(4, ''[ SolarWinds SD Webhook ] Failed to parse response received from SolarWinds'');
                response = null;
            }
        }

        if (request.Status() < 200 || request.Status() >= 300) {
            var message = ''Request failed with status code '' + request.Status();

            if (response !== null && typeof response.error !== ''undefined''
                && Object.keys(response.error).length > 0) {
                message += '': '' + JSON.stringify(response.error);
            }
            else if (response !== null && typeof response === ''object''
                && Object.keys(response).length > 0) {
                Object.keys(response)
                    .forEach(function(field) {
                        message += ''\\n'' + field + '': '' + response[field][0];
                    });
            }

            throw message + '' Check debug log for more information.'';
        }

        return {
            status: request.Status(),
            response: response
        };
    },

    createIncident: function(name, description, fields) {
        var data = {
            incident: {
                name: name,
                description: description,
                priority: SolarWinds.params.priority
            }
        };

        var result = SolarWinds.request(''post'', ''incidents.json'', SolarWinds.addCustomFields(data, fields));

        if (typeof result.response !== ''object'' || typeof result.response.id === ''undefined'') {
            throw ''Cannot create SolarWinds incident. Check debug log for more information.'';
        }

        return result.response.id;
    },

    updateIncident: function(name, fields, message) {
        var data = {
            incident: {
                name: name,
                priority: SolarWinds.params.priority
            }
        };

        SolarWinds.request(
            ''put'',
            ''incidents/'' + SolarWinds.params.incident_id + ''.json'',
            SolarWinds.addCustomFields(data, fields));

        SolarWinds.commenIncident(message);
    },

    commenIncident: function(message) {
        var data = {
            comment: {
                body: message
            }
        };

        SolarWinds.request(''post'', ''incidents/'' + SolarWinds.params.incident_id + ''/comments.json'', data);
    }
};

try {
    var params = JSON.parse(value),
        fields = {},
        samanage = {},
        result = {tags: {}},
        required_params = [''alert_subject'', ''event_recovery_value'', ''event_source'', ''event_value'', ''priority_default''],
        severities = [
            {name: ''not_classified''},
            {name: ''information''},
            {name: ''warning''},
            {name: ''average''},
            {name: ''high''},
            {name: ''disaster''},
            {name: ''resolved''},
            {name: ''default''}
        ];

    fields.sw_fields = {};
    fields.sw_customfields = {};

    Object.keys(params)
        .forEach(function (key) {
            if (key.startsWith(''samanage_'')) {
                samanage[key.substring(9)] = params[key];
            }
            else if (key.startsWith(''sw_field_'')) {
                fields.sw_fields[key.substring(9)] = params[key];
            }
            else if (key.startsWith(''sw_customfield_'')) {
                fields.sw_customfields[key.substring(15)] = params[key];
            }
            else if (required_params.indexOf(key) !== -1 && params[key] === '''') {
                throw ''Parameter "'' + key + ''" can\\''t be empty.'';
            }
        });

    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {
        throw ''Incorrect "event_source" parameter given: '' + params.event_source + ''\\nMust be 0-3.'';
    }

    // Check {EVENT.VALUE} for trigger-based and internal events.
    if (params.event_value !== ''0'' && params.event_value !== ''1''
        && (params.event_source === ''0'' || params.event_source === ''3'')) {
        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\\nMust be 0 or 1.'';
    }

    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.
    if (params.event_update_status !== ''0'' && params.event_update_status !== ''1'' && params.event_source === ''0'') {
        throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''\\nMust be 0 or 1.'';
    }

    if (params.event_source !== ''0'' && params.event_recovery_value === ''0'') {
        throw ''Recovery operations are supported only for trigger-based actions.'';
    }

    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {
        params.event_nseverity = ''7'';
    }

    if (params.event_value === ''0'') {
        params.event_nseverity = ''6'';
    }

    samanage.priority = params[''priority_'' + severities[params.event_nseverity].name] || params.priority_default;

    SolarWinds.setParams(samanage);
    SolarWinds.setProxy(params.HTTPProxy);

    // Create incident for non trigger-based events.
    if (params.event_source !== ''0'' && params.event_recovery_value !== ''0'') {
        SolarWinds.createIncident(params.alert_subject, params.alert_message);
    }
    // Create incident for trigger-based events.
    else if (params.event_value === ''1'' && params.event_update_status === ''0''
            && samanage.incident_id === ''{EVENT.TAGS.__zbx_solarwinds_inc_id}'') {
        var key = SolarWinds.createIncident(params.alert_subject, params.alert_message, fields);


        result.tags.__zbx_solarwinds_inc_id = key;
        result.tags.__zbx_solarwinds_inc_link = params.samanage_url +
            (params.samanage_url.endsWith(''/'') ? '''' : ''/'') + ''incidents/'' + key;
    }
    // Update created incident for trigger-based event.
    else {
        if (samanage.incident_id === ''{EVENT.TAGS.__zbx_solarwinds_inc_id}'' || samanage.incident_id === '''') {
            throw ''Incorrect incident key given: '' + samanage.incident_id;
        }
        if (!params.alert_message) {
            throw ''Parameter "alert_message" can\\''t be empty.'';
        }
        SolarWinds.updateIncident(params.alert_subject, fields, params.alert_message);
    }

    if (params.event_source === ''0'') {
        return JSON.stringify(result);
    }
    else {
        return ''OK'';
    }
}
catch (error) {
    Zabbix.Log(3, ''[ SolarWinds SD Webhook ] ERROR: '' + error);
    throw ''Sending failed: '' + error;
}','30s','1','1','{EVENT.TAGS.__zbx_solarwinds_inc_link}','SolarWinds incident ID: {EVENT.TAGS.__zbx_solarwinds_inc_id}','');
INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,status,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,exec_params,maxsessions,maxattempts,attempt_interval,content_type,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description) values ('24','4','SysAid','','','','','','','','0','25','0','0','0','0','','1','3','10s','1',E'var SysAid = {
    params: {},

    setParams: function (params) {
        var required = [''url'', ''auth_user'', ''auth_password'', ''category_level_1'', ''category_level_2'',
            ''category_level_3'', ''incident_id'', ''template_id'', ''urgency_id'', ''incident_state'',
            ''default_priority_id''
        ];

        required.forEach(function (field) {
            if (typeof params !== ''object'' || typeof params[field] === ''undefined'' || params[field] === '''') {
                throw ''Required param is not set: "'' + field + ''".'';
            }
        });

        SysAid.params = params;
        if (typeof SysAid.params.url === ''string'' && !SysAid.params.url.endsWith(''/'')) {
            SysAid.params.url += ''/'';
        }
    },

    login: function () {
        var result = SysAid.request(''post'', ''api/v1/login'', {
            user_name: SysAid.params.auth_user,
            password: SysAid.params.auth_password
        });

        return result.response.user.id;
    },

    request: function (method, query, data) {
        var response,
            request = SysAid.req || (SysAid.req = new CurlHttpRequest()),
            url = SysAid.params.url + query;

        if (typeof SysAid.HTTPProxy !== ''undefined'' && SysAid.HTTPProxy.trim() !== '''') {
            request.SetProxy(SysAid.HTTPProxy);
        }

        if (typeof data !== ''undefined'') {
            data = JSON.stringify(data);
        }

        Zabbix.Log(4, ''[ SysAid Webhook ] Sending request: '' +
            url + ((typeof data === ''string'') ? ('' '' + data) : ''''));

        switch (method) {
            case ''get'':
                response = request.Get(url, data);
                break;

            case ''post'':
                response = request.Post(url, data);
                break;

            case ''put'':
                response = request.Put(url, data);
                break;

            default:
                throw ''Unsupported HTTP request method: '' + method;
        }

        Zabbix.Log(4, ''[ SysAid Webhook ] Received response with status code '' + request.Status() + '': '' + response);

        if (request.Status() !== 200) {
            var message = ''Request failed with status code '' + request.Status();

            message += '': '' + response;
            throw message + '' Check debug log for more information.'';
        }

        if (response !== null) {
            try {
                response = JSON.parse(response);
            }
            catch (error) {
                Zabbix.Log(4, ''[ SysAid Webhook ] Failed to parse response received from SysAid'');
                response = null;
            }
        }

        if (response === null || (typeof response.Error !== ''undefined'' && Object.keys(response.Error).length > 0)) {
            throw ''Request failed: '' + JSON.stringify(response.Error);
        }

        return {
            status: request.Status(),
            response: response
        };
    },

    createIncident: function(subject, message, priority) {
        var result = SysAid.request(''post'', ''api/v1/sr/?template='' + encodeURIComponent(SysAid.params.template_id), {
            info: [
                {
                    key: ''problem_type'',
                    value: [
                        SysAid.params.category_level_1,
                        SysAid.params.category_level_2,
                        SysAid.params.category_level_3
                    ].join(''_'')
                },
                {
                    key: ''title'',
                    value: subject
                },
                {
                    key: ''description'',
                    value: message
                },
                {
                    key: ''status'',
                    value: ''1''
                },
                {
                    key: ''urgency'',
                    value: SysAid.params.urgency_id
                },
                {
                    key: ''priority'',
                    value: priority || SysAid.params.default_priority_id,
                }
            ]
        });

        if (result.response.id === ''undefined'') {
            throw ''Cannot create SysAid incident. Check debug log for more information.'';
        }

        return result.response.id;
    },

    updateTicket: function(note) {
        var date = new Date().getTime();

        SysAid.request(''put'', ''api/v1/sr/'' + encodeURIComponent(SysAid.params.incident_id), {
            id: SysAid.params.incident_id,
            info: [
                {
                    key: ''update_time'',
                    value: date
                },
                {
                    key: ''notes'',
                    value: [
                        {
                            userName: ''Zabbix'',
                            createDate: date,
                            text: note
                        }
                    ]
                }
            ]
        });
    }
};

try {
    var params = JSON.parse(value),
        params_sysaid = {},
        params_update = {},
        result = {tags: {}},
        required_params = [''alert_subject'', ''event_source'', ''event_value'',  ''event_update_status''],
        severities = [
            {name: ''not_classified'', color: ''#97AAB3''},
            {name: ''information'', color: ''#7499FF''},
            {name: ''warning'', color: ''#FFC859''},
            {name: ''average'', color: ''#FFA059''},
            {name: ''high'', color: ''#E97659''},
            {name: ''disaster'', color: ''#E45959''},
            {name: ''resolved'', color: ''#009900''},
            {name: null, color: ''#000000''}
        ],
        priority;

    Object.keys(params)
        .forEach(function (key) {
            if (key.startsWith(''sysaid_'')) {
                params_sysaid[key.substring(7)] = params[key];
            }
            else if (key.startsWith(''event_update_'')) {
                params_update[key.substring(13)] = params[key];
            }
            else if (required_params.indexOf(key) !== -1 && params[key].trim() === '''') {
                throw ''Parameter "'' + key + ''" cannot be empty.'';
            }
        });

    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {
        throw ''Incorrect "event_source" parameter given: '' + params.event_source + ''\\nMust be 0-3.'';
    }

    // Check {EVENT.VALUE} for trigger-based and internal events.
    if (params.event_value !== ''0'' && params.event_value !== ''1''
        && (params.event_source === ''0'' || params.event_source === ''3'')) {
        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\\nMust be 0 or 1.'';
    }

    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.
    if (params.event_source === ''0'' && params.event_update_status !== ''0'' && params.event_update_status !== ''1'') {
        throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''\\nMust be 0 or 1.'';
    }

    if (params.event_source !== ''0'' && params.event_value === ''0'') {
        throw ''Recovery operations are supported only for trigger-based actions.'';
    }

    if (params.event_source === ''0'' && ((params.event_value === ''1'' && params.event_update_status === ''1'')
            || (params.event_value === ''0'' && (params.event_update_status === ''0'' || params.event_update_status === ''1'')))
            && (isNaN(parseInt(params.sysaid_incident_id)) || parseInt(params.sysaid_incident_id) < 1 )) {
        throw ''Incorrect "sysaid_incident_id" parameter given: '' + params.sysaid_incident_id + ''\\nMust be positive integer.'';
    }

    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {
        params.event_nseverity = ''7'';
    }

    if (params.event_value === ''0'') {
        params.event_nseverity = ''6'';
    }

    priority = params[''severity_'' + severities[params.event_nseverity].name];
    priority = priority && priority.trim() || severities[7].name;

    SysAid.setParams(params_sysaid);
    SysAid.HTTPProxy = params.HTTPProxy;
    SysAid.login();

    if (params.event_source !== ''0'' && params.event_value !== ''0'') {
        // Create ticket for non trigger-based events.
        SysAid.createIncident(params.alert_subject, params.alert_message, priority);
    }
    else if (params.event_value === ''1'' && params_update.status === ''0'') {
        // Create ticket for trigger-based events.
        var incident_id = SysAid.createIncident(params.alert_subject, params.alert_subject + ''\\n'' + params.alert_message +
                ''\\n'' + params.zabbix_url + (params.zabbix_url.endsWith(''/'') ? '''' : ''/'') + ''tr_events.php?triggerid='' +
                params.trigger_id + ''&eventid='' + params.event_id + ''\\n'', priority
        );

        result.tags.__zbx_sysaid_incident_id = incident_id;
        result.tags.__zbx_sysaid_incidentlink = params.sysaid_url +
            (params.sysaid_url.endsWith(''/'') ? '''' : ''/'') + ''SREdit.jsp?id='' + incident_id + ''&fromId=IncidentsList'';
    }
    else {
        // Update created ticket for trigger-based event.
        SysAid.updateTicket(params.alert_subject + ''\\n'' + params.alert_message);
    }

    return JSON.stringify(result);
}
catch (error) {
    Zabbix.Log(3, ''[ SysAid Webhook ] ERROR: '' + error);
    throw ''Sending failed: '' + error;
}','30s','1','1','{EVENT.TAGS.__zbx_sysaid_incidentlink}','SysAid: incident #{EVENT.TAGS.__zbx_sysaid_incident_id}','');
INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,status,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,exec_params,maxsessions,maxattempts,attempt_interval,content_type,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description) values ('25','4','TOPdesk','','','','','','','','0','25','0','0','0','0','','1','3','10s','1',E'var Media = {
    params: {},
    name: '''',
    labels: [],
    HTTPProxy: '''',

    setParams: function (params) {
        if (typeof params !== ''object'') {
            return;
        }

        Media.params = params;
        Media.params.api += Media.params.api.endsWith(''/'') ? '''' : ''/'';
    },

    setProxy: function (HTTPProxy) {
        if (typeof HTTPProxy !== ''undefined'' && HTTPProxy.trim() !== '''') {
            Media.HTTPProxy = HTTPProxy;
        }
    },

    request: function (method, query, data) {
        [''api'', ''token''].forEach(function (field) {
            if (typeof Media.params !== ''object'' || typeof Media.params[field] === ''undefined''
                    || Media.params[field] === '''') {
                throw ''Required '' + Media.name + '' param is not set: "'' + field + ''".'';
            }
        });

        var response,
            url = Media.params.api + query,
            request = new CurlHttpRequest();

        request.AddHeader(''Content-Type: application/json'');
        request.AddHeader(''Accept: application/json'');
        request.AddHeader(''Authorization: '' + Media.params.token);
        request.SetProxy(Media.HTTPProxy);

        if (typeof data !== ''undefined'') {
            data = JSON.stringify(data);
        }

        Zabbix.Log(4, ''[ '' + Media.name + '' Webhook ] Sending request: '' +
            url + ((typeof data === ''string'') ? (''\\n'' + data) : ''''));

        switch (method) {
            case ''get'':
                response = request.Get(url, data);
                break;

            case ''post'':
                response = request.Post(url, data);
                break;

            case ''put'':
                response = request.Put(url, data);
                break;

            default:
                throw ''Unsupported HTTP request method: '' + method;
        }

        Zabbix.Log(4, ''[ '' + Media.name + '' Webhook ] Received response with status code '' +
            request.Status() + ''\\n'' + response);

        if (response !== null) {
            try {
                response = JSON.parse(response);
            }
            catch (error) {
                Zabbix.Log(4, ''[ '' + Media.name + '' Webhook ] Failed to parse response.'');
                response = null;
            }
        }

        if (request.Status() < 200 || request.Status() >= 300) {
            var message = ''Request failed with status code '' + request.Status();

            if (response !== null) {
                if (typeof response.errors === ''object'' && Object.keys(response.errors).length > 0) {
                    message += '': '' + JSON.stringify(response.errors);
                }
                else if (typeof response.errorMessages === ''object'' && Object.keys(response.errorMessages).length > 0) {
                    message += '': '' + JSON.stringify(response.errorMessages);
                }
                else if (typeof response.message === ''string'') {
                    message += '': '' + response.message;
                }
            }

            throw message + '' Check debug log for more information.'';
        }

        return {
            status: request.Status(),
            response: response
        };
    }
};

try {
    var result = {tags: {}},
        params = JSON.parse(value),
        media = {},
        fields = {},
        resp = {},
        required_params = [
            ''alert_subject'',
            ''alert_message'',
            ''event_id'',
            ''event_source'',
            ''event_value'',
            ''event_update_status'',
            ''topdesk_api'',
            ''topdesk_user'',
            ''topdesk_password''
        ],
        severities = [
            ''not_classified'',
            ''information'',
            ''warning'',
            ''average'',
            ''high'',
            ''disaster'',
            ''resolved'',
            ''default''
        ],
        priority;

    Object.keys(params)
        .forEach(function (key) {
            if (required_params.indexOf(key) !== -1 && params[key].trim() === '''') {
                throw ''Parameter "'' + key + ''" cannot be empty.'';
            }
            if (key.startsWith(''topdesk_'')) {
                media[key.substring(8)] = params[key];
            }
        });

    // Possible values of event_source:
    // 0 - Trigger, 1 - Discovery, 2 - Autoregistration, 3 - Internal.
    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {
        throw ''Incorrect "event_source" parameter given: "'' + params.event_source + ''".\\nMust be 0-3.'';
    }

    // Check event_value for trigger-based and internal events.
    // Possible values: 1 for problem, 0 for recovering
    if (params.event_value !== ''0'' && params.event_value !== ''1''
        && (params.event_source === ''0'' || params.event_source === ''3'')) {
        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\\nMust be 0 or 1.'';
    }

    // Check event_update_status only for trigger-based events.
    // Possible values: 0 - Webhook was called because of problem/recovery event, 1 - Update operation.
    if (params.event_source === ''0'' && params.event_update_status !== ''0'' && params.event_update_status !== ''1'') {
        throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''\\nMust be 0 or 1.'';
    }

    // Check event_id for a numeric value.
    if (isNaN(parseInt(params.event_id)) || params.event_id < 1) {
        throw ''Incorrect "event_id" parameter given: '' + params.event_id + ''\\nMust be a positive number.'';
    }

    if ((params.event_source === ''1'' || params.event_source === ''2'')  && params.event_value === ''0'') {
        throw ''Recovery operations are supported only for Trigger and Internal actions.'';
    }

    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {
        params.event_nseverity = ''7'';
    }

    if (params.event_value === ''0'') {
        params.event_nseverity = ''6'';
    }

    priority = params[''severity_'' + severities[params.event_nseverity]];
    params.zbxurl = params.zbxurl + (params.zbxurl.endsWith(''/'') ? '''' : ''/'');

    Media.name = ''TOPdesk'';
    Media.setParams(media);
    Media.params.token = ''Basic '' + btoa(Media.params.user + '':'' + Media.params.password);
    Media.setProxy(params.HTTPProxy);

    // Create an issue.
    // Numeric value of the event that triggered an action (1 for problem, 0 for recovering).
    // Numeric value of of the problem update status. Possible values:
    // 0 - Webhook was called because of problem/recovery event, 1 - Update operation.
    if ((params.event_source == 0 && params.event_value == 1 && params.event_update_status == 0)
            || (params.event_source == 3 && params.event_value == 1)
            || params.event_source == 1 || params.event_source == 2) {
        Zabbix.Log(4, ''[ '' + Media.name + '' Webhook ] Request of the ticket creating.'');
        fields.caller = {dynamicName: ''Zabbix''};
        fields.briefDescription = params.alert_subject;
        fields.request = params.alert_message.replace(/\\n/g, ''<br>'');
        fields.priority = {name: priority};
        fields.processingStatus = {name: Media.params.status};
        fields.externalNumber = params.event_id;
        fields.request += ''<br>'' + params.zbxurl;

        if (params.event_source === ''0'') {
            fields.request += ''tr_events.php?triggerid='' + params.trigger_id + ''&eventid='' + params.event_id;
        }

        resp = Media.request(''post'', ''tas/api/incidents'', fields);
        if (typeof resp.response !== ''object'' || typeof resp.response.id === ''undefined'') {
            throw ''Cannot create '' + Media.name + '' issue. Check debug log for more information.'';
        }

        if (params.event_source == 0 && params.event_value == 1 && params.event_update_status == 0) {
            result.tags.__zbx_tpd_issuekey = resp.response.number;
            result.tags.__zbx_tpd_issuelink = Media.params.api +
                ''tas/secure/incident?action=show&unid='' + resp.response.id;
        }
    }
    // Update a created issue.
    else {
        if (params.event_source == 3 && params.event_value == 0) {
            throw ''Internal event recovery actions are not supported.'';
        }

        Zabbix.Log(4, ''[ '' + Media.name + '' Webhook ] Request of the ticket updating.'');
        fields.action = params.alert_message.replace(/\\n/g, ''<br>'');

        resp = Media.request(''put'', ''tas/api/incidents/number/'' + Media.params.issue_key, fields);
        if (typeof resp.response !== ''object'' || typeof resp.response.id === ''undefined''
                || resp.response.number !== Media.params.issue_key) {
            throw ''Cannot update '' + Media.name + '' issue. Check debug log for more information.'';
        }
    }

    return JSON.stringify(result);
}
catch (error) {
    Zabbix.Log(3, ''[ '' + Media.name + '' Webhook ] ERROR: '' + error);
    throw ''Sending failed: '' + error;
}','30s','1','1','{EVENT.TAGS.__zbx_tpd_issuelink}','TOPdesk: {EVENT.TAGS.__zbx_tpd_issuekey}','Please refer to https://developers.topdesk.com/documentation/index.html and https://www.zabbix.com/documentation/current/manual/config/notifications/media/webhook#example_scripts.
  
Set global macro {$ZABBIX.URL} with your Zabbix server URL.
Add a dedicated user with the media type "TOPdesk".
Change the values of the variables topdesk_api (URL), topdesk_password, topdesk_user. The topdesk_status is the default status for creating a new TOPdesk ticket.');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('1','5','zabbix_url','{$ZABBIX.URL}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('2','5','bot_token','<YOUR BOT TOKEN>');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('3','5','mattermost_url','<YOUR MATTERMOST URL>');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('4','5','send_mode','alarm');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('5','5','send_to','{ALERT.SENDTO}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('6','5','event_tags','{EVENT.TAGS}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('8','5','event_nseverity','{EVENT.NSEVERITY}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('10','5','event_value','{EVENT.VALUE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('11','5','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('12','5','event_date','{EVENT.DATE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('13','5','event_time','{EVENT.TIME}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('14','5','event_severity','{EVENT.SEVERITY}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('15','5','event_opdata','{EVENT.OPDATA}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('16','5','event_id','{EVENT.ID}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('18','5','trigger_id','{TRIGGER.ID}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('19','5','trigger_description','{TRIGGER.DESCRIPTION}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('20','5','host_name','{HOST.HOST}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('21','5','host_ip','{HOST.IP}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('22','5','event_update_date','{EVENT.UPDATE.DATE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('23','5','event_update_time','{EVENT.UPDATE.TIME}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('24','5','event_recovery_date','{EVENT.RECOVERY.DATE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('25','5','event_recovery_time','{EVENT.RECOVERY.TIME}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('37','6','zbxurl','{$ZABBIX.URL}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('39','7','token','<put your key>');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('40','7','eventid','{EVENT.ID}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('41','7','eventname','{ALERT.SUBJECT}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('42','7','hostname','{HOST.NAME}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('43','7','hostip','{HOST.IP}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('44','7','severity','{EVENT.NSEVERITY}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('45','7','triggerdesc','{TRIGGER.DESCRIPTION}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('46','7','triggeropdata','{EVENT.OPDATA}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('47','7','eventtags','{EVENT.TAGS}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('48','7','triggerid','{TRIGGER.ID}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('49','7','eventdate','{EVENT.DATE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('50','7','eventtime','{EVENT.TIME}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('52','7','eventack','{EVENT.ACK.STATUS}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('53','7','eventupdate','{EVENT.UPDATE.STATUS}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('54','7','eventvalue','{EVENT.VALUE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('55','7','url','{$ZABBIX.URL}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('56','8','token','<PUSHOVER TOKEN HERE>');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('57','8','user','{ALERT.SENDTO}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('58','8','message','{ALERT.MESSAGE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('59','8','title','{ALERT.SUBJECT}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('60','8','url','{$ZABBIX.URL}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('61','8','url_title','Zabbix');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('63','8','eventid','{EVENT.ID}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('64','8','triggerid','{TRIGGER.ID}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('65','9','zabbix_url','{$ZABBIX.URL}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('66','9','bot_token','<PLACE YOUR KEY HERE>');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('67','9','channel','{ALERT.SENDTO}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('68','9','slack_mode','alarm');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('69','9','slack_as_user','true');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('71','9','event_tags','{EVENT.TAGS}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('73','9','event_nseverity','{EVENT.NSEVERITY}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('75','9','event_value','{EVENT.VALUE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('76','9','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('77','9','event_date','{EVENT.DATE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('78','9','event_time','{EVENT.TIME}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('79','9','event_severity','{EVENT.SEVERITY}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('80','9','event_opdata','{EVENT.OPDATA}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('81','9','event_id','{EVENT.ID}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('83','9','trigger_id','{TRIGGER.ID}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('84','9','trigger_description','{TRIGGER.DESCRIPTION}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('85','9','host_name','{HOST.HOST}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('87','9','event_update_date','{EVENT.UPDATE.DATE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('88','9','event_update_time','{EVENT.UPDATE.TIME}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('89','9','event_recovery_date','{EVENT.RECOVERY.DATE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('90','9','event_recovery_time','{EVENT.RECOVERY.TIME}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('91','10','zabbix_url','{$ZABBIX.URL}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('92','10','discord_endpoint','{ALERT.SENDTO}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('93','10','use_default_message','false');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('94','10','alert_message','{ALERT.MESSAGE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('95','10','alert_subject','{ALERT.SUBJECT}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('96','10','event_name','{EVENT.NAME}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('97','10','event_id','{EVENT.ID}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('98','10','event_severity','{EVENT.SEVERITY}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('99','10','event_nseverity','{EVENT.NSEVERITY}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('100','10','event_opdata','{EVENT.OPDATA}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('101','10','event_tags','{EVENT.TAGS}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('102','10','event_time','{EVENT.TIME}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('103','10','event_date','{EVENT.DATE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('104','10','event_recovery_date','{EVENT.RECOVERY.DATE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('105','10','event_recovery_time','{EVENT.RECOVERY.TIME}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('106','10','event_update_date','{EVENT.UPDATE.DATE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('107','10','event_update_time','{EVENT.UPDATE.TIME}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('108','10','event_update_action','{EVENT.UPDATE.ACTION}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('109','10','event_update_message','{EVENT.UPDATE.MESSAGE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('110','10','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('111','10','event_update_user','{USER.FULLNAME}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('112','10','event_value','{EVENT.VALUE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('113','10','host_ip','{HOST.IP}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('114','10','host_name','{HOST.NAME}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('115','10','trigger_description','{TRIGGER.DESCRIPTION}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('116','10','trigger_id','{TRIGGER.ID}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('117','8','endpoint','https://api.pushover.net/1/messages.json');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('118','8','retry','60');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('119','8','expire','1200');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('120','11','teamsecret','{ALERT.SENDTO}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('121','11','Subject','{ALERT.SUBJECT}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('122','11','Message','{ALERT.MESSAGE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('123','11','Severity','{EVENT.SEVERITY}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('125','11','Hostname','{HOST.NAME}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('127','12','alert_message','{ALERT.MESSAGE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('128','12','alert_subject','{ALERT.SUBJECT}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('129','12','event_recovery_value','{EVENT.RECOVERY.VALUE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('130','12','event_source','{EVENT.SOURCE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('131','12','event_tags_json','{EVENT.TAGSJSON}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('132','12','event_update_action','{EVENT.UPDATE.ACTION}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('133','12','event_update_message','{EVENT.UPDATE.MESSAGE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('134','12','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('135','12','event_update_user','{USER.FULLNAME}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('136','12','event_value','{EVENT.VALUE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('137','12','jira_issue_key','{EVENT.TAGS.__zbx_jira_issuekey}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('138','12','jira_issue_type','<PLACE ISSUETYPE NAME>');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('139','12','jira_password','<PLACE PASSWORD OR TOKEN>');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('140','12','jira_project_key','<PLACE PROJECT KEY>');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('141','12','jira_url','<PLACE YOUR JIRA URL>');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('142','12','jira_user','<PLACE LOGIN>');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('143','12','trigger_description','{TRIGGER.DESCRIPTION}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('144','13','<''DATETIME'' CUSTOMFIELD FOR EVENT RECOVERY TIME>','{EVENT.RECOVERY.DATE}T{EVENT.RECOVERY.TIME}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('145','13','<''DATETIME'' CUSTOMFIELD FOR EVENT TIME>','{EVENT.DATE}T{EVENT.TIME}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('146','13','<''NUMBER'' CUSTOMFIELD FOR EVENT.ID>','{EVENT.ID}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('147','13','<''NUMBER'' CUSTOMFIELD FOR TRIGGER.ID>','{TRIGGER.ID}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('148','13',E'<''STRING'' CUSTOMFIELD FOR HOST\\IP>','{HOST.HOST} [{HOST.IP}]');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('149','13','<''STRING'' CUSTOMFIELD FOR OPERATIONAL DATA>','{EVENT.OPDATA}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('150','13','<''STRING'' CUSTOMFIELD FOR SEVERITY>','{EVENT.SEVERITY}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('151','13','<''URL'' CUSTOMFIELD FOR EVENT URL>','{$ZABBIX.URL}/tr_events.php?triggerid={TRIGGER.ID}&eventid={EVENT.ID}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('152','13','alert_message','{ALERT.MESSAGE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('153','13','alert_subject','{ALERT.SUBJECT}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('154','13','event_recovery_value','{EVENT.RECOVERY.VALUE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('155','13','event_source','{EVENT.SOURCE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('156','13','event_tags_json','{EVENT.TAGSJSON}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('157','13','event_update_action','{EVENT.UPDATE.ACTION}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('158','13','event_update_message','{EVENT.UPDATE.MESSAGE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('159','13','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('160','13','event_update_user','{USER.FULLNAME}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('161','13','event_value','{EVENT.VALUE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('162','13','jira_issue_key','{EVENT.TAGS.__zbx_jira_issuekey}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('163','13','jira_issue_type','<PLACE ISSUETYPE NAME>');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('164','13','jira_password','<PLACE PASSWORD OR TOKEN>');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('165','13','jira_project_key','<PLACE PROJECT KEY>');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('166','13','jira_url','<PLACE YOUR JIRA URL>');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('167','13','jira_user','<PLACE LOGIN>');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('168','13','trigger_description','{TRIGGER.DESCRIPTION}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('169','14','alert_message','{ALERT.MESSAGE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('170','14','alert_subject','{ALERT.SUBJECT}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('171','14','event_date','{EVENT.DATE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('172','14','event_id','{EVENT.ID}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('173','14','event_nseverity','{EVENT.NSEVERITY}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('174','14','event_opdata','{EVENT.OPDATA}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('175','14','event_recovery_date','{EVENT.RECOVERY.DATE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('176','14','event_recovery_time','{EVENT.RECOVERY.TIME}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('177','14','event_severity','{EVENT.SEVERITY}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('178','14','event_source','{EVENT.SOURCE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('179','14','event_status','{EVENT.STATUS}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('180','14','event_tags','{EVENT.TAGS}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('181','14','event_time','{EVENT.TIME}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('182','14','event_update_action','{EVENT.UPDATE.ACTION}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('183','14','event_update_date','{EVENT.UPDATE.DATE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('184','14','event_update_message','{EVENT.UPDATE.MESSAGE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('185','14','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('186','14','event_update_time','{EVENT.UPDATE.TIME}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('187','14','event_update_user','{USER.FULLNAME}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('188','14','event_value','{EVENT.VALUE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('189','14','host_ip','{HOST.IP}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('190','14','host_name','{HOST.NAME}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('191','14','teams_endpoint','<PLACE WEBHOOK URL HERE>');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('192','14','trigger_description','{TRIGGER.DESCRIPTION}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('193','14','trigger_id','{TRIGGER.ID}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('194','14','use_default_message','false');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('195','14','zabbix_url','{$ZABBIX.URL}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('196','15','alert_message','{ALERT.MESSAGE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('197','15','alert_subject','{ALERT.SUBJECT}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('198','15','event_id','{EVENT.ID}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('199','15','event_nseverity','{EVENT.NSEVERITY}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('200','15','event_source','{EVENT.SOURCE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('201','15','event_update_message','{EVENT.UPDATE.MESSAGE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('202','15','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('203','15','event_value','{EVENT.VALUE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('204','15','redmine_access_key','<PUT YOUR ACCESS KEY>');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('205','15','redmine_issue_key','{EVENT.TAGS.__zbx_redmine_issue_id}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('206','15','redmine_project','<PUT YOUR PROJECT ID OR NAME>');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('207','15','redmine_tracker_id','<PUT YOUR TRACKER ID>');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('208','15','redmine_url','<PUT YOUR REDMINE URL>');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('209','15','trigger_id','{TRIGGER.ID}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('210','15','zabbix_url','{$ZABBIX.URL}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('211','16','Message','{ALERT.MESSAGE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('212','16','ParseMode','');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('213','16','Subject','{ALERT.SUBJECT}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('214','16','To','{ALERT.SENDTO}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('215','16','Token','<PLACE YOUR TOKEN>');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('216','17','alert_message','{ALERT.MESSAGE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('217','17','alert_subject','{ALERT.SUBJECT}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('218','17','event_id','{EVENT.ID}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('219','17','event_nseverity','{EVENT.NSEVERITY}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('220','17','event_source','{EVENT.SOURCE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('221','17','event_tags','{EVENT.TAGS}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('222','17','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('223','17','event_value','{EVENT.VALUE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('224','17','severity_average','normal');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('225','17','severity_default','-');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('226','17','severity_disaster','urgent');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('227','17','severity_high','high');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('228','17','severity_information','low');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('229','17','severity_not_classified','low');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('230','17','severity_warning','normal');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('231','17','trigger_id','{TRIGGER.ID}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('232','17','zbxurl','{$ZABBIX.URL}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('233','17','zendesk_issue_key','{EVENT.TAGS.__zbx_zdk_issuekey}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('234','17','zendesk_token','<put your {enduser_email_address}/token:{api_token}>');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('235','17','zendesk_type','incident');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('236','17','zendesk_url','<put your Zendesk URL>');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('237','18','alert_message','{ALERT.MESSAGE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('238','18','alert_subject','{ALERT.SUBJECT}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('239','18','event_nseverity','{EVENT.NSEVERITY}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('240','18','event_recovery_value','{EVENT.RECOVERY.VALUE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('241','18','event_source','{EVENT.SOURCE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('242','18','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('243','18','event_value','{EVENT.VALUE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('244','18','servicenow_password','<PLACE PASSWORD HERE>');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('245','18','servicenow_sys_id','{EVENT.TAGS.__zbx_servicenow_sys_id}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('246','18','servicenow_url','{ALERT.SENDTO}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('247','18','servicenow_user','<PLACE USERNAME HERE>');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('248','18','urgency_for_average','2');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('249','18','urgency_for_disaster','1');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('250','18','urgency_for_high','2');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('251','18','urgency_for_information','3');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('252','18','urgency_for_not_classified','3');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('253','18','urgency_for_warning','3');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('254','19','alert_message','{ALERT.MESSAGE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('255','19','alert_subject','{ALERT.SUBJECT}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('256','19','event_id','{EVENT.ID}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('257','19','event_nseverity','{EVENT.NSEVERITY}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('258','19','event_source','{EVENT.SOURCE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('259','19','event_tags','{EVENT.TAGSJSON}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('260','19','event_update_message','{EVENT.UPDATE.MESSAGE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('261','19','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('262','19','event_value','{EVENT.VALUE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('263','19','trigger_id','{TRIGGER.ID}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('264','19','zabbix_url','{$ZABBIX.URL}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('265','19','zammad_access_token','<PUT YOUR ACCESS TOKEN>');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('266','19','zammad_customer','<PUT YOUR CUSTOMER EMAIL>');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('267','19','zammad_enable_tags','true');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('268','19','zammad_ticket_id','{EVENT.TAGS.__zbx_zammad_ticket_id}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('269','19','zammad_url','<PUT YOUR ZAMMAD URL>');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('270','20','alert_message','{ALERT.MESSAGE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('271','20','alert_subject','{ALERT.SUBJECT}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('272','20','event_recovery_value','{EVENT.RECOVERY.VALUE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('273','20','event_source','{EVENT.SOURCE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('274','20','event_tags_json','{EVENT.TAGSJSON}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('275','20','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('276','20','event_value','{EVENT.VALUE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('277','20','jira_password','<PLACE PASSWORD OR TOKEN>');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('278','20','jira_request_key','{EVENT.TAGS.__zbx_jira_requestkey}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('279','20','jira_request_type_id','<PLACE REQUEST TYPE ID>');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('280','20','jira_servicedesk_id','<PLACE SERVICEDESK ID>');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('281','20','jira_url','<PLACE YOUR JIRA URL>');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('282','20','jira_user','<PLACE LOGIN>');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('283','21','alert_message','{ALERT.MESSAGE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('284','21','alert_subject','{ALERT.SUBJECT}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('285','21','event_id','{EVENT.ID}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('286','21','event_nseverity','{EVENT.NSEVERITY}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('287','21','event_source','{EVENT.SOURCE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('288','21','event_update_message','{EVENT.UPDATE.MESSAGE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('289','21','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('290','21','event_value','{EVENT.VALUE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('291','21','otrs_auth_password','<PUT YOUR USER PASSWORD>');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('292','21','otrs_auth_user','<PUT YOUR USER NAME>');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('293','21','otrs_customer','<PUT YOUR CUSTOMER EMAIL>');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('294','21','otrs_default_priority_id','3');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('295','21','otrs_queue','<PUT YOUR QUEUE NAME>');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('296','21','otrs_ticket_id','{EVENT.TAGS.__zbx_otrs_ticket_id}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('297','21','otrs_ticket_state','new');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('298','21','otrs_time_unit','0');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('299','21','otrs_url','<PUT YOUR OTRS URL>');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('300','21','trigger_id','{TRIGGER.ID}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('301','21','zabbix_url','{$ZABBIX.URL}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('302','11','Event_Ack_Status','{EVENT.ACK.STATUS}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('303','11','Event_Date_Time','{EVENT.DATE} {EVENT.TIME}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('304','11','Event_ID','{EVENT.ID}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('305','11','Event_Update_Action','{EVENT.UPDATE.ACTION}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('306','11','Event_Update_Status','{EVENT.UPDATE.STATUS}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('307','11','Host_IP','{HOST.IP}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('308','11','Trigger_ID','{TRIGGER.ID}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('309','11','Trigger_Status','{TRIGGER.STATUS}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('310','11','User','{USER.FULLNAME}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('311','11','Zabbix_URL','{$ZABBIX.URL}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('312','10','event_source','{EVENT.SOURCE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('313','22','.ILERT.ALERT.SOURCE.KEY','{ALERT.SENDTO}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('314','22','.ILERT.INCIDENT.SUMMARY','');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('315','22','ALERT.MESSAGE','{ALERT.MESSAGE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('316','22','ALERT.SUBJECT','{ALERT.SUBJECT}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('317','22','EVENT.ACK.STATUS','{EVENT.ACK.STATUS}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('318','22','EVENT.DATE','{EVENT.DATE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('319','22','EVENT.ID','{EVENT.ID}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('320','22','EVENT.NAME','{EVENT.NAME}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('321','22','EVENT.NSEVERITY','{EVENT.NSEVERITY}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('322','22','EVENT.OPDATA','{EVENT.OPDATA}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('323','22','EVENT.RECOVERY.DATE','{EVENT.RECOVERY.DATE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('324','22','EVENT.RECOVERY.TIME','{EVENT.RECOVERY.TIME}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('325','22','EVENT.RECOVERY.VALUE','{EVENT.RECOVERY.VALUE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('326','22','EVENT.SEVERITY','{EVENT.SEVERITY}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('327','22','EVENT.TAGS','{EVENT.TAGS}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('328','22','EVENT.TIME','{EVENT.TIME}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('329','22','EVENT.UPDATE.ACTION','{EVENT.UPDATE.ACTION}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('330','22','EVENT.UPDATE.DATE','{EVENT.UPDATE.DATE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('331','22','EVENT.UPDATE.MESSAGE','{EVENT.UPDATE.MESSAGE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('332','22','EVENT.UPDATE.STATUS','{EVENT.UPDATE.STATUS}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('333','22','EVENT.UPDATE.TIME','{EVENT.UPDATE.TIME}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('334','22','EVENT.VALUE','{EVENT.VALUE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('335','22','HOST.HOST','{HOST.HOST}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('336','22','HOST.IP','{HOST.IP}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('337','22','HOST.NAME','{HOST.NAME}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('338','22','ITEM.ID1','{ITEM.ID1}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('339','22','ITEM.ID2','{ITEM.ID2}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('340','22','ITEM.ID3','{ITEM.ID3}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('341','22','ITEM.ID4','{ITEM.ID4}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('342','22','ITEM.ID5','{ITEM.ID5}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('343','22','ITEM.NAME1','{ITEM.NAME1}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('344','22','ITEM.NAME2','{ITEM.NAME2}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('345','22','ITEM.NAME3','{ITEM.NAME3}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('346','22','ITEM.NAME4','{ITEM.NAME4}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('347','22','ITEM.NAME5','{ITEM.NAME5}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('348','22','TRIGGER.DESCRIPTION','{TRIGGER.DESCRIPTION}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('349','22','TRIGGER.ID','{TRIGGER.ID}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('350','22','TRIGGER.NAME','{TRIGGER.NAME}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('351','22','TRIGGER.SEVERITY','{TRIGGER.SEVERITY}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('352','22','TRIGGER.STATUS','{TRIGGER.STATUS}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('353','22','TRIGGER.URL','{TRIGGER.URL}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('354','22','TRIGGER.VALUE','{TRIGGER.VALUE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('355','22','USER.FULLNAME','{USER.FULLNAME}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('356','22','ZABBIX.URL','{$ZABBIX.URL}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('357','5','alert_message','{ALERT.MESSAGE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('358','5','alert_subject','{ALERT.SUBJECT}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('359','5','discovery_host_dns','{DISCOVERY.DEVICE.DNS}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('360','5','discovery_host_ip','{DISCOVERY.DEVICE.IPADDRESS}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('361','5','event_source','{EVENT.SOURCE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('362','6','alert_message','{ALERT.MESSAGE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('363','6','alert_subject','{ALERT.SUBJECT}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('364','6','event_id','{EVENT.ID}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('365','6','event_nseverity','{EVENT.NSEVERITY}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('366','6','event_source','{EVENT.SOURCE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('367','6','event_tags_json','{EVENT.TAGSJSON}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('368','6','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('369','6','event_value','{EVENT.VALUE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('370','6','opsgenie_api','<put your opsgenie api>');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('371','6','opsgenie_tags','');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('372','6','opsgenie_teams','');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('373','6','opsgenie_token','<put your token>');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('374','6','opsgenie_web','<put your opsgenie web>');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('375','6','severity_average','P3');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('376','6','severity_default','P5');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('377','6','severity_disaster','P1');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('378','6','severity_high','P2');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('379','6','severity_information','P5');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('380','6','severity_not_classified','P5');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('381','6','severity_warning','P4');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('382','6','trigger_id','{TRIGGER.ID}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('383','6','zbxuser','{USER.FULLNAME}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('384','7','alert_message','{ALERT.MESSAGE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('385','7','event_source','{EVENT.SOURCE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('386','8','event_nseverity','{EVENT.NSEVERITY}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('387','8','event_source','{EVENT.SOURCE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('388','8','event_value','{EVENT.VALUE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('389','8','priority_average','0');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('390','8','priority_default','0');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('391','8','priority_disaster','0');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('392','8','priority_high','0');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('393','8','priority_information','0');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('394','8','priority_not_classified','0');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('395','8','priority_warning','0');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('396','9','alert_message','{ALERT.MESSAGE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('397','9','alert_subject','{ALERT.SUBJECT}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('398','9','discovery_host_dns','{DISCOVERY.DEVICE.DNS}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('399','9','discovery_host_ip','{DISCOVERY.DEVICE.IPADDRESS}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('400','9','event_source','{EVENT.SOURCE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('401','9','host_conn','{HOST.CONN}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('402','23','alert_message','{ALERT.MESSAGE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('403','23','alert_subject','{ALERT.SUBJECT}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('404','23','event_nseverity','{EVENT.NSEVERITY}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('405','23','event_recovery_value','{EVENT.RECOVERY.VALUE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('406','23','event_source','{EVENT.SOURCE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('407','23','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('408','23','event_value','{EVENT.VALUE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('409','23','priority_average','Medium');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('410','23','priority_default','Low');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('411','23','priority_disaster','Critical');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('412','23','priority_high','High');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('413','23','samanage_incident_id','{EVENT.TAGS.__zbx_solarwinds_inc_id}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('414','23','samanage_token','<PUT YOUR TOKEN HERE>');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('415','23','samanage_url','<PUT YOUR INSTANCE URL HERE>');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('416','24','alert_message','{ALERT.MESSAGE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('417','24','alert_subject','{ALERT.SUBJECT}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('418','24','event_id','{EVENT.ID}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('419','24','event_nseverity','{EVENT.NSEVERITY}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('420','24','event_source','{EVENT.SOURCE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('421','24','event_update_message','{EVENT.UPDATE.MESSAGE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('422','24','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('423','24','event_value','{EVENT.VALUE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('424','24','sysaid_auth_password','<PUT YOUR USER PASSWORD>');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('425','24','sysaid_auth_user','<PUT YOUR USER NAME>');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('426','24','sysaid_category_level_1','<PUT YOUR CATEGORY>');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('427','24','sysaid_category_level_2','<PUT YOUR SUB-CATEGORY>');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('428','24','sysaid_category_level_3','<PUT YOUR THIRD LEVEL CATEGORY>');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('429','24','sysaid_default_priority_id','1');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('430','24','sysaid_incident_id','{EVENT.TAGS.__zbx_sysaid_incident_id}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('431','24','sysaid_incident_state','1');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('432','24','sysaid_template_id','<PUT YOUR TEMPLATE ID>');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('433','24','sysaid_urgency_id','<PUT YOUR URGENCY ID>');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('434','24','sysaid_url','<PUT YOUR SYSAID URL>');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('435','24','trigger_id','{TRIGGER.ID}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('436','24','zabbix_url','{$ZABBIX.URL}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('437','25','alert_message','{ALERT.MESSAGE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('438','25','alert_subject','{ALERT.SUBJECT}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('439','25','event_id','{EVENT.ID}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('440','25','event_nseverity','{EVENT.NSEVERITY}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('441','25','event_source','{EVENT.SOURCE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('442','25','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('443','25','event_value','{EVENT.VALUE}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('444','25','severity_average','P3');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('445','25','severity_default','P5');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('446','25','severity_disaster','P1');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('447','25','severity_high','P2');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('448','25','severity_information','P5');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('449','25','severity_not_classified','P5');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('450','25','severity_warning','P4');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('451','25','topdesk_api','<put your TOPdesk API URL>');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('452','25','topdesk_issue_key','{EVENT.TAGS.__zbx_tpd_issuekey}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('453','25','topdesk_password','<put your TOPdesk application password>');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('454','25','topdesk_status','<put default status for new tickets>');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('455','25','topdesk_user','<put your TOPdesk username>');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('456','25','trigger_id','{TRIGGER.ID}');
INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value) values ('457','25','zbxurl','{$ZABBIX.URL}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('1','1','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}
Problem name: {EVENT.NAME}
Host: {HOST.NAME}
Severity: {EVENT.SEVERITY}
Operational data: {EVENT.OPDATA}
Original problem ID: {EVENT.ID}
{TRIGGER.URL}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('2','1','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}
Problem name: {EVENT.NAME}
Problem duration: {EVENT.DURATION}
Host: {HOST.NAME}
Severity: {EVENT.SEVERITY}
Original problem ID: {EVENT.ID}
{TRIGGER.URL}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('3','1','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.
{EVENT.UPDATE.MESSAGE}

Current problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('4','1','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}

Device IP: {DISCOVERY.DEVICE.IPADDRESS}
Device DNS: {DISCOVERY.DEVICE.DNS}
Device status: {DISCOVERY.DEVICE.STATUS}
Device uptime: {DISCOVERY.DEVICE.UPTIME}

Device service name: {DISCOVERY.SERVICE.NAME}
Device service port: {DISCOVERY.SERVICE.PORT}
Device service status: {DISCOVERY.SERVICE.STATUS}
Device service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('5','1','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}
Host IP: {HOST.IP}
Agent port: {HOST.PORT}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('6','3','0','0','','{EVENT.SEVERITY}: {EVENT.NAME}
Host: {HOST.NAME}
{EVENT.DATE} {EVENT.TIME}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('7','3','0','1','','Resolved in {EVENT.DURATION}: {EVENT.NAME}
Host: {HOST.NAME}
{EVENT.DATE} {EVENT.TIME}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('8','3','0','2','','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem in {EVENT.AGE} at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('9','3','1','0','','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('10','3','2','0','','Autoregistration: {HOST.HOST}
Host IP: {HOST.IP}
Agent port: {HOST.PORT}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('11','4','0','0','Problem: {EVENT.NAME}','<b>Problem started</b> at {EVENT.TIME} on {EVENT.DATE}<br><b>Problem name:</b> {EVENT.NAME}<br><b>Host:</b> {HOST.NAME}<br><b>Severity:</b> {EVENT.SEVERITY}<br><b>Operational data:</b> {EVENT.OPDATA}<br><b>Original problem ID:</b> {EVENT.ID}<br>{TRIGGER.URL}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('12','4','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','<b>Problem has been resolved</b> at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}<br><b>Problem name:</b> {EVENT.NAME}<br><b>Problem duration:</b> {EVENT.DURATION}<br><b>Host:</b> {HOST.NAME}<br><b>Severity:</b> {EVENT.SEVERITY}<br><b>Original problem ID:</b> {EVENT.ID}<br>{TRIGGER.URL}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('13','4','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','<b>{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem</b> at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.<br>{EVENT.UPDATE.MESSAGE}<br><br><b>Current problem status:</b> {EVENT.STATUS}<br><b>Age:</b> {EVENT.AGE}<br><b>Acknowledged:</b> {EVENT.ACK.STATUS}.');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('14','4','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','<b>Discovery rule:</b> {DISCOVERY.RULE.NAME}<br><br><b>Device IP:</b> {DISCOVERY.DEVICE.IPADDRESS}<br><b>Device DNS:</b> {DISCOVERY.DEVICE.DNS}<br><b>Device status:</b> {DISCOVERY.DEVICE.STATUS}<br><b>Device uptime:</b> {DISCOVERY.DEVICE.UPTIME}<br><br><b>Device service name:</b> {DISCOVERY.SERVICE.NAME}<br><b>Device service port:</b> {DISCOVERY.SERVICE.PORT}<br><b>Device service status:</b> {DISCOVERY.SERVICE.STATUS}<br><b>Device service uptime:</b> {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('15','4','2','0','Autoregistration: {HOST.HOST}','<b>Host name:</b> {HOST.HOST}<br><b>Host IP:</b> {HOST.IP}<br><b>Agent port:</b> {HOST.PORT}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('16','11','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}
Problem name: {EVENT.NAME}
Host: {HOST.NAME}
Severity: {EVENT.SEVERITY}
Operational data: {EVENT.OPDATA}
Original problem ID: {EVENT.ID}
{TRIGGER.URL}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('17','11','0','1','Resolved: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}
Problem name: {EVENT.NAME}
Host: {HOST.NAME}
Severity: {EVENT.SEVERITY}
Original problem ID: {EVENT.ID}
{TRIGGER.URL}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('18','11','0','2','Updated problem: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.
{EVENT.UPDATE.MESSAGE}

Current problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('19','11','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}

Device IP: {DISCOVERY.DEVICE.IPADDRESS}
Device DNS: {DISCOVERY.DEVICE.DNS}
Device status: {DISCOVERY.DEVICE.STATUS}
Device uptime: {DISCOVERY.DEVICE.UPTIME}

Device service name: {DISCOVERY.SERVICE.NAME}
Device service port: {DISCOVERY.SERVICE.PORT}
Device service status: {DISCOVERY.SERVICE.STATUS}
Device service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('20','11','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}
Host IP: {HOST.IP}
Agent port: {HOST.PORT}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('21','12','0','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}
Problem name: {EVENT.NAME}
Host: {HOST.NAME}
Severity: {EVENT.SEVERITY}
Operational data: {EVENT.OPDATA}
Original problem ID: {EVENT.ID}
{TRIGGER.URL}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('22','12','0','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}
Problem name: {EVENT.NAME}
Host: {HOST.NAME}
Severity: {EVENT.SEVERITY}
Original problem ID: {EVENT.ID}
{TRIGGER.URL}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('23','12','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.
{EVENT.UPDATE.MESSAGE}

Current problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('24','12','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}

Device IP: {DISCOVERY.DEVICE.IPADDRESS}
Device DNS: {DISCOVERY.DEVICE.DNS}
Device status: {DISCOVERY.DEVICE.STATUS}
Device uptime: {DISCOVERY.DEVICE.UPTIME}

Device service name: {DISCOVERY.SERVICE.NAME}
Device service port: {DISCOVERY.SERVICE.PORT}
Device service status: {DISCOVERY.SERVICE.STATUS}
Device service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('25','12','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}
Host IP: {HOST.IP}
Agent port: {HOST.PORT}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('26','13','0','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}
Problem name: {EVENT.NAME}
Host: {HOST.NAME}
Severity: {EVENT.SEVERITY}
Operational data: {EVENT.OPDATA}
Original problem ID: {EVENT.ID}
{TRIGGER.URL}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('27','13','0','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}
Problem name: {EVENT.NAME}
Host: {HOST.NAME}
Severity: {EVENT.SEVERITY}
Original problem ID: {EVENT.ID}
{TRIGGER.URL}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('28','13','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.
{EVENT.UPDATE.MESSAGE}

Current problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('29','13','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}

Device IP: {DISCOVERY.DEVICE.IPADDRESS}
Device DNS: {DISCOVERY.DEVICE.DNS}
Device status: {DISCOVERY.DEVICE.STATUS}
Device uptime: {DISCOVERY.DEVICE.UPTIME}

Device service name: {DISCOVERY.SERVICE.NAME}
Device service port: {DISCOVERY.SERVICE.PORT}
Device service status: {DISCOVERY.SERVICE.STATUS}
Device service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('30','13','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}
Host IP: {HOST.IP}
Agent port: {HOST.PORT}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('31','14','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}

Device IP: {DISCOVERY.DEVICE.IPADDRESS}
Device DNS: {DISCOVERY.DEVICE.DNS}
Device status: {DISCOVERY.DEVICE.STATUS}
Device uptime: {DISCOVERY.DEVICE.UPTIME}

Device service name: {DISCOVERY.SERVICE.NAME}
Device service port: {DISCOVERY.SERVICE.PORT}
Device service status: {DISCOVERY.SERVICE.STATUS}
Device service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('32','14','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}
Host IP: {HOST.IP}
Agent port: {HOST.PORT}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('33','14','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}
Problem name: {EVENT.NAME}
Host: {HOST.NAME}
Severity: {EVENT.SEVERITY}
Operational data: {EVENT.OPDATA}
Original problem ID: {EVENT.ID}
{TRIGGER.URL}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('34','14','0','1','Resolved: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}
Problem name: {EVENT.NAME}
Host: {HOST.NAME}
Severity: {EVENT.SEVERITY}
Original problem ID: {EVENT.ID}
{TRIGGER.URL}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('35','14','0','2','Updated problem: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.
{EVENT.UPDATE.MESSAGE}

Current problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('36','15','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}
Problem name: {EVENT.NAME}
Host: {HOST.NAME}
Severity: {EVENT.SEVERITY}
Operational data: {EVENT.OPDATA}
Original problem ID: {EVENT.ID}
{TRIGGER.URL}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('37','15','0','1','Resolved: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}
Problem name: {EVENT.NAME}
Host: {HOST.NAME}
Severity: {EVENT.SEVERITY}
Original problem ID: {EVENT.ID}
{TRIGGER.URL}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('38','15','0','2','Updated problem: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.
{EVENT.UPDATE.MESSAGE}

Current problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('39','15','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}

Device IP: {DISCOVERY.DEVICE.IPADDRESS}
Device DNS: {DISCOVERY.DEVICE.DNS}
Device status: {DISCOVERY.DEVICE.STATUS}
Device uptime: {DISCOVERY.DEVICE.UPTIME}

Device service name: {DISCOVERY.SERVICE.NAME}
Device service port: {DISCOVERY.SERVICE.PORT}
Device service status: {DISCOVERY.SERVICE.STATUS}
Device service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('40','15','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}
Host IP: {HOST.IP}
Agent port: {HOST.PORT}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('41','16','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}
Problem name: {EVENT.NAME}
Host: {HOST.NAME}
Severity: {EVENT.SEVERITY}
Operational data: {EVENT.OPDATA}
Original problem ID: {EVENT.ID}
{TRIGGER.URL}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('42','16','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}
Problem name: {EVENT.NAME}
Host: {HOST.NAME}
Severity: {EVENT.SEVERITY}
Original problem ID: {EVENT.ID}
{TRIGGER.URL}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('43','16','0','2','Updated problem: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.
{EVENT.UPDATE.MESSAGE}

Current problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('44','16','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}

Device IP: {DISCOVERY.DEVICE.IPADDRESS}
Device DNS: {DISCOVERY.DEVICE.DNS}
Device status: {DISCOVERY.DEVICE.STATUS}
Device uptime: {DISCOVERY.DEVICE.UPTIME}

Device service name: {DISCOVERY.SERVICE.NAME}
Device service port: {DISCOVERY.SERVICE.PORT}
Device service status: {DISCOVERY.SERVICE.STATUS}
Device service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('45','16','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}
Host IP: {HOST.IP}
Agent port: {HOST.PORT}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('46','17','0','0','{EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}
Problem name: {EVENT.NAME}
Host: {HOST.NAME}
Severity: {EVENT.SEVERITY}
Operational data: {EVENT.OPDATA}
Original problem ID: {EVENT.ID}
{TRIGGER.URL}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('47','17','0','1','{EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}
Problem name: {EVENT.NAME}
Host: {HOST.NAME}
Severity: {EVENT.SEVERITY}
Operational data: {EVENT.OPDATA}
Original problem ID: {EVENT.ID}
{TRIGGER.URL}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('48','17','0','2','{EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.
{EVENT.UPDATE.MESSAGE}

Current problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('49','17','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}

Device IP: {DISCOVERY.DEVICE.IPADDRESS}
Device DNS: {DISCOVERY.DEVICE.DNS}
Device status: {DISCOVERY.DEVICE.STATUS}
Device uptime: {DISCOVERY.DEVICE.UPTIME}

Device service name: {DISCOVERY.SERVICE.NAME}
Device service port: {DISCOVERY.SERVICE.PORT}
Device service status: {DISCOVERY.SERVICE.STATUS}
Device service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('50','17','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}
Host IP: {HOST.IP}
Agent port: {HOST.PORT}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('51','17','3','0','Internal problem: {EVENT.NAME}','Internal problem started at {EVENT.TIME} on {EVENT.DATE}
Problem name: {EVENT.NAME}
Host: {HOST.NAME}
Operational data: {EVENT.OPDATA}
Original problem ID: {EVENT.ID}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('52','18','0','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}
Problem name: {EVENT.NAME}
Host: {HOST.NAME}
Severity: {EVENT.SEVERITY}
Operational data: {EVENT.OPDATA}
Original problem ID: {EVENT.ID}
{TRIGGER.URL}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('53','18','0','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}
Problem name: {EVENT.NAME}
Host: {HOST.NAME}
Severity: {EVENT.SEVERITY}
Original problem ID: {EVENT.ID}
{TRIGGER.URL}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('54','18','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.
{EVENT.UPDATE.MESSAGE}

Current problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('55','18','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}

Device IP: {DISCOVERY.DEVICE.IPADDRESS}
Device DNS: {DISCOVERY.DEVICE.DNS}
Device status: {DISCOVERY.DEVICE.STATUS}
Device uptime: {DISCOVERY.DEVICE.UPTIME}

Device service name: {DISCOVERY.SERVICE.NAME}
Device service port: {DISCOVERY.SERVICE.PORT}
Device service status: {DISCOVERY.SERVICE.STATUS}
Device service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('56','18','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}
Host IP: {HOST.IP}
Agent port: {HOST.PORT}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('57','19','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}
Problem name: {EVENT.NAME}
Host: {HOST.NAME}
Severity: {EVENT.SEVERITY}
Operational data: {EVENT.OPDATA}
Original problem ID: {EVENT.ID}
{TRIGGER.URL}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('58','19','0','1','Resolved: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}
Problem name: {EVENT.NAME}
Host: {HOST.NAME}
Severity: {EVENT.SEVERITY}
Original problem ID: {EVENT.ID}
{TRIGGER.URL}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('59','19','0','2','Updated problem: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.
{EVENT.UPDATE.MESSAGE}

Current problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('60','19','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}

Device IP: {DISCOVERY.DEVICE.IPADDRESS}
Device DNS: {DISCOVERY.DEVICE.DNS}
Device status: {DISCOVERY.DEVICE.STATUS}
Device uptime: {DISCOVERY.DEVICE.UPTIME}

Device service name: {DISCOVERY.SERVICE.NAME}
Device service port: {DISCOVERY.SERVICE.PORT}
Device service status: {DISCOVERY.SERVICE.STATUS}
Device service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('61','19','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}
Host IP: {HOST.IP}
Agent port: {HOST.PORT}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('62','20','0','0','{EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}
Problem name: {EVENT.NAME}
Host: {HOST.NAME}
Severity: {EVENT.SEVERITY}
Operational data: {EVENT.OPDATA}
Original problem ID: {EVENT.ID}
{TRIGGER.URL}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('63','20','0','1','{EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}
Problem name: {EVENT.NAME}
Host: {HOST.NAME}
Severity: {EVENT.SEVERITY}
Original problem ID: {EVENT.ID}
{TRIGGER.URL}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('64','20','0','2','{EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.
{EVENT.UPDATE.MESSAGE}

Current problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('65','20','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}

Device IP: {DISCOVERY.DEVICE.IPADDRESS}
Device DNS: {DISCOVERY.DEVICE.DNS}
Device status: {DISCOVERY.DEVICE.STATUS}
Device uptime: {DISCOVERY.DEVICE.UPTIME}

Device service name: {DISCOVERY.SERVICE.NAME}
Device service port: {DISCOVERY.SERVICE.PORT}
Device service status: {DISCOVERY.SERVICE.STATUS}
Device service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('66','20','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}
Host IP: {HOST.IP}
Agent port: {HOST.PORT}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('67','21','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}
Problem name: {EVENT.NAME}
Host: {HOST.NAME}
Severity: {EVENT.SEVERITY}
Operational data: {EVENT.OPDATA}
Original problem ID: {EVENT.ID}
{TRIGGER.URL}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('68','21','0','1','Resolved: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}
Problem name: {EVENT.NAME}
Host: {HOST.NAME}
Severity: {EVENT.SEVERITY}
Original problem ID: {EVENT.ID}
{TRIGGER.URL}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('69','21','0','2','Updated problem: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.
{EVENT.UPDATE.MESSAGE}

Current problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('70','21','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}

Device IP: {DISCOVERY.DEVICE.IPADDRESS}
Device DNS: {DISCOVERY.DEVICE.DNS}
Device status: {DISCOVERY.DEVICE.STATUS}
Device uptime: {DISCOVERY.DEVICE.UPTIME}

Device service name: {DISCOVERY.SERVICE.NAME}
Device service port: {DISCOVERY.SERVICE.PORT}
Device service status: {DISCOVERY.SERVICE.STATUS}
Device service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('71','21','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}
Host IP: {HOST.IP}
Agent port: {HOST.PORT}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('72','10','0','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}
Problem name: {EVENT.NAME}
Host: {HOST.NAME}
Severity: {EVENT.SEVERITY}
Operational data: {EVENT.OPDATA}
Original problem ID: {EVENT.ID}
{TRIGGER.URL}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('73','10','0','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}
Problem name: {EVENT.NAME}
Host: {HOST.NAME}
Severity: {EVENT.SEVERITY}
Original problem ID: {EVENT.ID}
{TRIGGER.URL}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('74','10','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.
{EVENT.UPDATE.MESSAGE}

Current problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('75','10','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}

Device IP: {DISCOVERY.DEVICE.IPADDRESS}
Device DNS: {DISCOVERY.DEVICE.DNS}
Device status: {DISCOVERY.DEVICE.STATUS}
Device uptime: {DISCOVERY.DEVICE.UPTIME}

Device service name: {DISCOVERY.SERVICE.NAME}
Device service port: {DISCOVERY.SERVICE.PORT}
Device service status: {DISCOVERY.SERVICE.STATUS}
Device service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('76','10','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}
Host IP: {HOST.IP}
Agent port: {HOST.PORT}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('77','22','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}
Problem name: {EVENT.NAME}
Host: {HOST.NAME}
Severity: {EVENT.SEVERITY}
Operational data: {EVENT.OPDATA}
Original problem ID: {EVENT.ID}
{TRIGGER.URL}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('78','22','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.
{EVENT.UPDATE.MESSAGE}

Current problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('79','22','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}
Problem name: {EVENT.NAME}
Problem duration: {EVENT.DURATION}
Host: {HOST.NAME}
Severity: {EVENT.SEVERITY}
Original problem ID: {EVENT.ID}
{TRIGGER.URL}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('80','5','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}
Problem name: {EVENT.NAME}
Host: {HOST.NAME}
Severity: {EVENT.SEVERITY}
Operational data: {EVENT.OPDATA}
Original problem ID: {EVENT.ID}
{TRIGGER.URL}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('81','5','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}
Problem name: {EVENT.NAME}
Problem duration: {EVENT.DURATION}
Host: {HOST.NAME}
Severity: {EVENT.SEVERITY}
Original problem ID: {EVENT.ID}
{TRIGGER.URL}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('82','5','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.
{EVENT.UPDATE.MESSAGE}

Current problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('83','5','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}

Device IP: {DISCOVERY.DEVICE.IPADDRESS}
Device DNS: {DISCOVERY.DEVICE.DNS}
Device status: {DISCOVERY.DEVICE.STATUS}
Device uptime: {DISCOVERY.DEVICE.UPTIME}

Device service name: {DISCOVERY.SERVICE.NAME}
Device service port: {DISCOVERY.SERVICE.PORT}
Device service status: {DISCOVERY.SERVICE.STATUS}
Device service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('84','5','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}
Host IP: {HOST.IP}
Agent port: {HOST.PORT}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('85','6','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}
Problem name: {EVENT.NAME}
Host: {HOST.NAME}
Severity: {EVENT.SEVERITY}
Operational data: {EVENT.OPDATA}
Original problem ID: {EVENT.ID}
{TRIGGER.URL}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('86','6','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.
{EVENT.UPDATE.MESSAGE}

Current problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('87','6','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}

Device IP: {DISCOVERY.DEVICE.IPADDRESS}
Device DNS: {DISCOVERY.DEVICE.DNS}
Device status: {DISCOVERY.DEVICE.STATUS}
Device uptime: {DISCOVERY.DEVICE.UPTIME}

Device service name: {DISCOVERY.SERVICE.NAME}
Device service port: {DISCOVERY.SERVICE.PORT}
Device service status: {DISCOVERY.SERVICE.STATUS}
Device service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('88','6','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}
Host IP: {HOST.IP}
Agent port: {HOST.PORT}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('89','6','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}
Problem name: {EVENT.NAME}
Problem duration: {EVENT.DURATION}
Host: {HOST.NAME}
Severity: {EVENT.SEVERITY}
Original problem ID: {EVENT.ID}
{TRIGGER.URL}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('90','7','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}
Problem name: {EVENT.NAME}
Host: {HOST.NAME}
Severity: {EVENT.SEVERITY}
Operational data: {EVENT.OPDATA}
Original problem ID: {EVENT.ID}
{TRIGGER.URL}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('91','7','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}
Problem name: {EVENT.NAME}
Problem duration: {EVENT.DURATION}
Host: {HOST.NAME}
Severity: {EVENT.SEVERITY}
Original problem ID: {EVENT.ID}
{TRIGGER.URL}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('92','7','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.
{EVENT.UPDATE.MESSAGE}

Current problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('93','7','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}

Device IP: {DISCOVERY.DEVICE.IPADDRESS}
Device DNS: {DISCOVERY.DEVICE.DNS}
Device status: {DISCOVERY.DEVICE.STATUS}
Device uptime: {DISCOVERY.DEVICE.UPTIME}

Device service name: {DISCOVERY.SERVICE.NAME}
Device service port: {DISCOVERY.SERVICE.PORT}
Device service status: {DISCOVERY.SERVICE.STATUS}
Device service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('94','7','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}
Host IP: {HOST.IP}
Agent port: {HOST.PORT}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('95','8','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}
Problem name: {EVENT.NAME}
Host: {HOST.NAME}
Severity: {EVENT.SEVERITY}
Operational data: {EVENT.OPDATA}
Original problem ID: {EVENT.ID}
{TRIGGER.URL}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('96','8','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}
Problem name: {EVENT.NAME}
Problem duration: {EVENT.DURATION}
Host: {HOST.NAME}
Severity: {EVENT.SEVERITY}
Original problem ID: {EVENT.ID}
{TRIGGER.URL}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('97','8','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.
{EVENT.UPDATE.MESSAGE}

Current problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('98','8','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}

Device IP: {DISCOVERY.DEVICE.IPADDRESS}
Device DNS: {DISCOVERY.DEVICE.DNS}
Device status: {DISCOVERY.DEVICE.STATUS}
Device uptime: {DISCOVERY.DEVICE.UPTIME}

Device service name: {DISCOVERY.SERVICE.NAME}
Device service port: {DISCOVERY.SERVICE.PORT}
Device service status: {DISCOVERY.SERVICE.STATUS}
Device service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('99','8','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}
Host IP: {HOST.IP}
Agent port: {HOST.PORT}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('100','9','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}
Problem name: {EVENT.NAME}
Host: {HOST.NAME}
Severity: {EVENT.SEVERITY}
Operational data: {EVENT.OPDATA}
Original problem ID: {EVENT.ID}
{TRIGGER.URL}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('101','9','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}
Problem name: {EVENT.NAME}
Problem duration: {EVENT.DURATION}
Host: {HOST.NAME}
Severity: {EVENT.SEVERITY}
Original problem ID: {EVENT.ID}
{TRIGGER.URL}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('102','9','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.
{EVENT.UPDATE.MESSAGE}

Current problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('103','9','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}

Device IP: {DISCOVERY.DEVICE.IPADDRESS}
Device DNS: {DISCOVERY.DEVICE.DNS}
Device status: {DISCOVERY.DEVICE.STATUS}
Device uptime: {DISCOVERY.DEVICE.UPTIME}

Device service name: {DISCOVERY.SERVICE.NAME}
Device service port: {DISCOVERY.SERVICE.PORT}
Device service status: {DISCOVERY.SERVICE.STATUS}
Device service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('104','9','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}
Host IP: {HOST.IP}
Agent port: {HOST.PORT}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('105','23','0','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}
Problem name: {EVENT.NAME}
Host: {HOST.NAME}
Severity: {EVENT.SEVERITY}
Operational data: {EVENT.OPDATA}
Original problem ID: {EVENT.ID}

Trigger description: {TRIGGER.DESCRIPTION}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('106','23','0','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}
Problem name: {EVENT.NAME}
Host: {HOST.NAME}
Severity: {EVENT.SEVERITY}
Original problem ID: {EVENT.ID}
{TRIGGER.URL}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('107','23','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.
{EVENT.UPDATE.MESSAGE}

Current problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('108','23','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}

Device IP: {DISCOVERY.DEVICE.IPADDRESS}
Device DNS: {DISCOVERY.DEVICE.DNS}
Device status: {DISCOVERY.DEVICE.STATUS}
Device uptime: {DISCOVERY.DEVICE.UPTIME}

Device service name: {DISCOVERY.SERVICE.NAME}
Device service port: {DISCOVERY.SERVICE.PORT}
Device service status: {DISCOVERY.SERVICE.STATUS}
Device service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('109','23','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}
Host IP: {HOST.IP}
Agent port: {HOST.PORT}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('110','24','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}
Problem name: {EVENT.NAME}
Host: {HOST.NAME}
Severity: {EVENT.SEVERITY}
Operational data: {EVENT.OPDATA}
Original problem ID: {EVENT.ID}
{TRIGGER.URL}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('111','24','0','1','Resolved: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}
Problem name: {EVENT.NAME}
Host: {HOST.NAME}
Severity: {EVENT.SEVERITY}
Original problem ID: {EVENT.ID}
{TRIGGER.URL}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('112','24','0','2','Updated problem: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.
{EVENT.UPDATE.MESSAGE}

Current problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('113','24','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}

Device IP: {DISCOVERY.DEVICE.IPADDRESS}
Device DNS: {DISCOVERY.DEVICE.DNS}
Device status: {DISCOVERY.DEVICE.STATUS}
Device uptime: {DISCOVERY.DEVICE.UPTIME}

Device service name: {DISCOVERY.SERVICE.NAME}
Device service port: {DISCOVERY.SERVICE.PORT}
Device service status: {DISCOVERY.SERVICE.STATUS}
Device service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('114','24','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}
Host IP: {HOST.IP}
Agent port: {HOST.PORT}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('115','25','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}
Problem name: {EVENT.NAME}
Host: {HOST.NAME}
Severity: {EVENT.SEVERITY}
Operational data: {EVENT.OPDATA}
Original problem ID: {EVENT.ID}
{TRIGGER.URL}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('116','25','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}
Problem name: {EVENT.NAME}
Problem duration: {EVENT.DURATION}
Host: {HOST.NAME}
Severity: {EVENT.SEVERITY}
Original problem ID: {EVENT.ID}
{TRIGGER.URL}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('117','25','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.
{EVENT.UPDATE.MESSAGE}

Current problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('118','25','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}

Device IP: {DISCOVERY.DEVICE.IPADDRESS}
Device DNS: {DISCOVERY.DEVICE.DNS}
Device status: {DISCOVERY.DEVICE.STATUS}
Device uptime: {DISCOVERY.DEVICE.UPTIME}

Device service name: {DISCOVERY.SERVICE.NAME}
Device service port: {DISCOVERY.SERVICE.PORT}
Device service status: {DISCOVERY.SERVICE.STATUS}
Device service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message) values ('119','25','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}
Host IP: {HOST.IP}
Agent port: {HOST.PORT}');
INSERT INTO usrgrp (usrgrpid,name,gui_access,users_status,debug_mode) values ('7','Zabbix administrators','0','0','0');
INSERT INTO usrgrp (usrgrpid,name,gui_access,users_status,debug_mode) values ('8','Guests','1','0','0');
INSERT INTO usrgrp (usrgrpid,name,gui_access,users_status,debug_mode) values ('9','Disabled','0','1','0');
INSERT INTO usrgrp (usrgrpid,name,gui_access,users_status,debug_mode) values ('11','Enabled debug mode','0','0','1');
INSERT INTO usrgrp (usrgrpid,name,gui_access,users_status,debug_mode) values ('12','No access to the frontend','3','0','0');
INSERT INTO users_groups (id,usrgrpid,userid) values ('2','8','2');
INSERT INTO users_groups (id,usrgrpid,userid) values ('3','9','2');
INSERT INTO users_groups (id,usrgrpid,userid) values ('4','7','1');
INSERT INTO scripts (scriptid,name,command,host_access,usrgrpid,groupid,description,confirmation,type,execute_on) values ('1','Ping','ping -c 3 {HOST.CONN}; case $? in [01]) true;; *) false;; esac','2',NULL,NULL,'','','0','2');
INSERT INTO scripts (scriptid,name,command,host_access,usrgrpid,groupid,description,confirmation,type,execute_on) values ('2','Traceroute','/usr/sbin/traceroute {HOST.CONN}','2',NULL,NULL,'','','0','2');
INSERT INTO scripts (scriptid,name,command,host_access,usrgrpid,groupid,description,confirmation,type,execute_on) values ('3','Detect operating system','sudo /usr/local/bin/nmap -O {HOST.CONN}','2','7',NULL,'','','0','2');
INSERT INTO actions (actionid,name,eventsource,evaltype,status,esc_period,formula,pause_suppressed) values ('2','Auto discovery. Linux servers.','1','0','1','0','','1');
INSERT INTO actions (actionid,name,eventsource,evaltype,status,esc_period,formula,pause_suppressed) values ('3','Report problems to Zabbix administrators','0','0','1','1h','','1');
INSERT INTO actions (actionid,name,eventsource,evaltype,status,esc_period,formula,pause_suppressed) values ('4','Report not supported items','3','0','1','1h','','1');
INSERT INTO actions (actionid,name,eventsource,evaltype,status,esc_period,formula,pause_suppressed) values ('5','Report not supported low level discovery rules','3','0','1','1h','','1');
INSERT INTO actions (actionid,name,eventsource,evaltype,status,esc_period,formula,pause_suppressed) values ('6','Report unknown triggers','3','0','1','1h','','1');
INSERT INTO operations (operationid,actionid,operationtype,esc_period,esc_step_from,esc_step_to,evaltype,recovery) values ('1','2','6','0','1','1','0','0');
INSERT INTO operations (operationid,actionid,operationtype,esc_period,esc_step_from,esc_step_to,evaltype,recovery) values ('2','2','4','0','1','1','0','0');
INSERT INTO operations (operationid,actionid,operationtype,esc_period,esc_step_from,esc_step_to,evaltype,recovery) values ('3','3','0','0','1','1','0','0');
INSERT INTO operations (operationid,actionid,operationtype,esc_period,esc_step_from,esc_step_to,evaltype,recovery) values ('4','4','0','0','1','1','0','0');
INSERT INTO operations (operationid,actionid,operationtype,esc_period,esc_step_from,esc_step_to,evaltype,recovery) values ('5','5','0','0','1','1','0','0');
INSERT INTO operations (operationid,actionid,operationtype,esc_period,esc_step_from,esc_step_to,evaltype,recovery) values ('6','6','0','0','1','1','0','0');
INSERT INTO operations (operationid,actionid,operationtype,esc_period,esc_step_from,esc_step_to,evaltype,recovery) values ('7','3','11','0','1','1','0','1');
INSERT INTO operations (operationid,actionid,operationtype,esc_period,esc_step_from,esc_step_to,evaltype,recovery) values ('8','4','11','0','1','1','0','1');
INSERT INTO operations (operationid,actionid,operationtype,esc_period,esc_step_from,esc_step_to,evaltype,recovery) values ('9','5','11','0','1','1','0','1');
INSERT INTO operations (operationid,actionid,operationtype,esc_period,esc_step_from,esc_step_to,evaltype,recovery) values ('10','6','11','0','1','1','0','1');
INSERT INTO opmessage (operationid,default_msg,subject,message,mediatypeid) values ('3','1','','',NULL);
INSERT INTO opmessage (operationid,default_msg,subject,message,mediatypeid) values ('4','1','','',NULL);
INSERT INTO opmessage (operationid,default_msg,subject,message,mediatypeid) values ('5','1','','',NULL);
INSERT INTO opmessage (operationid,default_msg,subject,message,mediatypeid) values ('6','1','','',NULL);
INSERT INTO opmessage (operationid,default_msg,subject,message,mediatypeid) values ('7','1','','',NULL);
INSERT INTO opmessage (operationid,default_msg,subject,message,mediatypeid) values ('8','1','','',NULL);
INSERT INTO opmessage (operationid,default_msg,subject,message,mediatypeid) values ('9','1','','',NULL);
INSERT INTO opmessage (operationid,default_msg,subject,message,mediatypeid) values ('10','1','','',NULL);
INSERT INTO opmessage_grp (opmessage_grpid,operationid,usrgrpid) values ('1','3','7');
INSERT INTO opmessage_grp (opmessage_grpid,operationid,usrgrpid) values ('2','4','7');
INSERT INTO opmessage_grp (opmessage_grpid,operationid,usrgrpid) values ('3','5','7');
INSERT INTO opmessage_grp (opmessage_grpid,operationid,usrgrpid) values ('4','6','7');
INSERT INTO opgroup (opgroupid,operationid,groupid) values ('1','2','2');
INSERT INTO conditions (conditionid,actionid,conditiontype,operator,value,value2) values ('2','2','10','0','0','');
INSERT INTO conditions (conditionid,actionid,conditiontype,operator,value,value2) values ('3','2','8','0','9','');
INSERT INTO conditions (conditionid,actionid,conditiontype,operator,value,value2) values ('4','2','12','2','Linux','');
INSERT INTO conditions (conditionid,actionid,conditiontype,operator,value,value2) values ('6','4','23','0','0','');
INSERT INTO conditions (conditionid,actionid,conditiontype,operator,value,value2) values ('7','5','23','0','2','');
INSERT INTO conditions (conditionid,actionid,conditiontype,operator,value,value2) values ('8','6','23','0','4','');
INSERT INTO config (configid,refresh_unsupported,work_period,alert_usrgrpid,discovery_groupid) values ('1','10m','1-5,09:00-18:00','7','5');
INSERT INTO graph_theme (graphthemeid,theme,backgroundcolor,graphcolor,gridcolor,maingridcolor,gridbordercolor,textcolor,highlightcolor,leftpercentilecolor,rightpercentilecolor,nonworktimecolor,colorpalette) values ('1','blue-theme','FFFFFF','FFFFFF','CCD5D9','ACBBC2','ACBBC2','1F2C33','E33734','429E47','E33734','EBEBEB','1A7C11,F63100,2774A4,A54F10,FC6EA3,6C59DC,AC8C14,611F27,F230E0,5CCD18,BB2A02,5A2B57,89ABF8,7EC25C,274482,2B5429,8048B4,FD5434,790E1F,87AC4D,E89DF4');
INSERT INTO graph_theme (graphthemeid,theme,backgroundcolor,graphcolor,gridcolor,maingridcolor,gridbordercolor,textcolor,highlightcolor,leftpercentilecolor,rightpercentilecolor,nonworktimecolor,colorpalette) values ('2','dark-theme','2B2B2B','2B2B2B','454545','4F4F4F','4F4F4F','F2F2F2','E45959','59DB8F','E45959','333333','199C0D,F63100,2774A4,F7941D,FC6EA3,6C59DC,C7A72D,BA2A5D,F230E0,5CCD18,BB2A02,AC41A5,89ABF8,7EC25C,3165D5,79A277,AA73DE,FD5434,F21C3E,87AC4D,E89DF4');
INSERT INTO graph_theme (graphthemeid,theme,backgroundcolor,graphcolor,gridcolor,maingridcolor,gridbordercolor,textcolor,highlightcolor,leftpercentilecolor,rightpercentilecolor,nonworktimecolor,colorpalette) values ('3','hc-light','FFFFFF','FFFFFF','555555','000000','333333','000000','333333','000000','000000','EBEBEB','1A7C11,F63100,2774A4,A54F10,FC6EA3,6C59DC,AC8C14,611F27,F230E0,5CCD18,BB2A02,5A2B57,89ABF8,7EC25C,274482,2B5429,8048B4,FD5434,790E1F,87AC4D,E89DF4');
INSERT INTO graph_theme (graphthemeid,theme,backgroundcolor,graphcolor,gridcolor,maingridcolor,gridbordercolor,textcolor,highlightcolor,leftpercentilecolor,rightpercentilecolor,nonworktimecolor,colorpalette) values ('4','hc-dark','000000','000000','666666','888888','4F4F4F','FFFFFF','FFFFFF','FFFFFF','FFFFFF','333333','199C0D,F63100,2774A4,F7941D,FC6EA3,6C59DC,C7A72D,BA2A5D,F230E0,5CCD18,BB2A02,AC41A5,89ABF8,7EC25C,3165D5,79A277,AA73DE,FD5434,F21C3E,87AC4D,E89DF4');
INSERT INTO globalmacro (globalmacroid,macro,value,description,type) values ('2','{$SNMP_COMMUNITY}','public','','0');
INSERT INTO regexps (regexpid,name,test_string) values ('1','File systems for discovery','ext3');
INSERT INTO regexps (regexpid,name,test_string) values ('2','Network interfaces for discovery','eth0');
INSERT INTO regexps (regexpid,name,test_string) values ('3','Storage devices for SNMP discovery','/boot');
INSERT INTO regexps (regexpid,name,test_string) values ('4','Windows service names for discovery','SysmonLog');
INSERT INTO regexps (regexpid,name,test_string) values ('5','Windows service startup states for discovery','automatic');
INSERT INTO expressions (expressionid,regexpid,expression,expression_type,exp_delimiter,case_sensitive) values ('1','1','^(btrfs|ext2|ext3|ext4|reiser|xfs|ffs|ufs|jfs|jfs2|vxfs|hfs|apfs|refs|ntfs|fat32|zfs)$','3',',','0');
INSERT INTO expressions (expressionid,regexpid,expression,expression_type,exp_delimiter,case_sensitive) values ('3','3','^(Physical memory|Virtual memory|Memory buffers|Cached memory|Swap space)$','4',',','1');
INSERT INTO expressions (expressionid,regexpid,expression,expression_type,exp_delimiter,case_sensitive) values ('5','4','^(MMCSS|gupdate|SysmonLog|clr_optimization_v2.0.50727_32|clr_optimization_v4.0.30319_32)$','4',',','1');
INSERT INTO expressions (expressionid,regexpid,expression,expression_type,exp_delimiter,case_sensitive) values ('6','5','^(automatic|automatic delayed)$','3',',','1');
INSERT INTO expressions (expressionid,regexpid,expression,expression_type,exp_delimiter,case_sensitive) values ('7','2','^Software Loopback Interface','4',',','1');
INSERT INTO expressions (expressionid,regexpid,expression,expression_type,exp_delimiter,case_sensitive) values ('8','2','^(In)?[Ll]oop[Bb]ack[0-9._]*$','4',',','1');
INSERT INTO expressions (expressionid,regexpid,expression,expression_type,exp_delimiter,case_sensitive) values ('9','2','^NULL[0-9.]*$','4',',','1');
INSERT INTO expressions (expressionid,regexpid,expression,expression_type,exp_delimiter,case_sensitive) values ('10','2','^[Ll]o[0-9.]*$','4',',','1');
INSERT INTO expressions (expressionid,regexpid,expression,expression_type,exp_delimiter,case_sensitive) values ('11','2','^[Ss]ystem$','4',',','1');
INSERT INTO expressions (expressionid,regexpid,expression,expression_type,exp_delimiter,case_sensitive) values ('12','2','^Nu[0-9.]*$','4',',','1');
INSERT INTO config_autoreg_tls (autoreg_tlsid,tls_psk_identity,tls_psk) values ('1','','');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10001',NULL,'Template OS Linux by Zabbix agent','3','-1','2','','','Template OS Linux by Zabbix agent','0',NULL,'Official Linux template. Requires agent of Zabbix 3.0.14, 3.4.5 and 4.0.0 or newer.

Known Issues:

  Description: Network discovery. Zabbix agent as of 4.2 doesn''t support items such as net.if.status, net.if.speed.

You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387225-discussion-thread-for-official-zabbix-template-for-linux

Template tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10047',NULL,'Template App Zabbix Server','3','-1','2','','','Template App Zabbix Server','0',NULL,'','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10048',NULL,'Template App Zabbix Proxy','3','-1','2','','','Template App Zabbix Proxy','0',NULL,'','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10050',NULL,'Template Module Zabbix agent','3','-1','2','','','Template Module Zabbix agent','0',NULL,'Use this template for agents reachable from Zabbix server/proxy (passive mode).

Template tooling version used: 0.34','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10074',NULL,'Template OS OpenBSD','3','-1','2','','','Template OS OpenBSD','0',NULL,'','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10075',NULL,'Template OS FreeBSD','3','-1','2','','','Template OS FreeBSD','0',NULL,'','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10076',NULL,'Template OS AIX','3','-1','2','','','Template OS AIX','0',NULL,'','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10077',NULL,'Template OS HP-UX','3','-1','2','','','Template OS HP-UX','0',NULL,'','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10078',NULL,'Template OS Solaris','3','-1','2','','','Template OS Solaris','0',NULL,'','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10079',NULL,'Template OS Mac OS X','3','-1','2','','','Template OS Mac OS X','0',NULL,'','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10081',NULL,'Template OS Windows by Zabbix agent','3','-1','2','','','Template OS Windows by Zabbix agent','0',NULL,'Official Windows template. Requires agent of Zabbix 4.4 and newer.


You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387224-discussion-thread-for-official-zabbix-template-for-windows

Template tooling version used: 0.37','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10084',NULL,'Zabbix server','0','-1','2','','','Zabbix server','0',NULL,'','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10093',NULL,'Template App FTP Service','3','-1','2','','','Template App FTP Service','0',NULL,'','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10094',NULL,'Template App HTTP Service','3','-1','2','','','Template App HTTP Service','0',NULL,'','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10095',NULL,'Template App HTTPS Service','3','-1','2','','','Template App HTTPS Service','0',NULL,'','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10096',NULL,'Template App IMAP Service','3','-1','2','','','Template App IMAP Service','0',NULL,'','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10097',NULL,'Template App LDAP Service','3','-1','2','','','Template App LDAP Service','0',NULL,'','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10098',NULL,'Template App NNTP Service','3','-1','2','','','Template App NNTP Service','0',NULL,'','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10099',NULL,'Template App NTP Service','3','-1','2','','','Template App NTP Service','0',NULL,'','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10100',NULL,'Template App POP Service','3','-1','2','','','Template App POP Service','0',NULL,'','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10101',NULL,'Template App SMTP Service','3','-1','2','','','Template App SMTP Service','0',NULL,'','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10102',NULL,'Template App SSH Service','3','-1','2','','','Template App SSH Service','0',NULL,'','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10103',NULL,'Template App Telnet Service','3','-1','2','','','Template App Telnet Service','0',NULL,'','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10169',NULL,'Template App Generic Java JMX','3','-1','2','','','Template App Generic Java JMX','0',NULL,'Template tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10170',NULL,'Template DB MySQL','3','-1','2','','','Template DB MySQL','0',NULL,E'Requirements for template operation:
1.Install Zabbix agent and MySQL client.
2.Copy Template_DB_MySQL.conf into folder with Zabbix agent configuration (/etc/zabbix/zabbix_agentd.d/ by default). Don''t forget restart zabbix-agent. 
3.Create MySQL user for monitoring. For example:
CREATE USER ''zbx_monitor''@''%'' IDENTIFIED BY ''<password>'';
GRANT USAGE,REPLICATION CLIENT,PROCESS,SHOW DATABASES,SHOW VIEW ON *.* TO ''zbx_monitor''@''%'';
For more information read the MYSQL documentation https://dev.mysql.com/doc/refman/8.0/en/grant.html , please. 
4.Create .my.cnf in home directory of Zabbix agent for Linux (/var/lib/zabbix by default ) or my.cnf in c:\\ for Windows. For example:
[client]
user=zbx_monitor
password=<password>','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10171',NULL,'Template Server Intel SR1530 IPMI','3','-1','2','','','Template Server Intel SR1530 IPMI','0',NULL,'','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10172',NULL,'Template Server Intel SR1630 IPMI','3','-1','2','','','Template Server Intel SR1630 IPMI','0',NULL,'','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10173',NULL,'Template VM VMware','3','-1','2','','','Template VM VMware','0',NULL,'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/

Template tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10174',NULL,'Template VM VMware Guest','3','-1','2','','','Template VM VMware Guest','0',NULL,'Template tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10175',NULL,'Template VM VMware Hypervisor','3','-1','2','','','Template VM VMware Hypervisor','0',NULL,'Template tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10183',NULL,'Template Module EtherLike-MIB SNMP','3','-1','2','','','Template Module EtherLike-MIB SNMP','0',NULL,'Template EtherLike-MIB (duplex control only)

MIBs used:
EtherLike-MIB

Template tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10185',NULL,'Template Module HOST-RESOURCES-MIB SNMP','3','-1','2','','','Template Module HOST-RESOURCES-MIB SNMP','0',NULL,'HOST-RESOURCES-MIB: CPU, memory and storage(vfs.fs.file) linked together.

Template tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10186',NULL,'Template Module ICMP Ping','3','-1','2','','','Template Module ICMP Ping','0',NULL,'Template Module ICMP Ping

Template tooling version used: 0.34','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10188',NULL,'Template Module Interfaces Simple SNMP','3','-1','2','','','Template Module Interfaces Simple SNMP','0',NULL,'Template Module Interfaces Simple (no ifXTable). This is the exact copy of Template Module Interfaces template with the exception that metrics from ifXTable are replaced with ifTable counters where possible. Use this template with devices where IF-MIB::ifXtable is not available. If supported by the host - use Template Module Interfaces template instead.

MIBs used:
IF-MIB

Known Issues:

  Description: 32bit counters are used in this template (since there is no ifXtable available). If busy interfaces return incorrect bits sent/received - set update interval to 1m or less.

Template tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10190',NULL,'Template Module Interfaces SNMP','3','-1','2','','','Template Module Interfaces SNMP','0',NULL,'Template Module Interfaces

MIBs used:
IF-MIB

Template tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10192',NULL,'Template Module Interfaces Windows SNMP','3','-1','2','','','Template Module Interfaces Windows SNMP','0',NULL,'Template Interfaces Windows

MIBs used:
IF-MIB

Known Issues:

  Description: 32bit counters are used in this template (since 64bit are not supported by Windows OS). If busy interfaces return incorrect bits sent/received - set update interval to 1m or less.

Template tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10204',NULL,'Template Module Generic SNMP','3','-1','2','','','Template Module Generic SNMP','0',NULL,'Template Module Generic

MIBs used:
SNMPv2-MIB

Template tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10207',NULL,'Template Net Alcatel Timetra TiMOS SNMP','3','-1','2','','','Template Net Alcatel Timetra TiMOS SNMP','0',NULL,'Template Net Alcatel Timetra TiMOS

MIBs used:
TIMETRA-CHASSIS-MIB
TIMETRA-SYSTEM-MIB
SNMPv2-MIB

Template tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10208',NULL,'Template Net Brocade FC SNMP','3','-1','2','','','Template Net Brocade FC SNMP','0',NULL,'Template Net Brocade FC

MIBs used:
SW-MIB

Known Issues:

  Description: no IF-MIB::ifAlias is available
  Version: v6.3.1c, v7.0.0c,  v7.4.1c
  Device: all

Template tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10209',NULL,'Template Module Brocade_Foundry Performance SNMP','3','-1','2','','','Template Module Brocade_Foundry Performance SNMP','0',NULL,'Template Module Brocade_Foundry Performance

MIBs used:
FOUNDRY-SN-AGENT-MIB

Template tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10210',NULL,'Template Net Brocade_Foundry Nonstackable SNMP','3','-1','2','','','Template Net Brocade_Foundry Nonstackable SNMP','0',NULL,'Template Net Brocade_Foundry Nonstackable

MIBs used:
FOUNDRY-SN-AGENT-MIB

Template tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10211',NULL,'Template Net Brocade_Foundry Stackable SNMP','3','-1','2','','','Template Net Brocade_Foundry Stackable SNMP','0',NULL,'Template Brocade_Foundry Stackable

MIBs used:
FOUNDRY-SN-AGENT-MIB
FOUNDRY-SN-STACKING-MIB

Known Issues:

  Description: Correct fan(returns fan status as ''other(1)'' and temperature (returns 0) for the non-master Switches are not available in SNMP
  Version: Version 08.0.40b and above
  Device: ICX 7750 in stack

Template tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10212',NULL,'Template Module Cisco CISCO-MEMORY-POOL-MIB SNMP','3','-1','2','','','Template Module Cisco CISCO-MEMORY-POOL-MIB SNMP','0',NULL,'Template Cisco CISCO-MEMORY-POOL-MIB

MIBs used:
CISCO-MEMORY-POOL-MIB

Template tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10213',NULL,'Template Module Cisco CISCO-PROCESS-MIB SNMP','3','-1','2','','','Template Module Cisco CISCO-PROCESS-MIB SNMP','0',NULL,'Template Cisco CISCO-PROCESS-MIB

MIBs used:
CISCO-PROCESS-MIB

Template tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10215',NULL,'Template Module Cisco OLD-CISCO-CPU-MIB SNMP','3','-1','2','','','Template Module Cisco OLD-CISCO-CPU-MIB SNMP','0',NULL,'Template Cisco OLD-CISCO-CPU-MIB

MIBs used:
OLD-CISCO-CPU-MIB

Template tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10216',NULL,'Template Module Cisco Inventory SNMP','3','-1','2','','','Template Module Cisco Inventory SNMP','0',NULL,'Template Cisco Inventory

MIBs used:
ENTITY-MIB
SNMPv2-MIB

Template tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10217',NULL,'Template Module Cisco CISCO-ENVMON-MIB SNMP','3','-1','2','','','Template Module Cisco CISCO-ENVMON-MIB SNMP','0',NULL,'Template Cisco CISCO-ENVMON-MIB

MIBs used:
CISCO-ENVMON-MIB

Template tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10218',NULL,'Template Net Cisco IOS SNMP','3','-1','2','','','Template Net Cisco IOS SNMP','0',NULL,'Template Cisco IOS Software releases 12.2(3.5) or later

Known Issues:

  Description: no if(in|out)(Errors|Discards) are available for vlan ifType
  Version: IOS for example: 12.1(22)EA11, 15.4(3)M2
  Device: C2911, C7600

Template tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10220',NULL,'Template Net Cisco IOS prior to 12.0_3_T SNMP','3','-1','2','','','Template Net Cisco IOS prior to 12.0_3_T SNMP','0',NULL,'Cisco IOS Software releases prior to 12.0(3)T

Template tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10221',NULL,'Template Net Dell Force S-Series SNMP','3','-1','2','','','Template Net Dell Force S-Series SNMP','0',NULL,'Template Dell Force S-Series

MIBs used:
F10-S-SERIES-CHASSIS-MIB

Template tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10222',NULL,'Template Net D-Link DES 7200 SNMP','3','-1','2','','','Template Net D-Link DES 7200 SNMP','0',NULL,'Template D-Link DES 7200

MIBs used:
MY-PROCESS-MIB
SNMPv2-MIB
MY-MEMORY-MIB
ENTITY-MIB
MY-SYSTEM-MIB

Template tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10223',NULL,'Template Net D-Link DES_DGS Switch SNMP','3','-1','2','','','Template Net D-Link DES_DGS Switch SNMP','0',NULL,'Template D-Link DES_DGS Switch

MIBs used:
DLINK-AGENT-MIB
SNMPv2-MIB
ENTITY-MIB
EQUIPMENT-MIB

Known Issues:

  Description: D-Link reports missing PSU as fail(4)
  Version: Firmware: 1.73R008,hardware revision: B1
  Device: DGS-3420-26SC Gigabit Ethernet Switch

Template tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10224',NULL,'Template Net Extreme EXOS SNMP','3','-1','2','','','Template Net Extreme EXOS SNMP','0',NULL,'Template Extreme EXOS

MIBs used:
EXTREME-SOFTWARE-MONITOR-MIB
EXTREME-SYSTEM-MIB
ENTITY-MIB

Template tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10226',NULL,'Template Net Network Generic Device SNMP','3','-1','2','','','Template Net Network Generic Device SNMP','0',NULL,'Template Net Network Generic Device

Template tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10227',NULL,'Template Net HP Comware HH3C SNMP','3','-1','2','','','Template Net HP Comware HH3C SNMP','0',NULL,'Template Net HP Comware (HH3C)

MIBs used:
ENTITY-MIB
HH3C-ENTITY-EXT-MIB

Known Issues:

  Description: No temperature sensors. All entities of them return 0 for HH3C-ENTITY-EXT-MIB::hh3cEntityExtTemperature
  Version: 1910-48 Switch Software Version 5.20.99, Release 1116 Copyright(c)2010-2016 Hewlett Packard Enterprise Development LP
  Device: HP 1910-48

Template tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10229',NULL,'Template Net Huawei VRP SNMP','3','-1','2','','','Template Net Huawei VRP SNMP','0',NULL,'Template Net Huawei VRP

MIBs used:
HUAWEI-ENTITY-EXTENT-MIB
ENTITY-MIB

Template tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10230',NULL,'Template Net Intel_Qlogic Infiniband SNMP','3','-1','2','','','Template Net Intel_Qlogic Infiniband SNMP','0',NULL,'Template Net Intel_Qlogic Infiniband

MIBs used:
ICS-CHASSIS-MIB

Template tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10231',NULL,'Template Net Juniper SNMP','3','-1','2','','','Template Net Juniper SNMP','0',NULL,'Template Net Juniper

MIBs used:
JUNIPER-ALARM-MIB
JUNIPER-MIB
SNMPv2-MIB

Template tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10233',NULL,'Template Net Mikrotik SNMP','3','-1','2','','','Template Net Mikrotik SNMP','0',NULL,'Template Net Mikrotik

MIBs used:
HOST-RESOURCES-MIB
MIKROTIK-MIB

Known Issues:

  Description: Doesn''t have ifHighSpeed filled. fixed in more recent versions
  Version: RouterOS 6.28 or lower

  Description: Doesn''t have any temperature sensors
  Version: RouterOS 6.38.5
  Device: Mikrotik 941-2nD, Mikrotik 951G-2HnD

Template tooling version used: 0.37','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10234',NULL,'Template Net Netgear Fastpath SNMP','3','-1','2','','','Template Net Netgear Fastpath SNMP','0',NULL,'Template Net Netgear Fastpath

MIBs used:
FASTPATH-SWITCHING-MIB
FASTPATH-BOXSERVICES-PRIVATE-MIB

Template tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10235',NULL,'Template Net QTech QSW SNMP','3','-1','2','','','Template Net QTech QSW SNMP','0',NULL,'Template Net QTech QSW

MIBs used:
QTECH-MIB
ENTITY-MIB

Template tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10236',NULL,'Template Net TP-LINK SNMP','3','-1','2','','','Template Net TP-LINK SNMP','0',NULL,'Template Net TP-LINK JetStream

MIBs used:
TPLINK-SYSINFO-MIB
TPLINK-SYSMONITOR-MIB

Known Issues:

  Description: default sysLocation, sysName and sysContact is not filled with proper data. Real hostname and location can be found only in private branch(TPLINK-SYSINFO-MIB). Please check whether this problem exists in the latest firware: http://www.tp-linkru.com/download/T2600G-28TS.html#Firmware
  Version: 2.0.0 Build 20170628 Rel.55184(Beta)
  Device: T2600G-28TS 2.0

  Description: The Serial number of the product(tpSysInfoSerialNum) is missing in HW versions prior to V2_170323
  Version: prior to version V2_170323
  Device: T2600G-28TS 2.0

Template tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10237',NULL,'Template Net Ubiquiti AirOS SNMP','3','-1','2','','','Template Net Ubiquiti AirOS SNMP','0',NULL,'Template Net Ubiquiti AirOS

MIBs used:
IEEE802dot11-MIB
FROGFOOT-RESOURCES-MIB

Known Issues:

  Description: UBNT unifi reports speed: like IF-MIB::ifSpeed.1 = Gauge32: 4294967295 for all interfaces
  Version: Firmware: BZ.ar7240.v3.7.51.6230.170322.1513
  Device: UBNT UAP-LR

  Description: UBNT AirMax(NanoStation, NanoBridge etc) reports ifSpeed: as 0 for VLAN and wireless(ath0) interfaces
  Version: Firmware: XW.ar934x.v5.6-beta4.22359.140521.1836
  Device: NanoStation M5

  Description: UBNT AirMax(NanoStation, NanoBridge etc) reports always return ifType: as ethernet(6) even for wifi,vlans and other types
  Version: Firmware: XW.ar934x.v5.6-beta4.22359.140521.1836
  Device: NanoStation M5

  Description: ifXTable is not provided in IF-MIB. So Interfaces Simple Template is used instead
  Version: all above
  Device: NanoStation, UAP-LR

Template tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10248',NULL,'Template OS Linux SNMP','3','-1','2','','','Template OS Linux SNMP','0',NULL,'Template OS Linux

You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387225-discussion-thread-for-official-zabbix-template-for-linux

Template tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10249',NULL,'Template OS Windows SNMP','3','-1','2','','','Template OS Windows SNMP','0',NULL,'Official Windows SNMP template. Requires Zabbix server 4.0.14, 4.2.8, 4.4.0 or newer (JSONPath function avg() used with types autoconversion).


Known Issues:

  Description: Doesn''t support In/Out 64 bit counters even though IfxTable is present:
Currently, Windows gets it’s interface status from MIB-2. Since these 64bit SNMP counters (ifHCInOctets, ifHCOutOctets, etc.) are defined as an extension to IF-MIB, Microsoft has not implemented it.
https://social.technet.microsoft.com/Forums/windowsserver/en-US/07b62ff0-94f6-40ca-a99d-d129c1b33d70/windows-2008-r2-snmp-64bit-counters-support?forum=winservergen

  Version: Win2008, Win2012R2.

  Description: Doesn''t support ifXTable at all
  Version: WindowsXP

  Description: EtherLike MIB is not supported
  Version: *
  Device: *

Template tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10250',NULL,'Template Net HP Enterprise Switch SNMP','3','-1','2','','','Template Net HP Enterprise Switch SNMP','0',NULL,'Template Net HP Enterprise Switch

MIBs used:
SEMI-MIB
NETSWITCH-MIB
HP-ICF-CHASSIS
ENTITY-SENSORS-MIB
ENTITY-MIB
STATISTICS-MIB

Template tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10251',NULL,'Template Net Mellanox SNMP','3','-1','2','','','Template Net Mellanox SNMP','0',NULL,'Template Net Mellanox

MIBs used:
ENTITY-SENSORS-MIB
ENTITY-STATE-MIB
ENTITY-MIB

Template tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10252',NULL,'Template Module Cisco CISCO-PROCESS-MIB IOS versions 12.0_3_T-12.2_3.5 SNMP','3','-1','2','','','Template Module Cisco CISCO-PROCESS-MIB IOS versions 12.0_3_T-12.2_3.5 SNMP','0',NULL,'Template Module Cisco CISCO-PROCESS-MIB IOS versions 12.0_3_T-12.2_3.5

MIBs used:
CISCO-PROCESS-MIB

Template tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10253',NULL,'Template Net Cisco IOS versions 12.0_3_T-12.2_3.5 SNMP','3','-1','2','','','Template Net Cisco IOS versions 12.0_3_T-12.2_3.5 SNMP','0',NULL,'Cisco IOS Software releases later to 12.0(3)T and prior to 12.2(3.5)

Template tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10254',NULL,'Template Net Arista SNMP','3','-1','2','','','Template Net Arista SNMP','0',NULL,'Template Net Arista

MIBs used:
ENTITY-SENSORS-MIB
ENTITY-STATE-MIB
ENTITY-MIB

Template tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10255',NULL,'Template Server Dell iDRAC SNMP','3','-1','2','','','Template Server Dell iDRAC SNMP','0',NULL,'Template Server iDRAC

MIBs used:
IDRAC-MIB-SMIv2

Template tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10256',NULL,'Template Server HP iLO SNMP','3','-1','2','','','Template Server HP iLO SNMP','0',NULL,'Template Server HP iLO

MIBs used:
CPQSINFO-MIB
CPQHLTH-MIB
CPQIDA-MIB

Template tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10258',NULL,'Template Server IBM IMM SNMP','3','-1','2','','','Template Server IBM IMM SNMP','0',NULL,'Template Server IBM IMM

MIBs used:
IMM-MIB

Known Issues:

  Description: Some IMMs (IMM1) do not return disks
  Version: IMM1
  Device: IBM x3250M3

  Description: Some IMMs (IMM1) do not return fan status: fanHealthStatus
  Version: IMM1
  Device: IBM x3250M3

  Description: IMM1 servers (M2, M3 generations) sysObjectID is NET-SNMP-MIB::netSnmpAgentOIDs.10
  Version: IMM1
  Device: IMM1 servers (M2,M3 generations)

  Description: IMM1 servers (M2, M3 generations) only Ambient temperature sensor available
  Version: IMM1
  Device: IMM1 servers (M2,M3 generations)

Template tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10259',NULL,'Template Server Supermicro Aten SNMP','3','-1','2','','','Template Server Supermicro Aten SNMP','0',NULL,'Template Server Supermicro Aten

MIBs used:
ATEN-IPMI-MIB

Template tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10260',NULL,'Template App Apache Tomcat JMX','3','-1','2','','','Template App Apache Tomcat JMX','0',NULL,'','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10261',NULL,'Template App Remote Zabbix server','3','-1','2','','','Template App Remote Zabbix server','0',NULL,'','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10262',NULL,'Template App Remote Zabbix proxy','3','-1','2','','','Template App Remote Zabbix proxy','0',NULL,'','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10263',NULL,'Template DB PostgreSQL','3','-1','2','','','Template DB PostgreSQL','0',NULL,'','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10264',NULL,'Template App Apache by Zabbix agent','3','-1','2','','','Template App Apache by Zabbix agent','0',NULL,'Get metrics from mod_status module using HTTP agent.
https://httpd.apache.org/docs/current/mod/mod_status.html

You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384764-discussion-thread-for-official-zabbix-template-apache

Template tooling version used: 0.37','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10265',NULL,'Template App Apache by HTTP','3','-1','2','','','Template App Apache by HTTP','0',NULL,'Get metrics from mod_status module using HTTP agent.
https://httpd.apache.org/docs/current/mod/mod_status.html

You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384764-discussion-thread-for-official-zabbix-template-apache

Template tooling version used: 0.37','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10266',NULL,'Template App Nginx by Zabbix agent','3','-1','2','','','Template App Nginx by Zabbix agent','0',NULL,'Get metrics from stub status module using Zabbix agent running on Linux
https://nginx.ru/en/docs/http/ngx_http_stub_status_module.html


You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384765-discussion-thread-for-official-zabbix-template-nginx

Template tooling version used: 0.37','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10267',NULL,'Template App Nginx by HTTP','3','-1','2','','','Template App Nginx by HTTP','0',NULL,'Get metrics from stub status module using HTTP agent
https://nginx.ru/en/docs/http/ngx_http_stub_status_module.html.


You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384765-discussion-thread-for-official-zabbix-template-nginx

Template tooling version used: 0.37','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10268',NULL,'Template Module Linux memory SNMP','3','-1','2','','','Template Module Linux memory SNMP','0',NULL,'MIBs used:
UCD-SNMP-MIB

Known Issues:

  Description: Please note that memory utilization is a rough estimate, since memory available is calculated as free+buffers+cached, which is not 100% accurate, but the best we can get using SNMP.

Template tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10269',NULL,'Template Module Linux block devices SNMP','3','-1','2','','','Template Module Linux block devices SNMP','0',NULL,'MIBs used:
UCD-DISKIO-MIB

Template tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10270',NULL,'Template Module Linux CPU SNMP','3','-1','2','','','Template Module Linux CPU SNMP','0',NULL,'MIBs used:
HOST-RESOURCES-MIB
UCD-SNMP-MIB

Template tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10271',NULL,'Template Module Linux filesystems SNMP','3','-1','2','','','Template Module Linux filesystems SNMP','0',NULL,'MIBs used:
HOST-RESOURCES-MIB
UCD-SNMP-MIB

Template tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10272',NULL,'Template Module Linux CPU by Zabbix agent','3','-1','2','','','Template Module Linux CPU by Zabbix agent','0',NULL,'Template tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10273',NULL,'Template Module Linux filesystems by Zabbix agent','3','-1','2','','','Template Module Linux filesystems by Zabbix agent','0',NULL,'Template tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10274',NULL,'Template Module Linux memory by Zabbix agent','3','-1','2','','','Template Module Linux memory by Zabbix agent','0',NULL,'Template tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10275',NULL,'Template Module Linux block devices by Zabbix agent','3','-1','2','','','Template Module Linux block devices by Zabbix agent','0',NULL,'Template tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10276',NULL,'Template Module Linux network interfaces by Zabbix agent','3','-1','2','','','Template Module Linux network interfaces by Zabbix agent','0',NULL,'Known Issues:

  Description: High interface utilization trigger is removed since currently it is not possible to retrieve interface speed to determine the max bandwidth.

Template tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10277',NULL,'Template Module Linux generic by Zabbix agent','3','-1','2','','','Template Module Linux generic by Zabbix agent','0',NULL,'Template tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10278',NULL,'Template Module Linux CPU by Zabbix agent active','3','-1','2','','','Template Module Linux CPU by Zabbix agent active','0',NULL,'Template tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10279',NULL,'Template Module Linux filesystems by Zabbix agent active','3','-1','2','','','Template Module Linux filesystems by Zabbix agent active','0',NULL,'Template tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10280',NULL,'Template Module Linux memory by Zabbix agent active','3','-1','2','','','Template Module Linux memory by Zabbix agent active','0',NULL,'Template tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10281',NULL,'Template Module Linux block devices by Zabbix agent active','3','-1','2','','','Template Module Linux block devices by Zabbix agent active','0',NULL,'Template tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10282',NULL,'Template Module Linux network interfaces by Zabbix agent active','3','-1','2','','','Template Module Linux network interfaces by Zabbix agent active','0',NULL,'Known Issues:

  Description: High interface utilization trigger is removed since currently it is not possible to retrieve interface speed to determine the max bandwidth.

Template tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10283',NULL,'Template Module Linux generic by Zabbix agent active','3','-1','2','','','Template Module Linux generic by Zabbix agent active','0',NULL,'Template tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10284',NULL,'Template OS Linux by Zabbix agent active','3','-1','2','','','Template OS Linux by Zabbix agent active','0',NULL,'Official Linux template. Requires agent of Zabbix 3.0.14, 3.4.5 and 4.0.0 or newer.

Known Issues:

  Description: Network discovery. Zabbix agent as of 4.2 doesn''t support items such as net.if.status, net.if.speed.

You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387225-discussion-thread-for-official-zabbix-template-for-linux

Template tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10285',NULL,'Template OS Linux by Prom','3','-1','2','','','Template OS Linux by Prom','0',NULL,'Official Linux template using node exporter.

Known Issues:

  Description: node_exporter v0.16.0 renamed many metrics. CPU utilization for ''guest'' and ''guest_nice'' metrics are not supported in this template with node_exporter < 0.16. Disk IO metrics are not supported. Other metrics provided as ''best effort''.  
 See https://github.com/prometheus/node_exporter/releases/tag/v0.16.0 for details.
  Version: below 0.16.0

  Description: metric node_network_info with label ''device'' cannot be found, so network discovery is not possible.
  Version: below 0.18

You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387225-discussion-thread-for-official-zabbix-template-for-linux

Template tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10286',NULL,'Template Module Windows CPU by Zabbix agent','3','-1','2','','','Template Module Windows CPU by Zabbix agent','0',NULL,'Template tooling version used: 0.37','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10287',NULL,'Template Module Windows memory by Zabbix agent','3','-1','2','','','Template Module Windows memory by Zabbix agent','0',NULL,'Template tooling version used: 0.37','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10288',NULL,'Template Module Windows filesystems by Zabbix agent','3','-1','2','','','Template Module Windows filesystems by Zabbix agent','0',NULL,'Template tooling version used: 0.37','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10289',NULL,'Template Module Windows physical disks by Zabbix agent','3','-1','2','','','Template Module Windows physical disks by Zabbix agent','0',NULL,'Template tooling version used: 0.37','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10290',NULL,'Template Module Windows generic by Zabbix agent','3','-1','2','','','Template Module Windows generic by Zabbix agent','0',NULL,'Template tooling version used: 0.37','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10291',NULL,'Template Module Windows network by Zabbix agent','3','-1','2','','','Template Module Windows network by Zabbix agent','0',NULL,'Template tooling version used: 0.37','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10292',NULL,'Template Module Zabbix agent active','3','-1','2','','','Template Module Zabbix agent active','0',NULL,'Use this template instead of ''Template Module Zabbix agent'' for agents running in active mode only.

Template tooling version used: 0.34','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10293',NULL,'Template Module Windows CPU by Zabbix agent active','3','-1','2','','','Template Module Windows CPU by Zabbix agent active','0',NULL,'Template tooling version used: 0.37','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10294',NULL,'Template Module Windows memory by Zabbix agent active','3','-1','2','','','Template Module Windows memory by Zabbix agent active','0',NULL,'Template tooling version used: 0.37','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10295',NULL,'Template Module Windows filesystems by Zabbix agent active','3','-1','2','','','Template Module Windows filesystems by Zabbix agent active','0',NULL,'Template tooling version used: 0.37','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10296',NULL,'Template Module Windows physical disks by Zabbix agent active','3','-1','2','','','Template Module Windows physical disks by Zabbix agent active','0',NULL,'Template tooling version used: 0.37','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10297',NULL,'Template Module Windows generic by Zabbix agent active','3','-1','2','','','Template Module Windows generic by Zabbix agent active','0',NULL,'Template tooling version used: 0.37','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10298',NULL,'Template Module Windows network by Zabbix agent active','3','-1','2','','','Template Module Windows network by Zabbix agent active','0',NULL,'Template tooling version used: 0.37','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10299',NULL,'Template OS Windows by Zabbix agent active','3','-1','2','','','Template OS Windows by Zabbix agent active','0',NULL,'Official Windows template. Requires agent of Zabbix 4.4 and newer.


You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387224-discussion-thread-for-official-zabbix-template-for-windows

Template tooling version used: 0.37','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10300',NULL,'Template App RabbitMQ cluster by Zabbix agent','3','-1','2','','','Template App RabbitMQ cluster by Zabbix agent','0',NULL,'Get cluster metrics from RabbitMQ management plugin provided an HTTP-based API using Zabbix agent.

You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387226-discussion-thread-for-official-zabbix-template-rabbitmq

Template tooling version used: 0.34','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10301',NULL,'Template App RabbitMQ node by Zabbix agent','3','-1','2','','','Template App RabbitMQ node by Zabbix agent','0',NULL,'Get node metrics from RabbitMQ management plugin provided an HTTP-based API using Zabbix agent.

You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387226-discussion-thread-for-official-zabbix-template-rabbitmq

Template tooling version used: 0.34','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10302',NULL,'Template App RabbitMQ cluster by HTTP','3','-1','2','','','Template App RabbitMQ cluster by HTTP','0',NULL,'Get cluster metrics from RabbitMQ management plugin provided an HTTP-based API using HTTP agent.

You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387226-discussion-thread-for-official-zabbix-template-rabbitmq

Template tooling version used: 0.34','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10303',NULL,'Template App RabbitMQ node by HTTP','3','-1','2','','','Template App RabbitMQ node by HTTP','0',NULL,'Get node metrics from RabbitMQ management plugin provided an HTTP-based API using HTTP agent.

You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387226-discussion-thread-for-official-zabbix-template-rabbitmq

Template tooling version used: 0.34','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10304',NULL,'Template Server Cisco UCS SNMP','3','-1','2','','','Template Server Cisco UCS SNMP','0',NULL,'Template Server Cisco UCS

MIBs used:
CISCO-UNIFIED-COMPUTING-COMPUTE-MIB
CISCO-UNIFIED-COMPUTING-PROCESSOR-MIB
CISCO-UNIFIED-COMPUTING-EQUIPMENT-MIB
CISCO-UNIFIED-COMPUTING-STORAGE-MIB

Template tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10305',NULL,'Template Module HOST-RESOURCES-MIB CPU SNMP','3','-1','2','','','Template Module HOST-RESOURCES-MIB CPU SNMP','0',NULL,'Requires Zabbix server 4.0.14, 4.2.8, 4.4.0 or newer (JSONPath function avg() used with types autoconversion).

MIBs used:
HOST-RESOURCES-MIB

Template tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10306',NULL,'Template Module HOST-RESOURCES-MIB memory SNMP','3','-1','2','','','Template Module HOST-RESOURCES-MIB memory SNMP','0',NULL,'MIBs used:
HOST-RESOURCES-MIB

Template tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10307',NULL,'Template Module HOST-RESOURCES-MIB storage SNMP','3','-1','2','','','Template Module HOST-RESOURCES-MIB storage SNMP','0',NULL,'MIBs used:
HOST-RESOURCES-MIB

Template tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10308',NULL,'Template App HAProxy by Zabbix agent','3','-1','2','','','Template App HAProxy by Zabbix agent','0',NULL,'Get metrics from status page using Zabbix agent
https://www.haproxy.com/blog/exploring-the-haproxy-stats-page/.
Example configuration of HAProxy:        
  frontend stats
      bind *:8404
      stats enable
      stats uri /stats
      stats refresh 10s


You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/393527-discussion-thread-for-official-zabbix-template-haproxy

Template tooling version used: 0.35','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10309',NULL,'Template App HAProxy by HTTP','3','-1','2','','','Template App HAProxy by HTTP','0',NULL,'Get metrics from status page using HTTP agent
https://www.haproxy.com/blog/exploring-the-haproxy-stats-page/.
Example configuration of HAProxy:        
  frontend stats
      bind *:8404
      stats enable
      stats uri /stats
      stats refresh 10s
      #stats auth Username:Password  # Authentication credentials


You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/393527-discussion-thread-for-official-zabbix-template-haproxy

Template tooling version used: 0.35','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10310',NULL,'Template DB Redis','3','-1','2','','','Template DB Redis','0',NULL,'Get Redis metrics from plugin for the New Zabbix Agent (zabbix-agent2).

You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/389050-discussion-thread-for-official-zabbix-template-redis

Template tooling version used: 0.33','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10314',NULL,'Template Module Windows services by Zabbix agent','3','-1','2','','','Template Module Windows services by Zabbix agent','0',NULL,'Template Services OS Windows

Template tooling version used: 0.37','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10315',NULL,'Template Module Windows services by Zabbix agent active','3','-1','2','','','Template Module Windows services by Zabbix agent active','0',NULL,'Template Services OS Windows

Template tooling version used: 0.37','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10316',NULL,'Template DB MySQL by Zabbix agent','3','-1','2','','','Template DB MySQL by Zabbix agent','0',NULL,E'Requirements for template operation:
1.Install Zabbix agent and MySQL client.
2.Copy template_db_mysql.conf into folder with Zabbix agent configuration (/etc/zabbix/zabbix_agentd.d/ by default). Don''t forget restart zabbix-agent. 
3.Create MySQL user for monitoring. For example:
CREATE USER ''zbx_monitor''@''%'' IDENTIFIED BY ''<password>'';
GRANT USAGE,REPLICATION CLIENT,PROCESS,SHOW DATABASES,SHOW VIEW ON *.* TO ''zbx_monitor''@''%'';
For more information read the MYSQL documentation https://dev.mysql.com/doc/refman/8.0/en/grant.html , please. 
4.Create .my.cnf in home directory of Zabbix agent for Linux (/var/lib/zabbix by default ) or my.cnf in c:\\ for Windows. For example:
[client]
user=''zbx_monitor''
password=''<password>''


You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384189-discussion-thread-for-official-zabbix-template-db-mysql

Template tooling version used: 0.37','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10317',NULL,'Template DB MySQL by ODBC','3','-1','2','','','Template DB MySQL by ODBC','0',NULL,'Requirements for template operation:
1.Create MySQL user for monitoring. For example:
CREATE USER ''zbx_monitor''@''%'' IDENTIFIED BY ''<password>'';
GRANT USAGE,REPLICATION CLIENT,PROCESS,SHOW DATABASES,SHOW VIEW ON *.* TO ''zbx_monitor''@''%'';
For more information read the MYSQL documentation https://dev.mysql.com/doc/refman/8.0/en/grant.html , please. 
2. Set the user name and password in host macros ({$MYSQL.USER} and {$MYSQL.PASSWORD}).


You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384189-discussion-thread-for-official-zabbix-template-db-mysql

Template tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10318',NULL,'Template App Docker','3','-1','2','','','Template App Docker','0',NULL,'Get Docker engine metrics from plugin for the New Zabbix Agent (zabbix-agent2).

You can discuss this template or leave feedback on our forum 

Template tooling version used: 0.35','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10319',NULL,'Template App Memcached','3','-1','2','','','Template App Memcached','0',NULL,'Get Memcached metrics from plugin for the New Zabbix Agent (zabbix-agent2).

You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/398623-discussion-thread-for-official-zabbix-template-memcached

Template tooling version used: 0.35','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10320',NULL,'Template DB MySQL by Zabbix agent 2','3','-1','2','','','Template DB MySQL by Zabbix agent 2','0',NULL,'Requirements for template operation:
1. Create MySQL user for monitoring. For example:
CREATE USER ''zbx_monitor''@''%'' IDENTIFIED BY ''<password>'';
GRANT USAGE,REPLICATION CLIENT,PROCESS,SHOW DATABASES,SHOW VIEW ON *.* TO ''zbx_monitor''@''%'';
For more information please read the MYSQL documentation https://dev.mysql.com/doc/refman/8.0/en/grant.html.
2. Set in the {$MYSQL.DSN} macro the data source name of the MySQL instance either session name from Zabbix agent 2 configuration file or URI.
Examples: MySQL1, tcp://localhost:3306, tcp://172.16.0.10, unix:/var/run/mysql.sock
For more information about MySQL Unix socket file please read the MySQL documentation https://dev.mysql.com/doc/refman/8.0/en/problems-with-mysql-sock.html.
3. If you had set URI in the {$MYSQL.DSN}, please define the user name and password in host macros ({$MYSQL.USER} and {$MYSQL.PASSWORD}).
Leave macros {$MYSQL.USER} and {$MYSQL.PASSWORD} empty if you use a session name. Set the user name and password in the Plugins.Mysql.<...> section of your Zabbix agent 2 configuration file.
For more information about configuring the Zabbix MySQL plugin please read the documentation https://git.zabbix.com/projects/ZBX/repos/zabbix/browse/src/go/plugins/mysql/README.md.


You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384189-discussion-thread-for-official-zabbix-template-db-mysql

Template tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10321',NULL,'Template Server Chassis by IPMI','3','-1','2','','','Template Server Chassis by IPMI','0',NULL,'Template for monitoring servers with BMC over IPMI that work without any external scripts. 
All metrics are collected at once, thanks to Zabbix''s bulk data collection. The template is available starting from Zabbix version 5.0. 
It collects metrics by polling BMC remotely using an IPMI agent.


Known Issues:

  Description: If the BMC has a sensor with an empty threshold value, we get the LLD error "Cannot create trigger...".

You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/398023-discussion-thread-for-official-zabbix-template-ipmi

Template tooling version used: 0.37','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10322',NULL,'Template App Elasticsearch Cluster by HTTP','3','-1','2','','','Template App Elasticsearch Cluster by HTTP','0',NULL,'The template to monitor Elasticsearch by Zabbix that work without any external scripts.
It works with both standalone and cluster instances.
The metrics are collected in one pass remotely using an HTTP agent. 
They are getting values from REST API _cluster/health, _cluster/stats, _nodes/stats requests.
You can set {$ELASTICSEARCH.USERNAME} and {$ELASTICSEARCH.PASSWORD} macros in the template for using on the host level.
If you use an atypical location ES API, don''t forget to change the macros {$ELASTICSEARCH.SCHEME},{$ELASTICSEARCH.PORT}.


You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/399473-discussion-thread-for-official-zabbix-template-for-elasticsearch

Template tooling version used: 0.35','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10323',NULL,'Template DB ClickHouse by HTTP','3','-1','2','','','Template DB ClickHouse by HTTP','0',NULL,'Get node metrics from ClickHouse HTTP interface using HTTP agent.

Template tooling version used: 0.35','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10324',NULL,'Template App Etcd by HTTP','3','-1','2','','','Template App Etcd by HTTP','0',NULL,'Get Etcd metrics by HTTP agent.

Template tooling version used: 0.36','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10325',NULL,'Template App IIS by Zabbix agent','3','-1','2','','','Template App IIS by Zabbix agent','0',NULL,'Get metrics from IIS using Zabbix agent running on Windows


You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/401862-discussion-thread-for-official-zabbix-template-internet-information-services

Template tooling version used: 0.35','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10326',NULL,'Template App IIS by Zabbix agent active','3','-1','2','','','Template App IIS by Zabbix agent active','0',NULL,'Get metrics from IIS using Zabbix agent running on Windows


You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/401862-discussion-thread-for-official-zabbix-template-internet-information-services

Template tooling version used: 0.35','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10327',NULL,'Template DB MSSQL by ODBC','3','-1','2','','','Template DB MSSQL by ODBC','0',NULL,'1. Create an MSSQL user for monitoring.
  View Server State and View Any Definition permissions should be granted to the user.
  For more information please see the MSSQL documentation.
2. Set the user name and password in host macros ({$MSSQL.USER} and {$MSSQL.PASSWORD}).
  Do not forget to install the Microsoft ODBC driver on the Zabbix server or the Zabbix proxy.
  See Microsoft documentation for instructions: https://docs.microsoft.com/en-us/sql/connect/odbc/linux-mac/installing-the-microsoft-odbc-driver-for-sql-server?view=sql-server-ver15.
  Note! Credentials in the odbc.ini do not work for MSSQL.
3. For named instance set the value of {$MSSQL.INSTANCE} macro as MSSQL$instance name, please.
The "Service''s TCP port state" item uses {HOST.CONN} and {$MSSQL.PORT} macros to check the availability of the MSSQL instance.


You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/

Template tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10328',NULL,'Template DB PostgreSQL Agent 2','3','-1','2','','','Template DB PostgreSQL Agent 2','0',NULL,'Template tooling version used: 0.37','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10329',NULL,'Template DB Oracle by ODBC','3','-1','2','','','Template DB Oracle by ODBC','0',NULL,'1. Create an Oracle user for monitoring.

2. Set the user name and password in host macros ({$ORACLE.USER} and {$ORACLE.PASSWORD}).
  Do not forget to install the Microsoft ODBC driver on the Zabbix server or the Zabbix proxy.
  See Oracle documentation for instructions: https://www.oracle.com/database/technologies/releasenote-odbc-ic.html.

  Note! Credentials in the odbc.ini do not work for Oracle.
  Note! Be sure that ODBC connects to Oracle with session parameter NLS_NUMERIC_CHARACTERS= ''.,'' It is important for correct display float numbers in Zabbix.
The "Service''s TCP port state" item uses {HOST.CONN} and {$ORACLE.PORT} macros to check the availability of the listener.


Template tooling version used: 0.37','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10330',NULL,'Template VM VMware macros','3','-1','2','','','Template VM VMware macros','0',NULL,'Template tooling version used: 0.38','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10331',NULL,'{#HV.UUID}','0','-1','2','','','{#HV.NAME}','2',NULL,'','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10332',NULL,'{#VM.UUID}','0','-1','2','','','{#VM.NAME}','2',NULL,'','1','1','','','','','','1','0');
INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover) values ('10333',NULL,'Template DB Oracle by Zabbix Agent 2','3','-1','2','','','Template DB Oracle by Zabbix Agent 2','0',NULL,'Template tooling version used: 0.37','1','1','','','','','','1','0');
INSERT INTO group_prototype (group_prototypeid,hostid,name,groupid,templateid) values ('1','10331','{#CLUSTER.NAME}',NULL,NULL);
INSERT INTO group_prototype (group_prototypeid,hostid,name,groupid,templateid) values ('2','10331','{#DATACENTER.NAME}',NULL,NULL);
INSERT INTO group_prototype (group_prototypeid,hostid,name,groupid,templateid) values ('3','10331','','12',NULL);
INSERT INTO group_prototype (group_prototypeid,hostid,name,groupid,templateid) values ('4','10332','{#CLUSTER.NAME} (vm)',NULL,NULL);
INSERT INTO group_prototype (group_prototypeid,hostid,name,groupid,templateid) values ('5','10332','{#DATACENTER.NAME} (vm)',NULL,NULL);
INSERT INTO group_prototype (group_prototypeid,hostid,name,groupid,templateid) values ('6','10332','{#HV.NAME}',NULL,NULL);
INSERT INTO group_prototype (group_prototypeid,hostid,name,groupid,templateid) values ('7','10332','','12',NULL);
INSERT INTO screens (screenid,name,hsize,vsize,templateid,userid,private) values ('3','System performance','2','7','10001',NULL,'0');
INSERT INTO screens (screenid,name,hsize,vsize,templateid,userid,private) values ('4','Zabbix server health','2','3','10047',NULL,'0');
INSERT INTO screens (screenid,name,hsize,vsize,templateid,userid,private) values ('5','System performance','2','2','10076',NULL,'0');
INSERT INTO screens (screenid,name,hsize,vsize,templateid,userid,private) values ('6','System performance','2','2','10077',NULL,'0');
INSERT INTO screens (screenid,name,hsize,vsize,templateid,userid,private) values ('7','System performance','2','2','10075',NULL,'0');
INSERT INTO screens (screenid,name,hsize,vsize,templateid,userid,private) values ('9','System performance','2','3','10074',NULL,'0');
INSERT INTO screens (screenid,name,hsize,vsize,templateid,userid,private) values ('10','System performance','2','3','10078',NULL,'0');
INSERT INTO screens (screenid,name,hsize,vsize,templateid,userid,private) values ('16','Zabbix server','2','2',NULL,'1','0');
INSERT INTO screens (screenid,name,hsize,vsize,templateid,userid,private) values ('17','Zabbix proxy health','2','2','10048',NULL,'0');
INSERT INTO screens (screenid,name,hsize,vsize,templateid,userid,private) values ('18','System performance','1','2','10079',NULL,'0');
INSERT INTO screens (screenid,name,hsize,vsize,templateid,userid,private) values ('19','System performance','2','6','10081',NULL,'0');
INSERT INTO screens (screenid,name,hsize,vsize,templateid,userid,private) values ('20','MySQL performance','2','4','10170',NULL,'1');
INSERT INTO screens (screenid,name,hsize,vsize,templateid,userid,private) values ('21','Zabbix server health','2','3','10261',NULL,'1');
INSERT INTO screens (screenid,name,hsize,vsize,templateid,userid,private) values ('22','Zabbix proxy health','2','2','10262',NULL,'1');
INSERT INTO screens (screenid,name,hsize,vsize,templateid,userid,private) values ('23','PostgreSQL databases','2','4','10263',NULL,'1');
INSERT INTO screens (screenid,name,hsize,vsize,templateid,userid,private) values ('24','PostgreSQL stat','2','4','10263',NULL,'1');
INSERT INTO screens (screenid,name,hsize,vsize,templateid,userid,private) values ('25','Apache performance','2','3','10264',NULL,'1');
INSERT INTO screens (screenid,name,hsize,vsize,templateid,userid,private) values ('26','Apache performance','2','3','10265',NULL,'1');
INSERT INTO screens (screenid,name,hsize,vsize,templateid,userid,private) values ('27','Nginx performance','2','2','10266',NULL,'1');
INSERT INTO screens (screenid,name,hsize,vsize,templateid,userid,private) values ('28','Nginx performance','2','2','10267',NULL,'1');
INSERT INTO screens (screenid,name,hsize,vsize,templateid,userid,private) values ('29','System performance','2','6','10248',NULL,'1');
INSERT INTO screens (screenid,name,hsize,vsize,templateid,userid,private) values ('30','Network interfaces','1','1','10276',NULL,'1');
INSERT INTO screens (screenid,name,hsize,vsize,templateid,userid,private) values ('31','Network interfaces','1','1','10282',NULL,'1');
INSERT INTO screens (screenid,name,hsize,vsize,templateid,userid,private) values ('32','System performance','2','7','10284',NULL,'1');
INSERT INTO screens (screenid,name,hsize,vsize,templateid,userid,private) values ('33','System performance','2','7','10285',NULL,'1');
INSERT INTO screens (screenid,name,hsize,vsize,templateid,userid,private) values ('34','Network interfaces','1','1','10285',NULL,'1');
INSERT INTO screens (screenid,name,hsize,vsize,templateid,userid,private) values ('35','Netowrk interfaces','1','1','10291',NULL,'1');
INSERT INTO screens (screenid,name,hsize,vsize,templateid,userid,private) values ('36','Netowrk interfaces','1','1','10298',NULL,'1');
INSERT INTO screens (screenid,name,hsize,vsize,templateid,userid,private) values ('37','System performance','2','6','10299',NULL,'1');
INSERT INTO screens (screenid,name,hsize,vsize,templateid,userid,private) values ('38','RabbitMQ overview','2','3','10300',NULL,'1');
INSERT INTO screens (screenid,name,hsize,vsize,templateid,userid,private) values ('39','RabbitMQ node status','2','3','10301',NULL,'1');
INSERT INTO screens (screenid,name,hsize,vsize,templateid,userid,private) values ('40','RabbitMQ overview','2','3','10302',NULL,'1');
INSERT INTO screens (screenid,name,hsize,vsize,templateid,userid,private) values ('41','RabbitMQ node status','2','3','10303',NULL,'1');
INSERT INTO screens (screenid,name,hsize,vsize,templateid,userid,private) values ('43','Network interfaces','1','1','10190',NULL,'1');
INSERT INTO screens (screenid,name,hsize,vsize,templateid,userid,private) values ('45','Network interfaces','1','1','10188',NULL,'1');
INSERT INTO screens (screenid,name,hsize,vsize,templateid,userid,private) values ('46','Network interfaces','1','1','10192',NULL,'1');
INSERT INTO screens (screenid,name,hsize,vsize,templateid,userid,private) values ('47','System performance','2','3','10185',NULL,'1');
INSERT INTO screens (screenid,name,hsize,vsize,templateid,userid,private) values ('48','HAProxy Backend performance','1','1','10308',NULL,'1');
INSERT INTO screens (screenid,name,hsize,vsize,templateid,userid,private) values ('49','HAProxy Frontend performance','2','2','10308',NULL,'1');
INSERT INTO screens (screenid,name,hsize,vsize,templateid,userid,private) values ('50','HAProxy Server performance','1','1','10308',NULL,'1');
INSERT INTO screens (screenid,name,hsize,vsize,templateid,userid,private) values ('51','HAProxy Backend performance','1','1','10309',NULL,'1');
INSERT INTO screens (screenid,name,hsize,vsize,templateid,userid,private) values ('52','HAProxy Frontend performance','2','2','10309',NULL,'1');
INSERT INTO screens (screenid,name,hsize,vsize,templateid,userid,private) values ('53','HAProxy Server performance','1','1','10309',NULL,'1');
INSERT INTO screens (screenid,name,hsize,vsize,templateid,userid,private) values ('54','Redis overview','2','5','10310',NULL,'1');
INSERT INTO screens (screenid,name,hsize,vsize,templateid,userid,private) values ('55','Redis performance','2','2','10310',NULL,'1');
INSERT INTO screens (screenid,name,hsize,vsize,templateid,userid,private) values ('57','MySQL performance','2','3','10316',NULL,'1');
INSERT INTO screens (screenid,name,hsize,vsize,templateid,userid,private) values ('58','MySQL performance','2','3','10317',NULL,'1');
INSERT INTO screens (screenid,name,hsize,vsize,templateid,userid,private) values ('59','Docker overview','2','5','10318',NULL,'1');
INSERT INTO screens (screenid,name,hsize,vsize,templateid,userid,private) values ('60','MySQL performance','2','3','10320',NULL,'1');
INSERT INTO screens (screenid,name,hsize,vsize,templateid,userid,private) values ('61','PostgreSQL databases','2','5','10328',NULL,'1');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('44','16','2','1','500','100','0','0','2','1','0','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('1954','20','0','862','750','200','0','0','1','1','0','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('1955','20','0','863','750','200','1','0','1','1','0','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('1956','20','0','860','750','200','0','1','1','1','0','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('1957','20','0','859','750','200','1','1','1','1','0','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('1958','20','0','861','750','200','0','2','1','1','0','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('1959','20','0','864','750','200','1','2','1','1','0','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4002','25','0','1174','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4003','25','0','1176','500','100','1','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4004','25','20','1172','500','100','0','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4005','25','20','1173','500','100','1','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4006','25','0','1175','500','100','0','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4007','26','0','838','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4008','26','0','839','500','100','1','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4009','26','20','836','500','100','0','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4010','26','20','837','500','100','1','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4011','26','0','840','500','100','0','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4012','59','0','1125','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4013','59','0','1129','500','100','1','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4014','59','0','1128','500','100','0','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4015','59','0','1126','500','100','1','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4016','59','0','1127','500','100','0','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4017','48','20','1075','750','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4018','49','20','1078','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4019','49','20','1076','500','100','1','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4020','49','20','1079','500','100','0','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4021','49','20','1077','500','100','1','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4022','50','20','1080','750','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4023','51','20','1081','750','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4024','52','20','1084','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4025','52','20','1082','500','100','1','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4026','52','20','1085','500','100','0','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4027','52','20','1083','500','100','1','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4028','53','20','1086','750','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4029','27','0','841','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4030','27','0','843','500','100','1','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4031','27','0','842','500','100','0','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4032','28','0','845','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4033','28','0','847','500','100','1','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4034','28','0','846','500','100','0','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4035','38','0','1029','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4036','38','0','1027','500','100','1','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4037','38','0','1030','500','100','0','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4038','38','0','1028','500','100','1','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4039','38','0','1031','500','100','0','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4040','39','0','1011','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4041','39','0','1012','500','100','1','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4042','39','0','1008','500','100','0','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4043','39','0','1009','500','100','1','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4044','39','0','1007','500','100','0','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4045','39','0','1010','500','100','1','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4046','40','0','1018','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4047','40','0','1016','500','100','1','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4048','40','0','1019','500','100','0','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4049','40','0','1017','500','100','1','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4050','40','0','1020','500','100','0','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4051','41','0','1025','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4052','41','0','1026','500','100','1','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4053','41','0','1022','500','100','0','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4054','41','0','1023','500','100','1','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4055','41','0','1021','500','100','0','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4056','41','0','1024','500','100','1','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4057','22','0','806','500','212','0','0','1','1','0','1','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4058','22','0','804','500','100','1','0','1','1','0','1','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4059','22','0','805','500','100','0','1','1','1','0','1','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4060','22','0','803','500','128','1','1','1','1','0','1','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4061','21','0','802','500','212','0','0','1','1','0','1','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4062','21','0','799','500','100','1','0','1','1','0','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4063','21','0','800','500','114','0','1','1','1','0','1','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4064','21','0','798','500','128','1','1','1','1','0','1','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4065','21','0','797','500','160','0','2','1','1','0','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4066','21','0','801','500','160','1','2','1','1','0','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4067','17','0','532','500','212','0','0','1','1','0','1','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4068','17','0','530','500','100','1','0','1','1','0','1','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4069','17','0','531','500','100','0','1','1','1','0','1','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4070','17','0','529','500','128','1','1','1','1','0','1','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4071','4','0','392','500','212','0','0','1','1','0','1','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4072','4','0','404','500','100','1','0','1','1','0','1','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4073','4','0','406','500','114','0','1','1','1','0','1','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4074','4','0','410','500','128','1','1','1','1','0','1','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4075','4','0','527','500','160','0','2','1','1','0','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4076','4','0','788','500','160','1','2','1','1','0','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4077','5','0','469','500','148','0','0','1','1','0','1','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4078','5','0','471','500','100','1','0','1','1','0','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4079','5','0','498','500','100','0','1','1','1','0','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4080','5','0','540','500','100','1','1','1','1','0','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4081','7','0','463','500','120','0','0','1','1','0','1','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4082','7','0','462','500','106','1','0','1','1','0','1','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4083','7','0','541','500','100','0','1','1','1','0','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4084','7','0','464','500','300','1','1','1','1','0','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4085','6','0','475','500','114','0','0','1','1','0','1','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4086','6','0','474','500','100','1','0','1','1','0','1','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4087','6','0','542','500','100','0','1','1','1','0','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4088','18','0','487','750','100','0','0','1','1','0','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4089','18','0','543','750','100','0','1','1','1','0','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4090','9','0','457','500','120','0','0','1','1','0','1','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4091','9','0','456','500','106','1','0','1','1','0','1','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4092','9','0','544','500','100','0','1','1','1','0','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4093','9','0','458','500','300','1','1','1','1','0','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4094','9','1','22838','500','100','0','2','1','1','0','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4095','9','1','22837','500','100','1','2','1','1','0','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4096','10','0','481','500','114','0','0','1','1','0','1','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4097','10','0','480','500','100','1','0','1','1','0','1','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4098','10','0','545','500','100','0','1','1','1','0','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4099','10','0','482','500','300','1','1','1','1','0','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4100','10','1','22998','500','100','0','2','1','1','0','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4101','10','1','22997','500','100','1','2','1','1','0','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4102','57','0','1112','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4103','57','0','1113','500','100','1','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4104','57','0','1110','500','100','0','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4105','57','0','1109','500','100','1','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4106','57','0','1111','500','100','0','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4107','57','0','1114','500','100','1','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4108','60','0','1139','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4109','60','0','1140','500','100','1','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4110','60','0','1137','500','100','0','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4111','60','0','1136','500','100','1','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4112','60','0','1138','500','100','0','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4113','60','0','1141','500','100','1','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4114','58','0','1118','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4115','58','0','1119','500','100','1','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4116','58','0','1116','500','100','0','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4117','58','0','1115','500','100','1','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4118','58','0','1117','500','100','0','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4119','58','0','1120','500','100','1','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4120','23','20','821','500','200','0','0','1','1','0','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4121','23','20','816','500','200','1','0','1','1','0','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4122','23','20','814','500','200','0','1','1','1','0','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4123','23','20','820','500','200','1','1','1','1','0','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4124','23','20','817','500','200','0','2','1','1','0','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4125','23','20','815','500','200','1','2','1','1','0','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4126','23','20','818','500','200','0','3','1','1','0','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4127','23','20','819','500','200','1','3','1','1','0','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4128','24','0','824','500','200','0','0','1','1','0','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4129','24','0','827','500','200','1','0','1','1','0','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4130','24','0','825','500','200','0','1','1','1','0','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4131','24','0','828','500','200','1','1','1','1','0','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4132','24','0','826','500','200','0','2','1','1','0','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4133','24','0','829','500','200','1','2','1','1','0','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4134','24','0','822','500','200','0','3','1','1','0','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4135','24','0','823','500','200','1','3','1','1','0','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4136','61','20','1212','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4137','61','20','1210','500','100','1','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4138','61','20','1213','500','100','0','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4139','61','20','1211','500','100','1','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4140','54','0','1091','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4141','54','0','1095','500','100','1','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4142','54','0','1092','500','100','0','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4143','54','0','1094','500','100','1','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4144','54','0','1099','500','100','0','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4145','54','0','1100','500','100','1','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4146','54','0','1101','500','100','0','3','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4147','54','0','1102','500','100','1','3','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4148','54','20','1090','500','100','0','4','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4149','55','0','1093','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4150','55','0','1098','500','100','1','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4151','55','0','1096','500','100','0','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4152','55','0','1097','500','100','1','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4153','47','0','1071','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4154','47','20','1061','500','100','0','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4155','47','20','1066','500','100','0','2','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4156','45','20','741','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4157','43','20','745','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4158','46','20','766','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4159','3','0','903','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4160','3','0','909','500','100','1','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4161','3','0','918','500','100','0','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4162','3','0','921','500','100','1','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4163','3','20','888','500','100','0','2','2','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4164','3','20','1218','500','100','0','3','2','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4165','3','20','1215','500','100','0','4','2','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4166','3','20','1221','500','100','0','5','2','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4167','3','20','900','500','100','0','6','2','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4168','30','20','899','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4169','31','20','934','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4170','32','0','937','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4171','32','0','941','500','100','1','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4172','32','0','947','500','100','0','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4173','32','0','949','500','100','1','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4174','32','20','927','500','100','0','2','2','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4175','32','20','1226','500','100','0','3','2','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4176','32','20','1224','500','100','0','4','2','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4177','32','20','1228','500','100','0','5','2','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4178','32','20','935','500','100','0','6','2','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4179','33','0','957','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4180','33','0','959','500','100','1','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4181','33','0','962','500','100','0','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4182','33','0','963','500','100','1','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4183','33','20','953','500','100','0','2','2','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4184','33','20','954','500','100','0','3','2','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4185','33','20','955','500','100','0','4','2','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4186','33','20','956','500','100','0','5','2','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4187','33','20','952','500','100','0','6','2','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4188','34','20','952','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4189','29','0','881','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4190','29','20','869','500','100','1','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4191','29','0','877','500','100','0','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4192','29','0','879','500','100','1','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4193','29','20','873','500','100','0','2','2','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4194','29','20','867','500','100','0','3','2','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4195','29','19','29033','500','100','0','4','2','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4196','29','20','865','500','100','0','5','2','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4197','19','0','977','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4198','19','1','29485','500','100','1','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4199','19','0','979','500','100','0','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4200','19','0','981','500','100','1','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4201','19','20','965','500','100','0','2','2','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4202','19','20','1230','500','100','0','3','2','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4203','19','20','1232','500','100','0','4','2','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4204','19','20','1247','500','100','0','5','2','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4205','35','20','1246','750','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4206','36','20','1248','750','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4207','37','0','995','500','100','0','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4208','37','1','29592','500','100','1','0','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4209','37','0','997','500','100','0','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4210','37','0','999','500','100','1','1','1','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4211','37','20','983','500','100','0','2','2','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4212','37','20','1234','500','100','0','3','2','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4213','37','20','1236','500','100','0','4','2','1','25','0','0','0','','0','0','','3');
INSERT INTO screens_items (screenitemid,screenid,resourcetype,resourceid,width,height,x,y,colspan,rowspan,elements,valign,halign,style,url,dynamic,sort_triggers,application,max_columns) values ('4214','37','20','1249','500','100','0','5','2','1','25','0','0','0','','0','0','','3');
INSERT INTO applications (applicationid,hostid,name,flags) values ('179','10047','Zabbix server','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('253','10074','CPU','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('254','10074','Filesystems','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('255','10074','General','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('256','10074','Memory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('257','10074','Network interfaces','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('258','10074','OS','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('259','10074','Performance','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('260','10074','Processes','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('261','10074','Security','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('263','10075','CPU','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('264','10075','Filesystems','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('265','10075','General','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('266','10075','Memory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('267','10075','Network interfaces','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('268','10075','OS','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('269','10075','Performance','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('270','10075','Processes','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('271','10075','Security','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('273','10076','CPU','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('274','10076','Filesystems','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('275','10076','General','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('276','10076','Memory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('277','10076','Network interfaces','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('278','10076','OS','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('279','10076','Performance','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('280','10076','Processes','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('281','10076','Security','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('283','10077','CPU','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('284','10077','Filesystems','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('285','10077','General','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('286','10077','Memory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('287','10077','Network interfaces','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('288','10077','OS','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('289','10077','Performance','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('290','10077','Processes','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('291','10077','Security','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('293','10078','CPU','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('294','10078','Filesystems','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('295','10078','General','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('296','10078','Memory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('297','10078','Network interfaces','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('298','10078','OS','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('299','10078','Performance','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('300','10078','Processes','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('301','10078','Security','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('303','10079','CPU','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('304','10079','Filesystems','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('305','10079','General','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('306','10079','Memory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('307','10079','Network interfaces','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('308','10079','OS','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('309','10079','Performance','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('310','10079','Processes','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('311','10079','Security','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('331','10076','Logical partitions','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('345','10084','Zabbix server','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('356','10048','Zabbix proxy','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('446','10093','FTP service','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('447','10094','HTTP service','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('448','10095','HTTPS service','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('449','10096','IMAP service','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('450','10097','LDAP service','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('451','10098','NNTP service','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('452','10099','NTP service','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('453','10100','POP service','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('454','10101','SMTP service','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('455','10102','SSH service','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('456','10103','Telnet service','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('740','10170','MySQL','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('741','10171','Fans','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('742','10171','Temperature','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('743','10171','Voltage','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('744','10172','Fans','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('745','10172','Temperature','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('746','10172','Voltage','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('771','10183','Network interfaces','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('780','10186','Status','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('782','10188','Network interfaces','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('784','10190','Network interfaces','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('786','10192','Network interfaces','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('799','10204','Status','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('800','10204','General','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('803','10207','Network interfaces','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('804','10207','General','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('805','10207','Status','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('806','10207','CPU','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('807','10207','Memory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('808','10207','Temperature','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('809','10207','Fans','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('810','10207','Inventory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('811','10208','Network interfaces','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('812','10208','General','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('813','10208','Status','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('814','10208','CPU','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('815','10208','Memory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('816','10208','Temperature','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('817','10208','Power supply','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('818','10208','Fans','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('819','10208','Inventory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('820','10210','Network interfaces','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('821','10210','General','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('822','10210','Status','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('823','10211','Network interfaces','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('824','10211','General','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('825','10211','Status','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('826','10209','CPU','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('827','10209','Memory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('828','10210','Temperature','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('829','10210','Power supply','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('830','10210','Fans','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('831','10210','Inventory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('832','10211','Temperature','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('833','10211','Power supply','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('834','10211','Fans','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('835','10211','Inventory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('836','10210','CPU','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('837','10210','Memory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('838','10211','CPU','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('839','10211','Memory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('840','10218','Network interfaces','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('841','10218','General','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('842','10218','Status','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('846','10220','General','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('847','10220','Status','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('848','10212','Memory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('849','10213','CPU','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('851','10215','CPU','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('852','10216','Inventory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('853','10217','Temperature','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('854','10217','Power supply','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('855','10217','Fans','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('856','10218','Memory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('857','10218','CPU','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('858','10218','Inventory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('859','10218','Temperature','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('860','10218','Power supply','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('861','10218','Fans','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('868','10220','Memory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('869','10220','CPU','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('870','10220','Inventory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('871','10220','Temperature','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('872','10220','Power supply','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('873','10220','Fans','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('874','10221','Network interfaces','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('875','10221','General','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('876','10221','Status','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('877','10221','CPU','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('878','10221','Memory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('879','10221','Temperature','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('880','10221','Power supply','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('881','10221','Fans','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('882','10221','Inventory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('883','10222','Network interfaces','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('884','10222','General','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('885','10222','Status','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('886','10222','CPU','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('887','10222','Memory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('888','10222','Temperature','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('889','10222','Fans','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('890','10222','Power supply','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('891','10222','Inventory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('892','10223','Network interfaces','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('893','10223','General','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('894','10223','Status','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('895','10223','CPU','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('896','10223','Memory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('897','10223','Temperature','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('898','10223','Fans','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('899','10223','Power supply','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('900','10223','Inventory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('901','10224','Network interfaces','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('902','10224','General','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('903','10224','Status','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('904','10224','CPU','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('905','10224','Memory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('906','10224','Temperature','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('907','10224','Power supply','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('908','10224','Fans','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('909','10224','Inventory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('913','10226','Network interfaces','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('914','10226','General','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('915','10226','Status','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('916','10227','Network interfaces','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('917','10227','General','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('918','10227','Status','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('919','10227','CPU','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('920','10227','Memory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('921','10227','Temperature','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('922','10227','Fans','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('923','10227','Power supply','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('924','10227','Inventory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('934','10229','Network interfaces','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('935','10229','General','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('936','10229','Status','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('937','10229','CPU','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('938','10229','Memory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('939','10229','Temperature','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('940','10229','Fans','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('941','10229','Inventory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('942','10230','Network interfaces','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('943','10230','General','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('944','10230','Status','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('945','10230','Temperature','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('946','10230','Power supply','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('947','10230','Fans','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('948','10230','Inventory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('949','10231','Network interfaces','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('950','10231','General','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('951','10231','Status','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('952','10231','CPU','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('953','10231','Memory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('954','10231','Temperature','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('955','10231','Power supply','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('956','10231','Fans','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('957','10231','Inventory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('969','10233','Network interfaces','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('970','10233','General','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('971','10233','Status','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('972','10233','CPU','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('973','10233','Memory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('974','10233','Temperature','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('975','10233','Storage','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('976','10233','Inventory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('977','10234','Network interfaces','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('978','10234','General','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('979','10234','Status','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('980','10234','CPU','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('981','10234','Memory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('982','10234','Temperature','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('983','10234','Power supply','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('984','10234','Fans','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('985','10234','Inventory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('986','10235','Network interfaces','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('987','10235','General','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('988','10235','Status','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('989','10235','CPU','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('990','10235','Memory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('991','10235','Inventory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('992','10236','Network interfaces','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('993','10236','General','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('994','10236','Status','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('995','10236','CPU','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('996','10236','Memory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('997','10236','Inventory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('998','10237','Network interfaces','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('999','10237','General','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1000','10237','Status','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1001','10237','CPU','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1002','10237','Memory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1003','10237','Inventory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1028','10250','Network interfaces','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1029','10250','General','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1030','10250','Status','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1031','10250','CPU','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1032','10250','Memory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1033','10250','Temperature','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1034','10250','Fans','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1035','10250','Power supply','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1036','10250','Inventory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1041','10251','Network interfaces','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1042','10251','General','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1043','10251','Status','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1044','10251','Temperature','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1045','10251','Fans','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1046','10251','Power supply','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1047','10251','Inventory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1048','10253','Inventory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1049','10253','Fans','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1050','10253','Power supply','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1051','10253','Temperature','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1052','10253','Memory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1053','10253','Network interfaces','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1054','10253','General','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1055','10253','Status','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1056','10252','CPU','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1057','10253','CPU','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1058','10254','Network interfaces','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1059','10254','General','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1060','10254','Status','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1062','10254','Fans','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1064','10254','Inventory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1066','10254','Power supply','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1068','10254','Temperature','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1069','10255','General','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1070','10255','Status','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1071','10255','Disk arrays','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1072','10255','Fans','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1073','10255','Inventory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1074','10255','Physical disks','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1075','10255','Power supply','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1076','10255','Temperature','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1077','10255','Virtual disks','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1078','10256','General','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1079','10256','Status','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1080','10256','Disk arrays','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1081','10256','Fans','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1082','10256','Inventory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1083','10256','Physical disks','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1084','10256','Power supply','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1085','10256','Temperature','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1086','10256','Virtual disks','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1094','10258','General','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1095','10258','Status','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1096','10258','Fans','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1097','10258','Inventory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1098','10258','Physical disks','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1099','10258','Power supply','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1100','10258','Temperature','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1101','10259','General','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1102','10259','Status','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1103','10259','Fans','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1104','10259','Temperature','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1105','10260','http-8080','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1106','10260','http-8443','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1107','10260','jk-8009','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1108','10260','Sessions','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1109','10260','Tomcat','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1110','10261','Zabbix server','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1111','10262','Zabbix proxy','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1114','10263','PostgreSQL','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1115','10263','Zabbix raw items','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1116','10264','Apache','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1117','10264','Zabbix raw items','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1118','10265','Apache','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1119','10265','Zabbix raw items','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1120','10266','Nginx','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1121','10266','Zabbix raw items','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1122','10267','Nginx','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1123','10267','Zabbix raw items','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1124','10170','Zabbix raw items','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1125','10248','Network interfaces','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1126','10248','General','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1127','10248','Status','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1128','10268','Memory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1129','10269','Storage','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1130','10270','CPU','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1131','10271','Storage','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1132','10248','Memory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1133','10248','Storage','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1134','10248','CPU','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1135','10249','General','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1136','10249','Status','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1141','10249','Network interfaces','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1142','10272','CPU','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1143','10273','Filesystems','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1144','10274','Memory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1145','10275','Storage','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1146','10275','Zabbix raw items','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1147','10276','Network interfaces','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1148','10277','General','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1149','10277','Inventory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1150','10277','Security','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1151','10277','Status','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1152','10001','CPU','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1153','10001','Filesystems','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1154','10001','Memory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1155','10001','Storage','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1156','10001','Zabbix raw items','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1157','10001','Network interfaces','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1158','10001','General','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1159','10001','Inventory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1160','10001','Security','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1161','10001','Status','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1162','10084','CPU','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1163','10084','Filesystems','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1164','10084','Memory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1165','10084','Storage','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1166','10084','Zabbix raw items','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1167','10084','Network interfaces','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1168','10084','General','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1169','10084','Inventory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1170','10084','Security','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1171','10084','Status','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1173','10278','CPU','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1174','10279','Filesystems','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1175','10280','Memory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1176','10281','Storage','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1177','10281','Zabbix raw items','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1178','10282','Network interfaces','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1179','10283','General','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1180','10283','Inventory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1181','10283','Security','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1182','10283','Status','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1183','10284','CPU','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1184','10284','Filesystems','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1185','10284','Memory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1186','10284','Storage','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1187','10284','Zabbix raw items','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1188','10284','Network interfaces','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1189','10284','General','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1190','10284','Inventory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1191','10284','Security','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1192','10284','Status','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1193','10285','CPU','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1194','10285','General','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1195','10285','Inventory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1196','10285','Memory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1197','10285','Monitoring agent','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1198','10285','Network interfaces','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1199','10285','Status','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1200','10285','Storage','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1201','10285','Zabbix raw items','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1202','10286','CPU','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1203','10287','Memory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1204','10288','Filesystems','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1205','10289','Storage','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1207','10290','General','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1208','10290','Inventory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1209','10290','Status','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1210','10291','Network interfaces','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1211','10291','Zabbix raw items','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1212','10081','CPU','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1213','10081','Memory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1214','10081','Filesystems','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1215','10081','Storage','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1216','10081','Zabbix raw items','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1217','10081','General','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1218','10081','Inventory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1219','10081','Status','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1220','10081','Network interfaces','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1221','10050','Monitoring agent','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1222','10050','Status','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1223','10292','Monitoring agent','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1224','10292','Status','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1225','10001','Monitoring agent','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1226','10074','Monitoring agent','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1227','10074','Status','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1228','10075','Monitoring agent','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1229','10075','Status','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1230','10076','Monitoring agent','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1231','10076','Status','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1232','10077','Monitoring agent','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1233','10077','Status','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1234','10078','Monitoring agent','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1235','10078','Status','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1236','10079','Monitoring agent','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1237','10079','Status','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1238','10081','Monitoring agent','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1240','10084','Monitoring agent','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1241','10299','Monitoring agent','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1242','10299','Status','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1243','10293','CPU','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1244','10294','Memory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1245','10295','Filesystems','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1246','10296','Storage','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1248','10297','General','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1249','10297','Inventory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1250','10297','Status','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1251','10298','Network interfaces','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1252','10298','Zabbix raw items','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1253','10299','CPU','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1254','10299','Memory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1255','10299','Filesystems','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1256','10299','Storage','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1257','10299','Zabbix raw items','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1258','10299','General','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1259','10299','Inventory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1260','10299','Network interfaces','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1261','10300','RabbitMQ','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1262','10300','Zabbix raw items','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1263','10301','RabbitMQ','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1264','10301','Zabbix raw items','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1265','10302','RabbitMQ','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1266','10302','Zabbix raw items','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1267','10303','RabbitMQ','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1268','10303','Zabbix raw items','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1269','10284','Monitoring agent','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1270','10304','General','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1271','10304','Status','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1272','10304','Disk arrays','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1273','10304','Fans','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1274','10304','Inventory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1275','10304','Physical disks','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1276','10304','Power supply','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1277','10304','Temperature','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1278','10304','Virtual disks','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1279','10207','Power supply','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1280','10235','Fans','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1281','10235','Power supply','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1282','10235','Temperature','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1283','10305','CPU','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1284','10306','Memory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1285','10307','Storage','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1286','10185','CPU','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1287','10185','Memory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1288','10185','Storage','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1289','10251','CPU','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1290','10251','Memory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1291','10251','Storage','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1292','10249','CPU','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1293','10249','Memory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1294','10249','Storage','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1295','10254','CPU','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1296','10254','Memory','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1297','10254','Storage','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1298','10308','HAProxy','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1299','10308','Zabbix raw items','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1300','10309','HAProxy','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1301','10309','Zabbix raw items','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1302','10310','Redis','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1303','10310','Zabbix raw items','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1310','10314','Services','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1311','10081','Services','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1312','10315','Services','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1313','10299','Services','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1314','10316','MySQL','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1315','10316','Zabbix raw items','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1316','10317','MySQL','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1317','10317','Zabbix raw items','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1318','10318','Docker','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1319','10318','Zabbix raw items','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1320','10319','Memcached','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1321','10319','Zabbix raw items','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1322','10320','MySQL','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1323','10320','Zabbix raw items','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1324','10321','General','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1325','10321','Zabbix raw items','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1326','10322','ES cluster','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1327','10322','Zabbix raw items','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1328','10323','ClickHouse','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1329','10323','ClickHouse ZooKeeper','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1330','10323','Zabbix raw items','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1331','10324','Etcd','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1332','10324','Zabbix raw items','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1333','10325','IIS','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1334','10326','IIS','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1335','10327','MSSQL','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1336','10327','Zabbix raw items','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1337','10328','PostgreSQL','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1338','10328','Zabbix raw items','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1339','10329','Oracle','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1340','10329','Zabbix raw items','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1341','10169','JMX','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1342','10173','VMware','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1343','10174','VMware','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1344','10175','VMware','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1345','10333','Oracle','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1346','10333','Zabbix raw items','0');
INSERT INTO applications (applicationid,hostid,name,flags) values ('1347','10233','Wireless','0');
INSERT INTO interface (interfaceid,hostid,main,type,useip,ip,dns,port) values ('1','10084','1','1','1','127.0.0.1','','10050');
INSERT INTO valuemaps (valuemapid,name) values ('1','Service state');
INSERT INTO valuemaps (valuemapid,name) values ('2','Host availability');
INSERT INTO valuemaps (valuemapid,name) values ('3','Windows service state');
INSERT INTO valuemaps (valuemapid,name) values ('4','APC Battery Replacement Status');
INSERT INTO valuemaps (valuemapid,name) values ('5','APC Battery Status');
INSERT INTO valuemaps (valuemapid,name) values ('6','HP Insight System Status');
INSERT INTO valuemaps (valuemapid,name) values ('7','Dell Open Manage System Status');
INSERT INTO valuemaps (valuemapid,name) values ('8','SNMP interface status (ifOperStatus)');
INSERT INTO valuemaps (valuemapid,name) values ('9','SNMP device status (hrDeviceStatus)');
INSERT INTO valuemaps (valuemapid,name) values ('10','Zabbix agent ping status');
INSERT INTO valuemaps (valuemapid,name) values ('11','SNMP interface status (ifAdminStatus)');
INSERT INTO valuemaps (valuemapid,name) values ('12','VMware VirtualMachinePowerState');
INSERT INTO valuemaps (valuemapid,name) values ('13','VMware status');
INSERT INTO valuemaps (valuemapid,name) values ('14','Maintenance status');
INSERT INTO valuemaps (valuemapid,name) values ('15','Value cache operating mode');
INSERT INTO valuemaps (valuemapid,name) values ('16','Windows service startup type');
INSERT INTO valuemaps (valuemapid,name) values ('17','HTTP response status code');
INSERT INTO valuemaps (valuemapid,name) values ('18','ENTITY-SENSORS-MIB::EntitySensorStatus');
INSERT INTO valuemaps (valuemapid,name) values ('19','EtherLike-MIB::dot3StatsDuplexStatus');
INSERT INTO valuemaps (valuemapid,name) values ('20','IF-MIB::ifOperStatus');
INSERT INTO valuemaps (valuemapid,name) values ('21','IF-MIB::ifType');
INSERT INTO valuemaps (valuemapid,name) values ('22','zabbix.host.available');
INSERT INTO valuemaps (valuemapid,name) values ('23','TIMETRA-CHASSIS-MIB::TmnxDeviceState');
INSERT INTO valuemaps (valuemapid,name) values ('24','SW-MIB::swSensorStatus');
INSERT INTO valuemaps (valuemapid,name) values ('25','SW-MIB::swOperStatus');
INSERT INTO valuemaps (valuemapid,name) values ('26','FOUNDRY-SN-AGENT-MIB::snChasPwrSupplyOperStatus');
INSERT INTO valuemaps (valuemapid,name) values ('27','FOUNDRY-SN-AGENT-MIB::snChasFanOperStatus');
INSERT INTO valuemaps (valuemapid,name) values ('28','CISCO-ENVMON-MIB::CiscoEnvMonState');
INSERT INTO valuemaps (valuemapid,name) values ('29','F10-S-SERIES-CHASSIS-MIB::extremeFanOperational');
INSERT INTO valuemaps (valuemapid,name) values ('30','F10-S-SERIES-CHASSIS-MIB::chSysFanTrayOperStatus');
INSERT INTO valuemaps (valuemapid,name) values ('31','F10-S-SERIES-CHASSIS-MIB::chSysPowerSupplyOperStatus');
INSERT INTO valuemaps (valuemapid,name) values ('32','MY-SYSTEM-MIB::mySystemFanIsNormal');
INSERT INTO valuemaps (valuemapid,name) values ('33','EQUIPMENT-MIB::swFanStatus');
INSERT INTO valuemaps (valuemapid,name) values ('34','EQUIPMENT-MIB::swPowerStatus');
INSERT INTO valuemaps (valuemapid,name) values ('35','TruthValue');
INSERT INTO valuemaps (valuemapid,name) values ('36','EXTREME-SYSTEM-MIB::extremeFanOperational');
INSERT INTO valuemaps (valuemapid,name) values ('37','EXTREME-SYSTEM-MIB::extremeOverTemperatureAlarm');
INSERT INTO valuemaps (valuemapid,name) values ('38','EXTREME-SYSTEM-MIB::extremePowerSupplyStatus');
INSERT INTO valuemaps (valuemapid,name) values ('39','HH3C-ENTITY-EXT-MIB::hh3cEntityExtErrorStatus');
INSERT INTO valuemaps (valuemapid,name) values ('40','HP-ICF-CHASSIS::hpicfSensorStatus');
INSERT INTO valuemaps (valuemapid,name) values ('41','HUAWEI-ENTITY-EXTENT-MIB::hwEntityFanState');
INSERT INTO valuemaps (valuemapid,name) values ('42','ICS-CHASSIS-MIB::icsChassisFanOperStatus');
INSERT INTO valuemaps (valuemapid,name) values ('43','ICS-CHASSIS-MIB::icsChassisSensorSlotOperStatus');
INSERT INTO valuemaps (valuemapid,name) values ('44','ICS-CHASSIS-MIB::icsChassisPowerSupplyOperStatus');
INSERT INTO valuemaps (valuemapid,name) values ('45','ICS-CHASSIS-MIB::icsChassisTemperatureStatus');
INSERT INTO valuemaps (valuemapid,name) values ('46','JUNIPER-ALARM-MIB::jnxRedAlarmState');
INSERT INTO valuemaps (valuemapid,name) values ('47','JUNIPER-ALARM-MIB::jnxOperatingState');
INSERT INTO valuemaps (valuemapid,name) values ('48','ENTITY-STATE-MIB::EntityOperState');
INSERT INTO valuemaps (valuemapid,name) values ('49','FASTPATH-BOXSERVICES-PRIVATE-MIB::boxServicesPowSupplyItemState');
INSERT INTO valuemaps (valuemapid,name) values ('50','FASTPATH-BOXSERVICES-PRIVATE-MIB::boxServicesFanItemState');
INSERT INTO valuemaps (valuemapid,name) values ('51','FASTPATH-BOXSERVICES-PRIVATE-MIB::boxServicesTempSensorState');
INSERT INTO valuemaps (valuemapid,name) values ('52','QTECH-MIB::sysFanStatus');
INSERT INTO valuemaps (valuemapid,name) values ('53','QTECH-MIB::sysPowerStatus');
INSERT INTO valuemaps (valuemapid,name) values ('54','CPQSINFO-MIB::status');
INSERT INTO valuemaps (valuemapid,name) values ('55','CPQHLTH-MIB::cpqHeTemperatureLocale');
INSERT INTO valuemaps (valuemapid,name) values ('56','CPQIDA-MIB::cpqDaCntlrModel');
INSERT INTO valuemaps (valuemapid,name) values ('57','CPQIDA-MIB::cpqDaPhyDrvStatus');
INSERT INTO valuemaps (valuemapid,name) values ('58','IMM-MIB::systemHealthStat');
INSERT INTO valuemaps (valuemapid,name) values ('59','IDRAC-MIB-SMIv2::ObjectStatusEnum');
INSERT INTO valuemaps (valuemapid,name) values ('60','IDRAC-MIB-SMIv2::StatusProbeEnum');
INSERT INTO valuemaps (valuemapid,name) values ('61','IDRAC-MIB-SMIv2::physicalDiskComponentStatus');
INSERT INTO valuemaps (valuemapid,name) values ('62','IDRAC-MIB-SMIv2::BooleanType');
INSERT INTO valuemaps (valuemapid,name) values ('63','IDRAC-MIB-SMIv2::physicalDiskMediaType');
INSERT INTO valuemaps (valuemapid,name) values ('64','IDRAC-MIB-SMIv2::batteryState');
INSERT INTO valuemaps (valuemapid,name) values ('65','IDRAC-MIB-SMIv2::virtualDiskLayout');
INSERT INTO valuemaps (valuemapid,name) values ('66','IDRAC-MIB-SMIv2::virtualDiskOperationalState');
INSERT INTO valuemaps (valuemapid,name) values ('67','IDRAC-MIB-SMIv2::virtualDiskWritePolicy');
INSERT INTO valuemaps (valuemapid,name) values ('68','IDRAC-MIB-SMIv2::virtualDiskReadPolicy');
INSERT INTO valuemaps (valuemapid,name) values ('69','IDRAC-MIB-SMIv2::virtualDiskState');
INSERT INTO valuemaps (valuemapid,name) values ('70','CPQIDA-MIB::cpqDaPhyDrvSmartStatus');
INSERT INTO valuemaps (valuemapid,name) values ('71','CPQIDA-MIB::cpqDaAccelStatus');
INSERT INTO valuemaps (valuemapid,name) values ('72','CPQIDA-MIB::cpqDaAccelBattery');
INSERT INTO valuemaps (valuemapid,name) values ('73','CPQIDA-MIB::cpqDaPhyDrvMediaType');
INSERT INTO valuemaps (valuemapid,name) values ('74','CPQIDA-MIB::cpqDaLogDrvFaultTol');
INSERT INTO valuemaps (valuemapid,name) values ('75','CPQIDA-MIB::cpqDaLogDrvStatus');
INSERT INTO valuemaps (valuemapid,name) values ('76','PostgreSQL recovery role');
INSERT INTO valuemaps (valuemapid,name) values ('77','PostgreSQL replication status');
INSERT INTO valuemaps (valuemapid,name) values ('78','Linux::Interface protocol types');
INSERT INTO valuemaps (valuemapid,name) values ('79','Win32_NetworkAdapter::AdapterTypeId');
INSERT INTO valuemaps (valuemapid,name) values ('80','CIM_LogicalDevice::Availability');
INSERT INTO valuemaps (valuemapid,name) values ('81','Win32_NetworkAdapter::NetConnectionStatus');
INSERT INTO valuemaps (valuemapid,name) values ('82','RabbitMQ healthcheck');
INSERT INTO valuemaps (valuemapid,name) values ('83','Alarm state');
INSERT INTO valuemaps (valuemapid,name) values ('84','CISCO-UNIFIED-COMPUTING-TC-MIB::CucsEquipmentOperability');
INSERT INTO valuemaps (valuemapid,name) values ('85','CISCO-UNIFIED-COMPUTING-TC-MIB::CucsLsOperState');
INSERT INTO valuemaps (valuemapid,name) values ('86','CISCO-UNIFIED-COMPUTING-TC-MIB::CucsStoragePDriveStatus');
INSERT INTO valuemaps (valuemapid,name) values ('87','CISCO-UNIFIED-COMPUTING-TC-MIB::CucsStorageLunType');
INSERT INTO valuemaps (valuemapid,name) values ('88','CISCO-UNIFIED-COMPUTING-TC-MIB::CucsEquipmentPresence');
INSERT INTO valuemaps (valuemapid,name) values ('89','Redis bgwrite status');
INSERT INTO valuemaps (valuemapid,name) values ('90','Redis flag');
INSERT INTO valuemaps (valuemapid,name) values ('91','Redis repl offset');
INSERT INTO valuemaps (valuemapid,name) values ('92','Redis bgsave time');
INSERT INTO valuemaps (valuemapid,name) values ('93','Docker flag');
INSERT INTO valuemaps (valuemapid,name) values ('94','ES cluster state');
INSERT INTO valuemaps (valuemapid,name) values ('95','Replicas state');
INSERT INTO valuemaps (valuemapid,name) values ('96','Etcd healthcheck');
INSERT INTO valuemaps (valuemapid,name) values ('97','Etcd leader');
INSERT INTO valuemaps (valuemapid,name) values ('98','Application pool state');
INSERT INTO valuemaps (valuemapid,name) values ('99','MSSQL DB state');
INSERT INTO valuemaps (valuemapid,name) values ('100','MSSQL AG Connected state');
INSERT INTO valuemaps (valuemapid,name) values ('101','MSSQL AG Join state');
INSERT INTO valuemaps (valuemapid,name) values ('102','MSSQL AG Operational state');
INSERT INTO valuemaps (valuemapid,name) values ('103','MSSQL AG Recovery health');
INSERT INTO valuemaps (valuemapid,name) values ('104','MSSQL AG Role');
INSERT INTO valuemaps (valuemapid,name) values ('105','MSSQL AG Suspend state');
INSERT INTO valuemaps (valuemapid,name) values ('106','MSSQL AG Synchronization health');
INSERT INTO valuemaps (valuemapid,name) values ('107','MSSQL - Yes / No');
INSERT INTO valuemaps (valuemapid,name) values ('108','MSSQL Mirroring State');
INSERT INTO valuemaps (valuemapid,name) values ('109','MSSQL Mirroring Role');
INSERT INTO valuemaps (valuemapid,name) values ('110','MSSQL Safety level');
INSERT INTO valuemaps (valuemapid,name) values ('111','MSSQL Witness state');
INSERT INTO valuemaps (valuemapid,name) values ('112','Oracle DB open status');
INSERT INTO valuemaps (valuemapid,name) values ('113','Oracle DB role');
INSERT INTO valuemaps (valuemapid,name) values ('114','Oracle instance status');
INSERT INTO valuemaps (valuemapid,name) values ('115','Oracle instance role');
INSERT INTO valuemaps (valuemapid,name) values ('116','Oracle archiver state');
INSERT INTO valuemaps (valuemapid,name) values ('117','Oracle tablespace status');
INSERT INTO valuemaps (valuemapid,name) values ('118','Oracle Archivelog status');
INSERT INTO valuemaps (valuemapid,name) values ('119','Oracle force log status');
INSERT INTO valuemaps (valuemapid,name) values ('120','Oracle log mode');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('10061','5','','10047','Number of processed numeric (float) values per second','zabbix[wcache,values,float]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('10062','5','','10047','Number of processed character values per second','zabbix[wcache,values,str]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('10063','5','','10047','Number of processed log values per second','zabbix[wcache,values,log]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('10064','5','','10047','Number of processed numeric (unsigned) values per second','zabbix[wcache,values,uint]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('10065','5','','10047','Number of processed text values per second','zabbix[wcache,values,text]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('10066','5','','10047','Number of processed not supported values per second','zabbix[wcache,values,not supported]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('10067','5','','10048','Number of processed numeric (float) values per second','zabbix[wcache,values,float]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','1','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('10068','5','','10048','Number of processed character values per second','zabbix[wcache,values,str]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','1','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('10069','5','','10048','Number of processed log values per second','zabbix[wcache,values,log]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','1','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('10070','5','','10048','Number of processed numeric (unsigned) values per second','zabbix[wcache,values,uint]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','1','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('10071','5','','10048','Number of processed text values per second','zabbix[wcache,values,text]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','1','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('10072','5','','10048','Number of processed not supported values per second','zabbix[wcache,values,not supported]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','1','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22183','5','','10047','Zabbix history write cache, % used','zabbix[wcache,history,pused]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22185','5','','10047','Zabbix trend write cache, % used','zabbix[wcache,trend,pused]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22187','5','','10047','Number of processed values per second','zabbix[wcache,values]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22189','5','','10047','Zabbix configuration cache, % used','zabbix[rcache,buffer,pused]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22191','5','','10047','Zabbix value cache, % used','zabbix[vcache,buffer,pused]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22196','5','','10047','Zabbix value cache hits','zabbix[vcache,cache,hits]','1m','1w','365d','0','0','','vps','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22199','5','','10047','Zabbix value cache misses','zabbix[vcache,cache,misses]','1m','1w','365d','0','0','','vps','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22219','5','','10047','Zabbix queue over 10 minutes','zabbix[queue,10m]','10m','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22231','0','','10050','Version of Zabbix agent running','agent.version','1h','7d','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22232','0','','10050','Zabbix agent ping','agent.ping','1m','7d','365d','0','3','','','','',NULL,'10','','','0','','','','','0',NULL,'The agent always returns 1 for this item. It could be used in combination with nodata() for availability check.','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22396','5','','10047','Zabbix history index cache, % used','zabbix[wcache,index,pused]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22399','5','','10047','Utilization of poller data collector processes, in %','zabbix[process,poller,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22400','5','','10047','Utilization of unreachable poller data collector processes, in %','zabbix[process,unreachable poller,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22401','5','','10047','Utilization of vmware data collector processes, in %','zabbix[process,vmware collector,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22402','5','','10047','Utilization of http poller data collector processes, in %','zabbix[process,http poller,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22404','5','','10047','Utilization of trapper data collector processes, in %','zabbix[process,trapper,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22406','5','','10047','Utilization of history syncer internal processes, in %','zabbix[process,history syncer,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22408','5','','10047','Utilization of housekeeper internal processes, in %','zabbix[process,housekeeper,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22412','5','','10047','Utilization of configuration syncer internal processes, in %','zabbix[process,configuration syncer,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22414','5','','10047','Utilization of self-monitoring internal processes, in %','zabbix[process,self-monitoring,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22416','5','','10047','Utilization of ipmi poller data collector processes, in %','zabbix[process,ipmi poller,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22418','5','','10047','Utilization of icmp pinger data collector processes, in %','zabbix[process,icmp pinger,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22420','5','','10047','Utilization of proxy poller data collector processes, in %','zabbix[process,proxy poller,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22422','5','','10047','Utilization of escalator internal processes, in %','zabbix[process,escalator,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22424','5','','10047','Utilization of alerter internal processes, in %','zabbix[process,alerter,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22426','5','','10047','Utilization of timer internal processes, in %','zabbix[process,timer,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22430','5','','10047','Utilization of discoverer data collector processes, in %','zabbix[process,discoverer,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22689','5','','10047','Utilization of java poller data collector processes, in %','zabbix[process,java poller,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22835','0','','10074','Maximum number of opened files','kernel.maxfiles','1h','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'It could be increased by using sysctrl utility or modifying file /etc/sysctl.conf.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22836','0','','10074','Maximum number of processes','kernel.maxproc','1h','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'It could be increased by using sysctrl utility or modifying file /etc/sysctl.conf.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22837','0','','10074','Number of running processes','proc.num[,,run]','1m','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Number of processes in running state.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22838','0','','10074','Number of processes','proc.num[]','1m','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Total number of processes in any state.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22839','0','','10074','Host boot time','system.boottime','10m','1w','365d','0','3','','unixtime','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22840','0','','10074','Interrupts per second','system.cpu.intr','1m','1w','365d','0','3','','ips','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22841','0','','10074','Processor load (15 min average per core)','system.cpu.load[percpu,avg15]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The processor load is calculated as system CPU load divided by number of CPU cores.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22842','0','','10074','Processor load (1 min average per core)','system.cpu.load[percpu,avg1]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The processor load is calculated as system CPU load divided by number of CPU cores.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22843','0','','10074','Processor load (5 min average per core)','system.cpu.load[percpu,avg5]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The processor load is calculated as system CPU load divided by number of CPU cores.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22844','0','','10074','Context switches per second','system.cpu.switches','1m','1w','365d','0','3','','sps','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22845','0','','10074','CPU idle time','system.cpu.util[,idle]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'The time the CPU has spent doing nothing.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22846','0','','10074','CPU interrupt time','system.cpu.util[,interrupt]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'The amount of time the CPU has been servicing hardware interrupts.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22848','0','','10074','CPU nice time','system.cpu.util[,nice]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'The time the CPU has spent running users'' processes that have been niced.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22851','0','','10074','CPU system time','system.cpu.util[,system]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'The time the CPU has spent running the kernel and its processes.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22852','0','','10074','CPU user time','system.cpu.util[,user]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'The time the CPU has spent running users'' processes that are not niced.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22853','0','','10074','Host name','system.hostname','1h','1w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'System host name.','3','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22854','0','','10074','Host local time','system.localtime','1m','1w','365d','0','3','','unixtime','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22855','0','','10074','Free swap space','system.swap.size[,free]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22856','0','','10074','Free swap space in %','system.swap.size[,pfree]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22857','0','','10074','Total swap space','system.swap.size[,total]','1h','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22858','0','','10074','System information','system.uname','1h','1w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The information as normally returned by ''uname -a''.','5','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22859','0','','10074','System uptime','system.uptime','10m','1w','365d','0','3','','uptime','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22860','0','','10074','Number of logged in users','system.users.num','1m','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Number of users who are currently logged in.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22861','0','','10074','Checksum of /etc/passwd','vfs.file.cksum[/etc/passwd]','1h','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22862','0','','10074','Available memory','vm.memory.size[available]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'Available memory is defined as free+cached+buffers memory.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22863','0','','10074','Total memory','vm.memory.size[total]','1h','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22867','0','','10074','Mounted filesystem discovery','vfs.fs.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Discovery of file systems of different types as defined in global regular expression "File systems for discovery".','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22868','0','','10074','Free disk space on {#FSNAME}','vfs.fs.size[{#FSNAME},free]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22869','0','','10074','Free inodes on {#FSNAME} (percentage)','vfs.fs.inode[{#FSNAME},pfree]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22870','0','','10074','Total disk space on {#FSNAME}','vfs.fs.size[{#FSNAME},total]','1h','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22871','0','','10074','Used disk space on {#FSNAME}','vfs.fs.size[{#FSNAME},used]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22872','0','','10074','Free disk space on {#FSNAME} (percentage)','vfs.fs.size[{#FSNAME},pfree]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22875','0','','10075','Maximum number of opened files','kernel.maxfiles','1h','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'It could be increased by using sysctrl utility or modifying file /etc/sysctl.conf.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22876','0','','10075','Maximum number of processes','kernel.maxproc','1h','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'It could be increased by using sysctrl utility or modifying file /etc/sysctl.conf.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22877','0','','10075','Number of running processes','proc.num[,,run]','1m','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Number of processes in running state.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22878','0','','10075','Number of processes','proc.num[]','1m','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Total number of processes in any state.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22879','0','','10075','Host boot time','system.boottime','10m','1w','365d','0','3','','unixtime','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22880','0','','10075','Interrupts per second','system.cpu.intr','1m','1w','365d','0','3','','ips','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22881','0','','10075','Processor load (15 min average per core)','system.cpu.load[percpu,avg15]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The processor load is calculated as system CPU load divided by number of CPU cores.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22882','0','','10075','Processor load (1 min average per core)','system.cpu.load[percpu,avg1]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The processor load is calculated as system CPU load divided by number of CPU cores.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22883','0','','10075','Processor load (5 min average per core)','system.cpu.load[percpu,avg5]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The processor load is calculated as system CPU load divided by number of CPU cores.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22884','0','','10075','Context switches per second','system.cpu.switches','1m','1w','365d','0','3','','sps','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22885','0','','10075','CPU idle time','system.cpu.util[,idle]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'The time the CPU has spent doing nothing.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22886','0','','10075','CPU interrupt time','system.cpu.util[,interrupt]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'The amount of time the CPU has been servicing hardware interrupts.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22888','0','','10075','CPU nice time','system.cpu.util[,nice]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'The time the CPU has spent running users'' processes that have been niced.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22891','0','','10075','CPU system time','system.cpu.util[,system]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'The time the CPU has spent running the kernel and its processes.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22892','0','','10075','CPU user time','system.cpu.util[,user]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'The time the CPU has spent running users'' processes that are not niced.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22893','0','','10075','Host name','system.hostname','1h','1w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'System host name.','3','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22894','0','','10075','Host local time','system.localtime','1m','1w','365d','0','3','','unixtime','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22895','0','','10075','Free swap space','system.swap.size[,free]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22896','0','','10075','Free swap space in %','system.swap.size[,pfree]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22897','0','','10075','Total swap space','system.swap.size[,total]','1h','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22898','0','','10075','System information','system.uname','1h','1w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The information as normally returned by ''uname -a''.','5','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22899','0','','10075','System uptime','system.uptime','10m','1w','365d','0','3','','uptime','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22900','0','','10075','Number of logged in users','system.users.num','1m','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Number of users who are currently logged in.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22901','0','','10075','Checksum of /etc/passwd','vfs.file.cksum[/etc/passwd]','1h','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22902','0','','10075','Available memory','vm.memory.size[available]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'Available memory is defined as free+cached+buffers memory.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22903','0','','10075','Total memory','vm.memory.size[total]','1h','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22907','0','','10075','Mounted filesystem discovery','vfs.fs.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Discovery of file systems of different types as defined in global regular expression "File systems for discovery".','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22908','0','','10075','Free disk space on {#FSNAME}','vfs.fs.size[{#FSNAME},free]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22909','0','','10075','Free inodes on {#FSNAME} (percentage)','vfs.fs.inode[{#FSNAME},pfree]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22910','0','','10075','Total disk space on {#FSNAME}','vfs.fs.size[{#FSNAME},total]','1h','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22911','0','','10075','Used disk space on {#FSNAME}','vfs.fs.size[{#FSNAME},used]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22912','0','','10075','Free disk space on {#FSNAME} (percentage)','vfs.fs.size[{#FSNAME},pfree]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22917','0','','10076','Number of running processes','proc.num[,,run]','1m','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Number of processes in running state.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22918','0','','10076','Number of processes','proc.num[]','1m','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Total number of processes in any state.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22920','0','','10076','Interrupts per second','system.cpu.intr','1m','1w','365d','0','3','','ips','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22921','0','','10076','Processor load (15 min average per core)','system.cpu.load[percpu,avg15]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The processor load is calculated as system CPU load divided by number of CPU cores.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22922','0','','10076','Processor load (1 min average per core)','system.cpu.load[percpu,avg1]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The processor load is calculated as system CPU load divided by number of CPU cores.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22923','0','','10076','Processor load (5 min average per core)','system.cpu.load[percpu,avg5]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The processor load is calculated as system CPU load divided by number of CPU cores.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22924','0','','10076','Context switches per second','system.cpu.switches','1m','1w','365d','0','3','','sps','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22933','0','','10076','Host name','system.hostname','1h','1w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'System host name.','3','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22934','0','','10076','Host local time','system.localtime','1m','1w','365d','0','3','','unixtime','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22938','0','','10076','System information','system.uname','1h','1w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The information as normally returned by ''uname -a''.','5','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22939','0','','10076','System uptime','system.uptime','10m','1w','365d','0','3','','uptime','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22940','0','','10076','Number of logged in users','system.users.num','1m','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Number of users who are currently logged in.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22941','0','','10076','Checksum of /etc/passwd','vfs.file.cksum[/etc/passwd]','1h','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22942','0','','10076','Available memory','vm.memory.size[available]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'Available memory is defined as free+cached+buffers memory.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22943','0','','10076','Total memory','vm.memory.size[total]','1h','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22944','0','','10076','Network interface discovery','net.if.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Discovery of network interfaces as defined in global regular expression "Network interfaces for discovery".','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22945','0','','10076','Incoming network traffic on {#IFNAME}','net.if.in[{#IFNAME}]','1m','1w','365d','0','3','','bps','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22946','0','','10076','Outgoing network traffic on {#IFNAME}','net.if.out[{#IFNAME}]','1m','1w','365d','0','3','','bps','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22947','0','','10076','Mounted filesystem discovery','vfs.fs.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Discovery of file systems of different types as defined in global regular expression "File systems for discovery".','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22948','0','','10076','Free disk space on {#FSNAME}','vfs.fs.size[{#FSNAME},free]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22949','0','','10076','Free inodes on {#FSNAME} (percentage)','vfs.fs.inode[{#FSNAME},pfree]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22950','0','','10076','Total disk space on {#FSNAME}','vfs.fs.size[{#FSNAME},total]','1h','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22951','0','','10076','Used disk space on {#FSNAME}','vfs.fs.size[{#FSNAME},used]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22952','0','','10076','Free disk space on {#FSNAME} (percentage)','vfs.fs.size[{#FSNAME},pfree]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22961','0','','10077','Processor load (15 min average per core)','system.cpu.load[percpu,avg15]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The processor load is calculated as system CPU load divided by number of CPU cores.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22962','0','','10077','Processor load (1 min average per core)','system.cpu.load[percpu,avg1]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The processor load is calculated as system CPU load divided by number of CPU cores.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22963','0','','10077','Processor load (5 min average per core)','system.cpu.load[percpu,avg5]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The processor load is calculated as system CPU load divided by number of CPU cores.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22965','0','','10077','CPU idle time','system.cpu.util[,idle]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'The time the CPU has spent doing nothing.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22968','0','','10077','CPU nice time','system.cpu.util[,nice]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'The time the CPU has spent running users'' processes that have been niced.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22971','0','','10077','CPU system time','system.cpu.util[,system]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'The time the CPU has spent running the kernel and its processes.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22972','0','','10077','CPU user time','system.cpu.util[,user]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'The time the CPU has spent running users'' processes that are not niced.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22973','0','','10077','Host name','system.hostname','1h','1w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'System host name.','3','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22974','0','','10077','Host local time','system.localtime','1m','1w','365d','0','3','','unixtime','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22978','0','','10077','System information','system.uname','1h','1w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The information as normally returned by ''uname -a''.','5','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22980','0','','10077','Number of logged in users','system.users.num','1m','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Number of users who are currently logged in.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22981','0','','10077','Checksum of /etc/passwd','vfs.file.cksum[/etc/passwd]','1h','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22982','0','','10077','Available memory','vm.memory.size[available]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'Available memory is defined as free+cached+buffers memory.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22983','0','','10077','Total memory','vm.memory.size[total]','1h','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22984','0','','10077','Network interface discovery','net.if.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Discovery of network interfaces as defined in global regular expression "Network interfaces for discovery".','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22985','0','','10077','Incoming network traffic on {#IFNAME}','net.if.in[{#IFNAME}]','1m','1w','365d','0','3','','bps','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22986','0','','10077','Outgoing network traffic on {#IFNAME}','net.if.out[{#IFNAME}]','1m','1w','365d','0','3','','bps','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22987','0','','10077','Mounted filesystem discovery','vfs.fs.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Discovery of file systems of different types as defined in global regular expression "File systems for discovery".','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22988','0','','10077','Free disk space on {#FSNAME}','vfs.fs.size[{#FSNAME},free]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22989','0','','10077','Free inodes on {#FSNAME} (percentage)','vfs.fs.inode[{#FSNAME},pfree]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22990','0','','10077','Total disk space on {#FSNAME}','vfs.fs.size[{#FSNAME},total]','1h','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22991','0','','10077','Used disk space on {#FSNAME}','vfs.fs.size[{#FSNAME},used]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22992','0','','10077','Free disk space on {#FSNAME} (percentage)','vfs.fs.size[{#FSNAME},pfree]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22996','0','','10078','Maximum number of processes','kernel.maxproc','1h','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'It could be increased by using sysctrl utility or modifying file /etc/sysctl.conf.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22997','0','','10078','Number of running processes','proc.num[,,run]','1m','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Number of processes in running state.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22998','0','','10078','Number of processes','proc.num[]','1m','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Total number of processes in any state.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('22999','0','','10078','Host boot time','system.boottime','10m','1w','365d','0','3','','unixtime','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23000','0','','10078','Interrupts per second','system.cpu.intr','1m','1w','365d','0','3','','ips','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23001','0','','10078','Processor load (15 min average per core)','system.cpu.load[percpu,avg15]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The processor load is calculated as system CPU load divided by number of CPU cores.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23002','0','','10078','Processor load (1 min average per core)','system.cpu.load[percpu,avg1]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The processor load is calculated as system CPU load divided by number of CPU cores.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23003','0','','10078','Processor load (5 min average per core)','system.cpu.load[percpu,avg5]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The processor load is calculated as system CPU load divided by number of CPU cores.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23004','0','','10078','Context switches per second','system.cpu.switches','1m','1w','365d','0','3','','sps','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23005','0','','10078','CPU idle time','system.cpu.util[,idle]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'The time the CPU has spent doing nothing.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23007','0','','10078','CPU iowait time','system.cpu.util[,iowait]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Amount of time the CPU has been waiting for I/O to complete.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23011','0','','10078','CPU system time','system.cpu.util[,system]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'The time the CPU has spent running the kernel and its processes.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23012','0','','10078','CPU user time','system.cpu.util[,user]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'The time the CPU has spent running users'' processes that are not niced.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23013','0','','10078','Host name','system.hostname','1h','1w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'System host name.','3','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23014','0','','10078','Host local time','system.localtime','1m','1w','365d','0','3','','unixtime','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23015','0','','10078','Free swap space','system.swap.size[,free]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23016','0','','10078','Free swap space in %','system.swap.size[,pfree]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23017','0','','10078','Total swap space','system.swap.size[,total]','1h','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23018','0','','10078','System information','system.uname','1h','1w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The information as normally returned by ''uname -a''.','5','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23019','0','','10078','System uptime','system.uptime','10m','1w','365d','0','3','','uptime','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23020','0','','10078','Number of logged in users','system.users.num','1m','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Number of users who are currently logged in.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23021','0','','10078','Checksum of /etc/passwd','vfs.file.cksum[/etc/passwd]','1h','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23022','0','','10078','Available memory','vm.memory.size[available]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'Available memory is defined as free+cached+buffers memory.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23023','0','','10078','Total memory','vm.memory.size[total]','1h','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23024','0','','10078','Network interface discovery','net.if.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Discovery of network interfaces as defined in global regular expression "Network interfaces for discovery".','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23025','0','','10078','Incoming network traffic on {#IFNAME}','net.if.in[{#IFNAME}]','1m','1w','365d','0','3','','bps','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23026','0','','10078','Outgoing network traffic on {#IFNAME}','net.if.out[{#IFNAME}]','1m','1w','365d','0','3','','bps','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23027','0','','10078','Mounted filesystem discovery','vfs.fs.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Discovery of file systems of different types as defined in global regular expression "File systems for discovery".','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23028','0','','10078','Free disk space on {#FSNAME}','vfs.fs.size[{#FSNAME},free]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23029','0','','10078','Free inodes on {#FSNAME} (percentage)','vfs.fs.inode[{#FSNAME},pfree]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23030','0','','10078','Total disk space on {#FSNAME}','vfs.fs.size[{#FSNAME},total]','1h','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23031','0','','10078','Used disk space on {#FSNAME}','vfs.fs.size[{#FSNAME},used]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23032','0','','10078','Free disk space on {#FSNAME} (percentage)','vfs.fs.size[{#FSNAME},pfree]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23035','0','','10079','Maximum number of opened files','kernel.maxfiles','1h','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'It could be increased by using sysctrl utility or modifying file /etc/sysctl.conf.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23036','0','','10079','Maximum number of processes','kernel.maxproc','1h','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'It could be increased by using sysctrl utility or modifying file /etc/sysctl.conf.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23039','0','','10079','Host boot time','system.boottime','10m','1w','365d','0','3','','unixtime','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23041','0','','10079','Processor load (15 min average per core)','system.cpu.load[percpu,avg15]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The processor load is calculated as system CPU load divided by number of CPU cores.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23042','0','','10079','Processor load (1 min average per core)','system.cpu.load[percpu,avg1]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The processor load is calculated as system CPU load divided by number of CPU cores.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23043','0','','10079','Processor load (5 min average per core)','system.cpu.load[percpu,avg5]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The processor load is calculated as system CPU load divided by number of CPU cores.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23053','0','','10079','Host name','system.hostname','1h','1w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'System host name.','3','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23054','0','','10079','Host local time','system.localtime','1m','1w','365d','0','3','','unixtime','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23058','0','','10079','System information','system.uname','1h','1w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The information as normally returned by ''uname -a''.','5','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23059','0','','10079','System uptime','system.uptime','10m','1w','365d','0','3','','uptime','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23060','0','','10079','Number of logged in users','system.users.num','1m','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Number of users who are currently logged in.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23061','0','','10079','Checksum of /etc/passwd','vfs.file.cksum[/etc/passwd]','1h','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23062','0','','10079','Available memory','vm.memory.size[available]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'Available memory is defined as free+cached+buffers memory.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23063','0','','10079','Total memory','vm.memory.size[total]','1h','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23067','0','','10079','Mounted filesystem discovery','vfs.fs.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Discovery of file systems of different types as defined in global regular expression "File systems for discovery".','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23068','0','','10079','Free disk space on {#FSNAME}','vfs.fs.size[{#FSNAME},free]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23069','0','','10079','Free inodes on {#FSNAME} (percentage)','vfs.fs.inode[{#FSNAME},pfree]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23070','0','','10079','Total disk space on {#FSNAME}','vfs.fs.size[{#FSNAME},total]','1h','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23071','0','','10079','Used disk space on {#FSNAME}','vfs.fs.size[{#FSNAME},used]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23072','0','','10079','Free disk space on {#FSNAME} (percentage)','vfs.fs.size[{#FSNAME},pfree]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23073','0','','10075','Incoming network traffic on {#IFNAME}','net.if.in[{#IFNAME}]','1m','1w','365d','0','3','','bps','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23074','0','','10075','Outgoing network traffic on {#IFNAME}','net.if.out[{#IFNAME}]','1m','1w','365d','0','3','','bps','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23075','0','','10074','Incoming network traffic on {#IFNAME}','net.if.in[{#IFNAME}]','1m','1w','365d','0','3','','bps','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23076','0','','10074','Outgoing network traffic on {#IFNAME}','net.if.out[{#IFNAME}]','1m','1w','365d','0','3','','bps','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23077','0','','10079','Incoming network traffic on en0','net.if.in[en0]','1m','1w','365d','0','3','','bps','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23078','0','','10079','Outgoing network traffic on en0','net.if.out[en0]','1m','1w','365d','0','3','','bps','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23108','0','','10076','CPU available physical processors in the shared pool','system.stat[cpu,app]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23109','0','','10076','CPU entitled capacity consumed','system.stat[cpu,ec]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23110','0','','10076','CPU idle time','system.stat[cpu,id]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23111','0','','10076','CPU logical processor utilization','system.stat[cpu,lbusy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23112','0','','10076','CPU number of physical processors consumed','system.stat[cpu,pc]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23113','0','','10076','CPU system time','system.stat[cpu,sy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23114','0','','10076','CPU user time','system.stat[cpu,us]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23115','0','','10076','CPU iowait time','system.stat[cpu,wa]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23116','0','','10076','Amount of data transferred','system.stat[disk,bps]','1m','1w','365d','0','0','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23117','0','','10076','Number of transfers','system.stat[disk,tps]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23118','0','','10076','Processor units is entitled to receive','system.stat[ent]','1h','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23119','0','','10076','Kernel thread context switches','system.stat[faults,cs]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23120','0','','10076','Device interrupts','system.stat[faults,in]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23121','0','','10076','System calls','system.stat[faults,sy]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23122','0','','10076','Length of the swap queue','system.stat[kthr,b]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23123','0','','10076','Length of the run queue','system.stat[kthr,r]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23124','0','','10076','Active virtual pages','system.stat[memory,avm]','1m','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23125','0','','10076','Free real memory','system.stat[memory,fre]','1m','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23126','0','','10076','File page-ins per second','system.stat[page,fi]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23127','0','','10076','File page-outs per second','system.stat[page,fo]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23128','0','','10076','Pages freed (page replacement)','system.stat[page,fr]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23129','0','','10076','Pages paged in from paging space','system.stat[page,pi]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23130','0','','10076','Pages paged out to paging space','system.stat[page,po]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23131','0','','10076','Pages scanned by page-replacement algorithm','system.stat[page,sr]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23171','5','','10047','Utilization of snmp trapper data collector processes, in %','zabbix[process,snmp trapper,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23251','5','','10047','Zabbix queue','zabbix[queue]','1m','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23318','0','','10050','Host name of Zabbix agent running','agent.hostname','1h','7d','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23329','0','','10074','Network interface discovery','net.if.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Discovery of network interfaces as defined in global regular expression "Network interfaces for discovery".','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23340','5','','10048','Number of processed values per second','zabbix[wcache,values]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','1','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23341','5','','10048','Zabbix history index cache, % used','zabbix[wcache,index,pused]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','1','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23342','5','','10048','Zabbix history write cache, % used','zabbix[wcache,history,pused]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','1','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23343','5','','10048','Utilization of self-monitoring internal processes, in %','zabbix[process,self-monitoring,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','1','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23344','5','','10048','Utilization of snmp trapper data collector processes, in %','zabbix[process,snmp trapper,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','1','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23345','5','','10048','Utilization of trapper data collector processes, in %','zabbix[process,trapper,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','1','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23346','5','','10048','Utilization of unreachable poller data collector processes, in %','zabbix[process,unreachable poller,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','1','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23347','5','','10048','Utilization of configuration syncer internal processes, in %','zabbix[process,configuration syncer,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','1','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23348','5','','10048','Utilization of poller data collector processes, in %','zabbix[process,poller,avg,busy]','1m','1w','365d','0','0','localhost','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','1','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23349','5','','10048','Utilization of java poller data collector processes, in %','zabbix[process,java poller,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','1','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23350','5','','10048','Utilization of history syncer internal processes, in %','zabbix[process,history syncer,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','1','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23351','5','','10048','Utilization of heartbeat sender internal processes, in %','zabbix[process,heartbeat sender,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','1','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23352','5','','10048','Utilization of discoverer data collector processes, in %','zabbix[process,discoverer,avg,busy]','1m','1w','365d','0','0','localhost','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','1','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23353','5','','10048','Utilization of housekeeper internal processes, in %','zabbix[process,housekeeper,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','1','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23354','5','','10048','Utilization of http poller data collector processes, in %','zabbix[process,http poller,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','1','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23355','5','','10048','Utilization of ipmi poller data collector processes, in %','zabbix[process,ipmi poller,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','1','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23356','5','','10048','Utilization of icmp pinger data collector processes, in %','zabbix[process,icmp pinger,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','1','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23357','5','','10048','Zabbix configuration cache, % used','zabbix[rcache,buffer,pused]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','1','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23358','5','','10048','Zabbix queue','zabbix[queue]','1m','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','1','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23359','5','','10048','Zabbix queue over 10 minutes','zabbix[queue,10m]','10m','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','1','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23360','5','','10048','Utilization of data sender internal processes, in %','zabbix[process,data sender,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','1','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23540','0','','10075','Network interface discovery','net.if.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Discovery of network interfaces as defined in global regular expression "Network interfaces for discovery".','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23634','5','','10047','Zabbix vmware cache, % used','zabbix[vmware,buffer,pused]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23644','3','','10093','FTP service is running','net.tcp.service[ftp]','1m','1w','365d','0','3','','','','',NULL,'1','','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23645','3','','10094','HTTP service is running','net.tcp.service[http]','1m','1w','365d','0','3','','','','',NULL,'1','','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23646','3','','10095','HTTPS service is running','net.tcp.service[https]','1m','1w','365d','0','3','','','','',NULL,'1','','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23647','3','','10096','IMAP service is running','net.tcp.service[imap]','1m','1w','365d','0','3','','','','',NULL,'1','','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23648','3','','10097','LDAP service is running','net.tcp.service[ldap]','1m','1w','365d','0','3','','','','',NULL,'1','','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23649','3','','10098','NNTP service is running','net.tcp.service[nntp]','1m','1w','365d','0','3','','','','',NULL,'1','','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23650','3','','10099','NTP service is running','net.udp.service[ntp]','1m','1w','365d','0','3','','','','',NULL,'1','','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23651','3','','10100','POP service is running','net.tcp.service[pop]','1m','1w','365d','0','3','','','','',NULL,'1','','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23652','3','','10101','SMTP service is running','net.tcp.service[smtp]','1m','1w','365d','0','3','','','','',NULL,'1','','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23653','3','','10102','SSH service is running','net.tcp.service[ssh]','1m','1w','365d','0','3','','','','',NULL,'1','','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23654','3','','10103','Telnet service is running','net.tcp.service[telnet]','1m','1w','365d','0','3','','','','',NULL,'1','','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23661','5','','10047','Zabbix value cache operating mode','zabbix[vcache,cache,mode]','1m','1w','365d','0','3','','','','',NULL,'15','','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('23663','5','','10047','Utilization of task manager internal processes, in %','zabbix[process,task manager,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('25366','5','','10047','Utilization of ipmi manager internal processes, in %','zabbix[process,ipmi manager,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('25368','5','','10048','Utilization of ipmi manager internal processes, in %','zabbix[process,ipmi manager,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','1','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('25369','5','','10048','Utilization of task manager internal processes, in %','zabbix[process,task manager,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','1','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('25370','5','','10047','Utilization of alert manager internal processes, in %','zabbix[process,alert manager,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('25665','5','','10047','Utilization of preprocessing manager internal processes, in %','zabbix[process,preprocessing manager,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('25666','5','','10047','Utilization of preprocessing worker internal processes, in %','zabbix[process,preprocessing worker,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('26925','12','','10171','Power','power','1m','1w','365d','0','3','','','','',NULL,NULL,'','power','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('26926','12','','10171','Processor Vcc','processor_vcc','1m','1w','365d','0','0','','V','','',NULL,NULL,'','Processor Vcc','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('26927','12','','10171','System Fan 3','system_fan_3','1m','1w','365d','0','0','','RPM','','',NULL,NULL,'','System Fan 3','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('26928','12','','10171','BB Ambient Temp','bb_ambient_temp','1m','1w','365d','0','0','','C','','',NULL,NULL,'','BB Ambient Temp','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('26929','12','','10171','BB +5.0V','bb_5.0v','1m','1w','365d','0','0','','V','','',NULL,NULL,'','BB +5.0V','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('26930','12','','10171','BB +3.3V','bb_3.3v','1m','1w','365d','0','0','','V','','',NULL,NULL,'','BB +3.3V','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('26931','12','','10171','BB +3.3V STBY','bb_3.3v_stby','1m','1w','365d','0','0','','V','','',NULL,NULL,'','BB +3.3V STBY','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('26932','12','','10171','BB +1.8V SM','bb_1.8v_sm','1m','1w','365d','0','0','','V','','',NULL,NULL,'','BB +1.8V SM','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('26933','12','','10172','Front Panel Temp','front_panel_temp','1m','1w','365d','0','0','','C','','',NULL,NULL,'','Front Panel Temp','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('26934','12','','10172','Power','power','1m','1w','365d','0','3','','','','',NULL,NULL,'','power','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('26935','12','','10172','System Fan 2','system_fan_2','1m','1w','365d','0','0','','RPM','','',NULL,NULL,'','System Fan 2','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('26936','12','','10172','System Fan 3','system_fan_3','1m','1w','365d','0','0','','RPM','','',NULL,NULL,'','System Fan 3','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('26937','12','','10172','BB +5.0V','bb_5.0v','1m','1w','365d','0','0','','V','','',NULL,NULL,'','BB +5.0V','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('26938','12','','10172','BB +3.3V STBY','bb_3.3v_stby','1m','1w','365d','0','0','','V','','',NULL,NULL,'','BB +3.3V STBY','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('26939','12','','10172','BB +1.05V PCH','bb_1.05v_pch','1m','1w','365d','0','0','','V','','',NULL,NULL,'','BB +1.05V PCH','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('26940','12','','10172','BB +1.1V P1 Vccp','bb_1.1v_p1_vccp','1m','1w','365d','0','0','','V','','',NULL,NULL,'','BB +1.1V P1 Vccp','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('26941','12','','10172','BB +1.5V P1 DDR3','bb_1.5v_p1_ddr3','1m','1w','365d','0','0','','V','','',NULL,NULL,'','BB +1.5V P1 DDR3','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('26942','12','','10172','BB +3.3V','bb_3.3v','1m','1w','365d','0','0','','V','','',NULL,NULL,'','BB +3.3V','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('26943','12','','10172','Baseboard Temp','baseboard_temp','1m','1w','365d','0','0','','C','','',NULL,NULL,'','Baseboard Temp','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27031','20','discovery[{#SNMPVALUE},1.3.6.1.2.1.10.7.2.1.19,{#IFOPERSTATUS},1.3.6.1.2.1.2.2.1.8,{#IFALIAS},1.3.6.1.2.1.31.1.1.1.18,{#IFNAME},1.3.6.1.2.1.31.1.1.1.1,{#IFDESCR},1.3.6.1.2.1.2.2.1.2]','10183','EtherLike-MIB Discovery','net.if.duplex.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Discovering interfaces from IF-MIB and EtherLike-MIB. Interfaces with up(1) Operational Status are discovered.','0','30d','1','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27032','20','1.3.6.1.2.1.10.7.2.1.19.{#SNMPINDEX}','10183','Interface {#IFNAME}({#IFALIAS}): Duplex status','net.if.duplex[dot3StatsDuplexStatus.{#SNMPINDEX}]','1m','7d','365d','0','3','','','','',NULL,'19','','','0','','','','','2',NULL,'MIB: EtherLike-MIB
The current mode of operation of the MAC
entity.  ''unknown'' indicates that the current
duplex mode could not be determined.

Management control of the duplex mode is
accomplished through the MAU MIB.  When
an interface does not support autonegotiation,
or when autonegotiation is not enabled, the
duplex mode is controlled using
ifMauDefaultType.  When autonegotiation is
supported and enabled, duplex mode is controlled
using ifMauAutoNegAdvertisedBits.  In either
case, the currently operating duplex mode is
reflected both in this object and in ifMauType.

Note that this object provides redundant
information with ifMauType.  Normally, redundant
objects are discouraged.  However, in this
instance, it allows a management application to
determine the duplex status of an interface
without having to know every possible value of
ifMauType.  This was felt to be sufficiently
valuable to justify the redundancy.
Reference: [IEEE 802.3 Std.], 30.3.1.1.32,aDuplexStatus.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27065','3','','10186','ICMP response time','icmppingsec','1m','1w','365d','0','0','','s','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27066','3','','10186','ICMP loss','icmppingloss','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27067','3','','10186','ICMP ping','icmpping','1m','1w','365d','0','3','','','','',NULL,'1','','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27078','20','discovery[{#IFOPERSTATUS},1.3.6.1.2.1.2.2.1.8,{#IFADMINSTATUS},1.3.6.1.2.1.2.2.1.7,{#IFNAME},1.3.6.1.2.1.2.2.1.2,{#IFDESCR},1.3.6.1.2.1.2.2.1.2,{#IFTYPE},1.3.6.1.2.1.2.2.1.3]','10188','Network interfaces discovery','net.if.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Discovering interfaces from IF-MIB.','0','30d','1','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27079','20','1.3.6.1.2.1.2.2.1.13.{#SNMPINDEX}','10188','Interface {#IFDESCR}: Inbound packets discarded','net.if.in.discards[ifInDiscards.{#SNMPINDEX}]','3m','7d','365d','0','3','','','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: IF-MIB
The number of inbound packets which were chosen to be discarded
even though no errors had been detected to prevent their being deliverable to a higher-layer protocol.
One possible reason for discarding such a packet could be to free up buffer space.
Discontinuities in the value of this counter can occur at re-initialization of the management system,
and at other times as indicated by the value of ifCounterDiscontinuityTime.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27080','20','1.3.6.1.2.1.2.2.1.3.{#SNMPINDEX}','10188','Interface {#IFDESCR}: Interface type','net.if.type[ifType.{#SNMPINDEX}]','1h','7d','0d','0','3','','','','',NULL,'21','','','0','','','','','2',NULL,'MIB: IF-MIB
The type of interface.
Additional values for ifType are assigned by the Internet Assigned NumbersAuthority (IANA),
through updating the syntax of the IANAifType textual convention.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27081','20','1.3.6.1.2.1.2.2.1.5.{#SNMPINDEX}','10188','Interface {#IFDESCR}: Speed','net.if.speed[ifSpeed.{#SNMPINDEX}]','5m','7d','0d','0','3','','bps','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: IF-MIB
An estimate of the interface''s current bandwidth in bits per second.
For interfaces which do not vary in bandwidth or for those where no accurate estimation can be made,
this object should contain the nominal bandwidth.
If the bandwidth of the interface is greater than the maximum value reportable by this object then
this object should report its maximum value (4,294,967,295) and ifHighSpeed must be used to report the interace''s speed.
For a sub-layer which has no concept of bandwidth, this object should be zero.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27082','20','1.3.6.1.2.1.2.2.1.19.{#SNMPINDEX}','10188','Interface {#IFDESCR}: Outbound packets discarded','net.if.out.discards[ifOutDiscards.{#SNMPINDEX}]','3m','7d','365d','0','3','','','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: IF-MIB
The number of outbound packets which were chosen to be discarded
even though no errors had been detected to prevent their being deliverable to a higher-layer protocol.
One possible reason for discarding such a packet could be to free up buffer space.
Discontinuities in the value of this counter can occur at re-initialization of the management system,
and at other times as indicated by the value of ifCounterDiscontinuityTime.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27083','20','1.3.6.1.2.1.2.2.1.20.{#SNMPINDEX}','10188','Interface {#IFDESCR}: Outbound packets with errors','net.if.out.errors[ifOutErrors.{#SNMPINDEX}]','3m','7d','365d','0','3','','','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: IF-MIB
For packet-oriented interfaces, the number of outbound packets that contained errors preventing them from being deliverable to a higher-layer protocol.  For character-oriented or fixed-length interfaces, the number of outbound transmission units that contained errors preventing them from being deliverable to a higher-layer protocol. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ifCounterDiscontinuityTime.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27084','20','1.3.6.1.2.1.2.2.1.10.{#SNMPINDEX}','10188','Interface {#IFDESCR}: Bits received','net.if.in[ifInOctets.{#SNMPINDEX}]','3m','7d','365d','0','3','','bps','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: IF-MIB
The total number of octets received on the interface,including framing characters. Discontinuities in the value of this counter can occurat re-initialization of the management system, and atother times as indicated by the value of ifCounterDiscontinuityTime.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27085','20','1.3.6.1.2.1.2.2.1.16.{#SNMPINDEX}','10188','Interface {#IFDESCR}: Bits sent','net.if.out[ifOutOctets.{#SNMPINDEX}]','3m','7d','365d','0','3','','bps','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: IF-MIB
The total number of octets transmitted out of the interface, including framing characters. Discontinuities in the value of this counter can occurat re-initialization of the management system, and at other times as indicated by the value of ifCounterDiscontinuityTime.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27086','20','1.3.6.1.2.1.2.2.1.14.{#SNMPINDEX}','10188','Interface {#IFDESCR}: Inbound packets with errors','net.if.in.errors[ifInErrors.{#SNMPINDEX}]','3m','7d','365d','0','3','','','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: IF-MIB
For packet-oriented interfaces, the number of inbound packets that contained errors preventing them from being deliverable to a higher-layer protocol.  For character-oriented or fixed-length interfaces, the number of inbound transmission units that contained errors preventing them from being deliverable to a higher-layer protocol. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ifCounterDiscontinuityTime.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27087','20','1.3.6.1.2.1.2.2.1.8.{#SNMPINDEX}','10188','Interface {#IFDESCR}: Operational status','net.if.status[ifOperStatus.{#SNMPINDEX}]','1m','7d','0','0','3','','','','',NULL,'20','','','0','','','','','2',NULL,'MIB: IF-MIB
The current operational state of the interface.
- The testing(3) state indicates that no operational packet scan be passed
- If ifAdminStatus is down(2) then ifOperStatus should be down(2)
- If ifAdminStatus is changed to up(1) then ifOperStatus should change to up(1) if the interface is ready to transmit and receive network traffic
- It should change todormant(5) if the interface is waiting for external actions (such as a serial line waiting for an incoming connection)
- It should remain in the down(2) state if and only if there is a fault that prevents it from going to the up(1) state
- It should remain in the notPresent(6) state if the interface has missing(typically, hardware) components.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27098','20','discovery[{#IFOPERSTATUS},1.3.6.1.2.1.2.2.1.8,{#IFADMINSTATUS},1.3.6.1.2.1.2.2.1.7,{#IFALIAS},1.3.6.1.2.1.31.1.1.1.18,{#IFNAME},1.3.6.1.2.1.31.1.1.1.1,{#IFDESCR},1.3.6.1.2.1.2.2.1.2,{#IFTYPE},1.3.6.1.2.1.2.2.1.3]','10190','Network interfaces discovery','net.if.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Discovering interfaces from IF-MIB.','0','30d','1','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27099','20','1.3.6.1.2.1.2.2.1.13.{#SNMPINDEX}','10190','Interface {#IFNAME}({#IFALIAS}): Inbound packets discarded','net.if.in.discards[ifInDiscards.{#SNMPINDEX}]','3m','7d','365d','0','3','','','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: IF-MIB
The number of inbound packets which were chosen to be discarded
even though no errors had been detected to prevent their being deliverable to a higher-layer protocol.
One possible reason for discarding such a packet could be to free up buffer space.
Discontinuities in the value of this counter can occur at re-initialization of the management system,
and at other times as indicated by the value of ifCounterDiscontinuityTime.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27100','20','1.3.6.1.2.1.2.2.1.3.{#SNMPINDEX}','10190','Interface {#IFNAME}({#IFALIAS}): Interface type','net.if.type[ifType.{#SNMPINDEX}]','1h','7d','0d','0','3','','','','',NULL,'21','','','0','','','','','2',NULL,'MIB: IF-MIB
The type of interface.
Additional values for ifType are assigned by the Internet Assigned NumbersAuthority (IANA),
through updating the syntax of the IANAifType textual convention.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27101','20','1.3.6.1.2.1.31.1.1.1.15.{#SNMPINDEX}','10190','Interface {#IFNAME}({#IFALIAS}): Speed','net.if.speed[ifHighSpeed.{#SNMPINDEX}]','5m','7d','0d','0','3','','bps','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: IF-MIB
An estimate of the interface''s current bandwidth in units of 1,000,000 bits per second. If this object reports a value of `n'' then the speed of the interface is somewhere in the range of `n-500,000'' to`n+499,999''.  For interfaces which do not vary in bandwidth or for those where no accurate estimation can be made, this object should contain the nominal bandwidth. For a sub-layer which has no concept of bandwidth, this object should be zero.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27102','20','1.3.6.1.2.1.2.2.1.19.{#SNMPINDEX}','10190','Interface {#IFNAME}({#IFALIAS}): Outbound packets discarded','net.if.out.discards[ifOutDiscards.{#SNMPINDEX}]','3m','7d','365d','0','3','','','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: IF-MIB
The number of outbound packets which were chosen to be discarded
even though no errors had been detected to prevent their being deliverable to a higher-layer protocol.
One possible reason for discarding such a packet could be to free up buffer space.
Discontinuities in the value of this counter can occur at re-initialization of the management system,
and at other times as indicated by the value of ifCounterDiscontinuityTime.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27103','20','1.3.6.1.2.1.2.2.1.20.{#SNMPINDEX}','10190','Interface {#IFNAME}({#IFALIAS}): Outbound packets with errors','net.if.out.errors[ifOutErrors.{#SNMPINDEX}]','3m','7d','365d','0','3','','','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: IF-MIB
For packet-oriented interfaces, the number of outbound packets that contained errors preventing them from being deliverable to a higher-layer protocol.  For character-oriented or fixed-length interfaces, the number of outbound transmission units that contained errors preventing them from being deliverable to a higher-layer protocol. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ifCounterDiscontinuityTime.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27104','20','1.3.6.1.2.1.31.1.1.1.6.{#SNMPINDEX}','10190','Interface {#IFNAME}({#IFALIAS}): Bits received','net.if.in[ifHCInOctets.{#SNMPINDEX}]','3m','7d','365d','0','3','','bps','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: IF-MIB
The total number of octets received on the interface, including framing characters. This object is a 64-bit version of ifInOctets. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ifCounterDiscontinuityTime.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27105','20','1.3.6.1.2.1.31.1.1.1.10.{#SNMPINDEX}','10190','Interface {#IFNAME}({#IFALIAS}): Bits sent','net.if.out[ifHCOutOctets.{#SNMPINDEX}]','3m','7d','365d','0','3','','bps','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: IF-MIB
The total number of octets transmitted out of the interface, including framing characters. This object is a 64-bit version of ifOutOctets.Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ifCounterDiscontinuityTime.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27106','20','1.3.6.1.2.1.2.2.1.14.{#SNMPINDEX}','10190','Interface {#IFNAME}({#IFALIAS}): Inbound packets with errors','net.if.in.errors[ifInErrors.{#SNMPINDEX}]','3m','7d','365d','0','3','','','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: IF-MIB
For packet-oriented interfaces, the number of inbound packets that contained errors preventing them from being deliverable to a higher-layer protocol.  For character-oriented or fixed-length interfaces, the number of inbound transmission units that contained errors preventing them from being deliverable to a higher-layer protocol. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ifCounterDiscontinuityTime.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27107','20','1.3.6.1.2.1.2.2.1.8.{#SNMPINDEX}','10190','Interface {#IFNAME}({#IFALIAS}): Operational status','net.if.status[ifOperStatus.{#SNMPINDEX}]','1m','7d','0','0','3','','','','',NULL,'20','','','0','','','','','2',NULL,'MIB: IF-MIB
The current operational state of the interface.
- The testing(3) state indicates that no operational packet scan be passed
- If ifAdminStatus is down(2) then ifOperStatus should be down(2)
- If ifAdminStatus is changed to up(1) then ifOperStatus should change to up(1) if the interface is ready to transmit and receive network traffic
- It should change todormant(5) if the interface is waiting for external actions (such as a serial line waiting for an incoming connection)
- It should remain in the down(2) state if and only if there is a fault that prevents it from going to the up(1) state
- It should remain in the notPresent(6) state if the interface has missing(typically, hardware) components.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27118','20','discovery[{#IFOPERSTATUS},1.3.6.1.2.1.2.2.1.8,{#IFADMINSTATUS},1.3.6.1.2.1.2.2.1.7,{#IFALIAS},1.3.6.1.2.1.31.1.1.1.18,{#IFNAME},1.3.6.1.2.1.31.1.1.1.1,{#IFDESCR},1.3.6.1.2.1.2.2.1.2,{#IFTYPE},1.3.6.1.2.1.2.2.1.3]','10192','Network interfaces discovery','net.if.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Discovering interfaces from IF-MIB.','0','30d','1','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27119','20','1.3.6.1.2.1.2.2.1.13.{#SNMPINDEX}','10192','Interface {#IFNAME}({#IFALIAS}): Inbound packets discarded','net.if.in.discards[ifInDiscards.{#SNMPINDEX}]','3m','7d','365d','0','3','','','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: IF-MIB
The number of inbound packets which were chosen to be discarded
even though no errors had been detected to prevent their being deliverable to a higher-layer protocol.
One possible reason for discarding such a packet could be to free up buffer space.
Discontinuities in the value of this counter can occur at re-initialization of the management system,
and at other times as indicated by the value of ifCounterDiscontinuityTime.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27120','20','1.3.6.1.2.1.2.2.1.3.{#SNMPINDEX}','10192','Interface {#IFNAME}({#IFALIAS}): Interface type','net.if.type[ifType.{#SNMPINDEX}]','1h','7d','0d','0','3','','','','',NULL,'21','','','0','','','','','2',NULL,'MIB: IF-MIB
The type of interface.
Additional values for ifType are assigned by the Internet Assigned NumbersAuthority (IANA),
through updating the syntax of the IANAifType textual convention.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27121','20','1.3.6.1.2.1.31.1.1.1.15.{#SNMPINDEX}','10192','Interface {#IFNAME}({#IFALIAS}): Speed','net.if.speed[ifHighSpeed.{#SNMPINDEX}]','5m','7d','0d','0','3','','bps','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: IF-MIB
An estimate of the interface''s current bandwidth in units of 1,000,000 bits per second. If this object reports a value of `n'' then the speed of the interface is somewhere in the range of `n-500,000'' to`n+499,999''.  For interfaces which do not vary in bandwidth or for those where no accurate estimation can be made, this object should contain the nominal bandwidth. For a sub-layer which has no concept of bandwidth, this object should be zero.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27122','20','1.3.6.1.2.1.2.2.1.19.{#SNMPINDEX}','10192','Interface {#IFNAME}({#IFALIAS}): Outbound packets discarded','net.if.out.discards[ifOutDiscards.{#SNMPINDEX}]','3m','7d','365d','0','3','','','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: IF-MIB
The number of outbound packets which were chosen to be discarded
even though no errors had been detected to prevent their being deliverable to a higher-layer protocol.
One possible reason for discarding such a packet could be to free up buffer space.
Discontinuities in the value of this counter can occur at re-initialization of the management system,
and at other times as indicated by the value of ifCounterDiscontinuityTime.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27123','20','1.3.6.1.2.1.2.2.1.20.{#SNMPINDEX}','10192','Interface {#IFNAME}({#IFALIAS}): Outbound packets with errors','net.if.out.errors[ifOutErrors.{#SNMPINDEX}]','3m','7d','365d','0','3','','','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: IF-MIB
For packet-oriented interfaces, the number of outbound packets that contained errors preventing them from being deliverable to a higher-layer protocol.  For character-oriented or fixed-length interfaces, the number of outbound transmission units that contained errors preventing them from being deliverable to a higher-layer protocol. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ifCounterDiscontinuityTime.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27124','20','1.3.6.1.2.1.2.2.1.10.{#SNMPINDEX}','10192','Interface {#IFNAME}({#IFALIAS}): Bits received','net.if.in[ifInOctets.{#SNMPINDEX}]','3m','7d','365d','0','3','','bps','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: IF-MIB
The total number of octets received on the interface,including framing characters. Discontinuities in the value of this counter can occur at re-initialization of the management system, and atother times as indicated by the value of ifCounterDiscontinuityTime.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27125','20','1.3.6.1.2.1.2.2.1.16.{#SNMPINDEX}','10192','Interface {#IFNAME}({#IFALIAS}): Bits sent','net.if.out[ifOutOctets.{#SNMPINDEX}]','3m','7d','365d','0','3','','bps','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: IF-MIB
The total number of octets transmitted out of the interface, including framing characters. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ifCounterDiscontinuityTime.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27126','20','1.3.6.1.2.1.2.2.1.14.{#SNMPINDEX}','10192','Interface {#IFNAME}({#IFALIAS}): Inbound packets with errors','net.if.in.errors[ifInErrors.{#SNMPINDEX}]','3m','7d','365d','0','3','','','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: IF-MIB
For packet-oriented interfaces, the number of inbound packets that contained errors preventing them from being deliverable to a higher-layer protocol.  For character-oriented or fixed-length interfaces, the number of inbound transmission units that contained errors preventing them from being deliverable to a higher-layer protocol. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ifCounterDiscontinuityTime.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27127','20','1.3.6.1.2.1.2.2.1.8.{#SNMPINDEX}','10192','Interface {#IFNAME}({#IFALIAS}): Operational status','net.if.status[ifOperStatus.{#SNMPINDEX}]','1m','7d','0','0','3','','','','',NULL,'20','','','0','','','','','2',NULL,'MIB: IF-MIB
The current operational state of the interface.
- The testing(3) state indicates that no operational packet scan be passed
- If ifAdminStatus is down(2) then ifOperStatus should be down(2)
- If ifAdminStatus is changed to up(1) then ifOperStatus should change to up(1) if the interface is ready to transmit and receive network traffic
- It should change todormant(5) if the interface is waiting for external actions (such as a serial line waiting for an incoming connection)
- It should remain in the down(2) state if and only if there is a fault that prevents it from going to the up(1) state
- It should remain in the notPresent(6) state if the interface has missing(typically, hardware) components.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27152','20','1.3.6.1.2.1.1.5.0','10204','System name','system.name','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: SNMPv2-MIB
An administratively-assigned name for this managed node.By convention, this is the node''s fully-qualified domain name.  If the name is unknown, the value is the zero-length string.','3','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27154','5','','10204','SNMP agent availability','zabbix[host,snmp,available]','1m','7d','365d','0','3','','','','',NULL,'22','','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27157','17','','10204','SNMP traps (fallback)','snmptrap.fallback','1m','2w','0','0','2','','','','hh:mm:sszyyyy/MM/dd',NULL,NULL,'','','0','','','','','0',NULL,'Item is used to collect all SNMP traps unmatched by other snmptrap items','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27203','20','1.3.6.1.2.1.1.1.0','10207','Hardware model name','system.hw.model','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: SNMPv2-MIB','29','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27207','20','1.3.6.1.4.1.6527.3.1.2.1.1.9.0','10207','Used memory','vm.memory.used[sgiKbMemoryUsed.0]','1m','7d','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: TIMETRA-SYSTEM-MIB
The value of sgiKbMemoryUsed indicates the total pre-allocated pool memory, in kilobytes, currently in use on the system.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27208','20','1.3.6.1.4.1.6527.3.1.2.1.1.1.0','10207','CPU utilization','system.cpu.util[sgiCpuUsage.0]','1m','7d','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: TIMETRA-SYSTEM-MIB
The value of sgiCpuUsage indicates the current CPU utilization for the system.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27209','20','discovery[{#SNMPVALUE},1.3.6.1.4.1.6527.3.1.2.2.1.8.1.8,{#TEMP_SENSOR},1.3.6.1.4.1.6527.3.1.2.2.1.8.1.17]','10207','Temperature Discovery','temperature.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27210','20','discovery[{#SNMPVALUE},1.3.6.1.4.1.6527.3.1.2.2.1.4.1.2]','10207','FAN Discovery','fan.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27211','20','discovery[{#ENT_NAME},1.3.6.1.4.1.6527.3.1.2.2.1.8.1.8,{#ENT_CLASS},1.3.6.1.4.1.6527.3.1.2.2.1.8.1.7,{#ENT_SN},1.3.6.1.4.1.6527.3.1.2.2.1.8.1.5]','10207','Entity Serial Numbers Discovery','entity_sn.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'','0','30d','1','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27212','20','1.3.6.1.4.1.6527.3.1.2.2.1.8.1.18.{#SNMPINDEX}','10207','{#SNMPVALUE}: Temperature','sensor.temp.value[tmnxHwTemperature.{#SNMPINDEX}]','3m','90d','365d','0','0','','°C','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: TIMETRA-SYSTEM-MIB
The current temperature reading in degrees celsius from this hardware component''s temperature sensor.  If this component does not contain a temperature sensor, then the value -1 is returned.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27213','20','1.3.6.1.4.1.6527.3.1.2.2.1.4.1.2.{#SNMPINDEX}','10207','#{#SNMPINDEX}: Fan status','sensor.fan.status[tmnxChassisFanOperStatus.{#SNMPINDEX}]','3m','2w','0d','0','3','','','','',NULL,'23','','','0','','','','','2',NULL,'MIB: TIMETRA-SYSTEM-MIB
Current status of the Fan tray.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27214','20','1.3.6.1.4.1.6527.3.1.2.2.1.8.1.5.{#SNMPINDEX}','10207','{#ENT_NAME}: Hardware serial number','system.hw.serialnumber[tmnxHwSerialNumber.{#SNMPINDEX}]','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: TIMETRA-CHASSIS-MIB','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27236','20','1.3.6.1.4.1.1588.2.1.1.1.1.6.0','10208','Firmware version','system.hw.firmware','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: SW-MIB','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27237','20','1.3.6.1.4.1.1588.2.1.1.1.1.10.0','10208','Hardware serial number','system.hw.serialnumber','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: SW-MIB','8','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27238','20','1.3.6.1.4.1.1588.2.1.1.1.1.7.0','10208','Overall system health status','system.status[swOperStatus.0]','30s','2w','0d','0','3','','','','',NULL,'25','','','0','','','','','0',NULL,'MIB: SW-MIB
The current operational status of the switch.The states are as follow:
online(1) means the switch is accessible by an external Fibre Channel port
offline(2) means the switch is not accessible
testing(3) means the switch is in a built-in test mode and is not accessible by an external Fibre Channel port
faulty(4) means the switch is not operational.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27240','20','1.3.6.1.4.1.1588.2.1.1.1.26.1.0','10208','CPU utilization','system.cpu.util[swCpuUsage.0]','1m','7d','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: SW-MIB
System''s CPU usage.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27242','20','discovery[{#SNMPVALUE},1.3.6.1.4.1.1588.2.1.1.1.1.22.1.1,{#SENSOR_TYPE},1.3.6.1.4.1.1588.2.1.1.1.1.22.1.2,{#SENSOR_INFO},1.3.6.1.4.1.1588.2.1.1.1.1.22.1.5]','10208','Temperature Discovery','temperature.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27243','20','discovery[{#SNMPVALUE},1.3.6.1.4.1.1588.2.1.1.1.1.22.1.1,{#SENSOR_TYPE},1.3.6.1.4.1.1588.2.1.1.1.1.22.1.2,{#SENSOR_INFO},1.3.6.1.4.1.1588.2.1.1.1.1.22.1.5]','10208','PSU Discovery','psu.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27244','20','discovery[{#SNMPVALUE},1.3.6.1.4.1.1588.2.1.1.1.1.22.1.1,{#SENSOR_TYPE},1.3.6.1.4.1.1588.2.1.1.1.1.22.1.2,{#SENSOR_INFO},1.3.6.1.4.1.1588.2.1.1.1.1.22.1.5]','10208','FAN Discovery','fan.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27246','20','1.3.6.1.4.1.1588.2.1.1.1.1.22.1.3.{#SNMPINDEX}','10208','{#SENSOR_INFO}: Temperature status','sensor.temp.status[swSensorStatus.{#SNMPINDEX}]','3m','2w','0d','0','3','','','','',NULL,'24','','','0','','','','','2',NULL,'MIB: SW-MIB
Temperature status of testpoint: {#SENSOR_INFO}','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27247','20','1.3.6.1.4.1.1588.2.1.1.1.1.22.1.4.{#SNMPINDEX}','10208','{#SENSOR_INFO}: Temperature','sensor.temp.value[swSensorValue.{#SNMPINDEX}]','3m','90d','365d','0','0','','°C','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: SW-MIB
Temperature readings of testpoint: {#SENSOR_INFO}','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27248','20','1.3.6.1.4.1.1588.2.1.1.1.1.22.1.3.{#SNMPINDEX}','10208','{#SENSOR_INFO}: Power supply status','sensor.psu.status[swSensorStatus.{#SNMPINDEX}]','3m','2w','0d','0','3','','','','',NULL,'24','','','0','','','','','2',NULL,'MIB: SW-MIB','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27249','20','1.3.6.1.4.1.1588.2.1.1.1.1.22.1.4.{#SNMPINDEX}','10208','{#SENSOR_INFO}: Fan speed','sensor.fan.speed[swSensorValue.{#SNMPINDEX}]','1m','90d','365d','0','3','','rpm','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: SW-MIB
The current value (reading) of the sensor.
The value, -2147483648, represents an unknown quantity.
The fan value will be in RPM(revolution per minute)','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27250','20','1.3.6.1.4.1.1588.2.1.1.1.1.22.1.3.{#SNMPINDEX}','10208','{#SENSOR_INFO}: Fan status','sensor.fan.status[swSensorStatus.{#SNMPINDEX}]','3m','2w','0d','0','3','','','','',NULL,'24','','','0','','','','','2',NULL,'MIB: SW-MIB','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27294','20','1.3.6.1.4.1.1991.1.1.2.1.52.0','10209','CPU utilization','system.cpu.util[snAgGblCpuUtil1MinAvg.0]','1m','7d','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: FOUNDRY-SN-AGENT-MIB
The statistics collection of 1 minute CPU utilization.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27295','20','1.3.6.1.4.1.1991.1.1.2.1.11.0','10210','Firmware version','system.hw.firmware','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: FOUNDRY-SN-AGENT-MIB
The version of the running software in the form''major.minor.maintenance[letters]''','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27296','20','1.3.6.1.4.1.1991.1.1.1.1.2.0','10210','Hardware serial number','system.hw.serialnumber','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: FOUNDRY-SN-AGENT-MIB','8','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27297','20','1.3.6.1.4.1.1991.1.1.2.1.11.0','10211','Firmware version','system.hw.firmware','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: FOUNDRY-SN-AGENT-MIB
The version of the running software in the form ''major.minor.maintenance[letters]''','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27302','20','discovery[{#PSU_INDEX},1.3.6.1.4.1.1991.1.1.1.2.1.1.1]','10210','PSU Discovery','psu.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'snChasPwrSupplyTable: A table of each power supply information. Only installed power supply appears in a table row.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27303','20','discovery[{#FAN_INDEX},1.3.6.1.4.1.1991.1.1.1.3.1.1.1]','10210','FAN Discovery','fan.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'snChasFanTable: A table of each fan information. Only installed fan appears in a table row.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27304','20','discovery[{#SENSOR_DESCR},1.3.6.1.4.1.1991.1.1.2.13.1.1.3]','10210','Temperature Discovery','temp.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'snAgentTempTable:Table to list temperatures of the modules in the device. This table is applicable to only those modules with temperature sensors.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27306','20','discovery[{#SNMPVALUE},1.3.6.1.4.1.1991.1.1.1.1.18]','10210','Temperature Discovery Chassis','temp.chassis.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Since temperature of the chassis is not available on all Brocade/Foundry hardware, this LLD is here to avoid unsupported items.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27307','20','discovery[{#PSU_UNIT},1.3.6.1.4.1.1991.1.1.1.2.2.1.1,{#PSU_INDEX},1.3.6.1.4.1.1991.1.1.1.2.2.1.2]','10211','PSU Discovery','psu.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'snChasPwrSupply2Table: A table of each power supply information for each unit. Only installed power supply appears in a table row.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27308','20','discovery[{#FAN_UNIT},1.3.6.1.4.1.1991.1.1.1.3.2.1.1,{#FAN_INDEX},1.3.6.1.4.1.1991.1.1.1.3.2.1.2]','10211','FAN Discovery','fan.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'snChasFan2Table: A table of each fan information for each unit. Only installed fan appears in a table row.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27309','20','discovery[{#SENSOR_DESCR},1.3.6.1.4.1.1991.1.1.2.13.3.1.4]','10211','Temperature Discovery','temp.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'snAgentTemp2Table:Table to list temperatures of the modules in the device for each unit. This table is applicable to only those modules with temperature sensors.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27310','20','discovery[{#SNMPVALUE},1.3.6.1.4.1.1991.1.1.3.31.2.1.1.5]','10211','Stack Discovery','stack.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Discovering snStackingConfigUnitTable for Model names','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27311','20','discovery[{#SNMPVALUE},1.3.6.1.4.1.1991.1.1.1.4.1.1.1]','10211','Chassis Discovery','chassis.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'snChasUnitIndex: The index to chassis table.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27312','20','1.3.6.1.4.1.1991.1.1.1.2.1.1.3.{#SNMPINDEX}','10210','PSU {#PSU_INDEX}: Power supply status','sensor.psu.status[snChasPwrSupplyOperStatus.{#SNMPINDEX}]','3m','2w','0d','0','3','','','','',NULL,'26','','','0','','','','','2',NULL,'MIB: FOUNDRY-SN-AGENT-MIB','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27313','20','1.3.6.1.4.1.1991.1.1.1.3.1.1.3.{#SNMPINDEX}','10210','Fan {#FAN_INDEX}: Fan status','sensor.fan.status[snChasFanOperStatus.{#SNMPINDEX}]','3m','2w','0d','0','3','','','','',NULL,'27','','','0','','','','','2',NULL,'MIB: FOUNDRY-SN-AGENT-MIB','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27314','20','1.3.6.1.4.1.1991.1.1.2.13.1.1.4.{#SNMPINDEX}','10210','{#SENSOR_DESCR}: Temperature','sensor.temp.value[snAgentTempValue.{#SNMPINDEX}]','3m','90d','365d','0','0','','°C','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: FOUNDRY-SN-AGENT-MIB
Temperature of the sensor represented by this row. Each unit is 0.5 degrees Celsius.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27315','20','1.3.6.1.4.1.1991.1.1.1.1.18.{#SNMPINDEX}','10210','Chassis #{#SNMPINDEX}: Temperature','sensor.temp.value[snChasActualTemperature.{#SNMPINDEX}]','3m','90d','365d','0','0','','°C','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: FOUNDRY-SN-AGENT-MIB
Temperature of the chassis. Each unit is 0.5 degrees Celcius.
Only management module built with temperature sensor hardware is applicable.
For those non-applicable management module, it returns no-such-name.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27316','20','1.3.6.1.4.1.1991.1.1.1.2.2.1.4.{#SNMPINDEX}','10211','Unit {#PSU_UNIT} PSU {#PSU_INDEX}: Power supply status','sensor.psu.status[snChasPwrSupply2OperStatus.{#SNMPINDEX}]','3m','2w','0d','0','3','','','','',NULL,'26','','','0','','','','','2',NULL,'MIB: FOUNDRY-SN-AGENT-MIB','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27317','20','1.3.6.1.4.1.1991.1.1.1.3.2.1.4.{#SNMPINDEX}','10211','Unit {#FAN_UNIT} Fan {#FAN_INDEX}: Fan status','sensor.fan.status[snChasFan2OperStatus.{#SNMPINDEX}]','3m','2w','0d','0','3','','','','',NULL,'27','','','0','','','','','2',NULL,'MIB: FOUNDRY-SN-AGENT-MIB','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27318','20','1.3.6.1.4.1.1991.1.1.2.13.3.1.5.{#SNMPINDEX}','10211','{#SENSOR_DESCR}: Temperature','sensor.temp.value[snAgentTemp2Value.{#SNMPINDEX}]','3m','90d','365d','0','0','','°C','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: FOUNDRY-SN-AGENT-MIB
Temperature of the sensor represented by this row. Each unit is 0.5 degrees Celsius.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27319','20','1.3.6.1.4.1.1991.1.1.3.31.2.1.1.5.{#SNMPINDEX}','10211','Unit {#SNMPINDEX}: Hardware model name','system.hw.model[snStackingConfigUnitType.{#SNMPINDEX}]','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: FOUNDRY-SN-STACKING-MIB
A description of the configured/active system type for each unit.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27320','20','1.3.6.1.4.1.1991.1.1.1.4.1.1.2.{#SNMPINDEX}','10211','Unit {#SNMPVALUE}: Hardware serial number','system.hw.serialnumber[snChasUnitSerNum.{#SNMPINDEX}]','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: FOUNDRY-SN-AGENT-MIB
The serial number of the chassis for each unit. If the serial number is unknown or unavailable then the value should be a zero length string.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27376','20','1.3.6.1.4.1.9.2.1.58','10215','CPU utilization','system.cpu.util[avgBusy5]','5m','7d','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: OLD-CISCO-CPU-MIB
5 minute exponentially-decayed moving average of the CPU busy percentage.
Reference: http://www.cisco.com/c/en/us/support/docs/ip/simple-network-management-protocol-snmp/15215-collect-cpu-util-snmp.html','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27378','20','1.3.6.1.2.1.47.1.1.1.1.11.1','10216','Hardware serial number','system.hw.serialnumber','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: ENTITY-MIB','8','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27379','20','1.3.6.1.2.1.47.1.1.1.1.13.1','10216','Hardware model name','system.hw.model','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: ENTITY-MIB','29','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27390','20','discovery[{#SNMPVALUE},1.3.6.1.4.1.9.9.48.1.1.1.2]','10212','Memory Discovery','memory.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Discovery of ciscoMemoryPoolTable, a table of memory pool monitoring entries.
http://www.cisco.com/c/en/us/support/docs/ip/simple-network-management-protocol-snmp/15216-contiguous-memory.html','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27391','20','discovery[{#SNMPVALUE},1.3.6.1.4.1.9.9.109.1.1.1.1.5]','10213','CPU Discovery','cpu.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'If your IOS device has several CPUs, you must use CISCO-PROCESS-MIB and its object cpmCPUTotal5minRev from the table called cpmCPUTotalTable ,
indexed with cpmCPUTotalIndex .
This table allows CISCO-PROCESS-MIB to keep CPU statistics for different physical entities in the router,
like different CPU chips, group of CPUs, or CPUs in different modules/cards.
In case of a single CPU, cpmCPUTotalTable has only one entry.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27393','20','discovery[{#ENT_CLASS},1.3.6.1.2.1.47.1.1.1.1.5,{#ENT_NAME},1.3.6.1.2.1.47.1.1.1.1.7,{#ENT_SN},1.3.6.1.2.1.47.1.1.1.1.11]','10216','Entity Serial Numbers Discovery','entity_sn.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'','0','30d','1','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27394','20','discovery[{#SNMPVALUE},1.3.6.1.4.1.9.9.13.1.3.1.2]','10217','Temperature Discovery','temperature.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Discovery of ciscoEnvMonTemperatureTable (ciscoEnvMonTemperatureDescr), a table of ambient temperature status
maintained by the environmental monitor.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27395','20','discovery[{#SENSOR_INFO},1.3.6.1.4.1.9.9.13.1.5.1.2]','10217','PSU Discovery','psu.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'The table of power supply status maintained by the environmental monitor card.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27396','20','discovery[{#SENSOR_INFO},1.3.6.1.4.1.9.9.13.1.4.1.2]','10217','FAN Discovery','fan.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'The table of fan status maintained by the environmental monitor.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27415','20','1.3.6.1.4.1.9.9.48.1.1.1.6.{#SNMPINDEX}','10212','{#SNMPVALUE}: Free memory','vm.memory.free[ciscoMemoryPoolFree.{#SNMPINDEX}]','1m','7d','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: CISCO-MEMORY-POOL-MIB
Indicates the number of bytes from the memory pool that are currently unused on the managed device. Note that the sum of ciscoMemoryPoolUsed and ciscoMemoryPoolFree is the total amount of memory in the pool
Reference: http://www.cisco.com/c/en/us/support/docs/ip/simple-network-management-protocol-snmp/15216-contiguous-memory.html','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27416','20','1.3.6.1.4.1.9.9.48.1.1.1.5.{#SNMPINDEX}','10212','{#SNMPVALUE}: Used memory','vm.memory.used[ciscoMemoryPoolUsed.{#SNMPINDEX}]','1m','7d','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: CISCO-MEMORY-POOL-MIB
Indicates the number of bytes from the memory pool that are currently in use by applications on the managed device.
Reference: http://www.cisco.com/c/en/us/support/docs/ip/simple-network-management-protocol-snmp/15216-contiguous-memory.html','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27417','20','1.3.6.1.4.1.9.9.109.1.1.1.1.8.{#SNMPINDEX}','10213','#{#SNMPINDEX}: CPU utilization','system.cpu.util[cpmCPUTotal5minRev.{#SNMPINDEX}]','5m','7d','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: CISCO-PROCESS-MIB
The cpmCPUTotal5minRev MIB object provides a more accurate view of the performance of the router over time than the MIB objects cpmCPUTotal1minRev and cpmCPUTotal5secRev . These MIB objects are not accurate because they look at CPU at one minute and five second intervals, respectively. These MIBs enable you to monitor the trends and plan the capacity of your network. The recommended baseline rising threshold for cpmCPUTotal5minRev is 90 percent. Depending on the platform, some routers that run at 90 percent, for example, 2500s, can exhibit performance degradation versus a high-end router, for example, the 7500 series, which can operate fine.
Reference: http://www.cisco.com/c/en/us/support/docs/ip/simple-network-management-protocol-snmp/15215-collect-cpu-util-snmp.html','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27419','20','1.3.6.1.2.1.47.1.1.1.1.11.{#SNMPINDEX}','10216','{#ENT_NAME}: Hardware serial number','system.hw.serialnumber[entPhysicalSerialNum.{#SNMPINDEX}]','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: ENTITY-MIB','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27420','20','1.3.6.1.4.1.9.9.13.1.3.1.6.{#SNMPINDEX}','10217','{#SNMPVALUE}: Temperature status','sensor.temp.status[ciscoEnvMonTemperatureState.{#SNMPINDEX}]','3m','2w','0d','0','3','','','','',NULL,'28','','','0','','','','','2',NULL,'MIB: CISCO-ENVMON-MIB
The current state of the test point being instrumented.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27421','20','1.3.6.1.4.1.9.9.13.1.3.1.3.{#SNMPINDEX}','10217','{#SNMPVALUE}: Temperature','sensor.temp.value[ciscoEnvMonTemperatureValue.{#SNMPINDEX}]','3m','90d','365d','0','0','','°C','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: CISCO-ENVMON-MIB
The current measurement of the test point being instrumented.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27422','20','1.3.6.1.4.1.9.9.13.1.5.1.3.{#SNMPINDEX}','10217','{#SENSOR_INFO}: Power supply status','sensor.psu.status[ciscoEnvMonSupplyState.{#SNMPINDEX}]','3m','2w','0d','0','3','','','','',NULL,'28','','','0','','','','','2',NULL,'MIB: CISCO-ENVMON-MIB','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27423','20','1.3.6.1.4.1.9.9.13.1.4.1.3.{#SNMPINDEX}','10217','{#SENSOR_INFO}: Fan status','sensor.fan.status[ciscoEnvMonFanState.{#SNMPINDEX}]','3m','2w','0d','0','3','','','','',NULL,'28','','','0','','','','','2',NULL,'MIB: CISCO-ENVMON-MIB','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27473','20','discovery[{#SNMPVALUE},1.3.6.1.4.1.6027.3.10.1.2.9.1.1]','10221','CPU and Memory and Flash Discovery','module.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27474','20','discovery[{#SNMPVALUE},1.3.6.1.4.1.6027.3.10.1.2.3.1.1]','10221','PSU Discovery','psu.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'A list of power supply residents in the S-series chassis.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27475','20','discovery[{#SNMPVALUE},1.3.6.1.4.1.6027.3.10.1.2.4.1.1]','10221','FAN Discovery','fan.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27476','20','discovery[{#SNMPVALUE},1.3.6.1.4.1.6027.3.10.1.2.2.1.2]','10221','Stack Unit Discovery','stack.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27478','20','1.3.6.1.4.1.6027.3.10.1.2.9.1.3.{#SNMPINDEX}','10221','#{#SNMPINDEX}: CPU utilization','system.cpu.util[chStackUnitCpuUtil1Min.{#SNMPINDEX}]','1m','7d','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: F10-S-SERIES-CHASSIS-MIB
CPU utilization in percentage for last 1 minute.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27479','20','1.3.6.1.4.1.6027.3.10.1.2.3.1.2.{#SNMPINDEX}','10221','PSU {#SNMPVALUE}: Power supply status','sensor.psu.status[chSysPowerSupplyOperStatus.{#SNMPINDEX}]','3m','2w','0d','0','3','','','','',NULL,'31','','','0','','','','','2',NULL,'MIB: F10-S-SERIES-CHASSIS-MIB
The status of the power supply {#SNMPVALUE}','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27480','20','1.3.6.1.4.1.6027.3.10.1.2.4.1.2.{#SNMPINDEX}','10221','Fan {#SNMPVALUE}: Fan status','sensor.fan.status[chSysFanTrayOperStatus.{#SNMPINDEX}]','3m','2w','0d','0','3','','','','',NULL,'30','','','0','','','','','2',NULL,'MIB: F10-S-SERIES-CHASSIS-MIB
The status of the fan tray {#SNMPVALUE}.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27481','20','1.3.6.1.4.1.6027.3.10.1.2.2.1.10.{#SNMPINDEX}','10221','#{#SNMPVALUE}: Operating system','system.sw.os[chStackUnitCodeVersion.{#SNMPINDEX}]','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: F10-S-SERIES-CHASSIS-MIB
Current code version of this unit.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27482','20','1.3.6.1.4.1.6027.3.10.1.2.2.1.21.{#SNMPINDEX}','10221','#{#SNMPVALUE}: Hardware version(revision)','system.hw.version[chStackUnitProductRev.{#SNMPINDEX}]','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: F10-S-SERIES-CHASSIS-MIB
The unit manufacturer''s product revision','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27483','20','1.3.6.1.4.1.6027.3.10.1.2.2.1.12.{#SNMPINDEX}','10221','#{#SNMPVALUE}: Hardware serial number','system.hw.serialnumber[chStackUnitSerialNumber.{#SNMPINDEX}]','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: F10-S-SERIES-CHASSIS-MIB
The unit''s serial number.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27484','20','1.3.6.1.4.1.6027.3.10.1.2.2.1.7.{#SNMPINDEX}','10221','#{#SNMPVALUE}: Hardware model name','system.hw.model[chStackUnitModelID.{#SNMPINDEX}]','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: F10-S-SERIES-CHASSIS-MIB
The plugged-in model ID for this unit.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27485','20','1.3.6.1.4.1.6027.3.10.1.2.2.1.14.{#SNMPINDEX}','10221','Device {#SNMPVALUE}: Temperature','sensor.temp.value[chStackUnitTemp.{#SNMPINDEX}]','3m','90d','365d','0','0','','°C','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: F10-S-SERIES-CHASSIS-MIB
The temperature of the unit.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27508','20','1.3.6.1.2.1.47.1.1.1.1.8.1','10222','Hardware version(revision)','system.hw.version','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: ENTITY-MIB','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27509','20','1.3.6.1.2.1.47.1.1.1.1.9.1','10222','Firmware version','system.hw.firmware','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: ENTITY-MIB','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27510','20','1.3.6.1.2.1.1.1.0','10222','Hardware model name','system.hw.model','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: SNMPv2-MIB
A textual description of the entity. This value should
include the full name and version identification of the system''s hardware type, software operating-system, and
networking software.','29','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27511','20','1.3.6.1.4.1.171.10.97.2.36.1.1.3.0','10222','CPU utilization','system.cpu.util[myCPUUtilization5Min.0]','1m','7d','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: MY-PROCESS-MIB
CPU utilization in %','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27512','20','discovery[{#SNMPVALUE},1.3.6.1.4.1.171.10.97.2.35.1.1.1.2]','10222','Memory Discovery','memory.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27513','20','discovery[{#SNMPVALUE},1.3.6.1.4.1.171.10.97.2.1.1.23.1.2]','10222','Temperature Discovery','temperature.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27514','20','discovery[{#SNMPVALUE},1.3.6.1.4.1.171.10.97.2.1.1.18.1.3]','10222','PSU Discovery','psu.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27515','20','discovery[{#SNMPVALUE},1.3.6.1.4.1.171.10.97.2.1.1.21.1.3]','10222','FAN Discovery','fan.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27517','20','1.3.6.1.4.1.171.10.97.2.1.1.23.1.3.{#SNMPINDEX}','10222','{#SNMPVALUE}: Temperature','sensor.temp.value[mySystemTemperatureCurrent.{#SNMPINDEX}]','3m','90d','365d','0','0','','°C','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: MY-SYSTEM-MIB
Return the current temperature of the FastSwitch.The temperature display is not supported for the current temperature returns to 0.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27518','20','1.3.6.1.4.1.171.10.97.2.1.1.18.1.2.{#SNMPINDEX}','10222','{#SNMPVALUE}: Power supply status','sensor.psu.status[mySystemElectricalSourceIsNormal.{#SNMPINDEX}]','3m','2w','0d','0','3','','','','',NULL,'32','','','0','','','','','2',NULL,'MIB: MY-SYSTEM-MIB','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27519','20','1.3.6.1.4.1.171.10.97.2.1.1.21.1.2.{#SNMPINDEX}','10222','{#SNMPVALUE}: Fan status','sensor.fan.status[mySystemFanIsNormal.{#SNMPINDEX}]','3m','2w','0d','0','3','','','','',NULL,'32','','','0','','','','','2',NULL,'MIB: MY-SYSTEM-MIB','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27543','20','1.3.6.1.2.1.47.1.1.1.1.8.1','10223','Hardware version(revision)','system.hw.version','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: ENTITY-MIB','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27544','20','1.3.6.1.2.1.47.1.1.1.1.9.1','10223','Firmware version','system.hw.firmware','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: ENTITY-MIB','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27545','20','1.3.6.1.4.1.171.12.1.1.12.0','10223','Hardware serial number','system.hw.serialnumber','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: DLINK-AGENT-MIB
A text string containing the serial number of this device.','8','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27546','20','1.3.6.1.2.1.1.1.0','10223','Hardware model name','system.hw.model','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: SNMPv2-MIB
A textual description of the entity.  This value should
include the full name and version identification of the system''s hardware type, software operating-system, and
networking software.','29','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27547','20','1.3.6.1.4.1.171.12.1.1.6.2.0','10223','CPU utilization','system.cpu.util[agentCPUutilizationIn1min.0]','1m','7d','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: DLINK-AGENT-MIB
The unit of time is 1 minute. The value will be between 0% (idle) and 100%(very busy).','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27548','20','discovery[{#SNMPVALUE},1.3.6.1.4.1.171.12.1.1.9.1.1]','10223','Memory Discovery','memory.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27549','20','discovery[{#SNMPVALUE},1.3.6.1.4.1.171.12.11.1.8.1.1]','10223','Temperature Discovery','temperature.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27550','20','discovery[{#SNMPVALUE},1.3.6.1.4.1.171.12.11.1.6.1.2,{#STATUS},1.3.6.1.4.1.171.12.11.1.6.1.3]','10223','PSU Discovery','psu.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'swPowerID of EQUIPMENT-MIB::swPowerTable','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27551','20','discovery[{#SNMPVALUE},1.3.6.1.4.1.171.12.11.1.7.1.2,{#STATUS},1.3.6.1.4.1.171.12.11.1.7.1.3]','10223','FAN Discovery','fan.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'swFanID of EQUIPMENT-MIB::swFanTable','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27553','20','1.3.6.1.4.1.171.12.11.1.8.1.2.{#SNMPINDEX}','10223','#{#SNMPVALUE}: Temperature','sensor.temp.value[swTemperatureCurrent.{#SNMPINDEX}]','3m','90d','365d','0','0','','°C','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: EQUIPMENT-MIB
The shelf current temperature.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27554','20','1.3.6.1.4.1.171.12.11.1.6.1.3.{#SNMPINDEX}','10223','#{#SNMPVALUE}: Power supply status','sensor.psu.status[swPowerStatus.{#SNMPINDEX}]','3m','2w','0d','0','3','','','','',NULL,'34','','','0','','','','','2',NULL,'MIB: EQUIPMENT-MIB
Indicates the current power status.
lowVoltage : The voltage of the power unit is too low.
overCurrent: The current of the power unit is too high.
working    : The power unit is working normally.
fail       : The power unit has failed.
connect    : The power unit is connected but not powered on.
disconnect : The power unit is not connected.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27555','20','1.3.6.1.4.1.171.12.11.1.7.1.3.{#SNMPINDEX}','10223','#{#SNMPVALUE}: Fan status','sensor.fan.status[swFanStatus.{#SNMPINDEX}]','3m','2w','0d','0','3','','','','',NULL,'33','','','0','','','','','2',NULL,'MIB: EQUIPMENT-MIB
Indicates the current fan status.
speed-0     : If the fan function is normal and the fan does not spin            due to the temperature not  reaching the threshold, the status of the fan is speed 0.
speed-low   : Fan spin using the lowest speed.
speed-middle: Fan spin using the middle speed.
speed-high  : Fan spin using the highest speed.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27579','20','1.3.6.1.2.1.47.1.1.1.1.9.1','10224','Firmware version','system.hw.firmware','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: ENTITY-MIB','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27580','20','1.3.6.1.2.1.47.1.1.1.1.9.1','10224','Hardware version(revision)','system.hw.version','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: ENTITY-MIB','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27582','20','1.3.6.1.2.1.47.1.1.1.1.11.1','10224','Hardware serial number','system.hw.serialnumber','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: ENTITY-MIB','8','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27583','20','1.3.6.1.2.1.47.1.1.1.1.2.1','10224','Hardware model name','system.hw.model','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: ENTITY-MIB','29','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27584','20','1.3.6.1.4.1.1916.1.1.1.8.0','10224','Device: Temperature','sensor.temp.value[extremeCurrentTemperature.0]','3m','90d','365d','0','0','','°C','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: EXTREME-SYSTEM-MIB
Temperature readings of testpoint: Device
Reference: https://gtacknowledge.extremenetworks.com/articles/Q_A/Does-EXOS-support-temperature-polling-via-SNMP-on-all-nodes-in-a-stack','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27585','20','1.3.6.1.4.1.1916.1.1.1.7.0','10224','Device: Temperature status','sensor.temp.status[extremeOverTemperatureAlarm.0]','3m','2w','0d','0','3','','','','',NULL,'37','','','0','','','','','0',NULL,'MIB: EXTREME-SYSTEM-MIB
Temperature status of testpoint: Device','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27586','20','1.3.6.1.4.1.1916.1.32.1.2.0','10224','CPU utilization','system.cpu.util[extremeCpuMonitorTotalUtilization.0]','1m','7d','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: EXTREME-SOFTWARE-MONITOR-MIB
Total CPU utlization (percentage) as of last sampling.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27587','20','discovery[{#SNMPVALUE},1.3.6.1.4.1.1916.1.32.2.2.1.1]','10224','Memory Discovery','memory.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27588','20','discovery[{#SNMPVALUE},1.3.6.1.4.1.1916.1.1.1.27.1.1]','10224','PSU Discovery','psu.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Table of status of all power supplies in the system.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27589','20','discovery[{#SNMPVALUE},1.3.6.1.4.1.1916.1.1.1.9.1.1]','10224','FAN Discovery','fan.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27591','20','1.3.6.1.4.1.1916.1.32.2.2.1.2.{#SNMPINDEX}','10224','#{#SNMPVALUE}: Total memory','vm.memory.total[extremeMemoryMonitorSystemTotal.{#SNMPINDEX}]','1m','7d','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: EXTREME-SOFTWARE-MONITOR-MIB
Total amount of DRAM in Kbytes in the system.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27593','20','1.3.6.1.4.1.1916.1.1.1.27.1.2.{#SNMPINDEX}','10224','PSU {#SNMPVALUE}: Power supply status','sensor.psu.status[extremePowerSupplyStatus.{#SNMPINDEX}]','3m','2w','0d','0','3','','','','',NULL,'38','','','0','','','','','2',NULL,'MIB: EXTREME-SYSTEM-MIB
Status of the power supply {#SNMPVALUE}','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27594','20','1.3.6.1.4.1.1916.1.1.1.9.1.4.{#SNMPINDEX}','10224','Fan {#SNMPVALUE}: Fan speed','sensor.fan.speed[extremeFanSpeed.{#SNMPINDEX}]','1m','90d','365d','0','3','','rpm','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: EXTREME-SYSTEM-MIB
The speed (RPM) of a cooling fan in the fantray {#SNMPVALUE}','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27595','20','1.3.6.1.4.1.1916.1.1.1.9.1.2.{#SNMPINDEX}','10224','Fan {#SNMPVALUE}: Fan status','sensor.fan.status[extremeFanOperational.{#SNMPINDEX}]','3m','2w','0d','0','3','','','','',NULL,'36','','','0','','','','','2',NULL,'MIB: EXTREME-SYSTEM-MIB
Operational status of a cooling fan.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27665','20','discovery[{#SNMPVALUE},1.3.6.1.2.1.47.1.1.1.1.2,{#MODULE_NAME},1.3.6.1.2.1.47.1.1.1.1.7]','10227','Module Discovery','module.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Filter limits results to ''Module level1'' or Fabric Modules','0','30d','2','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27666','20','discovery[{#SNMPVALUE},1.3.6.1.2.1.47.1.1.1.1.2,{#MODULE_NAME},1.3.6.1.2.1.47.1.1.1.1.7]','10227','Temperature Discovery','temp.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Discovering modules temperature (same filter as in Module Discovery) plus and temperature sensors','0','30d','2','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27667','20','discovery[{#ENT_CLASS},1.3.6.1.2.1.47.1.1.1.1.5,{#ENT_NAME},1.3.6.1.2.1.47.1.1.1.1.7,{#ENT_DESCR},1.3.6.1.2.1.47.1.1.1.1.2]','10227','FAN Discovery','fan.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Discovering all entities of PhysicalClass - 7: fan(7)','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27668','20','discovery[{#ENT_CLASS},1.3.6.1.2.1.47.1.1.1.1.5,{#ENT_NAME},1.3.6.1.2.1.47.1.1.1.1.7,{#ENT_DESCR},1.3.6.1.2.1.47.1.1.1.1.2]','10227','PSU Discovery','psu.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Discovering all entities of PhysicalClass - 6: powerSupply(6)','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27669','20','discovery[{#ENT_CLASS},1.3.6.1.2.1.47.1.1.1.1.5,{#ENT_NAME},1.3.6.1.2.1.47.1.1.1.1.7]','10227','Entity Discovery','entity.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27671','20','1.3.6.1.4.1.25506.2.6.1.1.1.1.6.{#SNMPINDEX}','10227','{#MODULE_NAME}: CPU utilization','system.cpu.util[hh3cEntityExtCpuUsage.{#SNMPINDEX}]','1m','7d','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: HH3C-ENTITY-EXT-MIB
The CPU usage for this entity. Generally, the CPU usage
will calculate the overall CPU usage on the entity, and it
is not sensible with the number of CPU on the entity','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27672','20','1.3.6.1.4.1.25506.2.6.1.1.1.1.12.{#SNMPINDEX}','10227','{#SNMPVALUE}: Temperature','sensor.temp.value[hh3cEntityExtTemperature.{#SNMPINDEX}]','3m','90d','365d','0','0','','°C','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: HH3C-ENTITY-EXT-MIB
The temperature for the {#SNMPVALUE}.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27673','20','1.3.6.1.4.1.25506.2.6.1.1.1.1.19.{#SNMPINDEX}','10227','{#ENT_NAME}: Fan status','sensor.fan.status[hh3cEntityExtErrorStatus.{#SNMPINDEX}]','3m','2w','0d','0','3','','','','',NULL,'39','','','0','','','','','2',NULL,'MIB: HH3C-ENTITY-EXT-MIB
Indicate the error state of this entity object.
fanError(41) means that the fan stops working.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27674','20','1.3.6.1.4.1.25506.2.6.1.1.1.1.19.{#SNMPINDEX}','10227','{#ENT_NAME}: Power supply status','sensor.psu.status[hh3cEntityExtErrorStatus.{#SNMPINDEX}]','3m','2w','0d','0','3','','','','',NULL,'39','','','0','','','','','2',NULL,'MIB: HH3C-ENTITY-EXT-MIB
Indicate the error state of this entity object.
psuError(51) means that the Power Supply Unit is in the state of fault.
rpsError(61) means the Redundant Power Supply is in the state of fault.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27675','20','1.3.6.1.2.1.47.1.1.1.1.10.{#SNMPINDEX}','10227','{#ENT_NAME}: Operating system','system.sw.os[entPhysicalSoftwareRev.{#SNMPINDEX}]','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: ENTITY-MIB','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27676','20','1.3.6.1.2.1.47.1.1.1.1.8.{#SNMPINDEX}','10227','{#ENT_NAME}: Hardware version(revision)','system.hw.version[entPhysicalHardwareRev.{#SNMPINDEX}]','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: ENTITY-MIB','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27677','20','1.3.6.1.2.1.47.1.1.1.1.9.{#SNMPINDEX}','10227','{#ENT_NAME}: Firmware version','system.hw.firmware[entPhysicalFirmwareRev.{#SNMPINDEX}]','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: ENTITY-MIB','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27678','20','1.3.6.1.2.1.47.1.1.1.1.11.{#SNMPINDEX}','10227','{#ENT_NAME}: Hardware serial number','system.hw.serialnumber[entPhysicalSerialNum.{#SNMPINDEX}]','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: ENTITY-MIB','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27679','20','1.3.6.1.2.1.47.1.1.1.1.2.{#SNMPINDEX}','10227','{#ENT_NAME}: Hardware model name','system.hw.model[entPhysicalDescr.{#SNMPINDEX}]','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: ENTITY-MIB','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27745','20','discovery[{#ENT_NAME},1.3.6.1.2.1.47.1.1.1.1.7]','10229','MPU Discovery','mpu.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'http://support.huawei.com/enterprise/KnowledgebaseReadAction.action?contentId=KB1000090234. Filter limits results to Main Processing Units','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27746','20','discovery[{#ENT_CLASS},1.3.6.1.2.1.47.1.1.1.1.5,{#ENT_NAME},1.3.6.1.2.1.47.1.1.1.1.7]','10229','Entity Discovery','entity.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27747','20','discovery[{#SNMPVALUE},1.3.6.1.4.1.2011.5.25.31.1.1.10.1.1]','10229','FAN Discovery','discovery.fans','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27748','20','1.3.6.1.2.1.47.1.1.1.1.8.{#SNMPINDEX}','10229','{#ENT_NAME}: Hardware version(revision)','system.hw.version[entPhysicalHardwareRev.{#SNMPINDEX}]','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: ENTITY-MIB','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27749','20','1.3.6.1.2.1.47.1.1.1.1.10.{#SNMPINDEX}','10229','{#ENT_NAME}: Operating system','system.sw.os[entPhysicalSoftwareRev.{#SNMPINDEX}]','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: ENTITY-MIB','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27750','20','1.3.6.1.2.1.47.1.1.1.1.11.{#SNMPINDEX}','10229','{#ENT_NAME}: Hardware serial number','system.hw.serialnumber[entPhysicalSerialNum.{#SNMPINDEX}]','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: ENTITY-MIB','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27751','20','1.3.6.1.4.1.2011.5.25.31.1.1.1.1.11.{#SNMPINDEX}','10229','{#ENT_NAME}: Temperature','sensor.temp.value[hwEntityTemperature.{#SNMPINDEX}]','3m','90d','365d','0','0','','°C','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: HUAWEI-ENTITY-EXTENT-MIB
The temperature for the {#SNMPVALUE}.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27753','20','1.3.6.1.4.1.2011.5.25.31.1.1.1.1.5.{#SNMPINDEX}','10229','{#ENT_NAME}: CPU utilization','system.cpu.util[hwEntityCpuUsage.{#SNMPINDEX}]','1m','7d','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: HUAWEI-ENTITY-EXTENT-MIB
The CPU usage for this entity. Generally, the CPU usage will calculate the overall CPU usage on the entity, and itis not sensible with the number of CPU on the entity.
Reference: http://support.huawei.com/enterprise/KnowledgebaseReadAction.action?contentId=KB1000090234','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27754','20','1.3.6.1.2.1.47.1.1.1.1.2.{#SNMPINDEX}','10229','{#ENT_NAME}: Hardware model name','system.hw.model[entPhysicalDescr.{#SNMPINDEX}]','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: ENTITY-MIB','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27755','20','1.3.6.1.4.1.2011.5.25.31.1.1.10.1.7.{#SNMPINDEX}','10229','#{#SNMPVALUE}: Fan status','sensor.fan.status[hwEntityFanState.{#SNMPINDEX}]','3m','2w','0d','0','3','','','','',NULL,'41','','','0','','','','','2',NULL,'MIB: HUAWEI-ENTITY-EXTENT-MIB','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27777','20','1.3.6.1.4.1.10222.2.1.1.1.0','10230','Firmware version','system.hw.firmware','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: ICS-CHASSIS-MIB','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27778','20','1.3.6.1.4.1.10222.2.1.1.1.0','10230','Hardware model name','system.hw.model','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: ICS-CHASSIS-MIB','29','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27779','20','discovery[{#SENSOR_TYPE},1.3.6.1.4.1.10222.2.1.9.8.1.2,{#SENSOR_INFO},1.3.6.1.4.1.10222.2.1.9.8.1.7]','10230','Temperature Discovery','temp.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Discovering sensor''s table with temperature filter','0','30d','1','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27780','20','discovery[{#ENT_CLASS},1.3.6.1.4.1.10222.2.1.1.9.1.3,{#ENT_NAME},1.3.6.1.4.1.10222.2.1.1.9.1.2]','10230','Unit Discovery','unit.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27781','20','discovery[{#SNMPVALUE},1.3.6.1.4.1.10222.2.1.4.7.1.2]','10230','PSU Discovery','psu.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'A textual description of the power supply, that can be assigned by the administrator.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27782','20','discovery[{#SNMPVALUE},1.3.6.1.4.1.10222.2.1.6.5.1.2]','10230','FAN Discovery','fan.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'icsChassisFanDescription of icsChassisFanTable','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27783','20','1.3.6.1.4.1.10222.2.1.9.8.1.3.{#SNMPINDEX}','10230','{#SENSOR_INFO}: Temperature status','sensor.temp.status[icsChassisSensorSlotOperStatus.{#SNMPINDEX}]','3m','2w','0d','0','3','','','','',NULL,'43','','','0','','','','','2',NULL,'MIB: ICS-CHASSIS-MIB
The operational status of the sensor.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27784','20','1.3.6.1.4.1.10222.2.1.9.8.1.8.{#SNMPINDEX}','10230','{#SENSOR_INFO}: Temperature','sensor.temp.value[icsChassisSensorSlotValue.{#SNMPINDEX}]','3m','90d','365d','0','0','','°C','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: ICS-CHASSIS-MIB
The current value read from the sensor.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27785','20','1.3.6.1.4.1.10222.2.1.1.10.1.1.{#SNMPINDEX}','10230','{#ENT_NAME}: Hardware serial number','system.hw.serialnumber[icsChassisSystemUnitFruSerialNumber.{#SNMPINDEX}]','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: ICS-CHASSIS-MIB
The serial number of the FRU.  If not available, this value is a zero-length string.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27786','20','1.3.6.1.4.1.10222.2.1.4.7.1.3.{#SNMPINDEX}','10230','{#SNMPVALUE}: Power supply status','sensor.psu.status[icsChassisPowerSupplyEntry.{#SNMPINDEX}]','3m','2w','0d','0','3','','','','',NULL,'44','','','0','','','','','2',NULL,'MIB: ICS-CHASSIS-MIB
Actual status of the power supply:
(1) unknown: status not known.
(2) disabled: power supply is disabled.
(3) failed - power supply is unable to supply power due to failure.
(4) warning - power supply is supplying power, but an output or sensor is bad or warning.
(5) standby - power supply believed usable,but not supplying power.
(6) engaged - power supply is supplying power.
(7) redundant - power supply is supplying power, but not needed.
(8) notPresent - power supply is supplying power is not present.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27787','20','1.3.6.1.4.1.10222.2.1.6.5.1.3.{#SNMPINDEX}','10230','{#SNMPVALUE}: Fan status','sensor.fan.status[icsChassisFanOperStatus.{#SNMPINDEX}]','3m','2w','0d','0','3','','','','',NULL,'42','','','0','','','','','2',NULL,'MIB: ICS-CHASSIS-MIB
The operational status of the fan unit.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27812','20','1.3.6.1.4.1.2636.3.1.2.0','10231','Hardware model name','system.hw.model','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: JUNIPER-MIB
The name, model, or detailed description of the box,indicating which product the box is about, for example ''M40''.','29','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27813','20','1.3.6.1.4.1.2636.3.1.3.0','10231','Hardware serial number','system.hw.serialnumber','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: JUNIPER-MIB
The serial number of this subject, blank if unknown or unavailable.','8','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27814','20','1.3.6.1.4.1.2636.3.4.2.3.1.0','10231','Overall system health status','system.status[jnxRedAlarmState.0]','30s','2w','0d','0','3','','','','',NULL,'46','','','0','','','','','0',NULL,'MIB: JUNIPER-ALARM-MIB
The red alarm indication on the craft interface panel.
The red alarm is on when there is some system
failure or power supply failure or the system
is experiencing a hardware malfunction or some
threshold is being exceeded.

This red alarm state could be turned off by the
ACO/LT (Alarm Cut Off / Lamp Test) button on the
front panel module.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27815','20','discovery[{#SNMPVALUE},1.3.6.1.4.1.2636.3.1.13.1.5]','10231','CPU and Memory Discovery','jnxOperatingTable.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Scanning JUNIPER-MIB::jnxOperatingTable for CPU and Memory
http://kb.juniper.net/InfoCenter/index?page=content&id=KB17526&actp=search. Filter limits results to Routing Engines','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27816','20','discovery[{#SNMPVALUE},1.3.6.1.4.1.2636.3.1.13.1.7,{#SENSOR_INFO},1.3.6.1.4.1.2636.3.1.13.1.5]','10231','Temperature discovery','jnxOperatingTable.discovery.temp','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Scanning JUNIPER-MIB::jnxOperatingTable for Temperature
http://kb.juniper.net/InfoCenter/index?page=content&id=KB17526&actp=search. Filter limits results to Routing Engines','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27817','20','discovery[{#SNMPVALUE},1.3.6.1.4.1.2636.3.1.13.1.5.4]','10231','FAN Discovery','jnxOperatingTable.discovery.fans','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Scanning JUNIPER-MIB::jnxOperatingTable for Fans','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27818','20','discovery[{#SNMPVALUE},1.3.6.1.4.1.2636.3.1.13.1.5.2]','10231','PSU Discovery','jnxOperatingTable.discovery.psu','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Scanning JUNIPER-MIB::jnxOperatingTable for Power Supplies','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27821','20','1.3.6.1.4.1.2636.3.1.13.1.7.{#SNMPINDEX}','10231','{#SENSOR_INFO}: Temperature','sensor.temp.value[jnxOperatingTemp.{#SNMPINDEX}]','3m','90d','365d','0','0','','°C','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: JUNIPER-MIB
The temperature in Celsius (degrees C) of {#SENSOR_INFO}','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27822','20','1.3.6.1.4.1.2636.3.1.13.1.6.4.{#SNMPINDEX}','10231','{#SNMPVALUE}: Fan status','sensor.fan.status[jnxOperatingState.4.{#SNMPINDEX}]','3m','2w','0d','0','3','','','','',NULL,'47','','','0','','','','','2',NULL,'MIB: JUNIPER-MIB','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27823','20','1.3.6.1.4.1.2636.3.1.13.1.6.2.{#SNMPINDEX}','10231','{#SNMPVALUE}: Power supply status','sensor.psu.status[jnxOperatingState.2.{#SNMPINDEX}]','3m','2w','0d','0','3','','','','',NULL,'47','','','0','','','','','2',NULL,'MIB: JUNIPER-MIB
If they are using DC power supplies there is a known issue on PR 1064039 where the fans do not detect the temperature correctly and fail to cool the power supply causing the shutdown to occur.
This is fixed in Junos 13.3R7 https://forums.juniper.net/t5/Routing/PEM-0-not-OK-MX104/m-p/289644#M14122','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27893','20','1.3.6.1.2.1.1.1.0','10233','Hardware model name','system.hw.model','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','29','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27894','20','1.3.6.1.4.1.14988.1.1.7.3.0','10233','Hardware serial number','system.hw.serialnumber','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: MIKROTIK-MIB
RouterBOARD serial number','8','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27895','20','1.3.6.1.4.1.14988.1.1.7.4.0','10233','Firmware version','system.hw.firmware','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: MIKROTIK-MIB
Current firmware version','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27898','20','1.3.6.1.2.1.25.2.3.1.5.65536','10233','Total memory','vm.memory.total[hrStorageSize.Memory]','1m','7d','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: HOST-RESOURCES-MIB
The size of the storage represented by this entry, in
units of hrStorageAllocationUnits. This object is
writable to allow remote configuration of the size of
the storage area in those cases where such an
operation makes sense and is possible on the
underlying system. For example, the amount of main
memory allocated to a buffer pool might be modified or
the amount of disk space allocated to virtual memory
might be modified.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27900','20','1.3.6.1.2.1.25.2.3.1.6.65536','10233','Used memory','vm.memory.used[hrStorageUsed.Memory]','1m','7d','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: HOST-RESOURCES-MIB
The amount of the storage represented by this entry that is allocated, in units of hrStorageAllocationUnits.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27901','20','discovery[{#SNMPVALUE},1.3.6.1.2.1.25.3.3.1.1]','10233','CPU discovery','hrProcessorLoad.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'HOST-RESOURCES-MIB::hrProcessorTable discovery','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27902','20','discovery[{#SNMPVALUE},1.3.6.1.4.1.14988.1.1.3.11]','10233','Temperature CPU discovery','mtxrHlProcessorTemperature.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'MIKROTIK-MIB::mtxrHlProcessorTemperature
Since temperature of CPU is not available on all Mikrotik hardware, this is done to avoid unsupported items.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27903','20','discovery[{#SNMPVALUE},1.3.6.1.2.1.25.2.3.1.3,{#ALLOC_UNITS},1.3.6.1.2.1.25.2.3.1.4,{#STORAGE_TYPE},1.3.6.1.2.1.25.2.3.1.2]','10233','Storage discovery','storage.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'HOST-RESOURCES-MIB::hrStorage discovery with storage filter','0','30d','2','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27904','20','1.3.6.1.2.1.25.3.3.1.2.{#SNMPINDEX}','10233','#{#SNMPINDEX}: CPU utilization','system.cpu.util[hrProcessorLoad.{#SNMPINDEX}]','1m','7d','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: HOST-RESOURCES-MIB
The average, over the last minute, of the percentage of time that this processor was not idle. Implementations may approximate this one minute smoothing period if necessary.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27905','20','1.3.6.1.4.1.14988.1.1.3.11.{#SNMPINDEX}','10233','CPU: Temperature','sensor.temp.value[mtxrHlProcessorTemperature.{#SNMPINDEX}]','3m','90d','365d','0','0','','°C','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: MIKROTIK-MIB
(mtxrHlProcessorTemperature) Processor temperature in Celsius (degrees C). Might be missing in entry models (RB750, RB450G..)','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27906','15','','10233','Disk-{#SNMPINDEX}: Space utilization','vfs.fs.pused[hrStorageSize.{#SNMPINDEX}]','1m','7d','365d','0','0','','%','','',NULL,NULL,'(last("vfs.fs.used[hrStorageSize.{#SNMPINDEX}]")/last("vfs.fs.total[hrStorageSize.{#SNMPINDEX}]"))*100','','0','','','','','2',NULL,'Space utilization in % for Disk-{#SNMPINDEX}','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27907','20','1.3.6.1.2.1.25.2.3.1.5.{#SNMPINDEX}','10233','Disk-{#SNMPINDEX}: Total space','vfs.fs.total[hrStorageSize.{#SNMPINDEX}]','1m','7d','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: HOST-RESOURCES-MIB
The size of the storage represented by this entry, in
units of hrStorageAllocationUnits. This object is
writable to allow remote configuration of the size of
the storage area in those cases where such an
operation makes sense and is possible on the
underlying system. For example, the amount of main
memory allocated to a buffer pool might be modified or
the amount of disk space allocated to virtual memory
might be modified.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27908','20','1.3.6.1.2.1.25.2.3.1.6.{#SNMPINDEX}','10233','Disk-{#SNMPINDEX}: Used space','vfs.fs.used[hrStorageSize.{#SNMPINDEX}]','1m','7d','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: HOST-RESOURCES-MIB
The amount of the storage represented by this entry that is allocated, in units of hrStorageAllocationUnits.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27930','20','1.3.6.1.4.1.4526.10.1.1.1.3.0','10234','Hardware model name','system.hw.model','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: FASTPATH-SWITCHING-MIB','29','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27931','20','1.3.6.1.4.1.4526.10.1.1.1.4.0','10234','Hardware serial number','system.hw.serialnumber','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: FASTPATH-SWITCHING-MIB
Serial number of the switch','8','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27935','20','1.3.6.1.4.1.4526.10.1.1.5.2.0','10234','Total memory','vm.memory.total[agentSwitchCpuProcessMemAvailable.0]','1m','7d','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: FASTPATH-SWITCHING-MIB
The total Memory allocated for the tasks','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27936','20','1.3.6.1.4.1.4526.10.1.1.4.9.0','10234','CPU utilization','system.cpu.util[agentSwitchCpuProcessTotalUtilization.0]','1m','7d','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: FASTPATH-SWITCHING-MIB
CPU utilization in %','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27937','20','discovery[{#SNMPVALUE},1.3.6.1.4.1.4526.10.43.1.8.1.1]','10234','Temperature Discovery','temp.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'FASTPATH-BOXSERVICES-PRIVATE-MIB::boxServicesTempSensorsTable','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27938','20','discovery[{#SNMPVALUE},1.3.6.1.4.1.4526.10.43.1.6.1.1]','10234','FAN Discovery','fan.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'FASTPATH-BOXSERVICES-PRIVATE-MIB::1.3.6.1.4.1.4526.10.43.1.6.1.1','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27939','20','discovery[{#SNMPVALUE},1.3.6.1.4.1.4526.10.43.1.7.1.1]','10234','PSU Discovery','psu.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'FASTPATH-BOXSERVICES-PRIVATE-MIB::boxServicesPowSupplyIndex','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27940','20','1.3.6.1.4.1.4526.10.43.1.8.1.3.{#SNMPINDEX}','10234','#{#SNMPVALUE}: Temperature status','sensor.temp.status[boxServicesTempSensorState.{#SNMPINDEX}]','3m','2w','0d','0','3','','','','',NULL,'51','','','0','','','','','2',NULL,'MIB: FASTPATH-BOXSERVICES-PRIVATE-MIB
The state of temperature sensor','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27941','20','1.3.6.1.4.1.4526.10.43.1.8.1.5.{#SNMPINDEX}','10234','#{#SNMPVALUE}: Temperature','sensor.temp.value[boxServicesTempSensorTemperature.{#SNMPINDEX}]','3m','90d','365d','0','0','','°C','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: FASTPATH-BOXSERVICES-PRIVATE-MIB
The temperature value reported by sensor','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27942','20','1.3.6.1.4.1.4526.10.43.1.6.1.3.{#SNMPINDEX}','10234','#{#SNMPVALUE}: Fan status','sensor.fan.status[boxServicesFanItemState.{#SNMPINDEX}]','3m','2w','0d','0','3','','','','',NULL,'50','','','0','','','','','2',NULL,'MIB: FASTPATH-BOXSERVICES-PRIVATE-MIB
The status of fan','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27943','20','1.3.6.1.4.1.4526.10.43.1.7.1.3.{#SNMPINDEX}','10234','#{#SNMPVALUE}: Power supply status','sensor.psu.status[boxServicesPowSupplyItemState.{#SNMPINDEX}]','3m','2w','0d','0','3','','','','',NULL,'49','','','0','','','','','2',NULL,'MIB: FASTPATH-BOXSERVICES-PRIVATE-MIB
The status of power supply','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27967','20','1.3.6.1.2.1.47.1.1.1.1.9.1','10235','Firmware version','system.hw.firmware','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: ENTITY-MIB','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27968','20','1.3.6.1.2.1.47.1.1.1.1.8.1','10235','Hardware version(revision)','system.hw.version','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: ENTITY-MIB','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27970','20','1.3.6.1.2.1.47.1.1.1.1.11.1','10235','Hardware serial number','system.hw.serialnumber','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: ENTITY-MIB','8','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27971','20','1.3.6.1.2.1.47.1.1.1.1.13.1','10235','Hardware model name','system.hw.model','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: ENTITY-MIB','29','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27972','20','1.3.6.1.4.1.27514.100.1.11.7.0','10235','Used memory','vm.memory.used[switchMemoryBusy.0]','1m','7d','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: QTECH-MIB
Used memory in Bytes','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27973','20','1.3.6.1.4.1.27514.100.1.11.6.0','10235','Total memory','vm.memory.total[switchMemorySize.0]','1m','7d','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: QTECH-MIB
Total memory in Bytes','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27975','20','1.3.6.1.4.1.27514.100.1.11.10.0','10235','CPU utilization','system.cpu.util[switchCpuUsage.0]','1m','7d','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: QTECH-MIB
CPU utilization in %','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27997','20','1.3.6.1.4.1.11863.6.1.1.5.0','10236','Hardware version(revision)','system.hw.version','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: TPLINK-SYSINFO-MIB
The hardware version of the product.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27998','20','1.3.6.1.4.1.11863.6.1.1.6.0','10236','Firmware version','system.hw.firmware','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: TPLINK-SYSINFO-MIB
The software version of the product.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('27999','20','1.3.6.1.4.1.11863.6.1.1.8.0','10236','Hardware serial number','system.hw.serialnumber','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: TPLINK-SYSINFO-MIB
The Serial number of the product.','8','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('28000','20','1.3.6.1.4.1.11863.6.1.1.5.0','10236','Hardware model name','system.hw.model','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: TPLINK-SYSINFO-MIB
The hardware version of the product.','29','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('28001','20','discovery[{#SNMPVALUE},1.3.6.1.4.1.11863.6.4.1.1.1.1.1]','10236','CPU Discovery','cpu.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Discovering TPLINK-SYSMONITOR-MIB::tpSysMonitorCpuTable, displays the CPU utilization of all UNITs.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('28002','20','discovery[{#SNMPVALUE},1.3.6.1.4.1.11863.6.4.1.2.1.1.1]','10236','Memory Discovery','memory.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Discovering TPLINK-SYSMONITOR-MIB::tpSysMonitorMemoryTable, displays the memory utilization of all UNITs.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('28003','20','1.3.6.1.4.1.11863.6.4.1.1.1.1.3.{#SNMPINDEX}','10236','#{#SNMPVALUE}: CPU utilization','system.cpu.util[tpSysMonitorCpu1Minute.{#SNMPINDEX}]','1m','7d','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: TPLINK-SYSMONITOR-MIB
Displays the CPU utilization in 1 minute.
Reference: http://www.tp-link.com/faq-1330.html','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('28026','20','1.2.840.10036.3.1.2.1.3.5','10237','Hardware model name','system.hw.model','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: IEEE802dot11-MIB
A printable string used to identify the manufacturer''s product name of the resource. Maximum string length is 128 octets.','29','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('28027','20','1.2.840.10036.3.1.2.1.4.5','10237','Firmware version','system.hw.firmware','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: IEEE802dot11-MIB
Printable string used to identify the manufacturer''s product version of the resource. Maximum string length is 128 octets.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('28031','20','1.3.6.1.4.1.10002.1.1.1.4.2.1.3.2','10237','CPU utilization','system.cpu.util[loadValue.2]','1m','7d','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: FROGFOOT-RESOURCES-MIB
5 minute load average of processor load.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('28141','20','1.3.6.1.4.1.11.2.14.11.5.1.1.3.0','10250','Firmware version','system.hw.firmware','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: NETSWITCH-MIB
Contains the operating code version number (also known as software or firmware).
For example, a software version such as A.08.01 is described as follows:
A    the function set available in your router
08   the common release number
01   updates to the current common release','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('28142','20','1.3.6.1.4.1.11.2.36.1.1.2.9.0','10250','Hardware serial number','system.hw.serialnumber','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: SEMI-MIB','8','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('28143','20','1.3.6.1.4.1.11.2.14.11.5.1.9.6.1.0','10250','CPU utilization','system.cpu.util[hpSwitchCpuStat.0]','1m','7d','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: STATISTICS-MIB
The CPU utilization in percent(%).
Reference: http://h20564.www2.hpe.com/hpsc/doc/public/display?docId=emr_na-c02597344&sp4ts.oid=51079','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('28144','20','discovery[{#SENSOR_TYPE},1.3.6.1.2.1.99.1.1.1.1,{#SENSOR_INFO},1.3.6.1.2.1.47.1.1.1.1.2,{#SENSOR_PRECISION},1.3.6.1.2.1.99.1.1.1.3]','10250','Temperature Discovery','temp.precision0.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'ENTITY-SENSORS-MIB::EntitySensorDataType discovery with celsius filter','0','30d','1','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('28145','20','discovery[{#SNMPVALUE},1.3.6.1.4.1.11.2.14.11.5.1.1.2.1.1.1.1]','10250','Memory Discovery','memory.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Discovery of NETSWITCH-MIB::hpLocalMemTable, A table that contains information on all the local memory for each slot.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('28146','20','discovery[{#ENT_CLASS},1.3.6.1.4.1.11.2.14.11.1.2.6.1.2,{#ENT_DESCR},1.3.6.1.4.1.11.2.14.11.1.2.6.1.7,{#ENT_STATUS},1.3.6.1.4.1.11.2.14.11.1.2.6.1.4]','10250','FAN Discovery','fan.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Discovering all entities of hpicfSensorObjectId that ends with: 11.2.3.7.8.3.2 - fans and are present','0','30d','1','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('28147','20','discovery[{#ENT_CLASS},1.3.6.1.4.1.11.2.14.11.1.2.6.1.2,{#ENT_DESCR},1.3.6.1.4.1.11.2.14.11.1.2.6.1.7,{#ENT_STATUS},1.3.6.1.4.1.11.2.14.11.1.2.6.1.4]','10250','PSU Discovery','psu.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Discovering all entities of hpicfSensorObjectId that ends with: 11.2.3.7.8.3.1 - power supplies and are present','0','30d','1','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('28148','20','discovery[{#ENT_CLASS},1.3.6.1.4.1.11.2.14.11.1.2.6.1.2,{#ENT_DESCR},1.3.6.1.4.1.11.2.14.11.1.2.6.1.7,{#ENT_STATUS},1.3.6.1.4.1.11.2.14.11.1.2.6.1.4]','10250','Temp Status Discovery','temp.status.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Discovering all entities of hpicfSensorObjectId that ends with: 11.2.3.7.8.3.3 - over temp status and are present','0','30d','1','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('28149','20','discovery[{#ENT_CLASS},1.3.6.1.2.1.47.1.1.1.1.5,{#ENT_NAME},1.3.6.1.2.1.47.1.1.1.1.7]','10250','Entity Discovery','entity.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('28150','20','1.3.6.1.2.1.99.1.1.1.4.{#SNMPINDEX}','10250','{#SENSOR_INFO}: Temperature','sensor.temp.value[entPhySensorValue.{#SNMPINDEX}]','3m','90d','365d','0','0','','°C','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: ENTITY-SENSORS-MIB
The most recent measurement obtained by the agent for this sensor.
To correctly interpret the value of this object, the associated entPhySensorType,
entPhySensorScale, and entPhySensorPrecision objects must also be examined.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('28153','20','1.3.6.1.4.1.11.2.14.11.5.1.1.2.1.1.1.7.{#SNMPINDEX}','10250','#{#SNMPVALUE}: Used memory','vm.memory.used[hpLocalMemAllocBytes.{#SNMPINDEX}]','1m','7d','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: NETSWITCH-MIB
The number of currently allocated bytes.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('28154','20','1.3.6.1.4.1.11.2.14.11.1.2.6.1.4.{#SNMPINDEX}','10250','{#ENT_DESCR}: Fan status','sensor.fan.status[hpicfSensorStatus.{#SNMPINDEX}]','3m','2w','0d','0','3','','','','',NULL,'40','','','0','','','','','2',NULL,'MIB: HP-ICF-CHASSIS
Actual status indicated by the sensor: {#ENT_DESCR}','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('28155','20','1.3.6.1.4.1.11.2.14.11.1.2.6.1.4.{#SNMPINDEX}','10250','{#ENT_DESCR}: Power supply status','sensor.psu.status[hpicfSensorStatus.{#SNMPINDEX}]','3m','2w','0d','0','3','','','','',NULL,'40','','','0','','','','','2',NULL,'MIB: HP-ICF-CHASSIS
Actual status indicated by the sensor: {#ENT_DESCR}','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('28156','20','1.3.6.1.4.1.11.2.14.11.1.2.6.1.4.{#SNMPINDEX}','10250','{#ENT_DESCR}: Temperature status','sensor.temp.status[hpicfSensorStatus.{#SNMPINDEX}]','3m','2w','0d','0','3','','','','',NULL,'40','','','0','','','','','2',NULL,'MIB: HP-ICF-CHASSIS
Actual status indicated by the sensor: {#ENT_DESCR}','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('28157','20','1.3.6.1.2.1.47.1.1.1.1.8.{#SNMPINDEX}','10250','{#ENT_NAME}: Hardware version(revision)','system.hw.version[entPhysicalHardwareRev.{#SNMPINDEX}]','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: ENTITY-MIB','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('28158','20','1.3.6.1.2.1.47.1.1.1.1.2.{#SNMPINDEX}','10250','{#ENT_NAME}: Hardware model name','system.hw.model[entPhysicalDescr.{#SNMPINDEX}]','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: ENTITY-MIB','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('28196','20','discovery[{#SENSOR_TYPE},1.3.6.1.2.1.99.1.1.1.1,{#SENSOR_INFO},1.3.6.1.2.1.47.1.1.1.1.2,{#SENSOR_PRECISION},1.3.6.1.2.1.99.1.1.1.3]','10251','Temperature Discovery','temp.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'ENTITY-SENSORS-MIB::EntitySensorDataType discovery with celsius filter','0','30d','1','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('28197','20','discovery[{#SNMPVALUE},1.3.6.1.2.1.99.1.1.1.1,{#SENSOR_INFO},1.3.6.1.2.1.47.1.1.1.1.2]','10251','Fan Discovery','fan.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'ENTITY-SENSORS-MIB::EntitySensorDataType discovery with rpm filter','0','30d','2','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('28198','20','discovery[{#ENT_CLASS},1.3.6.1.2.1.47.1.1.1.1.5,{#ENT_NAME},1.3.6.1.2.1.47.1.1.1.1.7]','10251','Entity Discovery','entity.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('28199','20','discovery[{#ENT_CLASS},1.3.6.1.2.1.47.1.1.1.1.5,{#ENT_NAME},1.3.6.1.2.1.47.1.1.1.1.7]','10251','PSU Discovery','psu.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('28200','20','1.3.6.1.2.1.99.1.1.1.5.{#SNMPINDEX}','10251','{#SENSOR_INFO}: Temperature status','sensor.temp.status[entPhySensorOperStatus.{#SNMPINDEX}]','3m','2w','0d','0','3','','','','',NULL,'18','','','0','','','','','2',NULL,'MIB: ENTITY-SENSORS-MIB
The operational status of the sensor {#SENSOR_INFO}','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('28201','20','1.3.6.1.2.1.99.1.1.1.4.{#SNMPINDEX}','10251','{#SENSOR_INFO}: Temperature','sensor.temp.value[entPhySensorValue.{#SNMPINDEX}]','3m','90d','365d','0','0','','°C','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: ENTITY-SENSORS-MIB
The most recent measurement obtained by the agent for this sensor.
To correctly interpret the value of this object, the associated entPhySensorType,
entPhySensorScale, and entPhySensorPrecision objects must also be examined.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('28202','20','1.3.6.1.2.1.99.1.1.1.5.{#SNMPINDEX}','10251','{#SENSOR_INFO}: Fan status','sensor.fan.status[entPhySensorOperStatus.{#SNMPINDEX}]','3m','2w','0d','0','3','','','','',NULL,'18','','','0','','','','','2',NULL,'MIB: ENTITY-SENSORS-MIB
The operational status of the sensor {#SENSOR_INFO}','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('28203','20','1.3.6.1.2.1.99.1.1.1.4.{#SNMPINDEX}','10251','{#SENSOR_INFO}: Fan speed','sensor.fan.speed[entPhySensorValue.{#SNMPINDEX}]','1m','90d','365d','0','3','','rpm','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: ENTITY-SENSORS-MIB
The most recent measurement obtained by the agent for this sensor.
To correctly interpret the value of this object, the associated entPhySensorType,
entPhySensorScale, and entPhySensorPrecision objects must also be examined.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('28204','20','1.3.6.1.2.1.47.1.1.1.1.11.{#SNMPINDEX}','10251','{#ENT_NAME}: Hardware serial number','system.hw.serialnumber[entPhysicalSerialNum.{#SNMPINDEX}]','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: ENTITY-MIB','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('28205','20','1.3.6.1.2.1.47.1.1.1.1.13.{#SNMPINDEX}','10251','{#ENT_NAME}: Hardware model name','system.hw.model[entPhysicalModelName.{#SNMPINDEX}]','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: ENTITY-MIB','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('28206','20','1.3.6.1.2.1.131.1.1.1.3.{#SNMPINDEX}','10251','{#ENT_NAME}: Power supply status','sensor.psu.status[entStateOper.{#SNMPINDEX}]','3m','2w','0d','0','3','','','','',NULL,'48','','','0','','','','','2',NULL,'MIB: ENTITY-STATE-MIB','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interfaceid,description,inventory_link,lifetime,evaltype,jmx_endpoint,master_itemid,timeout,url,query_fields,posts,status_codes,follow_redirects,post_type,headers,retrieve_mode,request_method,output_format,verify_peer,verify_host,allow_traps,discover) values ('28244','20','discovery[{#SNMPVALUE},1.3.6.1.4.1.9.9.109.1.1.1.1.5]','10252','CPU Discovery','cpu.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'If your IOS device has several CPUs, you must use CISCO-PROCESS-MIB and its object cpmCPUTotal5minRev from the table called cpmCPUTotalTable ,
indexed with cpmCPUTotalIndex .
This table allows CISCO-PROCESS-MIB to keep CPU statistics for different physical entities in the router,
like different CPU chips, group of CPUs, or CPUs in different modules/cards.
In case of a single CPU, cpmCPUTotalTable has only one entry.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO items (itemid,type,snmp_oid,hostid,name,key_,delay,history,trends,status,value_type,trapper_hosts,units,formula,logtimefmt,templateid,valuemapid,params,ipmi_sensor,authtype,username,password,publickey,privatekey,flags,interf