/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.stream;

import com.sun.xml.stream.BufferManager;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;

public class FileBufferManager
extends BufferManager {
    static final int DEFAULT_LENGTH = 8192;
    static final int THRESH_HOLD = 81920;
    static final boolean DEBUG = false;
    CharsetDecoder decoder = null;
    FileChannel fChannel = null;
    CharBuffer charBuffer = null;
    boolean calledGetMore;
    long remaining = -1L;
    long filepos = 0L;
    long filesize = -1L;

    int getLength() {
        return this.remaining < 16384L ? (int)this.remaining : 16384;
    }

    public void close() throws IOException {
        if (this.fChannel != null) {
            this.fChannel.close();
        }
    }

    public boolean getMore() throws IOException {
        this.calledGetMore = true;
        if (this.endOfStream) {
            return false;
        }
        ByteBuffer byteBuffer = this.getMoreBytes();
        if (this.charBuffer.position() != 0) {
            this.charBuffer.compact();
        } else {
            this.charBuffer.clear();
        }
        int n = this.charBuffer.position();
        CoderResult coderResult = this.decoder.decode(byteBuffer, this.charBuffer, false);
        while (byteBuffer.remaining() > 0) {
            if (coderResult.isOverflow()) {
                this.resizeCharBuffer(this.charBuffer.limit() + byteBuffer.remaining());
            }
            coderResult = this.decoder.decode(byteBuffer, this.charBuffer, true);
        }
        if (coderResult.isUnderflow()) {
            coderResult = this.decoder.decode(byteBuffer, this.charBuffer, true);
            this.decoder.flush(this.charBuffer);
        }
        this.decoder.reset();
        if (this.charBuffer.position() > n) {
            this.charBuffer.flip();
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public boolean arrangeCapacity(int var1_1) throws IOException {
        if (!this.calledGetMore) {
            this.getMore();
        }
        if (this.getCharBuffer().limit() - this.getCharBuffer().position() < var1_1) ** GOTO lbl9
        return true;
        while (!this.endOfStream()) {
            this.getMore();
lbl9:
            // 2 sources

            if (this.getCharBuffer().limit() - this.getCharBuffer().position() < var1_1) continue;
        }
        return this.getCharBuffer().limit() - this.getCharBuffer().position() >= var1_1;
    }

    void init(FileInputStream fileInputStream) throws IOException {
        this.charBuffer = CharBuffer.allocate(16384);
        this.fChannel = fileInputStream.getChannel();
        this.remaining = this.filesize = this.fChannel.size();
    }

    CharSequence getCharSequence() {
        return this.charBuffer.subSequence(0, this.charBuffer.remaining());
    }

    void setDecoder(String string) throws IOException {
        if (string != null) {
            this.decoder = Charset.forName(string).newDecoder();
        } else {
            ByteBuffer byteBuffer = ByteBuffer.allocate(4);
            this.fChannel.read(byteBuffer);
            byte[] byArray = new byte[4];
            byteBuffer.get(byArray);
            Object[] objectArray = this.getEncodingName(byArray, 4);
            this.decoder = Charset.forName((String)objectArray[0]).newDecoder();
        }
    }

    public void setEncoding(String string) throws IOException {
    }

    public static void main(String[] stringArray) {
        try {
            FileBufferManager fileBufferManager = new FileBufferManager(new FileInputStream(stringArray[0]), "UTF-8");
            CharBuffer charBuffer = fileBufferManager.getCharBuffer();
            int n = 0;
            while (fileBufferManager.getMore()) {
                System.out.println("Loop " + n++ + " = " + fileBufferManager.getCharBuffer().toString());
                System.out.println("------------Loop CharBuffer details--------");
                FileBufferManager.printCharBuffer(charBuffer);
            }
            System.out.println("End of file reached = " + fileBufferManager.endOfStream());
            System.out.println("Total no. of loops required = " + n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public ByteBuffer getMoreBytes() throws IOException {
        int n = this.getLength();
        if (this.endOfStream) {
            return ByteBuffer.allocate(0);
        }
        ByteBuffer byteBuffer = null;
        if (this.filesize > 81920L) {
            byteBuffer = this.fChannel.map(FileChannel.MapMode.READ_ONLY, this.filepos, n);
            this.filepos += (long)byteBuffer.limit();
        } else {
            byteBuffer = ByteBuffer.allocate(this.getLength());
            this.fChannel.read(byteBuffer);
            this.filepos = this.fChannel.position();
            byteBuffer.flip();
        }
        this.remaining = this.filesize - this.filepos;
        if (this.remaining < 1L) {
            this.endOfStream = true;
        }
        return byteBuffer;
    }

    static void printByteBuffer(ByteBuffer byteBuffer) {
        System.out.println("------------ByteBuffer Details---------");
        System.out.println("bb.position = " + byteBuffer.position());
        System.out.println("bb.remaining() = " + byteBuffer.remaining());
        System.out.println("bb.limit = " + byteBuffer.limit());
        System.out.println("bb.capacity = " + byteBuffer.capacity());
    }

    public CharBuffer getCharBuffer() {
        return this.charBuffer;
    }

    CharBuffer resizeCharBuffer(int n) {
        CharBuffer charBuffer = CharBuffer.allocate(n);
        this.charBuffer = charBuffer.put((CharBuffer)this.charBuffer.flip());
        return this.charBuffer;
    }

    static void printCharBuffer(CharBuffer charBuffer) {
        System.out.println("----------- CharBuffer Details---------");
        System.out.println("bb.position = " + charBuffer.position());
        System.out.println("bb.remaining() = " + charBuffer.remaining());
        System.out.println("bb.limit = " + charBuffer.limit());
        System.out.println("bb.capacity = " + charBuffer.capacity());
    }

    public FileBufferManager(FileInputStream fileInputStream, String string) throws IOException {
        this.init(fileInputStream);
        this.setDecoder("UTF-8");
    }
}

