/*
 * Decompiled with CFR 0.152.
 */
package groovy.util.logging;

import groovy.lang.GroovyClassLoader;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Locale;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.transform.GroovyASTTransformationClass;
import org.codehaus.groovy.transform.LogASTTransformation;

@Documented
@Retention(value=RetentionPolicy.SOURCE)
@Target(value={ElementType.TYPE})
@GroovyASTTransformationClass(value={"org.codehaus.groovy.transform.LogASTTransformation"})
public @interface Log4j2 {
    public String value() default "log";

    public String category() default "##default-category-name##";

    public String visibilityId() default "<DummyUndefinedMarkerString-DoNotUse>";

    public Class<? extends LogASTTransformation.LoggingStrategy> loggingStrategy() default Log4j2LoggingStrategy.class;

    public static class Log4j2LoggingStrategy
    extends LogASTTransformation.AbstractLoggingStrategyV2 {
        protected Log4j2LoggingStrategy(GroovyClassLoader loader) {
            super(loader);
        }

        @Override
        public FieldNode addLoggerFieldToClass(ClassNode classNode, String logFieldName, String categoryName, int fieldModifiers) {
            ClassNode fieldType = this.classNode("org.apache.logging.log4j.Logger");
            MethodCallExpression fieldValue = new MethodCallExpression((Expression)GeneralUtils.classX(this.classNode("org.apache.logging.log4j.LogManager")), "getLogger", (Expression)GeneralUtils.constX(this.getCategoryName(classNode, categoryName)));
            fieldValue.setImplicitThis(false);
            return classNode.addField(logFieldName, fieldModifiers, fieldType, fieldValue);
        }

        @Override
        public boolean isLoggingMethod(String methodName) {
            return methodName.matches("fatal|error|warn|info|debug|trace");
        }

        @Override
        public Expression wrapLoggingMethodCall(Expression logVariable, String methodName, Expression originalExpression) {
            MethodCallExpression condition = new MethodCallExpression(logVariable, "is" + methodName.substring(0, 1).toUpperCase(Locale.ENGLISH) + methodName.substring(1) + "Enabled", (Expression)ArgumentListExpression.EMPTY_ARGUMENTS);
            condition.setImplicitThis(false);
            return GeneralUtils.ternaryX(condition, originalExpression, GeneralUtils.nullX());
        }
    }
}

