/**
 * HttpServerWorker.java
 *
 * (C) Copyright IBM Corp. 2005, 2006
 *
 * THIS FILE IS PROVIDED UNDER THE TERMS OF THE COMMON PUBLIC LICENSE 
 * ("AGREEMENT"). ANY USE, REPRODUCTION OR DISTRIBUTION OF THIS FILE 
 * CONSTITUTES RECIPIENTS ACCEPTANCE OF THE AGREEMENT.
 *
 * You can obtain a current copy of the Common Public License from
 * http://www.opensource.org/licenses/cpl1.0.php
 *
 * @author: Roberto Pineiro, IBM, roberto.pineiro@us.ibm.com  
 * @author: Chung-hao Tan, IBM ,chungtan@us.ibm.com
 * 
 * 
 * Change History
 * Flag       Date        Prog         Description
 *------------------------------------------------------------------------------- 
 * 1498927    2006-06-01  lupusalex    Fill gaps in logging coverage
 * 1535756    2006-08-07  lupusalex    Make code warning free
 */

package org.sblim.wbem.http;

import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.sblim.wbem.util.GlobalProperties;

public class HttpServerWorker implements Runnable {

	HttpConnectionHandler iHandler;

	Socket iSocket;

	public HttpServerWorker(HttpConnectionHandler handler, Socket socket) {
		iHandler = handler;
		iSocket = socket;
	}

	public void run() {
		try {
			iHandler.handleConnection(iSocket);
		} catch (Exception e) {
			Logger logger = GlobalProperties.getLogger();
			if (logger.isLoggable(Level.WARNING)) {
				logger.log(Level.WARNING, "Exception while processing HTTP client connection", e);
			}
		}
	}
}
