/**
 * CIMCreateClassOp.java
 *
 * (C) Copyright IBM Corp. 2005, 2006
 *
 * THIS FILE IS PROVIDED UNDER THE TERMS OF THE COMMON PUBLIC LICENSE 
 * ("AGREEMENT"). ANY USE, REPRODUCTION OR DISTRIBUTION OF THIS FILE 
 * CONSTITUTES RECIPIENTS ACCEPTANCE OF THE AGREEMENT.
 *
 * You can obtain a current copy of the Common Public License from
 * http://www.opensource.org/licenses/cpl1.0.php
 *
 * @author: Roberto Pineiro, IBM, roberto.pineiro@us.ibm.com  
 * @author: Chung-hao Tan, IBM ,chungtan@us.ibm.com
 * 
 * 
 * Change History
 * Flag       Date        Prog         Description
 *------------------------------------------------------------------------------- 
 * 1535756    2006-08-07  lupusalex    Make code warning free
 *
 */

package org.sblim.wbem.client.operations;

import org.sblim.wbem.cim.CIMClass;
import org.sblim.wbem.cim.CIMObjectPath;

public class CIMCreateClassOp extends CIMOperation {

	protected CIMClass iCimClass;

	public CIMCreateClassOp(CIMObjectPath pObjectName, CIMClass pCimClass) {
		iMethodCall = "CreateClass";
		iObjectName = pObjectName;
		iCimClass = pCimClass;
	}

	/**
	 * Returns the CIM class
	 * 
	 * @return The CIM class
	 */
	public CIMClass getCimClass() {
		return iCimClass;
	}
}
