/**
 * CIMListener.java
 *
 * (C) Copyright IBM Corp. 2005
 *
 * THIS FILE IS PROVIDED UNDER THE TERMS OF THE COMMON PUBLIC LICENSE 
 * ("AGREEMENT"). ANY USE, REPRODUCTION OR DISTRIBUTION OF THIS FILE 
 * CONSTITUTES RECIPIENTS ACCEPTANCE OF THE AGREEMENT.
 *
 * You can obtain a current copy of the Common Public License from
 * http://www.opensource.org/licenses/cpl1.0.php
 *
 * @author: Roberto Pineiro, IBM, roberto.pineiro@us.ibm.com  
 * @author: Chung-hao Tan, IBM ,chungtan@us.ibm.com
 * 
 * 
 * Change History
 * Flag       Date        Prog         Description
 *------------------------------------------------------------------------------- 
 * 1535756    2006-08-07  lupusalex    Make code warning free
 *
 */
package org.sblim.wbem.client.indications;

import java.util.EventListener;

/**
 * Defines the interface to be implemented by CIM Event consumers.
 * 
 * It's important to note that implementors of this interface also overrides the
 * hashCode() method to provides an exclusive ID (if that is the case) to
 * diferentiate themself from other CIMListeners.
 * 
 */
public interface CIMListener extends EventListener {

	public void indicationOccured(CIMEvent pEvent);
}
