/*
 * Copyright (C) 1999 by   XCIN TEAM
 * Copyright (C) 2004 by   Leon Ho <llch@redhat.com>
 *                         Lawrence Lim <llim@redhat.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "xcin.h"


/*
 * define if_methods_t
 */
if_methods_t xcin_method =
{
    if_xcin_OpenIF,
    if_xcin_CloseIF,
    if_xcin_GetIFValue,
    if_xcin_SetIFValue,
    if_xcin_OpenDesktop,
    if_xcin_CloseDesktop,
    if_xcin_CreateSC,
    if_xcin_DestroySC,
    if_xcin_GetSCValue,
    if_xcin_SetSCValue,
    if_xcin_ResetSC,
    if_xcin_SetSCFocus,
    if_xcin_UnsetSCFocus,
    if_xcin_SendEvent
};

extern char lename_string[];
extern UTFCHAR lename_utf_string[];
extern IMLocale locales[];
//extern IMEntry imentries[];

extern void load_syscin(const char *);
extern int gen_inp_xim_init( gen_inp_conf_t*, gen_inp_iccf_t*, inpinfo_t* );
extern int gen_inp_xim_end( gen_inp_conf_t*, inpinfo_t *);
//extern void ccode_info( ccode_info_t* info );
extern int loadtab( gen_inp_conf_t* cf, FILE* fp, char* encoding );

static IMLEName lename = {lename_string, lename_utf_string };

static IMObjectDescriptorStruct* objects = NULL;


/*
 * This method is invoked when htt_server retrieves if_method_t method table.
 */
void if_GetIfInfo(IMArgList args, int num_args)
{
    int i;

    init_objects();
    
    for(i = 0; i < num_args; i++, args++)
    {
        switch(args->id)
        {
            case IF_VERSION:
                args->value = (IMArgVal) "0.1";
                break;
            case IF_METHOD_TABLE:
                args->value = (IMArgVal) & xcin_method;
                break;
            case IF_LE_NAME:
                args->value = (IMArgVal) & lename;
                break;
            case IF_SUPPORTED_LOCALES:
			    args->value = (IMArgVal) & locales;
                break;
            case IF_SUPPORTED_OBJECTS:
                args->value = (IMArgVal) objects;
                break;
            case IF_NEED_THREAD_LOCK:
                args->value = (IMArgVal) False;
                break;
            default:
                break;
        }
    }
}

/*
 * This method is invoked when the Language Engine is started to use by htt_server
 */
Bool if_xcin_OpenIF( iml_if_t* If )
{
#ifdef  DEBUG
    printf("if_xcin_OpenIF()\n");
    printf("    If=[%x]\n", If);
    printf("    locale=[%s]\n", If->locale);
    printf("    if_name=[%s]\n", If->if_name);
#endif
    
    init_objects();
    return True;
}

/*
 * This method is invoked when htt_server stops to use the Language Engine, 
 * which means there is no client using the Language Engine.
 */
Bool if_xcin_CloseIF( iml_if_t* If )
{
#ifdef  DEBUG
    printf("if_xcin_CloseIF()\n");
    printf("    If=[%x]\n", If);
    printf("    locale=[%s]\n", If->locale);
    printf("    if_name=[%s]\n", If->if_name);
#endif

    free_objects();
    return True;
}

/*
 * This method is invoked when the Language Engine wants to set IF attributes of IM Client.
 */
Bool if_xcin_GetIFValue( iml_if_t* If, IMArgList args, int num_args )
{
#ifdef DEBUG
   printf("*** if_xcin_GetIFValue() ***\n");
   printf("    If=[%x]\n", If);
   printf("    locale=[%s]\n", If->locale);
   printf("    if_name=[%s]\n", If->if_name); 
#endif
    return True;
}

/* 
 * This method is invoked when the IM client wants to set IF attributes.
 */
Bool if_xcin_SetIFValue( iml_if_t* If, IMArgList args, int num_args )
{
#ifdef DEBUG
    printf("*** if_xcin_SetIFValue() ***\n");
    printf("    If=[%x]\n", If);
    printf("    locale=[%s]\n", If->locale);
    printf("    if_name=[%s]\n", If->if_name);
#endif	

    return True;
}

/*
 * This method is invoked during the first connection when the user start to use the desktop
 */
Bool if_xcin_OpenDesktop( iml_desktop_t* desktop, IMArgList args, int num_args )
{
    MyDataPerDesktop *desktop_data = (MyDataPerDesktop *) calloc(1, sizeof(MyDataPerDesktop));
    int i;

#ifdef  DEBUG
    printf("if_xcin_OpenDesktop()\n");
    printf("    If=[%x]\n", desktop->If);
    printf("    desktop=[%x]\n", desktop);
    printf("    locale=[%s]\n", desktop->If->locale);
    printf("    if_name=[%s]\n", desktop->If->if_name);

    printf("    USER:%s\n", desktop->user_name);
    printf("    HOST:%s\n", desktop->host_name);
    printf("    DISPLAY:%s\n", desktop->display_id);

    for (i = 0; i < num_args; i++, args++) 
    {
        switch (args->id) 
        {
            case UI_USER_NAME:
                if (args->value) 
                {
                    printf("    UI_USER_NAME=%s\n", args->value);
                }
                break;
            case UI_HOST_NAME:
                if (args->value) 
                {
                    printf("    UI_HOST_NAME=%s\n", args->value);
                }
                break;
            case UI_DISPLAY_ID:
                if (args->value) 
                {
                    printf("    UI_DISPLAY_ID=%s\n", args->value);
                }
                break;
            case UI_PROTOCOL_TYPE:
                if (args->value) 
                {
                    printf("    UI_PROTOCOL_TYPE=%s\n", args->value);
                }
                break;
            case UI_CLIENT_TYPE:
                if (args->value) 
                {
                    printf("    UI_CLIENT_TYPE=%s\n", args->value);
                }
                break;
            case UI_XSERVER_VENDOR:
                if (args->value) 
                {
                    printf("    UI_XSERVER_VENDOR=%s\n", args->value);
                }
                break;
            case UI_OS_NAME:
                if (args->value) 
                {
                    printf("    UI_OS_NAME=%s\n", args->value);
                }
                break;
            case UI_OS_ARCH:
                if (args->value) 
                {
                    printf("    UI_OS_ARCH=%s\n", args->value);
                }
                break;
            case UI_OS_VERSION:
                if (args->value) 
                {
                    printf("    UI_OS_VERSION=%s\n", args->value);
                }
                break;
            case UI_AUTH_PASSWD:
                if (args->value) 
                {
                    printf("    UI_AUTH_PASSWD=%s\n", args->value);
                }
                break;
            }
    }
#endif

    for ( i = 0; i < MAX_AUX; i++ ) 
    {
        desktop_data->aux_start[i] = False;
    }
    desktop_data->auxproxy_session = 0;
    desktop->specific_data = (void *) desktop_data;
    return True;
}


/*
 * This method is invoked when the user exit from the desktop, which means there is no IM client for the server.
 * An axample is the shutdown of 'httx'
 */
Bool if_xcin_CloseDesktop( iml_desktop_t* desktop )
{
    MyDataPerDesktop *desktop_data = (MyDataPerDesktop *) desktop->specific_data;

#ifdef DEBUG
    printf("*** if_xcin_CloseDesktop()***\n");
    printf("    If=[%x]\n", desktop->If);
    printf("    desktop=[%x]\n", desktop);
    printf("    locale=[%s]\n", desktop->If->locale);
    printf("    if_name=[%s]\n", desktop->If->if_name);

    printf("    USER: %s\n", desktop->user_name);
    printf("    HOST: %s\n", desktop->host_name);
    printf("    DISPLAY: %s\n", desktop->display_id);
#endif

    free(desktop_data);
    return True;
}

/*
 * This method is invoked when a session is created
 */
Bool if_xcin_CreateSC( iml_session_t* s, IMArgList args, int num_args )
{
    int i;

    FILE* fp;
    char filename[256]; 

    MyDataPerSession *p = (MyDataPerSession *) calloc(1, sizeof(MyDataPerSession));
    p->status_start = False;
    p->luc_start = False;
    p->luc_commit = False;
    p->preedit_start = False;
    p->preedit_buf = (UTFCHAR *) calloc(1, sizeof(UTFCHAR) * BUFSIZE);
    p->commit_buf = (UTFCHAR *) calloc(1, sizeof(UTFCHAR) * BUFSIZE);

    p->conversion_string = (UTFCHAR *) calloc(1, sizeof(UTFCHAR) * BUFSIZE);
    p->on_string = (UTFCHAR *) calloc(1, sizeof(UTFCHAR) * BUFSIZE);
    p->preedit_string = (UTFCHAR *) calloc(1, sizeof(UTFCHAR) * BUFSIZE);
    p->luc_candidates = NULL;
    p->luc_labels = NULL;
    p->luc_nchoices = 9;
    p->caret_pos = -1;
    p->max_candidates = MAXCANDIDATES - 1;
    p->luc_current_candidate = 0;

    p->preedit_feedback = create_feedback(0, BUFSIZE);
    p->luc_fbs_reverse = create_feedback(0, BUFSIZE);
    p->luc_fbs_normal = create_feedback(0, BUFSIZE);

    /* initialize xml conf structures */
    p->inputstyles = calloc(1, sizeof(langim));
    p->inputstyles->first = NULL;
    p->inputstyles->last = NULL;

    /* parse the xml conf */
    parseConf(p->inputstyles);

/* START XCIN */
    p->cf = calloc(1, sizeof(gen_inp_conf_t));
    p->iccf = calloc(1, sizeof(gen_inp_iccf_t));
    p->inpinfo = calloc(1, sizeof(inpinfo_t));

    p->cf->mode = 66694;                /* HARDCODED    TODO: fix in v0.2 */
    p->imnode = fetchIMpos(p->inputstyles, p->cur_im); 
    p->cf->inp_ename = p->imnode->id; 
    p->tabenc = strdup(TAB_ENC);
    
    if(p->imnode->file)
        sprintf(filename, "%s.tab", p->imnode->file);
    else
        sprintf(filename, "%s/%s.tab", p->inputstyles->path, p->imnode->id);

    if ( (fp = fopen( filename, "r" )) == NULL ) 
        printf("*** XCIN: File could not be opened.\n");
    else
    {
        load_syscin(p->inputstyles->path);
        gen_inp_xim_init( p->cf, p->iccf, p->inpinfo );
        ccode_info( &(p->cf->ccinfo) );
        loadtab( p->cf, fp, p->tabenc ); 
    }

/* END XCIN */
    fclose(fp);

    /* Start Input Method on first one; */
    p->cur_im = 0;
    //p->on_string = imentries[p->cur_im].name;
    {
        char *name;
        if(p->inputstyles->first->name)
            name = p->inputstyles->first->name;
        else
            name = p->cf->inp_cname;

        utf8_to_utf16(name, (char *)p->on_string, strlen(name)); 
        debug("FILE: %s, LINE: %d, preconvert on_string name: %s", __FILE__, __LINE__, name);
    }

    
    /* NOTE: If encounter any preedit problem, have a look here */
    for (i = 0; i < BUFSIZE; i++) {
        set_feedback(&p->preedit_feedback[i], IMUnderline);
        set_feedback(&p->luc_fbs_reverse[i], IMReverse);
        set_feedback(&p->luc_fbs_normal[i], IMNormal);
    }

#ifdef  DEBUG
    iml_desktop_t *desktop = s->desktop;

    printf("if_xcin_CreateSC()\n");
    printf("    If=[%x]\n", desktop->If);
    printf("    desktop=[%x]\n", desktop);
    printf("    locale=[%s]\n", desktop->If->locale);
    printf("    if_name=[%s]\n", desktop->If->if_name);

    printf("    BASIC INFO - USER:%s\n", desktop->user_name);
    printf("    BASIC INFO - HOST:%s\n", desktop->host_name);
    printf("    BASIC INFO - DISPLAY:%s\n", desktop->display_id);

    for (i = 0; i < num_args; i++, args++) 
    {
        switch (args->id) 
        {
            case UI_USER_NAME:
                if (args->value) 
                {
                    printf("    UI_USER_NAME=%s\n", args->value);
                }
                break;
            case UI_HOST_NAME:
                if (args->value) 
                {
                    printf("    UI_HOST_NAME=%s\n", args->value);
                }
                break;
            case UI_DISPLAY_ID:
                if (args->value) 
                {
                    printf("    UI_DISPLAY_ID=%s\n", args->value);
                }
                break;
            case UI_PROTOCOL_TYPE:
                if (args->value) 
                {
                    printf("    UI_PROTOCOL_TYPE=%s\n", args->value);
                }
                break;
            case UI_XSERVER_VENDOR:
                if (args->value) 
                {
                    printf("    UI_XSERVER_VENDOR=%s\n", args->value);
                }
                break;
            case UI_CLIENT_TYPE:
                if (args->value) 
                {
                    printf("    UI_CLIENT_TYPE=%s\n", args->value);
                }
                break;
            case UI_OS_NAME:
                if (args->value) 
                {
                    printf("    UI_OS_NAME=%s\n", args->value);
                }
                break;
            case UI_OS_ARCH:
                if (args->value) 
                {
                    printf("    UI_OS_ARCH=%s\n", args->value);
                }
                break;
            case UI_OS_VERSION:
                if (args->value) 
                {
                    printf("    UI_OS_VERSION=%s\n", args->value);
                }
            case UI_AUTH_PASSWD:
                if (args->value) 
                {
                    printf("    UI_AUTH_PASSWD=%s\n", args->value);
                }
                break;
            }
    }
#endif

    s->specific_data = (void *) p;
    return True;
}

/*
 * This method is invoked when the session is destroyed
 * An example is the shudown of an application ie. gedit
 */
Bool if_xcin_DestroySC( iml_session_t* s )
{ 
    MyDataPerSession *p = (MyDataPerSession *) s->specific_data;
    MyDataPerDesktop *desktop_data = (MyDataPerDesktop *) s->desktop->specific_data;

    if ( s == desktop_data->auxproxy_session)
    {
        desktop_data->auxproxy_session = NULL;
    }

    /* clean up cf and inpinfo from gen_inp */
    gen_inp_xim_end( p->cf, p->inpinfo );
    
    if (p->preedit_buf)
        free((char *) p->preedit_buf);
    if (p->commit_buf)
        free((char *) p->commit_buf);
    if (p->conversion_string)
        free((char *) p->conversion_string);
    if (p->on_string)
        free((char *) p->on_string);
    if (p->preedit_string)
        free((char *) p->preedit_string);
    if (p->preedit_feedback)
        free((char *) p->preedit_feedback);

    if (p->luc_fbs_reverse)
        free((char *) p->luc_fbs_reverse);
    if (p->luc_fbs_normal)
        free((char *) p->luc_fbs_normal);

    freeConf(p->inputstyles);
    
    free((char *) p); 

#ifdef DEBUG
    printf("*** if_xcin_DestroySC(s=%x)\n", s);
    printf("    s=[%x]\n", s);
    printf("    If=[%x]\n", s->desktop->If);
    printf("    desktop=[%x]\n", s->desktop);
    printf("    locale=[%s]\n", s->desktop->If->locale);
    printf("    if_name=[%s]\n", s->desktop->If->if_name);

    printf("    USER:%s\n", s->desktop->user_name);
    printf("    HOST:%s\n", s->desktop->host_name);
    printf("    DISPLAY:%s\n", s->desktop->display_id);
#endif

    return True;
}

/*
 * This method is invoked when the Language Engine wants to set SC attributes of IM client
 */
Bool if_xcin_GetSCValue( iml_session_t* s, IMArgList args, int num_args )
{
	return True;
}

/*
 * This method is invoked when the IM client wants to set SC attributes.
 */
Bool if_xcin_SetSCValue( iml_session_t* s, IMArgList args, int num_args )
{
    int i;
    IMArg *p = args;
    MyDataPerDesktop *desktop_data = (MyDataPerDesktop *) s->desktop->specific_data;
    /*MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;*/
                                                                                                
#ifdef  DEBUG
    printf("*** if_xcin_SetSCValue() ***\n");
    printf("    s=[%x]\n", s);
    printf("    If=[%x]\n", s->desktop->If);
    printf("    desktop=[%x]\n", s->desktop);
    printf("    locale=[%s]\n", s->desktop->If->locale);
    printf("    if_name=[%s]\n", s->desktop->If->if_name);
    printf("    USER:%s\n", s->desktop->user_name);
    printf("    HOST:%s\n", s->desktop->host_name);
#endif
                                                                                                                             
    for (i = 0; i < num_args; i++, p++)
    {
        switch (p->id)
        {
            case SC_TRIGGER_ON_NOTIFY:
                conversion_on(s);
                break;
            case SC_TRIGGER_OFF_NOTIFY:
                conversion_off(s);
                break;
            case SC_REALIZE:
                if (!desktop_data->auxproxy_session)
                {
                    desktop_data->auxproxy_session = s;
                    if (getenv("DONOTSTART_AUX_AT_SC_REALIZE") == NULL)
                    {
/*                        aux_start(desktop_data->auxproxy_session, SAMPLE_AUX_PANEL); */
                    }
                }
                break;
            case SC_LOOKUP_LABELTYPE:
                break;
            default:
                break;
        }
    }
                                                                                                                             
    return True;
}

/*
 * This method is invoked when the IM client wants to reset the Input Context.
 */
IMText* if_xcin_ResetSC( iml_session_t* s )
{
    int i;
    iml_inst *lp;
    IMText* p = make_preedit_imtext(s);
    MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
                                                                                                                             
#ifdef DEBUG
    printf("*** if_xcin_ResetSC(s=%x) ***\n", s);
    printf("    s=[%x]\n", s);
    printf("    If=[%x]\n", s->desktop->If);
    printf("    desktop=[%x]\n", s->desktop);
    printf("    locale=[%s]\n", s->desktop->If->locale);
    printf("    if_name=[%s]\n", s->desktop->If->if_name);
    printf("    USER:%s\n", s->desktop->user_name);
    printf("    HOST:%s\n", s->desktop->host_name);
    printf("    DISPLAY:%s\n", s->desktop->display_id);
#endif
                                                                                                                             
    /*
     * When you return IMText for commit string, you will need to call iml_make_preedit_erase_inst() here
     */
    lp = s->If->m->iml_make_preedit_erase_inst(s);
    s->If->m->iml_execute(s, &lp);
                                                                                                                             
    /*
     * reset buffer
     */
    for (i = 0; i < BUFSIZE; i++)
    {
        set_feedback(&session_data->preedit_feedback[i], IMUnderline);
    }
    memset(session_data->preedit_buf, 0, sizeof(UTFCHAR) * BUFSIZE);
    memset(session_data->commit_buf, 0, sizeof(UTFCHAR) * BUFSIZE);
    memset(session_data->preedit_string, 0, sizeof(UTFCHAR) * BUFSIZE);
    memset(session_data->conversion_string, 0, sizeof(UTFCHAR) * BUFSIZE);
    session_data->caret_pos = -1;
                                                                                                                             
    /*
     * return committed string
     */
    if ( p -> char_length )
    {
        return p;
    }
                                                                                                                             
    return (IMText *) NULL;
}

/*
 * This method is invoked when the IM client gets the input focus.
 */
void if_xcin_SetSCFocus( iml_session_t* s )
{
                                                                                                                             
#ifdef  DEBUG
    printf("*** if_xcin_SetSCFocus() ***\n");
    printf("    s=[%x]\n", s);
    printf("    If=[%x]\n", s->desktop->If);
    printf("    desktop=[%x]\n", s->desktop);
    printf("    locale=[%s]\n", s->desktop->If->locale);
    printf("    if_name=[%s]\n", s->desktop->If->if_name);
    printf("    USER:%s\n", s->desktop->user_name);
    printf("    HOST:%s\n", s->desktop->host_name);
    printf("    DISPLAY:%s\n", s->desktop->display_id);
#endif
                                                                                                                             
    status_draw(s);
}
                                                                                                                             
/*
 * This method is invoked when the IM client loses the input focus
 */
void if_xcin_UnsetSCFocus( iml_session_t* s )
{
#ifdef DEBUG
    printf("*** if_xcin_UnsetSCFocus()\n");
    printf("    s=[%x]\n", s);
    printf("    If=[%x]\n", s->desktop->If);
    printf("    desktop=[%x]\n", s->desktop);
    printf("    locale=[%s]\n", s->desktop->If->locale);
    printf("    if_name=[%s]\n", s->desktop->If->if_name);
    printf("    USER:%s\n", s->desktop->user_name);
    printf("    HOST:%s\n", s->desktop->host_name);
    printf("    DISPLAY:%s\n", s->desktop->display_id);
#endif
}

/*
 * This method is invoked when any event occurs on the IM client.
 */
void if_xcin_SendEvent( iml_session_t* s, IMInputEvent* ev )
{
#ifdef  DEBUG
    printf("*** if_xcin_SendEvent( ) ***\n");
    printf("    if_xcin_SendEvent s=%x ev=%x\n", s, ev);
#endif
    if (ev)
    {
        if (ev->type == IM_EventKeyList)
        {
            if (receive_keylist(s, (IMKeyListEvent *) ev) == False)
            {
                IMKeyListEvent *keylist = (IMKeyListEvent *) ev;
                iml_inst *lp = s->If->m->iml_make_keypress_inst(s, (IMKeyEventStruct *) keylist->keylist);
                s->If->m->iml_execute(s, &lp);
            }
        }
    
    }

}


/*
 * Initialise IM Object
 */ 
void init_objects()
{
    IMObjectDescriptorStruct *l;
    char xaux_so_path[125];
    
    objects = ( IMObjectDescriptorStruct * ) calloc ( 2, sizeof( IMObjectDescriptorStruct ) );  
    l = objects;

    sprintf(xaux_so_path, "./locale/%s/aux.so", LOCALE_NAME);
    
    l->leid = lename_string;		            /* engine id */
    l->type = IM_DOWNLOADINGOBJECT_BINGUI_TYPE; /* IMObjectType */
    l->name = lename_utf_string;	        /* HRN (Human Readable Name) */
    l->name_length = UTFCHARLen(lename_utf_string);
    l->domain = "com.redhat";
    l->scope = lename_string;
    l->path = (char *)(strdup(xaux_so_path));    /* path for .so starts from /usr/lib/im/ */
}

/*
 * Free IM Objects from memory
 */ 
void free_objects()
{
    IMObjectDescriptorStruct *l = objects;

    while ( l-> leid )
    {
        free( l->name );
	    l++;
    };
    free( objects );
    objects = NULL;
}


