/*
Copyright 1990-2006 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#include <stdlib.h>
#include <stdio.h>
#include <strings.h>

#include <gtk/gtk.h>
#include <gconf/gconf-client.h>
#include <glade/glade.h>

#include "kbltrans.h"
#include "support.h"
#include "iiim-properties.h"

struct KeyboardSetting {
  gint layout_id;
  gboolean autodetect;
};
static struct KeyboardSetting keyboard_setting;

void keyboard_initialize (GtkWidget *dialog, IIIMProps *iiim_props)
{
  GtkWidget *list = lookup_widget (dialog, "keyboardLayoutList");
  GtkTreeView *view = GTK_TREE_VIEW(list);
  GtkTreePath *path;
  int cur = 0;
  GtkTreeModel *model = gtk_tree_view_get_model (view);
  GtkTreeIter iter;
  gboolean valid;
  gchar *current_layout = kbltrans_id_to_text (iiim_props->i_kbd_layout);

  /* TODO: need to translate current_layout to native text here */

  valid = gtk_tree_model_get_iter_first (model, &iter);
  while (valid) {
    gchar *layout;
    gtk_tree_model_get (model, &iter, 0, &layout, -1);
    if (!strcmp (layout, current_layout)) {
      g_free (layout);
      break;
    }
    g_free (layout);
    valid = gtk_tree_model_iter_next (model, &iter);
  }

  path = gtk_tree_model_get_path (model, &iter);
  gtk_tree_view_set_cursor (view, path, NULL, FALSE);
  gtk_tree_view_scroll_to_cell (view, path, NULL, FALSE, 0, 0);

  keyboard_setting.layout_id = iiim_props->i_kbd_layout;
  keyboard_setting.autodetect = iiim_props->b_kbd_check;
}

void keyboard_update_properties (IIIMProps *iiim_props)
{
  iiim_props->i_kbd_layout = keyboard_setting.layout_id;
  iiim_props->b_kbd_check = keyboard_setting.autodetect;
}

void keyboard_autodetect_toggled (GtkToggleButton *togglebutton, gpointer user_data)
{
  GtkWidget *layoutList;

  keyboard_setting.autodetect = gtk_toggle_button_get_active (togglebutton);

  layoutList = lookup_widget (GTK_WIDGET (togglebutton), "keyboardLayoutList");
  
  if (keyboard_setting.autodetect) {
    gtk_widget_set_sensitive (layoutList, FALSE);
  } else {
    gtk_widget_set_sensitive (layoutList, TRUE);
  }
}

void keyboard_layout_changed (GtkTreeView *treeview, gpointer user_data)
{
  GtkTreeIter iter;
  GtkTreeModel *model;
  GtkTreePath *path;
  gchar *name;
  gint layout_id;

  model = gtk_tree_view_get_model (treeview);
  gtk_tree_view_get_cursor (treeview, &path, NULL);
  gtk_tree_model_get_iter (model, &iter, path);
  gtk_tree_model_get (model, &iter, 0, &name, -1);

  layout_id = kbltrans_text_to_id (name);

  g_free (name);
  keyboard_setting.layout_id = layout_id;
}
