
/*
Copyright 1990-2006 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#include <stdlib.h>
#include <stdio.h>
#include <strings.h>

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <gconf/gconf-client.h>
#include <glade/glade.h>
#include <glib/gprintf.h>

#include "support.h"
#include "iiimcf.h"
#include "iiim-properties.h"
#include "iiim-properties-trigger.h"

static PangoLayout *layout;
static GtkTreeView *targetList;

GtkWidget *create_hotkeyConfDialog ();
gchar * hkc_popup_dialog (GtkWidget *widget)
{
  gchar *message = NULL;
  targetList = GTK_TREE_VIEW (widget);
  GtkWidget *canvas;
  GtkWidget *dialog = create_hotkeyConfDialog ();
  gtk_window_set_transient_for (GTK_WINDOW (dialog),
				GTK_WINDOW (lookup_widget (widget, "iiimDialog")));

  message = g_strdup_printf("<span foreground=\"black\" weight=\"bold\"> %s </span>", _("Please type keys here!"));
  canvas = lookup_widget (dialog, "hkc_canvas");
  layout = gtk_widget_create_pango_layout (canvas, NULL);
  pango_layout_set_markup (layout, message, -1);
  gtk_widget_show (dialog);
  g_free (message);
}

/* modifier state holder */
static int mod_state;
/* modifier names */
static char *shift_l;
static char *shift_r;
static char *control_l;
static char *control_r;
static char *alt_l;
static char *alt_r;
static char *meta_l;
static char *meta_r;

void hkc_initialize ()
{
  shift_l = gdk_keyval_name (GDK_Shift_L);
  shift_r = gdk_keyval_name (GDK_Shift_R);
  control_l = gdk_keyval_name (GDK_Control_L);
  control_r = gdk_keyval_name (GDK_Control_R);
  alt_l = gdk_keyval_name (GDK_Alt_L);
  alt_r = gdk_keyval_name (GDK_Alt_R);
  meta_l = gdk_keyval_name (GDK_Meta_L);
  meta_r = gdk_keyval_name (GDK_Meta_R);
}

void hkc_focus_in (GtkWidget *widget)
{
}

void hkc_focus_out (GtkWidget *widget)
{
}


/* These values should be calculated with text and area size */
#define X_OFFSET 20
#define Y_OFFSET 20

void hkc_expose (GtkWidget *widget, GdkEventExpose *event)
{
  gtk_paint_layout (widget->style,
		    widget->window,
		    GTK_STATE_ACTIVE, 
		    TRUE,
		    &event->area,
		    widget,
		    "typing area",
		    X_OFFSET, Y_OFFSET,
		    layout);
}

static int get_modifier_state (unsigned keyval) {
  int state = IIIMCF_NO_MODIFIER_STATE;

  switch(keyval) {
  case GDK_Shift_L:
    state = IIIMCF_SHIFT_L_STATE;
    break;
  case GDK_Shift_R:
    state = IIIMCF_SHIFT_R_STATE;
    break;
  case GDK_Control_L:
    state = IIIMCF_CONTROL_L_STATE;
    break;
  case GDK_Control_R:
    state = IIIMCF_CONTROL_R_STATE;
    break;
  case GDK_Alt_L:
    state = IIIMCF_ALT_L_STATE;
    break;
  case GDK_Alt_R:
    state = IIIMCF_ALT_R_STATE;
    break;
  case GDK_Meta_L:
    state = IIIMCF_META_L_STATE;
    break;
  case GDK_Meta_R:
    state = IIIMCF_META_R_STATE;
    break;
  }

  return state;
}

void hkc_key_released (GtkWidget *widget, GdkEventKey *keyevent)
{
  int state = get_modifier_state (keyevent->keyval);
  mod_state &= ~state;
}

static gchar *append (char *a, char *b)
{
  gchar *ret;
  if (a == NULL)
    {
      ret = g_strdup (b);
    }
  else
    {
      ret = g_strconcat (a, "+", b, NULL);
      g_free (a);
    }
  return ret;
}

void hkc_key_pressed (GtkWidget *widget, GdkEventKey *keyevent)
{
  GtkWidget *entry = lookup_widget (widget, "entry1");
  unsigned keyval = gdk_keyval_to_lower (keyevent->keyval);
  char *keyname = "";
  char *key_string = NULL;
  int state = get_modifier_state (keyevent->keyval);

  if (state != IIIMCF_NO_MODIFIER_STATE) {
    mod_state |= state;
  } else {
    keyname = gdk_keyval_name (keyval);
  }

  if (mod_state & IIIMCF_SHIFT_L_STATE)
    key_string = append (key_string, shift_l);
  if (mod_state & IIIMCF_SHIFT_R_STATE)
    key_string = append (key_string, shift_r);
  if (mod_state & IIIMCF_CONTROL_L_STATE)
    key_string = append (key_string, control_l);
  if (mod_state & IIIMCF_CONTROL_R_STATE)
    key_string = append (key_string, control_r);
  if (mod_state & IIIMCF_ALT_L_STATE)
    key_string = append (key_string, alt_l);
  if (mod_state & IIIMCF_ALT_R_STATE)
    key_string = append (key_string, alt_r);
  if (mod_state & IIIMCF_META_L_STATE)
    key_string = append (key_string, meta_l);
  if (mod_state & IIIMCF_META_R_STATE)
    key_string = append (key_string, meta_r);
  if (strlen (keyname) > 0)
    key_string = append (key_string, keyname);

  gtk_entry_set_text (GTK_ENTRY (entry), key_string);
  g_free (key_string);
}

void hkc_help (GtkButton *button)
{
  GError *error = NULL;
  gnome_help_display ("iiim-properties.xml", "page-trigger", &error);

  if (error != NULL)
    {
      g_warning (error->message);
      g_error_free (error);
    }
}

void hkc_close (GtkButton *button)
{
  GtkWidget *dialog = lookup_widget (GTK_WIDGET (button), "hotkeyConfDialog");
  gtk_widget_destroy (dialog);
}

static gint p_strcmp (gconstpointer a, gconstpointer b)
{
  return strcmp (a, b);
}

void util_message (GtkWidget *, gchar *);
IIIMProps *util_get_iiimprops();
void trigger_update_properties (IIIMProps *);
void misc_update_properties (IIIMProps *);
static gboolean is_registered_hotkey (const gchar *key, gchar **hotkey_kind)
{
  IIIMProps *props = util_get_iiimprops ();
  trigger_update_properties (props);
  misc_update_properties (props);

  /* check trigger keys */
  if (props->l_trigger_keys != NULL &&
      g_slist_find_custom (props->l_trigger_keys->hotkeys, key, p_strcmp))
    {
      *hotkey_kind = g_strdup (_("Trigger key"));
      return TRUE;
    }
  /* check lang list keys */
  if (props->l_lang_list_hotkey != NULL &&
      g_slist_find_custom (props->l_lang_list_hotkey->hotkeys, key, p_strcmp))
    {
      *hotkey_kind = g_strdup (_("Language/Script choice window hotkey"));
      return TRUE;
    }
  /* check cycle keys */
  if (props->l_cycle_lang_hotkey != NULL &&
      g_slist_find_custom (props->l_cycle_lang_hotkey->hotkeys, key, p_strcmp))
    {
      *hotkey_kind = g_strdup (_("Cycle Language/Script hotkey"));
      return TRUE;
    }
  /* check reverse cycle keys */
  if (props->l_reverse_cycle_lang_hotkey != NULL &&
      g_slist_find_custom (props->l_reverse_cycle_lang_hotkey->hotkeys, key, p_strcmp))
    {
      *hotkey_kind = g_strdup (_("Reversed Cycle Language/Script hotkey"));
      return TRUE;
    }
  
  return FALSE;
}

void hkc_add (GtkButton *button)
{
  GtkWidget *canvas = lookup_widget (GTK_WIDGET (button), "hkc_canvas");
  GtkWidget *entry = lookup_widget (GTK_WIDGET (button), "entry1");
  GtkWidget *dialog = lookup_widget (GTK_WIDGET (targetList), "iiimDialog");
  const gchar *key = gtk_entry_get_text (GTK_ENTRY (entry));
  GtkTreeModel *model = gtk_tree_view_get_model (targetList);
  gchar key_string[MAX_HOTKEY_STRING_SIZE];
  GtkTreeIter iter, iter2;
  gboolean valid;
  gchar *hotkey_kind;

  gtk_widget_grab_focus (canvas);

  if (!*key)
    {
      gchar *message = _("Key is not typed yet.");
      util_message (dialog, message);

      return;
    }

  /* avoid duplicate hotkeys for different purposes */
  if (is_registered_hotkey (key, &hotkey_kind))
    {
      gchar *message = _("This key already specified as \"%s\".");
      gchar *buf = g_new0(gchar, strlen (message) + strlen (hotkey_kind));
      g_sprintf (buf, message, hotkey_kind);
      util_message (dialog, buf);
      
      g_free (hotkey_kind);
      g_free (buf);

      return;
    }

  /* get rid of zero length entry from list. This can be happned as
   * if user removed all of trigger keys.
   */
  valid = gtk_tree_model_get_iter_first (model, &iter2);
  while (valid) {
    gchar *trigger;
    gtk_tree_model_get (model, &iter2, 0, &trigger, -1);
    if (strlen (trigger) == 0) {
      gtk_list_store_remove (GTK_LIST_STORE (model), &iter2);
      break;
    }
    valid = gtk_tree_model_iter_next (model, &iter2);
  }

  gtk_list_store_append (GTK_LIST_STORE (model), &iter);
  gtk_list_store_set  (GTK_LIST_STORE (model), &iter, 0, key, -1);

  hkc_close (button);
}


