/*
Copyright 1990-2006 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#include <stdlib.h>
#include <stdio.h>
#include <strings.h>

#include <gtk/gtk.h>
#include <gconf/gconf-client.h>
#include <glade/glade.h>

#include "support.h"
#include "iiim-properties.h"

struct GeneralSetting {
  gboolean im_enabled;
  gboolean switcher_autostart;
  gboolean status_enabled;
  StatusPlacement status_placement;
  gboolean sync_activation;
  LangSwitchPolicy lang_switch_policy;
  OnOffPolicy on_off_policy;
  gboolean remember_last_le;
};
static struct GeneralSetting general_setting;

void general_initialize (IIIMProps *iiim_props)
{
  general_setting.im_enabled = iiim_props->b_im_enabled;
  general_setting.switcher_autostart = iiim_props->b_switcher_autostart;
  general_setting.status_enabled = iiim_props->b_status_enabled;
  general_setting.status_placement = iiim_props->e_status_placement;
  general_setting.sync_activation = iiim_props->b_sync_activation;
  general_setting.lang_switch_policy = iiim_props->e_lang_switch_policy;
  general_setting.on_off_policy = iiim_props->e_on_off_policy;
  general_setting.remember_last_le = iiim_props->b_remember_last_le;
}

void general_update_properties (IIIMProps *iiim_props)
{
  iiim_props->b_im_enabled = general_setting.im_enabled;
  iiim_props->b_switcher_autostart = general_setting.switcher_autostart;
  iiim_props->b_status_enabled = general_setting.status_enabled;
  iiim_props->e_status_placement = general_setting.status_placement;
  iiim_props->b_sync_activation = general_setting.sync_activation;
  iiim_props->e_lang_switch_policy = general_setting.lang_switch_policy;
  iiim_props->e_on_off_policy = general_setting.on_off_policy;
  iiim_props->b_remember_last_le = general_setting.remember_last_le;
}

void general_enable_im_toggled (GtkToggleButton *togglebutton, gpointer user_data)
{
  general_setting.im_enabled = gtk_toggle_button_get_active (togglebutton);
}

gboolean setget_get_on_CDE ();
void general_status_place_changed (GtkComboBox *combobox, gpointer user_data)
{
  general_setting.status_placement = gtk_combo_box_get_active (combobox);
  general_setting.status_enabled =
    (general_setting.status_placement == S_NONE) ? FALSE : TRUE;
  
  switch (general_setting.status_placement)
    {
    case S_DESKTOP_DEFAULT:
      general_setting.switcher_autostart = setget_get_on_CDE () ? FALSE : TRUE;
      break;
    case S_PANEL:
      general_setting.switcher_autostart = TRUE;
      break;
    default:
      general_setting.switcher_autostart = FALSE;
      break;
    }
}

void general_sync_activation_toggled (GtkToggleButton *togglebutton, gpointer user_data)
{
  general_setting.sync_activation = gtk_toggle_button_get_active (togglebutton);
}

void general_lang_per_ic_or_desktop_button_toggled (GtkToggleButton *togglebutton,
						 gpointer user_data)
{
  general_setting.lang_switch_policy =
    gtk_toggle_button_get_active (togglebutton) ? LS_DESKTOP : LS_IC;
}

void general_im_activate_policy_button_toggled (GtkToggleButton *togglebutton,
					     gpointer user_data)
{
  general_setting.on_off_policy =
    gtk_toggle_button_get_active (togglebutton) ? OO_ACTIVATE : OO_DONOT_CHANGE;
}

void general_remember_last_le_button_toggled (GtkToggleButton *togglebutton,
					      gpointer user_data)
{
  general_setting.remember_last_le = gtk_toggle_button_get_active (togglebutton);
}
