/* GNOME INPUT METHOD SWITCHER
 * Copyright 2003 Sun Microsystems Inc.
 *
 * This is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <config.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gconf/gconf-client.h>
#include <assert.h>
#include "gimlet.h"

static GConfClient *default_client = NULL;

void
panel_save_position (int x, int y)
{
  gconf_client_set_int (default_client, 
                        KEY_PANEL_SAVED_POSITION_X, x, NULL);
  gconf_client_set_int (default_client,
                        KEY_PANEL_SAVED_POSITION_Y, y, NULL);
}

void
panel_get_saved_position (int *px, int *py)
{
  assert (px && py);
  *px = gconf_client_get_int (default_client,
                             KEY_PANEL_SAVED_POSITION_X, NULL);
  *py = gconf_client_get_int (default_client,
                             KEY_PANEL_SAVED_POSITION_Y, NULL);
}

static void
init_iiim_settings (GimletWindow *gimlet)
{
  gchar *str;

  str = NULL;
  str = gconf_client_get_string (default_client,
				 KEY_ENABLE_IM, NULL);
  if (str && strcmp (str, "False") == 0)
    gimlet->im_enabled = FALSE;
  else
    gimlet->im_enabled = TRUE;
  g_free (str);

  str = NULL;
  str = gconf_client_get_string (default_client,
				 KEY_ENABLE_STATUS, NULL);
  if (str && strcmp (str, "False") == 0)
    gimlet->status_enabled = FALSE;
  else
    gimlet->status_enabled = TRUE;
  g_free (str);

  str = NULL;
  str = gconf_client_get_string (default_client,
				 KEY_STATUS_PLACEMENT, NULL);
  gimlet->status_placement = status_placement_num_id (str);

  g_free (str);
}

static void
iiim_setting_changed (GConfClient  *client,
		    guint         cnxn_id,
		    GConfEntry   *entry,
		    GimletWindow *gimlet)
{
  gchar *str = NULL;

  if (!entry->value)
    return;

  if (strcmp (entry->key, KEY_ENABLE_IM) == 0)
    {
      str = g_strdup (gconf_value_get_string (entry->value));
      if (strcmp (str, "False") == 0)
	gimlet->im_enabled = FALSE;
      else
	gimlet->im_enabled = TRUE;
    }
  else if (strcmp (entry->key, KEY_ENABLE_STATUS) == 0)
    {
      str = g_strdup (gconf_value_get_string (entry->value));
      if (strcmp (str, "False") == 0)
	gimlet->status_enabled = FALSE;
      else
	gimlet->status_enabled = TRUE;
    }
  else if (strcmp (entry->key, KEY_STATUS_PLACEMENT) == 0)
    {
      str = g_strdup (gconf_value_get_string (entry->value));
      gimlet->status_placement = status_placement_num_id (str);
    }
  else if (strcmp (entry->key, KEY_LANG_TO_USE_LIST) == 0)
    {
      gimlet->le_list_changed = TRUE;
    }

  g_free (str);

  if (gimlet->status_placement != ON_DESKTOP_PANEL)
    gtk_main_quit ();
 
  gimlet_update_lang (gimlet);
  gimlet_status_show_or_hide (gimlet);
}

void
gimlet_settings_init (GimletWindow *gimlet)
{
  if (default_client == NULL)
    {
      default_client = gconf_client_get_default ();
      g_object_ref (G_OBJECT (default_client));
    }

  /* input method settings */
  init_iiim_settings (gimlet);
  gconf_client_add_dir (default_client, IIIM_KEY_DIR,
			GCONF_CLIENT_PRELOAD_ONELEVEL, NULL);

  gconf_client_notify_add (default_client, KEY_ENABLE_IM,
			   (GConfClientNotifyFunc)iiim_setting_changed,
			   gimlet, NULL, NULL);
  gconf_client_notify_add (default_client, KEY_ENABLE_STATUS,
			   (GConfClientNotifyFunc)iiim_setting_changed,
			   gimlet, NULL, NULL);
  gconf_client_notify_add (default_client, KEY_STATUS_PLACEMENT,
			   (GConfClientNotifyFunc)iiim_setting_changed,
			   gimlet, NULL, NULL);
  gconf_client_notify_add (default_client, KEY_LANG_TO_USE_LIST,
                           (GConfClientNotifyFunc)iiim_setting_changed,
                           gimlet, NULL, NULL);
}
