#include <config.h>
#include <gnome.h>
#include "gimlet.h"

GimletWindow *gimlet;

int main (int argc, char **argv)
{
#ifdef ENABLE_NLS
  bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
  textdomain (GETTEXT_PACKAGE);
#endif

  gnome_program_init (PACKAGE, VERSION, LIBGNOMEUI_MODULE,
		      argc, argv,
		      GNOME_PARAM_APP_DATADIR, PACKAGE_DATA_DIR,
		      NULL);

  sm_disable_on_gnome ();

  if (is_panel_running ()) {
    fprintf (stderr, "iiim-panel is already running!\n");
    exit (1);
  }

  ignore_child_signal();
  start_iiimx_settings_init ();

  gimlet = g_new0 (GimletWindow, 1);

  gimlet_settings_init (gimlet);
  gimlet_create_panel (gimlet);

  gtk_main ();

  return 0;
}
